/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getPublished published}</li>
 * <li>{@link #getDeveloper developer}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getTagline tagline}</li>
 * <li>{@link #getVideoUrl videoUrl}</li>
 * <li>{@link #getActivationUrl activationUrl}</li>
 * <li>{@link #getSiteUrl siteUrl}</li>
 * <li>{@link #getDefaultResponseType defaultResponseType}</li>
 * <li>{@link #getAppDomain appDomain}</li>
 * <li>{@link #getAndroidVersion androidVersion}</li>
 * <li>{@link #getPackageName packageName}</li>
 * <li>{@link #getApproved approved}</li>
 * <li>{@link #getSystemApp systemApp}</li>
 * <li>{@link #getHidden hidden}</li>
 * <li>{@link #getFilenameIcon filenameIcon}</li>
 * <li>{@link #getFilenameIconSmall filenameIconSmall}</li>
 * <li>{@link #getFilenameIconLarge filenameIconLarge}</li>
 * <li>{@link #getInstallCount installCount}</li>
 * <li>{@link #getSortOrder sortOrder}</li>
 * <li>{@link #getPermissionMerchantRead permissionMerchantRead}</li>
 * <li>{@link #getPermissionMerchantWrite permissionMerchantWrite}</li>
 * <li>{@link #getPermissionCustomersRead permissionCustomersRead}</li>
 * <li>{@link #getPermissionCustomersWrite permissionCustomersWrite}</li>
 * <li>{@link #getPermissionInventoryRead permissionInventoryRead}</li>
 * <li>{@link #getPermissionInventoryWrite permissionInventoryWrite}</li>
 * <li>{@link #getPermissionOrdersRead permissionOrdersRead}</li>
 * <li>{@link #getPermissionOrdersWrite permissionOrdersWrite}</li>
 * <li>{@link #getPermissionPaymentsRead permissionPaymentsRead}</li>
 * <li>{@link #getPermissionPaymentsWrite permissionPaymentsWrite}</li>
 * <li>{@link #getPermissionEmployeesRead permissionEmployeesRead}</li>
 * <li>{@link #getPermissionEmployeesWrite permissionEmployeesWrite}</li>
 * <li>{@link #getPermissionProcessCards permissionProcessCards}</li>
 * <li>{@link #getPermissionMidRead permissionMidRead}</li>
 * <li>{@link #getPrivacyPolicy privacyPolicy}</li>
 * <li>{@link #getEula eula}</li>
 * <li>{@link #getSupportPhone supportPhone}</li>
 * <li>{@link #getSupportPhoneHours supportPhoneHours}</li>
 * <li>{@link #getSupportEmail supportEmail}</li>
 * <li>{@link #getSupportUrl supportUrl}</li>
 * <li>{@link #getProductType productType}</li>
 * <li>{@link #getApprovalStatus approvalStatus}</li>
 * <li>{@link #getAndroidPermissions androidPermissions}</li>
 * <li>{@link #getScreenshots screenshots}</li>
 * <li>{@link #getAvailableSubscriptions availableSubscriptions}</li>
 * <li>{@link #getSubscriptions subscriptions}</li>
 * <li>{@link #getAvailableMetereds availableMetereds}</li>
 * <li>{@link #getMetereds metereds}</li>
 * <li>{@link #getUsbDevices usbDevices}</li>
 * <li>{@link #getIsMerchantInTrial isMerchantInTrial}</li>
 * <li>{@link #getCurrentSubscription currentSubscription}</li>
 * <li>{@link #getWebhook webhook}</li>
 * <li>{@link #getAndroidVersions androidVersions}</li>
 * <li>{@link #getInstalled installed}</li>
 * <li>{@link #getInstalledTime installedTime}</li>
 * <li>{@link #getPaidAppHasTrial paidAppHasTrial}</li>
 * <li>{@link #getApprovalStatusModifiedTime approvalStatusModifiedTime}</li>
 * <li>{@link #getSmartReceiptText smartReceiptText}</li>
 * <li>{@link #getSmartReceiptUrl smartReceiptUrl}</li>
 * <li>{@link #getBillingStartTime billingStartTime}</li>
 * <li>{@link #getAppSecret appSecret}</li>
 * <li>{@link #getBusinessTypes businessTypes}</li>
 * <li>{@link #getDeviceTypes deviceTypes}</li>
 * <li>{@link #getModules modules}</li>
 * <li>{@link #getTaxClassificationCode taxClassificationCode}</li>
 * <li>{@link #getApplicationId applicationId}</li>
 * <li>{@link #getNonCloverBilling nonCloverBilling}</li>
 * <li>{@link #getEquipmentCode equipmentCode}</li>
 * <li>{@link #getEquipmentName equipmentName}</li>
 * <li>{@link #getFirstPublishedTime firstPublishedTime}</li>
 * <li>{@link #getFirstApprovalTime firstApprovalTime}</li>
 * <li>{@link #getAppBundle appBundle}</li>
 * <li>{@link #getEditorPick editorPick}</li>
 * <li>{@link #getPopularity popularity}</li>
 * <li>{@link #getAllowUninstall allowUninstall}</li>
 * <li>{@link #getCharge charge}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class App extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the app
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.Boolean getPublished() {
    return genClient.cacheGet(CacheKey.published);
  }

  public com.clover.sdk.v3.developer.Developer getDeveloper() {
    return genClient.cacheGet(CacheKey.developer);
  }

  /**
   * Only available when app is installed to a merchant
   */
  public com.clover.sdk.v3.merchant.Merchant getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * App Description
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  /**
   * Short tagline for the app
   */
  public java.lang.String getTagline() {
    return genClient.cacheGet(CacheKey.tagline);
  }

  /**
   * URL for embedded video
   */
  public java.lang.String getVideoUrl() {
    return genClient.cacheGet(CacheKey.videoUrl);
  }

  /**
   * Activation url for redirecting users after app installation.
   */
  public java.lang.String getActivationUrl() {
    return genClient.cacheGet(CacheKey.activationUrl);
  }

  /**
   * Site url for oauth redirect and web app launch from appmarket.
   */
  public java.lang.String getSiteUrl() {
    return genClient.cacheGet(CacheKey.siteUrl);
  }

  /**
   * Default oauth response type.
   */
  public com.clover.sdk.v3.apps.OAuthResponseType getDefaultResponseType() {
    return genClient.cacheGet(CacheKey.defaultResponseType);
  }

  public java.lang.String getAppDomain() {
    return genClient.cacheGet(CacheKey.appDomain);
  }

  public com.clover.sdk.v3.apps.AndroidVersion getAndroidVersion() {
    return genClient.cacheGet(CacheKey.androidVersion);
  }

  public java.lang.String getPackageName() {
    return genClient.cacheGet(CacheKey.packageName);
  }

  public java.lang.Boolean getApproved() {
    return genClient.cacheGet(CacheKey.approved);
  }

  public java.lang.Boolean getSystemApp() {
    return genClient.cacheGet(CacheKey.systemApp);
  }

  public java.lang.Boolean getHidden() {
    return genClient.cacheGet(CacheKey.hidden);
  }

  public java.lang.String getFilenameIcon() {
    return genClient.cacheGet(CacheKey.filenameIcon);
  }

  /**
   * URL to the icon of the app. Generated from filenameIcon.
   */
  public java.lang.String getFilenameIconSmall() {
    return genClient.cacheGet(CacheKey.filenameIconSmall);
  }

  /**
   * URL to the icon of the app. Generated from filenameIcon.
   */
  public java.lang.String getFilenameIconLarge() {
    return genClient.cacheGet(CacheKey.filenameIconLarge);
  }

  public java.lang.Long getInstallCount() {
    return genClient.cacheGet(CacheKey.installCount);
  }

  public java.lang.Long getSortOrder() {
    return genClient.cacheGet(CacheKey.sortOrder);
  }

  public java.lang.Boolean getPermissionMerchantRead() {
    return genClient.cacheGet(CacheKey.permissionMerchantRead);
  }

  public java.lang.Boolean getPermissionMerchantWrite() {
    return genClient.cacheGet(CacheKey.permissionMerchantWrite);
  }

  public java.lang.Boolean getPermissionCustomersRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersRead);
  }

  public java.lang.Boolean getPermissionCustomersWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersWrite);
  }

  public java.lang.Boolean getPermissionInventoryRead() {
    return genClient.cacheGet(CacheKey.permissionInventoryRead);
  }

  public java.lang.Boolean getPermissionInventoryWrite() {
    return genClient.cacheGet(CacheKey.permissionInventoryWrite);
  }

  public java.lang.Boolean getPermissionOrdersRead() {
    return genClient.cacheGet(CacheKey.permissionOrdersRead);
  }

  public java.lang.Boolean getPermissionOrdersWrite() {
    return genClient.cacheGet(CacheKey.permissionOrdersWrite);
  }

  public java.lang.Boolean getPermissionPaymentsRead() {
    return genClient.cacheGet(CacheKey.permissionPaymentsRead);
  }

  public java.lang.Boolean getPermissionPaymentsWrite() {
    return genClient.cacheGet(CacheKey.permissionPaymentsWrite);
  }

  public java.lang.Boolean getPermissionEmployeesRead() {
    return genClient.cacheGet(CacheKey.permissionEmployeesRead);
  }

  public java.lang.Boolean getPermissionEmployeesWrite() {
    return genClient.cacheGet(CacheKey.permissionEmployeesWrite);
  }

  public java.lang.Boolean getPermissionProcessCards() {
    return genClient.cacheGet(CacheKey.permissionProcessCards);
  }

  public java.lang.Boolean getPermissionMidRead() {
    return genClient.cacheGet(CacheKey.permissionMidRead);
  }

  public java.lang.String getPrivacyPolicy() {
    return genClient.cacheGet(CacheKey.privacyPolicy);
  }

  public java.lang.String getEula() {
    return genClient.cacheGet(CacheKey.eula);
  }

  public java.lang.String getSupportPhone() {
    return genClient.cacheGet(CacheKey.supportPhone);
  }

  public java.lang.String getSupportPhoneHours() {
    return genClient.cacheGet(CacheKey.supportPhoneHours);
  }

  public java.lang.String getSupportEmail() {
    return genClient.cacheGet(CacheKey.supportEmail);
  }

  public java.lang.String getSupportUrl() {
    return genClient.cacheGet(CacheKey.supportUrl);
  }

  public com.clover.sdk.v3.apps.ProductType getProductType() {
    return genClient.cacheGet(CacheKey.productType);
  }

  public com.clover.sdk.v3.base.ApprovalStatus getApprovalStatus() {
    return genClient.cacheGet(CacheKey.approvalStatus);
  }

  /**
   * The app's android permissions
   */
  public java.util.List<com.clover.sdk.v3.apps.AndroidPermission> getAndroidPermissions() {
    return genClient.cacheGet(CacheKey.androidPermissions);
  }

  /**
   * The app's screenshots
   */
  public java.util.List<com.clover.sdk.v3.apps.Screenshot> getScreenshots() {
    return genClient.cacheGet(CacheKey.screenshots);
  }

  /**
   * Available subscription options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppSubscription> getAvailableSubscriptions() {
    return genClient.cacheGet(CacheKey.availableSubscriptions);
  }

  /**
   * Subscription options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppSubscription> getSubscriptions() {
    return genClient.cacheGet(CacheKey.subscriptions);
  }

  /**
   * Available metered options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppMetered> getAvailableMetereds() {
    return genClient.cacheGet(CacheKey.availableMetereds);
  }

  /**
   * Metered options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppMetered> getMetereds() {
    return genClient.cacheGet(CacheKey.metereds);
  }

  /**
   * USB devices with which this app will communicate
   */
  public java.util.List<com.clover.sdk.v3.apps.AppUsbDevice> getUsbDevices() {
    return genClient.cacheGet(CacheKey.usbDevices);
  }

  /**
   * DEPRECATED: This is now derived directly from billingStartTime (if future -> in trial; if past -> not in trial).  So it is now unnecessary.  Please update client code to not use it.
   */
  public java.lang.Boolean getIsMerchantInTrial() {
    return genClient.cacheGet(CacheKey.isMerchantInTrial);
  }

  /**
   * The merchant's current subscription for this app
   */
  public com.clover.sdk.v3.apps.AppSubscription getCurrentSubscription() {
    return genClient.cacheGet(CacheKey.currentSubscription);
  }

  /**
   * The app's web hook
   */
  public com.clover.sdk.v3.apps.WebHook getWebhook() {
    return genClient.cacheGet(CacheKey.webhook);
  }

  /**
   * The app's uploaded apks
   */
  public java.util.List<com.clover.sdk.v3.apps.AndroidVersion> getAndroidVersions() {
    return genClient.cacheGet(CacheKey.androidVersions);
  }

  /**
   *  Whether the app is installed 
   */
  public java.lang.Boolean getInstalled() {
    return genClient.cacheGet(CacheKey.installed);
  }

  /**
   * If the merchant has the app installed, this is the timestamp of when they installed the app.
   */
  public java.lang.Long getInstalledTime() {
    return genClient.cacheGet(CacheKey.installedTime);
  }

  /**
   * If the app is a paid app, this tells whether it currently offers a 30 day free trial or not.  Developer can toggle at will.
   */
  public java.lang.Boolean getPaidAppHasTrial() {
    return genClient.cacheGet(CacheKey.paidAppHasTrial);
  }

  /**
   * Records the time that the approval status last changed
   */
  public java.lang.Long getApprovalStatusModifiedTime() {
    return genClient.cacheGet(CacheKey.approvalStatusModifiedTime);
  }

  /**
   * Text will print on printed receipts for this app
   */
  public java.lang.String getSmartReceiptText() {
    return genClient.cacheGet(CacheKey.smartReceiptText);
  }

  /**
   * URL we will expose on printed and web receipts for this app
   */
  public java.lang.String getSmartReceiptUrl() {
    return genClient.cacheGet(CacheKey.smartReceiptUrl);
  }

  /**
   * If the merchant has the app installed, this is the timestamp of when they start/started paying.  If the merchant doesn't have the app installed, this is the timestamp of when they would start paying.  In UTC.  Applies to paid apps only.
   */
  public java.lang.Long getBillingStartTime() {
    return genClient.cacheGet(CacheKey.billingStartTime);
  }

  /**
   * App's client secret for use with oauth
   */
  public java.lang.String getAppSecret() {
    return genClient.cacheGet(CacheKey.appSecret);
  }

  /**
   * App's associated business types
   */
  public java.util.List<com.clover.sdk.v3.apps.BusinessType> getBusinessTypes() {
    return genClient.cacheGet(CacheKey.businessTypes);
  }

  /**
   * App's supported device types
   */
  public java.util.List<com.clover.sdk.v3.apps.DeviceType> getDeviceTypes() {
    return genClient.cacheGet(CacheKey.deviceTypes);
  }

  public java.util.List<com.clover.sdk.v3.merchant.Module> getModules() {
    return genClient.cacheGet(CacheKey.modules);
  }

  public java.lang.String getTaxClassificationCode() {
    return genClient.cacheGet(CacheKey.taxClassificationCode);
  }

  /**
   * When set, this provides a friendly id that can be used to link an external application to this app.
   */
  public java.lang.String getApplicationId() {
    return genClient.cacheGet(CacheKey.applicationId);
  }

  /**
   * True if the app developer handles the billing for this app.
   */
  public java.lang.Boolean getNonCloverBilling() {
    return genClient.cacheGet(CacheKey.nonCloverBilling);
  }

  /**
   * Used to associate this developer/app combination with a specific equipment code in First Data back office systems
   */
  public java.lang.String getEquipmentCode() {
    return genClient.cacheGet(CacheKey.equipmentCode);
  }

  /**
   * Used to associate this developer/app combination with a specific equipment code in First Data back office systems
   */
  public java.lang.String getEquipmentName() {
    return genClient.cacheGet(CacheKey.equipmentName);
  }

  /**
   * Timestamp of first time this app transitions to approvalStatus PUBLISHED
   */
  public java.lang.Long getFirstPublishedTime() {
    return genClient.cacheGet(CacheKey.firstPublishedTime);
  }

  /**
   * Timestamp of first time this app transitions to approvalStatus APPROVED
   */
  public java.lang.Long getFirstApprovalTime() {
    return genClient.cacheGet(CacheKey.firstApprovalTime);
  }

  /**
   * Points to a bundle of apps that should be installed/uninstalled when user installs/uninstalls this app.
   */
  public com.clover.sdk.v3.base.Reference getAppBundle() {
    return genClient.cacheGet(CacheKey.appBundle);
  }

  /**
   * True if the App has been tagged as an editor's pick.
   */
  public java.lang.Boolean getEditorPick() {
    return genClient.cacheGet(CacheKey.editorPick);
  }

  /**
   * Number of installs by billable production merchants once this app is published.
   */
  public java.lang.Long getPopularity() {
    return genClient.cacheGet(CacheKey.popularity);
  }

  /**
   * Only applies to default apps of plan, if true allow merchant to uninstall app.
   */
  public java.lang.Boolean getAllowUninstall() {
    return genClient.cacheGet(CacheKey.allowUninstall);
  }

  /**
   * Only applies to default apps of plan, if true then charge for app.
   */
  public java.lang.Boolean getCharge() {
    return genClient.cacheGet(CacheKey.charge);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<App> {
    id {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    name {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    published {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("published", java.lang.Boolean.class);
      }
    },
    developer {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractRecord("developer", com.clover.sdk.v3.developer.Developer.JSON_CREATOR);
      }
    },
    merchant {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractRecord("merchant", com.clover.sdk.v3.merchant.Merchant.JSON_CREATOR);
      }
    },
    description {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("description", java.lang.String.class);
      }
    },
    tagline {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("tagline", java.lang.String.class);
      }
    },
    videoUrl {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("videoUrl", java.lang.String.class);
      }
    },
    activationUrl {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("activationUrl", java.lang.String.class);
      }
    },
    siteUrl {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("siteUrl", java.lang.String.class);
      }
    },
    defaultResponseType {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractEnum("defaultResponseType", com.clover.sdk.v3.apps.OAuthResponseType.class);
      }
    },
    appDomain {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("appDomain", java.lang.String.class);
      }
    },
    androidVersion {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractRecord("androidVersion", com.clover.sdk.v3.apps.AndroidVersion.JSON_CREATOR);
      }
    },
    packageName {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("packageName", java.lang.String.class);
      }
    },
    approved {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("approved", java.lang.Boolean.class);
      }
    },
    systemApp {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("systemApp", java.lang.Boolean.class);
      }
    },
    hidden {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("hidden", java.lang.Boolean.class);
      }
    },
    filenameIcon {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("filenameIcon", java.lang.String.class);
      }
    },
    filenameIconSmall {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("filenameIconSmall", java.lang.String.class);
      }
    },
    filenameIconLarge {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("filenameIconLarge", java.lang.String.class);
      }
    },
    installCount {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("installCount", java.lang.Long.class);
      }
    },
    sortOrder {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("sortOrder", java.lang.Long.class);
      }
    },
    permissionMerchantRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionMerchantRead", java.lang.Boolean.class);
      }
    },
    permissionMerchantWrite {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionMerchantWrite", java.lang.Boolean.class);
      }
    },
    permissionCustomersRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionCustomersRead", java.lang.Boolean.class);
      }
    },
    permissionCustomersWrite {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionCustomersWrite", java.lang.Boolean.class);
      }
    },
    permissionInventoryRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionInventoryRead", java.lang.Boolean.class);
      }
    },
    permissionInventoryWrite {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionInventoryWrite", java.lang.Boolean.class);
      }
    },
    permissionOrdersRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionOrdersRead", java.lang.Boolean.class);
      }
    },
    permissionOrdersWrite {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionOrdersWrite", java.lang.Boolean.class);
      }
    },
    permissionPaymentsRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionPaymentsRead", java.lang.Boolean.class);
      }
    },
    permissionPaymentsWrite {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionPaymentsWrite", java.lang.Boolean.class);
      }
    },
    permissionEmployeesRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionEmployeesRead", java.lang.Boolean.class);
      }
    },
    permissionEmployeesWrite {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionEmployeesWrite", java.lang.Boolean.class);
      }
    },
    permissionProcessCards {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionProcessCards", java.lang.Boolean.class);
      }
    },
    permissionMidRead {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("permissionMidRead", java.lang.Boolean.class);
      }
    },
    privacyPolicy {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("privacyPolicy", java.lang.String.class);
      }
    },
    eula {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("eula", java.lang.String.class);
      }
    },
    supportPhone {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("supportPhone", java.lang.String.class);
      }
    },
    supportPhoneHours {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("supportPhoneHours", java.lang.String.class);
      }
    },
    supportEmail {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("supportEmail", java.lang.String.class);
      }
    },
    supportUrl {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("supportUrl", java.lang.String.class);
      }
    },
    productType {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractEnum("productType", com.clover.sdk.v3.apps.ProductType.class);
      }
    },
    approvalStatus {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractEnum("approvalStatus", com.clover.sdk.v3.base.ApprovalStatus.class);
      }
    },
    androidPermissions {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("androidPermissions", com.clover.sdk.v3.apps.AndroidPermission.JSON_CREATOR);
      }
    },
    screenshots {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("screenshots", com.clover.sdk.v3.apps.Screenshot.JSON_CREATOR);
      }
    },
    availableSubscriptions {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("availableSubscriptions", com.clover.sdk.v3.apps.AppSubscription.JSON_CREATOR);
      }
    },
    subscriptions {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("subscriptions", com.clover.sdk.v3.apps.AppSubscription.JSON_CREATOR);
      }
    },
    availableMetereds {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("availableMetereds", com.clover.sdk.v3.apps.AppMetered.JSON_CREATOR);
      }
    },
    metereds {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("metereds", com.clover.sdk.v3.apps.AppMetered.JSON_CREATOR);
      }
    },
    usbDevices {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("usbDevices", com.clover.sdk.v3.apps.AppUsbDevice.JSON_CREATOR);
      }
    },
    isMerchantInTrial {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("isMerchantInTrial", java.lang.Boolean.class);
      }
    },
    currentSubscription {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractRecord("currentSubscription", com.clover.sdk.v3.apps.AppSubscription.JSON_CREATOR);
      }
    },
    webhook {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractRecord("webhook", com.clover.sdk.v3.apps.WebHook.JSON_CREATOR);
      }
    },
    androidVersions {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("androidVersions", com.clover.sdk.v3.apps.AndroidVersion.JSON_CREATOR);
      }
    },
    installed {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("installed", java.lang.Boolean.class);
      }
    },
    installedTime {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("installedTime", java.lang.Long.class);
      }
    },
    paidAppHasTrial {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("paidAppHasTrial", java.lang.Boolean.class);
      }
    },
    approvalStatusModifiedTime {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("approvalStatusModifiedTime", java.lang.Long.class);
      }
    },
    smartReceiptText {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("smartReceiptText", java.lang.String.class);
      }
    },
    smartReceiptUrl {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("smartReceiptUrl", java.lang.String.class);
      }
    },
    billingStartTime {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("billingStartTime", java.lang.Long.class);
      }
    },
    appSecret {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("appSecret", java.lang.String.class);
      }
    },
    businessTypes {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("businessTypes", com.clover.sdk.v3.apps.BusinessType.JSON_CREATOR);
      }
    },
    deviceTypes {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("deviceTypes", com.clover.sdk.v3.apps.DeviceType.JSON_CREATOR);
      }
    },
    modules {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractListRecord("modules", com.clover.sdk.v3.merchant.Module.JSON_CREATOR);
      }
    },
    taxClassificationCode {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("taxClassificationCode", java.lang.String.class);
      }
    },
    applicationId {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("applicationId", java.lang.String.class);
      }
    },
    nonCloverBilling {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("nonCloverBilling", java.lang.Boolean.class);
      }
    },
    equipmentCode {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("equipmentCode", java.lang.String.class);
      }
    },
    equipmentName {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("equipmentName", java.lang.String.class);
      }
    },
    firstPublishedTime {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("firstPublishedTime", java.lang.Long.class);
      }
    },
    firstApprovalTime {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("firstApprovalTime", java.lang.Long.class);
      }
    },
    appBundle {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractRecord("appBundle", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    editorPick {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("editorPick", java.lang.Boolean.class);
      }
    },
    popularity {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("popularity", java.lang.Long.class);
      }
    },
    allowUninstall {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("allowUninstall", java.lang.Boolean.class);
      }
    },
    charge {
      @Override
      public Object extractValue(App instance) {
        return instance.genClient.extractOther("charge", java.lang.Boolean.class);
      }
    },
      ;
  }

  private GenericClient<App> genClient;

  /**
  * Constructs a new empty instance.
  */
  public App() {
    genClient = new GenericClient<App>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected App(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public App(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public App(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public App(App src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateNull(getName(), "name");
    genClient.validateLength(getName(), 127);

    genClient.validateLength(getDescription(), 2000);

    genClient.validateLength(getTagline(), 255);

    genClient.validateLength(getVideoUrl(), 255);

    genClient.validateLength(getActivationUrl(), 255);

    genClient.validateLength(getSiteUrl(), 255);

    genClient.validateLength(getAppDomain(), 255);

    genClient.validateLength(getPackageName(), 255);

    genClient.validateLength(getFilenameIcon(), 100);

    genClient.validateLength(getFilenameIconSmall(), 255);

    genClient.validateLength(getFilenameIconLarge(), 255);

    genClient.validateLength(getPrivacyPolicy(), 255);

    genClient.validateLength(getEula(), 255);

    genClient.validateLength(getSupportPhone(), 25);

    genClient.validateLength(getSupportPhoneHours(), 127);

    genClient.validateLength(getSupportEmail(), 127);

    genClient.validateLength(getSupportUrl(), 255);

    genClient.validateLength(getSmartReceiptText(), 100);

    genClient.validateLength(getSmartReceiptUrl(), 255);

    genClient.validateLength(getAppSecret(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'published' field is set and is not null */
  public boolean isNotNullPublished() {
    return genClient.cacheValueIsNotNull(CacheKey.published);
  }

  /** Checks whether the 'developer' field is set and is not null */
  public boolean isNotNullDeveloper() {
    return genClient.cacheValueIsNotNull(CacheKey.developer);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'tagline' field is set and is not null */
  public boolean isNotNullTagline() {
    return genClient.cacheValueIsNotNull(CacheKey.tagline);
  }

  /** Checks whether the 'videoUrl' field is set and is not null */
  public boolean isNotNullVideoUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.videoUrl);
  }

  /** Checks whether the 'activationUrl' field is set and is not null */
  public boolean isNotNullActivationUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.activationUrl);
  }

  /** Checks whether the 'siteUrl' field is set and is not null */
  public boolean isNotNullSiteUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.siteUrl);
  }

  /** Checks whether the 'defaultResponseType' field is set and is not null */
  public boolean isNotNullDefaultResponseType() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultResponseType);
  }

  /** Checks whether the 'appDomain' field is set and is not null */
  public boolean isNotNullAppDomain() {
    return genClient.cacheValueIsNotNull(CacheKey.appDomain);
  }

  /** Checks whether the 'androidVersion' field is set and is not null */
  public boolean isNotNullAndroidVersion() {
    return genClient.cacheValueIsNotNull(CacheKey.androidVersion);
  }

  /** Checks whether the 'packageName' field is set and is not null */
  public boolean isNotNullPackageName() {
    return genClient.cacheValueIsNotNull(CacheKey.packageName);
  }

  /** Checks whether the 'approved' field is set and is not null */
  public boolean isNotNullApproved() {
    return genClient.cacheValueIsNotNull(CacheKey.approved);
  }

  /** Checks whether the 'systemApp' field is set and is not null */
  public boolean isNotNullSystemApp() {
    return genClient.cacheValueIsNotNull(CacheKey.systemApp);
  }

  /** Checks whether the 'hidden' field is set and is not null */
  public boolean isNotNullHidden() {
    return genClient.cacheValueIsNotNull(CacheKey.hidden);
  }

  /** Checks whether the 'filenameIcon' field is set and is not null */
  public boolean isNotNullFilenameIcon() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameIcon);
  }

  /** Checks whether the 'filenameIconSmall' field is set and is not null */
  public boolean isNotNullFilenameIconSmall() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameIconSmall);
  }

  /** Checks whether the 'filenameIconLarge' field is set and is not null */
  public boolean isNotNullFilenameIconLarge() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameIconLarge);
  }

  /** Checks whether the 'installCount' field is set and is not null */
  public boolean isNotNullInstallCount() {
    return genClient.cacheValueIsNotNull(CacheKey.installCount);
  }

  /** Checks whether the 'sortOrder' field is set and is not null */
  public boolean isNotNullSortOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.sortOrder);
  }

  /** Checks whether the 'permissionMerchantRead' field is set and is not null */
  public boolean isNotNullPermissionMerchantRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionMerchantRead);
  }

  /** Checks whether the 'permissionMerchantWrite' field is set and is not null */
  public boolean isNotNullPermissionMerchantWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionMerchantWrite);
  }

  /** Checks whether the 'permissionCustomersRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersRead);
  }

  /** Checks whether the 'permissionCustomersWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersWrite);
  }

  /** Checks whether the 'permissionInventoryRead' field is set and is not null */
  public boolean isNotNullPermissionInventoryRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionInventoryRead);
  }

  /** Checks whether the 'permissionInventoryWrite' field is set and is not null */
  public boolean isNotNullPermissionInventoryWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionInventoryWrite);
  }

  /** Checks whether the 'permissionOrdersRead' field is set and is not null */
  public boolean isNotNullPermissionOrdersRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionOrdersRead);
  }

  /** Checks whether the 'permissionOrdersWrite' field is set and is not null */
  public boolean isNotNullPermissionOrdersWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionOrdersWrite);
  }

  /** Checks whether the 'permissionPaymentsRead' field is set and is not null */
  public boolean isNotNullPermissionPaymentsRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionPaymentsRead);
  }

  /** Checks whether the 'permissionPaymentsWrite' field is set and is not null */
  public boolean isNotNullPermissionPaymentsWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionPaymentsWrite);
  }

  /** Checks whether the 'permissionEmployeesRead' field is set and is not null */
  public boolean isNotNullPermissionEmployeesRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionEmployeesRead);
  }

  /** Checks whether the 'permissionEmployeesWrite' field is set and is not null */
  public boolean isNotNullPermissionEmployeesWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionEmployeesWrite);
  }

  /** Checks whether the 'permissionProcessCards' field is set and is not null */
  public boolean isNotNullPermissionProcessCards() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionProcessCards);
  }

  /** Checks whether the 'permissionMidRead' field is set and is not null */
  public boolean isNotNullPermissionMidRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionMidRead);
  }

  /** Checks whether the 'privacyPolicy' field is set and is not null */
  public boolean isNotNullPrivacyPolicy() {
    return genClient.cacheValueIsNotNull(CacheKey.privacyPolicy);
  }

  /** Checks whether the 'eula' field is set and is not null */
  public boolean isNotNullEula() {
    return genClient.cacheValueIsNotNull(CacheKey.eula);
  }

  /** Checks whether the 'supportPhone' field is set and is not null */
  public boolean isNotNullSupportPhone() {
    return genClient.cacheValueIsNotNull(CacheKey.supportPhone);
  }

  /** Checks whether the 'supportPhoneHours' field is set and is not null */
  public boolean isNotNullSupportPhoneHours() {
    return genClient.cacheValueIsNotNull(CacheKey.supportPhoneHours);
  }

  /** Checks whether the 'supportEmail' field is set and is not null */
  public boolean isNotNullSupportEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.supportEmail);
  }

  /** Checks whether the 'supportUrl' field is set and is not null */
  public boolean isNotNullSupportUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.supportUrl);
  }

  /** Checks whether the 'productType' field is set and is not null */
  public boolean isNotNullProductType() {
    return genClient.cacheValueIsNotNull(CacheKey.productType);
  }

  /** Checks whether the 'approvalStatus' field is set and is not null */
  public boolean isNotNullApprovalStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.approvalStatus);
  }

  /** Checks whether the 'androidPermissions' field is set and is not null */
  public boolean isNotNullAndroidPermissions() {
    return genClient.cacheValueIsNotNull(CacheKey.androidPermissions);
  }

  /** Checks whether the 'androidPermissions' field is set and is not null and is not empty */
  public boolean isNotEmptyAndroidPermissions() { return isNotNullAndroidPermissions() && !getAndroidPermissions().isEmpty(); }

  /** Checks whether the 'screenshots' field is set and is not null */
  public boolean isNotNullScreenshots() {
    return genClient.cacheValueIsNotNull(CacheKey.screenshots);
  }

  /** Checks whether the 'screenshots' field is set and is not null and is not empty */
  public boolean isNotEmptyScreenshots() { return isNotNullScreenshots() && !getScreenshots().isEmpty(); }

  /** Checks whether the 'availableSubscriptions' field is set and is not null */
  public boolean isNotNullAvailableSubscriptions() {
    return genClient.cacheValueIsNotNull(CacheKey.availableSubscriptions);
  }

  /** Checks whether the 'availableSubscriptions' field is set and is not null and is not empty */
  public boolean isNotEmptyAvailableSubscriptions() { return isNotNullAvailableSubscriptions() && !getAvailableSubscriptions().isEmpty(); }

  /** Checks whether the 'subscriptions' field is set and is not null */
  public boolean isNotNullSubscriptions() {
    return genClient.cacheValueIsNotNull(CacheKey.subscriptions);
  }

  /** Checks whether the 'subscriptions' field is set and is not null and is not empty */
  public boolean isNotEmptySubscriptions() { return isNotNullSubscriptions() && !getSubscriptions().isEmpty(); }

  /** Checks whether the 'availableMetereds' field is set and is not null */
  public boolean isNotNullAvailableMetereds() {
    return genClient.cacheValueIsNotNull(CacheKey.availableMetereds);
  }

  /** Checks whether the 'availableMetereds' field is set and is not null and is not empty */
  public boolean isNotEmptyAvailableMetereds() { return isNotNullAvailableMetereds() && !getAvailableMetereds().isEmpty(); }

  /** Checks whether the 'metereds' field is set and is not null */
  public boolean isNotNullMetereds() {
    return genClient.cacheValueIsNotNull(CacheKey.metereds);
  }

  /** Checks whether the 'metereds' field is set and is not null and is not empty */
  public boolean isNotEmptyMetereds() { return isNotNullMetereds() && !getMetereds().isEmpty(); }

  /** Checks whether the 'usbDevices' field is set and is not null */
  public boolean isNotNullUsbDevices() {
    return genClient.cacheValueIsNotNull(CacheKey.usbDevices);
  }

  /** Checks whether the 'usbDevices' field is set and is not null and is not empty */
  public boolean isNotEmptyUsbDevices() { return isNotNullUsbDevices() && !getUsbDevices().isEmpty(); }

  /** Checks whether the 'isMerchantInTrial' field is set and is not null */
  public boolean isNotNullIsMerchantInTrial() {
    return genClient.cacheValueIsNotNull(CacheKey.isMerchantInTrial);
  }

  /** Checks whether the 'currentSubscription' field is set and is not null */
  public boolean isNotNullCurrentSubscription() {
    return genClient.cacheValueIsNotNull(CacheKey.currentSubscription);
  }

  /** Checks whether the 'webhook' field is set and is not null */
  public boolean isNotNullWebhook() {
    return genClient.cacheValueIsNotNull(CacheKey.webhook);
  }

  /** Checks whether the 'androidVersions' field is set and is not null */
  public boolean isNotNullAndroidVersions() {
    return genClient.cacheValueIsNotNull(CacheKey.androidVersions);
  }

  /** Checks whether the 'androidVersions' field is set and is not null and is not empty */
  public boolean isNotEmptyAndroidVersions() { return isNotNullAndroidVersions() && !getAndroidVersions().isEmpty(); }

  /** Checks whether the 'installed' field is set and is not null */
  public boolean isNotNullInstalled() {
    return genClient.cacheValueIsNotNull(CacheKey.installed);
  }

  /** Checks whether the 'installedTime' field is set and is not null */
  public boolean isNotNullInstalledTime() {
    return genClient.cacheValueIsNotNull(CacheKey.installedTime);
  }

  /** Checks whether the 'paidAppHasTrial' field is set and is not null */
  public boolean isNotNullPaidAppHasTrial() {
    return genClient.cacheValueIsNotNull(CacheKey.paidAppHasTrial);
  }

  /** Checks whether the 'approvalStatusModifiedTime' field is set and is not null */
  public boolean isNotNullApprovalStatusModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.approvalStatusModifiedTime);
  }

  /** Checks whether the 'smartReceiptText' field is set and is not null */
  public boolean isNotNullSmartReceiptText() {
    return genClient.cacheValueIsNotNull(CacheKey.smartReceiptText);
  }

  /** Checks whether the 'smartReceiptUrl' field is set and is not null */
  public boolean isNotNullSmartReceiptUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.smartReceiptUrl);
  }

  /** Checks whether the 'billingStartTime' field is set and is not null */
  public boolean isNotNullBillingStartTime() {
    return genClient.cacheValueIsNotNull(CacheKey.billingStartTime);
  }

  /** Checks whether the 'appSecret' field is set and is not null */
  public boolean isNotNullAppSecret() {
    return genClient.cacheValueIsNotNull(CacheKey.appSecret);
  }

  /** Checks whether the 'businessTypes' field is set and is not null */
  public boolean isNotNullBusinessTypes() {
    return genClient.cacheValueIsNotNull(CacheKey.businessTypes);
  }

  /** Checks whether the 'businessTypes' field is set and is not null and is not empty */
  public boolean isNotEmptyBusinessTypes() { return isNotNullBusinessTypes() && !getBusinessTypes().isEmpty(); }

  /** Checks whether the 'deviceTypes' field is set and is not null */
  public boolean isNotNullDeviceTypes() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceTypes);
  }

  /** Checks whether the 'deviceTypes' field is set and is not null and is not empty */
  public boolean isNotEmptyDeviceTypes() { return isNotNullDeviceTypes() && !getDeviceTypes().isEmpty(); }

  /** Checks whether the 'modules' field is set and is not null */
  public boolean isNotNullModules() {
    return genClient.cacheValueIsNotNull(CacheKey.modules);
  }

  /** Checks whether the 'modules' field is set and is not null and is not empty */
  public boolean isNotEmptyModules() { return isNotNullModules() && !getModules().isEmpty(); }

  /** Checks whether the 'taxClassificationCode' field is set and is not null */
  public boolean isNotNullTaxClassificationCode() {
    return genClient.cacheValueIsNotNull(CacheKey.taxClassificationCode);
  }

  /** Checks whether the 'applicationId' field is set and is not null */
  public boolean isNotNullApplicationId() {
    return genClient.cacheValueIsNotNull(CacheKey.applicationId);
  }

  /** Checks whether the 'nonCloverBilling' field is set and is not null */
  public boolean isNotNullNonCloverBilling() {
    return genClient.cacheValueIsNotNull(CacheKey.nonCloverBilling);
  }

  /** Checks whether the 'equipmentCode' field is set and is not null */
  public boolean isNotNullEquipmentCode() {
    return genClient.cacheValueIsNotNull(CacheKey.equipmentCode);
  }

  /** Checks whether the 'equipmentName' field is set and is not null */
  public boolean isNotNullEquipmentName() {
    return genClient.cacheValueIsNotNull(CacheKey.equipmentName);
  }

  /** Checks whether the 'firstPublishedTime' field is set and is not null */
  public boolean isNotNullFirstPublishedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstPublishedTime);
  }

  /** Checks whether the 'firstApprovalTime' field is set and is not null */
  public boolean isNotNullFirstApprovalTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstApprovalTime);
  }

  /** Checks whether the 'appBundle' field is set and is not null */
  public boolean isNotNullAppBundle() {
    return genClient.cacheValueIsNotNull(CacheKey.appBundle);
  }

  /** Checks whether the 'editorPick' field is set and is not null */
  public boolean isNotNullEditorPick() {
    return genClient.cacheValueIsNotNull(CacheKey.editorPick);
  }

  /** Checks whether the 'popularity' field is set and is not null */
  public boolean isNotNullPopularity() {
    return genClient.cacheValueIsNotNull(CacheKey.popularity);
  }

  /** Checks whether the 'allowUninstall' field is set and is not null */
  public boolean isNotNullAllowUninstall() {
    return genClient.cacheValueIsNotNull(CacheKey.allowUninstall);
  }

  /** Checks whether the 'charge' field is set and is not null */
  public boolean isNotNullCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.charge);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'published' field has been set, however the value could be null */
  public boolean hasPublished() {
    return genClient.cacheHasKey(CacheKey.published);
  }

  /** Checks whether the 'developer' field has been set, however the value could be null */
  public boolean hasDeveloper() {
    return genClient.cacheHasKey(CacheKey.developer);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'tagline' field has been set, however the value could be null */
  public boolean hasTagline() {
    return genClient.cacheHasKey(CacheKey.tagline);
  }

  /** Checks whether the 'videoUrl' field has been set, however the value could be null */
  public boolean hasVideoUrl() {
    return genClient.cacheHasKey(CacheKey.videoUrl);
  }

  /** Checks whether the 'activationUrl' field has been set, however the value could be null */
  public boolean hasActivationUrl() {
    return genClient.cacheHasKey(CacheKey.activationUrl);
  }

  /** Checks whether the 'siteUrl' field has been set, however the value could be null */
  public boolean hasSiteUrl() {
    return genClient.cacheHasKey(CacheKey.siteUrl);
  }

  /** Checks whether the 'defaultResponseType' field has been set, however the value could be null */
  public boolean hasDefaultResponseType() {
    return genClient.cacheHasKey(CacheKey.defaultResponseType);
  }

  /** Checks whether the 'appDomain' field has been set, however the value could be null */
  public boolean hasAppDomain() {
    return genClient.cacheHasKey(CacheKey.appDomain);
  }

  /** Checks whether the 'androidVersion' field has been set, however the value could be null */
  public boolean hasAndroidVersion() {
    return genClient.cacheHasKey(CacheKey.androidVersion);
  }

  /** Checks whether the 'packageName' field has been set, however the value could be null */
  public boolean hasPackageName() {
    return genClient.cacheHasKey(CacheKey.packageName);
  }

  /** Checks whether the 'approved' field has been set, however the value could be null */
  public boolean hasApproved() {
    return genClient.cacheHasKey(CacheKey.approved);
  }

  /** Checks whether the 'systemApp' field has been set, however the value could be null */
  public boolean hasSystemApp() {
    return genClient.cacheHasKey(CacheKey.systemApp);
  }

  /** Checks whether the 'hidden' field has been set, however the value could be null */
  public boolean hasHidden() {
    return genClient.cacheHasKey(CacheKey.hidden);
  }

  /** Checks whether the 'filenameIcon' field has been set, however the value could be null */
  public boolean hasFilenameIcon() {
    return genClient.cacheHasKey(CacheKey.filenameIcon);
  }

  /** Checks whether the 'filenameIconSmall' field has been set, however the value could be null */
  public boolean hasFilenameIconSmall() {
    return genClient.cacheHasKey(CacheKey.filenameIconSmall);
  }

  /** Checks whether the 'filenameIconLarge' field has been set, however the value could be null */
  public boolean hasFilenameIconLarge() {
    return genClient.cacheHasKey(CacheKey.filenameIconLarge);
  }

  /** Checks whether the 'installCount' field has been set, however the value could be null */
  public boolean hasInstallCount() {
    return genClient.cacheHasKey(CacheKey.installCount);
  }

  /** Checks whether the 'sortOrder' field has been set, however the value could be null */
  public boolean hasSortOrder() {
    return genClient.cacheHasKey(CacheKey.sortOrder);
  }

  /** Checks whether the 'permissionMerchantRead' field has been set, however the value could be null */
  public boolean hasPermissionMerchantRead() {
    return genClient.cacheHasKey(CacheKey.permissionMerchantRead);
  }

  /** Checks whether the 'permissionMerchantWrite' field has been set, however the value could be null */
  public boolean hasPermissionMerchantWrite() {
    return genClient.cacheHasKey(CacheKey.permissionMerchantWrite);
  }

  /** Checks whether the 'permissionCustomersRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersRead);
  }

  /** Checks whether the 'permissionCustomersWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersWrite);
  }

  /** Checks whether the 'permissionInventoryRead' field has been set, however the value could be null */
  public boolean hasPermissionInventoryRead() {
    return genClient.cacheHasKey(CacheKey.permissionInventoryRead);
  }

  /** Checks whether the 'permissionInventoryWrite' field has been set, however the value could be null */
  public boolean hasPermissionInventoryWrite() {
    return genClient.cacheHasKey(CacheKey.permissionInventoryWrite);
  }

  /** Checks whether the 'permissionOrdersRead' field has been set, however the value could be null */
  public boolean hasPermissionOrdersRead() {
    return genClient.cacheHasKey(CacheKey.permissionOrdersRead);
  }

  /** Checks whether the 'permissionOrdersWrite' field has been set, however the value could be null */
  public boolean hasPermissionOrdersWrite() {
    return genClient.cacheHasKey(CacheKey.permissionOrdersWrite);
  }

  /** Checks whether the 'permissionPaymentsRead' field has been set, however the value could be null */
  public boolean hasPermissionPaymentsRead() {
    return genClient.cacheHasKey(CacheKey.permissionPaymentsRead);
  }

  /** Checks whether the 'permissionPaymentsWrite' field has been set, however the value could be null */
  public boolean hasPermissionPaymentsWrite() {
    return genClient.cacheHasKey(CacheKey.permissionPaymentsWrite);
  }

  /** Checks whether the 'permissionEmployeesRead' field has been set, however the value could be null */
  public boolean hasPermissionEmployeesRead() {
    return genClient.cacheHasKey(CacheKey.permissionEmployeesRead);
  }

  /** Checks whether the 'permissionEmployeesWrite' field has been set, however the value could be null */
  public boolean hasPermissionEmployeesWrite() {
    return genClient.cacheHasKey(CacheKey.permissionEmployeesWrite);
  }

  /** Checks whether the 'permissionProcessCards' field has been set, however the value could be null */
  public boolean hasPermissionProcessCards() {
    return genClient.cacheHasKey(CacheKey.permissionProcessCards);
  }

  /** Checks whether the 'permissionMidRead' field has been set, however the value could be null */
  public boolean hasPermissionMidRead() {
    return genClient.cacheHasKey(CacheKey.permissionMidRead);
  }

  /** Checks whether the 'privacyPolicy' field has been set, however the value could be null */
  public boolean hasPrivacyPolicy() {
    return genClient.cacheHasKey(CacheKey.privacyPolicy);
  }

  /** Checks whether the 'eula' field has been set, however the value could be null */
  public boolean hasEula() {
    return genClient.cacheHasKey(CacheKey.eula);
  }

  /** Checks whether the 'supportPhone' field has been set, however the value could be null */
  public boolean hasSupportPhone() {
    return genClient.cacheHasKey(CacheKey.supportPhone);
  }

  /** Checks whether the 'supportPhoneHours' field has been set, however the value could be null */
  public boolean hasSupportPhoneHours() {
    return genClient.cacheHasKey(CacheKey.supportPhoneHours);
  }

  /** Checks whether the 'supportEmail' field has been set, however the value could be null */
  public boolean hasSupportEmail() {
    return genClient.cacheHasKey(CacheKey.supportEmail);
  }

  /** Checks whether the 'supportUrl' field has been set, however the value could be null */
  public boolean hasSupportUrl() {
    return genClient.cacheHasKey(CacheKey.supportUrl);
  }

  /** Checks whether the 'productType' field has been set, however the value could be null */
  public boolean hasProductType() {
    return genClient.cacheHasKey(CacheKey.productType);
  }

  /** Checks whether the 'approvalStatus' field has been set, however the value could be null */
  public boolean hasApprovalStatus() {
    return genClient.cacheHasKey(CacheKey.approvalStatus);
  }

  /** Checks whether the 'androidPermissions' field has been set, however the value could be null */
  public boolean hasAndroidPermissions() {
    return genClient.cacheHasKey(CacheKey.androidPermissions);
  }

  /** Checks whether the 'screenshots' field has been set, however the value could be null */
  public boolean hasScreenshots() {
    return genClient.cacheHasKey(CacheKey.screenshots);
  }

  /** Checks whether the 'availableSubscriptions' field has been set, however the value could be null */
  public boolean hasAvailableSubscriptions() {
    return genClient.cacheHasKey(CacheKey.availableSubscriptions);
  }

  /** Checks whether the 'subscriptions' field has been set, however the value could be null */
  public boolean hasSubscriptions() {
    return genClient.cacheHasKey(CacheKey.subscriptions);
  }

  /** Checks whether the 'availableMetereds' field has been set, however the value could be null */
  public boolean hasAvailableMetereds() {
    return genClient.cacheHasKey(CacheKey.availableMetereds);
  }

  /** Checks whether the 'metereds' field has been set, however the value could be null */
  public boolean hasMetereds() {
    return genClient.cacheHasKey(CacheKey.metereds);
  }

  /** Checks whether the 'usbDevices' field has been set, however the value could be null */
  public boolean hasUsbDevices() {
    return genClient.cacheHasKey(CacheKey.usbDevices);
  }

  /** Checks whether the 'isMerchantInTrial' field has been set, however the value could be null */
  public boolean hasIsMerchantInTrial() {
    return genClient.cacheHasKey(CacheKey.isMerchantInTrial);
  }

  /** Checks whether the 'currentSubscription' field has been set, however the value could be null */
  public boolean hasCurrentSubscription() {
    return genClient.cacheHasKey(CacheKey.currentSubscription);
  }

  /** Checks whether the 'webhook' field has been set, however the value could be null */
  public boolean hasWebhook() {
    return genClient.cacheHasKey(CacheKey.webhook);
  }

  /** Checks whether the 'androidVersions' field has been set, however the value could be null */
  public boolean hasAndroidVersions() {
    return genClient.cacheHasKey(CacheKey.androidVersions);
  }

  /** Checks whether the 'installed' field has been set, however the value could be null */
  public boolean hasInstalled() {
    return genClient.cacheHasKey(CacheKey.installed);
  }

  /** Checks whether the 'installedTime' field has been set, however the value could be null */
  public boolean hasInstalledTime() {
    return genClient.cacheHasKey(CacheKey.installedTime);
  }

  /** Checks whether the 'paidAppHasTrial' field has been set, however the value could be null */
  public boolean hasPaidAppHasTrial() {
    return genClient.cacheHasKey(CacheKey.paidAppHasTrial);
  }

  /** Checks whether the 'approvalStatusModifiedTime' field has been set, however the value could be null */
  public boolean hasApprovalStatusModifiedTime() {
    return genClient.cacheHasKey(CacheKey.approvalStatusModifiedTime);
  }

  /** Checks whether the 'smartReceiptText' field has been set, however the value could be null */
  public boolean hasSmartReceiptText() {
    return genClient.cacheHasKey(CacheKey.smartReceiptText);
  }

  /** Checks whether the 'smartReceiptUrl' field has been set, however the value could be null */
  public boolean hasSmartReceiptUrl() {
    return genClient.cacheHasKey(CacheKey.smartReceiptUrl);
  }

  /** Checks whether the 'billingStartTime' field has been set, however the value could be null */
  public boolean hasBillingStartTime() {
    return genClient.cacheHasKey(CacheKey.billingStartTime);
  }

  /** Checks whether the 'appSecret' field has been set, however the value could be null */
  public boolean hasAppSecret() {
    return genClient.cacheHasKey(CacheKey.appSecret);
  }

  /** Checks whether the 'businessTypes' field has been set, however the value could be null */
  public boolean hasBusinessTypes() {
    return genClient.cacheHasKey(CacheKey.businessTypes);
  }

  /** Checks whether the 'deviceTypes' field has been set, however the value could be null */
  public boolean hasDeviceTypes() {
    return genClient.cacheHasKey(CacheKey.deviceTypes);
  }

  /** Checks whether the 'modules' field has been set, however the value could be null */
  public boolean hasModules() {
    return genClient.cacheHasKey(CacheKey.modules);
  }

  /** Checks whether the 'taxClassificationCode' field has been set, however the value could be null */
  public boolean hasTaxClassificationCode() {
    return genClient.cacheHasKey(CacheKey.taxClassificationCode);
  }

  /** Checks whether the 'applicationId' field has been set, however the value could be null */
  public boolean hasApplicationId() {
    return genClient.cacheHasKey(CacheKey.applicationId);
  }

  /** Checks whether the 'nonCloverBilling' field has been set, however the value could be null */
  public boolean hasNonCloverBilling() {
    return genClient.cacheHasKey(CacheKey.nonCloverBilling);
  }

  /** Checks whether the 'equipmentCode' field has been set, however the value could be null */
  public boolean hasEquipmentCode() {
    return genClient.cacheHasKey(CacheKey.equipmentCode);
  }

  /** Checks whether the 'equipmentName' field has been set, however the value could be null */
  public boolean hasEquipmentName() {
    return genClient.cacheHasKey(CacheKey.equipmentName);
  }

  /** Checks whether the 'firstPublishedTime' field has been set, however the value could be null */
  public boolean hasFirstPublishedTime() {
    return genClient.cacheHasKey(CacheKey.firstPublishedTime);
  }

  /** Checks whether the 'firstApprovalTime' field has been set, however the value could be null */
  public boolean hasFirstApprovalTime() {
    return genClient.cacheHasKey(CacheKey.firstApprovalTime);
  }

  /** Checks whether the 'appBundle' field has been set, however the value could be null */
  public boolean hasAppBundle() {
    return genClient.cacheHasKey(CacheKey.appBundle);
  }

  /** Checks whether the 'editorPick' field has been set, however the value could be null */
  public boolean hasEditorPick() {
    return genClient.cacheHasKey(CacheKey.editorPick);
  }

  /** Checks whether the 'popularity' field has been set, however the value could be null */
  public boolean hasPopularity() {
    return genClient.cacheHasKey(CacheKey.popularity);
  }

  /** Checks whether the 'allowUninstall' field has been set, however the value could be null */
  public boolean hasAllowUninstall() {
    return genClient.cacheHasKey(CacheKey.allowUninstall);
  }

  /** Checks whether the 'charge' field has been set, however the value could be null */
  public boolean hasCharge() {
    return genClient.cacheHasKey(CacheKey.charge);
  }


  /**
   * Sets the field 'id'.
   */
  public App setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public App setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'published'.
   */
  public App setPublished(java.lang.Boolean published) {
    return genClient.setOther(published, CacheKey.published);
  }

  /**
   * Sets the field 'developer'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setDeveloper(com.clover.sdk.v3.developer.Developer developer) {
    return genClient.setRecord(developer, CacheKey.developer);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setMerchant(com.clover.sdk.v3.merchant.Merchant merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'description'.
   */
  public App setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'tagline'.
   */
  public App setTagline(java.lang.String tagline) {
    return genClient.setOther(tagline, CacheKey.tagline);
  }

  /**
   * Sets the field 'videoUrl'.
   */
  public App setVideoUrl(java.lang.String videoUrl) {
    return genClient.setOther(videoUrl, CacheKey.videoUrl);
  }

  /**
   * Sets the field 'activationUrl'.
   */
  public App setActivationUrl(java.lang.String activationUrl) {
    return genClient.setOther(activationUrl, CacheKey.activationUrl);
  }

  /**
   * Sets the field 'siteUrl'.
   */
  public App setSiteUrl(java.lang.String siteUrl) {
    return genClient.setOther(siteUrl, CacheKey.siteUrl);
  }

  /**
   * Sets the field 'defaultResponseType'.
   */
  public App setDefaultResponseType(com.clover.sdk.v3.apps.OAuthResponseType defaultResponseType) {
    return genClient.setOther(defaultResponseType, CacheKey.defaultResponseType);
  }

  /**
   * Sets the field 'appDomain'.
   */
  public App setAppDomain(java.lang.String appDomain) {
    return genClient.setOther(appDomain, CacheKey.appDomain);
  }

  /**
   * Sets the field 'androidVersion'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setAndroidVersion(com.clover.sdk.v3.apps.AndroidVersion androidVersion) {
    return genClient.setRecord(androidVersion, CacheKey.androidVersion);
  }

  /**
   * Sets the field 'packageName'.
   */
  public App setPackageName(java.lang.String packageName) {
    return genClient.setOther(packageName, CacheKey.packageName);
  }

  /**
   * Sets the field 'approved'.
   */
  public App setApproved(java.lang.Boolean approved) {
    return genClient.setOther(approved, CacheKey.approved);
  }

  /**
   * Sets the field 'systemApp'.
   */
  public App setSystemApp(java.lang.Boolean systemApp) {
    return genClient.setOther(systemApp, CacheKey.systemApp);
  }

  /**
   * Sets the field 'hidden'.
   */
  public App setHidden(java.lang.Boolean hidden) {
    return genClient.setOther(hidden, CacheKey.hidden);
  }

  /**
   * Sets the field 'filenameIcon'.
   */
  public App setFilenameIcon(java.lang.String filenameIcon) {
    return genClient.setOther(filenameIcon, CacheKey.filenameIcon);
  }

  /**
   * Sets the field 'filenameIconSmall'.
   */
  public App setFilenameIconSmall(java.lang.String filenameIconSmall) {
    return genClient.setOther(filenameIconSmall, CacheKey.filenameIconSmall);
  }

  /**
   * Sets the field 'filenameIconLarge'.
   */
  public App setFilenameIconLarge(java.lang.String filenameIconLarge) {
    return genClient.setOther(filenameIconLarge, CacheKey.filenameIconLarge);
  }

  /**
   * Sets the field 'installCount'.
   */
  public App setInstallCount(java.lang.Long installCount) {
    return genClient.setOther(installCount, CacheKey.installCount);
  }

  /**
   * Sets the field 'sortOrder'.
   */
  public App setSortOrder(java.lang.Long sortOrder) {
    return genClient.setOther(sortOrder, CacheKey.sortOrder);
  }

  /**
   * Sets the field 'permissionMerchantRead'.
   */
  public App setPermissionMerchantRead(java.lang.Boolean permissionMerchantRead) {
    return genClient.setOther(permissionMerchantRead, CacheKey.permissionMerchantRead);
  }

  /**
   * Sets the field 'permissionMerchantWrite'.
   */
  public App setPermissionMerchantWrite(java.lang.Boolean permissionMerchantWrite) {
    return genClient.setOther(permissionMerchantWrite, CacheKey.permissionMerchantWrite);
  }

  /**
   * Sets the field 'permissionCustomersRead'.
   */
  public App setPermissionCustomersRead(java.lang.Boolean permissionCustomersRead) {
    return genClient.setOther(permissionCustomersRead, CacheKey.permissionCustomersRead);
  }

  /**
   * Sets the field 'permissionCustomersWrite'.
   */
  public App setPermissionCustomersWrite(java.lang.Boolean permissionCustomersWrite) {
    return genClient.setOther(permissionCustomersWrite, CacheKey.permissionCustomersWrite);
  }

  /**
   * Sets the field 'permissionInventoryRead'.
   */
  public App setPermissionInventoryRead(java.lang.Boolean permissionInventoryRead) {
    return genClient.setOther(permissionInventoryRead, CacheKey.permissionInventoryRead);
  }

  /**
   * Sets the field 'permissionInventoryWrite'.
   */
  public App setPermissionInventoryWrite(java.lang.Boolean permissionInventoryWrite) {
    return genClient.setOther(permissionInventoryWrite, CacheKey.permissionInventoryWrite);
  }

  /**
   * Sets the field 'permissionOrdersRead'.
   */
  public App setPermissionOrdersRead(java.lang.Boolean permissionOrdersRead) {
    return genClient.setOther(permissionOrdersRead, CacheKey.permissionOrdersRead);
  }

  /**
   * Sets the field 'permissionOrdersWrite'.
   */
  public App setPermissionOrdersWrite(java.lang.Boolean permissionOrdersWrite) {
    return genClient.setOther(permissionOrdersWrite, CacheKey.permissionOrdersWrite);
  }

  /**
   * Sets the field 'permissionPaymentsRead'.
   */
  public App setPermissionPaymentsRead(java.lang.Boolean permissionPaymentsRead) {
    return genClient.setOther(permissionPaymentsRead, CacheKey.permissionPaymentsRead);
  }

  /**
   * Sets the field 'permissionPaymentsWrite'.
   */
  public App setPermissionPaymentsWrite(java.lang.Boolean permissionPaymentsWrite) {
    return genClient.setOther(permissionPaymentsWrite, CacheKey.permissionPaymentsWrite);
  }

  /**
   * Sets the field 'permissionEmployeesRead'.
   */
  public App setPermissionEmployeesRead(java.lang.Boolean permissionEmployeesRead) {
    return genClient.setOther(permissionEmployeesRead, CacheKey.permissionEmployeesRead);
  }

  /**
   * Sets the field 'permissionEmployeesWrite'.
   */
  public App setPermissionEmployeesWrite(java.lang.Boolean permissionEmployeesWrite) {
    return genClient.setOther(permissionEmployeesWrite, CacheKey.permissionEmployeesWrite);
  }

  /**
   * Sets the field 'permissionProcessCards'.
   */
  public App setPermissionProcessCards(java.lang.Boolean permissionProcessCards) {
    return genClient.setOther(permissionProcessCards, CacheKey.permissionProcessCards);
  }

  /**
   * Sets the field 'permissionMidRead'.
   */
  public App setPermissionMidRead(java.lang.Boolean permissionMidRead) {
    return genClient.setOther(permissionMidRead, CacheKey.permissionMidRead);
  }

  /**
   * Sets the field 'privacyPolicy'.
   */
  public App setPrivacyPolicy(java.lang.String privacyPolicy) {
    return genClient.setOther(privacyPolicy, CacheKey.privacyPolicy);
  }

  /**
   * Sets the field 'eula'.
   */
  public App setEula(java.lang.String eula) {
    return genClient.setOther(eula, CacheKey.eula);
  }

  /**
   * Sets the field 'supportPhone'.
   */
  public App setSupportPhone(java.lang.String supportPhone) {
    return genClient.setOther(supportPhone, CacheKey.supportPhone);
  }

  /**
   * Sets the field 'supportPhoneHours'.
   */
  public App setSupportPhoneHours(java.lang.String supportPhoneHours) {
    return genClient.setOther(supportPhoneHours, CacheKey.supportPhoneHours);
  }

  /**
   * Sets the field 'supportEmail'.
   */
  public App setSupportEmail(java.lang.String supportEmail) {
    return genClient.setOther(supportEmail, CacheKey.supportEmail);
  }

  /**
   * Sets the field 'supportUrl'.
   */
  public App setSupportUrl(java.lang.String supportUrl) {
    return genClient.setOther(supportUrl, CacheKey.supportUrl);
  }

  /**
   * Sets the field 'productType'.
   */
  public App setProductType(com.clover.sdk.v3.apps.ProductType productType) {
    return genClient.setOther(productType, CacheKey.productType);
  }

  /**
   * Sets the field 'approvalStatus'.
   */
  public App setApprovalStatus(com.clover.sdk.v3.base.ApprovalStatus approvalStatus) {
    return genClient.setOther(approvalStatus, CacheKey.approvalStatus);
  }

  /**
   * Sets the field 'androidPermissions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAndroidPermissions(java.util.List<com.clover.sdk.v3.apps.AndroidPermission> androidPermissions) {
    return genClient.setArrayRecord(androidPermissions, CacheKey.androidPermissions);
  }

  /**
   * Sets the field 'screenshots'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setScreenshots(java.util.List<com.clover.sdk.v3.apps.Screenshot> screenshots) {
    return genClient.setArrayRecord(screenshots, CacheKey.screenshots);
  }

  /**
   * Sets the field 'availableSubscriptions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAvailableSubscriptions(java.util.List<com.clover.sdk.v3.apps.AppSubscription> availableSubscriptions) {
    return genClient.setArrayRecord(availableSubscriptions, CacheKey.availableSubscriptions);
  }

  /**
   * Sets the field 'subscriptions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setSubscriptions(java.util.List<com.clover.sdk.v3.apps.AppSubscription> subscriptions) {
    return genClient.setArrayRecord(subscriptions, CacheKey.subscriptions);
  }

  /**
   * Sets the field 'availableMetereds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAvailableMetereds(java.util.List<com.clover.sdk.v3.apps.AppMetered> availableMetereds) {
    return genClient.setArrayRecord(availableMetereds, CacheKey.availableMetereds);
  }

  /**
   * Sets the field 'metereds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setMetereds(java.util.List<com.clover.sdk.v3.apps.AppMetered> metereds) {
    return genClient.setArrayRecord(metereds, CacheKey.metereds);
  }

  /**
   * Sets the field 'usbDevices'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setUsbDevices(java.util.List<com.clover.sdk.v3.apps.AppUsbDevice> usbDevices) {
    return genClient.setArrayRecord(usbDevices, CacheKey.usbDevices);
  }

  /**
   * Sets the field 'isMerchantInTrial'.
   */
  public App setIsMerchantInTrial(java.lang.Boolean isMerchantInTrial) {
    return genClient.setOther(isMerchantInTrial, CacheKey.isMerchantInTrial);
  }

  /**
   * Sets the field 'currentSubscription'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setCurrentSubscription(com.clover.sdk.v3.apps.AppSubscription currentSubscription) {
    return genClient.setRecord(currentSubscription, CacheKey.currentSubscription);
  }

  /**
   * Sets the field 'webhook'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setWebhook(com.clover.sdk.v3.apps.WebHook webhook) {
    return genClient.setRecord(webhook, CacheKey.webhook);
  }

  /**
   * Sets the field 'androidVersions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAndroidVersions(java.util.List<com.clover.sdk.v3.apps.AndroidVersion> androidVersions) {
    return genClient.setArrayRecord(androidVersions, CacheKey.androidVersions);
  }

  /**
   * Sets the field 'installed'.
   */
  public App setInstalled(java.lang.Boolean installed) {
    return genClient.setOther(installed, CacheKey.installed);
  }

  /**
   * Sets the field 'installedTime'.
   */
  public App setInstalledTime(java.lang.Long installedTime) {
    return genClient.setOther(installedTime, CacheKey.installedTime);
  }

  /**
   * Sets the field 'paidAppHasTrial'.
   */
  public App setPaidAppHasTrial(java.lang.Boolean paidAppHasTrial) {
    return genClient.setOther(paidAppHasTrial, CacheKey.paidAppHasTrial);
  }

  /**
   * Sets the field 'approvalStatusModifiedTime'.
   */
  public App setApprovalStatusModifiedTime(java.lang.Long approvalStatusModifiedTime) {
    return genClient.setOther(approvalStatusModifiedTime, CacheKey.approvalStatusModifiedTime);
  }

  /**
   * Sets the field 'smartReceiptText'.
   */
  public App setSmartReceiptText(java.lang.String smartReceiptText) {
    return genClient.setOther(smartReceiptText, CacheKey.smartReceiptText);
  }

  /**
   * Sets the field 'smartReceiptUrl'.
   */
  public App setSmartReceiptUrl(java.lang.String smartReceiptUrl) {
    return genClient.setOther(smartReceiptUrl, CacheKey.smartReceiptUrl);
  }

  /**
   * Sets the field 'billingStartTime'.
   */
  public App setBillingStartTime(java.lang.Long billingStartTime) {
    return genClient.setOther(billingStartTime, CacheKey.billingStartTime);
  }

  /**
   * Sets the field 'appSecret'.
   */
  public App setAppSecret(java.lang.String appSecret) {
    return genClient.setOther(appSecret, CacheKey.appSecret);
  }

  /**
   * Sets the field 'businessTypes'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setBusinessTypes(java.util.List<com.clover.sdk.v3.apps.BusinessType> businessTypes) {
    return genClient.setArrayRecord(businessTypes, CacheKey.businessTypes);
  }

  /**
   * Sets the field 'deviceTypes'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setDeviceTypes(java.util.List<com.clover.sdk.v3.apps.DeviceType> deviceTypes) {
    return genClient.setArrayRecord(deviceTypes, CacheKey.deviceTypes);
  }

  /**
   * Sets the field 'modules'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setModules(java.util.List<com.clover.sdk.v3.merchant.Module> modules) {
    return genClient.setArrayRecord(modules, CacheKey.modules);
  }

  /**
   * Sets the field 'taxClassificationCode'.
   */
  public App setTaxClassificationCode(java.lang.String taxClassificationCode) {
    return genClient.setOther(taxClassificationCode, CacheKey.taxClassificationCode);
  }

  /**
   * Sets the field 'applicationId'.
   */
  public App setApplicationId(java.lang.String applicationId) {
    return genClient.setOther(applicationId, CacheKey.applicationId);
  }

  /**
   * Sets the field 'nonCloverBilling'.
   */
  public App setNonCloverBilling(java.lang.Boolean nonCloverBilling) {
    return genClient.setOther(nonCloverBilling, CacheKey.nonCloverBilling);
  }

  /**
   * Sets the field 'equipmentCode'.
   */
  public App setEquipmentCode(java.lang.String equipmentCode) {
    return genClient.setOther(equipmentCode, CacheKey.equipmentCode);
  }

  /**
   * Sets the field 'equipmentName'.
   */
  public App setEquipmentName(java.lang.String equipmentName) {
    return genClient.setOther(equipmentName, CacheKey.equipmentName);
  }

  /**
   * Sets the field 'firstPublishedTime'.
   */
  public App setFirstPublishedTime(java.lang.Long firstPublishedTime) {
    return genClient.setOther(firstPublishedTime, CacheKey.firstPublishedTime);
  }

  /**
   * Sets the field 'firstApprovalTime'.
   */
  public App setFirstApprovalTime(java.lang.Long firstApprovalTime) {
    return genClient.setOther(firstApprovalTime, CacheKey.firstApprovalTime);
  }

  /**
   * Sets the field 'appBundle'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setAppBundle(com.clover.sdk.v3.base.Reference appBundle) {
    return genClient.setRecord(appBundle, CacheKey.appBundle);
  }

  /**
   * Sets the field 'editorPick'.
   */
  public App setEditorPick(java.lang.Boolean editorPick) {
    return genClient.setOther(editorPick, CacheKey.editorPick);
  }

  /**
   * Sets the field 'popularity'.
   */
  public App setPopularity(java.lang.Long popularity) {
    return genClient.setOther(popularity, CacheKey.popularity);
  }

  /**
   * Sets the field 'allowUninstall'.
   */
  public App setAllowUninstall(java.lang.Boolean allowUninstall) {
    return genClient.setOther(allowUninstall, CacheKey.allowUninstall);
  }

  /**
   * Sets the field 'charge'.
   */
  public App setCharge(java.lang.Boolean charge) {
    return genClient.setOther(charge, CacheKey.charge);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'published' field, the 'has' method for this field will now return false */
  public void clearPublished() {
    genClient.clear(CacheKey.published);
  }
  /** Clears the 'developer' field, the 'has' method for this field will now return false */
  public void clearDeveloper() {
    genClient.clear(CacheKey.developer);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'tagline' field, the 'has' method for this field will now return false */
  public void clearTagline() {
    genClient.clear(CacheKey.tagline);
  }
  /** Clears the 'videoUrl' field, the 'has' method for this field will now return false */
  public void clearVideoUrl() {
    genClient.clear(CacheKey.videoUrl);
  }
  /** Clears the 'activationUrl' field, the 'has' method for this field will now return false */
  public void clearActivationUrl() {
    genClient.clear(CacheKey.activationUrl);
  }
  /** Clears the 'siteUrl' field, the 'has' method for this field will now return false */
  public void clearSiteUrl() {
    genClient.clear(CacheKey.siteUrl);
  }
  /** Clears the 'defaultResponseType' field, the 'has' method for this field will now return false */
  public void clearDefaultResponseType() {
    genClient.clear(CacheKey.defaultResponseType);
  }
  /** Clears the 'appDomain' field, the 'has' method for this field will now return false */
  public void clearAppDomain() {
    genClient.clear(CacheKey.appDomain);
  }
  /** Clears the 'androidVersion' field, the 'has' method for this field will now return false */
  public void clearAndroidVersion() {
    genClient.clear(CacheKey.androidVersion);
  }
  /** Clears the 'packageName' field, the 'has' method for this field will now return false */
  public void clearPackageName() {
    genClient.clear(CacheKey.packageName);
  }
  /** Clears the 'approved' field, the 'has' method for this field will now return false */
  public void clearApproved() {
    genClient.clear(CacheKey.approved);
  }
  /** Clears the 'systemApp' field, the 'has' method for this field will now return false */
  public void clearSystemApp() {
    genClient.clear(CacheKey.systemApp);
  }
  /** Clears the 'hidden' field, the 'has' method for this field will now return false */
  public void clearHidden() {
    genClient.clear(CacheKey.hidden);
  }
  /** Clears the 'filenameIcon' field, the 'has' method for this field will now return false */
  public void clearFilenameIcon() {
    genClient.clear(CacheKey.filenameIcon);
  }
  /** Clears the 'filenameIconSmall' field, the 'has' method for this field will now return false */
  public void clearFilenameIconSmall() {
    genClient.clear(CacheKey.filenameIconSmall);
  }
  /** Clears the 'filenameIconLarge' field, the 'has' method for this field will now return false */
  public void clearFilenameIconLarge() {
    genClient.clear(CacheKey.filenameIconLarge);
  }
  /** Clears the 'installCount' field, the 'has' method for this field will now return false */
  public void clearInstallCount() {
    genClient.clear(CacheKey.installCount);
  }
  /** Clears the 'sortOrder' field, the 'has' method for this field will now return false */
  public void clearSortOrder() {
    genClient.clear(CacheKey.sortOrder);
  }
  /** Clears the 'permissionMerchantRead' field, the 'has' method for this field will now return false */
  public void clearPermissionMerchantRead() {
    genClient.clear(CacheKey.permissionMerchantRead);
  }
  /** Clears the 'permissionMerchantWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionMerchantWrite() {
    genClient.clear(CacheKey.permissionMerchantWrite);
  }
  /** Clears the 'permissionCustomersRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersRead() {
    genClient.clear(CacheKey.permissionCustomersRead);
  }
  /** Clears the 'permissionCustomersWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersWrite() {
    genClient.clear(CacheKey.permissionCustomersWrite);
  }
  /** Clears the 'permissionInventoryRead' field, the 'has' method for this field will now return false */
  public void clearPermissionInventoryRead() {
    genClient.clear(CacheKey.permissionInventoryRead);
  }
  /** Clears the 'permissionInventoryWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionInventoryWrite() {
    genClient.clear(CacheKey.permissionInventoryWrite);
  }
  /** Clears the 'permissionOrdersRead' field, the 'has' method for this field will now return false */
  public void clearPermissionOrdersRead() {
    genClient.clear(CacheKey.permissionOrdersRead);
  }
  /** Clears the 'permissionOrdersWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionOrdersWrite() {
    genClient.clear(CacheKey.permissionOrdersWrite);
  }
  /** Clears the 'permissionPaymentsRead' field, the 'has' method for this field will now return false */
  public void clearPermissionPaymentsRead() {
    genClient.clear(CacheKey.permissionPaymentsRead);
  }
  /** Clears the 'permissionPaymentsWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionPaymentsWrite() {
    genClient.clear(CacheKey.permissionPaymentsWrite);
  }
  /** Clears the 'permissionEmployeesRead' field, the 'has' method for this field will now return false */
  public void clearPermissionEmployeesRead() {
    genClient.clear(CacheKey.permissionEmployeesRead);
  }
  /** Clears the 'permissionEmployeesWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionEmployeesWrite() {
    genClient.clear(CacheKey.permissionEmployeesWrite);
  }
  /** Clears the 'permissionProcessCards' field, the 'has' method for this field will now return false */
  public void clearPermissionProcessCards() {
    genClient.clear(CacheKey.permissionProcessCards);
  }
  /** Clears the 'permissionMidRead' field, the 'has' method for this field will now return false */
  public void clearPermissionMidRead() {
    genClient.clear(CacheKey.permissionMidRead);
  }
  /** Clears the 'privacyPolicy' field, the 'has' method for this field will now return false */
  public void clearPrivacyPolicy() {
    genClient.clear(CacheKey.privacyPolicy);
  }
  /** Clears the 'eula' field, the 'has' method for this field will now return false */
  public void clearEula() {
    genClient.clear(CacheKey.eula);
  }
  /** Clears the 'supportPhone' field, the 'has' method for this field will now return false */
  public void clearSupportPhone() {
    genClient.clear(CacheKey.supportPhone);
  }
  /** Clears the 'supportPhoneHours' field, the 'has' method for this field will now return false */
  public void clearSupportPhoneHours() {
    genClient.clear(CacheKey.supportPhoneHours);
  }
  /** Clears the 'supportEmail' field, the 'has' method for this field will now return false */
  public void clearSupportEmail() {
    genClient.clear(CacheKey.supportEmail);
  }
  /** Clears the 'supportUrl' field, the 'has' method for this field will now return false */
  public void clearSupportUrl() {
    genClient.clear(CacheKey.supportUrl);
  }
  /** Clears the 'productType' field, the 'has' method for this field will now return false */
  public void clearProductType() {
    genClient.clear(CacheKey.productType);
  }
  /** Clears the 'approvalStatus' field, the 'has' method for this field will now return false */
  public void clearApprovalStatus() {
    genClient.clear(CacheKey.approvalStatus);
  }
  /** Clears the 'androidPermissions' field, the 'has' method for this field will now return false */
  public void clearAndroidPermissions() {
    genClient.clear(CacheKey.androidPermissions);
  }
  /** Clears the 'screenshots' field, the 'has' method for this field will now return false */
  public void clearScreenshots() {
    genClient.clear(CacheKey.screenshots);
  }
  /** Clears the 'availableSubscriptions' field, the 'has' method for this field will now return false */
  public void clearAvailableSubscriptions() {
    genClient.clear(CacheKey.availableSubscriptions);
  }
  /** Clears the 'subscriptions' field, the 'has' method for this field will now return false */
  public void clearSubscriptions() {
    genClient.clear(CacheKey.subscriptions);
  }
  /** Clears the 'availableMetereds' field, the 'has' method for this field will now return false */
  public void clearAvailableMetereds() {
    genClient.clear(CacheKey.availableMetereds);
  }
  /** Clears the 'metereds' field, the 'has' method for this field will now return false */
  public void clearMetereds() {
    genClient.clear(CacheKey.metereds);
  }
  /** Clears the 'usbDevices' field, the 'has' method for this field will now return false */
  public void clearUsbDevices() {
    genClient.clear(CacheKey.usbDevices);
  }
  /** Clears the 'isMerchantInTrial' field, the 'has' method for this field will now return false */
  public void clearIsMerchantInTrial() {
    genClient.clear(CacheKey.isMerchantInTrial);
  }
  /** Clears the 'currentSubscription' field, the 'has' method for this field will now return false */
  public void clearCurrentSubscription() {
    genClient.clear(CacheKey.currentSubscription);
  }
  /** Clears the 'webhook' field, the 'has' method for this field will now return false */
  public void clearWebhook() {
    genClient.clear(CacheKey.webhook);
  }
  /** Clears the 'androidVersions' field, the 'has' method for this field will now return false */
  public void clearAndroidVersions() {
    genClient.clear(CacheKey.androidVersions);
  }
  /** Clears the 'installed' field, the 'has' method for this field will now return false */
  public void clearInstalled() {
    genClient.clear(CacheKey.installed);
  }
  /** Clears the 'installedTime' field, the 'has' method for this field will now return false */
  public void clearInstalledTime() {
    genClient.clear(CacheKey.installedTime);
  }
  /** Clears the 'paidAppHasTrial' field, the 'has' method for this field will now return false */
  public void clearPaidAppHasTrial() {
    genClient.clear(CacheKey.paidAppHasTrial);
  }
  /** Clears the 'approvalStatusModifiedTime' field, the 'has' method for this field will now return false */
  public void clearApprovalStatusModifiedTime() {
    genClient.clear(CacheKey.approvalStatusModifiedTime);
  }
  /** Clears the 'smartReceiptText' field, the 'has' method for this field will now return false */
  public void clearSmartReceiptText() {
    genClient.clear(CacheKey.smartReceiptText);
  }
  /** Clears the 'smartReceiptUrl' field, the 'has' method for this field will now return false */
  public void clearSmartReceiptUrl() {
    genClient.clear(CacheKey.smartReceiptUrl);
  }
  /** Clears the 'billingStartTime' field, the 'has' method for this field will now return false */
  public void clearBillingStartTime() {
    genClient.clear(CacheKey.billingStartTime);
  }
  /** Clears the 'appSecret' field, the 'has' method for this field will now return false */
  public void clearAppSecret() {
    genClient.clear(CacheKey.appSecret);
  }
  /** Clears the 'businessTypes' field, the 'has' method for this field will now return false */
  public void clearBusinessTypes() {
    genClient.clear(CacheKey.businessTypes);
  }
  /** Clears the 'deviceTypes' field, the 'has' method for this field will now return false */
  public void clearDeviceTypes() {
    genClient.clear(CacheKey.deviceTypes);
  }
  /** Clears the 'modules' field, the 'has' method for this field will now return false */
  public void clearModules() {
    genClient.clear(CacheKey.modules);
  }
  /** Clears the 'taxClassificationCode' field, the 'has' method for this field will now return false */
  public void clearTaxClassificationCode() {
    genClient.clear(CacheKey.taxClassificationCode);
  }
  /** Clears the 'applicationId' field, the 'has' method for this field will now return false */
  public void clearApplicationId() {
    genClient.clear(CacheKey.applicationId);
  }
  /** Clears the 'nonCloverBilling' field, the 'has' method for this field will now return false */
  public void clearNonCloverBilling() {
    genClient.clear(CacheKey.nonCloverBilling);
  }
  /** Clears the 'equipmentCode' field, the 'has' method for this field will now return false */
  public void clearEquipmentCode() {
    genClient.clear(CacheKey.equipmentCode);
  }
  /** Clears the 'equipmentName' field, the 'has' method for this field will now return false */
  public void clearEquipmentName() {
    genClient.clear(CacheKey.equipmentName);
  }
  /** Clears the 'firstPublishedTime' field, the 'has' method for this field will now return false */
  public void clearFirstPublishedTime() {
    genClient.clear(CacheKey.firstPublishedTime);
  }
  /** Clears the 'firstApprovalTime' field, the 'has' method for this field will now return false */
  public void clearFirstApprovalTime() {
    genClient.clear(CacheKey.firstApprovalTime);
  }
  /** Clears the 'appBundle' field, the 'has' method for this field will now return false */
  public void clearAppBundle() {
    genClient.clear(CacheKey.appBundle);
  }
  /** Clears the 'editorPick' field, the 'has' method for this field will now return false */
  public void clearEditorPick() {
    genClient.clear(CacheKey.editorPick);
  }
  /** Clears the 'popularity' field, the 'has' method for this field will now return false */
  public void clearPopularity() {
    genClient.clear(CacheKey.popularity);
  }
  /** Clears the 'allowUninstall' field, the 'has' method for this field will now return false */
  public void clearAllowUninstall() {
    genClient.clear(CacheKey.allowUninstall);
  }
  /** Clears the 'charge' field, the 'has' method for this field will now return false */
  public void clearCharge() {
    genClient.clear(CacheKey.charge);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public App copyChanges() {
    App copy = new App();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(App src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new App(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<App> CREATOR = new android.os.Parcelable.Creator<App>() {
    @Override
    public App createFromParcel(android.os.Parcel in) {
      App instance = new App(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public App[] newArray(int size) {
      return new App[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<App> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<App>() {
    @Override
    public App create(org.json.JSONObject jsonObject) {
      return new App(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean PUBLISHED_IS_REQUIRED = false;
    public static final boolean DEVELOPER_IS_REQUIRED = false;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final long DESCRIPTION_MAX_LEN = 2000;
    public static final boolean TAGLINE_IS_REQUIRED = false;
    public static final long TAGLINE_MAX_LEN = 255;
    public static final boolean VIDEOURL_IS_REQUIRED = false;
    public static final long VIDEOURL_MAX_LEN = 255;
    public static final boolean ACTIVATIONURL_IS_REQUIRED = false;
    public static final long ACTIVATIONURL_MAX_LEN = 255;
    public static final boolean SITEURL_IS_REQUIRED = false;
    public static final long SITEURL_MAX_LEN = 255;
    public static final boolean DEFAULTRESPONSETYPE_IS_REQUIRED = false;
    public static final boolean APPDOMAIN_IS_REQUIRED = false;
    public static final long APPDOMAIN_MAX_LEN = 255;
    public static final boolean ANDROIDVERSION_IS_REQUIRED = false;
    public static final boolean PACKAGENAME_IS_REQUIRED = false;
    public static final long PACKAGENAME_MAX_LEN = 255;
    public static final boolean APPROVED_IS_REQUIRED = false;
    public static final boolean SYSTEMAPP_IS_REQUIRED = false;
    public static final boolean HIDDEN_IS_REQUIRED = false;
    public static final boolean FILENAMEICON_IS_REQUIRED = false;
    public static final long FILENAMEICON_MAX_LEN = 100;
    public static final boolean FILENAMEICONSMALL_IS_REQUIRED = false;
    public static final long FILENAMEICONSMALL_MAX_LEN = 255;
    public static final boolean FILENAMEICONLARGE_IS_REQUIRED = false;
    public static final long FILENAMEICONLARGE_MAX_LEN = 255;
    public static final boolean INSTALLCOUNT_IS_REQUIRED = false;
    public static final boolean SORTORDER_IS_REQUIRED = false;
    public static final boolean PERMISSIONMERCHANTREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONMERCHANTWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONINVENTORYREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONINVENTORYWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONORDERSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONORDERSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONPAYMENTSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONPAYMENTSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONEMPLOYEESREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONEMPLOYEESWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONPROCESSCARDS_IS_REQUIRED = false;
    public static final boolean PERMISSIONMIDREAD_IS_REQUIRED = false;
    public static final boolean PRIVACYPOLICY_IS_REQUIRED = false;
    public static final long PRIVACYPOLICY_MAX_LEN = 255;
    public static final boolean EULA_IS_REQUIRED = false;
    public static final long EULA_MAX_LEN = 255;
    public static final boolean SUPPORTPHONE_IS_REQUIRED = false;
    public static final long SUPPORTPHONE_MAX_LEN = 25;
    public static final boolean SUPPORTPHONEHOURS_IS_REQUIRED = false;
    public static final long SUPPORTPHONEHOURS_MAX_LEN = 127;
    public static final boolean SUPPORTEMAIL_IS_REQUIRED = false;
    public static final long SUPPORTEMAIL_MAX_LEN = 127;
    public static final boolean SUPPORTURL_IS_REQUIRED = false;
    public static final long SUPPORTURL_MAX_LEN = 255;
    public static final boolean PRODUCTTYPE_IS_REQUIRED = false;
    public static final boolean APPROVALSTATUS_IS_REQUIRED = false;
    public static final boolean ANDROIDPERMISSIONS_IS_REQUIRED = false;
    public static final boolean SCREENSHOTS_IS_REQUIRED = false;
    public static final boolean AVAILABLESUBSCRIPTIONS_IS_REQUIRED = false;
    public static final boolean SUBSCRIPTIONS_IS_REQUIRED = false;
    public static final boolean AVAILABLEMETEREDS_IS_REQUIRED = false;
    public static final boolean METEREDS_IS_REQUIRED = false;
    public static final boolean USBDEVICES_IS_REQUIRED = false;
    public static final boolean ISMERCHANTINTRIAL_IS_REQUIRED = false;
    public static final boolean CURRENTSUBSCRIPTION_IS_REQUIRED = false;
    public static final boolean WEBHOOK_IS_REQUIRED = false;
    public static final boolean ANDROIDVERSIONS_IS_REQUIRED = false;
    public static final boolean INSTALLED_IS_REQUIRED = false;
    public static final boolean INSTALLEDTIME_IS_REQUIRED = false;
    public static final boolean PAIDAPPHASTRIAL_IS_REQUIRED = false;
    public static final boolean APPROVALSTATUSMODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean SMARTRECEIPTTEXT_IS_REQUIRED = false;
    public static final long SMARTRECEIPTTEXT_MAX_LEN = 100;
    public static final boolean SMARTRECEIPTURL_IS_REQUIRED = false;
    public static final long SMARTRECEIPTURL_MAX_LEN = 255;
    public static final boolean BILLINGSTARTTIME_IS_REQUIRED = false;
    public static final boolean APPSECRET_IS_REQUIRED = false;
    public static final long APPSECRET_MAX_LEN = 255;
    public static final boolean BUSINESSTYPES_IS_REQUIRED = false;
    public static final boolean DEVICETYPES_IS_REQUIRED = false;
    public static final boolean MODULES_IS_REQUIRED = false;
    public static final boolean TAXCLASSIFICATIONCODE_IS_REQUIRED = false;
    public static final boolean APPLICATIONID_IS_REQUIRED = false;
    public static final boolean NONCLOVERBILLING_IS_REQUIRED = false;
    public static final boolean EQUIPMENTCODE_IS_REQUIRED = false;
    public static final boolean EQUIPMENTNAME_IS_REQUIRED = false;
    public static final boolean FIRSTPUBLISHEDTIME_IS_REQUIRED = false;
    public static final boolean FIRSTAPPROVALTIME_IS_REQUIRED = false;
    public static final boolean APPBUNDLE_IS_REQUIRED = false;
    public static final boolean EDITORPICK_IS_REQUIRED = false;
    public static final boolean POPULARITY_IS_REQUIRED = false;
    public static final boolean ALLOWUNINSTALL_IS_REQUIRED = false;
    public static final boolean CHARGE_IS_REQUIRED = false;

  }

}
