/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getCountry country}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getActive active}</li>
 * <li>{@link #getAppSubscription appSubscription}</li>
 * <li>{@link #getInstallCount installCount}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AppSubscriptionCountry extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * App subscription country name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * The cost of the subscription country
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * The country of the subscription country
   */
  public java.lang.String getCountry() {
    return genClient.cacheGet(CacheKey.country);
  }

  /**
   * App subscription country name
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  /**
   * App subscription country active status
   */
  public java.lang.Boolean getActive() {
    return genClient.cacheGet(CacheKey.active);
  }

  /**
   * Reference to subscription this subscription country belongs to
   */
  public com.clover.sdk.v3.base.Reference getAppSubscription() {
    return genClient.cacheGet(CacheKey.appSubscription);
  }

  /**
   * The number of merchants that have this app subscription country installed
   */
  public java.lang.Long getInstallCount() {
    return genClient.cacheGet(CacheKey.installCount);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<AppSubscriptionCountry> {
    id {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    name {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    amount {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("amount", java.lang.Long.class);
      }
    },
    country {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("country", java.lang.String.class);
      }
    },
    description {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("description", java.lang.String.class);
      }
    },
    active {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("active", java.lang.Boolean.class);
      }
    },
    appSubscription {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractRecord("appSubscription", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    installCount {
      @Override
      public Object extractValue(AppSubscriptionCountry instance) {
        return instance.genClient.extractOther("installCount", java.lang.Long.class);
      }
    },
      ;
  }

  private GenericClient<AppSubscriptionCountry> genClient;

  /**
  * Constructs a new empty instance.
  */
  public AppSubscriptionCountry() {
    genClient = new GenericClient<AppSubscriptionCountry>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected AppSubscriptionCountry(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AppSubscriptionCountry(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AppSubscriptionCountry(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AppSubscriptionCountry(AppSubscriptionCountry src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateNull(getName(), "name");
    genClient.validateLength(getName(), 20);

    genClient.validateNull(getAmount(), "amount");
    if (getAmount() != null && ( getAmount() < 0)) throw new IllegalArgumentException("Invalid value for 'getAmount()'");

    genClient.validateNull(getCountry(), "country");
    genClient.validateLength(getCountry(), 2);

    genClient.validateNull(getDescription(), "description");
    genClient.validateLength(getDescription(), 1024);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'country' field is set and is not null */
  public boolean isNotNullCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.country);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'active' field is set and is not null */
  public boolean isNotNullActive() {
    return genClient.cacheValueIsNotNull(CacheKey.active);
  }

  /** Checks whether the 'appSubscription' field is set and is not null */
  public boolean isNotNullAppSubscription() {
    return genClient.cacheValueIsNotNull(CacheKey.appSubscription);
  }

  /** Checks whether the 'installCount' field is set and is not null */
  public boolean isNotNullInstallCount() {
    return genClient.cacheValueIsNotNull(CacheKey.installCount);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'country' field has been set, however the value could be null */
  public boolean hasCountry() {
    return genClient.cacheHasKey(CacheKey.country);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'active' field has been set, however the value could be null */
  public boolean hasActive() {
    return genClient.cacheHasKey(CacheKey.active);
  }

  /** Checks whether the 'appSubscription' field has been set, however the value could be null */
  public boolean hasAppSubscription() {
    return genClient.cacheHasKey(CacheKey.appSubscription);
  }

  /** Checks whether the 'installCount' field has been set, however the value could be null */
  public boolean hasInstallCount() {
    return genClient.cacheHasKey(CacheKey.installCount);
  }


  /**
   * Sets the field 'id'.
   */
  public AppSubscriptionCountry setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public AppSubscriptionCountry setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'amount'.
   */
  public AppSubscriptionCountry setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'country'.
   */
  public AppSubscriptionCountry setCountry(java.lang.String country) {
    return genClient.setOther(country, CacheKey.country);
  }

  /**
   * Sets the field 'description'.
   */
  public AppSubscriptionCountry setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'active'.
   */
  public AppSubscriptionCountry setActive(java.lang.Boolean active) {
    return genClient.setOther(active, CacheKey.active);
  }

  /**
   * Sets the field 'appSubscription'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppSubscriptionCountry setAppSubscription(com.clover.sdk.v3.base.Reference appSubscription) {
    return genClient.setRecord(appSubscription, CacheKey.appSubscription);
  }

  /**
   * Sets the field 'installCount'.
   */
  public AppSubscriptionCountry setInstallCount(java.lang.Long installCount) {
    return genClient.setOther(installCount, CacheKey.installCount);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'country' field, the 'has' method for this field will now return false */
  public void clearCountry() {
    genClient.clear(CacheKey.country);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'active' field, the 'has' method for this field will now return false */
  public void clearActive() {
    genClient.clear(CacheKey.active);
  }
  /** Clears the 'appSubscription' field, the 'has' method for this field will now return false */
  public void clearAppSubscription() {
    genClient.clear(CacheKey.appSubscription);
  }
  /** Clears the 'installCount' field, the 'has' method for this field will now return false */
  public void clearInstallCount() {
    genClient.clear(CacheKey.installCount);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AppSubscriptionCountry copyChanges() {
    AppSubscriptionCountry copy = new AppSubscriptionCountry();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AppSubscriptionCountry src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AppSubscriptionCountry(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AppSubscriptionCountry> CREATOR = new android.os.Parcelable.Creator<AppSubscriptionCountry>() {
    @Override
    public AppSubscriptionCountry createFromParcel(android.os.Parcel in) {
      AppSubscriptionCountry instance = new AppSubscriptionCountry(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AppSubscriptionCountry[] newArray(int size) {
      return new AppSubscriptionCountry[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AppSubscriptionCountry> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AppSubscriptionCountry>() {
    @Override
    public AppSubscriptionCountry create(org.json.JSONObject jsonObject) {
      return new AppSubscriptionCountry(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 20;
    public static final boolean AMOUNT_IS_REQUIRED = true;
    public static final long AMOUNT_MIN = 0;
    public static final boolean COUNTRY_IS_REQUIRED = true;
    public static final long COUNTRY_MAX_LEN = 2;
    public static final boolean DESCRIPTION_IS_REQUIRED = true;
    public static final long DESCRIPTION_MAX_LEN = 1024;
    public static final boolean ACTIVE_IS_REQUIRED = false;
    public static final boolean APPSUBSCRIPTION_IS_REQUIRED = false;
    public static final boolean INSTALLCOUNT_IS_REQUIRED = false;

  }

}
