/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPackageName packageName}</li>
 * <li>{@link #getVendorId vendorId}</li>
 * <li>{@link #getProductId productId}</li>
 * <li>{@link #getApp app}</li>
 * <li>{@link #getOpenAppMarketIfNotInstalled openAppMarketIfNotInstalled}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AppUsbDevice extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getPackageName() {
    return genClient.cacheGet(CacheKey.packageName);
  }

  public java.lang.Integer getVendorId() {
    return genClient.cacheGet(CacheKey.vendorId);
  }

  public java.lang.Integer getProductId() {
    return genClient.cacheGet(CacheKey.productId);
  }

  public com.clover.sdk.v3.base.Reference getApp() {
    return genClient.cacheGet(CacheKey.app);
  }

  public java.lang.Boolean getOpenAppMarketIfNotInstalled() {
    return genClient.cacheGet(CacheKey.openAppMarketIfNotInstalled);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<AppUsbDevice> {
    packageName {
      @Override
      public Object extractValue(AppUsbDevice instance) {
        return instance.genClient.extractOther("packageName", java.lang.String.class);
      }
    },
    vendorId {
      @Override
      public Object extractValue(AppUsbDevice instance) {
        return instance.genClient.extractOther("vendorId", java.lang.Integer.class);
      }
    },
    productId {
      @Override
      public Object extractValue(AppUsbDevice instance) {
        return instance.genClient.extractOther("productId", java.lang.Integer.class);
      }
    },
    app {
      @Override
      public Object extractValue(AppUsbDevice instance) {
        return instance.genClient.extractRecord("app", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    openAppMarketIfNotInstalled {
      @Override
      public Object extractValue(AppUsbDevice instance) {
        return instance.genClient.extractOther("openAppMarketIfNotInstalled", java.lang.Boolean.class);
      }
    },
      ;
  }

  private GenericClient<AppUsbDevice> genClient;

  /**
  * Constructs a new empty instance.
  */
  public AppUsbDevice() {
    genClient = new GenericClient<AppUsbDevice>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected AppUsbDevice(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AppUsbDevice(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AppUsbDevice(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AppUsbDevice(AppUsbDevice src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getPackageName(), 255);

    if (getVendorId() != null && ( getVendorId() < 0)) throw new IllegalArgumentException("Invalid value for 'getVendorId()'");

    if (getProductId() != null && ( getProductId() < 0)) throw new IllegalArgumentException("Invalid value for 'getProductId()'");
  }

  /** Checks whether the 'packageName' field is set and is not null */
  public boolean isNotNullPackageName() {
    return genClient.cacheValueIsNotNull(CacheKey.packageName);
  }

  /** Checks whether the 'vendorId' field is set and is not null */
  public boolean isNotNullVendorId() {
    return genClient.cacheValueIsNotNull(CacheKey.vendorId);
  }

  /** Checks whether the 'productId' field is set and is not null */
  public boolean isNotNullProductId() {
    return genClient.cacheValueIsNotNull(CacheKey.productId);
  }

  /** Checks whether the 'app' field is set and is not null */
  public boolean isNotNullApp() {
    return genClient.cacheValueIsNotNull(CacheKey.app);
  }

  /** Checks whether the 'openAppMarketIfNotInstalled' field is set and is not null */
  public boolean isNotNullOpenAppMarketIfNotInstalled() {
    return genClient.cacheValueIsNotNull(CacheKey.openAppMarketIfNotInstalled);
  }



  /** Checks whether the 'packageName' field has been set, however the value could be null */
  public boolean hasPackageName() {
    return genClient.cacheHasKey(CacheKey.packageName);
  }

  /** Checks whether the 'vendorId' field has been set, however the value could be null */
  public boolean hasVendorId() {
    return genClient.cacheHasKey(CacheKey.vendorId);
  }

  /** Checks whether the 'productId' field has been set, however the value could be null */
  public boolean hasProductId() {
    return genClient.cacheHasKey(CacheKey.productId);
  }

  /** Checks whether the 'app' field has been set, however the value could be null */
  public boolean hasApp() {
    return genClient.cacheHasKey(CacheKey.app);
  }

  /** Checks whether the 'openAppMarketIfNotInstalled' field has been set, however the value could be null */
  public boolean hasOpenAppMarketIfNotInstalled() {
    return genClient.cacheHasKey(CacheKey.openAppMarketIfNotInstalled);
  }


  /**
   * Sets the field 'packageName'.
   */
  public AppUsbDevice setPackageName(java.lang.String packageName) {
    return genClient.setOther(packageName, CacheKey.packageName);
  }

  /**
   * Sets the field 'vendorId'.
   */
  public AppUsbDevice setVendorId(java.lang.Integer vendorId) {
    return genClient.setOther(vendorId, CacheKey.vendorId);
  }

  /**
   * Sets the field 'productId'.
   */
  public AppUsbDevice setProductId(java.lang.Integer productId) {
    return genClient.setOther(productId, CacheKey.productId);
  }

  /**
   * Sets the field 'app'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppUsbDevice setApp(com.clover.sdk.v3.base.Reference app) {
    return genClient.setRecord(app, CacheKey.app);
  }

  /**
   * Sets the field 'openAppMarketIfNotInstalled'.
   */
  public AppUsbDevice setOpenAppMarketIfNotInstalled(java.lang.Boolean openAppMarketIfNotInstalled) {
    return genClient.setOther(openAppMarketIfNotInstalled, CacheKey.openAppMarketIfNotInstalled);
  }


  /** Clears the 'packageName' field, the 'has' method for this field will now return false */
  public void clearPackageName() {
    genClient.clear(CacheKey.packageName);
  }
  /** Clears the 'vendorId' field, the 'has' method for this field will now return false */
  public void clearVendorId() {
    genClient.clear(CacheKey.vendorId);
  }
  /** Clears the 'productId' field, the 'has' method for this field will now return false */
  public void clearProductId() {
    genClient.clear(CacheKey.productId);
  }
  /** Clears the 'app' field, the 'has' method for this field will now return false */
  public void clearApp() {
    genClient.clear(CacheKey.app);
  }
  /** Clears the 'openAppMarketIfNotInstalled' field, the 'has' method for this field will now return false */
  public void clearOpenAppMarketIfNotInstalled() {
    genClient.clear(CacheKey.openAppMarketIfNotInstalled);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AppUsbDevice copyChanges() {
    AppUsbDevice copy = new AppUsbDevice();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AppUsbDevice src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AppUsbDevice(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AppUsbDevice> CREATOR = new android.os.Parcelable.Creator<AppUsbDevice>() {
    @Override
    public AppUsbDevice createFromParcel(android.os.Parcel in) {
      AppUsbDevice instance = new AppUsbDevice(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AppUsbDevice[] newArray(int size) {
      return new AppUsbDevice[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AppUsbDevice> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AppUsbDevice>() {
    @Override
    public AppUsbDevice create(org.json.JSONObject jsonObject) {
      return new AppUsbDevice(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean PACKAGENAME_IS_REQUIRED = false;
    public static final long PACKAGENAME_MAX_LEN = 255;
    public static final boolean VENDORID_IS_REQUIRED = false;
    public static final long VENDORID_MIN = 0;
    public static final boolean PRODUCTID_IS_REQUIRED = false;
    public static final long PRODUCTID_MIN = 0;
    public static final boolean APP_IS_REQUIRED = false;
    public static final boolean OPENAPPMARKETIFNOTINSTALLED_IS_REQUIRED = false;

  }

}
