/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.base;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getEnabled enabled}</li>
 * <li>{@link #getPercentage percentage}</li>
 * <li>{@link #getPercentageDecimal percentageDecimal}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class ServiceCharge extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Service charge name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * If this service charge is enabled
   */
  public java.lang.Boolean getEnabled() {
    return genClient.cacheGet(CacheKey.enabled);
  }

  /**
   * DEPRECATED
   */
  public java.lang.Long getPercentage() {
    return genClient.cacheGet(CacheKey.percentage);
  }

  /**
   * Percent to charge times 10000, e.g. 12.5% will be 125000
   */
  public java.lang.Long getPercentageDecimal() {
    return genClient.cacheGet(CacheKey.percentageDecimal);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<ServiceCharge> {
    id {
      @Override
      public Object extractValue(ServiceCharge instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    name {
      @Override
      public Object extractValue(ServiceCharge instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    enabled {
      @Override
      public Object extractValue(ServiceCharge instance) {
        return instance.genClient.extractOther("enabled", java.lang.Boolean.class);
      }
    },
    percentage {
      @Override
      public Object extractValue(ServiceCharge instance) {
        return instance.genClient.extractOther("percentage", java.lang.Long.class);
      }
    },
    percentageDecimal {
      @Override
      public Object extractValue(ServiceCharge instance) {
        return instance.genClient.extractOther("percentageDecimal", java.lang.Long.class);
      }
    },
      ;
  }

  private GenericClient<ServiceCharge> genClient;

  /**
  * Constructs a new empty instance.
  */
  public ServiceCharge() {
    genClient = new GenericClient<ServiceCharge>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected ServiceCharge(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ServiceCharge(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ServiceCharge(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ServiceCharge(ServiceCharge src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getName(), 127);

    if (getPercentage() != null && ( getPercentage() < 0)) throw new IllegalArgumentException("Invalid value for 'getPercentage()'");

    if (getPercentageDecimal() != null && ( getPercentageDecimal() < 0 || getPercentageDecimal() > 1000000)) throw new IllegalArgumentException("Invalid value for 'getPercentageDecimal()'");
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'enabled' field is set and is not null */
  public boolean isNotNullEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.enabled);
  }

  /** Checks whether the 'percentage' field is set and is not null */
  public boolean isNotNullPercentage() {
    return genClient.cacheValueIsNotNull(CacheKey.percentage);
  }

  /** Checks whether the 'percentageDecimal' field is set and is not null */
  public boolean isNotNullPercentageDecimal() {
    return genClient.cacheValueIsNotNull(CacheKey.percentageDecimal);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'enabled' field has been set, however the value could be null */
  public boolean hasEnabled() {
    return genClient.cacheHasKey(CacheKey.enabled);
  }

  /** Checks whether the 'percentage' field has been set, however the value could be null */
  public boolean hasPercentage() {
    return genClient.cacheHasKey(CacheKey.percentage);
  }

  /** Checks whether the 'percentageDecimal' field has been set, however the value could be null */
  public boolean hasPercentageDecimal() {
    return genClient.cacheHasKey(CacheKey.percentageDecimal);
  }


  /**
   * Sets the field 'id'.
   */
  public ServiceCharge setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public ServiceCharge setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'enabled'.
   */
  public ServiceCharge setEnabled(java.lang.Boolean enabled) {
    return genClient.setOther(enabled, CacheKey.enabled);
  }

  /**
   * Sets the field 'percentage'.
   */
  public ServiceCharge setPercentage(java.lang.Long percentage) {
    return genClient.setOther(percentage, CacheKey.percentage);
  }

  /**
   * Sets the field 'percentageDecimal'.
   */
  public ServiceCharge setPercentageDecimal(java.lang.Long percentageDecimal) {
    return genClient.setOther(percentageDecimal, CacheKey.percentageDecimal);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'enabled' field, the 'has' method for this field will now return false */
  public void clearEnabled() {
    genClient.clear(CacheKey.enabled);
  }
  /** Clears the 'percentage' field, the 'has' method for this field will now return false */
  public void clearPercentage() {
    genClient.clear(CacheKey.percentage);
  }
  /** Clears the 'percentageDecimal' field, the 'has' method for this field will now return false */
  public void clearPercentageDecimal() {
    genClient.clear(CacheKey.percentageDecimal);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ServiceCharge copyChanges() {
    ServiceCharge copy = new ServiceCharge();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ServiceCharge src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ServiceCharge(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ServiceCharge> CREATOR = new android.os.Parcelable.Creator<ServiceCharge>() {
    @Override
    public ServiceCharge createFromParcel(android.os.Parcel in) {
      ServiceCharge instance = new ServiceCharge(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ServiceCharge[] newArray(int size) {
      return new ServiceCharge[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ServiceCharge> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ServiceCharge>() {
    @Override
    public ServiceCharge create(org.json.JSONObject jsonObject) {
      return new ServiceCharge(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean ENABLED_IS_REQUIRED = false;
    public static final boolean PERCENTAGE_IS_REQUIRED = false;
    public static final long PERCENTAGE_MIN = 0;
    public static final boolean PERCENTAGEDECIMAL_IS_REQUIRED = false;
    public static final long PERCENTAGEDECIMAL_MIN = 0;
    public static final long PERCENTAGEDECIMAL_MAX = 1000000;

  }

}
