/**
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

package com.clover.sdk.v3.billing;

@SuppressWarnings("all")
public final class AppLineItem implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }
 /**
   * The app that this line item belongs to.
  */
  public com.clover.sdk.v3.base.Reference getApp() {
    return cacheGet(CacheKey.app);
  }
 /**
   * The merchant that this line item belongs to.
  */
  public com.clover.sdk.v3.base.Reference getMerchant() {
    return cacheGet(CacheKey.merchant);
  }
  public java.lang.Long getAmount() {
    return cacheGet(CacheKey.amount);
  }
  public com.clover.sdk.v3.billing.AppLineItemStatus getStatus() {
    return cacheGet(CacheKey.status);
  }
  public com.clover.sdk.v3.billing.AppLineItemType getType() {
    return cacheGet(CacheKey.type);
  }
  public java.lang.Long getCreatedTime() {
    return cacheGet(CacheKey.createdTime);
  }
  public java.lang.Long getModifiedTime() {
    return cacheGet(CacheKey.modifiedTime);
  }
 /**
   * This is only filled in if the install that caused this app line item has been uninstalled
  */
  public java.lang.Long getAppUninstallTime() {
    return cacheGet(CacheKey.appUninstallTime);
  }
  public java.util.List<com.clover.sdk.v3.billing.AppMeteredEvent> getAppMeteredEvents() {
    return cacheGet(CacheKey.appMeteredEvents);
  }


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractId();
      }
    },
    app {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractApp();
      }
    },
    merchant {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractMerchant();
      }
    },
    amount {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractAmount();
      }
    },
    status {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractStatus();
      }
    },
    type {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractType();
      }
    },
    createdTime {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractCreatedTime();
      }
    },
    modifiedTime {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractModifiedTime();
      }
    },
    appUninstallTime {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractAppUninstallTime();
      }
    },
    appMeteredEvents {
      @Override
      public Object extractValue(AppLineItem instance) {
        return instance.extractAppMeteredEvents();
      }
    },
    ;

    public abstract Object extractValue(AppLineItem instance);
  }

  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public AppLineItem() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AppLineItem(String json) throws java.lang.IllegalArgumentException {
    try {
      this.jsonObject = new org.json.JSONObject(json);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AppLineItem(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AppLineItem(AppLineItem src) {
    if (src.jsonObject != null) {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    if (jsonObject == null) {
      jsonObject = new org.json.JSONObject();
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) { throw new IllegalArgumentException("Maximum string length exceeded for 'id'");}

    com.clover.sdk.v3.base.Reference app = getApp();
    if (app == null) throw new java.lang.IllegalArgumentException("'app' is required to be non-null");

    com.clover.sdk.v3.base.Reference merchant = getMerchant();
    if (merchant == null) throw new java.lang.IllegalArgumentException("'merchant' is required to be non-null");

    java.lang.Long amount = getAmount();
    if (amount == null) throw new java.lang.IllegalArgumentException("'amount' is required to be non-null");

    com.clover.sdk.v3.billing.AppLineItemStatus status = getStatus();
    if (status == null) throw new java.lang.IllegalArgumentException("'status' is required to be non-null");

    com.clover.sdk.v3.billing.AppLineItemType type = getType();
    if (type == null) throw new java.lang.IllegalArgumentException("'type' is required to be non-null");
  }



  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }


  private com.clover.sdk.v3.base.Reference extractApp() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("app");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("app"));
    }
    return null;
  }


  private com.clover.sdk.v3.base.Reference extractMerchant() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("merchant");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("merchant"));
    }
    return null;
  }


  private java.lang.Long extractAmount() {
    return getJSONObject().isNull("amount") ? null :
      getJSONObject().optLong("amount");
  }


  private com.clover.sdk.v3.billing.AppLineItemStatus extractStatus() {
    if (!getJSONObject().isNull("status")) {
      try {
        return com.clover.sdk.v3.billing.AppLineItemStatus.valueOf(getJSONObject().optString("status"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }


  private com.clover.sdk.v3.billing.AppLineItemType extractType() {
    if (!getJSONObject().isNull("type")) {
      try {
        return com.clover.sdk.v3.billing.AppLineItemType.valueOf(getJSONObject().optString("type"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }


  private java.lang.Long extractCreatedTime() {
    return getJSONObject().isNull("createdTime") ? null :
      getJSONObject().optLong("createdTime");
  }


  private java.lang.Long extractModifiedTime() {
    return getJSONObject().isNull("modifiedTime") ? null :
      getJSONObject().optLong("modifiedTime");
  }


  private java.lang.Long extractAppUninstallTime() {
    return getJSONObject().isNull("appUninstallTime") ? null :
      getJSONObject().optLong("appUninstallTime");
  }


  private java.util.List<com.clover.sdk.v3.billing.AppMeteredEvent> extractAppMeteredEvents() {
    if (getJSONObject().isNull("appMeteredEvents")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("appMeteredEvents");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.billing.AppMeteredEvent> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.billing.AppMeteredEvent>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.billing.AppMeteredEvent item = new com.clover.sdk.v3.billing.AppMeteredEvent(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'app' field is set and is not null */
  public boolean isNotNullApp() {
    return cacheValueIsNotNull(CacheKey.app);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'status' field is set and is not null */
  public boolean isNotNullStatus() {
    return cacheValueIsNotNull(CacheKey.status);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'appUninstallTime' field is set and is not null */
  public boolean isNotNullAppUninstallTime() {
    return cacheValueIsNotNull(CacheKey.appUninstallTime);
  }

  /** Checks whether the 'appMeteredEvents' field is set and is not null */
  public boolean isNotNullAppMeteredEvents() {
    return cacheValueIsNotNull(CacheKey.appMeteredEvents);
  }

  /** Checks whether the 'appMeteredEvents' field is set and is not null and is not empty */
  public boolean isNotEmptyAppMeteredEvents() {
    return isNotNullAppMeteredEvents() && !getAppMeteredEvents().isEmpty();
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'app' field has been set, however the value could be null */
  public boolean hasApp() {
    return cacheHasKey(CacheKey.app);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'status' field has been set, however the value could be null */
  public boolean hasStatus() {
    return cacheHasKey(CacheKey.status);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'appUninstallTime' field has been set, however the value could be null */
  public boolean hasAppUninstallTime() {
    return cacheHasKey(CacheKey.appUninstallTime);
  }

  /** Checks whether the 'appMeteredEvents' field has been set, however the value could be null */
  public boolean hasAppMeteredEvents() {
    return cacheHasKey(CacheKey.appMeteredEvents);
  }


  /**
   * Sets the field 'id'.
   */
  public AppLineItem setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'app'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppLineItem setApp(com.clover.sdk.v3.base.Reference app) {
    logChange("app");

    try {
      getJSONObject().put("app",
          app == null ? org.json.JSONObject.NULL : app.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.app);
    return this;
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppLineItem setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    logChange("merchant");

    try {
      getJSONObject().put("merchant",
          merchant == null ? org.json.JSONObject.NULL : merchant.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.merchant);
    return this;
  }

  /**
   * Sets the field 'amount'.
   */
  public AppLineItem setAmount(java.lang.Long amount) {
    logChange("amount");

    try {
      getJSONObject().put("amount", amount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(amount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.amount);
    return this;
  }

  /**
   * Sets the field 'status'.
   */
  public AppLineItem setStatus(com.clover.sdk.v3.billing.AppLineItemStatus status) {
    logChange("status");

    try {
      getJSONObject().put("status", status == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(status));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.status);
    return this;
  }

  /**
   * Sets the field 'type'.
   */
  public AppLineItem setType(com.clover.sdk.v3.billing.AppLineItemType type) {
    logChange("type");

    try {
      getJSONObject().put("type", type == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(type));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.type);
    return this;
  }

  /**
   * Sets the field 'createdTime'.
   */
  public AppLineItem setCreatedTime(java.lang.Long createdTime) {
    logChange("createdTime");

    try {
      getJSONObject().put("createdTime", createdTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(createdTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.createdTime);
    return this;
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public AppLineItem setModifiedTime(java.lang.Long modifiedTime) {
    logChange("modifiedTime");

    try {
      getJSONObject().put("modifiedTime", modifiedTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(modifiedTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.modifiedTime);
    return this;
  }

  /**
   * Sets the field 'appUninstallTime'.
   */
  public AppLineItem setAppUninstallTime(java.lang.Long appUninstallTime) {
    logChange("appUninstallTime");

    try {
      getJSONObject().put("appUninstallTime", appUninstallTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(appUninstallTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.appUninstallTime);
    return this;
  }

  /**
   * Sets the field 'appMeteredEvents'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public AppLineItem setAppMeteredEvents(java.util.List<com.clover.sdk.v3.billing.AppMeteredEvent> appMeteredEvents) {
    logChange("appMeteredEvents");

    try {
      if (appMeteredEvents == null) {
        getJSONObject().put("appMeteredEvents", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.appMeteredEvents);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.billing.AppMeteredEvent obj : appMeteredEvents) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("appMeteredEvents", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.appMeteredEvents);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'app' field, the 'has' method for this field will now return false */
  public void clearApp() {
    unlogChange("app");
    getJSONObject().remove("app");
    cacheRemoveValue(CacheKey.app);
  }

  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    unlogChange("merchant");
    getJSONObject().remove("merchant");
    cacheRemoveValue(CacheKey.merchant);
  }

  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    unlogChange("amount");
    getJSONObject().remove("amount");
    cacheRemoveValue(CacheKey.amount);
  }

  /** Clears the 'status' field, the 'has' method for this field will now return false */
  public void clearStatus() {
    unlogChange("status");
    getJSONObject().remove("status");
    cacheRemoveValue(CacheKey.status);
  }

  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    unlogChange("type");
    getJSONObject().remove("type");
    cacheRemoveValue(CacheKey.type);
  }

  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    unlogChange("createdTime");
    getJSONObject().remove("createdTime");
    cacheRemoveValue(CacheKey.createdTime);
  }

  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    unlogChange("modifiedTime");
    getJSONObject().remove("modifiedTime");
    cacheRemoveValue(CacheKey.modifiedTime);
  }

  /** Clears the 'appUninstallTime' field, the 'has' method for this field will now return false */
  public void clearAppUninstallTime() {
    unlogChange("appUninstallTime");
    getJSONObject().remove("appUninstallTime");
    cacheRemoveValue(CacheKey.appUninstallTime);
  }

  /** Clears the 'appMeteredEvents' field, the 'has' method for this field will now return false */
  public void clearAppMeteredEvents() {
    unlogChange("appMeteredEvents");
    getJSONObject().remove("appMeteredEvents");
    cacheRemoveValue(CacheKey.appMeteredEvents);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AppLineItem copyChanges() {
    AppLineItem copy = new AppLineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AppLineItem src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new AppLineItem(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = getJSONObject().toString();

    if (bundle != null) {
      bundle.isEmpty(); // Triggers unparcel
    }

    if (changeLog != null) {
      changeLog.isEmpty(); // Triggers unparcel
    }

    return "AppLineItem{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<AppLineItem> CREATOR = new android.os.Parcelable.Creator<AppLineItem>() {
    @Override
    public AppLineItem createFromParcel(android.os.Parcel in) {
      AppLineItem instance = new AppLineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle(getClass().getClassLoader());
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public AppLineItem[] newArray(int size) {
      return new AppLineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AppLineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AppLineItem>() {
    @Override
    public AppLineItem create(org.json.JSONObject jsonObject) {
      return new AppLineItem(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean APP_IS_REQUIRED = true;

    public static final boolean MERCHANT_IS_REQUIRED = true;

    public static final boolean AMOUNT_IS_REQUIRED = true;

    public static final boolean STATUS_IS_REQUIRED = true;

    public static final boolean TYPE_IS_REQUIRED = true;

    public static final boolean CREATEDTIME_IS_REQUIRED = false;

    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;

    public static final boolean APPUNINSTALLTIME_IS_REQUIRED = false;

    public static final boolean APPMETEREDEVENTS_IS_REQUIRED = false;

  }

}
