/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAlternateName alternateName}</li>
 * <li>{@link #getMinRequired minRequired}</li>
 * <li>{@link #getMaxAllowed maxAllowed}</li>
 * <li>{@link #getShowByDefault showByDefault}</li>
 * <li>{@link #getModifiers modifiers}</li>
 * <li>{@link #getModifierIds modifierIds}</li>
 * <li>{@link #getItems items}</li>
 * <li>{@link #getSortOrder sortOrder}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.inventory.IInventoryService
 */
@SuppressWarnings("all")
public class ModifierGroup extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the modifier group
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.String getAlternateName() {
    return genClient.cacheGet(CacheKey.alternateName);
  }

  /**
   * The minimum amount of modifiers from this group that must be applied to associated lineItems when using Register
   */
  public java.lang.Integer getMinRequired() {
    return genClient.cacheGet(CacheKey.minRequired);
  }

  /**
   * The maximum amount of modifiers from this group that can be applied to associated lineItems when using Register
   */
  public java.lang.Integer getMaxAllowed() {
    return genClient.cacheGet(CacheKey.maxAllowed);
  }

  /**
   * Whether employees will be automatically prompted to add modifiers from this category when using Register
   */
  public java.lang.Boolean getShowByDefault() {
    return genClient.cacheGet(CacheKey.showByDefault);
  }

  public java.util.List<com.clover.sdk.v3.inventory.Modifier> getModifiers() {
    return genClient.cacheGet(CacheKey.modifiers);
  }

  /**
   * An ordered, comma-separated list of modifier ids in this group. (READ ONLY)
   */
  public java.lang.String getModifierIds() {
    return genClient.cacheGet(CacheKey.modifierIds);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getItems() {
    return genClient.cacheGet(CacheKey.items);
  }

  /**
   * The ordinal value used to determine where in an ordered list this modifier group should appear relative to others.
   */
  public java.lang.Integer getSortOrder() {
    return genClient.cacheGet(CacheKey.sortOrder);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<ModifierGroup> {
    id {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    name {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    alternateName {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("alternateName", java.lang.String.class);
      }
    },
    minRequired {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("minRequired", java.lang.Integer.class);
      }
    },
    maxAllowed {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("maxAllowed", java.lang.Integer.class);
      }
    },
    showByDefault {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("showByDefault", java.lang.Boolean.class);
      }
    },
    modifiers {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractListRecord("modifiers", com.clover.sdk.v3.inventory.Modifier.JSON_CREATOR);
      }
    },
    modifierIds {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("modifierIds", java.lang.String.class);
      }
    },
    items {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractListRecord("items", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    sortOrder {
      @Override
      public Object extractValue(ModifierGroup instance) {
        return instance.genClient.extractOther("sortOrder", java.lang.Integer.class);
      }
    },
      ;
  }

  private GenericClient<ModifierGroup> genClient;

  /**
  * Constructs a new empty instance.
  */
  public ModifierGroup() {
    genClient = new GenericClient<ModifierGroup>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected ModifierGroup(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public ModifierGroup(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public ModifierGroup(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public ModifierGroup(ModifierGroup src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateNull(getName(), "name");
    genClient.validateLength(getName(), 255);

    genClient.validateLength(getAlternateName(), 255);

    if (getMinRequired() != null && ( getMinRequired() < 0)) throw new IllegalArgumentException("Invalid value for 'getMinRequired()'");

    if (getMaxAllowed() != null && ( getMaxAllowed() < 0 || getMaxAllowed() > 65535)) throw new IllegalArgumentException("Invalid value for 'getMaxAllowed()'");

    if (getSortOrder() != null && ( getSortOrder() < 0)) throw new IllegalArgumentException("Invalid value for 'getSortOrder()'");
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return genClient.cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'minRequired' field is set and is not null */
  public boolean isNotNullMinRequired() {
    return genClient.cacheValueIsNotNull(CacheKey.minRequired);
  }

  /** Checks whether the 'maxAllowed' field is set and is not null */
  public boolean isNotNullMaxAllowed() {
    return genClient.cacheValueIsNotNull(CacheKey.maxAllowed);
  }

  /** Checks whether the 'showByDefault' field is set and is not null */
  public boolean isNotNullShowByDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.showByDefault);
  }

  /** Checks whether the 'modifiers' field is set and is not null */
  public boolean isNotNullModifiers() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiers);
  }

  /** Checks whether the 'modifiers' field is set and is not null and is not empty */
  public boolean isNotEmptyModifiers() { return isNotNullModifiers() && !getModifiers().isEmpty(); }

  /** Checks whether the 'modifierIds' field is set and is not null */
  public boolean isNotNullModifierIds() {
    return genClient.cacheValueIsNotNull(CacheKey.modifierIds);
  }

  /** Checks whether the 'items' field is set and is not null */
  public boolean isNotNullItems() {
    return genClient.cacheValueIsNotNull(CacheKey.items);
  }

  /** Checks whether the 'items' field is set and is not null and is not empty */
  public boolean isNotEmptyItems() { return isNotNullItems() && !getItems().isEmpty(); }

  /** Checks whether the 'sortOrder' field is set and is not null */
  public boolean isNotNullSortOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.sortOrder);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return genClient.cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'minRequired' field has been set, however the value could be null */
  public boolean hasMinRequired() {
    return genClient.cacheHasKey(CacheKey.minRequired);
  }

  /** Checks whether the 'maxAllowed' field has been set, however the value could be null */
  public boolean hasMaxAllowed() {
    return genClient.cacheHasKey(CacheKey.maxAllowed);
  }

  /** Checks whether the 'showByDefault' field has been set, however the value could be null */
  public boolean hasShowByDefault() {
    return genClient.cacheHasKey(CacheKey.showByDefault);
  }

  /** Checks whether the 'modifiers' field has been set, however the value could be null */
  public boolean hasModifiers() {
    return genClient.cacheHasKey(CacheKey.modifiers);
  }

  /** Checks whether the 'modifierIds' field has been set, however the value could be null */
  public boolean hasModifierIds() {
    return genClient.cacheHasKey(CacheKey.modifierIds);
  }

  /** Checks whether the 'items' field has been set, however the value could be null */
  public boolean hasItems() {
    return genClient.cacheHasKey(CacheKey.items);
  }

  /** Checks whether the 'sortOrder' field has been set, however the value could be null */
  public boolean hasSortOrder() {
    return genClient.cacheHasKey(CacheKey.sortOrder);
  }


  /**
   * Sets the field 'id'.
   */
  public ModifierGroup setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public ModifierGroup setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'alternateName'.
   */
  public ModifierGroup setAlternateName(java.lang.String alternateName) {
    return genClient.setOther(alternateName, CacheKey.alternateName);
  }

  /**
   * Sets the field 'minRequired'.
   */
  public ModifierGroup setMinRequired(java.lang.Integer minRequired) {
    return genClient.setOther(minRequired, CacheKey.minRequired);
  }

  /**
   * Sets the field 'maxAllowed'.
   */
  public ModifierGroup setMaxAllowed(java.lang.Integer maxAllowed) {
    return genClient.setOther(maxAllowed, CacheKey.maxAllowed);
  }

  /**
   * Sets the field 'showByDefault'.
   */
  public ModifierGroup setShowByDefault(java.lang.Boolean showByDefault) {
    return genClient.setOther(showByDefault, CacheKey.showByDefault);
  }

  /**
   * Sets the field 'modifiers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ModifierGroup setModifiers(java.util.List<com.clover.sdk.v3.inventory.Modifier> modifiers) {
    return genClient.setArrayRecord(modifiers, CacheKey.modifiers);
  }

  /**
   * Sets the field 'modifierIds'.
   */
  public ModifierGroup setModifierIds(java.lang.String modifierIds) {
    return genClient.setOther(modifierIds, CacheKey.modifierIds);
  }

  /**
   * Sets the field 'items'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public ModifierGroup setItems(java.util.List<com.clover.sdk.v3.base.Reference> items) {
    return genClient.setArrayRecord(items, CacheKey.items);
  }

  /**
   * Sets the field 'sortOrder'.
   */
  public ModifierGroup setSortOrder(java.lang.Integer sortOrder) {
    return genClient.setOther(sortOrder, CacheKey.sortOrder);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    genClient.clear(CacheKey.alternateName);
  }
  /** Clears the 'minRequired' field, the 'has' method for this field will now return false */
  public void clearMinRequired() {
    genClient.clear(CacheKey.minRequired);
  }
  /** Clears the 'maxAllowed' field, the 'has' method for this field will now return false */
  public void clearMaxAllowed() {
    genClient.clear(CacheKey.maxAllowed);
  }
  /** Clears the 'showByDefault' field, the 'has' method for this field will now return false */
  public void clearShowByDefault() {
    genClient.clear(CacheKey.showByDefault);
  }
  /** Clears the 'modifiers' field, the 'has' method for this field will now return false */
  public void clearModifiers() {
    genClient.clear(CacheKey.modifiers);
  }
  /** Clears the 'modifierIds' field, the 'has' method for this field will now return false */
  public void clearModifierIds() {
    genClient.clear(CacheKey.modifierIds);
  }
  /** Clears the 'items' field, the 'has' method for this field will now return false */
  public void clearItems() {
    genClient.clear(CacheKey.items);
  }
  /** Clears the 'sortOrder' field, the 'has' method for this field will now return false */
  public void clearSortOrder() {
    genClient.clear(CacheKey.sortOrder);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public ModifierGroup copyChanges() {
    ModifierGroup copy = new ModifierGroup();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(ModifierGroup src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new ModifierGroup(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<ModifierGroup> CREATOR = new android.os.Parcelable.Creator<ModifierGroup>() {
    @Override
    public ModifierGroup createFromParcel(android.os.Parcel in) {
      ModifierGroup instance = new ModifierGroup(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public ModifierGroup[] newArray(int size) {
      return new ModifierGroup[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<ModifierGroup> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<ModifierGroup>() {
    @Override
    public ModifierGroup create(org.json.JSONObject jsonObject) {
      return new ModifierGroup(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 255;
    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 255;
    public static final boolean MINREQUIRED_IS_REQUIRED = false;
    public static final long MINREQUIRED_MIN = 0;
    public static final boolean MAXALLOWED_IS_REQUIRED = false;
    public static final long MAXALLOWED_MIN = 0;
    public static final long MAXALLOWED_MAX = 65535;
    public static final boolean SHOWBYDEFAULT_IS_REQUIRED = false;
    public static final boolean MODIFIERS_IS_REQUIRED = false;
    public static final boolean MODIFIERIDS_IS_REQUIRED = false;
    public static final boolean ITEMS_IS_REQUIRED = false;
    public static final boolean SORTORDER_IS_REQUIRED = false;
    public static final long SORTORDER_MIN = 0;

  }

}
