/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * This class represents the association between an item and an option
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getOption option}</li>
 * <li>{@link #getItem item}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.inventory.IInventoryService
 */
@SuppressWarnings("all")
public class OptionItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Reference to an option
   */
  public com.clover.sdk.v3.base.Reference getOption() {
    return genClient.cacheGet(CacheKey.option);
  }

  /**
   * Reference to an item
   */
  public com.clover.sdk.v3.base.Reference getItem() {
    return genClient.cacheGet(CacheKey.item);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<OptionItem> {
    option {
      @Override
      public Object extractValue(OptionItem instance) {
        return instance.genClient.extractRecord("option", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    item {
      @Override
      public Object extractValue(OptionItem instance) {
        return instance.genClient.extractRecord("item", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
      ;
  }

  private GenericClient<OptionItem> genClient;

  /**
  * Constructs a new empty instance.
  */
  public OptionItem() {
    genClient = new GenericClient<OptionItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected OptionItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public OptionItem(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public OptionItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public OptionItem(OptionItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'option' field is set and is not null */
  public boolean isNotNullOption() {
    return genClient.cacheValueIsNotNull(CacheKey.option);
  }

  /** Checks whether the 'item' field is set and is not null */
  public boolean isNotNullItem() {
    return genClient.cacheValueIsNotNull(CacheKey.item);
  }



  /** Checks whether the 'option' field has been set, however the value could be null */
  public boolean hasOption() {
    return genClient.cacheHasKey(CacheKey.option);
  }

  /** Checks whether the 'item' field has been set, however the value could be null */
  public boolean hasItem() {
    return genClient.cacheHasKey(CacheKey.item);
  }


  /**
   * Sets the field 'option'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public OptionItem setOption(com.clover.sdk.v3.base.Reference option) {
    return genClient.setRecord(option, CacheKey.option);
  }

  /**
   * Sets the field 'item'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public OptionItem setItem(com.clover.sdk.v3.base.Reference item) {
    return genClient.setRecord(item, CacheKey.item);
  }


  /** Clears the 'option' field, the 'has' method for this field will now return false */
  public void clearOption() {
    genClient.clear(CacheKey.option);
  }
  /** Clears the 'item' field, the 'has' method for this field will now return false */
  public void clearItem() {
    genClient.clear(CacheKey.item);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public OptionItem copyChanges() {
    OptionItem copy = new OptionItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(OptionItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new OptionItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<OptionItem> CREATOR = new android.os.Parcelable.Creator<OptionItem>() {
    @Override
    public OptionItem createFromParcel(android.os.Parcel in) {
      OptionItem instance = new OptionItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public OptionItem[] newArray(int size) {
      return new OptionItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<OptionItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<OptionItem>() {
    @Override
    public OptionItem create(org.json.JSONObject jsonObject) {
      return new OptionItem(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean OPTION_IS_REQUIRED = false;
    public static final boolean ITEM_IS_REQUIRED = false;

  }

}
