/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getOwner owner}</li>
 * <li>{@link #getAddress address}</li>
 * <li>{@link #getMerchantPlan merchantPlan}</li>
 * <li>{@link #getDefaultCurrency defaultCurrency}</li>
 * <li>{@link #getPhoneNumber phoneNumber}</li>
 * <li>{@link #getWebsite website}</li>
 * <li>{@link #getCustomerContactEmail customerContactEmail}</li>
 * <li>{@link #getLogos logos}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getProperties properties}</li>
 * <li>{@link #getGateway gateway}</li>
 * <li>{@link #getTipSuggestions tipSuggestions}</li>
 * <li>{@link #getEmployees employees}</li>
 * <li>{@link #getItems items}</li>
 * <li>{@link #getTags tags}</li>
 * <li>{@link #getTenders tenders}</li>
 * <li>{@link #getShifts shifts}</li>
 * <li>{@link #getOrders orders}</li>
 * <li>{@link #getPayments payments}</li>
 * <li>{@link #getTaxRates taxRates}</li>
 * <li>{@link #getPrinters printers}</li>
 * <li>{@link #getModifierGroups modifierGroups}</li>
 * <li>{@link #getOrderTypes orderTypes}</li>
 * <li>{@link #getReseller reseller}</li>
 * <li>{@link #getOpeningHours opening_hours}</li>
 * <li>{@link #getBusinessTypeCode businessTypeCode}</li>
 * <li>{@link #getIsBillable isBillable}</li>
 * <li>{@link #getDevices devices}</li>
 * <li>{@link #getMerchantGroups merchantGroups}</li>
 * <li>{@link #getPartnerApp partnerApp}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Merchant extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the merchant
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * The account that owns this merchant
   */
  public com.clover.sdk.v3.employees.Employee getOwner() {
    return genClient.cacheGet(CacheKey.owner);
  }

  /**
   * The address of the merchant.
   */
  public com.clover.sdk.v3.base.Address getAddress() {
    return genClient.cacheGet(CacheKey.address);
  }

  public com.clover.sdk.v3.merchant.MerchantPlan getMerchantPlan() {
    return genClient.cacheGet(CacheKey.merchantPlan);
  }

  public java.lang.String getDefaultCurrency() {
    return genClient.cacheGet(CacheKey.defaultCurrency);
  }

  public java.lang.String getPhoneNumber() {
    return genClient.cacheGet(CacheKey.phoneNumber);
  }

  public java.lang.String getWebsite() {
    return genClient.cacheGet(CacheKey.website);
  }

  /**
   * Email address for customers to contact merchant through
   */
  public java.lang.String getCustomerContactEmail() {
    return genClient.cacheGet(CacheKey.customerContactEmail);
  }

  public java.util.List<com.clover.sdk.v3.merchant.Logo> getLogos() {
    return genClient.cacheGet(CacheKey.logos);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public com.clover.sdk.v3.merchant.MerchantProperties getProperties() {
    return genClient.cacheGet(CacheKey.properties);
  }

  public com.clover.sdk.v3.merchant.Gateway getGateway() {
    return genClient.cacheGet(CacheKey.gateway);
  }

  public java.util.List<com.clover.sdk.v3.merchant.TipSuggestion> getTipSuggestions() {
    return genClient.cacheGet(CacheKey.tipSuggestions);
  }

  /**
   * This merchant's employees
   */
  public java.util.List<com.clover.sdk.v3.employees.Employee> getEmployees() {
    return genClient.cacheGet(CacheKey.employees);
  }

  /**
   * This merchant's inventory items
   */
  public java.util.List<com.clover.sdk.v3.inventory.Item> getItems() {
    return genClient.cacheGet(CacheKey.items);
  }

  /**
   * This merchant's inventory tags
   */
  public java.util.List<com.clover.sdk.v3.inventory.Tag> getTags() {
    return genClient.cacheGet(CacheKey.tags);
  }

  /**
   * This merchant's supported tenders
   */
  public java.util.List<com.clover.sdk.v3.base.Tender> getTenders() {
    return genClient.cacheGet(CacheKey.tenders);
  }

  /**
   * This merchant's employees' shifts
   */
  public java.util.List<com.clover.sdk.v3.employees.Shift> getShifts() {
    return genClient.cacheGet(CacheKey.shifts);
  }

  /**
   * This merchant's orders
   */
  public java.util.List<com.clover.sdk.v3.order.Order> getOrders() {
    return genClient.cacheGet(CacheKey.orders);
  }

  /**
   * This merchant's order payments
   */
  public java.util.List<com.clover.sdk.v3.payments.Payment> getPayments() {
    return genClient.cacheGet(CacheKey.payments);
  }

  public java.util.List<com.clover.sdk.v3.inventory.TaxRate> getTaxRates() {
    return genClient.cacheGet(CacheKey.taxRates);
  }

  public java.util.List<com.clover.sdk.v3.printer.Printer> getPrinters() {
    return genClient.cacheGet(CacheKey.printers);
  }

  public java.util.List<com.clover.sdk.v3.inventory.ModifierGroup> getModifierGroups() {
    return genClient.cacheGet(CacheKey.modifierGroups);
  }

  public java.util.List<com.clover.sdk.v3.order.OrderType> getOrderTypes() {
    return genClient.cacheGet(CacheKey.orderTypes);
  }

  /**
   * The merchant's reseller
   */
  public com.clover.sdk.v3.base.Reference getReseller() {
    return genClient.cacheGet(CacheKey.reseller);
  }

  /**
   * This merchant's opening hours
   */
  public java.util.List<com.clover.sdk.v3.hours.HoursSet> getOpeningHours() {
    return genClient.cacheGet(CacheKey.opening_hours);
  }

  /**
   * The business type of the merchant
   */
  public com.clover.sdk.v3.base.BusinessTypeCode getBusinessTypeCode() {
    return genClient.cacheGet(CacheKey.businessTypeCode);
  }

  /**
   * Returns true when the merchant is billable.
   */
  public java.lang.Boolean getIsBillable() {
    return genClient.cacheGet(CacheKey.isBillable);
  }

  /**
   * A list of devices a merchant owns
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getDevices() {
    return genClient.cacheGet(CacheKey.devices);
  }

  /**
   * A list of merchant groups a merchant belongs to
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getMerchantGroups() {
    return genClient.cacheGet(CacheKey.merchantGroups);
  }

  /**
   * The partner app/solution with which this merchant is primarily associated
   */
  public com.clover.sdk.v3.base.Reference getPartnerApp() {
    return genClient.cacheGet(CacheKey.partnerApp);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<Merchant> {
    id {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    name {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    owner {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("owner", com.clover.sdk.v3.employees.Employee.JSON_CREATOR);
      }
    },
    address {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("address", com.clover.sdk.v3.base.Address.JSON_CREATOR);
      }
    },
    merchantPlan {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("merchantPlan", com.clover.sdk.v3.merchant.MerchantPlan.JSON_CREATOR);
      }
    },
    defaultCurrency {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("defaultCurrency", java.lang.String.class);
      }
    },
    phoneNumber {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("phoneNumber", java.lang.String.class);
      }
    },
    website {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("website", java.lang.String.class);
      }
    },
    customerContactEmail {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("customerContactEmail", java.lang.String.class);
      }
    },
    logos {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("logos", com.clover.sdk.v3.merchant.Logo.JSON_CREATOR);
      }
    },
    createdTime {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("createdTime", java.lang.Long.class);
      }
    },
    properties {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("properties", com.clover.sdk.v3.merchant.MerchantProperties.JSON_CREATOR);
      }
    },
    gateway {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("gateway", com.clover.sdk.v3.merchant.Gateway.JSON_CREATOR);
      }
    },
    tipSuggestions {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("tipSuggestions", com.clover.sdk.v3.merchant.TipSuggestion.JSON_CREATOR);
      }
    },
    employees {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("employees", com.clover.sdk.v3.employees.Employee.JSON_CREATOR);
      }
    },
    items {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("items", com.clover.sdk.v3.inventory.Item.JSON_CREATOR);
      }
    },
    tags {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("tags", com.clover.sdk.v3.inventory.Tag.JSON_CREATOR);
      }
    },
    tenders {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("tenders", com.clover.sdk.v3.base.Tender.JSON_CREATOR);
      }
    },
    shifts {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("shifts", com.clover.sdk.v3.employees.Shift.JSON_CREATOR);
      }
    },
    orders {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("orders", com.clover.sdk.v3.order.Order.JSON_CREATOR);
      }
    },
    payments {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("payments", com.clover.sdk.v3.payments.Payment.JSON_CREATOR);
      }
    },
    taxRates {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("taxRates", com.clover.sdk.v3.inventory.TaxRate.JSON_CREATOR);
      }
    },
    printers {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("printers", com.clover.sdk.v3.printer.Printer.JSON_CREATOR);
      }
    },
    modifierGroups {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("modifierGroups", com.clover.sdk.v3.inventory.ModifierGroup.JSON_CREATOR);
      }
    },
    orderTypes {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("orderTypes", com.clover.sdk.v3.order.OrderType.JSON_CREATOR);
      }
    },
    reseller {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("reseller", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    opening_hours {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("opening_hours", com.clover.sdk.v3.hours.HoursSet.JSON_CREATOR);
      }
    },
    businessTypeCode {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractEnum("businessTypeCode", com.clover.sdk.v3.base.BusinessTypeCode.class);
      }
    },
    isBillable {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractOther("isBillable", java.lang.Boolean.class);
      }
    },
    devices {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("devices", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    merchantGroups {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractListRecord("merchantGroups", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    partnerApp {
      @Override
      public Object extractValue(Merchant instance) {
        return instance.genClient.extractRecord("partnerApp", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
      ;
  }

  private GenericClient<Merchant> genClient;

  /**
  * Constructs a new empty instance.
  */
  public Merchant() {
    genClient = new GenericClient<Merchant>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected Merchant(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Merchant(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Merchant(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Merchant(Merchant src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateNull(getName(), "name");
    genClient.validateLength(getName(), 127);

    genClient.validateNull(getOwner(), "owner");

    genClient.validateLength(getDefaultCurrency(), 3);

    genClient.validateLength(getPhoneNumber(), 21);

    genClient.validateLength(getWebsite(), 255);

    genClient.validateLength(getCustomerContactEmail(), 127);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'owner' field is set and is not null */
  public boolean isNotNullOwner() {
    return genClient.cacheValueIsNotNull(CacheKey.owner);
  }

  /** Checks whether the 'address' field is set and is not null */
  public boolean isNotNullAddress() {
    return genClient.cacheValueIsNotNull(CacheKey.address);
  }

  /** Checks whether the 'merchantPlan' field is set and is not null */
  public boolean isNotNullMerchantPlan() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantPlan);
  }

  /** Checks whether the 'defaultCurrency' field is set and is not null */
  public boolean isNotNullDefaultCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'phoneNumber' field is set and is not null */
  public boolean isNotNullPhoneNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.phoneNumber);
  }

  /** Checks whether the 'website' field is set and is not null */
  public boolean isNotNullWebsite() {
    return genClient.cacheValueIsNotNull(CacheKey.website);
  }

  /** Checks whether the 'customerContactEmail' field is set and is not null */
  public boolean isNotNullCustomerContactEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.customerContactEmail);
  }

  /** Checks whether the 'logos' field is set and is not null */
  public boolean isNotNullLogos() {
    return genClient.cacheValueIsNotNull(CacheKey.logos);
  }

  /** Checks whether the 'logos' field is set and is not null and is not empty */
  public boolean isNotEmptyLogos() { return isNotNullLogos() && !getLogos().isEmpty(); }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'properties' field is set and is not null */
  public boolean isNotNullProperties() {
    return genClient.cacheValueIsNotNull(CacheKey.properties);
  }

  /** Checks whether the 'gateway' field is set and is not null */
  public boolean isNotNullGateway() {
    return genClient.cacheValueIsNotNull(CacheKey.gateway);
  }

  /** Checks whether the 'tipSuggestions' field is set and is not null */
  public boolean isNotNullTipSuggestions() {
    return genClient.cacheValueIsNotNull(CacheKey.tipSuggestions);
  }

  /** Checks whether the 'tipSuggestions' field is set and is not null and is not empty */
  public boolean isNotEmptyTipSuggestions() { return isNotNullTipSuggestions() && !getTipSuggestions().isEmpty(); }

  /** Checks whether the 'employees' field is set and is not null */
  public boolean isNotNullEmployees() {
    return genClient.cacheValueIsNotNull(CacheKey.employees);
  }

  /** Checks whether the 'employees' field is set and is not null and is not empty */
  public boolean isNotEmptyEmployees() { return isNotNullEmployees() && !getEmployees().isEmpty(); }

  /** Checks whether the 'items' field is set and is not null */
  public boolean isNotNullItems() {
    return genClient.cacheValueIsNotNull(CacheKey.items);
  }

  /** Checks whether the 'items' field is set and is not null and is not empty */
  public boolean isNotEmptyItems() { return isNotNullItems() && !getItems().isEmpty(); }

  /** Checks whether the 'tags' field is set and is not null */
  public boolean isNotNullTags() {
    return genClient.cacheValueIsNotNull(CacheKey.tags);
  }

  /** Checks whether the 'tags' field is set and is not null and is not empty */
  public boolean isNotEmptyTags() { return isNotNullTags() && !getTags().isEmpty(); }

  /** Checks whether the 'tenders' field is set and is not null */
  public boolean isNotNullTenders() {
    return genClient.cacheValueIsNotNull(CacheKey.tenders);
  }

  /** Checks whether the 'tenders' field is set and is not null and is not empty */
  public boolean isNotEmptyTenders() { return isNotNullTenders() && !getTenders().isEmpty(); }

  /** Checks whether the 'shifts' field is set and is not null */
  public boolean isNotNullShifts() {
    return genClient.cacheValueIsNotNull(CacheKey.shifts);
  }

  /** Checks whether the 'shifts' field is set and is not null and is not empty */
  public boolean isNotEmptyShifts() { return isNotNullShifts() && !getShifts().isEmpty(); }

  /** Checks whether the 'orders' field is set and is not null */
  public boolean isNotNullOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.orders);
  }

  /** Checks whether the 'orders' field is set and is not null and is not empty */
  public boolean isNotEmptyOrders() { return isNotNullOrders() && !getOrders().isEmpty(); }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() { return isNotNullPayments() && !getPayments().isEmpty(); }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return genClient.cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() { return isNotNullTaxRates() && !getTaxRates().isEmpty(); }

  /** Checks whether the 'printers' field is set and is not null */
  public boolean isNotNullPrinters() {
    return genClient.cacheValueIsNotNull(CacheKey.printers);
  }

  /** Checks whether the 'printers' field is set and is not null and is not empty */
  public boolean isNotEmptyPrinters() { return isNotNullPrinters() && !getPrinters().isEmpty(); }

  /** Checks whether the 'modifierGroups' field is set and is not null */
  public boolean isNotNullModifierGroups() {
    return genClient.cacheValueIsNotNull(CacheKey.modifierGroups);
  }

  /** Checks whether the 'modifierGroups' field is set and is not null and is not empty */
  public boolean isNotEmptyModifierGroups() { return isNotNullModifierGroups() && !getModifierGroups().isEmpty(); }

  /** Checks whether the 'orderTypes' field is set and is not null */
  public boolean isNotNullOrderTypes() {
    return genClient.cacheValueIsNotNull(CacheKey.orderTypes);
  }

  /** Checks whether the 'orderTypes' field is set and is not null and is not empty */
  public boolean isNotEmptyOrderTypes() { return isNotNullOrderTypes() && !getOrderTypes().isEmpty(); }

  /** Checks whether the 'reseller' field is set and is not null */
  public boolean isNotNullReseller() {
    return genClient.cacheValueIsNotNull(CacheKey.reseller);
  }

  /** Checks whether the 'opening_hours' field is set and is not null */
  public boolean isNotNullOpeningHours() {
    return genClient.cacheValueIsNotNull(CacheKey.opening_hours);
  }

  /** Checks whether the 'opening_hours' field is set and is not null and is not empty */
  public boolean isNotEmptyOpeningHours() { return isNotNullOpeningHours() && !getOpeningHours().isEmpty(); }

  /** Checks whether the 'businessTypeCode' field is set and is not null */
  public boolean isNotNullBusinessTypeCode() {
    return genClient.cacheValueIsNotNull(CacheKey.businessTypeCode);
  }

  /** Checks whether the 'isBillable' field is set and is not null */
  public boolean isNotNullIsBillable() {
    return genClient.cacheValueIsNotNull(CacheKey.isBillable);
  }

  /** Checks whether the 'devices' field is set and is not null */
  public boolean isNotNullDevices() {
    return genClient.cacheValueIsNotNull(CacheKey.devices);
  }

  /** Checks whether the 'devices' field is set and is not null and is not empty */
  public boolean isNotEmptyDevices() { return isNotNullDevices() && !getDevices().isEmpty(); }

  /** Checks whether the 'merchantGroups' field is set and is not null */
  public boolean isNotNullMerchantGroups() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantGroups);
  }

  /** Checks whether the 'merchantGroups' field is set and is not null and is not empty */
  public boolean isNotEmptyMerchantGroups() { return isNotNullMerchantGroups() && !getMerchantGroups().isEmpty(); }

  /** Checks whether the 'partnerApp' field is set and is not null */
  public boolean isNotNullPartnerApp() {
    return genClient.cacheValueIsNotNull(CacheKey.partnerApp);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'owner' field has been set, however the value could be null */
  public boolean hasOwner() {
    return genClient.cacheHasKey(CacheKey.owner);
  }

  /** Checks whether the 'address' field has been set, however the value could be null */
  public boolean hasAddress() {
    return genClient.cacheHasKey(CacheKey.address);
  }

  /** Checks whether the 'merchantPlan' field has been set, however the value could be null */
  public boolean hasMerchantPlan() {
    return genClient.cacheHasKey(CacheKey.merchantPlan);
  }

  /** Checks whether the 'defaultCurrency' field has been set, however the value could be null */
  public boolean hasDefaultCurrency() {
    return genClient.cacheHasKey(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'phoneNumber' field has been set, however the value could be null */
  public boolean hasPhoneNumber() {
    return genClient.cacheHasKey(CacheKey.phoneNumber);
  }

  /** Checks whether the 'website' field has been set, however the value could be null */
  public boolean hasWebsite() {
    return genClient.cacheHasKey(CacheKey.website);
  }

  /** Checks whether the 'customerContactEmail' field has been set, however the value could be null */
  public boolean hasCustomerContactEmail() {
    return genClient.cacheHasKey(CacheKey.customerContactEmail);
  }

  /** Checks whether the 'logos' field has been set, however the value could be null */
  public boolean hasLogos() {
    return genClient.cacheHasKey(CacheKey.logos);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'properties' field has been set, however the value could be null */
  public boolean hasProperties() {
    return genClient.cacheHasKey(CacheKey.properties);
  }

  /** Checks whether the 'gateway' field has been set, however the value could be null */
  public boolean hasGateway() {
    return genClient.cacheHasKey(CacheKey.gateway);
  }

  /** Checks whether the 'tipSuggestions' field has been set, however the value could be null */
  public boolean hasTipSuggestions() {
    return genClient.cacheHasKey(CacheKey.tipSuggestions);
  }

  /** Checks whether the 'employees' field has been set, however the value could be null */
  public boolean hasEmployees() {
    return genClient.cacheHasKey(CacheKey.employees);
  }

  /** Checks whether the 'items' field has been set, however the value could be null */
  public boolean hasItems() {
    return genClient.cacheHasKey(CacheKey.items);
  }

  /** Checks whether the 'tags' field has been set, however the value could be null */
  public boolean hasTags() {
    return genClient.cacheHasKey(CacheKey.tags);
  }

  /** Checks whether the 'tenders' field has been set, however the value could be null */
  public boolean hasTenders() {
    return genClient.cacheHasKey(CacheKey.tenders);
  }

  /** Checks whether the 'shifts' field has been set, however the value could be null */
  public boolean hasShifts() {
    return genClient.cacheHasKey(CacheKey.shifts);
  }

  /** Checks whether the 'orders' field has been set, however the value could be null */
  public boolean hasOrders() {
    return genClient.cacheHasKey(CacheKey.orders);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return genClient.cacheHasKey(CacheKey.payments);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return genClient.cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'printers' field has been set, however the value could be null */
  public boolean hasPrinters() {
    return genClient.cacheHasKey(CacheKey.printers);
  }

  /** Checks whether the 'modifierGroups' field has been set, however the value could be null */
  public boolean hasModifierGroups() {
    return genClient.cacheHasKey(CacheKey.modifierGroups);
  }

  /** Checks whether the 'orderTypes' field has been set, however the value could be null */
  public boolean hasOrderTypes() {
    return genClient.cacheHasKey(CacheKey.orderTypes);
  }

  /** Checks whether the 'reseller' field has been set, however the value could be null */
  public boolean hasReseller() {
    return genClient.cacheHasKey(CacheKey.reseller);
  }

  /** Checks whether the 'opening_hours' field has been set, however the value could be null */
  public boolean hasOpeningHours() {
    return genClient.cacheHasKey(CacheKey.opening_hours);
  }

  /** Checks whether the 'businessTypeCode' field has been set, however the value could be null */
  public boolean hasBusinessTypeCode() {
    return genClient.cacheHasKey(CacheKey.businessTypeCode);
  }

  /** Checks whether the 'isBillable' field has been set, however the value could be null */
  public boolean hasIsBillable() {
    return genClient.cacheHasKey(CacheKey.isBillable);
  }

  /** Checks whether the 'devices' field has been set, however the value could be null */
  public boolean hasDevices() {
    return genClient.cacheHasKey(CacheKey.devices);
  }

  /** Checks whether the 'merchantGroups' field has been set, however the value could be null */
  public boolean hasMerchantGroups() {
    return genClient.cacheHasKey(CacheKey.merchantGroups);
  }

  /** Checks whether the 'partnerApp' field has been set, however the value could be null */
  public boolean hasPartnerApp() {
    return genClient.cacheHasKey(CacheKey.partnerApp);
  }


  /**
   * Sets the field 'id'.
   */
  public Merchant setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public Merchant setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'owner'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setOwner(com.clover.sdk.v3.employees.Employee owner) {
    return genClient.setRecord(owner, CacheKey.owner);
  }

  /**
   * Sets the field 'address'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setAddress(com.clover.sdk.v3.base.Address address) {
    return genClient.setRecord(address, CacheKey.address);
  }

  /**
   * Sets the field 'merchantPlan'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setMerchantPlan(com.clover.sdk.v3.merchant.MerchantPlan merchantPlan) {
    return genClient.setRecord(merchantPlan, CacheKey.merchantPlan);
  }

  /**
   * Sets the field 'defaultCurrency'.
   */
  public Merchant setDefaultCurrency(java.lang.String defaultCurrency) {
    return genClient.setOther(defaultCurrency, CacheKey.defaultCurrency);
  }

  /**
   * Sets the field 'phoneNumber'.
   */
  public Merchant setPhoneNumber(java.lang.String phoneNumber) {
    return genClient.setOther(phoneNumber, CacheKey.phoneNumber);
  }

  /**
   * Sets the field 'website'.
   */
  public Merchant setWebsite(java.lang.String website) {
    return genClient.setOther(website, CacheKey.website);
  }

  /**
   * Sets the field 'customerContactEmail'.
   */
  public Merchant setCustomerContactEmail(java.lang.String customerContactEmail) {
    return genClient.setOther(customerContactEmail, CacheKey.customerContactEmail);
  }

  /**
   * Sets the field 'logos'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setLogos(java.util.List<com.clover.sdk.v3.merchant.Logo> logos) {
    return genClient.setArrayRecord(logos, CacheKey.logos);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Merchant setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'properties'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setProperties(com.clover.sdk.v3.merchant.MerchantProperties properties) {
    return genClient.setRecord(properties, CacheKey.properties);
  }

  /**
   * Sets the field 'gateway'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setGateway(com.clover.sdk.v3.merchant.Gateway gateway) {
    return genClient.setRecord(gateway, CacheKey.gateway);
  }

  /**
   * Sets the field 'tipSuggestions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setTipSuggestions(java.util.List<com.clover.sdk.v3.merchant.TipSuggestion> tipSuggestions) {
    return genClient.setArrayRecord(tipSuggestions, CacheKey.tipSuggestions);
  }

  /**
   * Sets the field 'employees'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setEmployees(java.util.List<com.clover.sdk.v3.employees.Employee> employees) {
    return genClient.setArrayRecord(employees, CacheKey.employees);
  }

  /**
   * Sets the field 'items'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setItems(java.util.List<com.clover.sdk.v3.inventory.Item> items) {
    return genClient.setArrayRecord(items, CacheKey.items);
  }

  /**
   * Sets the field 'tags'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setTags(java.util.List<com.clover.sdk.v3.inventory.Tag> tags) {
    return genClient.setArrayRecord(tags, CacheKey.tags);
  }

  /**
   * Sets the field 'tenders'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setTenders(java.util.List<com.clover.sdk.v3.base.Tender> tenders) {
    return genClient.setArrayRecord(tenders, CacheKey.tenders);
  }

  /**
   * Sets the field 'shifts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setShifts(java.util.List<com.clover.sdk.v3.employees.Shift> shifts) {
    return genClient.setArrayRecord(shifts, CacheKey.shifts);
  }

  /**
   * Sets the field 'orders'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setOrders(java.util.List<com.clover.sdk.v3.order.Order> orders) {
    return genClient.setArrayRecord(orders, CacheKey.orders);
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setPayments(java.util.List<com.clover.sdk.v3.payments.Payment> payments) {
    return genClient.setArrayRecord(payments, CacheKey.payments);
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setTaxRates(java.util.List<com.clover.sdk.v3.inventory.TaxRate> taxRates) {
    return genClient.setArrayRecord(taxRates, CacheKey.taxRates);
  }

  /**
   * Sets the field 'printers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setPrinters(java.util.List<com.clover.sdk.v3.printer.Printer> printers) {
    return genClient.setArrayRecord(printers, CacheKey.printers);
  }

  /**
   * Sets the field 'modifierGroups'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setModifierGroups(java.util.List<com.clover.sdk.v3.inventory.ModifierGroup> modifierGroups) {
    return genClient.setArrayRecord(modifierGroups, CacheKey.modifierGroups);
  }

  /**
   * Sets the field 'orderTypes'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setOrderTypes(java.util.List<com.clover.sdk.v3.order.OrderType> orderTypes) {
    return genClient.setArrayRecord(orderTypes, CacheKey.orderTypes);
  }

  /**
   * Sets the field 'reseller'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setReseller(com.clover.sdk.v3.base.Reference reseller) {
    return genClient.setRecord(reseller, CacheKey.reseller);
  }

  /**
   * Sets the field 'opening_hours'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setOpeningHours(java.util.List<com.clover.sdk.v3.hours.HoursSet> opening_hours) {
    return genClient.setArrayRecord(opening_hours, CacheKey.opening_hours);
  }

  /**
   * Sets the field 'businessTypeCode'.
   */
  public Merchant setBusinessTypeCode(com.clover.sdk.v3.base.BusinessTypeCode businessTypeCode) {
    return genClient.setOther(businessTypeCode, CacheKey.businessTypeCode);
  }

  /**
   * Sets the field 'isBillable'.
   */
  public Merchant setIsBillable(java.lang.Boolean isBillable) {
    return genClient.setOther(isBillable, CacheKey.isBillable);
  }

  /**
   * Sets the field 'devices'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setDevices(java.util.List<com.clover.sdk.v3.base.Reference> devices) {
    return genClient.setArrayRecord(devices, CacheKey.devices);
  }

  /**
   * Sets the field 'merchantGroups'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Merchant setMerchantGroups(java.util.List<com.clover.sdk.v3.base.Reference> merchantGroups) {
    return genClient.setArrayRecord(merchantGroups, CacheKey.merchantGroups);
  }

  /**
   * Sets the field 'partnerApp'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Merchant setPartnerApp(com.clover.sdk.v3.base.Reference partnerApp) {
    return genClient.setRecord(partnerApp, CacheKey.partnerApp);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'owner' field, the 'has' method for this field will now return false */
  public void clearOwner() {
    genClient.clear(CacheKey.owner);
  }
  /** Clears the 'address' field, the 'has' method for this field will now return false */
  public void clearAddress() {
    genClient.clear(CacheKey.address);
  }
  /** Clears the 'merchantPlan' field, the 'has' method for this field will now return false */
  public void clearMerchantPlan() {
    genClient.clear(CacheKey.merchantPlan);
  }
  /** Clears the 'defaultCurrency' field, the 'has' method for this field will now return false */
  public void clearDefaultCurrency() {
    genClient.clear(CacheKey.defaultCurrency);
  }
  /** Clears the 'phoneNumber' field, the 'has' method for this field will now return false */
  public void clearPhoneNumber() {
    genClient.clear(CacheKey.phoneNumber);
  }
  /** Clears the 'website' field, the 'has' method for this field will now return false */
  public void clearWebsite() {
    genClient.clear(CacheKey.website);
  }
  /** Clears the 'customerContactEmail' field, the 'has' method for this field will now return false */
  public void clearCustomerContactEmail() {
    genClient.clear(CacheKey.customerContactEmail);
  }
  /** Clears the 'logos' field, the 'has' method for this field will now return false */
  public void clearLogos() {
    genClient.clear(CacheKey.logos);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'properties' field, the 'has' method for this field will now return false */
  public void clearProperties() {
    genClient.clear(CacheKey.properties);
  }
  /** Clears the 'gateway' field, the 'has' method for this field will now return false */
  public void clearGateway() {
    genClient.clear(CacheKey.gateway);
  }
  /** Clears the 'tipSuggestions' field, the 'has' method for this field will now return false */
  public void clearTipSuggestions() {
    genClient.clear(CacheKey.tipSuggestions);
  }
  /** Clears the 'employees' field, the 'has' method for this field will now return false */
  public void clearEmployees() {
    genClient.clear(CacheKey.employees);
  }
  /** Clears the 'items' field, the 'has' method for this field will now return false */
  public void clearItems() {
    genClient.clear(CacheKey.items);
  }
  /** Clears the 'tags' field, the 'has' method for this field will now return false */
  public void clearTags() {
    genClient.clear(CacheKey.tags);
  }
  /** Clears the 'tenders' field, the 'has' method for this field will now return false */
  public void clearTenders() {
    genClient.clear(CacheKey.tenders);
  }
  /** Clears the 'shifts' field, the 'has' method for this field will now return false */
  public void clearShifts() {
    genClient.clear(CacheKey.shifts);
  }
  /** Clears the 'orders' field, the 'has' method for this field will now return false */
  public void clearOrders() {
    genClient.clear(CacheKey.orders);
  }
  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    genClient.clear(CacheKey.payments);
  }
  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    genClient.clear(CacheKey.taxRates);
  }
  /** Clears the 'printers' field, the 'has' method for this field will now return false */
  public void clearPrinters() {
    genClient.clear(CacheKey.printers);
  }
  /** Clears the 'modifierGroups' field, the 'has' method for this field will now return false */
  public void clearModifierGroups() {
    genClient.clear(CacheKey.modifierGroups);
  }
  /** Clears the 'orderTypes' field, the 'has' method for this field will now return false */
  public void clearOrderTypes() {
    genClient.clear(CacheKey.orderTypes);
  }
  /** Clears the 'reseller' field, the 'has' method for this field will now return false */
  public void clearReseller() {
    genClient.clear(CacheKey.reseller);
  }
  /** Clears the 'opening_hours' field, the 'has' method for this field will now return false */
  public void clearOpeningHours() {
    genClient.clear(CacheKey.opening_hours);
  }
  /** Clears the 'businessTypeCode' field, the 'has' method for this field will now return false */
  public void clearBusinessTypeCode() {
    genClient.clear(CacheKey.businessTypeCode);
  }
  /** Clears the 'isBillable' field, the 'has' method for this field will now return false */
  public void clearIsBillable() {
    genClient.clear(CacheKey.isBillable);
  }
  /** Clears the 'devices' field, the 'has' method for this field will now return false */
  public void clearDevices() {
    genClient.clear(CacheKey.devices);
  }
  /** Clears the 'merchantGroups' field, the 'has' method for this field will now return false */
  public void clearMerchantGroups() {
    genClient.clear(CacheKey.merchantGroups);
  }
  /** Clears the 'partnerApp' field, the 'has' method for this field will now return false */
  public void clearPartnerApp() {
    genClient.clear(CacheKey.partnerApp);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Merchant copyChanges() {
    Merchant copy = new Merchant();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Merchant src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Merchant(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Merchant> CREATOR = new android.os.Parcelable.Creator<Merchant>() {
    @Override
    public Merchant createFromParcel(android.os.Parcel in) {
      Merchant instance = new Merchant(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Merchant[] newArray(int size) {
      return new Merchant[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Merchant> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Merchant>() {
    @Override
    public Merchant create(org.json.JSONObject jsonObject) {
      return new Merchant(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean OWNER_IS_REQUIRED = true;
    public static final boolean ADDRESS_IS_REQUIRED = false;
    public static final boolean MERCHANTPLAN_IS_REQUIRED = false;
    public static final boolean DEFAULTCURRENCY_IS_REQUIRED = false;
    public static final long DEFAULTCURRENCY_MAX_LEN = 3;
    public static final boolean PHONENUMBER_IS_REQUIRED = false;
    public static final long PHONENUMBER_MAX_LEN = 21;
    public static final boolean WEBSITE_IS_REQUIRED = false;
    public static final long WEBSITE_MAX_LEN = 255;
    public static final boolean CUSTOMERCONTACTEMAIL_IS_REQUIRED = false;
    public static final long CUSTOMERCONTACTEMAIL_MAX_LEN = 127;
    public static final boolean LOGOS_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean PROPERTIES_IS_REQUIRED = false;
    public static final boolean GATEWAY_IS_REQUIRED = false;
    public static final boolean TIPSUGGESTIONS_IS_REQUIRED = false;
    public static final boolean EMPLOYEES_IS_REQUIRED = false;
    public static final boolean ITEMS_IS_REQUIRED = false;
    public static final boolean TAGS_IS_REQUIRED = false;
    public static final boolean TENDERS_IS_REQUIRED = false;
    public static final boolean SHIFTS_IS_REQUIRED = false;
    public static final boolean ORDERS_IS_REQUIRED = false;
    public static final boolean PAYMENTS_IS_REQUIRED = false;
    public static final boolean TAXRATES_IS_REQUIRED = false;
    public static final boolean PRINTERS_IS_REQUIRED = false;
    public static final boolean MODIFIERGROUPS_IS_REQUIRED = false;
    public static final boolean ORDERTYPES_IS_REQUIRED = false;
    public static final boolean RESELLER_IS_REQUIRED = false;
    public static final boolean OPENING_HOURS_IS_REQUIRED = false;
    public static final boolean BUSINESSTYPECODE_IS_REQUIRED = false;
    public static final boolean ISBILLABLE_IS_REQUIRED = false;
    public static final boolean DEVICES_IS_REQUIRED = false;
    public static final boolean MERCHANTGROUPS_IS_REQUIRED = false;
    public static final boolean PARTNERAPP_IS_REQUIRED = false;

  }

}
