/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getModules modules}</li>
 * <li>{@link #getAppBundle appBundle}</li>
 * <li>{@link #getPlanCode planCode}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantPlan extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The name of the merchant plan
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Description of the plan
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  public java.lang.Long getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  public java.util.List<com.clover.sdk.v3.merchant.Module> getModules() {
    return genClient.cacheGet(CacheKey.modules);
  }

  public com.clover.sdk.v3.apps.AppBundle getAppBundle() {
    return genClient.cacheGet(CacheKey.appBundle);
  }

  public com.clover.sdk.v3.resellers.Reseller getReseller() {
    return genClient.cacheGet(CacheKey.reseller);
  }

  /**
   * First data plan code
   */
  public java.lang.String getPlanCode() {
    return genClient.cacheGet(CacheKey.planCode);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<MerchantPlan> {
    id {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    name {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    description {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractOther("description", java.lang.String.class);
      }
    },
    price {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractOther("price", java.lang.Long.class);
      }
    },
    modules {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractListRecord("modules", com.clover.sdk.v3.merchant.Module.JSON_CREATOR);
      }
    },
    appBundle {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractRecord("appBundle", com.clover.sdk.v3.apps.AppBundle.JSON_CREATOR);
      }
    },
    reseller {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractRecord("reseller", com.clover.sdk.v3.resellers.Reseller.JSON_CREATOR);
      }
    },
    planCode {
      @Override
      public Object extractValue(MerchantPlan instance) {
        return instance.genClient.extractOther("planCode", java.lang.String.class);
      }
    },
      ;
  }

  private GenericClient<MerchantPlan> genClient;

  /**
  * Constructs a new empty instance.
  */
  public MerchantPlan() {
    genClient = new GenericClient<MerchantPlan>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected MerchantPlan(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantPlan(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantPlan(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantPlan(MerchantPlan src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getName(), 31);

    genClient.validateLength(getDescription(), 2047);

    genClient.validateLength(getPlanCode(), 50);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'modules' field is set and is not null */
  public boolean isNotNullModules() {
    return genClient.cacheValueIsNotNull(CacheKey.modules);
  }

  /** Checks whether the 'modules' field is set and is not null and is not empty */
  public boolean isNotEmptyModules() { return isNotNullModules() && !getModules().isEmpty(); }

  /** Checks whether the 'appBundle' field is set and is not null */
  public boolean isNotNullAppBundle() {
    return genClient.cacheValueIsNotNull(CacheKey.appBundle);
  }

  public boolean isNotNullReseller() {
    return genClient.cacheValueIsNotNull(CacheKey.reseller);
  }

  /** Checks whether the 'planCode' field is set and is not null */
  public boolean isNotNullPlanCode() {
    return genClient.cacheValueIsNotNull(CacheKey.planCode);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'modules' field has been set, however the value could be null */
  public boolean hasModules() {
    return genClient.cacheHasKey(CacheKey.modules);
  }

  /** Checks whether the 'appBundle' field has been set, however the value could be null */
  public boolean hasAppBundle() {
    return genClient.cacheHasKey(CacheKey.appBundle);
  }

  public boolean hasReseller() {
    return genClient.cacheHasKey(CacheKey.reseller);
  }

  /** Checks whether the 'planCode' field has been set, however the value could be null */
  public boolean hasPlanCode() {
    return genClient.cacheHasKey(CacheKey.planCode);
  }


  /**
   * Sets the field 'id'.
   */
  public MerchantPlan setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public MerchantPlan setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'description'.
   */
  public MerchantPlan setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'price'.
   */
  public MerchantPlan setPrice(java.lang.Long price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'modules'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantPlan setModules(java.util.List<com.clover.sdk.v3.merchant.Module> modules) {
    return genClient.setArrayRecord(modules, CacheKey.modules);
  }

  /**
   * Sets the field 'appBundle'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlan setAppBundle(com.clover.sdk.v3.apps.AppBundle appBundle) {
    return genClient.setRecord(appBundle, CacheKey.appBundle);
  }

  public MerchantPlan setReseller(com.clover.sdk.v3.resellers.Reseller reseller) {
    return genClient.setRecord(reseller, CacheKey.reseller);
  }

  /**
   * Sets the field 'planCode'.
   */
  public MerchantPlan setPlanCode(java.lang.String planCode) {
    return genClient.setOther(planCode, CacheKey.planCode);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'modules' field, the 'has' method for this field will now return false */
  public void clearModules() {
    genClient.clear(CacheKey.modules);
  }
  /** Clears the 'appBundle' field, the 'has' method for this field will now return false */
  public void clearAppBundle() {
    genClient.clear(CacheKey.appBundle);
  }

  public void clearReseller() {
    genClient.clear(CacheKey.reseller);
  }

  /** Clears the 'planCode' field, the 'has' method for this field will now return false */
  public void clearPlanCode() {
    genClient.clear(CacheKey.planCode);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantPlan copyChanges() {
    MerchantPlan copy = new MerchantPlan();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantPlan src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantPlan(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantPlan> CREATOR = new android.os.Parcelable.Creator<MerchantPlan>() {
    @Override
    public MerchantPlan createFromParcel(android.os.Parcel in) {
      MerchantPlan instance = new MerchantPlan(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantPlan[] newArray(int size) {
      return new MerchantPlan[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantPlan> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantPlan>() {
    @Override
    public MerchantPlan create(org.json.JSONObject jsonObject) {
      return new MerchantPlan(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 31;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final long DESCRIPTION_MAX_LEN = 2047;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean MODULES_IS_REQUIRED = false;
    public static final boolean APPBUNDLE_IS_REQUIRED = false;
    public static final boolean RESELLER_IS_REQUIRED = false;
    public static final boolean PLANCODE_IS_REQUIRED = false;
    public static final long PLANCODE_MAX_LEN = 50;

  }

}
