/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.merchant;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMerchantRef merchantRef}</li>
 * <li>{@link #getDefaultCurrency defaultCurrency}</li>
 * <li>{@link #getTipsEnabled tipsEnabled}</li>
 * <li>{@link #getReceiptProperties receiptProperties}</li>
 * <li>{@link #getSummaryHour summaryHour}</li>
 * <li>{@link #getSignatureThreshold signatureThreshold}</li>
 * <li>{@link #getHasDefaultEmployee hasDefaultEmployee}</li>
 * <li>{@link #getTipRateDefault tipRateDefault}</li>
 * <li>{@link #getOnPaperTipSignatures onPaperTipSignatures}</li>
 * <li>{@link #getAutoLogout autoLogout}</li>
 * <li>{@link #getOrderTitle orderTitle}</li>
 * <li>{@link #getOrderTitleMax orderTitleMax}</li>
 * <li>{@link #getResetOnReportingTime resetOnReportingTime}</li>
 * <li>{@link #getNotesOnOrders notesOnOrders}</li>
 * <li>{@link #getDeleteOrders deleteOrders}</li>
 * <li>{@link #getRemoveTaxEnabled removeTaxEnabled}</li>
 * <li>{@link #getGroupLineItems groupLineItems}</li>
 * <li>{@link #getAlternateInventoryNames alternateInventoryNames}</li>
 * <li>{@link #getAutoPrint autoPrint}</li>
 * <li>{@link #getHardwareProfile hardwareProfile}</li>
 * <li>{@link #getInfoleaseSuppressBilling infoleaseSuppressBilling}</li>
 * <li>{@link #getInfoleaseSuppressPlanBilling infoleaseSuppressPlanBilling}</li>
 * <li>{@link #getShippingAddress shippingAddress}</li>
 * <li>{@link #getMarketingEnabled marketingEnabled}</li>
 * <li>{@link #getMarketingPreferenceText marketingPreferenceText}</li>
 * <li>{@link #getBankMarker bankMarker}</li>
 * <li>{@link #getSupportPhone supportPhone}</li>
 * <li>{@link #getSupportEmail supportEmail}</li>
 * <li>{@link #getManualCloseout manualCloseout}</li>
 * <li>{@link #getShowCloseoutOrders showCloseoutOrders}</li>
 * <li>{@link #getSendCloseoutEmail sendCloseoutEmail}</li>
 * <li>{@link #getStayInCategory stayInCategory}</li>
 * <li>{@link #getLocale locale}</li>
 * <li>{@link #getTimezone timezone}</li>
 * <li>{@link #getVat vat}</li>
 * <li>{@link #getVatTaxName vatTaxName}</li>
 * <li>{@link #getAppBillingSystem appBillingSystem}</li>
 * <li>{@link #getAbaAccountNumber abaAccountNumber}</li>
 * <li>{@link #getDdaAccountNumber ddaAccountNumber}</li>
 * <li>{@link #getTrackStock trackStock}</li>
 * <li>{@link #getUpdateStock updateStock}</li>
 * <li>{@link #getAllowClockOutWithOpenOrders allowClockOutWithOpenOrders}</li>
 * <li>{@link #getLogInClockInPrompt logInClockInPrompt}</li>
 * <li>{@link #getAccountType accountType}</li>
 * <li>{@link #getBusinessTypeCode businessTypeCode}</li>
 * <li>{@link #getPinLength pinLength}</li>
 * <li>{@link #getCashBackEnabled cashBackEnabled}</li>
 * <li>{@link #getCashBackOptions cashBackOptions}</li>
 * <li>{@link #getMaxCashBack maxCashBack}</li>
 * <li>{@link #getHierarchy hierarchy}</li>
 * <li>{@link #getHasConsented hasConsented}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantProperties extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public com.clover.sdk.v3.base.Reference getMerchantRef() {
    return genClient.cacheGet(CacheKey.merchantRef);
  }

  public java.lang.String getDefaultCurrency() {
    return genClient.cacheGet(CacheKey.defaultCurrency);
  }

  public java.lang.Boolean getTipsEnabled() {
    return genClient.cacheGet(CacheKey.tipsEnabled);
  }

  public java.lang.String getReceiptProperties() {
    return genClient.cacheGet(CacheKey.receiptProperties);
  }

  public java.lang.Integer getSummaryHour() {
    return genClient.cacheGet(CacheKey.summaryHour);
  }

  public java.lang.Long getSignatureThreshold() {
    return genClient.cacheGet(CacheKey.signatureThreshold);
  }

  public java.lang.Boolean getHasDefaultEmployee() {
    return genClient.cacheGet(CacheKey.hasDefaultEmployee);
  }

  public java.lang.Integer getTipRateDefault() {
    return genClient.cacheGet(CacheKey.tipRateDefault);
  }

  public java.lang.Boolean getOnPaperTipSignatures() {
    return genClient.cacheGet(CacheKey.onPaperTipSignatures);
  }

  public java.lang.Boolean getAutoLogout() {
    return genClient.cacheGet(CacheKey.autoLogout);
  }

  public com.clover.sdk.v3.merchant.OrderTitle getOrderTitle() {
    return genClient.cacheGet(CacheKey.orderTitle);
  }

  public java.lang.Integer getOrderTitleMax() {
    return genClient.cacheGet(CacheKey.orderTitleMax);
  }

  public java.lang.Boolean getResetOnReportingTime() {
    return genClient.cacheGet(CacheKey.resetOnReportingTime);
  }

  public java.lang.Boolean getNotesOnOrders() {
    return genClient.cacheGet(CacheKey.notesOnOrders);
  }

  public java.lang.Boolean getDeleteOrders() {
    return genClient.cacheGet(CacheKey.deleteOrders);
  }

  public java.lang.Boolean getRemoveTaxEnabled() {
    return genClient.cacheGet(CacheKey.removeTaxEnabled);
  }

  public java.lang.Boolean getGroupLineItems() {
    return genClient.cacheGet(CacheKey.groupLineItems);
  }

  public java.lang.Boolean getAlternateInventoryNames() {
    return genClient.cacheGet(CacheKey.alternateInventoryNames);
  }

  public java.lang.Boolean getAutoPrint() {
    return genClient.cacheGet(CacheKey.autoPrint);
  }

  public java.lang.String getHardwareProfile() {
    return genClient.cacheGet(CacheKey.hardwareProfile);
  }

  public java.lang.Boolean getInfoleaseSuppressBilling() {
    return genClient.cacheGet(CacheKey.infoleaseSuppressBilling);
  }

  public java.lang.Boolean getInfoleaseSuppressPlanBilling() {
    return genClient.cacheGet(CacheKey.infoleaseSuppressPlanBilling);
  }

  public java.lang.String getShippingAddress() {
    return genClient.cacheGet(CacheKey.shippingAddress);
  }

  public java.lang.Boolean getMarketingEnabled() {
    return genClient.cacheGet(CacheKey.marketingEnabled);
  }

  public java.lang.String getMarketingPreferenceText() {
    return genClient.cacheGet(CacheKey.marketingPreferenceText);
  }

  public java.lang.Integer getBankMarker() {
    return genClient.cacheGet(CacheKey.bankMarker);
  }

  public java.lang.String getSupportPhone() {
    return genClient.cacheGet(CacheKey.supportPhone);
  }

  public java.lang.String getSupportEmail() {
    return genClient.cacheGet(CacheKey.supportEmail);
  }

  public java.lang.Boolean getManualCloseout() {
    return genClient.cacheGet(CacheKey.manualCloseout);
  }

  public java.lang.Boolean getShowCloseoutOrders() {
    return genClient.cacheGet(CacheKey.showCloseoutOrders);
  }

  public java.lang.Boolean getSendCloseoutEmail() {
    return genClient.cacheGet(CacheKey.sendCloseoutEmail);
  }

  public java.lang.Boolean getStayInCategory() {
    return genClient.cacheGet(CacheKey.stayInCategory);
  }

  /**
   * The locale of the merchant.
   */
  public java.lang.String getLocale() {
    return genClient.cacheGet(CacheKey.locale);
  }

  public java.lang.String getTimezone() {
    return genClient.cacheGet(CacheKey.timezone);
  }

  /**
   * Whether this merchant is in a VAT country
   */
  public java.lang.Boolean getVat() {
    return genClient.cacheGet(CacheKey.vat);
  }

  /**
   * The VAT tax name that is shown on receipts
   */
  public java.lang.String getVatTaxName() {
    return genClient.cacheGet(CacheKey.vatTaxName);
  }

  /**
   * Temporary while we are switching US billing systems
   */
  public java.lang.String getAppBillingSystem() {
    return genClient.cacheGet(CacheKey.appBillingSystem);
  }

  /**
   * The ABA Account Number.  Supplied by First Data.
   */
  public java.lang.String getAbaAccountNumber() {
    return genClient.cacheGet(CacheKey.abaAccountNumber);
  }

  /**
   * The Masked DDA Account Number.  Supplied by First Data.
   */
  public java.lang.String getDdaAccountNumber() {
    return genClient.cacheGet(CacheKey.ddaAccountNumber);
  }

  public java.lang.Boolean getTrackStock() {
    return genClient.cacheGet(CacheKey.trackStock);
  }

  public java.lang.Boolean getUpdateStock() {
    return genClient.cacheGet(CacheKey.updateStock);
  }

  public java.lang.Boolean getAllowClockOutWithOpenOrders() {
    return genClient.cacheGet(CacheKey.allowClockOutWithOpenOrders);
  }

  public java.lang.Boolean getLogInClockInPrompt() {
    return genClient.cacheGet(CacheKey.logInClockInPrompt);
  }

  public java.lang.String getAccountType() {
    return genClient.cacheGet(CacheKey.accountType);
  }

  /**
   * The business type of the merchant
   */
  public com.clover.sdk.v3.base.BusinessTypeCode getBusinessTypeCode() {
    return genClient.cacheGet(CacheKey.businessTypeCode);
  }

  public java.lang.Integer getPinLength() {
    return genClient.cacheGet(CacheKey.pinLength);
  }

  /**
   * Whether cash back is enabled for this merchant
   */
  public java.lang.Boolean getCashBackEnabled() {
    return genClient.cacheGet(CacheKey.cashBackEnabled);
  }

  /**
   * List of cash back possible cash back amounts
   */
  public java.lang.String getCashBackOptions() {
    return genClient.cacheGet(CacheKey.cashBackOptions);
  }

  /**
   * The maximum amount of cash back that the customer can select.
   */
  public java.lang.Long getMaxCashBack() {
    return genClient.cacheGet(CacheKey.maxCashBack);
  }

  /**
   * Merchant hierarchy (Business, Bank, Agent, Corp, Chain). Supplied by First Data.
   */
  public java.lang.String getHierarchy() {
    return genClient.cacheGet(CacheKey.hierarchy);
  }

  /**
   * Whether or not merchant has consented to infolease billing
   */
  public java.lang.Boolean getHasConsented() {
    return genClient.cacheGet(CacheKey.hasConsented);
  }



  public static final String AUTHORITY = "com.clover.merchants";

  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<MerchantProperties> {
    merchantRef {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractRecord("merchantRef", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    defaultCurrency {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("defaultCurrency", java.lang.String.class);
      }
    },
    tipsEnabled {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("tipsEnabled", java.lang.Boolean.class);
      }
    },
    receiptProperties {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("receiptProperties", java.lang.String.class);
      }
    },
    summaryHour {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("summaryHour", java.lang.Integer.class);
      }
    },
    signatureThreshold {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("signatureThreshold", java.lang.Long.class);
      }
    },
    hasDefaultEmployee {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("hasDefaultEmployee", java.lang.Boolean.class);
      }
    },
    tipRateDefault {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("tipRateDefault", java.lang.Integer.class);
      }
    },
    onPaperTipSignatures {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("onPaperTipSignatures", java.lang.Boolean.class);
      }
    },
    autoLogout {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("autoLogout", java.lang.Boolean.class);
      }
    },
    orderTitle {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractEnum("orderTitle", com.clover.sdk.v3.merchant.OrderTitle.class);
      }
    },
    orderTitleMax {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("orderTitleMax", java.lang.Integer.class);
      }
    },
    resetOnReportingTime {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("resetOnReportingTime", java.lang.Boolean.class);
      }
    },
    notesOnOrders {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("notesOnOrders", java.lang.Boolean.class);
      }
    },
    deleteOrders {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("deleteOrders", java.lang.Boolean.class);
      }
    },
    removeTaxEnabled {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("removeTaxEnabled", java.lang.Boolean.class);
      }
    },
    groupLineItems {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("groupLineItems", java.lang.Boolean.class);
      }
    },
    alternateInventoryNames {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("alternateInventoryNames", java.lang.Boolean.class);
      }
    },
    autoPrint {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("autoPrint", java.lang.Boolean.class);
      }
    },
    hardwareProfile {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("hardwareProfile", java.lang.String.class);
      }
    },
    infoleaseSuppressBilling {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("infoleaseSuppressBilling", java.lang.Boolean.class);
      }
    },
    infoleaseSuppressPlanBilling {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("infoleaseSuppressPlanBilling", java.lang.Boolean.class);
      }
    },
    shippingAddress {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("shippingAddress", java.lang.String.class);
      }
    },
    marketingEnabled {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("marketingEnabled", java.lang.Boolean.class);
      }
    },
    marketingPreferenceText {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("marketingPreferenceText", java.lang.String.class);
      }
    },
    bankMarker {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("bankMarker", java.lang.Integer.class);
      }
    },
    supportPhone {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("supportPhone", java.lang.String.class);
      }
    },
    supportEmail {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("supportEmail", java.lang.String.class);
      }
    },
    manualCloseout {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("manualCloseout", java.lang.Boolean.class);
      }
    },
    showCloseoutOrders {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("showCloseoutOrders", java.lang.Boolean.class);
      }
    },
    sendCloseoutEmail {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("sendCloseoutEmail", java.lang.Boolean.class);
      }
    },
    stayInCategory {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("stayInCategory", java.lang.Boolean.class);
      }
    },
    locale {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("locale", java.lang.String.class);
      }
    },
    timezone {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("timezone", java.lang.String.class);
      }
    },
    vat {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("vat", java.lang.Boolean.class);
      }
    },
    vatTaxName {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("vatTaxName", java.lang.String.class);
      }
    },
    appBillingSystem {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("appBillingSystem", java.lang.String.class);
      }
    },
    abaAccountNumber {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("abaAccountNumber", java.lang.String.class);
      }
    },
    ddaAccountNumber {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("ddaAccountNumber", java.lang.String.class);
      }
    },
    trackStock {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("trackStock", java.lang.Boolean.class);
      }
    },
    updateStock {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("updateStock", java.lang.Boolean.class);
      }
    },
    allowClockOutWithOpenOrders {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("allowClockOutWithOpenOrders", java.lang.Boolean.class);
      }
    },
    logInClockInPrompt {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("logInClockInPrompt", java.lang.Boolean.class);
      }
    },
    accountType {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("accountType", java.lang.String.class);
      }
    },
    businessTypeCode {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractEnum("businessTypeCode", com.clover.sdk.v3.base.BusinessTypeCode.class);
      }
    },
    pinLength {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("pinLength", java.lang.Integer.class);
      }
    },
    cashBackEnabled {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("cashBackEnabled", java.lang.Boolean.class);
      }
    },
    cashBackOptions {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("cashBackOptions", java.lang.String.class);
      }
    },
    maxCashBack {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("maxCashBack", java.lang.Long.class);
      }
    },
    hierarchy {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("hierarchy", java.lang.String.class);
      }
    },
    hasConsented {
      @Override
      public Object extractValue(MerchantProperties instance) {
        return instance.genClient.extractOther("hasConsented", java.lang.Boolean.class);
      }
    },
      ;
  }

  private GenericClient<MerchantProperties> genClient;

  /**
  * Constructs a new empty instance.
  */
  public MerchantProperties() {
    genClient = new GenericClient<MerchantProperties>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected MerchantProperties(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantProperties(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantProperties(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantProperties(MerchantProperties src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(getDefaultCurrency(), 3);

    genClient.validateLength(getHardwareProfile(), 127);

    genClient.validateLength(getMarketingPreferenceText(), 255);

    genClient.validateLength(getSupportPhone(), 25);

    genClient.validateLength(getSupportEmail(), 127);

    genClient.validateLength(getTimezone(), 255);

    genClient.validateLength(getVatTaxName(), 255);

    genClient.validateLength(getAppBillingSystem(), 10);

    genClient.validateLength(getAbaAccountNumber(), 40);

    genClient.validateLength(getDdaAccountNumber(), 40);

    genClient.validateLength(getHierarchy(), 127);
  }

  /** Checks whether the 'merchantRef' field is set and is not null */
  public boolean isNotNullMerchantRef() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantRef);
  }

  /** Checks whether the 'defaultCurrency' field is set and is not null */
  public boolean isNotNullDefaultCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'tipsEnabled' field is set and is not null */
  public boolean isNotNullTipsEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.tipsEnabled);
  }

  /** Checks whether the 'receiptProperties' field is set and is not null */
  public boolean isNotNullReceiptProperties() {
    return genClient.cacheValueIsNotNull(CacheKey.receiptProperties);
  }

  /** Checks whether the 'summaryHour' field is set and is not null */
  public boolean isNotNullSummaryHour() {
    return genClient.cacheValueIsNotNull(CacheKey.summaryHour);
  }

  /** Checks whether the 'signatureThreshold' field is set and is not null */
  public boolean isNotNullSignatureThreshold() {
    return genClient.cacheValueIsNotNull(CacheKey.signatureThreshold);
  }

  /** Checks whether the 'hasDefaultEmployee' field is set and is not null */
  public boolean isNotNullHasDefaultEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.hasDefaultEmployee);
  }

  /** Checks whether the 'tipRateDefault' field is set and is not null */
  public boolean isNotNullTipRateDefault() {
    return genClient.cacheValueIsNotNull(CacheKey.tipRateDefault);
  }

  /** Checks whether the 'onPaperTipSignatures' field is set and is not null */
  public boolean isNotNullOnPaperTipSignatures() {
    return genClient.cacheValueIsNotNull(CacheKey.onPaperTipSignatures);
  }

  /** Checks whether the 'autoLogout' field is set and is not null */
  public boolean isNotNullAutoLogout() {
    return genClient.cacheValueIsNotNull(CacheKey.autoLogout);
  }

  /** Checks whether the 'orderTitle' field is set and is not null */
  public boolean isNotNullOrderTitle() {
    return genClient.cacheValueIsNotNull(CacheKey.orderTitle);
  }

  /** Checks whether the 'orderTitleMax' field is set and is not null */
  public boolean isNotNullOrderTitleMax() {
    return genClient.cacheValueIsNotNull(CacheKey.orderTitleMax);
  }

  /** Checks whether the 'resetOnReportingTime' field is set and is not null */
  public boolean isNotNullResetOnReportingTime() {
    return genClient.cacheValueIsNotNull(CacheKey.resetOnReportingTime);
  }

  /** Checks whether the 'notesOnOrders' field is set and is not null */
  public boolean isNotNullNotesOnOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.notesOnOrders);
  }

  /** Checks whether the 'deleteOrders' field is set and is not null */
  public boolean isNotNullDeleteOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.deleteOrders);
  }

  /** Checks whether the 'removeTaxEnabled' field is set and is not null */
  public boolean isNotNullRemoveTaxEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.removeTaxEnabled);
  }

  /** Checks whether the 'groupLineItems' field is set and is not null */
  public boolean isNotNullGroupLineItems() {
    return genClient.cacheValueIsNotNull(CacheKey.groupLineItems);
  }

  /** Checks whether the 'alternateInventoryNames' field is set and is not null */
  public boolean isNotNullAlternateInventoryNames() {
    return genClient.cacheValueIsNotNull(CacheKey.alternateInventoryNames);
  }

  /** Checks whether the 'autoPrint' field is set and is not null */
  public boolean isNotNullAutoPrint() {
    return genClient.cacheValueIsNotNull(CacheKey.autoPrint);
  }

  /** Checks whether the 'hardwareProfile' field is set and is not null */
  public boolean isNotNullHardwareProfile() {
    return genClient.cacheValueIsNotNull(CacheKey.hardwareProfile);
  }

  /** Checks whether the 'infoleaseSuppressBilling' field is set and is not null */
  public boolean isNotNullInfoleaseSuppressBilling() {
    return genClient.cacheValueIsNotNull(CacheKey.infoleaseSuppressBilling);
  }

  /** Checks whether the 'infoleaseSuppressPlanBilling' field is set and is not null */
  public boolean isNotNullInfoleaseSuppressPlanBilling() {
    return genClient.cacheValueIsNotNull(CacheKey.infoleaseSuppressPlanBilling);
  }

  /** Checks whether the 'shippingAddress' field is set and is not null */
  public boolean isNotNullShippingAddress() {
    return genClient.cacheValueIsNotNull(CacheKey.shippingAddress);
  }

  /** Checks whether the 'marketingEnabled' field is set and is not null */
  public boolean isNotNullMarketingEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.marketingEnabled);
  }

  /** Checks whether the 'marketingPreferenceText' field is set and is not null */
  public boolean isNotNullMarketingPreferenceText() {
    return genClient.cacheValueIsNotNull(CacheKey.marketingPreferenceText);
  }

  /** Checks whether the 'bankMarker' field is set and is not null */
  public boolean isNotNullBankMarker() {
    return genClient.cacheValueIsNotNull(CacheKey.bankMarker);
  }

  /** Checks whether the 'supportPhone' field is set and is not null */
  public boolean isNotNullSupportPhone() {
    return genClient.cacheValueIsNotNull(CacheKey.supportPhone);
  }

  /** Checks whether the 'supportEmail' field is set and is not null */
  public boolean isNotNullSupportEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.supportEmail);
  }

  /** Checks whether the 'manualCloseout' field is set and is not null */
  public boolean isNotNullManualCloseout() {
    return genClient.cacheValueIsNotNull(CacheKey.manualCloseout);
  }

  /** Checks whether the 'showCloseoutOrders' field is set and is not null */
  public boolean isNotNullShowCloseoutOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.showCloseoutOrders);
  }

  /** Checks whether the 'sendCloseoutEmail' field is set and is not null */
  public boolean isNotNullSendCloseoutEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.sendCloseoutEmail);
  }

  /** Checks whether the 'stayInCategory' field is set and is not null */
  public boolean isNotNullStayInCategory() {
    return genClient.cacheValueIsNotNull(CacheKey.stayInCategory);
  }

  /** Checks whether the 'locale' field is set and is not null */
  public boolean isNotNullLocale() {
    return genClient.cacheValueIsNotNull(CacheKey.locale);
  }

  /** Checks whether the 'timezone' field is set and is not null */
  public boolean isNotNullTimezone() {
    return genClient.cacheValueIsNotNull(CacheKey.timezone);
  }

  /** Checks whether the 'vat' field is set and is not null */
  public boolean isNotNullVat() {
    return genClient.cacheValueIsNotNull(CacheKey.vat);
  }

  /** Checks whether the 'vatTaxName' field is set and is not null */
  public boolean isNotNullVatTaxName() {
    return genClient.cacheValueIsNotNull(CacheKey.vatTaxName);
  }

  /** Checks whether the 'appBillingSystem' field is set and is not null */
  public boolean isNotNullAppBillingSystem() {
    return genClient.cacheValueIsNotNull(CacheKey.appBillingSystem);
  }

  /** Checks whether the 'abaAccountNumber' field is set and is not null */
  public boolean isNotNullAbaAccountNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.abaAccountNumber);
  }

  /** Checks whether the 'ddaAccountNumber' field is set and is not null */
  public boolean isNotNullDdaAccountNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.ddaAccountNumber);
  }

  /** Checks whether the 'trackStock' field is set and is not null */
  public boolean isNotNullTrackStock() {
    return genClient.cacheValueIsNotNull(CacheKey.trackStock);
  }

  /** Checks whether the 'updateStock' field is set and is not null */
  public boolean isNotNullUpdateStock() {
    return genClient.cacheValueIsNotNull(CacheKey.updateStock);
  }

  /** Checks whether the 'allowClockOutWithOpenOrders' field is set and is not null */
  public boolean isNotNullAllowClockOutWithOpenOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.allowClockOutWithOpenOrders);
  }

  /** Checks whether the 'logInClockInPrompt' field is set and is not null */
  public boolean isNotNullLogInClockInPrompt() {
    return genClient.cacheValueIsNotNull(CacheKey.logInClockInPrompt);
  }

  /** Checks whether the 'accountType' field is set and is not null */
  public boolean isNotNullAccountType() {
    return genClient.cacheValueIsNotNull(CacheKey.accountType);
  }

  /** Checks whether the 'businessTypeCode' field is set and is not null */
  public boolean isNotNullBusinessTypeCode() {
    return genClient.cacheValueIsNotNull(CacheKey.businessTypeCode);
  }

  /** Checks whether the 'pinLength' field is set and is not null */
  public boolean isNotNullPinLength() {
    return genClient.cacheValueIsNotNull(CacheKey.pinLength);
  }

  /** Checks whether the 'cashBackEnabled' field is set and is not null */
  public boolean isNotNullCashBackEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.cashBackEnabled);
  }

  /** Checks whether the 'cashBackOptions' field is set and is not null */
  public boolean isNotNullCashBackOptions() {
    return genClient.cacheValueIsNotNull(CacheKey.cashBackOptions);
  }

  /** Checks whether the 'maxCashBack' field is set and is not null */
  public boolean isNotNullMaxCashBack() {
    return genClient.cacheValueIsNotNull(CacheKey.maxCashBack);
  }

  /** Checks whether the 'hierarchy' field is set and is not null */
  public boolean isNotNullHierarchy() {
    return genClient.cacheValueIsNotNull(CacheKey.hierarchy);
  }

  /** Checks whether the 'hasConsented' field is set and is not null */
  public boolean isNotNullHasConsented() {
    return genClient.cacheValueIsNotNull(CacheKey.hasConsented);
  }



  /** Checks whether the 'merchantRef' field has been set, however the value could be null */
  public boolean hasMerchantRef() {
    return genClient.cacheHasKey(CacheKey.merchantRef);
  }

  /** Checks whether the 'defaultCurrency' field has been set, however the value could be null */
  public boolean hasDefaultCurrency() {
    return genClient.cacheHasKey(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'tipsEnabled' field has been set, however the value could be null */
  public boolean hasTipsEnabled() {
    return genClient.cacheHasKey(CacheKey.tipsEnabled);
  }

  /** Checks whether the 'receiptProperties' field has been set, however the value could be null */
  public boolean hasReceiptProperties() {
    return genClient.cacheHasKey(CacheKey.receiptProperties);
  }

  /** Checks whether the 'summaryHour' field has been set, however the value could be null */
  public boolean hasSummaryHour() {
    return genClient.cacheHasKey(CacheKey.summaryHour);
  }

  /** Checks whether the 'signatureThreshold' field has been set, however the value could be null */
  public boolean hasSignatureThreshold() {
    return genClient.cacheHasKey(CacheKey.signatureThreshold);
  }

  /** Checks whether the 'hasDefaultEmployee' field has been set, however the value could be null */
  public boolean hasHasDefaultEmployee() {
    return genClient.cacheHasKey(CacheKey.hasDefaultEmployee);
  }

  /** Checks whether the 'tipRateDefault' field has been set, however the value could be null */
  public boolean hasTipRateDefault() {
    return genClient.cacheHasKey(CacheKey.tipRateDefault);
  }

  /** Checks whether the 'onPaperTipSignatures' field has been set, however the value could be null */
  public boolean hasOnPaperTipSignatures() {
    return genClient.cacheHasKey(CacheKey.onPaperTipSignatures);
  }

  /** Checks whether the 'autoLogout' field has been set, however the value could be null */
  public boolean hasAutoLogout() {
    return genClient.cacheHasKey(CacheKey.autoLogout);
  }

  /** Checks whether the 'orderTitle' field has been set, however the value could be null */
  public boolean hasOrderTitle() {
    return genClient.cacheHasKey(CacheKey.orderTitle);
  }

  /** Checks whether the 'orderTitleMax' field has been set, however the value could be null */
  public boolean hasOrderTitleMax() {
    return genClient.cacheHasKey(CacheKey.orderTitleMax);
  }

  /** Checks whether the 'resetOnReportingTime' field has been set, however the value could be null */
  public boolean hasResetOnReportingTime() {
    return genClient.cacheHasKey(CacheKey.resetOnReportingTime);
  }

  /** Checks whether the 'notesOnOrders' field has been set, however the value could be null */
  public boolean hasNotesOnOrders() {
    return genClient.cacheHasKey(CacheKey.notesOnOrders);
  }

  /** Checks whether the 'deleteOrders' field has been set, however the value could be null */
  public boolean hasDeleteOrders() {
    return genClient.cacheHasKey(CacheKey.deleteOrders);
  }

  /** Checks whether the 'removeTaxEnabled' field has been set, however the value could be null */
  public boolean hasRemoveTaxEnabled() {
    return genClient.cacheHasKey(CacheKey.removeTaxEnabled);
  }

  /** Checks whether the 'groupLineItems' field has been set, however the value could be null */
  public boolean hasGroupLineItems() {
    return genClient.cacheHasKey(CacheKey.groupLineItems);
  }

  /** Checks whether the 'alternateInventoryNames' field has been set, however the value could be null */
  public boolean hasAlternateInventoryNames() {
    return genClient.cacheHasKey(CacheKey.alternateInventoryNames);
  }

  /** Checks whether the 'autoPrint' field has been set, however the value could be null */
  public boolean hasAutoPrint() {
    return genClient.cacheHasKey(CacheKey.autoPrint);
  }

  /** Checks whether the 'hardwareProfile' field has been set, however the value could be null */
  public boolean hasHardwareProfile() {
    return genClient.cacheHasKey(CacheKey.hardwareProfile);
  }

  /** Checks whether the 'infoleaseSuppressBilling' field has been set, however the value could be null */
  public boolean hasInfoleaseSuppressBilling() {
    return genClient.cacheHasKey(CacheKey.infoleaseSuppressBilling);
  }

  /** Checks whether the 'infoleaseSuppressPlanBilling' field has been set, however the value could be null */
  public boolean hasInfoleaseSuppressPlanBilling() {
    return genClient.cacheHasKey(CacheKey.infoleaseSuppressPlanBilling);
  }

  /** Checks whether the 'shippingAddress' field has been set, however the value could be null */
  public boolean hasShippingAddress() {
    return genClient.cacheHasKey(CacheKey.shippingAddress);
  }

  /** Checks whether the 'marketingEnabled' field has been set, however the value could be null */
  public boolean hasMarketingEnabled() {
    return genClient.cacheHasKey(CacheKey.marketingEnabled);
  }

  /** Checks whether the 'marketingPreferenceText' field has been set, however the value could be null */
  public boolean hasMarketingPreferenceText() {
    return genClient.cacheHasKey(CacheKey.marketingPreferenceText);
  }

  /** Checks whether the 'bankMarker' field has been set, however the value could be null */
  public boolean hasBankMarker() {
    return genClient.cacheHasKey(CacheKey.bankMarker);
  }

  /** Checks whether the 'supportPhone' field has been set, however the value could be null */
  public boolean hasSupportPhone() {
    return genClient.cacheHasKey(CacheKey.supportPhone);
  }

  /** Checks whether the 'supportEmail' field has been set, however the value could be null */
  public boolean hasSupportEmail() {
    return genClient.cacheHasKey(CacheKey.supportEmail);
  }

  /** Checks whether the 'manualCloseout' field has been set, however the value could be null */
  public boolean hasManualCloseout() {
    return genClient.cacheHasKey(CacheKey.manualCloseout);
  }

  /** Checks whether the 'showCloseoutOrders' field has been set, however the value could be null */
  public boolean hasShowCloseoutOrders() {
    return genClient.cacheHasKey(CacheKey.showCloseoutOrders);
  }

  /** Checks whether the 'sendCloseoutEmail' field has been set, however the value could be null */
  public boolean hasSendCloseoutEmail() {
    return genClient.cacheHasKey(CacheKey.sendCloseoutEmail);
  }

  /** Checks whether the 'stayInCategory' field has been set, however the value could be null */
  public boolean hasStayInCategory() {
    return genClient.cacheHasKey(CacheKey.stayInCategory);
  }

  /** Checks whether the 'locale' field has been set, however the value could be null */
  public boolean hasLocale() {
    return genClient.cacheHasKey(CacheKey.locale);
  }

  /** Checks whether the 'timezone' field has been set, however the value could be null */
  public boolean hasTimezone() {
    return genClient.cacheHasKey(CacheKey.timezone);
  }

  /** Checks whether the 'vat' field has been set, however the value could be null */
  public boolean hasVat() {
    return genClient.cacheHasKey(CacheKey.vat);
  }

  /** Checks whether the 'vatTaxName' field has been set, however the value could be null */
  public boolean hasVatTaxName() {
    return genClient.cacheHasKey(CacheKey.vatTaxName);
  }

  /** Checks whether the 'appBillingSystem' field has been set, however the value could be null */
  public boolean hasAppBillingSystem() {
    return genClient.cacheHasKey(CacheKey.appBillingSystem);
  }

  /** Checks whether the 'abaAccountNumber' field has been set, however the value could be null */
  public boolean hasAbaAccountNumber() {
    return genClient.cacheHasKey(CacheKey.abaAccountNumber);
  }

  /** Checks whether the 'ddaAccountNumber' field has been set, however the value could be null */
  public boolean hasDdaAccountNumber() {
    return genClient.cacheHasKey(CacheKey.ddaAccountNumber);
  }

  /** Checks whether the 'trackStock' field has been set, however the value could be null */
  public boolean hasTrackStock() {
    return genClient.cacheHasKey(CacheKey.trackStock);
  }

  /** Checks whether the 'updateStock' field has been set, however the value could be null */
  public boolean hasUpdateStock() {
    return genClient.cacheHasKey(CacheKey.updateStock);
  }

  /** Checks whether the 'allowClockOutWithOpenOrders' field has been set, however the value could be null */
  public boolean hasAllowClockOutWithOpenOrders() {
    return genClient.cacheHasKey(CacheKey.allowClockOutWithOpenOrders);
  }

  /** Checks whether the 'logInClockInPrompt' field has been set, however the value could be null */
  public boolean hasLogInClockInPrompt() {
    return genClient.cacheHasKey(CacheKey.logInClockInPrompt);
  }

  /** Checks whether the 'accountType' field has been set, however the value could be null */
  public boolean hasAccountType() {
    return genClient.cacheHasKey(CacheKey.accountType);
  }

  /** Checks whether the 'businessTypeCode' field has been set, however the value could be null */
  public boolean hasBusinessTypeCode() {
    return genClient.cacheHasKey(CacheKey.businessTypeCode);
  }

  /** Checks whether the 'pinLength' field has been set, however the value could be null */
  public boolean hasPinLength() {
    return genClient.cacheHasKey(CacheKey.pinLength);
  }

  /** Checks whether the 'cashBackEnabled' field has been set, however the value could be null */
  public boolean hasCashBackEnabled() {
    return genClient.cacheHasKey(CacheKey.cashBackEnabled);
  }

  /** Checks whether the 'cashBackOptions' field has been set, however the value could be null */
  public boolean hasCashBackOptions() {
    return genClient.cacheHasKey(CacheKey.cashBackOptions);
  }

  /** Checks whether the 'maxCashBack' field has been set, however the value could be null */
  public boolean hasMaxCashBack() {
    return genClient.cacheHasKey(CacheKey.maxCashBack);
  }

  /** Checks whether the 'hierarchy' field has been set, however the value could be null */
  public boolean hasHierarchy() {
    return genClient.cacheHasKey(CacheKey.hierarchy);
  }

  /** Checks whether the 'hasConsented' field has been set, however the value could be null */
  public boolean hasHasConsented() {
    return genClient.cacheHasKey(CacheKey.hasConsented);
  }


  /**
   * Sets the field 'merchantRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantProperties setMerchantRef(com.clover.sdk.v3.base.Reference merchantRef) {
    return genClient.setRecord(merchantRef, CacheKey.merchantRef);
  }

  /**
   * Sets the field 'defaultCurrency'.
   */
  public MerchantProperties setDefaultCurrency(java.lang.String defaultCurrency) {
    return genClient.setOther(defaultCurrency, CacheKey.defaultCurrency);
  }

  /**
   * Sets the field 'tipsEnabled'.
   */
  public MerchantProperties setTipsEnabled(java.lang.Boolean tipsEnabled) {
    return genClient.setOther(tipsEnabled, CacheKey.tipsEnabled);
  }

  /**
   * Sets the field 'receiptProperties'.
   */
  public MerchantProperties setReceiptProperties(java.lang.String receiptProperties) {
    return genClient.setOther(receiptProperties, CacheKey.receiptProperties);
  }

  /**
   * Sets the field 'summaryHour'.
   */
  public MerchantProperties setSummaryHour(java.lang.Integer summaryHour) {
    return genClient.setOther(summaryHour, CacheKey.summaryHour);
  }

  /**
   * Sets the field 'signatureThreshold'.
   */
  public MerchantProperties setSignatureThreshold(java.lang.Long signatureThreshold) {
    return genClient.setOther(signatureThreshold, CacheKey.signatureThreshold);
  }

  /**
   * Sets the field 'hasDefaultEmployee'.
   */
  public MerchantProperties setHasDefaultEmployee(java.lang.Boolean hasDefaultEmployee) {
    return genClient.setOther(hasDefaultEmployee, CacheKey.hasDefaultEmployee);
  }

  /**
   * Sets the field 'tipRateDefault'.
   */
  public MerchantProperties setTipRateDefault(java.lang.Integer tipRateDefault) {
    return genClient.setOther(tipRateDefault, CacheKey.tipRateDefault);
  }

  /**
   * Sets the field 'onPaperTipSignatures'.
   */
  public MerchantProperties setOnPaperTipSignatures(java.lang.Boolean onPaperTipSignatures) {
    return genClient.setOther(onPaperTipSignatures, CacheKey.onPaperTipSignatures);
  }

  /**
   * Sets the field 'autoLogout'.
   */
  public MerchantProperties setAutoLogout(java.lang.Boolean autoLogout) {
    return genClient.setOther(autoLogout, CacheKey.autoLogout);
  }

  /**
   * Sets the field 'orderTitle'.
   */
  public MerchantProperties setOrderTitle(com.clover.sdk.v3.merchant.OrderTitle orderTitle) {
    return genClient.setOther(orderTitle, CacheKey.orderTitle);
  }

  /**
   * Sets the field 'orderTitleMax'.
   */
  public MerchantProperties setOrderTitleMax(java.lang.Integer orderTitleMax) {
    return genClient.setOther(orderTitleMax, CacheKey.orderTitleMax);
  }

  /**
   * Sets the field 'resetOnReportingTime'.
   */
  public MerchantProperties setResetOnReportingTime(java.lang.Boolean resetOnReportingTime) {
    return genClient.setOther(resetOnReportingTime, CacheKey.resetOnReportingTime);
  }

  /**
   * Sets the field 'notesOnOrders'.
   */
  public MerchantProperties setNotesOnOrders(java.lang.Boolean notesOnOrders) {
    return genClient.setOther(notesOnOrders, CacheKey.notesOnOrders);
  }

  /**
   * Sets the field 'deleteOrders'.
   */
  public MerchantProperties setDeleteOrders(java.lang.Boolean deleteOrders) {
    return genClient.setOther(deleteOrders, CacheKey.deleteOrders);
  }

  /**
   * Sets the field 'removeTaxEnabled'.
   */
  public MerchantProperties setRemoveTaxEnabled(java.lang.Boolean removeTaxEnabled) {
    return genClient.setOther(removeTaxEnabled, CacheKey.removeTaxEnabled);
  }

  /**
   * Sets the field 'groupLineItems'.
   */
  public MerchantProperties setGroupLineItems(java.lang.Boolean groupLineItems) {
    return genClient.setOther(groupLineItems, CacheKey.groupLineItems);
  }

  /**
   * Sets the field 'alternateInventoryNames'.
   */
  public MerchantProperties setAlternateInventoryNames(java.lang.Boolean alternateInventoryNames) {
    return genClient.setOther(alternateInventoryNames, CacheKey.alternateInventoryNames);
  }

  /**
   * Sets the field 'autoPrint'.
   */
  public MerchantProperties setAutoPrint(java.lang.Boolean autoPrint) {
    return genClient.setOther(autoPrint, CacheKey.autoPrint);
  }

  /**
   * Sets the field 'hardwareProfile'.
   */
  public MerchantProperties setHardwareProfile(java.lang.String hardwareProfile) {
    return genClient.setOther(hardwareProfile, CacheKey.hardwareProfile);
  }

  /**
   * Sets the field 'infoleaseSuppressBilling'.
   */
  public MerchantProperties setInfoleaseSuppressBilling(java.lang.Boolean infoleaseSuppressBilling) {
    return genClient.setOther(infoleaseSuppressBilling, CacheKey.infoleaseSuppressBilling);
  }

  /**
   * Sets the field 'infoleaseSuppressPlanBilling'.
   */
  public MerchantProperties setInfoleaseSuppressPlanBilling(java.lang.Boolean infoleaseSuppressPlanBilling) {
    return genClient.setOther(infoleaseSuppressPlanBilling, CacheKey.infoleaseSuppressPlanBilling);
  }

  /**
   * Sets the field 'shippingAddress'.
   */
  public MerchantProperties setShippingAddress(java.lang.String shippingAddress) {
    return genClient.setOther(shippingAddress, CacheKey.shippingAddress);
  }

  /**
   * Sets the field 'marketingEnabled'.
   */
  public MerchantProperties setMarketingEnabled(java.lang.Boolean marketingEnabled) {
    return genClient.setOther(marketingEnabled, CacheKey.marketingEnabled);
  }

  /**
   * Sets the field 'marketingPreferenceText'.
   */
  public MerchantProperties setMarketingPreferenceText(java.lang.String marketingPreferenceText) {
    return genClient.setOther(marketingPreferenceText, CacheKey.marketingPreferenceText);
  }

  /**
   * Sets the field 'bankMarker'.
   */
  public MerchantProperties setBankMarker(java.lang.Integer bankMarker) {
    return genClient.setOther(bankMarker, CacheKey.bankMarker);
  }

  /**
   * Sets the field 'supportPhone'.
   */
  public MerchantProperties setSupportPhone(java.lang.String supportPhone) {
    return genClient.setOther(supportPhone, CacheKey.supportPhone);
  }

  /**
   * Sets the field 'supportEmail'.
   */
  public MerchantProperties setSupportEmail(java.lang.String supportEmail) {
    return genClient.setOther(supportEmail, CacheKey.supportEmail);
  }

  /**
   * Sets the field 'manualCloseout'.
   */
  public MerchantProperties setManualCloseout(java.lang.Boolean manualCloseout) {
    return genClient.setOther(manualCloseout, CacheKey.manualCloseout);
  }

  /**
   * Sets the field 'showCloseoutOrders'.
   */
  public MerchantProperties setShowCloseoutOrders(java.lang.Boolean showCloseoutOrders) {
    return genClient.setOther(showCloseoutOrders, CacheKey.showCloseoutOrders);
  }

  /**
   * Sets the field 'sendCloseoutEmail'.
   */
  public MerchantProperties setSendCloseoutEmail(java.lang.Boolean sendCloseoutEmail) {
    return genClient.setOther(sendCloseoutEmail, CacheKey.sendCloseoutEmail);
  }

  /**
   * Sets the field 'stayInCategory'.
   */
  public MerchantProperties setStayInCategory(java.lang.Boolean stayInCategory) {
    return genClient.setOther(stayInCategory, CacheKey.stayInCategory);
  }

  /**
   * Sets the field 'locale'.
   */
  public MerchantProperties setLocale(java.lang.String locale) {
    return genClient.setOther(locale, CacheKey.locale);
  }

  /**
   * Sets the field 'timezone'.
   */
  public MerchantProperties setTimezone(java.lang.String timezone) {
    return genClient.setOther(timezone, CacheKey.timezone);
  }

  /**
   * Sets the field 'vat'.
   */
  public MerchantProperties setVat(java.lang.Boolean vat) {
    return genClient.setOther(vat, CacheKey.vat);
  }

  /**
   * Sets the field 'vatTaxName'.
   */
  public MerchantProperties setVatTaxName(java.lang.String vatTaxName) {
    return genClient.setOther(vatTaxName, CacheKey.vatTaxName);
  }

  /**
   * Sets the field 'appBillingSystem'.
   */
  public MerchantProperties setAppBillingSystem(java.lang.String appBillingSystem) {
    return genClient.setOther(appBillingSystem, CacheKey.appBillingSystem);
  }

  /**
   * Sets the field 'abaAccountNumber'.
   */
  public MerchantProperties setAbaAccountNumber(java.lang.String abaAccountNumber) {
    return genClient.setOther(abaAccountNumber, CacheKey.abaAccountNumber);
  }

  /**
   * Sets the field 'ddaAccountNumber'.
   */
  public MerchantProperties setDdaAccountNumber(java.lang.String ddaAccountNumber) {
    return genClient.setOther(ddaAccountNumber, CacheKey.ddaAccountNumber);
  }

  /**
   * Sets the field 'trackStock'.
   */
  public MerchantProperties setTrackStock(java.lang.Boolean trackStock) {
    return genClient.setOther(trackStock, CacheKey.trackStock);
  }

  /**
   * Sets the field 'updateStock'.
   */
  public MerchantProperties setUpdateStock(java.lang.Boolean updateStock) {
    return genClient.setOther(updateStock, CacheKey.updateStock);
  }

  /**
   * Sets the field 'allowClockOutWithOpenOrders'.
   */
  public MerchantProperties setAllowClockOutWithOpenOrders(java.lang.Boolean allowClockOutWithOpenOrders) {
    return genClient.setOther(allowClockOutWithOpenOrders, CacheKey.allowClockOutWithOpenOrders);
  }

  /**
   * Sets the field 'logInClockInPrompt'.
   */
  public MerchantProperties setLogInClockInPrompt(java.lang.Boolean logInClockInPrompt) {
    return genClient.setOther(logInClockInPrompt, CacheKey.logInClockInPrompt);
  }

  /**
   * Sets the field 'accountType'.
   */
  public MerchantProperties setAccountType(java.lang.String accountType) {
    return genClient.setOther(accountType, CacheKey.accountType);
  }

  /**
   * Sets the field 'businessTypeCode'.
   */
  public MerchantProperties setBusinessTypeCode(com.clover.sdk.v3.base.BusinessTypeCode businessTypeCode) {
    return genClient.setOther(businessTypeCode, CacheKey.businessTypeCode);
  }

  /**
   * Sets the field 'pinLength'.
   */
  public MerchantProperties setPinLength(java.lang.Integer pinLength) {
    return genClient.setOther(pinLength, CacheKey.pinLength);
  }

  /**
   * Sets the field 'cashBackEnabled'.
   */
  public MerchantProperties setCashBackEnabled(java.lang.Boolean cashBackEnabled) {
    return genClient.setOther(cashBackEnabled, CacheKey.cashBackEnabled);
  }

  /**
   * Sets the field 'cashBackOptions'.
   */
  public MerchantProperties setCashBackOptions(java.lang.String cashBackOptions) {
    return genClient.setOther(cashBackOptions, CacheKey.cashBackOptions);
  }

  /**
   * Sets the field 'maxCashBack'.
   */
  public MerchantProperties setMaxCashBack(java.lang.Long maxCashBack) {
    return genClient.setOther(maxCashBack, CacheKey.maxCashBack);
  }

  /**
   * Sets the field 'hierarchy'.
   */
  public MerchantProperties setHierarchy(java.lang.String hierarchy) {
    return genClient.setOther(hierarchy, CacheKey.hierarchy);
  }

  /**
   * Sets the field 'hasConsented'.
   */
  public MerchantProperties setHasConsented(java.lang.Boolean hasConsented) {
    return genClient.setOther(hasConsented, CacheKey.hasConsented);
  }


  /** Clears the 'merchantRef' field, the 'has' method for this field will now return false */
  public void clearMerchantRef() {
    genClient.clear(CacheKey.merchantRef);
  }
  /** Clears the 'defaultCurrency' field, the 'has' method for this field will now return false */
  public void clearDefaultCurrency() {
    genClient.clear(CacheKey.defaultCurrency);
  }
  /** Clears the 'tipsEnabled' field, the 'has' method for this field will now return false */
  public void clearTipsEnabled() {
    genClient.clear(CacheKey.tipsEnabled);
  }
  /** Clears the 'receiptProperties' field, the 'has' method for this field will now return false */
  public void clearReceiptProperties() {
    genClient.clear(CacheKey.receiptProperties);
  }
  /** Clears the 'summaryHour' field, the 'has' method for this field will now return false */
  public void clearSummaryHour() {
    genClient.clear(CacheKey.summaryHour);
  }
  /** Clears the 'signatureThreshold' field, the 'has' method for this field will now return false */
  public void clearSignatureThreshold() {
    genClient.clear(CacheKey.signatureThreshold);
  }
  /** Clears the 'hasDefaultEmployee' field, the 'has' method for this field will now return false */
  public void clearHasDefaultEmployee() {
    genClient.clear(CacheKey.hasDefaultEmployee);
  }
  /** Clears the 'tipRateDefault' field, the 'has' method for this field will now return false */
  public void clearTipRateDefault() {
    genClient.clear(CacheKey.tipRateDefault);
  }
  /** Clears the 'onPaperTipSignatures' field, the 'has' method for this field will now return false */
  public void clearOnPaperTipSignatures() {
    genClient.clear(CacheKey.onPaperTipSignatures);
  }
  /** Clears the 'autoLogout' field, the 'has' method for this field will now return false */
  public void clearAutoLogout() {
    genClient.clear(CacheKey.autoLogout);
  }
  /** Clears the 'orderTitle' field, the 'has' method for this field will now return false */
  public void clearOrderTitle() {
    genClient.clear(CacheKey.orderTitle);
  }
  /** Clears the 'orderTitleMax' field, the 'has' method for this field will now return false */
  public void clearOrderTitleMax() {
    genClient.clear(CacheKey.orderTitleMax);
  }
  /** Clears the 'resetOnReportingTime' field, the 'has' method for this field will now return false */
  public void clearResetOnReportingTime() {
    genClient.clear(CacheKey.resetOnReportingTime);
  }
  /** Clears the 'notesOnOrders' field, the 'has' method for this field will now return false */
  public void clearNotesOnOrders() {
    genClient.clear(CacheKey.notesOnOrders);
  }
  /** Clears the 'deleteOrders' field, the 'has' method for this field will now return false */
  public void clearDeleteOrders() {
    genClient.clear(CacheKey.deleteOrders);
  }
  /** Clears the 'removeTaxEnabled' field, the 'has' method for this field will now return false */
  public void clearRemoveTaxEnabled() {
    genClient.clear(CacheKey.removeTaxEnabled);
  }
  /** Clears the 'groupLineItems' field, the 'has' method for this field will now return false */
  public void clearGroupLineItems() {
    genClient.clear(CacheKey.groupLineItems);
  }
  /** Clears the 'alternateInventoryNames' field, the 'has' method for this field will now return false */
  public void clearAlternateInventoryNames() {
    genClient.clear(CacheKey.alternateInventoryNames);
  }
  /** Clears the 'autoPrint' field, the 'has' method for this field will now return false */
  public void clearAutoPrint() {
    genClient.clear(CacheKey.autoPrint);
  }
  /** Clears the 'hardwareProfile' field, the 'has' method for this field will now return false */
  public void clearHardwareProfile() {
    genClient.clear(CacheKey.hardwareProfile);
  }
  /** Clears the 'infoleaseSuppressBilling' field, the 'has' method for this field will now return false */
  public void clearInfoleaseSuppressBilling() {
    genClient.clear(CacheKey.infoleaseSuppressBilling);
  }
  /** Clears the 'infoleaseSuppressPlanBilling' field, the 'has' method for this field will now return false */
  public void clearInfoleaseSuppressPlanBilling() {
    genClient.clear(CacheKey.infoleaseSuppressPlanBilling);
  }
  /** Clears the 'shippingAddress' field, the 'has' method for this field will now return false */
  public void clearShippingAddress() {
    genClient.clear(CacheKey.shippingAddress);
  }
  /** Clears the 'marketingEnabled' field, the 'has' method for this field will now return false */
  public void clearMarketingEnabled() {
    genClient.clear(CacheKey.marketingEnabled);
  }
  /** Clears the 'marketingPreferenceText' field, the 'has' method for this field will now return false */
  public void clearMarketingPreferenceText() {
    genClient.clear(CacheKey.marketingPreferenceText);
  }
  /** Clears the 'bankMarker' field, the 'has' method for this field will now return false */
  public void clearBankMarker() {
    genClient.clear(CacheKey.bankMarker);
  }
  /** Clears the 'supportPhone' field, the 'has' method for this field will now return false */
  public void clearSupportPhone() {
    genClient.clear(CacheKey.supportPhone);
  }
  /** Clears the 'supportEmail' field, the 'has' method for this field will now return false */
  public void clearSupportEmail() {
    genClient.clear(CacheKey.supportEmail);
  }
  /** Clears the 'manualCloseout' field, the 'has' method for this field will now return false */
  public void clearManualCloseout() {
    genClient.clear(CacheKey.manualCloseout);
  }
  /** Clears the 'showCloseoutOrders' field, the 'has' method for this field will now return false */
  public void clearShowCloseoutOrders() {
    genClient.clear(CacheKey.showCloseoutOrders);
  }
  /** Clears the 'sendCloseoutEmail' field, the 'has' method for this field will now return false */
  public void clearSendCloseoutEmail() {
    genClient.clear(CacheKey.sendCloseoutEmail);
  }
  /** Clears the 'stayInCategory' field, the 'has' method for this field will now return false */
  public void clearStayInCategory() {
    genClient.clear(CacheKey.stayInCategory);
  }
  /** Clears the 'locale' field, the 'has' method for this field will now return false */
  public void clearLocale() {
    genClient.clear(CacheKey.locale);
  }
  /** Clears the 'timezone' field, the 'has' method for this field will now return false */
  public void clearTimezone() {
    genClient.clear(CacheKey.timezone);
  }
  /** Clears the 'vat' field, the 'has' method for this field will now return false */
  public void clearVat() {
    genClient.clear(CacheKey.vat);
  }
  /** Clears the 'vatTaxName' field, the 'has' method for this field will now return false */
  public void clearVatTaxName() {
    genClient.clear(CacheKey.vatTaxName);
  }
  /** Clears the 'appBillingSystem' field, the 'has' method for this field will now return false */
  public void clearAppBillingSystem() {
    genClient.clear(CacheKey.appBillingSystem);
  }
  /** Clears the 'abaAccountNumber' field, the 'has' method for this field will now return false */
  public void clearAbaAccountNumber() {
    genClient.clear(CacheKey.abaAccountNumber);
  }
  /** Clears the 'ddaAccountNumber' field, the 'has' method for this field will now return false */
  public void clearDdaAccountNumber() {
    genClient.clear(CacheKey.ddaAccountNumber);
  }
  /** Clears the 'trackStock' field, the 'has' method for this field will now return false */
  public void clearTrackStock() {
    genClient.clear(CacheKey.trackStock);
  }
  /** Clears the 'updateStock' field, the 'has' method for this field will now return false */
  public void clearUpdateStock() {
    genClient.clear(CacheKey.updateStock);
  }
  /** Clears the 'allowClockOutWithOpenOrders' field, the 'has' method for this field will now return false */
  public void clearAllowClockOutWithOpenOrders() {
    genClient.clear(CacheKey.allowClockOutWithOpenOrders);
  }
  /** Clears the 'logInClockInPrompt' field, the 'has' method for this field will now return false */
  public void clearLogInClockInPrompt() {
    genClient.clear(CacheKey.logInClockInPrompt);
  }
  /** Clears the 'accountType' field, the 'has' method for this field will now return false */
  public void clearAccountType() {
    genClient.clear(CacheKey.accountType);
  }
  /** Clears the 'businessTypeCode' field, the 'has' method for this field will now return false */
  public void clearBusinessTypeCode() {
    genClient.clear(CacheKey.businessTypeCode);
  }
  /** Clears the 'pinLength' field, the 'has' method for this field will now return false */
  public void clearPinLength() {
    genClient.clear(CacheKey.pinLength);
  }
  /** Clears the 'cashBackEnabled' field, the 'has' method for this field will now return false */
  public void clearCashBackEnabled() {
    genClient.clear(CacheKey.cashBackEnabled);
  }
  /** Clears the 'cashBackOptions' field, the 'has' method for this field will now return false */
  public void clearCashBackOptions() {
    genClient.clear(CacheKey.cashBackOptions);
  }
  /** Clears the 'maxCashBack' field, the 'has' method for this field will now return false */
  public void clearMaxCashBack() {
    genClient.clear(CacheKey.maxCashBack);
  }
  /** Clears the 'hierarchy' field, the 'has' method for this field will now return false */
  public void clearHierarchy() {
    genClient.clear(CacheKey.hierarchy);
  }
  /** Clears the 'hasConsented' field, the 'has' method for this field will now return false */
  public void clearHasConsented() {
    genClient.clear(CacheKey.hasConsented);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantProperties copyChanges() {
    MerchantProperties copy = new MerchantProperties();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantProperties src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantProperties(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantProperties> CREATOR = new android.os.Parcelable.Creator<MerchantProperties>() {
    @Override
    public MerchantProperties createFromParcel(android.os.Parcel in) {
      MerchantProperties instance = new MerchantProperties(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantProperties[] newArray(int size) {
      return new MerchantProperties[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantProperties> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantProperties>() {
    @Override
    public MerchantProperties create(org.json.JSONObject jsonObject) {
      return new MerchantProperties(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean MERCHANTREF_IS_REQUIRED = false;
    public static final boolean DEFAULTCURRENCY_IS_REQUIRED = false;
    public static final long DEFAULTCURRENCY_MAX_LEN = 3;
    public static final boolean TIPSENABLED_IS_REQUIRED = false;
    public static final boolean RECEIPTPROPERTIES_IS_REQUIRED = false;
    public static final boolean SUMMARYHOUR_IS_REQUIRED = false;
    public static final boolean SIGNATURETHRESHOLD_IS_REQUIRED = false;
    public static final boolean HASDEFAULTEMPLOYEE_IS_REQUIRED = false;
    public static final boolean TIPRATEDEFAULT_IS_REQUIRED = false;
    public static final boolean ONPAPERTIPSIGNATURES_IS_REQUIRED = false;
    public static final boolean AUTOLOGOUT_IS_REQUIRED = false;
    public static final boolean ORDERTITLE_IS_REQUIRED = false;
    public static final boolean ORDERTITLEMAX_IS_REQUIRED = false;
    public static final boolean RESETONREPORTINGTIME_IS_REQUIRED = false;
    public static final boolean NOTESONORDERS_IS_REQUIRED = false;
    public static final boolean DELETEORDERS_IS_REQUIRED = false;
    public static final boolean REMOVETAXENABLED_IS_REQUIRED = false;
    public static final boolean GROUPLINEITEMS_IS_REQUIRED = false;
    public static final boolean ALTERNATEINVENTORYNAMES_IS_REQUIRED = false;
    public static final boolean AUTOPRINT_IS_REQUIRED = false;
    public static final boolean HARDWAREPROFILE_IS_REQUIRED = false;
    public static final long HARDWAREPROFILE_MAX_LEN = 127;
    public static final boolean INFOLEASESUPPRESSBILLING_IS_REQUIRED = false;
    public static final boolean INFOLEASESUPPRESSPLANBILLING_IS_REQUIRED = false;
    public static final boolean SHIPPINGADDRESS_IS_REQUIRED = false;
    public static final boolean MARKETINGENABLED_IS_REQUIRED = false;
    public static final boolean MARKETINGPREFERENCETEXT_IS_REQUIRED = false;
    public static final long MARKETINGPREFERENCETEXT_MAX_LEN = 255;
    public static final boolean BANKMARKER_IS_REQUIRED = false;
    public static final boolean SUPPORTPHONE_IS_REQUIRED = false;
    public static final long SUPPORTPHONE_MAX_LEN = 25;
    public static final boolean SUPPORTEMAIL_IS_REQUIRED = false;
    public static final long SUPPORTEMAIL_MAX_LEN = 127;
    public static final boolean MANUALCLOSEOUT_IS_REQUIRED = false;
    public static final boolean SHOWCLOSEOUTORDERS_IS_REQUIRED = false;
    public static final boolean SENDCLOSEOUTEMAIL_IS_REQUIRED = false;
    public static final boolean STAYINCATEGORY_IS_REQUIRED = false;
    public static final boolean LOCALE_IS_REQUIRED = false;
    public static final boolean TIMEZONE_IS_REQUIRED = false;
    public static final long TIMEZONE_MAX_LEN = 255;
    public static final boolean VAT_IS_REQUIRED = false;
    public static final boolean VATTAXNAME_IS_REQUIRED = false;
    public static final long VATTAXNAME_MAX_LEN = 255;
    public static final boolean APPBILLINGSYSTEM_IS_REQUIRED = false;
    public static final long APPBILLINGSYSTEM_MAX_LEN = 10;
    public static final boolean ABAACCOUNTNUMBER_IS_REQUIRED = false;
    public static final long ABAACCOUNTNUMBER_MAX_LEN = 40;
    public static final boolean DDAACCOUNTNUMBER_IS_REQUIRED = false;
    public static final long DDAACCOUNTNUMBER_MAX_LEN = 40;
    public static final boolean TRACKSTOCK_IS_REQUIRED = false;
    public static final boolean UPDATESTOCK_IS_REQUIRED = false;
    public static final boolean ALLOWCLOCKOUTWITHOPENORDERS_IS_REQUIRED = false;
    public static final boolean LOGINCLOCKINPROMPT_IS_REQUIRED = false;
    public static final boolean ACCOUNTTYPE_IS_REQUIRED = false;
    public static final boolean BUSINESSTYPECODE_IS_REQUIRED = false;
    public static final boolean PINLENGTH_IS_REQUIRED = false;
    public static final boolean CASHBACKENABLED_IS_REQUIRED = false;
    public static final boolean CASHBACKOPTIONS_IS_REQUIRED = false;
    public static final boolean MAXCASHBACK_IS_REQUIRED = false;
    public static final boolean HIERARCHY_IS_REQUIRED = false;
    public static final long HIERARCHY_MAX_LEN = 127;
    public static final boolean HASCONSENTED_IS_REQUIRED = false;

  }

}
