/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getItem item}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getAlternateName alternateName}</li>
 * <li>{@link #getPrice price}</li>
 * <li>{@link #getUnitQty unitQty}</li>
 * <li>{@link #getUnitName unitName}</li>
 * <li>{@link #getItemCode itemCode}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getPrinted printed}</li>
 * <li>{@link #getExchangedLineItem exchangedLineItem}</li>
 * <li>{@link #getBinName binName}</li>
 * <li>{@link #getUserData userData}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getOrderClientCreatedTime orderClientCreatedTime}</li>
 * <li>{@link #getDiscounts discounts}</li>
 * <li>{@link #getDiscountAmount discountAmount}</li>
 * <li>{@link #getExchanged exchanged}</li>
 * <li>{@link #getModifications modifications}</li>
 * <li>{@link #getRefunded refunded}</li>
 * <li>{@link #getIsRevenue isRevenue}</li>
 * <li>{@link #getTaxRates taxRates}</li>
 * <li>{@link #getPayments payments}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.order.IOrderService
 */
@SuppressWarnings("all")
public class LineItem extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier.
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * A reference to the inventory item that was used to create this line item.
   */
  public com.clover.sdk.v3.base.Reference getItem() {
    return genClient.cacheGet(CacheKey.item);
  }

  /**
   * Line item name
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Alternate name of the line item.
   */
  public java.lang.String getAlternateName() {
    return genClient.cacheGet(CacheKey.alternateName);
  }

  /**
   * Price of the item, typically in cents; use priceType and merchant currency to determine actual item price.
   */
  public java.lang.Long getPrice() {
    return genClient.cacheGet(CacheKey.price);
  }

  /**
   * Unit quantity if this line item is priced by quantity instead of having a fixed price.
   */
  public java.lang.Integer getUnitQty() {
    return genClient.cacheGet(CacheKey.unitQty);
  }

  /**
   * Unit name (e.g. oz, lb, etc.)
   */
  public java.lang.String getUnitName() {
    return genClient.cacheGet(CacheKey.unitName);
  }

  public java.lang.String getItemCode() {
    return genClient.cacheGet(CacheKey.itemCode);
  }

  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  /**
   * True if this line item has been printed out on an order printer at least once already.
   */
  public java.lang.Boolean getPrinted() {
    return genClient.cacheGet(CacheKey.printed);
  }

  public com.clover.sdk.v3.base.Reference getExchangedLineItem() {
    return genClient.cacheGet(CacheKey.exchangedLineItem);
  }

  public java.lang.String getBinName() {
    return genClient.cacheGet(CacheKey.binName);
  }

  public java.lang.String getUserData() {
    return genClient.cacheGet(CacheKey.userData);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getOrderClientCreatedTime() {
    return genClient.cacheGet(CacheKey.orderClientCreatedTime);
  }

  /**
   * List of references to of Order discounts.
   */
  public java.util.List<com.clover.sdk.v3.order.Discount> getDiscounts() {
    return genClient.cacheGet(CacheKey.discounts);
  }

  /**
   * Unnamed fixed discount amount in cents.
   */
  public java.lang.Long getDiscountAmount() {
    return genClient.cacheGet(CacheKey.discountAmount);
  }

  public java.lang.Boolean getExchanged() {
    return genClient.cacheGet(CacheKey.exchanged);
  }

  /**
   * List of references to modifications applied to this line item.
   */
  public java.util.List<com.clover.sdk.v3.order.Modification> getModifications() {
    return genClient.cacheGet(CacheKey.modifications);
  }

  /**
   * True if this line item has been refunded
   */
  public java.lang.Boolean getRefunded() {
    return genClient.cacheGet(CacheKey.refunded);
  }

  /**
   * True if this item should be counted as revenue, for example gift cards and donations would not.
   */
  public java.lang.Boolean getIsRevenue() {
    return genClient.cacheGet(CacheKey.isRevenue);
  }

  /**
   * Tax rates that apply to this line item
   */
  public java.util.List<com.clover.sdk.v3.inventory.TaxRate> getTaxRates() {
    return genClient.cacheGet(CacheKey.taxRates);
  }

  /**
   * Payments that apply to this line item
   */
  public java.util.List<com.clover.sdk.v3.payments.LineItemPayment> getPayments() {
    return genClient.cacheGet(CacheKey.payments);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<LineItem> {
    id {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    item {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractRecord("item", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    name {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("name", java.lang.String.class);
      }
    },
    alternateName {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("alternateName", java.lang.String.class);
      }
    },
    price {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("price", java.lang.Long.class);
      }
    },
    unitQty {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("unitQty", java.lang.Integer.class);
      }
    },
    unitName {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("unitName", java.lang.String.class);
      }
    },
    itemCode {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("itemCode", java.lang.String.class);
      }
    },
    note {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("note", java.lang.String.class);
      }
    },
    printed {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("printed", java.lang.Boolean.class);
      }
    },
    exchangedLineItem {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractRecord("exchangedLineItem", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    binName {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("binName", java.lang.String.class);
      }
    },
    userData {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("userData", java.lang.String.class);
      }
    },
    createdTime {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("createdTime", java.lang.Long.class);
      }
    },
    orderClientCreatedTime {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("orderClientCreatedTime", java.lang.Long.class);
      }
    },
    discounts {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractListRecord("discounts", com.clover.sdk.v3.order.Discount.JSON_CREATOR);
      }
    },
    discountAmount {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("discountAmount", java.lang.Long.class);
      }
    },
    exchanged {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("exchanged", java.lang.Boolean.class);
      }
    },
    modifications {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractListRecord("modifications", com.clover.sdk.v3.order.Modification.JSON_CREATOR);
      }
    },
    refunded {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("refunded", java.lang.Boolean.class);
      }
    },
    isRevenue {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractOther("isRevenue", java.lang.Boolean.class);
      }
    },
    taxRates {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractListRecord("taxRates", com.clover.sdk.v3.inventory.TaxRate.JSON_CREATOR);
      }
    },
    payments {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.genClient.extractListRecord("payments", com.clover.sdk.v3.payments.LineItemPayment.JSON_CREATOR);
      }
    },
      ;
  }

  private GenericClient<LineItem> genClient;

  /**
  * Constructs a new empty instance.
  */
  public LineItem() {
    genClient = new GenericClient<LineItem>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected LineItem(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LineItem(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LineItem(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LineItem(LineItem src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getName(), 127);

    genClient.validateLength(getAlternateName(), 127);

    if (getUnitQty() != null && ( getUnitQty() < 0)) throw new IllegalArgumentException("Invalid value for 'getUnitQty()'");

    genClient.validateLength(getUnitName(), 64);

    genClient.validateLength(getItemCode(), 100);

    genClient.validateLength(getNote(), 255);

    genClient.validateLength(getBinName(), 127);

    genClient.validateLength(getUserData(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'item' field is set and is not null */
  public boolean isNotNullItem() {
    return genClient.cacheValueIsNotNull(CacheKey.item);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return genClient.cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return genClient.cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'unitQty' field is set and is not null */
  public boolean isNotNullUnitQty() {
    return genClient.cacheValueIsNotNull(CacheKey.unitQty);
  }

  /** Checks whether the 'unitName' field is set and is not null */
  public boolean isNotNullUnitName() {
    return genClient.cacheValueIsNotNull(CacheKey.unitName);
  }

  /** Checks whether the 'itemCode' field is set and is not null */
  public boolean isNotNullItemCode() {
    return genClient.cacheValueIsNotNull(CacheKey.itemCode);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'printed' field is set and is not null */
  public boolean isNotNullPrinted() {
    return genClient.cacheValueIsNotNull(CacheKey.printed);
  }

  /** Checks whether the 'exchangedLineItem' field is set and is not null */
  public boolean isNotNullExchangedLineItem() {
    return genClient.cacheValueIsNotNull(CacheKey.exchangedLineItem);
  }

  /** Checks whether the 'binName' field is set and is not null */
  public boolean isNotNullBinName() {
    return genClient.cacheValueIsNotNull(CacheKey.binName);
  }

  /** Checks whether the 'userData' field is set and is not null */
  public boolean isNotNullUserData() {
    return genClient.cacheValueIsNotNull(CacheKey.userData);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'orderClientCreatedTime' field is set and is not null */
  public boolean isNotNullOrderClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.orderClientCreatedTime);
  }

  /** Checks whether the 'discounts' field is set and is not null */
  public boolean isNotNullDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.discounts);
  }

  /** Checks whether the 'discounts' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscounts() { return isNotNullDiscounts() && !getDiscounts().isEmpty(); }

  /** Checks whether the 'discountAmount' field is set and is not null */
  public boolean isNotNullDiscountAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.discountAmount);
  }

  /** Checks whether the 'exchanged' field is set and is not null */
  public boolean isNotNullExchanged() {
    return genClient.cacheValueIsNotNull(CacheKey.exchanged);
  }

  /** Checks whether the 'modifications' field is set and is not null */
  public boolean isNotNullModifications() {
    return genClient.cacheValueIsNotNull(CacheKey.modifications);
  }

  /** Checks whether the 'modifications' field is set and is not null and is not empty */
  public boolean isNotEmptyModifications() { return isNotNullModifications() && !getModifications().isEmpty(); }

  /** Checks whether the 'refunded' field is set and is not null */
  public boolean isNotNullRefunded() {
    return genClient.cacheValueIsNotNull(CacheKey.refunded);
  }

  /** Checks whether the 'isRevenue' field is set and is not null */
  public boolean isNotNullIsRevenue() {
    return genClient.cacheValueIsNotNull(CacheKey.isRevenue);
  }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return genClient.cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() { return isNotNullTaxRates() && !getTaxRates().isEmpty(); }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() { return isNotNullPayments() && !getPayments().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'item' field has been set, however the value could be null */
  public boolean hasItem() {
    return genClient.cacheHasKey(CacheKey.item);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return genClient.cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return genClient.cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'unitQty' field has been set, however the value could be null */
  public boolean hasUnitQty() {
    return genClient.cacheHasKey(CacheKey.unitQty);
  }

  /** Checks whether the 'unitName' field has been set, however the value could be null */
  public boolean hasUnitName() {
    return genClient.cacheHasKey(CacheKey.unitName);
  }

  /** Checks whether the 'itemCode' field has been set, however the value could be null */
  public boolean hasItemCode() {
    return genClient.cacheHasKey(CacheKey.itemCode);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'printed' field has been set, however the value could be null */
  public boolean hasPrinted() {
    return genClient.cacheHasKey(CacheKey.printed);
  }

  /** Checks whether the 'exchangedLineItem' field has been set, however the value could be null */
  public boolean hasExchangedLineItem() {
    return genClient.cacheHasKey(CacheKey.exchangedLineItem);
  }

  /** Checks whether the 'binName' field has been set, however the value could be null */
  public boolean hasBinName() {
    return genClient.cacheHasKey(CacheKey.binName);
  }

  /** Checks whether the 'userData' field has been set, however the value could be null */
  public boolean hasUserData() {
    return genClient.cacheHasKey(CacheKey.userData);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'orderClientCreatedTime' field has been set, however the value could be null */
  public boolean hasOrderClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.orderClientCreatedTime);
  }

  /** Checks whether the 'discounts' field has been set, however the value could be null */
  public boolean hasDiscounts() {
    return genClient.cacheHasKey(CacheKey.discounts);
  }

  /** Checks whether the 'discountAmount' field has been set, however the value could be null */
  public boolean hasDiscountAmount() {
    return genClient.cacheHasKey(CacheKey.discountAmount);
  }

  /** Checks whether the 'exchanged' field has been set, however the value could be null */
  public boolean hasExchanged() {
    return genClient.cacheHasKey(CacheKey.exchanged);
  }

  /** Checks whether the 'modifications' field has been set, however the value could be null */
  public boolean hasModifications() {
    return genClient.cacheHasKey(CacheKey.modifications);
  }

  /** Checks whether the 'refunded' field has been set, however the value could be null */
  public boolean hasRefunded() {
    return genClient.cacheHasKey(CacheKey.refunded);
  }

  /** Checks whether the 'isRevenue' field has been set, however the value could be null */
  public boolean hasIsRevenue() {
    return genClient.cacheHasKey(CacheKey.isRevenue);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return genClient.cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return genClient.cacheHasKey(CacheKey.payments);
  }


  /**
   * Sets the field 'id'.
   */
  public LineItem setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'item'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setItem(com.clover.sdk.v3.base.Reference item) {
    return genClient.setRecord(item, CacheKey.item);
  }

  /**
   * Sets the field 'name'.
   */
  public LineItem setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'alternateName'.
   */
  public LineItem setAlternateName(java.lang.String alternateName) {
    return genClient.setOther(alternateName, CacheKey.alternateName);
  }

  /**
   * Sets the field 'price'.
   */
  public LineItem setPrice(java.lang.Long price) {
    return genClient.setOther(price, CacheKey.price);
  }

  /**
   * Sets the field 'unitQty'.
   */
  public LineItem setUnitQty(java.lang.Integer unitQty) {
    return genClient.setOther(unitQty, CacheKey.unitQty);
  }

  /**
   * Sets the field 'unitName'.
   */
  public LineItem setUnitName(java.lang.String unitName) {
    return genClient.setOther(unitName, CacheKey.unitName);
  }

  /**
   * Sets the field 'itemCode'.
   */
  public LineItem setItemCode(java.lang.String itemCode) {
    return genClient.setOther(itemCode, CacheKey.itemCode);
  }

  /**
   * Sets the field 'note'.
   */
  public LineItem setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'printed'.
   */
  public LineItem setPrinted(java.lang.Boolean printed) {
    return genClient.setOther(printed, CacheKey.printed);
  }

  /**
   * Sets the field 'exchangedLineItem'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setExchangedLineItem(com.clover.sdk.v3.base.Reference exchangedLineItem) {
    return genClient.setRecord(exchangedLineItem, CacheKey.exchangedLineItem);
  }

  /**
   * Sets the field 'binName'.
   */
  public LineItem setBinName(java.lang.String binName) {
    return genClient.setOther(binName, CacheKey.binName);
  }

  /**
   * Sets the field 'userData'.
   */
  public LineItem setUserData(java.lang.String userData) {
    return genClient.setOther(userData, CacheKey.userData);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public LineItem setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'orderClientCreatedTime'.
   */
  public LineItem setOrderClientCreatedTime(java.lang.Long orderClientCreatedTime) {
    return genClient.setOther(orderClientCreatedTime, CacheKey.orderClientCreatedTime);
  }

  /**
   * Sets the field 'discounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setDiscounts(java.util.List<com.clover.sdk.v3.order.Discount> discounts) {
    return genClient.setArrayRecord(discounts, CacheKey.discounts);
  }

  /**
   * Sets the field 'discountAmount'.
   */
  public LineItem setDiscountAmount(java.lang.Long discountAmount) {
    return genClient.setOther(discountAmount, CacheKey.discountAmount);
  }

  /**
   * Sets the field 'exchanged'.
   */
  public LineItem setExchanged(java.lang.Boolean exchanged) {
    return genClient.setOther(exchanged, CacheKey.exchanged);
  }

  /**
   * Sets the field 'modifications'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setModifications(java.util.List<com.clover.sdk.v3.order.Modification> modifications) {
    return genClient.setArrayRecord(modifications, CacheKey.modifications);
  }

  /**
   * Sets the field 'refunded'.
   */
  public LineItem setRefunded(java.lang.Boolean refunded) {
    return genClient.setOther(refunded, CacheKey.refunded);
  }

  /**
   * Sets the field 'isRevenue'.
   */
  public LineItem setIsRevenue(java.lang.Boolean isRevenue) {
    return genClient.setOther(isRevenue, CacheKey.isRevenue);
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setTaxRates(java.util.List<com.clover.sdk.v3.inventory.TaxRate> taxRates) {
    return genClient.setArrayRecord(taxRates, CacheKey.taxRates);
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setPayments(java.util.List<com.clover.sdk.v3.payments.LineItemPayment> payments) {
    return genClient.setArrayRecord(payments, CacheKey.payments);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'item' field, the 'has' method for this field will now return false */
  public void clearItem() {
    genClient.clear(CacheKey.item);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    genClient.clear(CacheKey.alternateName);
  }
  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    genClient.clear(CacheKey.price);
  }
  /** Clears the 'unitQty' field, the 'has' method for this field will now return false */
  public void clearUnitQty() {
    genClient.clear(CacheKey.unitQty);
  }
  /** Clears the 'unitName' field, the 'has' method for this field will now return false */
  public void clearUnitName() {
    genClient.clear(CacheKey.unitName);
  }
  /** Clears the 'itemCode' field, the 'has' method for this field will now return false */
  public void clearItemCode() {
    genClient.clear(CacheKey.itemCode);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'printed' field, the 'has' method for this field will now return false */
  public void clearPrinted() {
    genClient.clear(CacheKey.printed);
  }
  /** Clears the 'exchangedLineItem' field, the 'has' method for this field will now return false */
  public void clearExchangedLineItem() {
    genClient.clear(CacheKey.exchangedLineItem);
  }
  /** Clears the 'binName' field, the 'has' method for this field will now return false */
  public void clearBinName() {
    genClient.clear(CacheKey.binName);
  }
  /** Clears the 'userData' field, the 'has' method for this field will now return false */
  public void clearUserData() {
    genClient.clear(CacheKey.userData);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'orderClientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearOrderClientCreatedTime() {
    genClient.clear(CacheKey.orderClientCreatedTime);
  }
  /** Clears the 'discounts' field, the 'has' method for this field will now return false */
  public void clearDiscounts() {
    genClient.clear(CacheKey.discounts);
  }
  /** Clears the 'discountAmount' field, the 'has' method for this field will now return false */
  public void clearDiscountAmount() {
    genClient.clear(CacheKey.discountAmount);
  }
  /** Clears the 'exchanged' field, the 'has' method for this field will now return false */
  public void clearExchanged() {
    genClient.clear(CacheKey.exchanged);
  }
  /** Clears the 'modifications' field, the 'has' method for this field will now return false */
  public void clearModifications() {
    genClient.clear(CacheKey.modifications);
  }
  /** Clears the 'refunded' field, the 'has' method for this field will now return false */
  public void clearRefunded() {
    genClient.clear(CacheKey.refunded);
  }
  /** Clears the 'isRevenue' field, the 'has' method for this field will now return false */
  public void clearIsRevenue() {
    genClient.clear(CacheKey.isRevenue);
  }
  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    genClient.clear(CacheKey.taxRates);
  }
  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    genClient.clear(CacheKey.payments);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LineItem copyChanges() {
    LineItem copy = new LineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LineItem src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LineItem(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LineItem> CREATOR = new android.os.Parcelable.Creator<LineItem>() {
    @Override
    public LineItem createFromParcel(android.os.Parcel in) {
      LineItem instance = new LineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LineItem[] newArray(int size) {
      return new LineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LineItem>() {
    @Override
    public LineItem create(org.json.JSONObject jsonObject) {
      return new LineItem(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ITEM_IS_REQUIRED = false;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 127;
    public static final boolean PRICE_IS_REQUIRED = false;
    public static final boolean UNITQTY_IS_REQUIRED = false;
    public static final long UNITQTY_MIN = 0;
    public static final boolean UNITNAME_IS_REQUIRED = false;
    public static final long UNITNAME_MAX_LEN = 64;
    public static final boolean ITEMCODE_IS_REQUIRED = false;
    public static final long ITEMCODE_MAX_LEN = 100;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean PRINTED_IS_REQUIRED = false;
    public static final boolean EXCHANGEDLINEITEM_IS_REQUIRED = false;
    public static final boolean BINNAME_IS_REQUIRED = false;
    public static final long BINNAME_MAX_LEN = 127;
    public static final boolean USERDATA_IS_REQUIRED = false;
    public static final long USERDATA_MAX_LEN = 255;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean ORDERCLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean DISCOUNTS_IS_REQUIRED = false;
    public static final boolean DISCOUNTAMOUNT_IS_REQUIRED = false;
    public static final boolean EXCHANGED_IS_REQUIRED = false;
    public static final boolean MODIFICATIONS_IS_REQUIRED = false;
    public static final boolean REFUNDED_IS_REQUIRED = false;
    public static final boolean ISREVENUE_IS_REQUIRED = false;
    public static final boolean TAXRATES_IS_REQUIRED = false;
    public static final boolean PAYMENTS_IS_REQUIRED = false;

  }

}
