/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * The Order object is at the core of Clover’s transaction data. Almost every transaction either creates or updates an Order. When an order is created or updated via one of the Clover SDKs, the order data is automatically synchronized between the Clover Server and the merchant’s Clover devices.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getCurrency currency}</li>
 * <li>{@link #getCustomers customers}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getTotal total}</li>
 * <li>{@link #getTitle title}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getOrderType orderType}</li>
 * <li>{@link #getTaxRemoved taxRemoved}</li>
 * <li>{@link #getIsVat isVat}</li>
 * <li>{@link #getState state}</li>
 * <li>{@link #getManualTransaction manualTransaction}</li>
 * <li>{@link #getGroupLineItems groupLineItems}</li>
 * <li>{@link #getTestMode testMode}</li>
 * <li>{@link #getPayType payType}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getClientCreatedTime clientCreatedTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getDeletedTimestamp deletedTimestamp}</li>
 * <li>{@link #getServiceCharge serviceCharge}</li>
 * <li>{@link #getDiscounts discounts}</li>
 * <li>{@link #getLineItems lineItems}</li>
 * <li>{@link #getPayments payments}</li>
 * <li>{@link #getRefunds refunds}</li>
 * <li>{@link #getCredits credits}</li>
 * <li>{@link #getVoids voids}</li>
 * <li>{@link #getPreAuths preAuths}</li>
 * <li>{@link #getDevice device}</li>
 * <li>{@link #getAuthorizations authorizations}</li>
 * </ul>
 * <p>
 * @see com.clover.sdk.v3.order.IOrderService
 */
@SuppressWarnings("all")
public class Order extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Currency of this order. For example, "USD"
   */
  public java.lang.String getCurrency() {
    return genClient.cacheGet(CacheKey.currency);
  }

  /**
   * List of customers associated with this order.
   */
  public java.util.List<com.clover.sdk.v3.customers.Customer> getCustomers() {
    return genClient.cacheGet(CacheKey.customers);
  }

  /**
   * The employee who took this order
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * Total price of the order in cents
   */
  public java.lang.Long getTotal() {
    return genClient.cacheGet(CacheKey.total);
  }

  public java.lang.String getTitle() {
    return genClient.cacheGet(CacheKey.title);
  }

  /**
   * An arbitrary string with information about this order, may be printed on the order receipt and displayed in apps
   */
  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  public com.clover.sdk.v3.order.OrderType getOrderType() {
    return genClient.cacheGet(CacheKey.orderType);
  }

  /**
   * If true then this order should not have taxes applied to it
   */
  public java.lang.Boolean getTaxRemoved() {
    return genClient.cacheGet(CacheKey.taxRemoved);
  }

  /**
   * This order was created by merchant with VAT enabled.
   */
  public java.lang.Boolean getIsVat() {
    return genClient.cacheGet(CacheKey.isVat);
  }

  /**
   * A String generally describing the state of this Order. The value null indicates an empty Order that is not displayed in user interfaces. Other value such as "open" and "locked" are not checked or enforced by client or server and thus are not useful for making any logical decisions about this Order.
   */
  public java.lang.String getState() {
    return genClient.cacheGet(CacheKey.state);
  }

  /**
   * Whether this order represents a manual transaction. A manual transaction is a transaction that has an arbitrary amount defined and is not associated with any inventory items. For example, the Clover Sale App and Clover Manual Transaction App create manual transactions. A manual transactions will have a single associated line item to hold the sale amount, but the generated receipt will display this differently to indicate that it is not considered a typical order with inventory items.
   */
  public java.lang.Boolean getManualTransaction() {
    return genClient.cacheGet(CacheKey.manualTransaction);
  }

  /**
   * Whether similar line items should be grouped together on the receipt that this order generates. Item "similarity" is based on items having matching values for a set of properties including price, modifiers, and discounts.
   */
  public java.lang.Boolean getGroupLineItems() {
    return genClient.cacheGet(CacheKey.groupLineItems);
  }

  /**
   * Whether this order was created in test mode. Payments made against test orders are not processed. Test mode orders can be deleted from the Orders App on the merchant's device or web dashboard (https://www.clover.com/orders/m/{mId}/orders). They will also be deleted when the device sends a POST to the /v2/merchant/{mId}/orders/delete_all_tests endpoint.
   */
  public java.lang.Boolean getTestMode() {
    return genClient.cacheGet(CacheKey.testMode);
  }

  /**
   * Possible values: SPLIT_GUEST, SPLIT_ITEM, SPLIT_CUSTOM, FULL. During the payment flow, if the user chooses to split the payment for this order, this field will be set to one of the SPLIT_* values to indicate how the full amount should be split. If the user chooses to pay for the order in full with one payment, then this field will be FULL.
   */
  public com.clover.sdk.v3.order.PayType getPayType() {
    return genClient.cacheGet(CacheKey.payType);
  }

  /**
   * Creation timestamp
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * The time at which the client created this order
   */
  public java.lang.Long getClientCreatedTime() {
    return genClient.cacheGet(CacheKey.clientCreatedTime);
  }

  /**
   * Last modified time of the order
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  public java.lang.Long getDeletedTimestamp() {
    return genClient.cacheGet(CacheKey.deletedTimestamp);
  }

  /**
   * Optional service charge (gratuity) applied to this order
   */
  public com.clover.sdk.v3.base.ServiceCharge getServiceCharge() {
    return genClient.cacheGet(CacheKey.serviceCharge);
  }

  /**
   * Discounts applied to this order
   */
  public java.util.List<com.clover.sdk.v3.order.Discount> getDiscounts() {
    return genClient.cacheGet(CacheKey.discounts);
  }

  /**
   * Line items associated with this order
   */
  public java.util.List<com.clover.sdk.v3.order.LineItem> getLineItems() {
    return genClient.cacheGet(CacheKey.lineItems);
  }

  /**
   * Payments that were made for this order. If multiple payments were made, then the payType field should reflect the method used to split the total amount.
   */
  public java.util.List<com.clover.sdk.v3.payments.Payment> getPayments() {
    return genClient.cacheGet(CacheKey.payments);
  }

  /**
   * Refunds that were made for this order
   */
  public java.util.List<com.clover.sdk.v3.payments.Refund> getRefunds() {
    return genClient.cacheGet(CacheKey.refunds);
  }

  /**
   * Credits associated with this order.
   */
  public java.util.List<com.clover.sdk.v3.payments.Credit> getCredits() {
    return genClient.cacheGet(CacheKey.credits);
  }

  /**
   * Voided payments associated with this order
   */
  public java.util.List<com.clover.sdk.v3.payments.Payment> getVoids() {
    return genClient.cacheGet(CacheKey.voids);
  }

  /**
   * PreAuthorizations associated with this order
   */
  public java.util.List<com.clover.sdk.v3.payments.Payment> getPreAuths() {
    return genClient.cacheGet(CacheKey.preAuths);
  }

  /**
   * Device which created the order
   */
  public com.clover.sdk.v3.base.Reference getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }

  /**
   * Card authorizations associated with this order
   */
  public java.util.List<com.clover.sdk.v3.payments.Authorization> getAuthorizations() {
    return genClient.cacheGet(CacheKey.authorizations);
  }



  public static final String AUTHORITY = "com.clover.orders";

  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<Order> {
    id {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    currency {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("currency", java.lang.String.class);
      }
    },
    customers {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("customers", com.clover.sdk.v3.customers.Customer.JSON_CREATOR);
      }
    },
    employee {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractRecord("employee", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    total {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("total", java.lang.Long.class);
      }
    },
    title {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("title", java.lang.String.class);
      }
    },
    note {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("note", java.lang.String.class);
      }
    },
    orderType {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractRecord("orderType", com.clover.sdk.v3.order.OrderType.JSON_CREATOR);
      }
    },
    taxRemoved {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("taxRemoved", java.lang.Boolean.class);
      }
    },
    isVat {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("isVat", java.lang.Boolean.class);
      }
    },
    state {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("state", java.lang.String.class);
      }
    },
    manualTransaction {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("manualTransaction", java.lang.Boolean.class);
      }
    },
    groupLineItems {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("groupLineItems", java.lang.Boolean.class);
      }
    },
    testMode {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("testMode", java.lang.Boolean.class);
      }
    },
    payType {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractEnum("payType", com.clover.sdk.v3.order.PayType.class);
      }
    },
    createdTime {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("createdTime", java.lang.Long.class);
      }
    },
    clientCreatedTime {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("clientCreatedTime", java.lang.Long.class);
      }
    },
    modifiedTime {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("modifiedTime", java.lang.Long.class);
      }
    },
    deletedTimestamp {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractOther("deletedTimestamp", java.lang.Long.class);
      }
    },
    serviceCharge {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractRecord("serviceCharge", com.clover.sdk.v3.base.ServiceCharge.JSON_CREATOR);
      }
    },
    discounts {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("discounts", com.clover.sdk.v3.order.Discount.JSON_CREATOR);
      }
    },
    lineItems {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("lineItems", com.clover.sdk.v3.order.LineItem.JSON_CREATOR);
      }
    },
    payments {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("payments", com.clover.sdk.v3.payments.Payment.JSON_CREATOR);
      }
    },
    refunds {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("refunds", com.clover.sdk.v3.payments.Refund.JSON_CREATOR);
      }
    },
    credits {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("credits", com.clover.sdk.v3.payments.Credit.JSON_CREATOR);
      }
    },
    voids {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("voids", com.clover.sdk.v3.payments.Payment.JSON_CREATOR);
      }
    },
    preAuths {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("preAuths", com.clover.sdk.v3.payments.Payment.JSON_CREATOR);
      }
    },
    device {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractRecord("device", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    authorizations {
      @Override
      public Object extractValue(Order instance) {
        return instance.genClient.extractListRecord("authorizations", com.clover.sdk.v3.payments.Authorization.JSON_CREATOR);
      }
    },
    ;
  }

  private GenericClient<Order> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Order() {
    genClient = new GenericClient<Order>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Order(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Order(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Order(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Order(Order src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getCurrency(), 3);

    genClient.validateLength(getTitle(), 127);

    genClient.validateLength(getNote(), 2047);

    genClient.validateLength(getState(), 31);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'currency' field is set and is not null */
  public boolean isNotNullCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.currency);
  }

  /** Checks whether the 'customers' field is set and is not null */
  public boolean isNotNullCustomers() {
    return genClient.cacheValueIsNotNull(CacheKey.customers);
  }

  /** Checks whether the 'customers' field is set and is not null and is not empty */
  public boolean isNotEmptyCustomers() { return isNotNullCustomers() && !getCustomers().isEmpty(); }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'total' field is set and is not null */
  public boolean isNotNullTotal() {
    return genClient.cacheValueIsNotNull(CacheKey.total);
  }

  /** Checks whether the 'title' field is set and is not null */
  public boolean isNotNullTitle() {
    return genClient.cacheValueIsNotNull(CacheKey.title);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'orderType' field is set and is not null */
  public boolean isNotNullOrderType() {
    return genClient.cacheValueIsNotNull(CacheKey.orderType);
  }

  /** Checks whether the 'taxRemoved' field is set and is not null */
  public boolean isNotNullTaxRemoved() {
    return genClient.cacheValueIsNotNull(CacheKey.taxRemoved);
  }

  /** Checks whether the 'isVat' field is set and is not null */
  public boolean isNotNullIsVat() {
    return genClient.cacheValueIsNotNull(CacheKey.isVat);
  }

  /** Checks whether the 'state' field is set and is not null */
  public boolean isNotNullState() {
    return genClient.cacheValueIsNotNull(CacheKey.state);
  }

  /** Checks whether the 'manualTransaction' field is set and is not null */
  public boolean isNotNullManualTransaction() {
    return genClient.cacheValueIsNotNull(CacheKey.manualTransaction);
  }

  /** Checks whether the 'groupLineItems' field is set and is not null */
  public boolean isNotNullGroupLineItems() {
    return genClient.cacheValueIsNotNull(CacheKey.groupLineItems);
  }

  /** Checks whether the 'testMode' field is set and is not null */
  public boolean isNotNullTestMode() {
    return genClient.cacheValueIsNotNull(CacheKey.testMode);
  }

  /** Checks whether the 'payType' field is set and is not null */
  public boolean isNotNullPayType() {
    return genClient.cacheValueIsNotNull(CacheKey.payType);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTimestamp' field is set and is not null */
  public boolean isNotNullDeletedTimestamp() {
    return genClient.cacheValueIsNotNull(CacheKey.deletedTimestamp);
  }

  /** Checks whether the 'serviceCharge' field is set and is not null */
  public boolean isNotNullServiceCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceCharge);
  }

  /** Checks whether the 'discounts' field is set and is not null */
  public boolean isNotNullDiscounts() {
    return genClient.cacheValueIsNotNull(CacheKey.discounts);
  }

  /** Checks whether the 'discounts' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscounts() { return isNotNullDiscounts() && !getDiscounts().isEmpty(); }

  /** Checks whether the 'lineItems' field is set and is not null */
  public boolean isNotNullLineItems() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItems);
  }

  /** Checks whether the 'lineItems' field is set and is not null and is not empty */
  public boolean isNotEmptyLineItems() { return isNotNullLineItems() && !getLineItems().isEmpty(); }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() { return isNotNullPayments() && !getPayments().isEmpty(); }

  /** Checks whether the 'refunds' field is set and is not null */
  public boolean isNotNullRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.refunds);
  }

  /** Checks whether the 'refunds' field is set and is not null and is not empty */
  public boolean isNotEmptyRefunds() { return isNotNullRefunds() && !getRefunds().isEmpty(); }

  /** Checks whether the 'credits' field is set and is not null */
  public boolean isNotNullCredits() {
    return genClient.cacheValueIsNotNull(CacheKey.credits);
  }

  /** Checks whether the 'credits' field is set and is not null and is not empty */
  public boolean isNotEmptyCredits() { return isNotNullCredits() && !getCredits().isEmpty(); }

  /** Checks whether the 'voids' field is set and is not null */
  public boolean isNotNullVoids() {
    return genClient.cacheValueIsNotNull(CacheKey.voids);
  }

  /** Checks whether the 'voids' field is set and is not null and is not empty */
  public boolean isNotEmptyVoids() { return isNotNullVoids() && !getVoids().isEmpty(); }

  /** Checks whether the 'preAuths' field is set and is not null */
  public boolean isNotNullPreAuths() {
    return genClient.cacheValueIsNotNull(CacheKey.preAuths);
  }

  /** Checks whether the 'preAuths' field is set and is not null and is not empty */
  public boolean isNotEmptyPreAuths() { return isNotNullPreAuths() && !getPreAuths().isEmpty(); }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }

  /** Checks whether the 'authorizations' field is set and is not null */
  public boolean isNotNullAuthorizations() {
    return genClient.cacheValueIsNotNull(CacheKey.authorizations);
  }

  /** Checks whether the 'authorizations' field is set and is not null and is not empty */
  public boolean isNotEmptyAuthorizations() { return isNotNullAuthorizations() && !getAuthorizations().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'currency' field has been set, however the value could be null */
  public boolean hasCurrency() {
    return genClient.cacheHasKey(CacheKey.currency);
  }

  /** Checks whether the 'customers' field has been set, however the value could be null */
  public boolean hasCustomers() {
    return genClient.cacheHasKey(CacheKey.customers);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'total' field has been set, however the value could be null */
  public boolean hasTotal() {
    return genClient.cacheHasKey(CacheKey.total);
  }

  /** Checks whether the 'title' field has been set, however the value could be null */
  public boolean hasTitle() {
    return genClient.cacheHasKey(CacheKey.title);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'orderType' field has been set, however the value could be null */
  public boolean hasOrderType() {
    return genClient.cacheHasKey(CacheKey.orderType);
  }

  /** Checks whether the 'taxRemoved' field has been set, however the value could be null */
  public boolean hasTaxRemoved() {
    return genClient.cacheHasKey(CacheKey.taxRemoved);
  }

  /** Checks whether the 'isVat' field has been set, however the value could be null */
  public boolean hasIsVat() {
    return genClient.cacheHasKey(CacheKey.isVat);
  }

  /** Checks whether the 'state' field has been set, however the value could be null */
  public boolean hasState() {
    return genClient.cacheHasKey(CacheKey.state);
  }

  /** Checks whether the 'manualTransaction' field has been set, however the value could be null */
  public boolean hasManualTransaction() {
    return genClient.cacheHasKey(CacheKey.manualTransaction);
  }

  /** Checks whether the 'groupLineItems' field has been set, however the value could be null */
  public boolean hasGroupLineItems() {
    return genClient.cacheHasKey(CacheKey.groupLineItems);
  }

  /** Checks whether the 'testMode' field has been set, however the value could be null */
  public boolean hasTestMode() {
    return genClient.cacheHasKey(CacheKey.testMode);
  }

  /** Checks whether the 'payType' field has been set, however the value could be null */
  public boolean hasPayType() {
    return genClient.cacheHasKey(CacheKey.payType);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'deletedTimestamp' field has been set, however the value could be null */
  public boolean hasDeletedTimestamp() {
    return genClient.cacheHasKey(CacheKey.deletedTimestamp);
  }

  /** Checks whether the 'serviceCharge' field has been set, however the value could be null */
  public boolean hasServiceCharge() {
    return genClient.cacheHasKey(CacheKey.serviceCharge);
  }

  /** Checks whether the 'discounts' field has been set, however the value could be null */
  public boolean hasDiscounts() {
    return genClient.cacheHasKey(CacheKey.discounts);
  }

  /** Checks whether the 'lineItems' field has been set, however the value could be null */
  public boolean hasLineItems() {
    return genClient.cacheHasKey(CacheKey.lineItems);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return genClient.cacheHasKey(CacheKey.payments);
  }

  /** Checks whether the 'refunds' field has been set, however the value could be null */
  public boolean hasRefunds() {
    return genClient.cacheHasKey(CacheKey.refunds);
  }

  /** Checks whether the 'credits' field has been set, however the value could be null */
  public boolean hasCredits() {
    return genClient.cacheHasKey(CacheKey.credits);
  }

  /** Checks whether the 'voids' field has been set, however the value could be null */
  public boolean hasVoids() {
    return genClient.cacheHasKey(CacheKey.voids);
  }

  /** Checks whether the 'preAuths' field has been set, however the value could be null */
  public boolean hasPreAuths() {
    return genClient.cacheHasKey(CacheKey.preAuths);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }

  /** Checks whether the 'authorizations' field has been set, however the value could be null */
  public boolean hasAuthorizations() {
    return genClient.cacheHasKey(CacheKey.authorizations);
  }


  /**
   * Sets the field 'id'.
   */
  public Order setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'currency'.
   */
  public Order setCurrency(java.lang.String currency) {
    return genClient.setOther(currency, CacheKey.currency);
  }

  /**
   * Sets the field 'customers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setCustomers(java.util.List<com.clover.sdk.v3.customers.Customer> customers) {
    return genClient.setArrayRecord(customers, CacheKey.customers);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setEmployee(com.clover.sdk.v3.base.Reference employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'total'.
   */
  public Order setTotal(java.lang.Long total) {
    return genClient.setOther(total, CacheKey.total);
  }

  /**
   * Sets the field 'title'.
   */
  public Order setTitle(java.lang.String title) {
    return genClient.setOther(title, CacheKey.title);
  }

  /**
   * Sets the field 'note'.
   */
  public Order setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'orderType'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setOrderType(com.clover.sdk.v3.order.OrderType orderType) {
    return genClient.setRecord(orderType, CacheKey.orderType);
  }

  /**
   * Sets the field 'taxRemoved'.
   */
  public Order setTaxRemoved(java.lang.Boolean taxRemoved) {
    return genClient.setOther(taxRemoved, CacheKey.taxRemoved);
  }

  /**
   * Sets the field 'isVat'.
   */
  public Order setIsVat(java.lang.Boolean isVat) {
    return genClient.setOther(isVat, CacheKey.isVat);
  }

  /**
   * Sets the field 'state'.
   */
  public Order setState(java.lang.String state) {
    return genClient.setOther(state, CacheKey.state);
  }

  /**
   * Sets the field 'manualTransaction'.
   */
  public Order setManualTransaction(java.lang.Boolean manualTransaction) {
    return genClient.setOther(manualTransaction, CacheKey.manualTransaction);
  }

  /**
   * Sets the field 'groupLineItems'.
   */
  public Order setGroupLineItems(java.lang.Boolean groupLineItems) {
    return genClient.setOther(groupLineItems, CacheKey.groupLineItems);
  }

  /**
   * Sets the field 'testMode'.
   */
  public Order setTestMode(java.lang.Boolean testMode) {
    return genClient.setOther(testMode, CacheKey.testMode);
  }

  /**
   * Sets the field 'payType'.
   */
  public Order setPayType(com.clover.sdk.v3.order.PayType payType) {
    return genClient.setOther(payType, CacheKey.payType);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Order setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Order setClientCreatedTime(java.lang.Long clientCreatedTime) {
    return genClient.setOther(clientCreatedTime, CacheKey.clientCreatedTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Order setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'deletedTimestamp'.
   */
  public Order setDeletedTimestamp(java.lang.Long deletedTimestamp) {
    return genClient.setOther(deletedTimestamp, CacheKey.deletedTimestamp);
  }

  /**
   * Sets the field 'serviceCharge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setServiceCharge(com.clover.sdk.v3.base.ServiceCharge serviceCharge) {
    return genClient.setRecord(serviceCharge, CacheKey.serviceCharge);
  }

  /**
   * Sets the field 'discounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setDiscounts(java.util.List<com.clover.sdk.v3.order.Discount> discounts) {
    return genClient.setArrayRecord(discounts, CacheKey.discounts);
  }

  /**
   * Sets the field 'lineItems'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setLineItems(java.util.List<com.clover.sdk.v3.order.LineItem> lineItems) {
    return genClient.setArrayRecord(lineItems, CacheKey.lineItems);
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setPayments(java.util.List<com.clover.sdk.v3.payments.Payment> payments) {
    return genClient.setArrayRecord(payments, CacheKey.payments);
  }

  /**
   * Sets the field 'refunds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setRefunds(java.util.List<com.clover.sdk.v3.payments.Refund> refunds) {
    return genClient.setArrayRecord(refunds, CacheKey.refunds);
  }

  /**
   * Sets the field 'credits'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setCredits(java.util.List<com.clover.sdk.v3.payments.Credit> credits) {
    return genClient.setArrayRecord(credits, CacheKey.credits);
  }

  /**
   * Sets the field 'voids'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setVoids(java.util.List<com.clover.sdk.v3.payments.Payment> voids) {
    return genClient.setArrayRecord(voids, CacheKey.voids);
  }

  /**
   * Sets the field 'preAuths'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setPreAuths(java.util.List<com.clover.sdk.v3.payments.Payment> preAuths) {
    return genClient.setArrayRecord(preAuths, CacheKey.preAuths);
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setDevice(com.clover.sdk.v3.base.Reference device) {
    return genClient.setRecord(device, CacheKey.device);
  }

  /**
   * Sets the field 'authorizations'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setAuthorizations(java.util.List<com.clover.sdk.v3.payments.Authorization> authorizations) {
    return genClient.setArrayRecord(authorizations, CacheKey.authorizations);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'currency' field, the 'has' method for this field will now return false */
  public void clearCurrency() {
    genClient.clear(CacheKey.currency);
  }
  /** Clears the 'customers' field, the 'has' method for this field will now return false */
  public void clearCustomers() {
    genClient.clear(CacheKey.customers);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'total' field, the 'has' method for this field will now return false */
  public void clearTotal() {
    genClient.clear(CacheKey.total);
  }
  /** Clears the 'title' field, the 'has' method for this field will now return false */
  public void clearTitle() {
    genClient.clear(CacheKey.title);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'orderType' field, the 'has' method for this field will now return false */
  public void clearOrderType() {
    genClient.clear(CacheKey.orderType);
  }
  /** Clears the 'taxRemoved' field, the 'has' method for this field will now return false */
  public void clearTaxRemoved() {
    genClient.clear(CacheKey.taxRemoved);
  }
  /** Clears the 'isVat' field, the 'has' method for this field will now return false */
  public void clearIsVat() {
    genClient.clear(CacheKey.isVat);
  }
  /** Clears the 'state' field, the 'has' method for this field will now return false */
  public void clearState() {
    genClient.clear(CacheKey.state);
  }
  /** Clears the 'manualTransaction' field, the 'has' method for this field will now return false */
  public void clearManualTransaction() {
    genClient.clear(CacheKey.manualTransaction);
  }
  /** Clears the 'groupLineItems' field, the 'has' method for this field will now return false */
  public void clearGroupLineItems() {
    genClient.clear(CacheKey.groupLineItems);
  }
  /** Clears the 'testMode' field, the 'has' method for this field will now return false */
  public void clearTestMode() {
    genClient.clear(CacheKey.testMode);
  }
  /** Clears the 'payType' field, the 'has' method for this field will now return false */
  public void clearPayType() {
    genClient.clear(CacheKey.payType);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    genClient.clear(CacheKey.clientCreatedTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'deletedTimestamp' field, the 'has' method for this field will now return false */
  public void clearDeletedTimestamp() {
    genClient.clear(CacheKey.deletedTimestamp);
  }
  /** Clears the 'serviceCharge' field, the 'has' method for this field will now return false */
  public void clearServiceCharge() {
    genClient.clear(CacheKey.serviceCharge);
  }
  /** Clears the 'discounts' field, the 'has' method for this field will now return false */
  public void clearDiscounts() {
    genClient.clear(CacheKey.discounts);
  }
  /** Clears the 'lineItems' field, the 'has' method for this field will now return false */
  public void clearLineItems() {
    genClient.clear(CacheKey.lineItems);
  }
  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    genClient.clear(CacheKey.payments);
  }
  /** Clears the 'refunds' field, the 'has' method for this field will now return false */
  public void clearRefunds() {
    genClient.clear(CacheKey.refunds);
  }
  /** Clears the 'credits' field, the 'has' method for this field will now return false */
  public void clearCredits() {
    genClient.clear(CacheKey.credits);
  }
  /** Clears the 'voids' field, the 'has' method for this field will now return false */
  public void clearVoids() {
    genClient.clear(CacheKey.voids);
  }
  /** Clears the 'preAuths' field, the 'has' method for this field will now return false */
  public void clearPreAuths() {
    genClient.clear(CacheKey.preAuths);
  }
  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }
  /** Clears the 'authorizations' field, the 'has' method for this field will now return false */
  public void clearAuthorizations() {
    genClient.clear(CacheKey.authorizations);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Order copyChanges() {
    Order copy = new Order();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Order src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Order(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Order> CREATOR = new android.os.Parcelable.Creator<Order>() {
    @Override
    public Order createFromParcel(android.os.Parcel in) {
      Order instance = new Order(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Order[] newArray(int size) {
      return new Order[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Order> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Order>() {
    @Override
    public Order create(org.json.JSONObject jsonObject) {
      return new Order(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean CURRENCY_IS_REQUIRED = false;
    public static final long CURRENCY_MAX_LEN = 3;
    public static final boolean CUSTOMERS_IS_REQUIRED = false;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean TOTAL_IS_REQUIRED = false;
    public static final boolean TITLE_IS_REQUIRED = false;
    public static final long TITLE_MAX_LEN = 127;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 2047;
    public static final boolean ORDERTYPE_IS_REQUIRED = false;
    public static final boolean TAXREMOVED_IS_REQUIRED = false;
    public static final boolean ISVAT_IS_REQUIRED = false;
    public static final boolean STATE_IS_REQUIRED = false;
    public static final long STATE_MAX_LEN = 31;
    public static final boolean MANUALTRANSACTION_IS_REQUIRED = false;
    public static final boolean GROUPLINEITEMS_IS_REQUIRED = false;
    public static final boolean TESTMODE_IS_REQUIRED = false;
    public static final boolean PAYTYPE_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean DELETEDTIMESTAMP_IS_REQUIRED = false;
    public static final boolean SERVICECHARGE_IS_REQUIRED = false;
    public static final boolean DISCOUNTS_IS_REQUIRED = false;
    public static final boolean LINEITEMS_IS_REQUIRED = false;
    public static final boolean PAYMENTS_IS_REQUIRED = false;
    public static final boolean REFUNDS_IS_REQUIRED = false;
    public static final boolean CREDITS_IS_REQUIRED = false;
    public static final boolean VOIDS_IS_REQUIRED = false;
    public static final boolean PREAUTHS_IS_REQUIRED = false;
    public static final boolean DEVICE_IS_REQUIRED = false;
    public static final boolean AUTHORIZATIONS_IS_REQUIRED = false;

  }

}
