/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getPayment payment}</li>
 * <li>{@link #getTabName tabName}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getCardType cardType}</li>
 * <li>{@link #getLast4 last4}</li>
 * <li>{@link #getAuthcode authcode}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getClosingPayment closingPayment}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Authorization extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Payment that the auth was opened with
   */
  public com.clover.sdk.v3.payments.Payment getPayment() {
    return genClient.cacheGet(CacheKey.payment);
  }

  /**
   * Name of tab
   */
  public java.lang.String getTabName() {
    return genClient.cacheGet(CacheKey.tabName);
  }

  /**
   * Amount authorized
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Type of credit card used for authorization
   */
  public com.clover.sdk.v3.payments.CardType getCardType() {
    return genClient.cacheGet(CacheKey.cardType);
  }

  /**
   * Last 4 digits of credit card used for authorization
   */
  public java.lang.String getLast4() {
    return genClient.cacheGet(CacheKey.last4);
  }

  /**
   * Authorization code
   */
  public java.lang.String getAuthcode() {
    return genClient.cacheGet(CacheKey.authcode);
  }

  public com.clover.sdk.v3.payments.Type getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  /**
   * Payment that the auth was closed with
   */
  public com.clover.sdk.v3.payments.Payment getClosingPayment() {
    return genClient.cacheGet(CacheKey.closingPayment);
  }

  /**
   * Time authorization was recorded on server
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<Authorization> {
    id {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    payment {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractRecord("payment", com.clover.sdk.v3.payments.Payment.JSON_CREATOR);
      }
    },
    tabName {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("tabName", java.lang.String.class);
      }
    },
    amount {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("amount", java.lang.Long.class);
      }
    },
    cardType {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractEnum("cardType", com.clover.sdk.v3.payments.CardType.class);
      }
    },
    last4 {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("last4", java.lang.String.class);
      }
    },
    authcode {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("authcode", java.lang.String.class);
      }
    },
    type {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractEnum("type", com.clover.sdk.v3.payments.Type.class);
      }
    },
    note {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("note", java.lang.String.class);
      }
    },
    closingPayment {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractRecord("closingPayment", com.clover.sdk.v3.payments.Payment.JSON_CREATOR);
      }
    },
    createdTime {
      @Override
      public Object extractValue(Authorization instance) {
        return instance.genClient.extractOther("createdTime", java.lang.Long.class);
      }
    },
      ;
  }

  private GenericClient<Authorization> genClient;

  /**
  * Constructs a new empty instance.
  */
  public Authorization() {
    genClient = new GenericClient<Authorization>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected Authorization(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Authorization(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Authorization(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Authorization(Authorization src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getTabName(), 127);

    genClient.validateLength(getLast4(), 4);

    genClient.validateLength(getAuthcode(), 255);

    genClient.validateLength(getNote(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'payment' field is set and is not null */
  public boolean isNotNullPayment() {
    return genClient.cacheValueIsNotNull(CacheKey.payment);
  }

  /** Checks whether the 'tabName' field is set and is not null */
  public boolean isNotNullTabName() {
    return genClient.cacheValueIsNotNull(CacheKey.tabName);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'cardType' field is set and is not null */
  public boolean isNotNullCardType() {
    return genClient.cacheValueIsNotNull(CacheKey.cardType);
  }

  /** Checks whether the 'last4' field is set and is not null */
  public boolean isNotNullLast4() {
    return genClient.cacheValueIsNotNull(CacheKey.last4);
  }

  /** Checks whether the 'authcode' field is set and is not null */
  public boolean isNotNullAuthcode() {
    return genClient.cacheValueIsNotNull(CacheKey.authcode);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'closingPayment' field is set and is not null */
  public boolean isNotNullClosingPayment() {
    return genClient.cacheValueIsNotNull(CacheKey.closingPayment);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'payment' field has been set, however the value could be null */
  public boolean hasPayment() {
    return genClient.cacheHasKey(CacheKey.payment);
  }

  /** Checks whether the 'tabName' field has been set, however the value could be null */
  public boolean hasTabName() {
    return genClient.cacheHasKey(CacheKey.tabName);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'cardType' field has been set, however the value could be null */
  public boolean hasCardType() {
    return genClient.cacheHasKey(CacheKey.cardType);
  }

  /** Checks whether the 'last4' field has been set, however the value could be null */
  public boolean hasLast4() {
    return genClient.cacheHasKey(CacheKey.last4);
  }

  /** Checks whether the 'authcode' field has been set, however the value could be null */
  public boolean hasAuthcode() {
    return genClient.cacheHasKey(CacheKey.authcode);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'closingPayment' field has been set, however the value could be null */
  public boolean hasClosingPayment() {
    return genClient.cacheHasKey(CacheKey.closingPayment);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }


  /**
   * Sets the field 'id'.
   */
  public Authorization setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'payment'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Authorization setPayment(com.clover.sdk.v3.payments.Payment payment) {
    return genClient.setRecord(payment, CacheKey.payment);
  }

  /**
   * Sets the field 'tabName'.
   */
  public Authorization setTabName(java.lang.String tabName) {
    return genClient.setOther(tabName, CacheKey.tabName);
  }

  /**
   * Sets the field 'amount'.
   */
  public Authorization setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'cardType'.
   */
  public Authorization setCardType(com.clover.sdk.v3.payments.CardType cardType) {
    return genClient.setOther(cardType, CacheKey.cardType);
  }

  /**
   * Sets the field 'last4'.
   */
  public Authorization setLast4(java.lang.String last4) {
    return genClient.setOther(last4, CacheKey.last4);
  }

  /**
   * Sets the field 'authcode'.
   */
  public Authorization setAuthcode(java.lang.String authcode) {
    return genClient.setOther(authcode, CacheKey.authcode);
  }

  /**
   * Sets the field 'type'.
   */
  public Authorization setType(com.clover.sdk.v3.payments.Type type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'note'.
   */
  public Authorization setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'closingPayment'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Authorization setClosingPayment(com.clover.sdk.v3.payments.Payment closingPayment) {
    return genClient.setRecord(closingPayment, CacheKey.closingPayment);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Authorization setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'payment' field, the 'has' method for this field will now return false */
  public void clearPayment() {
    genClient.clear(CacheKey.payment);
  }
  /** Clears the 'tabName' field, the 'has' method for this field will now return false */
  public void clearTabName() {
    genClient.clear(CacheKey.tabName);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'cardType' field, the 'has' method for this field will now return false */
  public void clearCardType() {
    genClient.clear(CacheKey.cardType);
  }
  /** Clears the 'last4' field, the 'has' method for this field will now return false */
  public void clearLast4() {
    genClient.clear(CacheKey.last4);
  }
  /** Clears the 'authcode' field, the 'has' method for this field will now return false */
  public void clearAuthcode() {
    genClient.clear(CacheKey.authcode);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'closingPayment' field, the 'has' method for this field will now return false */
  public void clearClosingPayment() {
    genClient.clear(CacheKey.closingPayment);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Authorization copyChanges() {
    Authorization copy = new Authorization();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Authorization src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Authorization(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Authorization> CREATOR = new android.os.Parcelable.Creator<Authorization>() {
    @Override
    public Authorization createFromParcel(android.os.Parcel in) {
      Authorization instance = new Authorization(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Authorization[] newArray(int size) {
      return new Authorization[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Authorization> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Authorization>() {
    @Override
    public Authorization create(org.json.JSONObject jsonObject) {
      return new Authorization(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean PAYMENT_IS_REQUIRED = false;
    public static final boolean TABNAME_IS_REQUIRED = false;
    public static final long TABNAME_MAX_LEN = 127;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean CARDTYPE_IS_REQUIRED = false;
    public static final boolean LAST4_IS_REQUIRED = false;
    public static final long LAST4_MAX_LEN = 4;
    public static final boolean AUTHCODE_IS_REQUIRED = false;
    public static final long AUTHCODE_MAX_LEN = 255;
    public static final boolean TYPE_IS_REQUIRED = false;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean CLOSINGPAYMENT_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;

  }

}
