/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Data for a payment that is processed using a QR code or barcode.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPaymentNetwork paymentNetwork}</li>
 * <li>{@link #getPaymentType paymentType}</li>
 * <li>{@link #getPaymentData paymentData}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CardlessPaymentData extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Payment network
   */
  public com.clover.sdk.v3.payments.CardlessPaymentNetwork getPaymentNetwork() {
    return genClient.cacheGet(CacheKey.paymentNetwork);
  }

  /**
   * Payment method
   */
  public com.clover.sdk.v3.payments.CardlessPaymentDataType getPaymentType() {
    return genClient.cacheGet(CacheKey.paymentType);
  }

  /**
   * QR code or barcode data
   */
  public java.lang.String getPaymentData() {
    return genClient.cacheGet(CacheKey.paymentData);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<CardlessPaymentData> {
    paymentNetwork {
      @Override
      public Object extractValue(CardlessPaymentData instance) {
        return instance.genClient.extractEnum("paymentNetwork", com.clover.sdk.v3.payments.CardlessPaymentNetwork.class);
      }
    },
    paymentType {
      @Override
      public Object extractValue(CardlessPaymentData instance) {
        return instance.genClient.extractEnum("paymentType", com.clover.sdk.v3.payments.CardlessPaymentDataType.class);
      }
    },
    paymentData {
      @Override
      public Object extractValue(CardlessPaymentData instance) {
        return instance.genClient.extractOther("paymentData", java.lang.String.class);
      }
    },
      ;
  }

  private GenericClient<CardlessPaymentData> genClient;

  /**
  * Constructs a new empty instance.
  */
  public CardlessPaymentData() {
    genClient = new GenericClient<CardlessPaymentData>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected CardlessPaymentData(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CardlessPaymentData(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CardlessPaymentData(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CardlessPaymentData(CardlessPaymentData src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'paymentNetwork' field is set and is not null */
  public boolean isNotNullPaymentNetwork() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentNetwork);
  }

  /** Checks whether the 'paymentType' field is set and is not null */
  public boolean isNotNullPaymentType() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentType);
  }

  /** Checks whether the 'paymentData' field is set and is not null */
  public boolean isNotNullPaymentData() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentData);
  }



  /** Checks whether the 'paymentNetwork' field has been set, however the value could be null */
  public boolean hasPaymentNetwork() {
    return genClient.cacheHasKey(CacheKey.paymentNetwork);
  }

  /** Checks whether the 'paymentType' field has been set, however the value could be null */
  public boolean hasPaymentType() {
    return genClient.cacheHasKey(CacheKey.paymentType);
  }

  /** Checks whether the 'paymentData' field has been set, however the value could be null */
  public boolean hasPaymentData() {
    return genClient.cacheHasKey(CacheKey.paymentData);
  }


  /**
   * Sets the field 'paymentNetwork'.
   */
  public CardlessPaymentData setPaymentNetwork(com.clover.sdk.v3.payments.CardlessPaymentNetwork paymentNetwork) {
    return genClient.setOther(paymentNetwork, CacheKey.paymentNetwork);
  }

  /**
   * Sets the field 'paymentType'.
   */
  public CardlessPaymentData setPaymentType(com.clover.sdk.v3.payments.CardlessPaymentDataType paymentType) {
    return genClient.setOther(paymentType, CacheKey.paymentType);
  }

  /**
   * Sets the field 'paymentData'.
   */
  public CardlessPaymentData setPaymentData(java.lang.String paymentData) {
    return genClient.setOther(paymentData, CacheKey.paymentData);
  }


  /** Clears the 'paymentNetwork' field, the 'has' method for this field will now return false */
  public void clearPaymentNetwork() {
    genClient.clear(CacheKey.paymentNetwork);
  }
  /** Clears the 'paymentType' field, the 'has' method for this field will now return false */
  public void clearPaymentType() {
    genClient.clear(CacheKey.paymentType);
  }
  /** Clears the 'paymentData' field, the 'has' method for this field will now return false */
  public void clearPaymentData() {
    genClient.clear(CacheKey.paymentData);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CardlessPaymentData copyChanges() {
    CardlessPaymentData copy = new CardlessPaymentData();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CardlessPaymentData src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CardlessPaymentData(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CardlessPaymentData> CREATOR = new android.os.Parcelable.Creator<CardlessPaymentData>() {
    @Override
    public CardlessPaymentData createFromParcel(android.os.Parcel in) {
      CardlessPaymentData instance = new CardlessPaymentData(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CardlessPaymentData[] newArray(int size) {
      return new CardlessPaymentData[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CardlessPaymentData> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CardlessPaymentData>() {
    @Override
    public CardlessPaymentData create(org.json.JSONObject jsonObject) {
      return new CardlessPaymentData(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean PAYMENTNETWORK_IS_REQUIRED = false;
    public static final boolean PAYMENTTYPE_IS_REQUIRED = false;
    public static final boolean PAYMENTDATA_IS_REQUIRED = false;

  }

}
