/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getOrderRef orderRef}</li>
 * <li>{@link #getDevice device}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getClientCreatedTime clientCreatedTime}</li>
 * <li>{@link #getCredit credit}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getGermanInfo germanInfo}</li>
 * <li>{@link #getAppTracking appTracking}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CreditRefund extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The order with which the refund is associated
   */
  public com.clover.sdk.v3.base.Reference getOrderRef() {
    return genClient.cacheGet(CacheKey.orderRef);
  }

  /**
   * Device which processed the transaction for this refund
   */
  public com.clover.sdk.v3.base.Reference getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }

  /**
   * The time when the refund was recorded on the server
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * The time when the refund was recorded on the client
   */
  public java.lang.Long getClientCreatedTime() {
    return genClient.cacheGet(CacheKey.clientCreatedTime);
  }

  /**
   * The credit with which the credit refund is associated
   */
  public com.clover.sdk.v3.base.Reference getCredit() {
    return genClient.cacheGet(CacheKey.credit);
  }

  public com.clover.sdk.v3.base.Reference getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * German region-specific information
   */
  public com.clover.sdk.v3.payments.GermanInfo getGermanInfo() {
    return genClient.cacheGet(CacheKey.germanInfo);
  }

  /**
   * Tracking information for the app that created this payment.
   */
  public com.clover.sdk.v3.apps.AppTracking getAppTracking() {
    return genClient.cacheGet(CacheKey.appTracking);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<CreditRefund> {
    id {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    orderRef {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractRecord("orderRef", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    device {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractRecord("device", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    createdTime {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractOther("createdTime", java.lang.Long.class);
      }
    },
    clientCreatedTime {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractOther("clientCreatedTime", java.lang.Long.class);
      }
    },
    credit {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractRecord("credit", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    employee {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractRecord("employee", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    germanInfo {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractRecord("germanInfo", com.clover.sdk.v3.payments.GermanInfo.JSON_CREATOR);
      }
    },
    appTracking {
      @Override
      public Object extractValue(CreditRefund instance) {
        return instance.genClient.extractRecord("appTracking", com.clover.sdk.v3.apps.AppTracking.JSON_CREATOR);
      }
    },
      ;
  }

  private GenericClient<CreditRefund> genClient;

  /**
  * Constructs a new empty instance.
  */
  public CreditRefund() {
    genClient = new GenericClient<CreditRefund>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected CreditRefund(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CreditRefund(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CreditRefund(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CreditRefund(CreditRefund src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'orderRef' field is set and is not null */
  public boolean isNotNullOrderRef() {
    return genClient.cacheValueIsNotNull(CacheKey.orderRef);
  }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'credit' field is set and is not null */
  public boolean isNotNullCredit() {
    return genClient.cacheValueIsNotNull(CacheKey.credit);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'germanInfo' field is set and is not null */
  public boolean isNotNullGermanInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field is set and is not null */
  public boolean isNotNullAppTracking() {
    return genClient.cacheValueIsNotNull(CacheKey.appTracking);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'orderRef' field has been set, however the value could be null */
  public boolean hasOrderRef() {
    return genClient.cacheHasKey(CacheKey.orderRef);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'credit' field has been set, however the value could be null */
  public boolean hasCredit() {
    return genClient.cacheHasKey(CacheKey.credit);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'germanInfo' field has been set, however the value could be null */
  public boolean hasGermanInfo() {
    return genClient.cacheHasKey(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field has been set, however the value could be null */
  public boolean hasAppTracking() {
    return genClient.cacheHasKey(CacheKey.appTracking);
  }


  /**
   * Sets the field 'id'.
   */
  public CreditRefund setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'orderRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreditRefund setOrderRef(com.clover.sdk.v3.base.Reference orderRef) {
    return genClient.setRecord(orderRef, CacheKey.orderRef);
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreditRefund setDevice(com.clover.sdk.v3.base.Reference device) {
    return genClient.setRecord(device, CacheKey.device);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public CreditRefund setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public CreditRefund setClientCreatedTime(java.lang.Long clientCreatedTime) {
    return genClient.setOther(clientCreatedTime, CacheKey.clientCreatedTime);
  }

  /**
   * Sets the field 'credit'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreditRefund setCredit(com.clover.sdk.v3.base.Reference credit) {
    return genClient.setRecord(credit, CacheKey.credit);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreditRefund setEmployee(com.clover.sdk.v3.base.Reference employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'germanInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreditRefund setGermanInfo(com.clover.sdk.v3.payments.GermanInfo germanInfo) {
    return genClient.setRecord(germanInfo, CacheKey.germanInfo);
  }

  /**
   * Sets the field 'appTracking'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public CreditRefund setAppTracking(com.clover.sdk.v3.apps.AppTracking appTracking) {
    return genClient.setRecord(appTracking, CacheKey.appTracking);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'orderRef' field, the 'has' method for this field will now return false */
  public void clearOrderRef() {
    genClient.clear(CacheKey.orderRef);
  }
  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    genClient.clear(CacheKey.clientCreatedTime);
  }
  /** Clears the 'credit' field, the 'has' method for this field will now return false */
  public void clearCredit() {
    genClient.clear(CacheKey.credit);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'germanInfo' field, the 'has' method for this field will now return false */
  public void clearGermanInfo() {
    genClient.clear(CacheKey.germanInfo);
  }
  /** Clears the 'appTracking' field, the 'has' method for this field will now return false */
  public void clearAppTracking() {
    genClient.clear(CacheKey.appTracking);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CreditRefund copyChanges() {
    CreditRefund copy = new CreditRefund();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CreditRefund src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CreditRefund(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CreditRefund> CREATOR = new android.os.Parcelable.Creator<CreditRefund>() {
    @Override
    public CreditRefund createFromParcel(android.os.Parcel in) {
      CreditRefund instance = new CreditRefund(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CreditRefund[] newArray(int size) {
      return new CreditRefund[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CreditRefund> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CreditRefund>() {
    @Override
    public CreditRefund create(org.json.JSONObject jsonObject) {
      return new CreditRefund(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final boolean ORDERREF_IS_REQUIRED = false;
    public static final boolean DEVICE_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean CREDIT_IS_REQUIRED = false;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean GERMANINFO_IS_REQUIRED = false;
    public static final boolean APPTRACKING_IS_REQUIRED = false;

  }

}
