/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getPercentage percentage}</li>
 * <li>{@link #getBinName binName}</li>
 * <li>{@link #getRefunded refunded}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class LineItemPayment extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier; TBD this is confusing because it's used as either line item id or payment id
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Percent of this line item covered by this payment
   */
  public java.lang.Long getPercentage() {
    return genClient.cacheGet(CacheKey.percentage);
  }

  /**
   * Bin this line item payment was for
   */
  public java.lang.String getBinName() {
    return genClient.cacheGet(CacheKey.binName);
  }

  /**
   * Payment has been refunded
   */
  public java.lang.Boolean getRefunded() {
    return genClient.cacheGet(CacheKey.refunded);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<LineItemPayment> {
    id {
      @Override
      public Object extractValue(LineItemPayment instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    percentage {
      @Override
      public Object extractValue(LineItemPayment instance) {
        return instance.genClient.extractOther("percentage", java.lang.Long.class);
      }
    },
    binName {
      @Override
      public Object extractValue(LineItemPayment instance) {
        return instance.genClient.extractOther("binName", java.lang.String.class);
      }
    },
    refunded {
      @Override
      public Object extractValue(LineItemPayment instance) {
        return instance.genClient.extractOther("refunded", java.lang.Boolean.class);
      }
    },
      ;
  }

  private GenericClient<LineItemPayment> genClient;

  /**
  * Constructs a new empty instance.
  */
  public LineItemPayment() {
    genClient = new GenericClient<LineItemPayment>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected LineItemPayment(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LineItemPayment(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LineItemPayment(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LineItemPayment(LineItemPayment src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getBinName(), 127);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'percentage' field is set and is not null */
  public boolean isNotNullPercentage() {
    return genClient.cacheValueIsNotNull(CacheKey.percentage);
  }

  /** Checks whether the 'binName' field is set and is not null */
  public boolean isNotNullBinName() {
    return genClient.cacheValueIsNotNull(CacheKey.binName);
  }

  /** Checks whether the 'refunded' field is set and is not null */
  public boolean isNotNullRefunded() {
    return genClient.cacheValueIsNotNull(CacheKey.refunded);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'percentage' field has been set, however the value could be null */
  public boolean hasPercentage() {
    return genClient.cacheHasKey(CacheKey.percentage);
  }

  /** Checks whether the 'binName' field has been set, however the value could be null */
  public boolean hasBinName() {
    return genClient.cacheHasKey(CacheKey.binName);
  }

  /** Checks whether the 'refunded' field has been set, however the value could be null */
  public boolean hasRefunded() {
    return genClient.cacheHasKey(CacheKey.refunded);
  }


  /**
   * Sets the field 'id'.
   */
  public LineItemPayment setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'percentage'.
   */
  public LineItemPayment setPercentage(java.lang.Long percentage) {
    return genClient.setOther(percentage, CacheKey.percentage);
  }

  /**
   * Sets the field 'binName'.
   */
  public LineItemPayment setBinName(java.lang.String binName) {
    return genClient.setOther(binName, CacheKey.binName);
  }

  /**
   * Sets the field 'refunded'.
   */
  public LineItemPayment setRefunded(java.lang.Boolean refunded) {
    return genClient.setOther(refunded, CacheKey.refunded);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'percentage' field, the 'has' method for this field will now return false */
  public void clearPercentage() {
    genClient.clear(CacheKey.percentage);
  }
  /** Clears the 'binName' field, the 'has' method for this field will now return false */
  public void clearBinName() {
    genClient.clear(CacheKey.binName);
  }
  /** Clears the 'refunded' field, the 'has' method for this field will now return false */
  public void clearRefunded() {
    genClient.clear(CacheKey.refunded);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LineItemPayment copyChanges() {
    LineItemPayment copy = new LineItemPayment();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LineItemPayment src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new LineItemPayment(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<LineItemPayment> CREATOR = new android.os.Parcelable.Creator<LineItemPayment>() {
    @Override
    public LineItemPayment createFromParcel(android.os.Parcel in) {
      LineItemPayment instance = new LineItemPayment(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public LineItemPayment[] newArray(int size) {
      return new LineItemPayment[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LineItemPayment> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LineItemPayment>() {
    @Override
    public LineItemPayment create(org.json.JSONObject jsonObject) {
      return new LineItemPayment(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean PERCENTAGE_IS_REQUIRED = false;
    public static final boolean BINNAME_IS_REQUIRED = false;
    public static final long BINNAME_MAX_LEN = 127;
    public static final boolean REFUNDED_IS_REQUIRED = false;

  }

}
