/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getOrder order}</li>
 * <li>{@link #getDevice device}</li>
 * <li>{@link #getTender tender}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getTipAmount tipAmount}</li>
 * <li>{@link #getTaxAmount taxAmount}</li>
 * <li>{@link #getCashbackAmount cashbackAmount}</li>
 * <li>{@link #getCashTendered cashTendered}</li>
 * <li>{@link #getExternalPaymentId externalPaymentId}</li>
 * <li>{@link #getEmployee employee}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getClientCreatedTime clientCreatedTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getOffline offline}</li>
 * <li>{@link #getResult result}</li>
 * <li>{@link #getCardTransaction cardTransaction}</li>
 * <li>{@link #getServiceCharge serviceCharge}</li>
 * <li>{@link #getTaxRates taxRates}</li>
 * <li>{@link #getRefunds refunds}</li>
 * <li>{@link #getNote note}</li>
 * <li>{@link #getLineItemPayments lineItemPayments}</li>
 * <li>{@link #getVoidReason voidReason}</li>
 * <li>{@link #getDccInfo dccInfo}</li>
 * <li>{@link #getTransactionSettings transactionSettings}</li>
 * <li>{@link #getGermanInfo germanInfo}</li>
 * <li>{@link #getAppTracking appTracking}</li>
 * <li>{@link #getCashAdvanceExtra cashAdvanceExtra}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Payment extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The order with which the payment is associated
   */
  public com.clover.sdk.v3.base.Reference getOrder() {
    return genClient.cacheGet(CacheKey.order);
  }

  /**
   * Device which processed the transaction for this payment
   */
  public com.clover.sdk.v3.base.Reference getDevice() {
    return genClient.cacheGet(CacheKey.device);
  }

  /**
   * The tender type associated with this payment, e.g. credit card, cash, etc.
   */
  public com.clover.sdk.v3.base.Tender getTender() {
    return genClient.cacheGet(CacheKey.tender);
  }

  /**
   * Total amount paid
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Amount paid in tips
   */
  public java.lang.Long getTipAmount() {
    return genClient.cacheGet(CacheKey.tipAmount);
  }

  /**
   * Amount paid in tax
   */
  public java.lang.Long getTaxAmount() {
    return genClient.cacheGet(CacheKey.taxAmount);
  }

  /**
   * Amount given back in a cash back transaction
   */
  public java.lang.Long getCashbackAmount() {
    return genClient.cacheGet(CacheKey.cashbackAmount);
  }

  /**
   * Amount of cash given by the customer
   */
  public java.lang.Long getCashTendered() {
    return genClient.cacheGet(CacheKey.cashTendered);
  }

  public java.lang.String getExternalPaymentId() {
    return genClient.cacheGet(CacheKey.externalPaymentId);
  }

  /**
   * The employee who processed the payment
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return genClient.cacheGet(CacheKey.employee);
  }

  /**
   * Time payment was recorded on server
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getClientCreatedTime() {
    return genClient.cacheGet(CacheKey.clientCreatedTime);
  }

  /**
   * Last modified time of the payment
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  public java.lang.Boolean getOffline() {
    return genClient.cacheGet(CacheKey.offline);
  }

  public com.clover.sdk.v3.payments.Result getResult() {
    return genClient.cacheGet(CacheKey.result);
  }

  /**
   * Information about the card used for credit/debit card payments
   */
  public com.clover.sdk.v3.payments.CardTransaction getCardTransaction() {
    return genClient.cacheGet(CacheKey.cardTransaction);
  }

  /**
   * Amount record as a service charge
   */
  public com.clover.sdk.v3.payments.ServiceChargeAmount getServiceCharge() {
    return genClient.cacheGet(CacheKey.serviceCharge);
  }

  public java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> getTaxRates() {
    return genClient.cacheGet(CacheKey.taxRates);
  }

  public java.util.List<com.clover.sdk.v3.payments.Refund> getRefunds() {
    return genClient.cacheGet(CacheKey.refunds);
  }

  public java.lang.String getNote() {
    return genClient.cacheGet(CacheKey.note);
  }

  public java.util.List<com.clover.sdk.v3.payments.LineItemPayment> getLineItemPayments() {
    return genClient.cacheGet(CacheKey.lineItemPayments);
  }

  /**
   * If voided, the reason why (when available)
   */
  public com.clover.sdk.v3.order.VoidReason getVoidReason() {
    return genClient.cacheGet(CacheKey.voidReason);
  }

  /**
   * Dynamic Currency Conversion information
   */
  public com.clover.sdk.v3.payments.DCCInfo getDccInfo() {
    return genClient.cacheGet(CacheKey.dccInfo);
  }

  /**
   * Per transaction settings for the payment
   */
  public com.clover.sdk.v3.payments.TransactionSettings getTransactionSettings() {
    return genClient.cacheGet(CacheKey.transactionSettings);
  }

  /**
   * German region-specific information
   */
  public com.clover.sdk.v3.payments.GermanInfo getGermanInfo() {
    return genClient.cacheGet(CacheKey.germanInfo);
  }

  /**
   * Tracking information for the app that created this payment.
   */
  public com.clover.sdk.v3.apps.AppTracking getAppTracking() {
    return genClient.cacheGet(CacheKey.appTracking);
  }

  /**
   * Information specific to cash advance transactions.
   */
  public CashAdvanceExtra getCashAdvanceExtra() {
    return genClient.cacheGet(CacheKey.cashAdvanceExtra);
  }



  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<Payment> {
    id {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("id", java.lang.String.class);
      }
    },
    order {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("order", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    device {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("device", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    tender {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("tender", com.clover.sdk.v3.base.Tender.JSON_CREATOR);
      }
    },
    amount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("amount", java.lang.Long.class);
      }
    },
    tipAmount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("tipAmount", java.lang.Long.class);
      }
    },
    taxAmount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("taxAmount", java.lang.Long.class);
      }
    },
    cashbackAmount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("cashbackAmount", java.lang.Long.class);
      }
    },
    cashTendered {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("cashTendered", java.lang.Long.class);
      }
    },
    externalPaymentId {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("externalPaymentId", java.lang.String.class);
      }
    },
    employee {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("employee", com.clover.sdk.v3.base.Reference.JSON_CREATOR);
      }
    },
    createdTime {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("createdTime", java.lang.Long.class);
      }
    },
    clientCreatedTime {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("clientCreatedTime", java.lang.Long.class);
      }
    },
    modifiedTime {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("modifiedTime", java.lang.Long.class);
      }
    },
    offline {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("offline", java.lang.Boolean.class);
      }
    },
    result {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractEnum("result", com.clover.sdk.v3.payments.Result.class);
      }
    },
    cardTransaction {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("cardTransaction", com.clover.sdk.v3.payments.CardTransaction.JSON_CREATOR);
      }
    },
    serviceCharge {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("serviceCharge", com.clover.sdk.v3.payments.ServiceChargeAmount.JSON_CREATOR);
      }
    },
    taxRates {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractListRecord("taxRates", com.clover.sdk.v3.payments.PaymentTaxRate.JSON_CREATOR);
      }
    },
    refunds {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractListRecord("refunds", com.clover.sdk.v3.payments.Refund.JSON_CREATOR);
      }
    },
    note {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractOther("note", java.lang.String.class);
      }
    },
    lineItemPayments {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractListRecord("lineItemPayments", com.clover.sdk.v3.payments.LineItemPayment.JSON_CREATOR);
      }
    },
    voidReason {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractEnum("voidReason", com.clover.sdk.v3.order.VoidReason.class);
      }
    },
    dccInfo {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("dccInfo", com.clover.sdk.v3.payments.DCCInfo.JSON_CREATOR);
      }
    },
    transactionSettings {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("transactionSettings", com.clover.sdk.v3.payments.TransactionSettings.JSON_CREATOR);
      }
    },
    germanInfo {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("germanInfo", com.clover.sdk.v3.payments.GermanInfo.JSON_CREATOR);
      }
    },
    appTracking {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("appTracking", com.clover.sdk.v3.apps.AppTracking.JSON_CREATOR);
      }
    },
    cashAdvanceExtra {
      @Override
      public Object extractValue(Payment instance) {
        return instance.genClient.extractRecord("cashAdvanceExtra", CashAdvanceExtra.JSON_CREATOR);
      }
    },
    ;
  }

  private GenericClient<Payment> genClient;

  /**
  * Constructs a new empty instance.
  */
  public Payment() {
    genClient = new GenericClient<Payment>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected Payment(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Payment(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Payment(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Payment(Payment src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(getId(), 13);

    genClient.validateLength(getExternalPaymentId(), 32);

    genClient.validateLength(getNote(), 255);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'order' field is set and is not null */
  public boolean isNotNullOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.order);
  }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return genClient.cacheValueIsNotNull(CacheKey.device);
  }

  /** Checks whether the 'tender' field is set and is not null */
  public boolean isNotNullTender() {
    return genClient.cacheValueIsNotNull(CacheKey.tender);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field is set and is not null */
  public boolean isNotNullTipAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'cashbackAmount' field is set and is not null */
  public boolean isNotNullCashbackAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.cashbackAmount);
  }

  /** Checks whether the 'cashTendered' field is set and is not null */
  public boolean isNotNullCashTendered() {
    return genClient.cacheValueIsNotNull(CacheKey.cashTendered);
  }

  /** Checks whether the 'externalPaymentId' field is set and is not null */
  public boolean isNotNullExternalPaymentId() {
    return genClient.cacheValueIsNotNull(CacheKey.externalPaymentId);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return genClient.cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'offline' field is set and is not null */
  public boolean isNotNullOffline() {
    return genClient.cacheValueIsNotNull(CacheKey.offline);
  }

  /** Checks whether the 'result' field is set and is not null */
  public boolean isNotNullResult() {
    return genClient.cacheValueIsNotNull(CacheKey.result);
  }

  /** Checks whether the 'cardTransaction' field is set and is not null */
  public boolean isNotNullCardTransaction() {
    return genClient.cacheValueIsNotNull(CacheKey.cardTransaction);
  }

  /** Checks whether the 'serviceCharge' field is set and is not null */
  public boolean isNotNullServiceCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceCharge);
  }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return genClient.cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() { return isNotNullTaxRates() && !getTaxRates().isEmpty(); }

  /** Checks whether the 'refunds' field is set and is not null */
  public boolean isNotNullRefunds() {
    return genClient.cacheValueIsNotNull(CacheKey.refunds);
  }

  /** Checks whether the 'refunds' field is set and is not null and is not empty */
  public boolean isNotEmptyRefunds() { return isNotNullRefunds() && !getRefunds().isEmpty(); }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return genClient.cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'lineItemPayments' field is set and is not null */
  public boolean isNotNullLineItemPayments() {
    return genClient.cacheValueIsNotNull(CacheKey.lineItemPayments);
  }

  /** Checks whether the 'lineItemPayments' field is set and is not null and is not empty */
  public boolean isNotEmptyLineItemPayments() { return isNotNullLineItemPayments() && !getLineItemPayments().isEmpty(); }

  /** Checks whether the 'voidReason' field is set and is not null */
  public boolean isNotNullVoidReason() {
    return genClient.cacheValueIsNotNull(CacheKey.voidReason);
  }

  /** Checks whether the 'dccInfo' field is set and is not null */
  public boolean isNotNullDccInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.dccInfo);
  }

  /** Checks whether the 'transactionSettings' field is set and is not null */
  public boolean isNotNullTransactionSettings() {
    return genClient.cacheValueIsNotNull(CacheKey.transactionSettings);
  }

  /** Checks whether the 'germanInfo' field is set and is not null */
  public boolean isNotNullGermanInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field is set and is not null */
  public boolean isNotNullAppTracking() {
    return genClient.cacheValueIsNotNull(CacheKey.appTracking);
  }

  /** Checks whether the 'cashAdvanceExtra' field is set and is not null */
  public boolean isNotNullCashAdvanceExtra() {
    return genClient.cacheValueIsNotNull(CacheKey.cashAdvanceExtra);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'order' field has been set, however the value could be null */
  public boolean hasOrder() {
    return genClient.cacheHasKey(CacheKey.order);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return genClient.cacheHasKey(CacheKey.device);
  }

  /** Checks whether the 'tender' field has been set, however the value could be null */
  public boolean hasTender() {
    return genClient.cacheHasKey(CacheKey.tender);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field has been set, however the value could be null */
  public boolean hasTipAmount() {
    return genClient.cacheHasKey(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return genClient.cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'cashbackAmount' field has been set, however the value could be null */
  public boolean hasCashbackAmount() {
    return genClient.cacheHasKey(CacheKey.cashbackAmount);
  }

  /** Checks whether the 'cashTendered' field has been set, however the value could be null */
  public boolean hasCashTendered() {
    return genClient.cacheHasKey(CacheKey.cashTendered);
  }

  /** Checks whether the 'externalPaymentId' field has been set, however the value could be null */
  public boolean hasExternalPaymentId() {
    return genClient.cacheHasKey(CacheKey.externalPaymentId);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return genClient.cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return genClient.cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'offline' field has been set, however the value could be null */
  public boolean hasOffline() {
    return genClient.cacheHasKey(CacheKey.offline);
  }

  /** Checks whether the 'result' field has been set, however the value could be null */
  public boolean hasResult() {
    return genClient.cacheHasKey(CacheKey.result);
  }

  /** Checks whether the 'cardTransaction' field has been set, however the value could be null */
  public boolean hasCardTransaction() {
    return genClient.cacheHasKey(CacheKey.cardTransaction);
  }

  /** Checks whether the 'serviceCharge' field has been set, however the value could be null */
  public boolean hasServiceCharge() {
    return genClient.cacheHasKey(CacheKey.serviceCharge);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return genClient.cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'refunds' field has been set, however the value could be null */
  public boolean hasRefunds() {
    return genClient.cacheHasKey(CacheKey.refunds);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return genClient.cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'lineItemPayments' field has been set, however the value could be null */
  public boolean hasLineItemPayments() {
    return genClient.cacheHasKey(CacheKey.lineItemPayments);
  }

  /** Checks whether the 'voidReason' field has been set, however the value could be null */
  public boolean hasVoidReason() {
    return genClient.cacheHasKey(CacheKey.voidReason);
  }

  /** Checks whether the 'dccInfo' field has been set, however the value could be null */
  public boolean hasDccInfo() {
    return genClient.cacheHasKey(CacheKey.dccInfo);
  }

  /** Checks whether the 'transactionSettings' field has been set, however the value could be null */
  public boolean hasTransactionSettings() {
    return genClient.cacheHasKey(CacheKey.transactionSettings);
  }

  /** Checks whether the 'germanInfo' field has been set, however the value could be null */
  public boolean hasGermanInfo() {
    return genClient.cacheHasKey(CacheKey.germanInfo);
  }

  /** Checks whether the 'appTracking' field has been set, however the value could be null */
  public boolean hasAppTracking() {
    return genClient.cacheHasKey(CacheKey.appTracking);
  }

  /** Checks whether the 'cashAdvanceExtra' field has been set, however the value could be null */
  public boolean hasCashAdvanceExtra() {
    return genClient.cacheHasKey(CacheKey.cashAdvanceExtra);
  }


  /**
   * Sets the field 'id'.
   */
  public Payment setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'order'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setOrder(com.clover.sdk.v3.base.Reference order) {
    return genClient.setRecord(order, CacheKey.order);
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setDevice(com.clover.sdk.v3.base.Reference device) {
    return genClient.setRecord(device, CacheKey.device);
  }

  /**
   * Sets the field 'tender'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setTender(com.clover.sdk.v3.base.Tender tender) {
    return genClient.setRecord(tender, CacheKey.tender);
  }

  /**
   * Sets the field 'amount'.
   */
  public Payment setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'tipAmount'.
   */
  public Payment setTipAmount(java.lang.Long tipAmount) {
    return genClient.setOther(tipAmount, CacheKey.tipAmount);
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public Payment setTaxAmount(java.lang.Long taxAmount) {
    return genClient.setOther(taxAmount, CacheKey.taxAmount);
  }

  /**
   * Sets the field 'cashbackAmount'.
   */
  public Payment setCashbackAmount(java.lang.Long cashbackAmount) {
    return genClient.setOther(cashbackAmount, CacheKey.cashbackAmount);
  }

  /**
   * Sets the field 'cashTendered'.
   */
  public Payment setCashTendered(java.lang.Long cashTendered) {
    return genClient.setOther(cashTendered, CacheKey.cashTendered);
  }

  /**
   * Sets the field 'externalPaymentId'.
   */
  public Payment setExternalPaymentId(java.lang.String externalPaymentId) {
    return genClient.setOther(externalPaymentId, CacheKey.externalPaymentId);
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setEmployee(com.clover.sdk.v3.base.Reference employee) {
    return genClient.setRecord(employee, CacheKey.employee);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Payment setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Payment setClientCreatedTime(java.lang.Long clientCreatedTime) {
    return genClient.setOther(clientCreatedTime, CacheKey.clientCreatedTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Payment setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'offline'.
   */
  public Payment setOffline(java.lang.Boolean offline) {
    return genClient.setOther(offline, CacheKey.offline);
  }

  /**
   * Sets the field 'result'.
   */
  public Payment setResult(com.clover.sdk.v3.payments.Result result) {
    return genClient.setOther(result, CacheKey.result);
  }

  /**
   * Sets the field 'cardTransaction'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setCardTransaction(com.clover.sdk.v3.payments.CardTransaction cardTransaction) {
    return genClient.setRecord(cardTransaction, CacheKey.cardTransaction);
  }

  /**
   * Sets the field 'serviceCharge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setServiceCharge(com.clover.sdk.v3.payments.ServiceChargeAmount serviceCharge) {
    return genClient.setRecord(serviceCharge, CacheKey.serviceCharge);
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setTaxRates(java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> taxRates) {
    return genClient.setArrayRecord(taxRates, CacheKey.taxRates);
  }

  /**
   * Sets the field 'refunds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setRefunds(java.util.List<com.clover.sdk.v3.payments.Refund> refunds) {
    return genClient.setArrayRecord(refunds, CacheKey.refunds);
  }

  /**
   * Sets the field 'note'.
   */
  public Payment setNote(java.lang.String note) {
    return genClient.setOther(note, CacheKey.note);
  }

  /**
   * Sets the field 'lineItemPayments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setLineItemPayments(java.util.List<com.clover.sdk.v3.payments.LineItemPayment> lineItemPayments) {
    return genClient.setArrayRecord(lineItemPayments, CacheKey.lineItemPayments);
  }

  /**
   * Sets the field 'voidReason'.
   */
  public Payment setVoidReason(com.clover.sdk.v3.order.VoidReason voidReason) {
    return genClient.setOther(voidReason, CacheKey.voidReason);
  }

  /**
   * Sets the field 'dccInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setDccInfo(com.clover.sdk.v3.payments.DCCInfo dccInfo) {
    return genClient.setRecord(dccInfo, CacheKey.dccInfo);
  }

  /**
   * Sets the field 'transactionSettings'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setTransactionSettings(com.clover.sdk.v3.payments.TransactionSettings transactionSettings) {
    return genClient.setRecord(transactionSettings, CacheKey.transactionSettings);
  }

  /**
   * Sets the field 'germanInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setGermanInfo(com.clover.sdk.v3.payments.GermanInfo germanInfo) {
    return genClient.setRecord(germanInfo, CacheKey.germanInfo);
  }

  /**
   * Sets the field 'appTracking'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setAppTracking(com.clover.sdk.v3.apps.AppTracking appTracking) {
    return genClient.setRecord(appTracking, CacheKey.appTracking);
  }

  /**
   * Sets the field 'cashAdvanceExtra'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setCashAdvanceExtra(CashAdvanceExtra cashAdvanceExtra) {
    return genClient.setRecord(cashAdvanceExtra, CacheKey.cashAdvanceExtra);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'order' field, the 'has' method for this field will now return false */
  public void clearOrder() {
    genClient.clear(CacheKey.order);
  }
  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    genClient.clear(CacheKey.device);
  }
  /** Clears the 'tender' field, the 'has' method for this field will now return false */
  public void clearTender() {
    genClient.clear(CacheKey.tender);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'tipAmount' field, the 'has' method for this field will now return false */
  public void clearTipAmount() {
    genClient.clear(CacheKey.tipAmount);
  }
  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    genClient.clear(CacheKey.taxAmount);
  }
  /** Clears the 'cashbackAmount' field, the 'has' method for this field will now return false */
  public void clearCashbackAmount() {
    genClient.clear(CacheKey.cashbackAmount);
  }
  /** Clears the 'cashTendered' field, the 'has' method for this field will now return false */
  public void clearCashTendered() {
    genClient.clear(CacheKey.cashTendered);
  }
  /** Clears the 'externalPaymentId' field, the 'has' method for this field will now return false */
  public void clearExternalPaymentId() {
    genClient.clear(CacheKey.externalPaymentId);
  }
  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    genClient.clear(CacheKey.employee);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    genClient.clear(CacheKey.clientCreatedTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'offline' field, the 'has' method for this field will now return false */
  public void clearOffline() {
    genClient.clear(CacheKey.offline);
  }
  /** Clears the 'result' field, the 'has' method for this field will now return false */
  public void clearResult() {
    genClient.clear(CacheKey.result);
  }
  /** Clears the 'cardTransaction' field, the 'has' method for this field will now return false */
  public void clearCardTransaction() {
    genClient.clear(CacheKey.cardTransaction);
  }
  /** Clears the 'serviceCharge' field, the 'has' method for this field will now return false */
  public void clearServiceCharge() {
    genClient.clear(CacheKey.serviceCharge);
  }
  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    genClient.clear(CacheKey.taxRates);
  }
  /** Clears the 'refunds' field, the 'has' method for this field will now return false */
  public void clearRefunds() {
    genClient.clear(CacheKey.refunds);
  }
  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    genClient.clear(CacheKey.note);
  }
  /** Clears the 'lineItemPayments' field, the 'has' method for this field will now return false */
  public void clearLineItemPayments() {
    genClient.clear(CacheKey.lineItemPayments);
  }
  /** Clears the 'voidReason' field, the 'has' method for this field will now return false */
  public void clearVoidReason() {
    genClient.clear(CacheKey.voidReason);
  }
  /** Clears the 'dccInfo' field, the 'has' method for this field will now return false */
  public void clearDccInfo() {
    genClient.clear(CacheKey.dccInfo);
  }
  /** Clears the 'transactionSettings' field, the 'has' method for this field will now return false */
  public void clearTransactionSettings() {
    genClient.clear(CacheKey.transactionSettings);
  }
  /** Clears the 'germanInfo' field, the 'has' method for this field will now return false */
  public void clearGermanInfo() {
    genClient.clear(CacheKey.germanInfo);
  }
  /** Clears the 'appTracking' field, the 'has' method for this field will now return false */
  public void clearAppTracking() {
    genClient.clear(CacheKey.appTracking);
  }
  /** Clears the 'cashAdvanceExtra' field, the 'has' method for this field will now return false */
  public void clearCashAdvanceExtra() {
    genClient.clear(CacheKey.cashAdvanceExtra);
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Payment copyChanges() {
    Payment copy = new Payment();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Payment src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Payment(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Payment> CREATOR = new android.os.Parcelable.Creator<Payment>() {
    @Override
    public Payment createFromParcel(android.os.Parcel in) {
      Payment instance = new Payment(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Payment[] newArray(int size) {
      return new Payment[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Payment> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Payment>() {
    @Override
    public Payment create(org.json.JSONObject jsonObject) {
      return new Payment(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ORDER_IS_REQUIRED = false;
    public static final boolean DEVICE_IS_REQUIRED = false;
    public static final boolean TENDER_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean TIPAMOUNT_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHBACKAMOUNT_IS_REQUIRED = false;
    public static final boolean CASHTENDERED_IS_REQUIRED = false;
    public static final boolean EXTERNALPAYMENTID_IS_REQUIRED = false;
    public static final long EXTERNALPAYMENTID_MAX_LEN = 32;
    public static final boolean EMPLOYEE_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean OFFLINE_IS_REQUIRED = false;
    public static final boolean RESULT_IS_REQUIRED = false;
    public static final boolean CARDTRANSACTION_IS_REQUIRED = false;
    public static final boolean SERVICECHARGE_IS_REQUIRED = false;
    public static final boolean TAXRATES_IS_REQUIRED = false;
    public static final boolean REFUNDS_IS_REQUIRED = false;
    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;
    public static final boolean LINEITEMPAYMENTS_IS_REQUIRED = false;
    public static final boolean VOIDREASON_IS_REQUIRED = false;
    public static final boolean DCCINFO_IS_REQUIRED = false;
    public static final boolean TRANSACTIONSETTINGS_IS_REQUIRED = false;
    public static final boolean GERMANINFO_IS_REQUIRED = false;
    public static final boolean APPTRACKING_IS_REQUIRED = false;
    public static final boolean CASHADVANCEEXTRA_IS_REQUIRED = false;

  }

}
