/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2016 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.report;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * An object containing all of the fields of a Summary plus one additional key (groupByString). This object is useful for mapping the result set of a SQL query which selects Summaries using a GROUP BY clause.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getGroupByField groupByField}</li>
 * <li>{@link #getNum num}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getTipAmount tipAmount}</li>
 * <li>{@link #getTaxAmount taxAmount}</li>
 * <li>{@link #getServiceChargeAmount serviceChargeAmount}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class KeyedSummary extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Group by field
   */
  public java.lang.String getGroupByField() {
    return genClient.cacheGet(CacheKey.groupByField);
  }

  /**
   * Number of rows
   */
  public java.lang.Long getNum() {
    return genClient.cacheGet(CacheKey.num);
  }

  /**
   * Total amount
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * Total tip amount
   */
  public java.lang.Long getTipAmount() {
    return genClient.cacheGet(CacheKey.tipAmount);
  }

  /**
   * total tax amount
   */
  public java.lang.Long getTaxAmount() {
    return genClient.cacheGet(CacheKey.taxAmount);
  }

  /**
   * total service charge amount
   */
  public java.lang.Long getServiceChargeAmount() {
    return genClient.cacheGet(CacheKey.serviceChargeAmount);
  }




  private enum CacheKey implements com.clover.sdk.ValueExtractorEnum<KeyedSummary> {
    groupByField {
      @Override
      public Object extractValue(KeyedSummary instance) {
        return instance.genClient.extractOther("groupByField", java.lang.String.class);
      }
    },
    num {
      @Override
      public Object extractValue(KeyedSummary instance) {
        return instance.genClient.extractOther("num", java.lang.Long.class);
      }
    },
    amount {
      @Override
      public Object extractValue(KeyedSummary instance) {
        return instance.genClient.extractOther("amount", java.lang.Long.class);
      }
    },
    tipAmount {
      @Override
      public Object extractValue(KeyedSummary instance) {
        return instance.genClient.extractOther("tipAmount", java.lang.Long.class);
      }
    },
    taxAmount {
      @Override
      public Object extractValue(KeyedSummary instance) {
        return instance.genClient.extractOther("taxAmount", java.lang.Long.class);
      }
    },
    serviceChargeAmount {
      @Override
      public Object extractValue(KeyedSummary instance) {
        return instance.genClient.extractOther("serviceChargeAmount", java.lang.Long.class);
      }
    },
      ;
  }

  private GenericClient<KeyedSummary> genClient;

  /**
  * Constructs a new empty instance.
  */
  public KeyedSummary() {
    genClient = new GenericClient<KeyedSummary>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
  * Constructs a new empty instance.
  */
  protected KeyedSummary(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public KeyedSummary(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public KeyedSummary(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public KeyedSummary(KeyedSummary src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'groupByField' field is set and is not null */
  public boolean isNotNullGroupByField() {
    return genClient.cacheValueIsNotNull(CacheKey.groupByField);
  }

  /** Checks whether the 'num' field is set and is not null */
  public boolean isNotNullNum() {
    return genClient.cacheValueIsNotNull(CacheKey.num);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field is set and is not null */
  public boolean isNotNullTipAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'serviceChargeAmount' field is set and is not null */
  public boolean isNotNullServiceChargeAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.serviceChargeAmount);
  }



  /** Checks whether the 'groupByField' field has been set, however the value could be null */
  public boolean hasGroupByField() {
    return genClient.cacheHasKey(CacheKey.groupByField);
  }

  /** Checks whether the 'num' field has been set, however the value could be null */
  public boolean hasNum() {
    return genClient.cacheHasKey(CacheKey.num);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field has been set, however the value could be null */
  public boolean hasTipAmount() {
    return genClient.cacheHasKey(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return genClient.cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'serviceChargeAmount' field has been set, however the value could be null */
  public boolean hasServiceChargeAmount() {
    return genClient.cacheHasKey(CacheKey.serviceChargeAmount);
  }


  /**
   * Sets the field 'groupByField'.
   */
  public KeyedSummary setGroupByField(java.lang.String groupByField) {
    return genClient.setOther(groupByField, CacheKey.groupByField);
  }

  /**
   * Sets the field 'num'.
   */
  public KeyedSummary setNum(java.lang.Long num) {
    return genClient.setOther(num, CacheKey.num);
  }

  /**
   * Sets the field 'amount'.
   */
  public KeyedSummary setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'tipAmount'.
   */
  public KeyedSummary setTipAmount(java.lang.Long tipAmount) {
    return genClient.setOther(tipAmount, CacheKey.tipAmount);
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public KeyedSummary setTaxAmount(java.lang.Long taxAmount) {
    return genClient.setOther(taxAmount, CacheKey.taxAmount);
  }

  /**
   * Sets the field 'serviceChargeAmount'.
   */
  public KeyedSummary setServiceChargeAmount(java.lang.Long serviceChargeAmount) {
    return genClient.setOther(serviceChargeAmount, CacheKey.serviceChargeAmount);
  }


  /** Clears the 'groupByField' field, the 'has' method for this field will now return false */
  public void clearGroupByField() {
    genClient.clear(CacheKey.groupByField);
  }
  /** Clears the 'num' field, the 'has' method for this field will now return false */
  public void clearNum() {
    genClient.clear(CacheKey.num);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'tipAmount' field, the 'has' method for this field will now return false */
  public void clearTipAmount() {
    genClient.clear(CacheKey.tipAmount);
  }
  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    genClient.clear(CacheKey.taxAmount);
  }
  /** Clears the 'serviceChargeAmount' field, the 'has' method for this field will now return false */
  public void clearServiceChargeAmount() {
    genClient.clear(CacheKey.serviceChargeAmount);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public KeyedSummary copyChanges() {
    KeyedSummary copy = new KeyedSummary();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(KeyedSummary src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new KeyedSummary(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<KeyedSummary> CREATOR = new android.os.Parcelable.Creator<KeyedSummary>() {
    @Override
    public KeyedSummary createFromParcel(android.os.Parcel in) {
      KeyedSummary instance = new KeyedSummary(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public KeyedSummary[] newArray(int size) {
      return new KeyedSummary[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<KeyedSummary> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<KeyedSummary>() {
    @Override
    public KeyedSummary create(org.json.JSONObject jsonObject) {
      return new KeyedSummary(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean GROUPBYFIELD_IS_REQUIRED = false;
    public static final boolean NUM_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean TIPAMOUNT_IS_REQUIRED = false;
    public static final boolean TAXAMOUNT_IS_REQUIRED = false;
    public static final boolean SERVICECHARGEAMOUNT_IS_REQUIRED = false;

  }

}
