package com.clover.sdk.internal.util;

import java.util.ArrayList;
import java.util.Iterator;

public class Lists {

  public static <E> ArrayList<E> newArrayList() {
    return new ArrayList<E>();
  }

  public static <E> ArrayList<E> newArrayList(E... elements) {
    ArrayList<E> list = new ArrayList<E>();
    if (elements != null) {
      for (E element : elements) {
        list.add(element);
      }
    }
    return list;
  }

  public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
    ArrayList<E> list = new ArrayList<E>();
    if (elements != null) {
      Iterator i = elements.iterator();
      while (i.hasNext()) {
        list.add((E) i.next());
      }
    }
    return list;
  }
}
