/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.base;

@SuppressWarnings("all")
public final class CountryInfo implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    countryCode {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractCountryCode();
      }
    },
    displayName {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractDisplayName();
      }
    },
    localDisplayName {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractLocalDisplayName();
      }
    },
    defaultCurrency {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractDefaultCurrency();
      }
    },
    defaultTimezone {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractDefaultTimezone();
      }
    },
    stateProvinceRequired {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractStateProvinceRequired();
      }
    },
    zipPostalRequired {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractZipPostalRequired();
      }
    },
    defaultLocale {
      @Override
      public Object extractValue(CountryInfo instance) {
        return instance.extractDefaultLocale();
      }
    },
    ;

    public abstract Object extractValue(CountryInfo instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public CountryInfo() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CountryInfo(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CountryInfo(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CountryInfo(CountryInfo src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String countryCode = getCountryCode();
    if (countryCode != null && countryCode.length() > 2) throw new IllegalArgumentException("Maximum string length exceeded for 'countryCode'");

    java.lang.String defaultCurrency = getDefaultCurrency();
    if (defaultCurrency != null && defaultCurrency.length() > 3) throw new IllegalArgumentException("Maximum string length exceeded for 'defaultCurrency'");

    java.lang.String defaultTimezone = getDefaultTimezone();
    if (defaultTimezone != null && defaultTimezone.length() > 255) throw new IllegalArgumentException("Maximum string length exceeded for 'defaultTimezone'");

    java.lang.String defaultLocale = getDefaultLocale();
    if (defaultLocale != null && defaultLocale.length() > 5) throw new IllegalArgumentException("Maximum string length exceeded for 'defaultLocale'");
  }


  /**
   * ISO 3166-1-alpha-2 code
   */
  public java.lang.String getCountryCode() {
    return cacheGet(CacheKey.countryCode);
  }

  private java.lang.String extractCountryCode() {
    return getJSONObject().isNull("countryCode") ? null :
      getJSONObject().optString("countryCode");
  }

  /**
   */
  public java.lang.String getDisplayName() {
    return cacheGet(CacheKey.displayName);
  }

  private java.lang.String extractDisplayName() {
    return getJSONObject().isNull("displayName") ? null :
      getJSONObject().optString("displayName");
  }

  /**
   */
  public java.lang.String getLocalDisplayName() {
    return cacheGet(CacheKey.localDisplayName);
  }

  private java.lang.String extractLocalDisplayName() {
    return getJSONObject().isNull("localDisplayName") ? null :
      getJSONObject().optString("localDisplayName");
  }

  /**
   */
  public java.lang.String getDefaultCurrency() {
    return cacheGet(CacheKey.defaultCurrency);
  }

  private java.lang.String extractDefaultCurrency() {
    return getJSONObject().isNull("defaultCurrency") ? null :
      getJSONObject().optString("defaultCurrency");
  }

  /**
   */
  public java.lang.String getDefaultTimezone() {
    return cacheGet(CacheKey.defaultTimezone);
  }

  private java.lang.String extractDefaultTimezone() {
    return getJSONObject().isNull("defaultTimezone") ? null :
      getJSONObject().optString("defaultTimezone");
  }

  /**
   * Indicates whether the state/province field is required when creating the address
   */
  public java.lang.Boolean getStateProvinceRequired() {
    return cacheGet(CacheKey.stateProvinceRequired);
  }

  private java.lang.Boolean extractStateProvinceRequired() {
    return getJSONObject().isNull("stateProvinceRequired") ? null :
      getJSONObject().optBoolean("stateProvinceRequired");
  }

  /**
   * Indicates whether the ZIP/Postal code field is required when creating the address
   */
  public java.lang.Boolean getZipPostalRequired() {
    return cacheGet(CacheKey.zipPostalRequired);
  }

  private java.lang.Boolean extractZipPostalRequired() {
    return getJSONObject().isNull("zipPostalRequired") ? null :
      getJSONObject().optBoolean("zipPostalRequired");
  }

  /**
   */
  public java.lang.String getDefaultLocale() {
    return cacheGet(CacheKey.defaultLocale);
  }

  private java.lang.String extractDefaultLocale() {
    return getJSONObject().isNull("defaultLocale") ? null :
      getJSONObject().optString("defaultLocale");
  }


  /** Checks whether the 'countryCode' field is set and is not null */
  public boolean isNotNullCountryCode() {
    return cacheValueIsNotNull(CacheKey.countryCode);
  }

  /** Checks whether the 'displayName' field is set and is not null */
  public boolean isNotNullDisplayName() {
    return cacheValueIsNotNull(CacheKey.displayName);
  }

  /** Checks whether the 'localDisplayName' field is set and is not null */
  public boolean isNotNullLocalDisplayName() {
    return cacheValueIsNotNull(CacheKey.localDisplayName);
  }

  /** Checks whether the 'defaultCurrency' field is set and is not null */
  public boolean isNotNullDefaultCurrency() {
    return cacheValueIsNotNull(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'defaultTimezone' field is set and is not null */
  public boolean isNotNullDefaultTimezone() {
    return cacheValueIsNotNull(CacheKey.defaultTimezone);
  }

  /** Checks whether the 'stateProvinceRequired' field is set and is not null */
  public boolean isNotNullStateProvinceRequired() {
    return cacheValueIsNotNull(CacheKey.stateProvinceRequired);
  }

  /** Checks whether the 'zipPostalRequired' field is set and is not null */
  public boolean isNotNullZipPostalRequired() {
    return cacheValueIsNotNull(CacheKey.zipPostalRequired);
  }

  /** Checks whether the 'defaultLocale' field is set and is not null */
  public boolean isNotNullDefaultLocale() {
    return cacheValueIsNotNull(CacheKey.defaultLocale);
  }


  /** Checks whether the 'countryCode' field has been set, however the value could be null */
  public boolean hasCountryCode() {
    return cacheHasKey(CacheKey.countryCode);
  }

  /** Checks whether the 'displayName' field has been set, however the value could be null */
  public boolean hasDisplayName() {
    return cacheHasKey(CacheKey.displayName);
  }

  /** Checks whether the 'localDisplayName' field has been set, however the value could be null */
  public boolean hasLocalDisplayName() {
    return cacheHasKey(CacheKey.localDisplayName);
  }

  /** Checks whether the 'defaultCurrency' field has been set, however the value could be null */
  public boolean hasDefaultCurrency() {
    return cacheHasKey(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'defaultTimezone' field has been set, however the value could be null */
  public boolean hasDefaultTimezone() {
    return cacheHasKey(CacheKey.defaultTimezone);
  }

  /** Checks whether the 'stateProvinceRequired' field has been set, however the value could be null */
  public boolean hasStateProvinceRequired() {
    return cacheHasKey(CacheKey.stateProvinceRequired);
  }

  /** Checks whether the 'zipPostalRequired' field has been set, however the value could be null */
  public boolean hasZipPostalRequired() {
    return cacheHasKey(CacheKey.zipPostalRequired);
  }

  /** Checks whether the 'defaultLocale' field has been set, however the value could be null */
  public boolean hasDefaultLocale() {
    return cacheHasKey(CacheKey.defaultLocale);
  }


  /**
   * Sets the field 'countryCode'.
   */
  public CountryInfo setCountryCode(java.lang.String countryCode) {
    logChange("countryCode");

    try {
      getJSONObject().put("countryCode", countryCode == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(countryCode));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.countryCode);
    return this;
  }

  /**
   * Sets the field 'displayName'.
   */
  public CountryInfo setDisplayName(java.lang.String displayName) {
    logChange("displayName");

    try {
      getJSONObject().put("displayName", displayName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(displayName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.displayName);
    return this;
  }

  /**
   * Sets the field 'localDisplayName'.
   */
  public CountryInfo setLocalDisplayName(java.lang.String localDisplayName) {
    logChange("localDisplayName");

    try {
      getJSONObject().put("localDisplayName", localDisplayName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(localDisplayName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.localDisplayName);
    return this;
  }

  /**
   * Sets the field 'defaultCurrency'.
   */
  public CountryInfo setDefaultCurrency(java.lang.String defaultCurrency) {
    logChange("defaultCurrency");

    try {
      getJSONObject().put("defaultCurrency", defaultCurrency == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(defaultCurrency));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.defaultCurrency);
    return this;
  }

  /**
   * Sets the field 'defaultTimezone'.
   */
  public CountryInfo setDefaultTimezone(java.lang.String defaultTimezone) {
    logChange("defaultTimezone");

    try {
      getJSONObject().put("defaultTimezone", defaultTimezone == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(defaultTimezone));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.defaultTimezone);
    return this;
  }

  /**
   * Sets the field 'stateProvinceRequired'.
   */
  public CountryInfo setStateProvinceRequired(java.lang.Boolean stateProvinceRequired) {
    logChange("stateProvinceRequired");

    try {
      getJSONObject().put("stateProvinceRequired", stateProvinceRequired == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(stateProvinceRequired));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.stateProvinceRequired);
    return this;
  }

  /**
   * Sets the field 'zipPostalRequired'.
   */
  public CountryInfo setZipPostalRequired(java.lang.Boolean zipPostalRequired) {
    logChange("zipPostalRequired");

    try {
      getJSONObject().put("zipPostalRequired", zipPostalRequired == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(zipPostalRequired));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.zipPostalRequired);
    return this;
  }

  /**
   * Sets the field 'defaultLocale'.
   */
  public CountryInfo setDefaultLocale(java.lang.String defaultLocale) {
    logChange("defaultLocale");

    try {
      getJSONObject().put("defaultLocale", defaultLocale == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(defaultLocale));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.defaultLocale);
    return this;
  }


  /** Clears the 'countryCode' field, the 'has' method for this field will now return false */
  public void clearCountryCode() {
    unlogChange("countryCode");
    getJSONObject().remove("countryCode");
    cacheRemoveValue(CacheKey.countryCode);
  }

  /** Clears the 'displayName' field, the 'has' method for this field will now return false */
  public void clearDisplayName() {
    unlogChange("displayName");
    getJSONObject().remove("displayName");
    cacheRemoveValue(CacheKey.displayName);
  }

  /** Clears the 'localDisplayName' field, the 'has' method for this field will now return false */
  public void clearLocalDisplayName() {
    unlogChange("localDisplayName");
    getJSONObject().remove("localDisplayName");
    cacheRemoveValue(CacheKey.localDisplayName);
  }

  /** Clears the 'defaultCurrency' field, the 'has' method for this field will now return false */
  public void clearDefaultCurrency() {
    unlogChange("defaultCurrency");
    getJSONObject().remove("defaultCurrency");
    cacheRemoveValue(CacheKey.defaultCurrency);
  }

  /** Clears the 'defaultTimezone' field, the 'has' method for this field will now return false */
  public void clearDefaultTimezone() {
    unlogChange("defaultTimezone");
    getJSONObject().remove("defaultTimezone");
    cacheRemoveValue(CacheKey.defaultTimezone);
  }

  /** Clears the 'stateProvinceRequired' field, the 'has' method for this field will now return false */
  public void clearStateProvinceRequired() {
    unlogChange("stateProvinceRequired");
    getJSONObject().remove("stateProvinceRequired");
    cacheRemoveValue(CacheKey.stateProvinceRequired);
  }

  /** Clears the 'zipPostalRequired' field, the 'has' method for this field will now return false */
  public void clearZipPostalRequired() {
    unlogChange("zipPostalRequired");
    getJSONObject().remove("zipPostalRequired");
    cacheRemoveValue(CacheKey.zipPostalRequired);
  }

  /** Clears the 'defaultLocale' field, the 'has' method for this field will now return false */
  public void clearDefaultLocale() {
    unlogChange("defaultLocale");
    getJSONObject().remove("defaultLocale");
    cacheRemoveValue(CacheKey.defaultLocale);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CountryInfo copyChanges() {
    CountryInfo copy = new CountryInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CountryInfo src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new CountryInfo(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "CountryInfo{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<CountryInfo> CREATOR = new android.os.Parcelable.Creator<CountryInfo>() {
    @Override
    public CountryInfo createFromParcel(android.os.Parcel in) {
      CountryInfo instance = new CountryInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public CountryInfo[] newArray(int size) {
      return new CountryInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CountryInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CountryInfo>() {
    @Override
    public CountryInfo create(org.json.JSONObject jsonObject) {
      return new CountryInfo(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean COUNTRYCODE_IS_REQUIRED = false;
    public static final long COUNTRYCODE_MAX_LEN = 2;

    public static final boolean DISPLAYNAME_IS_REQUIRED = false;

    public static final boolean LOCALDISPLAYNAME_IS_REQUIRED = false;

    public static final boolean DEFAULTCURRENCY_IS_REQUIRED = false;
    public static final long DEFAULTCURRENCY_MAX_LEN = 3;

    public static final boolean DEFAULTTIMEZONE_IS_REQUIRED = false;
    public static final long DEFAULTTIMEZONE_MAX_LEN = 255;

    public static final boolean STATEPROVINCEREQUIRED_IS_REQUIRED = false;

    public static final boolean ZIPPOSTALREQUIRED_IS_REQUIRED = false;

    public static final boolean DEFAULTLOCALE_IS_REQUIRED = false;
    public static final long DEFAULTLOCALE_MAX_LEN = 5;

  }

}
