/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.customers;

@SuppressWarnings("all")
public final class Customer implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractId();
      }
    },
    firstName {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractFirstName();
      }
    },
    lastName {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractLastName();
      }
    },
    marketingAllowed {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractMarketingAllowed();
      }
    },
    customerSince {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractCustomerSince();
      }
    },
    addresses {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractAddresses();
      }
    },
    emailAddresses {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractEmailAddresses();
      }
    },
    phoneNumbers {
      @Override
      public Object extractValue(Customer instance) {
        return instance.extractPhoneNumbers();
      }
    },
    ;

    public abstract Object extractValue(Customer instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Customer() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Customer(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Customer(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Customer(Customer src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * First/given name of the customer
   */
  public java.lang.String getFirstName() {
    return cacheGet(CacheKey.firstName);
  }

  private java.lang.String extractFirstName() {
    return getJSONObject().isNull("firstName") ? null :
      getJSONObject().optString("firstName");
  }

  /**
   * Last name/surname of the customer
   */
  public java.lang.String getLastName() {
    return cacheGet(CacheKey.lastName);
  }

  private java.lang.String extractLastName() {
    return getJSONObject().isNull("lastName") ? null :
      getJSONObject().optString("lastName");
  }

  /**
   */
  public java.lang.Boolean getMarketingAllowed() {
    return cacheGet(CacheKey.marketingAllowed);
  }

  private java.lang.Boolean extractMarketingAllowed() {
    return getJSONObject().isNull("marketingAllowed") ? null :
      getJSONObject().optBoolean("marketingAllowed");
  }

  /**
   */
  public java.lang.Long getCustomerSince() {
    return cacheGet(CacheKey.customerSince);
  }

  private java.lang.Long extractCustomerSince() {
    return getJSONObject().isNull("customerSince") ? null :
      getJSONObject().optLong("customerSince");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.base.Address> getAddresses() {
    return cacheGet(CacheKey.addresses);
  }

  private java.util.List<com.clover.sdk.v3.base.Address> extractAddresses() {
    if (getJSONObject().isNull("addresses")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("addresses");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.base.Address> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.base.Address>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.base.Address item = new com.clover.sdk.v3.base.Address(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.customers.EmailAddress> getEmailAddresses() {
    return cacheGet(CacheKey.emailAddresses);
  }

  private java.util.List<com.clover.sdk.v3.customers.EmailAddress> extractEmailAddresses() {
    if (getJSONObject().isNull("emailAddresses")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("emailAddresses");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.customers.EmailAddress> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.customers.EmailAddress>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.customers.EmailAddress item = new com.clover.sdk.v3.customers.EmailAddress(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.customers.PhoneNumber> getPhoneNumbers() {
    return cacheGet(CacheKey.phoneNumbers);
  }

  private java.util.List<com.clover.sdk.v3.customers.PhoneNumber> extractPhoneNumbers() {
    if (getJSONObject().isNull("phoneNumbers")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("phoneNumbers");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.customers.PhoneNumber> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.customers.PhoneNumber>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.customers.PhoneNumber item = new com.clover.sdk.v3.customers.PhoneNumber(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'firstName' field is set and is not null */
  public boolean isNotNullFirstName() {
    return cacheValueIsNotNull(CacheKey.firstName);
  }

  /** Checks whether the 'lastName' field is set and is not null */
  public boolean isNotNullLastName() {
    return cacheValueIsNotNull(CacheKey.lastName);
  }

  /** Checks whether the 'marketingAllowed' field is set and is not null */
  public boolean isNotNullMarketingAllowed() {
    return cacheValueIsNotNull(CacheKey.marketingAllowed);
  }

  /** Checks whether the 'customerSince' field is set and is not null */
  public boolean isNotNullCustomerSince() {
    return cacheValueIsNotNull(CacheKey.customerSince);
  }

  /** Checks whether the 'addresses' field is set and is not null */
  public boolean isNotNullAddresses() {
    return cacheValueIsNotNull(CacheKey.addresses);
  }

  /** Checks whether the 'addresses' field is set and is not null and is not empty */
  public boolean isNotEmptyAddresses() {
    return isNotNullAddresses() && !getAddresses().isEmpty();
  }

  /** Checks whether the 'emailAddresses' field is set and is not null */
  public boolean isNotNullEmailAddresses() {
    return cacheValueIsNotNull(CacheKey.emailAddresses);
  }

  /** Checks whether the 'emailAddresses' field is set and is not null and is not empty */
  public boolean isNotEmptyEmailAddresses() {
    return isNotNullEmailAddresses() && !getEmailAddresses().isEmpty();
  }

  /** Checks whether the 'phoneNumbers' field is set and is not null */
  public boolean isNotNullPhoneNumbers() {
    return cacheValueIsNotNull(CacheKey.phoneNumbers);
  }

  /** Checks whether the 'phoneNumbers' field is set and is not null and is not empty */
  public boolean isNotEmptyPhoneNumbers() {
    return isNotNullPhoneNumbers() && !getPhoneNumbers().isEmpty();
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'firstName' field has been set, however the value could be null */
  public boolean hasFirstName() {
    return cacheHasKey(CacheKey.firstName);
  }

  /** Checks whether the 'lastName' field has been set, however the value could be null */
  public boolean hasLastName() {
    return cacheHasKey(CacheKey.lastName);
  }

  /** Checks whether the 'marketingAllowed' field has been set, however the value could be null */
  public boolean hasMarketingAllowed() {
    return cacheHasKey(CacheKey.marketingAllowed);
  }

  /** Checks whether the 'customerSince' field has been set, however the value could be null */
  public boolean hasCustomerSince() {
    return cacheHasKey(CacheKey.customerSince);
  }

  /** Checks whether the 'addresses' field has been set, however the value could be null */
  public boolean hasAddresses() {
    return cacheHasKey(CacheKey.addresses);
  }

  /** Checks whether the 'emailAddresses' field has been set, however the value could be null */
  public boolean hasEmailAddresses() {
    return cacheHasKey(CacheKey.emailAddresses);
  }

  /** Checks whether the 'phoneNumbers' field has been set, however the value could be null */
  public boolean hasPhoneNumbers() {
    return cacheHasKey(CacheKey.phoneNumbers);
  }


  /**
   * Sets the field 'id'.
   */
  public Customer setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'firstName'.
   */
  public Customer setFirstName(java.lang.String firstName) {
    logChange("firstName");

    try {
      getJSONObject().put("firstName", firstName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(firstName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.firstName);
    return this;
  }

  /**
   * Sets the field 'lastName'.
   */
  public Customer setLastName(java.lang.String lastName) {
    logChange("lastName");

    try {
      getJSONObject().put("lastName", lastName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(lastName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.lastName);
    return this;
  }

  /**
   * Sets the field 'marketingAllowed'.
   */
  public Customer setMarketingAllowed(java.lang.Boolean marketingAllowed) {
    logChange("marketingAllowed");

    try {
      getJSONObject().put("marketingAllowed", marketingAllowed == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(marketingAllowed));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.marketingAllowed);
    return this;
  }

  /**
   * Sets the field 'customerSince'.
   */
  public Customer setCustomerSince(java.lang.Long customerSince) {
    logChange("customerSince");

    try {
      getJSONObject().put("customerSince", customerSince == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(customerSince));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.customerSince);
    return this;
  }

  /**
   * Sets the field 'addresses'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setAddresses(java.util.List<com.clover.sdk.v3.base.Address> addresses) {
    logChange("addresses");

    try {
      if (addresses == null) {
        getJSONObject().put("addresses", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.addresses);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.base.Address obj : addresses) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("addresses", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.addresses);
    return this;
  }

  /**
   * Sets the field 'emailAddresses'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setEmailAddresses(java.util.List<com.clover.sdk.v3.customers.EmailAddress> emailAddresses) {
    logChange("emailAddresses");

    try {
      if (emailAddresses == null) {
        getJSONObject().put("emailAddresses", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.emailAddresses);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.customers.EmailAddress obj : emailAddresses) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("emailAddresses", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.emailAddresses);
    return this;
  }

  /**
   * Sets the field 'phoneNumbers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setPhoneNumbers(java.util.List<com.clover.sdk.v3.customers.PhoneNumber> phoneNumbers) {
    logChange("phoneNumbers");

    try {
      if (phoneNumbers == null) {
        getJSONObject().put("phoneNumbers", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.phoneNumbers);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.customers.PhoneNumber obj : phoneNumbers) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("phoneNumbers", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.phoneNumbers);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'firstName' field, the 'has' method for this field will now return false */
  public void clearFirstName() {
    unlogChange("firstName");
    getJSONObject().remove("firstName");
    cacheRemoveValue(CacheKey.firstName);
  }

  /** Clears the 'lastName' field, the 'has' method for this field will now return false */
  public void clearLastName() {
    unlogChange("lastName");
    getJSONObject().remove("lastName");
    cacheRemoveValue(CacheKey.lastName);
  }

  /** Clears the 'marketingAllowed' field, the 'has' method for this field will now return false */
  public void clearMarketingAllowed() {
    unlogChange("marketingAllowed");
    getJSONObject().remove("marketingAllowed");
    cacheRemoveValue(CacheKey.marketingAllowed);
  }

  /** Clears the 'customerSince' field, the 'has' method for this field will now return false */
  public void clearCustomerSince() {
    unlogChange("customerSince");
    getJSONObject().remove("customerSince");
    cacheRemoveValue(CacheKey.customerSince);
  }

  /** Clears the 'addresses' field, the 'has' method for this field will now return false */
  public void clearAddresses() {
    unlogChange("addresses");
    getJSONObject().remove("addresses");
    cacheRemoveValue(CacheKey.addresses);
  }

  /** Clears the 'emailAddresses' field, the 'has' method for this field will now return false */
  public void clearEmailAddresses() {
    unlogChange("emailAddresses");
    getJSONObject().remove("emailAddresses");
    cacheRemoveValue(CacheKey.emailAddresses);
  }

  /** Clears the 'phoneNumbers' field, the 'has' method for this field will now return false */
  public void clearPhoneNumbers() {
    unlogChange("phoneNumbers");
    getJSONObject().remove("phoneNumbers");
    cacheRemoveValue(CacheKey.phoneNumbers);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Customer copyChanges() {
    Customer copy = new Customer();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Customer src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Customer(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Customer{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Customer> CREATOR = new android.os.Parcelable.Creator<Customer>() {
    @Override
    public Customer createFromParcel(android.os.Parcel in) {
      Customer instance = new Customer(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Customer[] newArray(int size) {
      return new Customer[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Customer> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Customer>() {
    @Override
    public Customer create(org.json.JSONObject jsonObject) {
      return new Customer(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean FIRSTNAME_IS_REQUIRED = false;
    public static final long FIRSTNAME_MAX_LEN = 64;

    public static final boolean LASTNAME_IS_REQUIRED = false;
    public static final long LASTNAME_MAX_LEN = 64;

    public static final boolean MARKETINGALLOWED_IS_REQUIRED = false;

    public static final boolean CUSTOMERSINCE_IS_REQUIRED = false;

    public static final boolean ADDRESSES_IS_REQUIRED = false;

    public static final boolean EMAILADDRESSES_IS_REQUIRED = false;

    public static final boolean PHONENUMBERS_IS_REQUIRED = false;

  }

}
