/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.employees;

@SuppressWarnings("all")
public final class Employee implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractId();
      }
    },
    name {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractName();
      }
    },
    nickname {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractNickname();
      }
    },
    customId {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractCustomId();
      }
    },
    email {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractEmail();
      }
    },
    inviteSent {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractInviteSent();
      }
    },
    claimedTime {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractClaimedTime();
      }
    },
    pin {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractPin();
      }
    },
    unhashedPin {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractUnhashedPin();
      }
    },
    role {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractRole();
      }
    },
    roles {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractRoles();
      }
    },
    isOwner {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractIsOwner();
      }
    },
    shifts {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractShifts();
      }
    },
    payments {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractPayments();
      }
    },
    orders {
      @Override
      public Object extractValue(Employee instance) {
        return instance.extractOrders();
      }
    },
    ;

    public abstract Object extractValue(Employee instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Employee() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Employee(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Employee(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Employee(Employee src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String name = getName();
    if (name == null) throw new java.lang.IllegalArgumentException("'name' is required to be non-null");
    if (name != null && name.length() > 127) throw new IllegalArgumentException("Maximum string length exceeded for 'name'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * Full name of the employee
   */
  public java.lang.String getName() {
    return cacheGet(CacheKey.name);
  }

  private java.lang.String extractName() {
    return getJSONObject().isNull("name") ? null :
      getJSONObject().optString("name");
  }

  /**
   * Nickname of the employee (shows up on receipts)
   */
  public java.lang.String getNickname() {
    return cacheGet(CacheKey.nickname);
  }

  private java.lang.String extractNickname() {
    return getJSONObject().isNull("nickname") ? null :
      getJSONObject().optString("nickname");
  }

  /**
   * Custom ID of the employee
   */
  public java.lang.String getCustomId() {
    return cacheGet(CacheKey.customId);
  }

  private java.lang.String extractCustomId() {
    return getJSONObject().isNull("customId") ? null :
      getJSONObject().optString("customId");
  }

  /**
   * Email of the employee (optional)
   */
  public java.lang.String getEmail() {
    return cacheGet(CacheKey.email);
  }

  private java.lang.String extractEmail() {
    return getJSONObject().isNull("email") ? null :
      getJSONObject().optString("email");
  }

  /**
   * Returns true if this employee was sent an invite to activate their account
   */
  public java.lang.Boolean getInviteSent() {
    return cacheGet(CacheKey.inviteSent);
  }

  private java.lang.Boolean extractInviteSent() {
    return getJSONObject().isNull("inviteSent") ? null :
      getJSONObject().optBoolean("inviteSent");
  }

  /**
   * Timestamp of when this employee claimed their account
   */
  public java.lang.Long getClaimedTime() {
    return cacheGet(CacheKey.claimedTime);
  }

  private java.lang.Long extractClaimedTime() {
    return getJSONObject().isNull("claimedTime") ? null :
      getJSONObject().optLong("claimedTime");
  }

  /**
   * Employee PIN (hashed)
   */
  public java.lang.String getPin() {
    return cacheGet(CacheKey.pin);
  }

  private java.lang.String extractPin() {
    return getJSONObject().isNull("pin") ? null :
      getJSONObject().optString("pin");
  }

  /**
   * Employee PIN
   */
  public java.lang.String getUnhashedPin() {
    return cacheGet(CacheKey.unhashedPin);
  }

  private java.lang.String extractUnhashedPin() {
    return getJSONObject().isNull("unhashedPin") ? null :
      getJSONObject().optString("unhashedPin");
  }

  /**
   * Employee Role
   */
  public com.clover.sdk.v3.employees.AccountRole getRole() {
    return cacheGet(CacheKey.role);
  }

  private com.clover.sdk.v3.employees.AccountRole extractRole() {
    if (!getJSONObject().isNull("role")) {
      try {
        return com.clover.sdk.v3.employees.AccountRole.valueOf(getJSONObject().optString("role"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getRoles() {
    return cacheGet(CacheKey.roles);
  }

  private java.util.List<com.clover.sdk.v3.base.Reference> extractRoles() {
    if (getJSONObject().isNull("roles")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("roles");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.base.Reference> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.base.Reference>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.base.Reference item = new com.clover.sdk.v3.base.Reference(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * Returns true if this employee is the owner account for this merchant
   */
  public java.lang.Boolean getIsOwner() {
    return cacheGet(CacheKey.isOwner);
  }

  private java.lang.Boolean extractIsOwner() {
    return getJSONObject().isNull("isOwner") ? null :
      getJSONObject().optBoolean("isOwner");
  }

  /**
   * This employee's shifts
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getShifts() {
    return cacheGet(CacheKey.shifts);
  }

  private java.util.List<com.clover.sdk.v3.base.Reference> extractShifts() {
    if (getJSONObject().isNull("shifts")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("shifts");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.base.Reference> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.base.Reference>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.base.Reference item = new com.clover.sdk.v3.base.Reference(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * This employee's payments
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getPayments() {
    return cacheGet(CacheKey.payments);
  }

  private java.util.List<com.clover.sdk.v3.base.Reference> extractPayments() {
    if (getJSONObject().isNull("payments")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("payments");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.base.Reference> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.base.Reference>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.base.Reference item = new com.clover.sdk.v3.base.Reference(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * This employee's orders
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getOrders() {
    return cacheGet(CacheKey.orders);
  }

  private java.util.List<com.clover.sdk.v3.base.Reference> extractOrders() {
    if (getJSONObject().isNull("orders")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("orders");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.base.Reference> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.base.Reference>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.base.Reference item = new com.clover.sdk.v3.base.Reference(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'nickname' field is set and is not null */
  public boolean isNotNullNickname() {
    return cacheValueIsNotNull(CacheKey.nickname);
  }

  /** Checks whether the 'customId' field is set and is not null */
  public boolean isNotNullCustomId() {
    return cacheValueIsNotNull(CacheKey.customId);
  }

  /** Checks whether the 'email' field is set and is not null */
  public boolean isNotNullEmail() {
    return cacheValueIsNotNull(CacheKey.email);
  }

  /** Checks whether the 'inviteSent' field is set and is not null */
  public boolean isNotNullInviteSent() {
    return cacheValueIsNotNull(CacheKey.inviteSent);
  }

  /** Checks whether the 'claimedTime' field is set and is not null */
  public boolean isNotNullClaimedTime() {
    return cacheValueIsNotNull(CacheKey.claimedTime);
  }

  /** Checks whether the 'pin' field is set and is not null */
  public boolean isNotNullPin() {
    return cacheValueIsNotNull(CacheKey.pin);
  }

  /** Checks whether the 'unhashedPin' field is set and is not null */
  public boolean isNotNullUnhashedPin() {
    return cacheValueIsNotNull(CacheKey.unhashedPin);
  }

  /** Checks whether the 'role' field is set and is not null */
  public boolean isNotNullRole() {
    return cacheValueIsNotNull(CacheKey.role);
  }

  /** Checks whether the 'roles' field is set and is not null */
  public boolean isNotNullRoles() {
    return cacheValueIsNotNull(CacheKey.roles);
  }

  /** Checks whether the 'roles' field is set and is not null and is not empty */
  public boolean isNotEmptyRoles() {
    return isNotNullRoles() && !getRoles().isEmpty();
  }

  /** Checks whether the 'isOwner' field is set and is not null */
  public boolean isNotNullIsOwner() {
    return cacheValueIsNotNull(CacheKey.isOwner);
  }

  /** Checks whether the 'shifts' field is set and is not null */
  public boolean isNotNullShifts() {
    return cacheValueIsNotNull(CacheKey.shifts);
  }

  /** Checks whether the 'shifts' field is set and is not null and is not empty */
  public boolean isNotEmptyShifts() {
    return isNotNullShifts() && !getShifts().isEmpty();
  }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() {
    return isNotNullPayments() && !getPayments().isEmpty();
  }

  /** Checks whether the 'orders' field is set and is not null */
  public boolean isNotNullOrders() {
    return cacheValueIsNotNull(CacheKey.orders);
  }

  /** Checks whether the 'orders' field is set and is not null and is not empty */
  public boolean isNotEmptyOrders() {
    return isNotNullOrders() && !getOrders().isEmpty();
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'nickname' field has been set, however the value could be null */
  public boolean hasNickname() {
    return cacheHasKey(CacheKey.nickname);
  }

  /** Checks whether the 'customId' field has been set, however the value could be null */
  public boolean hasCustomId() {
    return cacheHasKey(CacheKey.customId);
  }

  /** Checks whether the 'email' field has been set, however the value could be null */
  public boolean hasEmail() {
    return cacheHasKey(CacheKey.email);
  }

  /** Checks whether the 'inviteSent' field has been set, however the value could be null */
  public boolean hasInviteSent() {
    return cacheHasKey(CacheKey.inviteSent);
  }

  /** Checks whether the 'claimedTime' field has been set, however the value could be null */
  public boolean hasClaimedTime() {
    return cacheHasKey(CacheKey.claimedTime);
  }

  /** Checks whether the 'pin' field has been set, however the value could be null */
  public boolean hasPin() {
    return cacheHasKey(CacheKey.pin);
  }

  /** Checks whether the 'unhashedPin' field has been set, however the value could be null */
  public boolean hasUnhashedPin() {
    return cacheHasKey(CacheKey.unhashedPin);
  }

  /** Checks whether the 'role' field has been set, however the value could be null */
  public boolean hasRole() {
    return cacheHasKey(CacheKey.role);
  }

  /** Checks whether the 'roles' field has been set, however the value could be null */
  public boolean hasRoles() {
    return cacheHasKey(CacheKey.roles);
  }

  /** Checks whether the 'isOwner' field has been set, however the value could be null */
  public boolean hasIsOwner() {
    return cacheHasKey(CacheKey.isOwner);
  }

  /** Checks whether the 'shifts' field has been set, however the value could be null */
  public boolean hasShifts() {
    return cacheHasKey(CacheKey.shifts);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return cacheHasKey(CacheKey.payments);
  }

  /** Checks whether the 'orders' field has been set, however the value could be null */
  public boolean hasOrders() {
    return cacheHasKey(CacheKey.orders);
  }


  /**
   * Sets the field 'id'.
   */
  public Employee setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'name'.
   */
  public Employee setName(java.lang.String name) {
    logChange("name");

    try {
      getJSONObject().put("name", name == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(name));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.name);
    return this;
  }

  /**
   * Sets the field 'nickname'.
   */
  public Employee setNickname(java.lang.String nickname) {
    logChange("nickname");

    try {
      getJSONObject().put("nickname", nickname == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(nickname));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.nickname);
    return this;
  }

  /**
   * Sets the field 'customId'.
   */
  public Employee setCustomId(java.lang.String customId) {
    logChange("customId");

    try {
      getJSONObject().put("customId", customId == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(customId));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.customId);
    return this;
  }

  /**
   * Sets the field 'email'.
   */
  public Employee setEmail(java.lang.String email) {
    logChange("email");

    try {
      getJSONObject().put("email", email == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(email));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.email);
    return this;
  }

  /**
   * Sets the field 'inviteSent'.
   */
  public Employee setInviteSent(java.lang.Boolean inviteSent) {
    logChange("inviteSent");

    try {
      getJSONObject().put("inviteSent", inviteSent == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(inviteSent));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.inviteSent);
    return this;
  }

  /**
   * Sets the field 'claimedTime'.
   */
  public Employee setClaimedTime(java.lang.Long claimedTime) {
    logChange("claimedTime");

    try {
      getJSONObject().put("claimedTime", claimedTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(claimedTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.claimedTime);
    return this;
  }

  /**
   * Sets the field 'pin'.
   */
  public Employee setPin(java.lang.String pin) {
    logChange("pin");

    try {
      getJSONObject().put("pin", pin == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(pin));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.pin);
    return this;
  }

  /**
   * Sets the field 'unhashedPin'.
   */
  public Employee setUnhashedPin(java.lang.String unhashedPin) {
    logChange("unhashedPin");

    try {
      getJSONObject().put("unhashedPin", unhashedPin == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(unhashedPin));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.unhashedPin);
    return this;
  }

  /**
   * Sets the field 'role'.
   */
  public Employee setRole(com.clover.sdk.v3.employees.AccountRole role) {
    logChange("role");

    try {
      getJSONObject().put("role", role == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(role));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.role);
    return this;
  }

  /**
   * Sets the field 'roles'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Employee setRoles(java.util.List<com.clover.sdk.v3.base.Reference> roles) {
    logChange("roles");

    try {
      if (roles == null) {
        getJSONObject().put("roles", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.roles);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.base.Reference obj : roles) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("roles", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.roles);
    return this;
  }

  /**
   * Sets the field 'isOwner'.
   */
  public Employee setIsOwner(java.lang.Boolean isOwner) {
    logChange("isOwner");

    try {
      getJSONObject().put("isOwner", isOwner == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(isOwner));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.isOwner);
    return this;
  }

  /**
   * Sets the field 'shifts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Employee setShifts(java.util.List<com.clover.sdk.v3.base.Reference> shifts) {
    logChange("shifts");

    try {
      if (shifts == null) {
        getJSONObject().put("shifts", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.shifts);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.base.Reference obj : shifts) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("shifts", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.shifts);
    return this;
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Employee setPayments(java.util.List<com.clover.sdk.v3.base.Reference> payments) {
    logChange("payments");

    try {
      if (payments == null) {
        getJSONObject().put("payments", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.payments);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.base.Reference obj : payments) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("payments", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.payments);
    return this;
  }

  /**
   * Sets the field 'orders'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Employee setOrders(java.util.List<com.clover.sdk.v3.base.Reference> orders) {
    logChange("orders");

    try {
      if (orders == null) {
        getJSONObject().put("orders", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.orders);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.base.Reference obj : orders) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("orders", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.orders);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    unlogChange("name");
    getJSONObject().remove("name");
    cacheRemoveValue(CacheKey.name);
  }

  /** Clears the 'nickname' field, the 'has' method for this field will now return false */
  public void clearNickname() {
    unlogChange("nickname");
    getJSONObject().remove("nickname");
    cacheRemoveValue(CacheKey.nickname);
  }

  /** Clears the 'customId' field, the 'has' method for this field will now return false */
  public void clearCustomId() {
    unlogChange("customId");
    getJSONObject().remove("customId");
    cacheRemoveValue(CacheKey.customId);
  }

  /** Clears the 'email' field, the 'has' method for this field will now return false */
  public void clearEmail() {
    unlogChange("email");
    getJSONObject().remove("email");
    cacheRemoveValue(CacheKey.email);
  }

  /** Clears the 'inviteSent' field, the 'has' method for this field will now return false */
  public void clearInviteSent() {
    unlogChange("inviteSent");
    getJSONObject().remove("inviteSent");
    cacheRemoveValue(CacheKey.inviteSent);
  }

  /** Clears the 'claimedTime' field, the 'has' method for this field will now return false */
  public void clearClaimedTime() {
    unlogChange("claimedTime");
    getJSONObject().remove("claimedTime");
    cacheRemoveValue(CacheKey.claimedTime);
  }

  /** Clears the 'pin' field, the 'has' method for this field will now return false */
  public void clearPin() {
    unlogChange("pin");
    getJSONObject().remove("pin");
    cacheRemoveValue(CacheKey.pin);
  }

  /** Clears the 'unhashedPin' field, the 'has' method for this field will now return false */
  public void clearUnhashedPin() {
    unlogChange("unhashedPin");
    getJSONObject().remove("unhashedPin");
    cacheRemoveValue(CacheKey.unhashedPin);
  }

  /** Clears the 'role' field, the 'has' method for this field will now return false */
  public void clearRole() {
    unlogChange("role");
    getJSONObject().remove("role");
    cacheRemoveValue(CacheKey.role);
  }

  /** Clears the 'roles' field, the 'has' method for this field will now return false */
  public void clearRoles() {
    unlogChange("roles");
    getJSONObject().remove("roles");
    cacheRemoveValue(CacheKey.roles);
  }

  /** Clears the 'isOwner' field, the 'has' method for this field will now return false */
  public void clearIsOwner() {
    unlogChange("isOwner");
    getJSONObject().remove("isOwner");
    cacheRemoveValue(CacheKey.isOwner);
  }

  /** Clears the 'shifts' field, the 'has' method for this field will now return false */
  public void clearShifts() {
    unlogChange("shifts");
    getJSONObject().remove("shifts");
    cacheRemoveValue(CacheKey.shifts);
  }

  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    unlogChange("payments");
    getJSONObject().remove("payments");
    cacheRemoveValue(CacheKey.payments);
  }

  /** Clears the 'orders' field, the 'has' method for this field will now return false */
  public void clearOrders() {
    unlogChange("orders");
    getJSONObject().remove("orders");
    cacheRemoveValue(CacheKey.orders);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Employee copyChanges() {
    Employee copy = new Employee();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Employee src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Employee(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Employee{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Employee> CREATOR = new android.os.Parcelable.Creator<Employee>() {
    @Override
    public Employee createFromParcel(android.os.Parcel in) {
      Employee instance = new Employee(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Employee[] newArray(int size) {
      return new Employee[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Employee> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Employee>() {
    @Override
    public Employee create(org.json.JSONObject jsonObject) {
      return new Employee(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;

    public static final boolean NICKNAME_IS_REQUIRED = false;
    public static final long NICKNAME_MAX_LEN = 127;

    public static final boolean CUSTOMID_IS_REQUIRED = false;
    public static final long CUSTOMID_MAX_LEN = 127;

    public static final boolean EMAIL_IS_REQUIRED = false;
    public static final long EMAIL_MAX_LEN = 127;

    public static final boolean INVITESENT_IS_REQUIRED = false;

    public static final boolean CLAIMEDTIME_IS_REQUIRED = false;

    public static final boolean PIN_IS_REQUIRED = false;

    public static final boolean UNHASHEDPIN_IS_REQUIRED = false;

    public static final boolean ROLE_IS_REQUIRED = false;

    public static final boolean ROLES_IS_REQUIRED = false;

    public static final boolean ISOWNER_IS_REQUIRED = false;

    public static final boolean SHIFTS_IS_REQUIRED = false;

    public static final boolean PAYMENTS_IS_REQUIRED = false;

    public static final boolean ORDERS_IS_REQUIRED = false;

  }

}
