/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.employees;

@SuppressWarnings("all")
public final class Shift implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractId();
      }
    },
    employee {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractEmployee();
      }
    },
    cashTipsCollected {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractCashTipsCollected();
      }
    },
    serverBanking {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractServerBanking();
      }
    },
    inTime {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractInTime();
      }
    },
    overrideInTime {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractOverrideInTime();
      }
    },
    overrideInEmployee {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractOverrideInEmployee();
      }
    },
    outTime {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractOutTime();
      }
    },
    overrideOutTime {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractOverrideOutTime();
      }
    },
    overrideOutEmployee {
      @Override
      public Object extractValue(Shift instance) {
        return instance.extractOverrideOutEmployee();
      }
    },
    ;

    public abstract Object extractValue(Shift instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Shift() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Shift(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Shift(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Shift(Shift src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * The employee that worked this shift
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.employees.Employee getEmployee() {
    return cacheGet(CacheKey.employee);
  }

  private com.clover.sdk.v3.employees.Employee extractEmployee() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("employee");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.employees.Employee(getJSONObject().optJSONObject("employee"));
    }
    return null;
  }

  /**
   * Amount of cash tips collected
   */
  public java.lang.Long getCashTipsCollected() {
    return cacheGet(CacheKey.cashTipsCollected);
  }

  private java.lang.Long extractCashTipsCollected() {
    return getJSONObject().isNull("cashTipsCollected") ? null :
      getJSONObject().optLong("cashTipsCollected");
  }

  /**
   * Whether the employee used server banking
   */
  public java.lang.Boolean getServerBanking() {
    return cacheGet(CacheKey.serverBanking);
  }

  private java.lang.Boolean extractServerBanking() {
    return getJSONObject().isNull("serverBanking") ? null :
      getJSONObject().optBoolean("serverBanking");
  }

  /**
   * Clock in time
   */
  public java.lang.Long getInTime() {
    return cacheGet(CacheKey.inTime);
  }

  private java.lang.Long extractInTime() {
    return getJSONObject().isNull("inTime") ? null :
      getJSONObject().optLong("inTime");
  }

  /**
   * Overridden clock in time
   */
  public java.lang.Long getOverrideInTime() {
    return cacheGet(CacheKey.overrideInTime);
  }

  private java.lang.Long extractOverrideInTime() {
    return getJSONObject().isNull("overrideInTime") ? null :
      getJSONObject().optLong("overrideInTime");
  }

  /**
   * The employee who overrode the clock in time
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.employees.Employee getOverrideInEmployee() {
    return cacheGet(CacheKey.overrideInEmployee);
  }

  private com.clover.sdk.v3.employees.Employee extractOverrideInEmployee() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("overrideInEmployee");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.employees.Employee(getJSONObject().optJSONObject("overrideInEmployee"));
    }
    return null;
  }

  /**
   * Clock out time
   */
  public java.lang.Long getOutTime() {
    return cacheGet(CacheKey.outTime);
  }

  private java.lang.Long extractOutTime() {
    return getJSONObject().isNull("outTime") ? null :
      getJSONObject().optLong("outTime");
  }

  /**
   * Overridden clock out time
   */
  public java.lang.Long getOverrideOutTime() {
    return cacheGet(CacheKey.overrideOutTime);
  }

  private java.lang.Long extractOverrideOutTime() {
    return getJSONObject().isNull("overrideOutTime") ? null :
      getJSONObject().optLong("overrideOutTime");
  }

  /**
   * The employee who overrode the clock out time
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.employees.Employee getOverrideOutEmployee() {
    return cacheGet(CacheKey.overrideOutEmployee);
  }

  private com.clover.sdk.v3.employees.Employee extractOverrideOutEmployee() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("overrideOutEmployee");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.employees.Employee(getJSONObject().optJSONObject("overrideOutEmployee"));
    }
    return null;
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'cashTipsCollected' field is set and is not null */
  public boolean isNotNullCashTipsCollected() {
    return cacheValueIsNotNull(CacheKey.cashTipsCollected);
  }

  /** Checks whether the 'serverBanking' field is set and is not null */
  public boolean isNotNullServerBanking() {
    return cacheValueIsNotNull(CacheKey.serverBanking);
  }

  /** Checks whether the 'inTime' field is set and is not null */
  public boolean isNotNullInTime() {
    return cacheValueIsNotNull(CacheKey.inTime);
  }

  /** Checks whether the 'overrideInTime' field is set and is not null */
  public boolean isNotNullOverrideInTime() {
    return cacheValueIsNotNull(CacheKey.overrideInTime);
  }

  /** Checks whether the 'overrideInEmployee' field is set and is not null */
  public boolean isNotNullOverrideInEmployee() {
    return cacheValueIsNotNull(CacheKey.overrideInEmployee);
  }

  /** Checks whether the 'outTime' field is set and is not null */
  public boolean isNotNullOutTime() {
    return cacheValueIsNotNull(CacheKey.outTime);
  }

  /** Checks whether the 'overrideOutTime' field is set and is not null */
  public boolean isNotNullOverrideOutTime() {
    return cacheValueIsNotNull(CacheKey.overrideOutTime);
  }

  /** Checks whether the 'overrideOutEmployee' field is set and is not null */
  public boolean isNotNullOverrideOutEmployee() {
    return cacheValueIsNotNull(CacheKey.overrideOutEmployee);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'cashTipsCollected' field has been set, however the value could be null */
  public boolean hasCashTipsCollected() {
    return cacheHasKey(CacheKey.cashTipsCollected);
  }

  /** Checks whether the 'serverBanking' field has been set, however the value could be null */
  public boolean hasServerBanking() {
    return cacheHasKey(CacheKey.serverBanking);
  }

  /** Checks whether the 'inTime' field has been set, however the value could be null */
  public boolean hasInTime() {
    return cacheHasKey(CacheKey.inTime);
  }

  /** Checks whether the 'overrideInTime' field has been set, however the value could be null */
  public boolean hasOverrideInTime() {
    return cacheHasKey(CacheKey.overrideInTime);
  }

  /** Checks whether the 'overrideInEmployee' field has been set, however the value could be null */
  public boolean hasOverrideInEmployee() {
    return cacheHasKey(CacheKey.overrideInEmployee);
  }

  /** Checks whether the 'outTime' field has been set, however the value could be null */
  public boolean hasOutTime() {
    return cacheHasKey(CacheKey.outTime);
  }

  /** Checks whether the 'overrideOutTime' field has been set, however the value could be null */
  public boolean hasOverrideOutTime() {
    return cacheHasKey(CacheKey.overrideOutTime);
  }

  /** Checks whether the 'overrideOutEmployee' field has been set, however the value could be null */
  public boolean hasOverrideOutEmployee() {
    return cacheHasKey(CacheKey.overrideOutEmployee);
  }


  /**
   * Sets the field 'id'.
   */
  public Shift setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Shift setEmployee(com.clover.sdk.v3.employees.Employee employee) {
    logChange("employee");

    try {
      getJSONObject().put("employee",
          employee == null ? org.json.JSONObject.NULL : employee.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.employee);
    return this;
  }

  /**
   * Sets the field 'cashTipsCollected'.
   */
  public Shift setCashTipsCollected(java.lang.Long cashTipsCollected) {
    logChange("cashTipsCollected");

    try {
      getJSONObject().put("cashTipsCollected", cashTipsCollected == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(cashTipsCollected));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.cashTipsCollected);
    return this;
  }

  /**
   * Sets the field 'serverBanking'.
   */
  public Shift setServerBanking(java.lang.Boolean serverBanking) {
    logChange("serverBanking");

    try {
      getJSONObject().put("serverBanking", serverBanking == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(serverBanking));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.serverBanking);
    return this;
  }

  /**
   * Sets the field 'inTime'.
   */
  public Shift setInTime(java.lang.Long inTime) {
    logChange("inTime");

    try {
      getJSONObject().put("inTime", inTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(inTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.inTime);
    return this;
  }

  /**
   * Sets the field 'overrideInTime'.
   */
  public Shift setOverrideInTime(java.lang.Long overrideInTime) {
    logChange("overrideInTime");

    try {
      getJSONObject().put("overrideInTime", overrideInTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(overrideInTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.overrideInTime);
    return this;
  }

  /**
   * Sets the field 'overrideInEmployee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Shift setOverrideInEmployee(com.clover.sdk.v3.employees.Employee overrideInEmployee) {
    logChange("overrideInEmployee");

    try {
      getJSONObject().put("overrideInEmployee",
          overrideInEmployee == null ? org.json.JSONObject.NULL : overrideInEmployee.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.overrideInEmployee);
    return this;
  }

  /**
   * Sets the field 'outTime'.
   */
  public Shift setOutTime(java.lang.Long outTime) {
    logChange("outTime");

    try {
      getJSONObject().put("outTime", outTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(outTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.outTime);
    return this;
  }

  /**
   * Sets the field 'overrideOutTime'.
   */
  public Shift setOverrideOutTime(java.lang.Long overrideOutTime) {
    logChange("overrideOutTime");

    try {
      getJSONObject().put("overrideOutTime", overrideOutTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(overrideOutTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.overrideOutTime);
    return this;
  }

  /**
   * Sets the field 'overrideOutEmployee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Shift setOverrideOutEmployee(com.clover.sdk.v3.employees.Employee overrideOutEmployee) {
    logChange("overrideOutEmployee");

    try {
      getJSONObject().put("overrideOutEmployee",
          overrideOutEmployee == null ? org.json.JSONObject.NULL : overrideOutEmployee.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.overrideOutEmployee);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    unlogChange("employee");
    getJSONObject().remove("employee");
    cacheRemoveValue(CacheKey.employee);
  }

  /** Clears the 'cashTipsCollected' field, the 'has' method for this field will now return false */
  public void clearCashTipsCollected() {
    unlogChange("cashTipsCollected");
    getJSONObject().remove("cashTipsCollected");
    cacheRemoveValue(CacheKey.cashTipsCollected);
  }

  /** Clears the 'serverBanking' field, the 'has' method for this field will now return false */
  public void clearServerBanking() {
    unlogChange("serverBanking");
    getJSONObject().remove("serverBanking");
    cacheRemoveValue(CacheKey.serverBanking);
  }

  /** Clears the 'inTime' field, the 'has' method for this field will now return false */
  public void clearInTime() {
    unlogChange("inTime");
    getJSONObject().remove("inTime");
    cacheRemoveValue(CacheKey.inTime);
  }

  /** Clears the 'overrideInTime' field, the 'has' method for this field will now return false */
  public void clearOverrideInTime() {
    unlogChange("overrideInTime");
    getJSONObject().remove("overrideInTime");
    cacheRemoveValue(CacheKey.overrideInTime);
  }

  /** Clears the 'overrideInEmployee' field, the 'has' method for this field will now return false */
  public void clearOverrideInEmployee() {
    unlogChange("overrideInEmployee");
    getJSONObject().remove("overrideInEmployee");
    cacheRemoveValue(CacheKey.overrideInEmployee);
  }

  /** Clears the 'outTime' field, the 'has' method for this field will now return false */
  public void clearOutTime() {
    unlogChange("outTime");
    getJSONObject().remove("outTime");
    cacheRemoveValue(CacheKey.outTime);
  }

  /** Clears the 'overrideOutTime' field, the 'has' method for this field will now return false */
  public void clearOverrideOutTime() {
    unlogChange("overrideOutTime");
    getJSONObject().remove("overrideOutTime");
    cacheRemoveValue(CacheKey.overrideOutTime);
  }

  /** Clears the 'overrideOutEmployee' field, the 'has' method for this field will now return false */
  public void clearOverrideOutEmployee() {
    unlogChange("overrideOutEmployee");
    getJSONObject().remove("overrideOutEmployee");
    cacheRemoveValue(CacheKey.overrideOutEmployee);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Shift copyChanges() {
    Shift copy = new Shift();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Shift src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Shift(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Shift{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Shift> CREATOR = new android.os.Parcelable.Creator<Shift>() {
    @Override
    public Shift createFromParcel(android.os.Parcel in) {
      Shift instance = new Shift(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Shift[] newArray(int size) {
      return new Shift[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Shift> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Shift>() {
    @Override
    public Shift create(org.json.JSONObject jsonObject) {
      return new Shift(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean EMPLOYEE_IS_REQUIRED = false;

    public static final boolean CASHTIPSCOLLECTED_IS_REQUIRED = false;
    public static final long CASHTIPSCOLLECTED_MAX_LEN = 127;

    public static final boolean SERVERBANKING_IS_REQUIRED = false;

    public static final boolean INTIME_IS_REQUIRED = false;

    public static final boolean OVERRIDEINTIME_IS_REQUIRED = false;

    public static final boolean OVERRIDEINEMPLOYEE_IS_REQUIRED = false;

    public static final boolean OUTTIME_IS_REQUIRED = false;

    public static final boolean OVERRIDEOUTTIME_IS_REQUIRED = false;

    public static final boolean OVERRIDEOUTEMPLOYEE_IS_REQUIRED = false;

  }

}
