/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

@SuppressWarnings("all")
public final class Item implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractId();
      }
    },
    hidden {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractHidden();
      }
    },
    parentItem {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractParentItem();
      }
    },
    name {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractName();
      }
    },
    alternateName {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractAlternateName();
      }
    },
    code {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractCode();
      }
    },
    sku {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractSku();
      }
    },
    price {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractPrice();
      }
    },
    priceType {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractPriceType();
      }
    },
    defaultTaxRates {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractDefaultTaxRates();
      }
    },
    unitName {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractUnitName();
      }
    },
    cost {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractCost();
      }
    },
    isRevenue {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractIsRevenue();
      }
    },
    stockCount {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractStockCount();
      }
    },
    taxRates {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractTaxRates();
      }
    },
    modifierGroups {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractModifierGroups();
      }
    },
    categories {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractCategories();
      }
    },
    tags {
      @Override
      public Object extractValue(Item instance) {
        return instance.extractTags();
      }
    },
    ;

    public abstract Object extractValue(Item instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Item() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Item(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Item(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Item(Item src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String name = getName();
    if (name == null) throw new java.lang.IllegalArgumentException("'name' is required to be non-null");
    if (name != null && name.length() > 127) throw new IllegalArgumentException("Maximum string length exceeded for 'name'");

    java.lang.Long price = getPrice();
    if (price == null) throw new java.lang.IllegalArgumentException("'price' is required to be non-null");
    if (price != null && price < 0) throw new IllegalArgumentException("Invalid value for 'price'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * True if this item is hidden from register
   */
  public java.lang.Boolean getHidden() {
    return cacheGet(CacheKey.hidden);
  }

  private java.lang.Boolean extractHidden() {
    return getJSONObject().isNull("hidden") ? null :
      getJSONObject().optBoolean("hidden");
  }

  /**
   * If this item is a variant, this will point to the base item upon which it is based
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getParentItem() {
    return cacheGet(CacheKey.parentItem);
  }

  private com.clover.sdk.v3.base.Reference extractParentItem() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("parentItem");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("parentItem"));
    }
    return null;
  }

  /**
   * Name of the item
   */
  public java.lang.String getName() {
    return cacheGet(CacheKey.name);
  }

  private java.lang.String extractName() {
    return getJSONObject().isNull("name") ? null :
      getJSONObject().optString("name");
  }

  /**
   * Alternate name of the item
   */
  public java.lang.String getAlternateName() {
    return cacheGet(CacheKey.alternateName);
  }

  private java.lang.String extractAlternateName() {
    return getJSONObject().isNull("alternateName") ? null :
      getJSONObject().optString("alternateName");
  }

  /**
   * Product code, e.g. UPC or EAN
   */
  public java.lang.String getCode() {
    return cacheGet(CacheKey.code);
  }

  private java.lang.String extractCode() {
    return getJSONObject().isNull("code") ? null :
      getJSONObject().optString("code");
  }

  /**
   * SKU of the item
   */
  public java.lang.String getSku() {
    return cacheGet(CacheKey.sku);
  }

  private java.lang.String extractSku() {
    return getJSONObject().isNull("sku") ? null :
      getJSONObject().optString("sku");
  }

  /**
   * Price of the item, typically in cents; use priceType and merchant currency to determine actual item price
   */
  public java.lang.Long getPrice() {
    return cacheGet(CacheKey.price);
  }

  private java.lang.Long extractPrice() {
    return getJSONObject().isNull("price") ? null :
      getJSONObject().optLong("price");
  }

  /**
   */
  public com.clover.sdk.v3.inventory.PriceType getPriceType() {
    return cacheGet(CacheKey.priceType);
  }

  private com.clover.sdk.v3.inventory.PriceType extractPriceType() {
    if (!getJSONObject().isNull("priceType")) {
      try {
        return com.clover.sdk.v3.inventory.PriceType.valueOf(getJSONObject().optString("priceType"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }

  /**
   * Flag to indicate whether or not to use default tax rates
   */
  public java.lang.Boolean getDefaultTaxRates() {
    return cacheGet(CacheKey.defaultTaxRates);
  }

  private java.lang.Boolean extractDefaultTaxRates() {
    return getJSONObject().isNull("defaultTaxRates") ? null :
      getJSONObject().optBoolean("defaultTaxRates");
  }

  /**
   * Unit name, e.g. oz, lb
   */
  public java.lang.String getUnitName() {
    return cacheGet(CacheKey.unitName);
  }

  private java.lang.String extractUnitName() {
    return getJSONObject().isNull("unitName") ? null :
      getJSONObject().optString("unitName");
  }

  /**
   * Cost of the item to merchant, as opposed to customer price
   */
  public java.lang.Long getCost() {
    return cacheGet(CacheKey.cost);
  }

  private java.lang.Long extractCost() {
    return getJSONObject().isNull("cost") ? null :
      getJSONObject().optLong("cost");
  }

  /**
   * True if this item should be counted as revenue, for example gift cards and donations would not
   */
  public java.lang.Boolean getIsRevenue() {
    return cacheGet(CacheKey.isRevenue);
  }

  private java.lang.Boolean extractIsRevenue() {
    return getJSONObject().isNull("isRevenue") ? null :
      getJSONObject().optBoolean("isRevenue");
  }

  /**
   * Current count of this item in stock
   */
  public java.lang.Long getStockCount() {
    return cacheGet(CacheKey.stockCount);
  }

  private java.lang.Long extractStockCount() {
    return getJSONObject().isNull("stockCount") ? null :
      getJSONObject().optLong("stockCount");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.inventory.TaxRate> getTaxRates() {
    return cacheGet(CacheKey.taxRates);
  }

  private java.util.List<com.clover.sdk.v3.inventory.TaxRate> extractTaxRates() {
    if (getJSONObject().isNull("taxRates")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("taxRates");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.inventory.TaxRate> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.inventory.TaxRate>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.inventory.TaxRate item = new com.clover.sdk.v3.inventory.TaxRate(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.inventory.ModifierGroup> getModifierGroups() {
    return cacheGet(CacheKey.modifierGroups);
  }

  private java.util.List<com.clover.sdk.v3.inventory.ModifierGroup> extractModifierGroups() {
    if (getJSONObject().isNull("modifierGroups")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("modifierGroups");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.inventory.ModifierGroup> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.inventory.ModifierGroup>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.inventory.ModifierGroup item = new com.clover.sdk.v3.inventory.ModifierGroup(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * Categories associated with this item
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.inventory.Category> getCategories() {
    return cacheGet(CacheKey.categories);
  }

  private java.util.List<com.clover.sdk.v3.inventory.Category> extractCategories() {
    if (getJSONObject().isNull("categories")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("categories");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.inventory.Category> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.inventory.Category>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.inventory.Category item = new com.clover.sdk.v3.inventory.Category(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * Tags associated with this item
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.inventory.Tag> getTags() {
    return cacheGet(CacheKey.tags);
  }

  private java.util.List<com.clover.sdk.v3.inventory.Tag> extractTags() {
    if (getJSONObject().isNull("tags")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("tags");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.inventory.Tag> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.inventory.Tag>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.inventory.Tag item = new com.clover.sdk.v3.inventory.Tag(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'hidden' field is set and is not null */
  public boolean isNotNullHidden() {
    return cacheValueIsNotNull(CacheKey.hidden);
  }

  /** Checks whether the 'parentItem' field is set and is not null */
  public boolean isNotNullParentItem() {
    return cacheValueIsNotNull(CacheKey.parentItem);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'code' field is set and is not null */
  public boolean isNotNullCode() {
    return cacheValueIsNotNull(CacheKey.code);
  }

  /** Checks whether the 'sku' field is set and is not null */
  public boolean isNotNullSku() {
    return cacheValueIsNotNull(CacheKey.sku);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'priceType' field is set and is not null */
  public boolean isNotNullPriceType() {
    return cacheValueIsNotNull(CacheKey.priceType);
  }

  /** Checks whether the 'defaultTaxRates' field is set and is not null */
  public boolean isNotNullDefaultTaxRates() {
    return cacheValueIsNotNull(CacheKey.defaultTaxRates);
  }

  /** Checks whether the 'unitName' field is set and is not null */
  public boolean isNotNullUnitName() {
    return cacheValueIsNotNull(CacheKey.unitName);
  }

  /** Checks whether the 'cost' field is set and is not null */
  public boolean isNotNullCost() {
    return cacheValueIsNotNull(CacheKey.cost);
  }

  /** Checks whether the 'isRevenue' field is set and is not null */
  public boolean isNotNullIsRevenue() {
    return cacheValueIsNotNull(CacheKey.isRevenue);
  }

  /** Checks whether the 'stockCount' field is set and is not null */
  public boolean isNotNullStockCount() {
    return cacheValueIsNotNull(CacheKey.stockCount);
  }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() {
    return isNotNullTaxRates() && !getTaxRates().isEmpty();
  }

  /** Checks whether the 'modifierGroups' field is set and is not null */
  public boolean isNotNullModifierGroups() {
    return cacheValueIsNotNull(CacheKey.modifierGroups);
  }

  /** Checks whether the 'modifierGroups' field is set and is not null and is not empty */
  public boolean isNotEmptyModifierGroups() {
    return isNotNullModifierGroups() && !getModifierGroups().isEmpty();
  }

  /** Checks whether the 'categories' field is set and is not null */
  public boolean isNotNullCategories() {
    return cacheValueIsNotNull(CacheKey.categories);
  }

  /** Checks whether the 'categories' field is set and is not null and is not empty */
  public boolean isNotEmptyCategories() {
    return isNotNullCategories() && !getCategories().isEmpty();
  }

  /** Checks whether the 'tags' field is set and is not null */
  public boolean isNotNullTags() {
    return cacheValueIsNotNull(CacheKey.tags);
  }

  /** Checks whether the 'tags' field is set and is not null and is not empty */
  public boolean isNotEmptyTags() {
    return isNotNullTags() && !getTags().isEmpty();
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'hidden' field has been set, however the value could be null */
  public boolean hasHidden() {
    return cacheHasKey(CacheKey.hidden);
  }

  /** Checks whether the 'parentItem' field has been set, however the value could be null */
  public boolean hasParentItem() {
    return cacheHasKey(CacheKey.parentItem);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'code' field has been set, however the value could be null */
  public boolean hasCode() {
    return cacheHasKey(CacheKey.code);
  }

  /** Checks whether the 'sku' field has been set, however the value could be null */
  public boolean hasSku() {
    return cacheHasKey(CacheKey.sku);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'priceType' field has been set, however the value could be null */
  public boolean hasPriceType() {
    return cacheHasKey(CacheKey.priceType);
  }

  /** Checks whether the 'defaultTaxRates' field has been set, however the value could be null */
  public boolean hasDefaultTaxRates() {
    return cacheHasKey(CacheKey.defaultTaxRates);
  }

  /** Checks whether the 'unitName' field has been set, however the value could be null */
  public boolean hasUnitName() {
    return cacheHasKey(CacheKey.unitName);
  }

  /** Checks whether the 'cost' field has been set, however the value could be null */
  public boolean hasCost() {
    return cacheHasKey(CacheKey.cost);
  }

  /** Checks whether the 'isRevenue' field has been set, however the value could be null */
  public boolean hasIsRevenue() {
    return cacheHasKey(CacheKey.isRevenue);
  }

  /** Checks whether the 'stockCount' field has been set, however the value could be null */
  public boolean hasStockCount() {
    return cacheHasKey(CacheKey.stockCount);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'modifierGroups' field has been set, however the value could be null */
  public boolean hasModifierGroups() {
    return cacheHasKey(CacheKey.modifierGroups);
  }

  /** Checks whether the 'categories' field has been set, however the value could be null */
  public boolean hasCategories() {
    return cacheHasKey(CacheKey.categories);
  }

  /** Checks whether the 'tags' field has been set, however the value could be null */
  public boolean hasTags() {
    return cacheHasKey(CacheKey.tags);
  }


  /**
   * Sets the field 'id'.
   */
  public Item setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'hidden'.
   */
  public Item setHidden(java.lang.Boolean hidden) {
    logChange("hidden");

    try {
      getJSONObject().put("hidden", hidden == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(hidden));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.hidden);
    return this;
  }

  /**
   * Sets the field 'parentItem'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Item setParentItem(com.clover.sdk.v3.base.Reference parentItem) {
    logChange("parentItem");

    try {
      getJSONObject().put("parentItem",
          parentItem == null ? org.json.JSONObject.NULL : parentItem.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.parentItem);
    return this;
  }

  /**
   * Sets the field 'name'.
   */
  public Item setName(java.lang.String name) {
    logChange("name");

    try {
      getJSONObject().put("name", name == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(name));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.name);
    return this;
  }

  /**
   * Sets the field 'alternateName'.
   */
  public Item setAlternateName(java.lang.String alternateName) {
    logChange("alternateName");

    try {
      getJSONObject().put("alternateName", alternateName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(alternateName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.alternateName);
    return this;
  }

  /**
   * Sets the field 'code'.
   */
  public Item setCode(java.lang.String code) {
    logChange("code");

    try {
      getJSONObject().put("code", code == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(code));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.code);
    return this;
  }

  /**
   * Sets the field 'sku'.
   */
  public Item setSku(java.lang.String sku) {
    logChange("sku");

    try {
      getJSONObject().put("sku", sku == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(sku));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.sku);
    return this;
  }

  /**
   * Sets the field 'price'.
   */
  public Item setPrice(java.lang.Long price) {
    logChange("price");

    try {
      getJSONObject().put("price", price == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(price));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.price);
    return this;
  }

  /**
   * Sets the field 'priceType'.
   */
  public Item setPriceType(com.clover.sdk.v3.inventory.PriceType priceType) {
    logChange("priceType");

    try {
      getJSONObject().put("priceType", priceType == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(priceType));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.priceType);
    return this;
  }

  /**
   * Sets the field 'defaultTaxRates'.
   */
  public Item setDefaultTaxRates(java.lang.Boolean defaultTaxRates) {
    logChange("defaultTaxRates");

    try {
      getJSONObject().put("defaultTaxRates", defaultTaxRates == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(defaultTaxRates));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.defaultTaxRates);
    return this;
  }

  /**
   * Sets the field 'unitName'.
   */
  public Item setUnitName(java.lang.String unitName) {
    logChange("unitName");

    try {
      getJSONObject().put("unitName", unitName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(unitName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.unitName);
    return this;
  }

  /**
   * Sets the field 'cost'.
   */
  public Item setCost(java.lang.Long cost) {
    logChange("cost");

    try {
      getJSONObject().put("cost", cost == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(cost));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.cost);
    return this;
  }

  /**
   * Sets the field 'isRevenue'.
   */
  public Item setIsRevenue(java.lang.Boolean isRevenue) {
    logChange("isRevenue");

    try {
      getJSONObject().put("isRevenue", isRevenue == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(isRevenue));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.isRevenue);
    return this;
  }

  /**
   * Sets the field 'stockCount'.
   */
  public Item setStockCount(java.lang.Long stockCount) {
    logChange("stockCount");

    try {
      getJSONObject().put("stockCount", stockCount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(stockCount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.stockCount);
    return this;
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Item setTaxRates(java.util.List<com.clover.sdk.v3.inventory.TaxRate> taxRates) {
    logChange("taxRates");

    try {
      if (taxRates == null) {
        getJSONObject().put("taxRates", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.taxRates);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.inventory.TaxRate obj : taxRates) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("taxRates", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxRates);
    return this;
  }

  /**
   * Sets the field 'modifierGroups'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Item setModifierGroups(java.util.List<com.clover.sdk.v3.inventory.ModifierGroup> modifierGroups) {
    logChange("modifierGroups");

    try {
      if (modifierGroups == null) {
        getJSONObject().put("modifierGroups", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.modifierGroups);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.inventory.ModifierGroup obj : modifierGroups) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("modifierGroups", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.modifierGroups);
    return this;
  }

  /**
   * Sets the field 'categories'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Item setCategories(java.util.List<com.clover.sdk.v3.inventory.Category> categories) {
    logChange("categories");

    try {
      if (categories == null) {
        getJSONObject().put("categories", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.categories);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.inventory.Category obj : categories) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("categories", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.categories);
    return this;
  }

  /**
   * Sets the field 'tags'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Item setTags(java.util.List<com.clover.sdk.v3.inventory.Tag> tags) {
    logChange("tags");

    try {
      if (tags == null) {
        getJSONObject().put("tags", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.tags);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.inventory.Tag obj : tags) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("tags", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.tags);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'hidden' field, the 'has' method for this field will now return false */
  public void clearHidden() {
    unlogChange("hidden");
    getJSONObject().remove("hidden");
    cacheRemoveValue(CacheKey.hidden);
  }

  /** Clears the 'parentItem' field, the 'has' method for this field will now return false */
  public void clearParentItem() {
    unlogChange("parentItem");
    getJSONObject().remove("parentItem");
    cacheRemoveValue(CacheKey.parentItem);
  }

  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    unlogChange("name");
    getJSONObject().remove("name");
    cacheRemoveValue(CacheKey.name);
  }

  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    unlogChange("alternateName");
    getJSONObject().remove("alternateName");
    cacheRemoveValue(CacheKey.alternateName);
  }

  /** Clears the 'code' field, the 'has' method for this field will now return false */
  public void clearCode() {
    unlogChange("code");
    getJSONObject().remove("code");
    cacheRemoveValue(CacheKey.code);
  }

  /** Clears the 'sku' field, the 'has' method for this field will now return false */
  public void clearSku() {
    unlogChange("sku");
    getJSONObject().remove("sku");
    cacheRemoveValue(CacheKey.sku);
  }

  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    unlogChange("price");
    getJSONObject().remove("price");
    cacheRemoveValue(CacheKey.price);
  }

  /** Clears the 'priceType' field, the 'has' method for this field will now return false */
  public void clearPriceType() {
    unlogChange("priceType");
    getJSONObject().remove("priceType");
    cacheRemoveValue(CacheKey.priceType);
  }

  /** Clears the 'defaultTaxRates' field, the 'has' method for this field will now return false */
  public void clearDefaultTaxRates() {
    unlogChange("defaultTaxRates");
    getJSONObject().remove("defaultTaxRates");
    cacheRemoveValue(CacheKey.defaultTaxRates);
  }

  /** Clears the 'unitName' field, the 'has' method for this field will now return false */
  public void clearUnitName() {
    unlogChange("unitName");
    getJSONObject().remove("unitName");
    cacheRemoveValue(CacheKey.unitName);
  }

  /** Clears the 'cost' field, the 'has' method for this field will now return false */
  public void clearCost() {
    unlogChange("cost");
    getJSONObject().remove("cost");
    cacheRemoveValue(CacheKey.cost);
  }

  /** Clears the 'isRevenue' field, the 'has' method for this field will now return false */
  public void clearIsRevenue() {
    unlogChange("isRevenue");
    getJSONObject().remove("isRevenue");
    cacheRemoveValue(CacheKey.isRevenue);
  }

  /** Clears the 'stockCount' field, the 'has' method for this field will now return false */
  public void clearStockCount() {
    unlogChange("stockCount");
    getJSONObject().remove("stockCount");
    cacheRemoveValue(CacheKey.stockCount);
  }

  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    unlogChange("taxRates");
    getJSONObject().remove("taxRates");
    cacheRemoveValue(CacheKey.taxRates);
  }

  /** Clears the 'modifierGroups' field, the 'has' method for this field will now return false */
  public void clearModifierGroups() {
    unlogChange("modifierGroups");
    getJSONObject().remove("modifierGroups");
    cacheRemoveValue(CacheKey.modifierGroups);
  }

  /** Clears the 'categories' field, the 'has' method for this field will now return false */
  public void clearCategories() {
    unlogChange("categories");
    getJSONObject().remove("categories");
    cacheRemoveValue(CacheKey.categories);
  }

  /** Clears the 'tags' field, the 'has' method for this field will now return false */
  public void clearTags() {
    unlogChange("tags");
    getJSONObject().remove("tags");
    cacheRemoveValue(CacheKey.tags);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Item copyChanges() {
    Item copy = new Item();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Item src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Item(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Item{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Item> CREATOR = new android.os.Parcelable.Creator<Item>() {
    @Override
    public Item createFromParcel(android.os.Parcel in) {
      Item instance = new Item(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Item[] newArray(int size) {
      return new Item[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Item> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Item>() {
    @Override
    public Item create(org.json.JSONObject jsonObject) {
      return new Item(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean HIDDEN_IS_REQUIRED = false;

    public static final boolean PARENTITEM_IS_REQUIRED = false;

    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;

    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 127;

    public static final boolean CODE_IS_REQUIRED = false;
    public static final long CODE_MAX_LEN = 100;

    public static final boolean SKU_IS_REQUIRED = false;
    public static final long SKU_MAX_LEN = 100;

    public static final boolean PRICE_IS_REQUIRED = true;
    public static final long PRICE_MIN = 0;

    public static final boolean PRICETYPE_IS_REQUIRED = false;

    public static final boolean DEFAULTTAXRATES_IS_REQUIRED = false;

    public static final boolean UNITNAME_IS_REQUIRED = false;
    public static final long UNITNAME_MAX_LEN = 64;

    public static final boolean COST_IS_REQUIRED = false;

    public static final boolean ISREVENUE_IS_REQUIRED = false;

    public static final boolean STOCKCOUNT_IS_REQUIRED = false;
    public static final long STOCKCOUNT_MIN = 0;

    public static final boolean TAXRATES_IS_REQUIRED = false;

    public static final boolean MODIFIERGROUPS_IS_REQUIRED = false;

    public static final boolean CATEGORIES_IS_REQUIRED = false;

    public static final boolean TAGS_IS_REQUIRED = false;

  }

}
