/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

@SuppressWarnings("all")
public final class Modifier implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Modifier instance) {
        return instance.extractId();
      }
    },
    name {
      @Override
      public Object extractValue(Modifier instance) {
        return instance.extractName();
      }
    },
    alternateName {
      @Override
      public Object extractValue(Modifier instance) {
        return instance.extractAlternateName();
      }
    },
    price {
      @Override
      public Object extractValue(Modifier instance) {
        return instance.extractPrice();
      }
    },
    modifierGroup {
      @Override
      public Object extractValue(Modifier instance) {
        return instance.extractModifierGroup();
      }
    },
    ;

    public abstract Object extractValue(Modifier instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Modifier() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Modifier(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Modifier(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Modifier(Modifier src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String name = getName();
    if (name == null) throw new java.lang.IllegalArgumentException("'name' is required to be non-null");
    if (name != null && name.length() > 255) throw new IllegalArgumentException("Maximum string length exceeded for 'name'");

    java.lang.String alternateName = getAlternateName();
    if (alternateName != null && alternateName.length() > 255) throw new IllegalArgumentException("Maximum string length exceeded for 'alternateName'");

    java.lang.Long price = getPrice();
    if (price == null) throw new java.lang.IllegalArgumentException("'price' is required to be non-null");
    if (price != null && price < 0) throw new IllegalArgumentException("Invalid value for 'price'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * Name of the modifier
   */
  public java.lang.String getName() {
    return cacheGet(CacheKey.name);
  }

  private java.lang.String extractName() {
    return getJSONObject().isNull("name") ? null :
      getJSONObject().optString("name");
  }

  /**
   * Alternate name of the modifier
   */
  public java.lang.String getAlternateName() {
    return cacheGet(CacheKey.alternateName);
  }

  private java.lang.String extractAlternateName() {
    return getJSONObject().isNull("alternateName") ? null :
      getJSONObject().optString("alternateName");
  }

  /**
   */
  public java.lang.Long getPrice() {
    return cacheGet(CacheKey.price);
  }

  private java.lang.Long extractPrice() {
    return getJSONObject().isNull("price") ? null :
      getJSONObject().optLong("price");
  }

  /**
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getModifierGroup() {
    return cacheGet(CacheKey.modifierGroup);
  }

  private com.clover.sdk.v3.base.Reference extractModifierGroup() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("modifierGroup");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("modifierGroup"));
    }
    return null;
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'modifierGroup' field is set and is not null */
  public boolean isNotNullModifierGroup() {
    return cacheValueIsNotNull(CacheKey.modifierGroup);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'modifierGroup' field has been set, however the value could be null */
  public boolean hasModifierGroup() {
    return cacheHasKey(CacheKey.modifierGroup);
  }


  /**
   * Sets the field 'id'.
   */
  public Modifier setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'name'.
   */
  public Modifier setName(java.lang.String name) {
    logChange("name");

    try {
      getJSONObject().put("name", name == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(name));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.name);
    return this;
  }

  /**
   * Sets the field 'alternateName'.
   */
  public Modifier setAlternateName(java.lang.String alternateName) {
    logChange("alternateName");

    try {
      getJSONObject().put("alternateName", alternateName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(alternateName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.alternateName);
    return this;
  }

  /**
   * Sets the field 'price'.
   */
  public Modifier setPrice(java.lang.Long price) {
    logChange("price");

    try {
      getJSONObject().put("price", price == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(price));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.price);
    return this;
  }

  /**
   * Sets the field 'modifierGroup'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Modifier setModifierGroup(com.clover.sdk.v3.base.Reference modifierGroup) {
    logChange("modifierGroup");

    try {
      getJSONObject().put("modifierGroup",
          modifierGroup == null ? org.json.JSONObject.NULL : modifierGroup.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.modifierGroup);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    unlogChange("name");
    getJSONObject().remove("name");
    cacheRemoveValue(CacheKey.name);
  }

  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    unlogChange("alternateName");
    getJSONObject().remove("alternateName");
    cacheRemoveValue(CacheKey.alternateName);
  }

  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    unlogChange("price");
    getJSONObject().remove("price");
    cacheRemoveValue(CacheKey.price);
  }

  /** Clears the 'modifierGroup' field, the 'has' method for this field will now return false */
  public void clearModifierGroup() {
    unlogChange("modifierGroup");
    getJSONObject().remove("modifierGroup");
    cacheRemoveValue(CacheKey.modifierGroup);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Modifier copyChanges() {
    Modifier copy = new Modifier();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Modifier src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Modifier(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Modifier{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Modifier> CREATOR = new android.os.Parcelable.Creator<Modifier>() {
    @Override
    public Modifier createFromParcel(android.os.Parcel in) {
      Modifier instance = new Modifier(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Modifier[] newArray(int size) {
      return new Modifier[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Modifier> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Modifier>() {
    @Override
    public Modifier create(org.json.JSONObject jsonObject) {
      return new Modifier(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 255;

    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 255;

    public static final boolean PRICE_IS_REQUIRED = true;
    public static final long PRICE_MIN = 0;

    public static final boolean MODIFIERGROUP_IS_REQUIRED = false;

  }

}
