/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.inventory;

@SuppressWarnings("all")
public final class TagPrinter implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    tag {
      @Override
      public Object extractValue(TagPrinter instance) {
        return instance.extractTag();
      }
    },
    printer {
      @Override
      public Object extractValue(TagPrinter instance) {
        return instance.extractPrinter();
      }
    },
    ;

    public abstract Object extractValue(TagPrinter instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public TagPrinter() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public TagPrinter(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public TagPrinter(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public TagPrinter(TagPrinter src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    com.clover.sdk.v3.inventory.Tag tag = getTag();
    if (tag == null) throw new java.lang.IllegalArgumentException("'tag' is required to be non-null");

    com.clover.sdk.v3.printer.Printer printer = getPrinter();
    if (printer == null) throw new java.lang.IllegalArgumentException("'printer' is required to be non-null");
  }


  /**
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.inventory.Tag getTag() {
    return cacheGet(CacheKey.tag);
  }

  private com.clover.sdk.v3.inventory.Tag extractTag() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("tag");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.inventory.Tag(getJSONObject().optJSONObject("tag"));
    }
    return null;
  }

  /**
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.printer.Printer getPrinter() {
    return cacheGet(CacheKey.printer);
  }

  private com.clover.sdk.v3.printer.Printer extractPrinter() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("printer");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.printer.Printer(getJSONObject().optJSONObject("printer"));
    }
    return null;
  }


  /** Checks whether the 'tag' field is set and is not null */
  public boolean isNotNullTag() {
    return cacheValueIsNotNull(CacheKey.tag);
  }

  /** Checks whether the 'printer' field is set and is not null */
  public boolean isNotNullPrinter() {
    return cacheValueIsNotNull(CacheKey.printer);
  }


  /** Checks whether the 'tag' field has been set, however the value could be null */
  public boolean hasTag() {
    return cacheHasKey(CacheKey.tag);
  }

  /** Checks whether the 'printer' field has been set, however the value could be null */
  public boolean hasPrinter() {
    return cacheHasKey(CacheKey.printer);
  }


  /**
   * Sets the field 'tag'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public TagPrinter setTag(com.clover.sdk.v3.inventory.Tag tag) {
    logChange("tag");

    try {
      getJSONObject().put("tag",
          tag == null ? org.json.JSONObject.NULL : tag.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.tag);
    return this;
  }

  /**
   * Sets the field 'printer'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public TagPrinter setPrinter(com.clover.sdk.v3.printer.Printer printer) {
    logChange("printer");

    try {
      getJSONObject().put("printer",
          printer == null ? org.json.JSONObject.NULL : printer.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.printer);
    return this;
  }


  /** Clears the 'tag' field, the 'has' method for this field will now return false */
  public void clearTag() {
    unlogChange("tag");
    getJSONObject().remove("tag");
    cacheRemoveValue(CacheKey.tag);
  }

  /** Clears the 'printer' field, the 'has' method for this field will now return false */
  public void clearPrinter() {
    unlogChange("printer");
    getJSONObject().remove("printer");
    cacheRemoveValue(CacheKey.printer);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public TagPrinter copyChanges() {
    TagPrinter copy = new TagPrinter();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(TagPrinter src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new TagPrinter(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "TagPrinter{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<TagPrinter> CREATOR = new android.os.Parcelable.Creator<TagPrinter>() {
    @Override
    public TagPrinter createFromParcel(android.os.Parcel in) {
      TagPrinter instance = new TagPrinter(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public TagPrinter[] newArray(int size) {
      return new TagPrinter[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<TagPrinter> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<TagPrinter>() {
    @Override
    public TagPrinter create(org.json.JSONObject jsonObject) {
      return new TagPrinter(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean TAG_IS_REQUIRED = true;

    public static final boolean PRINTER_IS_REQUIRED = true;

  }

}
