/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

@SuppressWarnings("all")
public final class LineItem implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractId();
      }
    },
    item {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractItem();
      }
    },
    name {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractName();
      }
    },
    alternateName {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractAlternateName();
      }
    },
    price {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractPrice();
      }
    },
    unitQty {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractUnitQty();
      }
    },
    unitName {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractUnitName();
      }
    },
    itemCode {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractItemCode();
      }
    },
    note {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractNote();
      }
    },
    printed {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractPrinted();
      }
    },
    exchangedLineItem {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractExchangedLineItem();
      }
    },
    binName {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractBinName();
      }
    },
    userData {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractUserData();
      }
    },
    createdTime {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractCreatedTime();
      }
    },
    discounts {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractDiscounts();
      }
    },
    discountAmount {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractDiscountAmount();
      }
    },
    exchanged {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractExchanged();
      }
    },
    modifications {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractModifications();
      }
    },
    refunded {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractRefunded();
      }
    },
    isRevenue {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractIsRevenue();
      }
    },
    taxRates {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractTaxRates();
      }
    },
    payments {
      @Override
      public Object extractValue(LineItem instance) {
        return instance.extractPayments();
      }
    },
    ;

    public abstract Object extractValue(LineItem instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public LineItem() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public LineItem(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public LineItem(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public LineItem(LineItem src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * Inventory item used to create this line item
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.inventory.Item getItem() {
    return cacheGet(CacheKey.item);
  }

  private com.clover.sdk.v3.inventory.Item extractItem() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("item");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.inventory.Item(getJSONObject().optJSONObject("item"));
    }
    return null;
  }

  /**
   * Line item name
   */
  public java.lang.String getName() {
    return cacheGet(CacheKey.name);
  }

  private java.lang.String extractName() {
    return getJSONObject().isNull("name") ? null :
      getJSONObject().optString("name");
  }

  /**
   * Alternate name of the line item
   */
  public java.lang.String getAlternateName() {
    return cacheGet(CacheKey.alternateName);
  }

  private java.lang.String extractAlternateName() {
    return getJSONObject().isNull("alternateName") ? null :
      getJSONObject().optString("alternateName");
  }

  /**
   * Price of the item, typically in cents; use priceType and merchant currency to determine actual item price
   */
  public java.lang.Long getPrice() {
    return cacheGet(CacheKey.price);
  }

  private java.lang.Long extractPrice() {
    return getJSONObject().isNull("price") ? null :
      getJSONObject().optLong("price");
  }

  /**
   * Unit quantity
   */
  public java.lang.Integer getUnitQty() {
    return cacheGet(CacheKey.unitQty);
  }

  private java.lang.Integer extractUnitQty() {
    return getJSONObject().isNull("unitQty") ? null :
      getJSONObject().optInt("unitQty");
  }

  /**
   * Unit name (e.g. oz, lb, etc.)
   */
  public java.lang.String getUnitName() {
    return cacheGet(CacheKey.unitName);
  }

  private java.lang.String extractUnitName() {
    return getJSONObject().isNull("unitName") ? null :
      getJSONObject().optString("unitName");
  }

  /**
   */
  public java.lang.String getItemCode() {
    return cacheGet(CacheKey.itemCode);
  }

  private java.lang.String extractItemCode() {
    return getJSONObject().isNull("itemCode") ? null :
      getJSONObject().optString("itemCode");
  }

  /**
   */
  public java.lang.String getNote() {
    return cacheGet(CacheKey.note);
  }

  private java.lang.String extractNote() {
    return getJSONObject().isNull("note") ? null :
      getJSONObject().optString("note");
  }

  /**
   */
  public java.lang.Boolean getPrinted() {
    return cacheGet(CacheKey.printed);
  }

  private java.lang.Boolean extractPrinted() {
    return getJSONObject().isNull("printed") ? null :
      getJSONObject().optBoolean("printed");
  }

  /**
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getExchangedLineItem() {
    return cacheGet(CacheKey.exchangedLineItem);
  }

  private com.clover.sdk.v3.base.Reference extractExchangedLineItem() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("exchangedLineItem");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("exchangedLineItem"));
    }
    return null;
  }

  /**
   */
  public java.lang.String getBinName() {
    return cacheGet(CacheKey.binName);
  }

  private java.lang.String extractBinName() {
    return getJSONObject().isNull("binName") ? null :
      getJSONObject().optString("binName");
  }

  /**
   */
  public java.lang.String getUserData() {
    return cacheGet(CacheKey.userData);
  }

  private java.lang.String extractUserData() {
    return getJSONObject().isNull("userData") ? null :
      getJSONObject().optString("userData");
  }

  /**
   */
  public java.lang.Long getCreatedTime() {
    return cacheGet(CacheKey.createdTime);
  }

  private java.lang.Long extractCreatedTime() {
    return getJSONObject().isNull("createdTime") ? null :
      getJSONObject().optLong("createdTime");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.order.Discount> getDiscounts() {
    return cacheGet(CacheKey.discounts);
  }

  private java.util.List<com.clover.sdk.v3.order.Discount> extractDiscounts() {
    if (getJSONObject().isNull("discounts")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("discounts");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.order.Discount> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.order.Discount>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.order.Discount item = new com.clover.sdk.v3.order.Discount(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * does the calculated flag actually do anything?
   */
  public java.lang.Long getDiscountAmount() {
    return cacheGet(CacheKey.discountAmount);
  }

  private java.lang.Long extractDiscountAmount() {
    return getJSONObject().isNull("discountAmount") ? null :
      getJSONObject().optLong("discountAmount");
  }

  /**
   */
  public java.lang.Boolean getExchanged() {
    return cacheGet(CacheKey.exchanged);
  }

  private java.lang.Boolean extractExchanged() {
    return getJSONObject().isNull("exchanged") ? null :
      getJSONObject().optBoolean("exchanged");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.order.Modification> getModifications() {
    return cacheGet(CacheKey.modifications);
  }

  private java.util.List<com.clover.sdk.v3.order.Modification> extractModifications() {
    if (getJSONObject().isNull("modifications")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("modifications");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.order.Modification> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.order.Modification>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.order.Modification item = new com.clover.sdk.v3.order.Modification(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   */
  public java.lang.Boolean getRefunded() {
    return cacheGet(CacheKey.refunded);
  }

  private java.lang.Boolean extractRefunded() {
    return getJSONObject().isNull("refunded") ? null :
      getJSONObject().optBoolean("refunded");
  }

  /**
   * True if this item should be counted as revenue, for example gift cards and donations would not
   */
  public java.lang.Boolean getIsRevenue() {
    return cacheGet(CacheKey.isRevenue);
  }

  private java.lang.Boolean extractIsRevenue() {
    return getJSONObject().isNull("isRevenue") ? null :
      getJSONObject().optBoolean("isRevenue");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.inventory.TaxRate> getTaxRates() {
    return cacheGet(CacheKey.taxRates);
  }

  private java.util.List<com.clover.sdk.v3.inventory.TaxRate> extractTaxRates() {
    if (getJSONObject().isNull("taxRates")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("taxRates");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.inventory.TaxRate> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.inventory.TaxRate>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.inventory.TaxRate item = new com.clover.sdk.v3.inventory.TaxRate(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * Payments that were made for this line item
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.LineItemPayment> getPayments() {
    return cacheGet(CacheKey.payments);
  }

  private java.util.List<com.clover.sdk.v3.payments.LineItemPayment> extractPayments() {
    if (getJSONObject().isNull("payments")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("payments");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.LineItemPayment> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.LineItemPayment>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.LineItemPayment item = new com.clover.sdk.v3.payments.LineItemPayment(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'item' field is set and is not null */
  public boolean isNotNullItem() {
    return cacheValueIsNotNull(CacheKey.item);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field is set and is not null */
  public boolean isNotNullAlternateName() {
    return cacheValueIsNotNull(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field is set and is not null */
  public boolean isNotNullPrice() {
    return cacheValueIsNotNull(CacheKey.price);
  }

  /** Checks whether the 'unitQty' field is set and is not null */
  public boolean isNotNullUnitQty() {
    return cacheValueIsNotNull(CacheKey.unitQty);
  }

  /** Checks whether the 'unitName' field is set and is not null */
  public boolean isNotNullUnitName() {
    return cacheValueIsNotNull(CacheKey.unitName);
  }

  /** Checks whether the 'itemCode' field is set and is not null */
  public boolean isNotNullItemCode() {
    return cacheValueIsNotNull(CacheKey.itemCode);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'printed' field is set and is not null */
  public boolean isNotNullPrinted() {
    return cacheValueIsNotNull(CacheKey.printed);
  }

  /** Checks whether the 'exchangedLineItem' field is set and is not null */
  public boolean isNotNullExchangedLineItem() {
    return cacheValueIsNotNull(CacheKey.exchangedLineItem);
  }

  /** Checks whether the 'binName' field is set and is not null */
  public boolean isNotNullBinName() {
    return cacheValueIsNotNull(CacheKey.binName);
  }

  /** Checks whether the 'userData' field is set and is not null */
  public boolean isNotNullUserData() {
    return cacheValueIsNotNull(CacheKey.userData);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'discounts' field is set and is not null */
  public boolean isNotNullDiscounts() {
    return cacheValueIsNotNull(CacheKey.discounts);
  }

  /** Checks whether the 'discounts' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscounts() {
    return isNotNullDiscounts() && !getDiscounts().isEmpty();
  }

  /** Checks whether the 'discountAmount' field is set and is not null */
  public boolean isNotNullDiscountAmount() {
    return cacheValueIsNotNull(CacheKey.discountAmount);
  }

  /** Checks whether the 'exchanged' field is set and is not null */
  public boolean isNotNullExchanged() {
    return cacheValueIsNotNull(CacheKey.exchanged);
  }

  /** Checks whether the 'modifications' field is set and is not null */
  public boolean isNotNullModifications() {
    return cacheValueIsNotNull(CacheKey.modifications);
  }

  /** Checks whether the 'modifications' field is set and is not null and is not empty */
  public boolean isNotEmptyModifications() {
    return isNotNullModifications() && !getModifications().isEmpty();
  }

  /** Checks whether the 'refunded' field is set and is not null */
  public boolean isNotNullRefunded() {
    return cacheValueIsNotNull(CacheKey.refunded);
  }

  /** Checks whether the 'isRevenue' field is set and is not null */
  public boolean isNotNullIsRevenue() {
    return cacheValueIsNotNull(CacheKey.isRevenue);
  }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() {
    return isNotNullTaxRates() && !getTaxRates().isEmpty();
  }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() {
    return isNotNullPayments() && !getPayments().isEmpty();
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'item' field has been set, however the value could be null */
  public boolean hasItem() {
    return cacheHasKey(CacheKey.item);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'alternateName' field has been set, however the value could be null */
  public boolean hasAlternateName() {
    return cacheHasKey(CacheKey.alternateName);
  }

  /** Checks whether the 'price' field has been set, however the value could be null */
  public boolean hasPrice() {
    return cacheHasKey(CacheKey.price);
  }

  /** Checks whether the 'unitQty' field has been set, however the value could be null */
  public boolean hasUnitQty() {
    return cacheHasKey(CacheKey.unitQty);
  }

  /** Checks whether the 'unitName' field has been set, however the value could be null */
  public boolean hasUnitName() {
    return cacheHasKey(CacheKey.unitName);
  }

  /** Checks whether the 'itemCode' field has been set, however the value could be null */
  public boolean hasItemCode() {
    return cacheHasKey(CacheKey.itemCode);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'printed' field has been set, however the value could be null */
  public boolean hasPrinted() {
    return cacheHasKey(CacheKey.printed);
  }

  /** Checks whether the 'exchangedLineItem' field has been set, however the value could be null */
  public boolean hasExchangedLineItem() {
    return cacheHasKey(CacheKey.exchangedLineItem);
  }

  /** Checks whether the 'binName' field has been set, however the value could be null */
  public boolean hasBinName() {
    return cacheHasKey(CacheKey.binName);
  }

  /** Checks whether the 'userData' field has been set, however the value could be null */
  public boolean hasUserData() {
    return cacheHasKey(CacheKey.userData);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'discounts' field has been set, however the value could be null */
  public boolean hasDiscounts() {
    return cacheHasKey(CacheKey.discounts);
  }

  /** Checks whether the 'discountAmount' field has been set, however the value could be null */
  public boolean hasDiscountAmount() {
    return cacheHasKey(CacheKey.discountAmount);
  }

  /** Checks whether the 'exchanged' field has been set, however the value could be null */
  public boolean hasExchanged() {
    return cacheHasKey(CacheKey.exchanged);
  }

  /** Checks whether the 'modifications' field has been set, however the value could be null */
  public boolean hasModifications() {
    return cacheHasKey(CacheKey.modifications);
  }

  /** Checks whether the 'refunded' field has been set, however the value could be null */
  public boolean hasRefunded() {
    return cacheHasKey(CacheKey.refunded);
  }

  /** Checks whether the 'isRevenue' field has been set, however the value could be null */
  public boolean hasIsRevenue() {
    return cacheHasKey(CacheKey.isRevenue);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return cacheHasKey(CacheKey.payments);
  }


  /**
   * Sets the field 'id'.
   */
  public LineItem setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'item'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setItem(com.clover.sdk.v3.inventory.Item item) {
    logChange("item");

    try {
      getJSONObject().put("item",
          item == null ? org.json.JSONObject.NULL : item.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.item);
    return this;
  }

  /**
   * Sets the field 'name'.
   */
  public LineItem setName(java.lang.String name) {
    logChange("name");

    try {
      getJSONObject().put("name", name == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(name));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.name);
    return this;
  }

  /**
   * Sets the field 'alternateName'.
   */
  public LineItem setAlternateName(java.lang.String alternateName) {
    logChange("alternateName");

    try {
      getJSONObject().put("alternateName", alternateName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(alternateName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.alternateName);
    return this;
  }

  /**
   * Sets the field 'price'.
   */
  public LineItem setPrice(java.lang.Long price) {
    logChange("price");

    try {
      getJSONObject().put("price", price == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(price));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.price);
    return this;
  }

  /**
   * Sets the field 'unitQty'.
   */
  public LineItem setUnitQty(java.lang.Integer unitQty) {
    logChange("unitQty");

    try {
      getJSONObject().put("unitQty", unitQty == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(unitQty));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.unitQty);
    return this;
  }

  /**
   * Sets the field 'unitName'.
   */
  public LineItem setUnitName(java.lang.String unitName) {
    logChange("unitName");

    try {
      getJSONObject().put("unitName", unitName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(unitName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.unitName);
    return this;
  }

  /**
   * Sets the field 'itemCode'.
   */
  public LineItem setItemCode(java.lang.String itemCode) {
    logChange("itemCode");

    try {
      getJSONObject().put("itemCode", itemCode == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(itemCode));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.itemCode);
    return this;
  }

  /**
   * Sets the field 'note'.
   */
  public LineItem setNote(java.lang.String note) {
    logChange("note");

    try {
      getJSONObject().put("note", note == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(note));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.note);
    return this;
  }

  /**
   * Sets the field 'printed'.
   */
  public LineItem setPrinted(java.lang.Boolean printed) {
    logChange("printed");

    try {
      getJSONObject().put("printed", printed == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(printed));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.printed);
    return this;
  }

  /**
   * Sets the field 'exchangedLineItem'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public LineItem setExchangedLineItem(com.clover.sdk.v3.base.Reference exchangedLineItem) {
    logChange("exchangedLineItem");

    try {
      getJSONObject().put("exchangedLineItem",
          exchangedLineItem == null ? org.json.JSONObject.NULL : exchangedLineItem.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.exchangedLineItem);
    return this;
  }

  /**
   * Sets the field 'binName'.
   */
  public LineItem setBinName(java.lang.String binName) {
    logChange("binName");

    try {
      getJSONObject().put("binName", binName == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(binName));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.binName);
    return this;
  }

  /**
   * Sets the field 'userData'.
   */
  public LineItem setUserData(java.lang.String userData) {
    logChange("userData");

    try {
      getJSONObject().put("userData", userData == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(userData));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.userData);
    return this;
  }

  /**
   * Sets the field 'createdTime'.
   */
  public LineItem setCreatedTime(java.lang.Long createdTime) {
    logChange("createdTime");

    try {
      getJSONObject().put("createdTime", createdTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(createdTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.createdTime);
    return this;
  }

  /**
   * Sets the field 'discounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setDiscounts(java.util.List<com.clover.sdk.v3.order.Discount> discounts) {
    logChange("discounts");

    try {
      if (discounts == null) {
        getJSONObject().put("discounts", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.discounts);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.order.Discount obj : discounts) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("discounts", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.discounts);
    return this;
  }

  /**
   * Sets the field 'discountAmount'.
   */
  public LineItem setDiscountAmount(java.lang.Long discountAmount) {
    logChange("discountAmount");

    try {
      getJSONObject().put("discountAmount", discountAmount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(discountAmount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.discountAmount);
    return this;
  }

  /**
   * Sets the field 'exchanged'.
   */
  public LineItem setExchanged(java.lang.Boolean exchanged) {
    logChange("exchanged");

    try {
      getJSONObject().put("exchanged", exchanged == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(exchanged));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.exchanged);
    return this;
  }

  /**
   * Sets the field 'modifications'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setModifications(java.util.List<com.clover.sdk.v3.order.Modification> modifications) {
    logChange("modifications");

    try {
      if (modifications == null) {
        getJSONObject().put("modifications", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.modifications);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.order.Modification obj : modifications) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("modifications", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.modifications);
    return this;
  }

  /**
   * Sets the field 'refunded'.
   */
  public LineItem setRefunded(java.lang.Boolean refunded) {
    logChange("refunded");

    try {
      getJSONObject().put("refunded", refunded == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(refunded));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.refunded);
    return this;
  }

  /**
   * Sets the field 'isRevenue'.
   */
  public LineItem setIsRevenue(java.lang.Boolean isRevenue) {
    logChange("isRevenue");

    try {
      getJSONObject().put("isRevenue", isRevenue == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(isRevenue));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.isRevenue);
    return this;
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setTaxRates(java.util.List<com.clover.sdk.v3.inventory.TaxRate> taxRates) {
    logChange("taxRates");

    try {
      if (taxRates == null) {
        getJSONObject().put("taxRates", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.taxRates);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.inventory.TaxRate obj : taxRates) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("taxRates", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxRates);
    return this;
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public LineItem setPayments(java.util.List<com.clover.sdk.v3.payments.LineItemPayment> payments) {
    logChange("payments");

    try {
      if (payments == null) {
        getJSONObject().put("payments", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.payments);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.LineItemPayment obj : payments) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("payments", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.payments);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'item' field, the 'has' method for this field will now return false */
  public void clearItem() {
    unlogChange("item");
    getJSONObject().remove("item");
    cacheRemoveValue(CacheKey.item);
  }

  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    unlogChange("name");
    getJSONObject().remove("name");
    cacheRemoveValue(CacheKey.name);
  }

  /** Clears the 'alternateName' field, the 'has' method for this field will now return false */
  public void clearAlternateName() {
    unlogChange("alternateName");
    getJSONObject().remove("alternateName");
    cacheRemoveValue(CacheKey.alternateName);
  }

  /** Clears the 'price' field, the 'has' method for this field will now return false */
  public void clearPrice() {
    unlogChange("price");
    getJSONObject().remove("price");
    cacheRemoveValue(CacheKey.price);
  }

  /** Clears the 'unitQty' field, the 'has' method for this field will now return false */
  public void clearUnitQty() {
    unlogChange("unitQty");
    getJSONObject().remove("unitQty");
    cacheRemoveValue(CacheKey.unitQty);
  }

  /** Clears the 'unitName' field, the 'has' method for this field will now return false */
  public void clearUnitName() {
    unlogChange("unitName");
    getJSONObject().remove("unitName");
    cacheRemoveValue(CacheKey.unitName);
  }

  /** Clears the 'itemCode' field, the 'has' method for this field will now return false */
  public void clearItemCode() {
    unlogChange("itemCode");
    getJSONObject().remove("itemCode");
    cacheRemoveValue(CacheKey.itemCode);
  }

  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    unlogChange("note");
    getJSONObject().remove("note");
    cacheRemoveValue(CacheKey.note);
  }

  /** Clears the 'printed' field, the 'has' method for this field will now return false */
  public void clearPrinted() {
    unlogChange("printed");
    getJSONObject().remove("printed");
    cacheRemoveValue(CacheKey.printed);
  }

  /** Clears the 'exchangedLineItem' field, the 'has' method for this field will now return false */
  public void clearExchangedLineItem() {
    unlogChange("exchangedLineItem");
    getJSONObject().remove("exchangedLineItem");
    cacheRemoveValue(CacheKey.exchangedLineItem);
  }

  /** Clears the 'binName' field, the 'has' method for this field will now return false */
  public void clearBinName() {
    unlogChange("binName");
    getJSONObject().remove("binName");
    cacheRemoveValue(CacheKey.binName);
  }

  /** Clears the 'userData' field, the 'has' method for this field will now return false */
  public void clearUserData() {
    unlogChange("userData");
    getJSONObject().remove("userData");
    cacheRemoveValue(CacheKey.userData);
  }

  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    unlogChange("createdTime");
    getJSONObject().remove("createdTime");
    cacheRemoveValue(CacheKey.createdTime);
  }

  /** Clears the 'discounts' field, the 'has' method for this field will now return false */
  public void clearDiscounts() {
    unlogChange("discounts");
    getJSONObject().remove("discounts");
    cacheRemoveValue(CacheKey.discounts);
  }

  /** Clears the 'discountAmount' field, the 'has' method for this field will now return false */
  public void clearDiscountAmount() {
    unlogChange("discountAmount");
    getJSONObject().remove("discountAmount");
    cacheRemoveValue(CacheKey.discountAmount);
  }

  /** Clears the 'exchanged' field, the 'has' method for this field will now return false */
  public void clearExchanged() {
    unlogChange("exchanged");
    getJSONObject().remove("exchanged");
    cacheRemoveValue(CacheKey.exchanged);
  }

  /** Clears the 'modifications' field, the 'has' method for this field will now return false */
  public void clearModifications() {
    unlogChange("modifications");
    getJSONObject().remove("modifications");
    cacheRemoveValue(CacheKey.modifications);
  }

  /** Clears the 'refunded' field, the 'has' method for this field will now return false */
  public void clearRefunded() {
    unlogChange("refunded");
    getJSONObject().remove("refunded");
    cacheRemoveValue(CacheKey.refunded);
  }

  /** Clears the 'isRevenue' field, the 'has' method for this field will now return false */
  public void clearIsRevenue() {
    unlogChange("isRevenue");
    getJSONObject().remove("isRevenue");
    cacheRemoveValue(CacheKey.isRevenue);
  }

  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    unlogChange("taxRates");
    getJSONObject().remove("taxRates");
    cacheRemoveValue(CacheKey.taxRates);
  }

  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    unlogChange("payments");
    getJSONObject().remove("payments");
    cacheRemoveValue(CacheKey.payments);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public LineItem copyChanges() {
    LineItem copy = new LineItem();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(LineItem src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new LineItem(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "LineItem{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<LineItem> CREATOR = new android.os.Parcelable.Creator<LineItem>() {
    @Override
    public LineItem createFromParcel(android.os.Parcel in) {
      LineItem instance = new LineItem(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public LineItem[] newArray(int size) {
      return new LineItem[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<LineItem> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<LineItem>() {
    @Override
    public LineItem create(org.json.JSONObject jsonObject) {
      return new LineItem(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean ITEM_IS_REQUIRED = false;

    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;

    public static final boolean ALTERNATENAME_IS_REQUIRED = false;
    public static final long ALTERNATENAME_MAX_LEN = 127;

    public static final boolean PRICE_IS_REQUIRED = false;

    public static final boolean UNITQTY_IS_REQUIRED = false;

    public static final boolean UNITNAME_IS_REQUIRED = false;
    public static final long UNITNAME_MAX_LEN = 64;

    public static final boolean ITEMCODE_IS_REQUIRED = false;
    public static final long ITEMCODE_MAX_LEN = 100;

    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;

    public static final boolean PRINTED_IS_REQUIRED = false;

    public static final boolean EXCHANGEDLINEITEM_IS_REQUIRED = false;

    public static final boolean BINNAME_IS_REQUIRED = false;
    public static final long BINNAME_MAX_LEN = 127;

    public static final boolean USERDATA_IS_REQUIRED = false;
    public static final long USERDATA_MAX_LEN = 255;

    public static final boolean CREATEDTIME_IS_REQUIRED = false;

    public static final boolean DISCOUNTS_IS_REQUIRED = false;

    public static final boolean DISCOUNTAMOUNT_IS_REQUIRED = false;

    public static final boolean EXCHANGED_IS_REQUIRED = false;

    public static final boolean MODIFICATIONS_IS_REQUIRED = false;

    public static final boolean REFUNDED_IS_REQUIRED = false;

    public static final boolean ISREVENUE_IS_REQUIRED = false;

    public static final boolean TAXRATES_IS_REQUIRED = false;

    public static final boolean PAYMENTS_IS_REQUIRED = false;

  }

}
