package com.clover.sdk.v3.order;

import android.os.Parcel;
import android.os.Parcelable;
import com.clover.sdk.internal.util.calc.Decimal;

import java.math.RoundingMode;

public class LineItemPercent implements Parcelable {
  private static final int SCALE = 7;
  private static final Decimal BIG_WHOLE = new Decimal(10000000L);
  private static final Decimal BIG_ONE_HUNDRED = new Decimal(100);

  public static final LineItemPercent ONE_HUNDRED = new LineItemPercent(1);

  final Decimal percent;

  public LineItemPercent(int split) {
    this(1, split);
  }

  public LineItemPercent(long divisor, long dividend) {
    percent = new Decimal(divisor).divide(new Decimal(dividend), SCALE, RoundingMode.HALF_UP);
  }

  public LineItemPercent(long longValue) {
    percent = new Decimal(longValue).divide(BIG_WHOLE, SCALE, RoundingMode.HALF_UP);
  }

  public long longValue() {
    return percent.multiply(BIG_WHOLE).setScale(0, RoundingMode.HALF_UP).longValue();
  }

  public Decimal getValue() {
    return percent;
  }

  public boolean isFractional() {
    return percent.compareTo(Decimal.ONE) < 0;
  }

  public String toDisplayString() {
    return percent.multiply(BIG_ONE_HUNDRED).setScale(0, RoundingMode.HALF_UP).longValue() + "%";
  }

  @Override
  public String toString() {
    return percent.multiply(BIG_ONE_HUNDRED).setScale(SCALE - 2, RoundingMode.HALF_UP).toString();
  }

  public long multiply(long value) {
    Decimal v = new Decimal(value);
    v = v.multiply(percent);
    return v.setScale(0, RoundingMode.HALF_UP).longValue();
  }

  public int describeContents() {
    return 0;
  }

  public void writeToParcel(Parcel out, int flags) {
    out.writeParcelable(percent, 0);
  }

  public static final Parcelable.Creator<LineItemPercent> CREATOR
      = new Parcelable.Creator<LineItemPercent>() {
    public LineItemPercent createFromParcel(Parcel in) {
      return new LineItemPercent(in);
    }

    public LineItemPercent[] newArray(int size) {
      return new LineItemPercent[size];
    }
  };

  private LineItemPercent(Parcel in) {
    percent = in.readParcelable(getClass().getClassLoader());
  }

}
