/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

@SuppressWarnings("all")
public final class Order implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractId();
      }
    },
    currency {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractCurrency();
      }
    },
    customers {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractCustomers();
      }
    },
    employee {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractEmployee();
      }
    },
    total {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractTotal();
      }
    },
    title {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractTitle();
      }
    },
    note {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractNote();
      }
    },
    orderType {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractOrderType();
      }
    },
    taxRemoved {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractTaxRemoved();
      }
    },
    isVat {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractIsVat();
      }
    },
    state {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractState();
      }
    },
    manualTransaction {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractManualTransaction();
      }
    },
    groupLineItems {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractGroupLineItems();
      }
    },
    testMode {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractTestMode();
      }
    },
    payType {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractPayType();
      }
    },
    createdTime {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractCreatedTime();
      }
    },
    clientCreatedTime {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractClientCreatedTime();
      }
    },
    serviceCharge {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractServiceCharge();
      }
    },
    discounts {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractDiscounts();
      }
    },
    lineItems {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractLineItems();
      }
    },
    payments {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractPayments();
      }
    },
    refunds {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractRefunds();
      }
    },
    credits {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractCredits();
      }
    },
    device {
      @Override
      public Object extractValue(Order instance) {
        return instance.extractDevice();
      }
    },
    ;

    public abstract Object extractValue(Order instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Order() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Order(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Order(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Order(Order src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String currency = getCurrency();
    if (currency != null && currency.length() > 3) throw new IllegalArgumentException("Maximum string length exceeded for 'currency'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * Currency of this order
   */
  public java.lang.String getCurrency() {
    return cacheGet(CacheKey.currency);
  }

  private java.lang.String extractCurrency() {
    return getJSONObject().isNull("currency") ? null :
      getJSONObject().optString("currency");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.customers.Customer> getCustomers() {
    return cacheGet(CacheKey.customers);
  }

  private java.util.List<com.clover.sdk.v3.customers.Customer> extractCustomers() {
    if (getJSONObject().isNull("customers")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("customers");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.customers.Customer> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.customers.Customer>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.customers.Customer item = new com.clover.sdk.v3.customers.Customer(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * The employee who took this order
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return cacheGet(CacheKey.employee);
  }

  private com.clover.sdk.v3.base.Reference extractEmployee() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("employee");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("employee"));
    }
    return null;
  }

  /**
   * Total price of the order
   */
  public java.lang.Long getTotal() {
    return cacheGet(CacheKey.total);
  }

  private java.lang.Long extractTotal() {
    return getJSONObject().isNull("total") ? null :
      getJSONObject().optLong("total");
  }

  /**
   */
  public java.lang.String getTitle() {
    return cacheGet(CacheKey.title);
  }

  private java.lang.String extractTitle() {
    return getJSONObject().isNull("title") ? null :
      getJSONObject().optString("title");
  }

  /**
   */
  public java.lang.String getNote() {
    return cacheGet(CacheKey.note);
  }

  private java.lang.String extractNote() {
    return getJSONObject().isNull("note") ? null :
      getJSONObject().optString("note");
  }

  /**
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.order.OrderType getOrderType() {
    return cacheGet(CacheKey.orderType);
  }

  private com.clover.sdk.v3.order.OrderType extractOrderType() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("orderType");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.order.OrderType(getJSONObject().optJSONObject("orderType"));
    }
    return null;
  }

  /**
   */
  public java.lang.Boolean getTaxRemoved() {
    return cacheGet(CacheKey.taxRemoved);
  }

  private java.lang.Boolean extractTaxRemoved() {
    return getJSONObject().isNull("taxRemoved") ? null :
      getJSONObject().optBoolean("taxRemoved");
  }

  /**
   */
  public java.lang.Boolean getIsVat() {
    return cacheGet(CacheKey.isVat);
  }

  private java.lang.Boolean extractIsVat() {
    return getJSONObject().isNull("isVat") ? null :
      getJSONObject().optBoolean("isVat");
  }

  /**
   */
  public java.lang.String getState() {
    return cacheGet(CacheKey.state);
  }

  private java.lang.String extractState() {
    return getJSONObject().isNull("state") ? null :
      getJSONObject().optString("state");
  }

  /**
   */
  public java.lang.Boolean getManualTransaction() {
    return cacheGet(CacheKey.manualTransaction);
  }

  private java.lang.Boolean extractManualTransaction() {
    return getJSONObject().isNull("manualTransaction") ? null :
      getJSONObject().optBoolean("manualTransaction");
  }

  /**
   */
  public java.lang.Boolean getGroupLineItems() {
    return cacheGet(CacheKey.groupLineItems);
  }

  private java.lang.Boolean extractGroupLineItems() {
    return getJSONObject().isNull("groupLineItems") ? null :
      getJSONObject().optBoolean("groupLineItems");
  }

  /**
   */
  public java.lang.Boolean getTestMode() {
    return cacheGet(CacheKey.testMode);
  }

  private java.lang.Boolean extractTestMode() {
    return getJSONObject().isNull("testMode") ? null :
      getJSONObject().optBoolean("testMode");
  }

  /**
   */
  public com.clover.sdk.v3.order.PayType getPayType() {
    return cacheGet(CacheKey.payType);
  }

  private com.clover.sdk.v3.order.PayType extractPayType() {
    if (!getJSONObject().isNull("payType")) {
      try {
        return com.clover.sdk.v3.order.PayType.valueOf(getJSONObject().optString("payType"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }

  /**
   * Creation timestamp
   */
  public java.lang.Long getCreatedTime() {
    return cacheGet(CacheKey.createdTime);
  }

  private java.lang.Long extractCreatedTime() {
    return getJSONObject().isNull("createdTime") ? null :
      getJSONObject().optLong("createdTime");
  }

  /**
   */
  public java.lang.Long getClientCreatedTime() {
    return cacheGet(CacheKey.clientCreatedTime);
  }

  private java.lang.Long extractClientCreatedTime() {
    return getJSONObject().isNull("clientCreatedTime") ? null :
      getJSONObject().optLong("clientCreatedTime");
  }

  /**
   * Optional service charge (gratuity) applied to this order
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.ServiceCharge getServiceCharge() {
    return cacheGet(CacheKey.serviceCharge);
  }

  private com.clover.sdk.v3.base.ServiceCharge extractServiceCharge() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("serviceCharge");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.ServiceCharge(getJSONObject().optJSONObject("serviceCharge"));
    }
    return null;
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.order.Discount> getDiscounts() {
    return cacheGet(CacheKey.discounts);
  }

  private java.util.List<com.clover.sdk.v3.order.Discount> extractDiscounts() {
    if (getJSONObject().isNull("discounts")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("discounts");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.order.Discount> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.order.Discount>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.order.Discount item = new com.clover.sdk.v3.order.Discount(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.order.LineItem> getLineItems() {
    return cacheGet(CacheKey.lineItems);
  }

  private java.util.List<com.clover.sdk.v3.order.LineItem> extractLineItems() {
    if (getJSONObject().isNull("lineItems")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("lineItems");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.order.LineItem> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.order.LineItem>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.order.LineItem item = new com.clover.sdk.v3.order.LineItem(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * Payments that were made for this order
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.Payment> getPayments() {
    return cacheGet(CacheKey.payments);
  }

  private java.util.List<com.clover.sdk.v3.payments.Payment> extractPayments() {
    if (getJSONObject().isNull("payments")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("payments");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.Payment> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.Payment>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.Payment item = new com.clover.sdk.v3.payments.Payment(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   * Refunds that were made for this order
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.Refund> getRefunds() {
    return cacheGet(CacheKey.refunds);
  }

  private java.util.List<com.clover.sdk.v3.payments.Refund> extractRefunds() {
    if (getJSONObject().isNull("refunds")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("refunds");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.Refund> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.Refund>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.Refund item = new com.clover.sdk.v3.payments.Refund(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.Credit> getCredits() {
    return cacheGet(CacheKey.credits);
  }

  private java.util.List<com.clover.sdk.v3.payments.Credit> extractCredits() {
    if (getJSONObject().isNull("credits")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("credits");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.Credit> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.Credit>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.Credit item = new com.clover.sdk.v3.payments.Credit(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.device.Device getDevice() {
    return cacheGet(CacheKey.device);
  }

  private com.clover.sdk.v3.device.Device extractDevice() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("device");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.device.Device(getJSONObject().optJSONObject("device"));
    }
    return null;
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'currency' field is set and is not null */
  public boolean isNotNullCurrency() {
    return cacheValueIsNotNull(CacheKey.currency);
  }

  /** Checks whether the 'customers' field is set and is not null */
  public boolean isNotNullCustomers() {
    return cacheValueIsNotNull(CacheKey.customers);
  }

  /** Checks whether the 'customers' field is set and is not null and is not empty */
  public boolean isNotEmptyCustomers() {
    return isNotNullCustomers() && !getCustomers().isEmpty();
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'total' field is set and is not null */
  public boolean isNotNullTotal() {
    return cacheValueIsNotNull(CacheKey.total);
  }

  /** Checks whether the 'title' field is set and is not null */
  public boolean isNotNullTitle() {
    return cacheValueIsNotNull(CacheKey.title);
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'orderType' field is set and is not null */
  public boolean isNotNullOrderType() {
    return cacheValueIsNotNull(CacheKey.orderType);
  }

  /** Checks whether the 'taxRemoved' field is set and is not null */
  public boolean isNotNullTaxRemoved() {
    return cacheValueIsNotNull(CacheKey.taxRemoved);
  }

  /** Checks whether the 'isVat' field is set and is not null */
  public boolean isNotNullIsVat() {
    return cacheValueIsNotNull(CacheKey.isVat);
  }

  /** Checks whether the 'state' field is set and is not null */
  public boolean isNotNullState() {
    return cacheValueIsNotNull(CacheKey.state);
  }

  /** Checks whether the 'manualTransaction' field is set and is not null */
  public boolean isNotNullManualTransaction() {
    return cacheValueIsNotNull(CacheKey.manualTransaction);
  }

  /** Checks whether the 'groupLineItems' field is set and is not null */
  public boolean isNotNullGroupLineItems() {
    return cacheValueIsNotNull(CacheKey.groupLineItems);
  }

  /** Checks whether the 'testMode' field is set and is not null */
  public boolean isNotNullTestMode() {
    return cacheValueIsNotNull(CacheKey.testMode);
  }

  /** Checks whether the 'payType' field is set and is not null */
  public boolean isNotNullPayType() {
    return cacheValueIsNotNull(CacheKey.payType);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'serviceCharge' field is set and is not null */
  public boolean isNotNullServiceCharge() {
    return cacheValueIsNotNull(CacheKey.serviceCharge);
  }

  /** Checks whether the 'discounts' field is set and is not null */
  public boolean isNotNullDiscounts() {
    return cacheValueIsNotNull(CacheKey.discounts);
  }

  /** Checks whether the 'discounts' field is set and is not null and is not empty */
  public boolean isNotEmptyDiscounts() {
    return isNotNullDiscounts() && !getDiscounts().isEmpty();
  }

  /** Checks whether the 'lineItems' field is set and is not null */
  public boolean isNotNullLineItems() {
    return cacheValueIsNotNull(CacheKey.lineItems);
  }

  /** Checks whether the 'lineItems' field is set and is not null and is not empty */
  public boolean isNotEmptyLineItems() {
    return isNotNullLineItems() && !getLineItems().isEmpty();
  }

  /** Checks whether the 'payments' field is set and is not null */
  public boolean isNotNullPayments() {
    return cacheValueIsNotNull(CacheKey.payments);
  }

  /** Checks whether the 'payments' field is set and is not null and is not empty */
  public boolean isNotEmptyPayments() {
    return isNotNullPayments() && !getPayments().isEmpty();
  }

  /** Checks whether the 'refunds' field is set and is not null */
  public boolean isNotNullRefunds() {
    return cacheValueIsNotNull(CacheKey.refunds);
  }

  /** Checks whether the 'refunds' field is set and is not null and is not empty */
  public boolean isNotEmptyRefunds() {
    return isNotNullRefunds() && !getRefunds().isEmpty();
  }

  /** Checks whether the 'credits' field is set and is not null */
  public boolean isNotNullCredits() {
    return cacheValueIsNotNull(CacheKey.credits);
  }

  /** Checks whether the 'credits' field is set and is not null and is not empty */
  public boolean isNotEmptyCredits() {
    return isNotNullCredits() && !getCredits().isEmpty();
  }

  /** Checks whether the 'device' field is set and is not null */
  public boolean isNotNullDevice() {
    return cacheValueIsNotNull(CacheKey.device);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'currency' field has been set, however the value could be null */
  public boolean hasCurrency() {
    return cacheHasKey(CacheKey.currency);
  }

  /** Checks whether the 'customers' field has been set, however the value could be null */
  public boolean hasCustomers() {
    return cacheHasKey(CacheKey.customers);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'total' field has been set, however the value could be null */
  public boolean hasTotal() {
    return cacheHasKey(CacheKey.total);
  }

  /** Checks whether the 'title' field has been set, however the value could be null */
  public boolean hasTitle() {
    return cacheHasKey(CacheKey.title);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'orderType' field has been set, however the value could be null */
  public boolean hasOrderType() {
    return cacheHasKey(CacheKey.orderType);
  }

  /** Checks whether the 'taxRemoved' field has been set, however the value could be null */
  public boolean hasTaxRemoved() {
    return cacheHasKey(CacheKey.taxRemoved);
  }

  /** Checks whether the 'isVat' field has been set, however the value could be null */
  public boolean hasIsVat() {
    return cacheHasKey(CacheKey.isVat);
  }

  /** Checks whether the 'state' field has been set, however the value could be null */
  public boolean hasState() {
    return cacheHasKey(CacheKey.state);
  }

  /** Checks whether the 'manualTransaction' field has been set, however the value could be null */
  public boolean hasManualTransaction() {
    return cacheHasKey(CacheKey.manualTransaction);
  }

  /** Checks whether the 'groupLineItems' field has been set, however the value could be null */
  public boolean hasGroupLineItems() {
    return cacheHasKey(CacheKey.groupLineItems);
  }

  /** Checks whether the 'testMode' field has been set, however the value could be null */
  public boolean hasTestMode() {
    return cacheHasKey(CacheKey.testMode);
  }

  /** Checks whether the 'payType' field has been set, however the value could be null */
  public boolean hasPayType() {
    return cacheHasKey(CacheKey.payType);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'serviceCharge' field has been set, however the value could be null */
  public boolean hasServiceCharge() {
    return cacheHasKey(CacheKey.serviceCharge);
  }

  /** Checks whether the 'discounts' field has been set, however the value could be null */
  public boolean hasDiscounts() {
    return cacheHasKey(CacheKey.discounts);
  }

  /** Checks whether the 'lineItems' field has been set, however the value could be null */
  public boolean hasLineItems() {
    return cacheHasKey(CacheKey.lineItems);
  }

  /** Checks whether the 'payments' field has been set, however the value could be null */
  public boolean hasPayments() {
    return cacheHasKey(CacheKey.payments);
  }

  /** Checks whether the 'refunds' field has been set, however the value could be null */
  public boolean hasRefunds() {
    return cacheHasKey(CacheKey.refunds);
  }

  /** Checks whether the 'credits' field has been set, however the value could be null */
  public boolean hasCredits() {
    return cacheHasKey(CacheKey.credits);
  }

  /** Checks whether the 'device' field has been set, however the value could be null */
  public boolean hasDevice() {
    return cacheHasKey(CacheKey.device);
  }


  /**
   * Sets the field 'id'.
   */
  public Order setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'currency'.
   */
  public Order setCurrency(java.lang.String currency) {
    logChange("currency");

    try {
      getJSONObject().put("currency", currency == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(currency));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.currency);
    return this;
  }

  /**
   * Sets the field 'customers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setCustomers(java.util.List<com.clover.sdk.v3.customers.Customer> customers) {
    logChange("customers");

    try {
      if (customers == null) {
        getJSONObject().put("customers", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.customers);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.customers.Customer obj : customers) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("customers", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.customers);
    return this;
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setEmployee(com.clover.sdk.v3.base.Reference employee) {
    logChange("employee");

    try {
      getJSONObject().put("employee",
          employee == null ? org.json.JSONObject.NULL : employee.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.employee);
    return this;
  }

  /**
   * Sets the field 'total'.
   */
  public Order setTotal(java.lang.Long total) {
    logChange("total");

    try {
      getJSONObject().put("total", total == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(total));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.total);
    return this;
  }

  /**
   * Sets the field 'title'.
   */
  public Order setTitle(java.lang.String title) {
    logChange("title");

    try {
      getJSONObject().put("title", title == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(title));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.title);
    return this;
  }

  /**
   * Sets the field 'note'.
   */
  public Order setNote(java.lang.String note) {
    logChange("note");

    try {
      getJSONObject().put("note", note == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(note));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.note);
    return this;
  }

  /**
   * Sets the field 'orderType'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setOrderType(com.clover.sdk.v3.order.OrderType orderType) {
    logChange("orderType");

    try {
      getJSONObject().put("orderType",
          orderType == null ? org.json.JSONObject.NULL : orderType.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.orderType);
    return this;
  }

  /**
   * Sets the field 'taxRemoved'.
   */
  public Order setTaxRemoved(java.lang.Boolean taxRemoved) {
    logChange("taxRemoved");

    try {
      getJSONObject().put("taxRemoved", taxRemoved == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(taxRemoved));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxRemoved);
    return this;
  }

  /**
   * Sets the field 'isVat'.
   */
  public Order setIsVat(java.lang.Boolean isVat) {
    logChange("isVat");

    try {
      getJSONObject().put("isVat", isVat == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(isVat));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.isVat);
    return this;
  }

  /**
   * Sets the field 'state'.
   */
  public Order setState(java.lang.String state) {
    logChange("state");

    try {
      getJSONObject().put("state", state == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(state));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.state);
    return this;
  }

  /**
   * Sets the field 'manualTransaction'.
   */
  public Order setManualTransaction(java.lang.Boolean manualTransaction) {
    logChange("manualTransaction");

    try {
      getJSONObject().put("manualTransaction", manualTransaction == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(manualTransaction));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.manualTransaction);
    return this;
  }

  /**
   * Sets the field 'groupLineItems'.
   */
  public Order setGroupLineItems(java.lang.Boolean groupLineItems) {
    logChange("groupLineItems");

    try {
      getJSONObject().put("groupLineItems", groupLineItems == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(groupLineItems));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.groupLineItems);
    return this;
  }

  /**
   * Sets the field 'testMode'.
   */
  public Order setTestMode(java.lang.Boolean testMode) {
    logChange("testMode");

    try {
      getJSONObject().put("testMode", testMode == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(testMode));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.testMode);
    return this;
  }

  /**
   * Sets the field 'payType'.
   */
  public Order setPayType(com.clover.sdk.v3.order.PayType payType) {
    logChange("payType");

    try {
      getJSONObject().put("payType", payType == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(payType));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.payType);
    return this;
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Order setCreatedTime(java.lang.Long createdTime) {
    logChange("createdTime");

    try {
      getJSONObject().put("createdTime", createdTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(createdTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.createdTime);
    return this;
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Order setClientCreatedTime(java.lang.Long clientCreatedTime) {
    logChange("clientCreatedTime");

    try {
      getJSONObject().put("clientCreatedTime", clientCreatedTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(clientCreatedTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.clientCreatedTime);
    return this;
  }

  /**
   * Sets the field 'serviceCharge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setServiceCharge(com.clover.sdk.v3.base.ServiceCharge serviceCharge) {
    logChange("serviceCharge");

    try {
      getJSONObject().put("serviceCharge",
          serviceCharge == null ? org.json.JSONObject.NULL : serviceCharge.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.serviceCharge);
    return this;
  }

  /**
   * Sets the field 'discounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setDiscounts(java.util.List<com.clover.sdk.v3.order.Discount> discounts) {
    logChange("discounts");

    try {
      if (discounts == null) {
        getJSONObject().put("discounts", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.discounts);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.order.Discount obj : discounts) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("discounts", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.discounts);
    return this;
  }

  /**
   * Sets the field 'lineItems'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setLineItems(java.util.List<com.clover.sdk.v3.order.LineItem> lineItems) {
    logChange("lineItems");

    try {
      if (lineItems == null) {
        getJSONObject().put("lineItems", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.lineItems);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.order.LineItem obj : lineItems) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("lineItems", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.lineItems);
    return this;
  }

  /**
   * Sets the field 'payments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setPayments(java.util.List<com.clover.sdk.v3.payments.Payment> payments) {
    logChange("payments");

    try {
      if (payments == null) {
        getJSONObject().put("payments", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.payments);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.Payment obj : payments) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("payments", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.payments);
    return this;
  }

  /**
   * Sets the field 'refunds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setRefunds(java.util.List<com.clover.sdk.v3.payments.Refund> refunds) {
    logChange("refunds");

    try {
      if (refunds == null) {
        getJSONObject().put("refunds", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.refunds);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.Refund obj : refunds) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("refunds", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.refunds);
    return this;
  }

  /**
   * Sets the field 'credits'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Order setCredits(java.util.List<com.clover.sdk.v3.payments.Credit> credits) {
    logChange("credits");

    try {
      if (credits == null) {
        getJSONObject().put("credits", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.credits);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.Credit obj : credits) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("credits", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.credits);
    return this;
  }

  /**
   * Sets the field 'device'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Order setDevice(com.clover.sdk.v3.device.Device device) {
    logChange("device");

    try {
      getJSONObject().put("device",
          device == null ? org.json.JSONObject.NULL : device.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.device);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'currency' field, the 'has' method for this field will now return false */
  public void clearCurrency() {
    unlogChange("currency");
    getJSONObject().remove("currency");
    cacheRemoveValue(CacheKey.currency);
  }

  /** Clears the 'customers' field, the 'has' method for this field will now return false */
  public void clearCustomers() {
    unlogChange("customers");
    getJSONObject().remove("customers");
    cacheRemoveValue(CacheKey.customers);
  }

  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    unlogChange("employee");
    getJSONObject().remove("employee");
    cacheRemoveValue(CacheKey.employee);
  }

  /** Clears the 'total' field, the 'has' method for this field will now return false */
  public void clearTotal() {
    unlogChange("total");
    getJSONObject().remove("total");
    cacheRemoveValue(CacheKey.total);
  }

  /** Clears the 'title' field, the 'has' method for this field will now return false */
  public void clearTitle() {
    unlogChange("title");
    getJSONObject().remove("title");
    cacheRemoveValue(CacheKey.title);
  }

  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    unlogChange("note");
    getJSONObject().remove("note");
    cacheRemoveValue(CacheKey.note);
  }

  /** Clears the 'orderType' field, the 'has' method for this field will now return false */
  public void clearOrderType() {
    unlogChange("orderType");
    getJSONObject().remove("orderType");
    cacheRemoveValue(CacheKey.orderType);
  }

  /** Clears the 'taxRemoved' field, the 'has' method for this field will now return false */
  public void clearTaxRemoved() {
    unlogChange("taxRemoved");
    getJSONObject().remove("taxRemoved");
    cacheRemoveValue(CacheKey.taxRemoved);
  }

  /** Clears the 'isVat' field, the 'has' method for this field will now return false */
  public void clearIsVat() {
    unlogChange("isVat");
    getJSONObject().remove("isVat");
    cacheRemoveValue(CacheKey.isVat);
  }

  /** Clears the 'state' field, the 'has' method for this field will now return false */
  public void clearState() {
    unlogChange("state");
    getJSONObject().remove("state");
    cacheRemoveValue(CacheKey.state);
  }

  /** Clears the 'manualTransaction' field, the 'has' method for this field will now return false */
  public void clearManualTransaction() {
    unlogChange("manualTransaction");
    getJSONObject().remove("manualTransaction");
    cacheRemoveValue(CacheKey.manualTransaction);
  }

  /** Clears the 'groupLineItems' field, the 'has' method for this field will now return false */
  public void clearGroupLineItems() {
    unlogChange("groupLineItems");
    getJSONObject().remove("groupLineItems");
    cacheRemoveValue(CacheKey.groupLineItems);
  }

  /** Clears the 'testMode' field, the 'has' method for this field will now return false */
  public void clearTestMode() {
    unlogChange("testMode");
    getJSONObject().remove("testMode");
    cacheRemoveValue(CacheKey.testMode);
  }

  /** Clears the 'payType' field, the 'has' method for this field will now return false */
  public void clearPayType() {
    unlogChange("payType");
    getJSONObject().remove("payType");
    cacheRemoveValue(CacheKey.payType);
  }

  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    unlogChange("createdTime");
    getJSONObject().remove("createdTime");
    cacheRemoveValue(CacheKey.createdTime);
  }

  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    unlogChange("clientCreatedTime");
    getJSONObject().remove("clientCreatedTime");
    cacheRemoveValue(CacheKey.clientCreatedTime);
  }

  /** Clears the 'serviceCharge' field, the 'has' method for this field will now return false */
  public void clearServiceCharge() {
    unlogChange("serviceCharge");
    getJSONObject().remove("serviceCharge");
    cacheRemoveValue(CacheKey.serviceCharge);
  }

  /** Clears the 'discounts' field, the 'has' method for this field will now return false */
  public void clearDiscounts() {
    unlogChange("discounts");
    getJSONObject().remove("discounts");
    cacheRemoveValue(CacheKey.discounts);
  }

  /** Clears the 'lineItems' field, the 'has' method for this field will now return false */
  public void clearLineItems() {
    unlogChange("lineItems");
    getJSONObject().remove("lineItems");
    cacheRemoveValue(CacheKey.lineItems);
  }

  /** Clears the 'payments' field, the 'has' method for this field will now return false */
  public void clearPayments() {
    unlogChange("payments");
    getJSONObject().remove("payments");
    cacheRemoveValue(CacheKey.payments);
  }

  /** Clears the 'refunds' field, the 'has' method for this field will now return false */
  public void clearRefunds() {
    unlogChange("refunds");
    getJSONObject().remove("refunds");
    cacheRemoveValue(CacheKey.refunds);
  }

  /** Clears the 'credits' field, the 'has' method for this field will now return false */
  public void clearCredits() {
    unlogChange("credits");
    getJSONObject().remove("credits");
    cacheRemoveValue(CacheKey.credits);
  }

  /** Clears the 'device' field, the 'has' method for this field will now return false */
  public void clearDevice() {
    unlogChange("device");
    getJSONObject().remove("device");
    cacheRemoveValue(CacheKey.device);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Order copyChanges() {
    Order copy = new Order();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Order src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Order(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Order{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Order> CREATOR = new android.os.Parcelable.Creator<Order>() {
    @Override
    public Order createFromParcel(android.os.Parcel in) {
      Order instance = new Order(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Order[] newArray(int size) {
      return new Order[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Order> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Order>() {
    @Override
    public Order create(org.json.JSONObject jsonObject) {
      return new Order(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean CURRENCY_IS_REQUIRED = false;
    public static final long CURRENCY_MAX_LEN = 3;

    public static final boolean CUSTOMERS_IS_REQUIRED = false;

    public static final boolean EMPLOYEE_IS_REQUIRED = false;

    public static final boolean TOTAL_IS_REQUIRED = false;

    public static final boolean TITLE_IS_REQUIRED = false;
    public static final long TITLE_MAX_LEN = 127;

    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 2047;

    public static final boolean ORDERTYPE_IS_REQUIRED = false;

    public static final boolean TAXREMOVED_IS_REQUIRED = false;

    public static final boolean ISVAT_IS_REQUIRED = false;

    public static final boolean STATE_IS_REQUIRED = false;
    public static final long STATE_MAX_LEN = 31;

    public static final boolean MANUALTRANSACTION_IS_REQUIRED = false;

    public static final boolean GROUPLINEITEMS_IS_REQUIRED = false;

    public static final boolean TESTMODE_IS_REQUIRED = false;

    public static final boolean PAYTYPE_IS_REQUIRED = false;

    public static final boolean CREATEDTIME_IS_REQUIRED = false;

    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;

    public static final boolean SERVICECHARGE_IS_REQUIRED = false;

    public static final boolean DISCOUNTS_IS_REQUIRED = false;

    public static final boolean LINEITEMS_IS_REQUIRED = false;

    public static final boolean PAYMENTS_IS_REQUIRED = false;

    public static final boolean REFUNDS_IS_REQUIRED = false;

    public static final boolean CREDITS_IS_REQUIRED = false;

    public static final boolean DEVICE_IS_REQUIRED = false;

  }

}
