/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.order;

@SuppressWarnings("all")
public final class OrderType implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(OrderType instance) {
        return instance.extractId();
      }
    },
    labelKey {
      @Override
      public Object extractValue(OrderType instance) {
        return instance.extractLabelKey();
      }
    },
    label {
      @Override
      public Object extractValue(OrderType instance) {
        return instance.extractLabel();
      }
    },
    taxable {
      @Override
      public Object extractValue(OrderType instance) {
        return instance.extractTaxable();
      }
    },
    isDefault {
      @Override
      public Object extractValue(OrderType instance) {
        return instance.extractIsDefault();
      }
    },
    isDeleted {
      @Override
      public Object extractValue(OrderType instance) {
        return instance.extractIsDeleted();
      }
    },
    ;

    public abstract Object extractValue(OrderType instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public OrderType() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public OrderType(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public OrderType(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public OrderType(OrderType src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String labelKey = getLabelKey();
    if (labelKey != null && labelKey.length() > 127) throw new IllegalArgumentException("Maximum string length exceeded for 'labelKey'");

    java.lang.String label = getLabel();
    if (label != null && label.length() > 127) throw new IllegalArgumentException("Maximum string length exceeded for 'label'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * Label Key
   */
  public java.lang.String getLabelKey() {
    return cacheGet(CacheKey.labelKey);
  }

  private java.lang.String extractLabelKey() {
    return getJSONObject().isNull("labelKey") ? null :
      getJSONObject().optString("labelKey");
  }

  /**
   * Label Key
   */
  public java.lang.String getLabel() {
    return cacheGet(CacheKey.label);
  }

  private java.lang.String extractLabel() {
    return getJSONObject().isNull("label") ? null :
      getJSONObject().optString("label");
  }

  /**
   * If this order type is taxable
   */
  public java.lang.Boolean getTaxable() {
    return cacheGet(CacheKey.taxable);
  }

  private java.lang.Boolean extractTaxable() {
    return getJSONObject().isNull("taxable") ? null :
      getJSONObject().optBoolean("taxable");
  }

  /**
   * If this order type is the default
   */
  public java.lang.Boolean getIsDefault() {
    return cacheGet(CacheKey.isDefault);
  }

  private java.lang.Boolean extractIsDefault() {
    return getJSONObject().isNull("isDefault") ? null :
      getJSONObject().optBoolean("isDefault");
  }

  /**
   * If this order type is deleted
   */
  public java.lang.Boolean getIsDeleted() {
    return cacheGet(CacheKey.isDeleted);
  }

  private java.lang.Boolean extractIsDeleted() {
    return getJSONObject().isNull("isDeleted") ? null :
      getJSONObject().optBoolean("isDeleted");
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'labelKey' field is set and is not null */
  public boolean isNotNullLabelKey() {
    return cacheValueIsNotNull(CacheKey.labelKey);
  }

  /** Checks whether the 'label' field is set and is not null */
  public boolean isNotNullLabel() {
    return cacheValueIsNotNull(CacheKey.label);
  }

  /** Checks whether the 'taxable' field is set and is not null */
  public boolean isNotNullTaxable() {
    return cacheValueIsNotNull(CacheKey.taxable);
  }

  /** Checks whether the 'isDefault' field is set and is not null */
  public boolean isNotNullIsDefault() {
    return cacheValueIsNotNull(CacheKey.isDefault);
  }

  /** Checks whether the 'isDeleted' field is set and is not null */
  public boolean isNotNullIsDeleted() {
    return cacheValueIsNotNull(CacheKey.isDeleted);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'labelKey' field has been set, however the value could be null */
  public boolean hasLabelKey() {
    return cacheHasKey(CacheKey.labelKey);
  }

  /** Checks whether the 'label' field has been set, however the value could be null */
  public boolean hasLabel() {
    return cacheHasKey(CacheKey.label);
  }

  /** Checks whether the 'taxable' field has been set, however the value could be null */
  public boolean hasTaxable() {
    return cacheHasKey(CacheKey.taxable);
  }

  /** Checks whether the 'isDefault' field has been set, however the value could be null */
  public boolean hasIsDefault() {
    return cacheHasKey(CacheKey.isDefault);
  }

  /** Checks whether the 'isDeleted' field has been set, however the value could be null */
  public boolean hasIsDeleted() {
    return cacheHasKey(CacheKey.isDeleted);
  }


  /**
   * Sets the field 'id'.
   */
  public OrderType setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'labelKey'.
   */
  public OrderType setLabelKey(java.lang.String labelKey) {
    logChange("labelKey");

    try {
      getJSONObject().put("labelKey", labelKey == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(labelKey));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.labelKey);
    return this;
  }

  /**
   * Sets the field 'label'.
   */
  public OrderType setLabel(java.lang.String label) {
    logChange("label");

    try {
      getJSONObject().put("label", label == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(label));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.label);
    return this;
  }

  /**
   * Sets the field 'taxable'.
   */
  public OrderType setTaxable(java.lang.Boolean taxable) {
    logChange("taxable");

    try {
      getJSONObject().put("taxable", taxable == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(taxable));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxable);
    return this;
  }

  /**
   * Sets the field 'isDefault'.
   */
  public OrderType setIsDefault(java.lang.Boolean isDefault) {
    logChange("isDefault");

    try {
      getJSONObject().put("isDefault", isDefault == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(isDefault));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.isDefault);
    return this;
  }

  /**
   * Sets the field 'isDeleted'.
   */
  public OrderType setIsDeleted(java.lang.Boolean isDeleted) {
    logChange("isDeleted");

    try {
      getJSONObject().put("isDeleted", isDeleted == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(isDeleted));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.isDeleted);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'labelKey' field, the 'has' method for this field will now return false */
  public void clearLabelKey() {
    unlogChange("labelKey");
    getJSONObject().remove("labelKey");
    cacheRemoveValue(CacheKey.labelKey);
  }

  /** Clears the 'label' field, the 'has' method for this field will now return false */
  public void clearLabel() {
    unlogChange("label");
    getJSONObject().remove("label");
    cacheRemoveValue(CacheKey.label);
  }

  /** Clears the 'taxable' field, the 'has' method for this field will now return false */
  public void clearTaxable() {
    unlogChange("taxable");
    getJSONObject().remove("taxable");
    cacheRemoveValue(CacheKey.taxable);
  }

  /** Clears the 'isDefault' field, the 'has' method for this field will now return false */
  public void clearIsDefault() {
    unlogChange("isDefault");
    getJSONObject().remove("isDefault");
    cacheRemoveValue(CacheKey.isDefault);
  }

  /** Clears the 'isDeleted' field, the 'has' method for this field will now return false */
  public void clearIsDeleted() {
    unlogChange("isDeleted");
    getJSONObject().remove("isDeleted");
    cacheRemoveValue(CacheKey.isDeleted);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public OrderType copyChanges() {
    OrderType copy = new OrderType();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(OrderType src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new OrderType(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "OrderType{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<OrderType> CREATOR = new android.os.Parcelable.Creator<OrderType>() {
    @Override
    public OrderType createFromParcel(android.os.Parcel in) {
      OrderType instance = new OrderType(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public OrderType[] newArray(int size) {
      return new OrderType[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<OrderType> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<OrderType>() {
    @Override
    public OrderType create(org.json.JSONObject jsonObject) {
      return new OrderType(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean LABELKEY_IS_REQUIRED = false;
    public static final long LABELKEY_MAX_LEN = 127;

    public static final boolean LABEL_IS_REQUIRED = false;
    public static final long LABEL_MAX_LEN = 127;

    public static final boolean TAXABLE_IS_REQUIRED = false;

    public static final boolean ISDEFAULT_IS_REQUIRED = false;

    public static final boolean ISDELETED_IS_REQUIRED = false;

  }

}
