/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

@SuppressWarnings("all")
public final class Credit implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractId();
      }
    },
    tender {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractTender();
      }
    },
    employee {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractEmployee();
      }
    },
    customers {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractCustomers();
      }
    },
    amount {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractAmount();
      }
    },
    taxAmount {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractTaxAmount();
      }
    },
    createdTime {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractCreatedTime();
      }
    },
    clientCreatedTime {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractClientCreatedTime();
      }
    },
    cardTransaction {
      @Override
      public Object extractValue(Credit instance) {
        return instance.extractCardTransaction();
      }
    },
    ;

    public abstract Object extractValue(Credit instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Credit() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Credit(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Credit(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Credit(Credit src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * The tender type associated with this payment, e.g. credit card, cash, etc.
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Tender getTender() {
    return cacheGet(CacheKey.tender);
  }

  private com.clover.sdk.v3.base.Tender extractTender() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("tender");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Tender(getJSONObject().optJSONObject("tender"));
    }
    return null;
  }

  /**
   * The employee who processed the payment
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return cacheGet(CacheKey.employee);
  }

  private com.clover.sdk.v3.base.Reference extractEmployee() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("employee");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("employee"));
    }
    return null;
  }

  /**
   * Customer who received the credit/refund
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.customers.Customer getCustomers() {
    return cacheGet(CacheKey.customers);
  }

  private com.clover.sdk.v3.customers.Customer extractCustomers() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("customers");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.customers.Customer(getJSONObject().optJSONObject("customers"));
    }
    return null;
  }

  /**
   * Amount paid in tax
   */
  public java.lang.Long getAmount() {
    return cacheGet(CacheKey.amount);
  }

  private java.lang.Long extractAmount() {
    return getJSONObject().isNull("amount") ? null :
      getJSONObject().optLong("amount");
  }

  /**
   * Amount paid in tax
   */
  public java.lang.Long getTaxAmount() {
    return cacheGet(CacheKey.taxAmount);
  }

  private java.lang.Long extractTaxAmount() {
    return getJSONObject().isNull("taxAmount") ? null :
      getJSONObject().optLong("taxAmount");
  }

  /**
   * Time payment was recorded on server
   */
  public java.lang.Long getCreatedTime() {
    return cacheGet(CacheKey.createdTime);
  }

  private java.lang.Long extractCreatedTime() {
    return getJSONObject().isNull("createdTime") ? null :
      getJSONObject().optLong("createdTime");
  }

  /**
   */
  public java.lang.Long getClientCreatedTime() {
    return cacheGet(CacheKey.clientCreatedTime);
  }

  private java.lang.Long extractClientCreatedTime() {
    return getJSONObject().isNull("clientCreatedTime") ? null :
      getJSONObject().optLong("clientCreatedTime");
  }

  /**
   * Information about the card used for credit/debit card payments
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.payments.CardTransaction getCardTransaction() {
    return cacheGet(CacheKey.cardTransaction);
  }

  private com.clover.sdk.v3.payments.CardTransaction extractCardTransaction() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("cardTransaction");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.payments.CardTransaction(getJSONObject().optJSONObject("cardTransaction"));
    }
    return null;
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'tender' field is set and is not null */
  public boolean isNotNullTender() {
    return cacheValueIsNotNull(CacheKey.tender);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'customers' field is set and is not null */
  public boolean isNotNullCustomers() {
    return cacheValueIsNotNull(CacheKey.customers);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'cardTransaction' field is set and is not null */
  public boolean isNotNullCardTransaction() {
    return cacheValueIsNotNull(CacheKey.cardTransaction);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'tender' field has been set, however the value could be null */
  public boolean hasTender() {
    return cacheHasKey(CacheKey.tender);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'customers' field has been set, however the value could be null */
  public boolean hasCustomers() {
    return cacheHasKey(CacheKey.customers);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'cardTransaction' field has been set, however the value could be null */
  public boolean hasCardTransaction() {
    return cacheHasKey(CacheKey.cardTransaction);
  }


  /**
   * Sets the field 'id'.
   */
  public Credit setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'tender'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Credit setTender(com.clover.sdk.v3.base.Tender tender) {
    logChange("tender");

    try {
      getJSONObject().put("tender",
          tender == null ? org.json.JSONObject.NULL : tender.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.tender);
    return this;
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Credit setEmployee(com.clover.sdk.v3.base.Reference employee) {
    logChange("employee");

    try {
      getJSONObject().put("employee",
          employee == null ? org.json.JSONObject.NULL : employee.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.employee);
    return this;
  }

  /**
   * Sets the field 'customers'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Credit setCustomers(com.clover.sdk.v3.customers.Customer customers) {
    logChange("customers");

    try {
      getJSONObject().put("customers",
          customers == null ? org.json.JSONObject.NULL : customers.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.customers);
    return this;
  }

  /**
   * Sets the field 'amount'.
   */
  public Credit setAmount(java.lang.Long amount) {
    logChange("amount");

    try {
      getJSONObject().put("amount", amount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(amount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.amount);
    return this;
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public Credit setTaxAmount(java.lang.Long taxAmount) {
    logChange("taxAmount");

    try {
      getJSONObject().put("taxAmount", taxAmount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(taxAmount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxAmount);
    return this;
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Credit setCreatedTime(java.lang.Long createdTime) {
    logChange("createdTime");

    try {
      getJSONObject().put("createdTime", createdTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(createdTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.createdTime);
    return this;
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Credit setClientCreatedTime(java.lang.Long clientCreatedTime) {
    logChange("clientCreatedTime");

    try {
      getJSONObject().put("clientCreatedTime", clientCreatedTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(clientCreatedTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.clientCreatedTime);
    return this;
  }

  /**
   * Sets the field 'cardTransaction'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Credit setCardTransaction(com.clover.sdk.v3.payments.CardTransaction cardTransaction) {
    logChange("cardTransaction");

    try {
      getJSONObject().put("cardTransaction",
          cardTransaction == null ? org.json.JSONObject.NULL : cardTransaction.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.cardTransaction);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'tender' field, the 'has' method for this field will now return false */
  public void clearTender() {
    unlogChange("tender");
    getJSONObject().remove("tender");
    cacheRemoveValue(CacheKey.tender);
  }

  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    unlogChange("employee");
    getJSONObject().remove("employee");
    cacheRemoveValue(CacheKey.employee);
  }

  /** Clears the 'customers' field, the 'has' method for this field will now return false */
  public void clearCustomers() {
    unlogChange("customers");
    getJSONObject().remove("customers");
    cacheRemoveValue(CacheKey.customers);
  }

  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    unlogChange("amount");
    getJSONObject().remove("amount");
    cacheRemoveValue(CacheKey.amount);
  }

  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    unlogChange("taxAmount");
    getJSONObject().remove("taxAmount");
    cacheRemoveValue(CacheKey.taxAmount);
  }

  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    unlogChange("createdTime");
    getJSONObject().remove("createdTime");
    cacheRemoveValue(CacheKey.createdTime);
  }

  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    unlogChange("clientCreatedTime");
    getJSONObject().remove("clientCreatedTime");
    cacheRemoveValue(CacheKey.clientCreatedTime);
  }

  /** Clears the 'cardTransaction' field, the 'has' method for this field will now return false */
  public void clearCardTransaction() {
    unlogChange("cardTransaction");
    getJSONObject().remove("cardTransaction");
    cacheRemoveValue(CacheKey.cardTransaction);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Credit copyChanges() {
    Credit copy = new Credit();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Credit src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Credit(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Credit{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Credit> CREATOR = new android.os.Parcelable.Creator<Credit>() {
    @Override
    public Credit createFromParcel(android.os.Parcel in) {
      Credit instance = new Credit(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Credit[] newArray(int size) {
      return new Credit[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Credit> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Credit>() {
    @Override
    public Credit create(org.json.JSONObject jsonObject) {
      return new Credit(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean TENDER_IS_REQUIRED = false;

    public static final boolean EMPLOYEE_IS_REQUIRED = false;

    public static final boolean CUSTOMERS_IS_REQUIRED = false;

    public static final boolean AMOUNT_IS_REQUIRED = false;

    public static final boolean TAXAMOUNT_IS_REQUIRED = false;

    public static final boolean CREATEDTIME_IS_REQUIRED = false;

    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;

    public static final boolean CARDTRANSACTION_IS_REQUIRED = false;

  }

}
