/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.payments;

@SuppressWarnings("all")
public final class Payment implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractId();
      }
    },
    order {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractOrder();
      }
    },
    tender {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractTender();
      }
    },
    amount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractAmount();
      }
    },
    tipAmount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractTipAmount();
      }
    },
    taxAmount {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractTaxAmount();
      }
    },
    cashTendered {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractCashTendered();
      }
    },
    externalPaymentId {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractExternalPaymentId();
      }
    },
    employee {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractEmployee();
      }
    },
    createdTime {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractCreatedTime();
      }
    },
    clientCreatedTime {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractClientCreatedTime();
      }
    },
    offline {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractOffline();
      }
    },
    result {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractResult();
      }
    },
    cardTransaction {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractCardTransaction();
      }
    },
    taxRates {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractTaxRates();
      }
    },
    refunds {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractRefunds();
      }
    },
    note {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractNote();
      }
    },
    lineItemPayments {
      @Override
      public Object extractValue(Payment instance) {
        return instance.extractLineItemPayments();
      }
    },
    ;

    public abstract Object extractValue(Payment instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Payment() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Payment(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Payment(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Payment(Payment src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String externalPaymentId = getExternalPaymentId();
    if (externalPaymentId != null && externalPaymentId.length() > 32) throw new IllegalArgumentException("Maximum string length exceeded for 'externalPaymentId'");

    java.lang.String note = getNote();
    if (note != null && note.length() > 255) throw new IllegalArgumentException("Maximum string length exceeded for 'note'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * The order with which the payment is associated
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getOrder() {
    return cacheGet(CacheKey.order);
  }

  private com.clover.sdk.v3.base.Reference extractOrder() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("order");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("order"));
    }
    return null;
  }

  /**
   * The tender type associated with this payment, e.g. credit card, cash, etc.
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Tender getTender() {
    return cacheGet(CacheKey.tender);
  }

  private com.clover.sdk.v3.base.Tender extractTender() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("tender");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Tender(getJSONObject().optJSONObject("tender"));
    }
    return null;
  }

  /**
   * Total amount paid
   */
  public java.lang.Long getAmount() {
    return cacheGet(CacheKey.amount);
  }

  private java.lang.Long extractAmount() {
    return getJSONObject().isNull("amount") ? null :
      getJSONObject().optLong("amount");
  }

  /**
   * Amount paid in tips
   */
  public java.lang.Long getTipAmount() {
    return cacheGet(CacheKey.tipAmount);
  }

  private java.lang.Long extractTipAmount() {
    return getJSONObject().isNull("tipAmount") ? null :
      getJSONObject().optLong("tipAmount");
  }

  /**
   * Amount paid in tax
   */
  public java.lang.Long getTaxAmount() {
    return cacheGet(CacheKey.taxAmount);
  }

  private java.lang.Long extractTaxAmount() {
    return getJSONObject().isNull("taxAmount") ? null :
      getJSONObject().optLong("taxAmount");
  }

  /**
   * Amount of cash given back to customer
   */
  public java.lang.Long getCashTendered() {
    return cacheGet(CacheKey.cashTendered);
  }

  private java.lang.Long extractCashTendered() {
    return getJSONObject().isNull("cashTendered") ? null :
      getJSONObject().optLong("cashTendered");
  }

  /**
   */
  public java.lang.String getExternalPaymentId() {
    return cacheGet(CacheKey.externalPaymentId);
  }

  private java.lang.String extractExternalPaymentId() {
    return getJSONObject().isNull("externalPaymentId") ? null :
      getJSONObject().optString("externalPaymentId");
  }

  /**
   * The employee who processed the payment
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.base.Reference getEmployee() {
    return cacheGet(CacheKey.employee);
  }

  private com.clover.sdk.v3.base.Reference extractEmployee() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("employee");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.base.Reference(getJSONObject().optJSONObject("employee"));
    }
    return null;
  }

  /**
   * Time payment was recorded on server
   */
  public java.lang.Long getCreatedTime() {
    return cacheGet(CacheKey.createdTime);
  }

  private java.lang.Long extractCreatedTime() {
    return getJSONObject().isNull("createdTime") ? null :
      getJSONObject().optLong("createdTime");
  }

  /**
   */
  public java.lang.Long getClientCreatedTime() {
    return cacheGet(CacheKey.clientCreatedTime);
  }

  private java.lang.Long extractClientCreatedTime() {
    return getJSONObject().isNull("clientCreatedTime") ? null :
      getJSONObject().optLong("clientCreatedTime");
  }

  /**
   */
  public java.lang.Boolean getOffline() {
    return cacheGet(CacheKey.offline);
  }

  private java.lang.Boolean extractOffline() {
    return getJSONObject().isNull("offline") ? null :
      getJSONObject().optBoolean("offline");
  }

  /**
   */
  public com.clover.sdk.v3.payments.Result getResult() {
    return cacheGet(CacheKey.result);
  }

  private com.clover.sdk.v3.payments.Result extractResult() {
    if (!getJSONObject().isNull("result")) {
      try {
        return com.clover.sdk.v3.payments.Result.valueOf(getJSONObject().optString("result"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }

  /**
   * Information about the card used for credit/debit card payments
   *
   * The returned object is not a copy so changes to it will be reflected in this instance and vice-versa.
   */
  public com.clover.sdk.v3.payments.CardTransaction getCardTransaction() {
    return cacheGet(CacheKey.cardTransaction);
  }

  private com.clover.sdk.v3.payments.CardTransaction extractCardTransaction() {
    org.json.JSONObject jsonObj = getJSONObject().optJSONObject("cardTransaction");
    if (jsonObj != null) {
      return new com.clover.sdk.v3.payments.CardTransaction(getJSONObject().optJSONObject("cardTransaction"));
    }
    return null;
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> getTaxRates() {
    return cacheGet(CacheKey.taxRates);
  }

  private java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> extractTaxRates() {
    if (getJSONObject().isNull("taxRates")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("taxRates");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.PaymentTaxRate>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.PaymentTaxRate item = new com.clover.sdk.v3.payments.PaymentTaxRate(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.Refund> getRefunds() {
    return cacheGet(CacheKey.refunds);
  }

  private java.util.List<com.clover.sdk.v3.payments.Refund> extractRefunds() {
    if (getJSONObject().isNull("refunds")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("refunds");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.Refund> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.Refund>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.Refund item = new com.clover.sdk.v3.payments.Refund(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }

  /**
   */
  public java.lang.String getNote() {
    return cacheGet(CacheKey.note);
  }

  private java.lang.String extractNote() {
    return getJSONObject().isNull("note") ? null :
      getJSONObject().optString("note");
  }

  /**
   *
   * The returned List is unmodifiable and will never contain any nulls, even if the source JSON had null entries.
   */
  public java.util.List<com.clover.sdk.v3.payments.LineItemPayment> getLineItemPayments() {
    return cacheGet(CacheKey.lineItemPayments);
  }

  private java.util.List<com.clover.sdk.v3.payments.LineItemPayment> extractLineItemPayments() {
    if (getJSONObject().isNull("lineItemPayments")) {
      return null;
    }

    org.json.JSONObject elementsContainer = getJSONObject().optJSONObject("lineItemPayments");
    org.json.JSONArray itemArray = elementsContainer.optJSONArray("elements");
    java.util.List<com.clover.sdk.v3.payments.LineItemPayment> itemList =
        new java.util.ArrayList<com.clover.sdk.v3.payments.LineItemPayment>(itemArray.length());
    for (int i = 0; i < itemArray.length(); i++) {
      org.json.JSONObject obj = itemArray.optJSONObject(i);
      if (obj == null) {
        continue;
      }
      com.clover.sdk.v3.payments.LineItemPayment item = new com.clover.sdk.v3.payments.LineItemPayment(obj);
      itemList.add(item);
    }

    return java.util.Collections.unmodifiableList(itemList);
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'order' field is set and is not null */
  public boolean isNotNullOrder() {
    return cacheValueIsNotNull(CacheKey.order);
  }

  /** Checks whether the 'tender' field is set and is not null */
  public boolean isNotNullTender() {
    return cacheValueIsNotNull(CacheKey.tender);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field is set and is not null */
  public boolean isNotNullTipAmount() {
    return cacheValueIsNotNull(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field is set and is not null */
  public boolean isNotNullTaxAmount() {
    return cacheValueIsNotNull(CacheKey.taxAmount);
  }

  /** Checks whether the 'cashTendered' field is set and is not null */
  public boolean isNotNullCashTendered() {
    return cacheValueIsNotNull(CacheKey.cashTendered);
  }

  /** Checks whether the 'externalPaymentId' field is set and is not null */
  public boolean isNotNullExternalPaymentId() {
    return cacheValueIsNotNull(CacheKey.externalPaymentId);
  }

  /** Checks whether the 'employee' field is set and is not null */
  public boolean isNotNullEmployee() {
    return cacheValueIsNotNull(CacheKey.employee);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field is set and is not null */
  public boolean isNotNullClientCreatedTime() {
    return cacheValueIsNotNull(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'offline' field is set and is not null */
  public boolean isNotNullOffline() {
    return cacheValueIsNotNull(CacheKey.offline);
  }

  /** Checks whether the 'result' field is set and is not null */
  public boolean isNotNullResult() {
    return cacheValueIsNotNull(CacheKey.result);
  }

  /** Checks whether the 'cardTransaction' field is set and is not null */
  public boolean isNotNullCardTransaction() {
    return cacheValueIsNotNull(CacheKey.cardTransaction);
  }

  /** Checks whether the 'taxRates' field is set and is not null */
  public boolean isNotNullTaxRates() {
    return cacheValueIsNotNull(CacheKey.taxRates);
  }

  /** Checks whether the 'taxRates' field is set and is not null and is not empty */
  public boolean isNotEmptyTaxRates() {
    return isNotNullTaxRates() && !getTaxRates().isEmpty();
  }

  /** Checks whether the 'refunds' field is set and is not null */
  public boolean isNotNullRefunds() {
    return cacheValueIsNotNull(CacheKey.refunds);
  }

  /** Checks whether the 'refunds' field is set and is not null and is not empty */
  public boolean isNotEmptyRefunds() {
    return isNotNullRefunds() && !getRefunds().isEmpty();
  }

  /** Checks whether the 'note' field is set and is not null */
  public boolean isNotNullNote() {
    return cacheValueIsNotNull(CacheKey.note);
  }

  /** Checks whether the 'lineItemPayments' field is set and is not null */
  public boolean isNotNullLineItemPayments() {
    return cacheValueIsNotNull(CacheKey.lineItemPayments);
  }

  /** Checks whether the 'lineItemPayments' field is set and is not null and is not empty */
  public boolean isNotEmptyLineItemPayments() {
    return isNotNullLineItemPayments() && !getLineItemPayments().isEmpty();
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'order' field has been set, however the value could be null */
  public boolean hasOrder() {
    return cacheHasKey(CacheKey.order);
  }

  /** Checks whether the 'tender' field has been set, however the value could be null */
  public boolean hasTender() {
    return cacheHasKey(CacheKey.tender);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'tipAmount' field has been set, however the value could be null */
  public boolean hasTipAmount() {
    return cacheHasKey(CacheKey.tipAmount);
  }

  /** Checks whether the 'taxAmount' field has been set, however the value could be null */
  public boolean hasTaxAmount() {
    return cacheHasKey(CacheKey.taxAmount);
  }

  /** Checks whether the 'cashTendered' field has been set, however the value could be null */
  public boolean hasCashTendered() {
    return cacheHasKey(CacheKey.cashTendered);
  }

  /** Checks whether the 'externalPaymentId' field has been set, however the value could be null */
  public boolean hasExternalPaymentId() {
    return cacheHasKey(CacheKey.externalPaymentId);
  }

  /** Checks whether the 'employee' field has been set, however the value could be null */
  public boolean hasEmployee() {
    return cacheHasKey(CacheKey.employee);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'clientCreatedTime' field has been set, however the value could be null */
  public boolean hasClientCreatedTime() {
    return cacheHasKey(CacheKey.clientCreatedTime);
  }

  /** Checks whether the 'offline' field has been set, however the value could be null */
  public boolean hasOffline() {
    return cacheHasKey(CacheKey.offline);
  }

  /** Checks whether the 'result' field has been set, however the value could be null */
  public boolean hasResult() {
    return cacheHasKey(CacheKey.result);
  }

  /** Checks whether the 'cardTransaction' field has been set, however the value could be null */
  public boolean hasCardTransaction() {
    return cacheHasKey(CacheKey.cardTransaction);
  }

  /** Checks whether the 'taxRates' field has been set, however the value could be null */
  public boolean hasTaxRates() {
    return cacheHasKey(CacheKey.taxRates);
  }

  /** Checks whether the 'refunds' field has been set, however the value could be null */
  public boolean hasRefunds() {
    return cacheHasKey(CacheKey.refunds);
  }

  /** Checks whether the 'note' field has been set, however the value could be null */
  public boolean hasNote() {
    return cacheHasKey(CacheKey.note);
  }

  /** Checks whether the 'lineItemPayments' field has been set, however the value could be null */
  public boolean hasLineItemPayments() {
    return cacheHasKey(CacheKey.lineItemPayments);
  }


  /**
   * Sets the field 'id'.
   */
  public Payment setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'order'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setOrder(com.clover.sdk.v3.base.Reference order) {
    logChange("order");

    try {
      getJSONObject().put("order",
          order == null ? org.json.JSONObject.NULL : order.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.order);
    return this;
  }

  /**
   * Sets the field 'tender'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setTender(com.clover.sdk.v3.base.Tender tender) {
    logChange("tender");

    try {
      getJSONObject().put("tender",
          tender == null ? org.json.JSONObject.NULL : tender.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.tender);
    return this;
  }

  /**
   * Sets the field 'amount'.
   */
  public Payment setAmount(java.lang.Long amount) {
    logChange("amount");

    try {
      getJSONObject().put("amount", amount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(amount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.amount);
    return this;
  }

  /**
   * Sets the field 'tipAmount'.
   */
  public Payment setTipAmount(java.lang.Long tipAmount) {
    logChange("tipAmount");

    try {
      getJSONObject().put("tipAmount", tipAmount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(tipAmount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.tipAmount);
    return this;
  }

  /**
   * Sets the field 'taxAmount'.
   */
  public Payment setTaxAmount(java.lang.Long taxAmount) {
    logChange("taxAmount");

    try {
      getJSONObject().put("taxAmount", taxAmount == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(taxAmount));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxAmount);
    return this;
  }

  /**
   * Sets the field 'cashTendered'.
   */
  public Payment setCashTendered(java.lang.Long cashTendered) {
    logChange("cashTendered");

    try {
      getJSONObject().put("cashTendered", cashTendered == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(cashTendered));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.cashTendered);
    return this;
  }

  /**
   * Sets the field 'externalPaymentId'.
   */
  public Payment setExternalPaymentId(java.lang.String externalPaymentId) {
    logChange("externalPaymentId");

    try {
      getJSONObject().put("externalPaymentId", externalPaymentId == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(externalPaymentId));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.externalPaymentId);
    return this;
  }

  /**
   * Sets the field 'employee'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setEmployee(com.clover.sdk.v3.base.Reference employee) {
    logChange("employee");

    try {
      getJSONObject().put("employee",
          employee == null ? org.json.JSONObject.NULL : employee.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.employee);
    return this;
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Payment setCreatedTime(java.lang.Long createdTime) {
    logChange("createdTime");

    try {
      getJSONObject().put("createdTime", createdTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(createdTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.createdTime);
    return this;
  }

  /**
   * Sets the field 'clientCreatedTime'.
   */
  public Payment setClientCreatedTime(java.lang.Long clientCreatedTime) {
    logChange("clientCreatedTime");

    try {
      getJSONObject().put("clientCreatedTime", clientCreatedTime == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(clientCreatedTime));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.clientCreatedTime);
    return this;
  }

  /**
   * Sets the field 'offline'.
   */
  public Payment setOffline(java.lang.Boolean offline) {
    logChange("offline");

    try {
      getJSONObject().put("offline", offline == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(offline));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.offline);
    return this;
  }

  /**
   * Sets the field 'result'.
   */
  public Payment setResult(com.clover.sdk.v3.payments.Result result) {
    logChange("result");

    try {
      getJSONObject().put("result", result == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(result));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.result);
    return this;
  }

  /**
   * Sets the field 'cardTransaction'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Payment setCardTransaction(com.clover.sdk.v3.payments.CardTransaction cardTransaction) {
    logChange("cardTransaction");

    try {
      getJSONObject().put("cardTransaction",
          cardTransaction == null ? org.json.JSONObject.NULL : cardTransaction.getJSONObject());
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.cardTransaction);
    return this;
  }

  /**
   * Sets the field 'taxRates'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setTaxRates(java.util.List<com.clover.sdk.v3.payments.PaymentTaxRate> taxRates) {
    logChange("taxRates");

    try {
      if (taxRates == null) {
        getJSONObject().put("taxRates", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.taxRates);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.PaymentTaxRate obj : taxRates) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("taxRates", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.taxRates);
    return this;
  }

  /**
   * Sets the field 'refunds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setRefunds(java.util.List<com.clover.sdk.v3.payments.Refund> refunds) {
    logChange("refunds");

    try {
      if (refunds == null) {
        getJSONObject().put("refunds", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.refunds);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.Refund obj : refunds) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("refunds", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.refunds);
    return this;
  }

  /**
   * Sets the field 'note'.
   */
  public Payment setNote(java.lang.String note) {
    logChange("note");

    try {
      getJSONObject().put("note", note == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(note));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.note);
    return this;
  }

  /**
   * Sets the field 'lineItemPayments'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Payment setLineItemPayments(java.util.List<com.clover.sdk.v3.payments.LineItemPayment> lineItemPayments) {
    logChange("lineItemPayments");

    try {
      if (lineItemPayments == null) {
        getJSONObject().put("lineItemPayments", org.json.JSONObject.NULL);
        cacheMarkDirty(CacheKey.lineItemPayments);
        return this;
      }

      org.json.JSONArray array = new org.json.JSONArray();
      for (com.clover.sdk.v3.payments.LineItemPayment obj : lineItemPayments) {
        if (obj == null) {
          continue;
        }
        array.put(obj.getJSONObject());
      }

      org.json.JSONObject elementsContainer = new org.json.JSONObject();
      elementsContainer.put("elements", array);
      getJSONObject().put("lineItemPayments", elementsContainer);
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.lineItemPayments);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'order' field, the 'has' method for this field will now return false */
  public void clearOrder() {
    unlogChange("order");
    getJSONObject().remove("order");
    cacheRemoveValue(CacheKey.order);
  }

  /** Clears the 'tender' field, the 'has' method for this field will now return false */
  public void clearTender() {
    unlogChange("tender");
    getJSONObject().remove("tender");
    cacheRemoveValue(CacheKey.tender);
  }

  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    unlogChange("amount");
    getJSONObject().remove("amount");
    cacheRemoveValue(CacheKey.amount);
  }

  /** Clears the 'tipAmount' field, the 'has' method for this field will now return false */
  public void clearTipAmount() {
    unlogChange("tipAmount");
    getJSONObject().remove("tipAmount");
    cacheRemoveValue(CacheKey.tipAmount);
  }

  /** Clears the 'taxAmount' field, the 'has' method for this field will now return false */
  public void clearTaxAmount() {
    unlogChange("taxAmount");
    getJSONObject().remove("taxAmount");
    cacheRemoveValue(CacheKey.taxAmount);
  }

  /** Clears the 'cashTendered' field, the 'has' method for this field will now return false */
  public void clearCashTendered() {
    unlogChange("cashTendered");
    getJSONObject().remove("cashTendered");
    cacheRemoveValue(CacheKey.cashTendered);
  }

  /** Clears the 'externalPaymentId' field, the 'has' method for this field will now return false */
  public void clearExternalPaymentId() {
    unlogChange("externalPaymentId");
    getJSONObject().remove("externalPaymentId");
    cacheRemoveValue(CacheKey.externalPaymentId);
  }

  /** Clears the 'employee' field, the 'has' method for this field will now return false */
  public void clearEmployee() {
    unlogChange("employee");
    getJSONObject().remove("employee");
    cacheRemoveValue(CacheKey.employee);
  }

  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    unlogChange("createdTime");
    getJSONObject().remove("createdTime");
    cacheRemoveValue(CacheKey.createdTime);
  }

  /** Clears the 'clientCreatedTime' field, the 'has' method for this field will now return false */
  public void clearClientCreatedTime() {
    unlogChange("clientCreatedTime");
    getJSONObject().remove("clientCreatedTime");
    cacheRemoveValue(CacheKey.clientCreatedTime);
  }

  /** Clears the 'offline' field, the 'has' method for this field will now return false */
  public void clearOffline() {
    unlogChange("offline");
    getJSONObject().remove("offline");
    cacheRemoveValue(CacheKey.offline);
  }

  /** Clears the 'result' field, the 'has' method for this field will now return false */
  public void clearResult() {
    unlogChange("result");
    getJSONObject().remove("result");
    cacheRemoveValue(CacheKey.result);
  }

  /** Clears the 'cardTransaction' field, the 'has' method for this field will now return false */
  public void clearCardTransaction() {
    unlogChange("cardTransaction");
    getJSONObject().remove("cardTransaction");
    cacheRemoveValue(CacheKey.cardTransaction);
  }

  /** Clears the 'taxRates' field, the 'has' method for this field will now return false */
  public void clearTaxRates() {
    unlogChange("taxRates");
    getJSONObject().remove("taxRates");
    cacheRemoveValue(CacheKey.taxRates);
  }

  /** Clears the 'refunds' field, the 'has' method for this field will now return false */
  public void clearRefunds() {
    unlogChange("refunds");
    getJSONObject().remove("refunds");
    cacheRemoveValue(CacheKey.refunds);
  }

  /** Clears the 'note' field, the 'has' method for this field will now return false */
  public void clearNote() {
    unlogChange("note");
    getJSONObject().remove("note");
    cacheRemoveValue(CacheKey.note);
  }

  /** Clears the 'lineItemPayments' field, the 'has' method for this field will now return false */
  public void clearLineItemPayments() {
    unlogChange("lineItemPayments");
    getJSONObject().remove("lineItemPayments");
    cacheRemoveValue(CacheKey.lineItemPayments);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Payment copyChanges() {
    Payment copy = new Payment();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Payment src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Payment(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Payment{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Payment> CREATOR = new android.os.Parcelable.Creator<Payment>() {
    @Override
    public Payment createFromParcel(android.os.Parcel in) {
      Payment instance = new Payment(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Payment[] newArray(int size) {
      return new Payment[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Payment> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Payment>() {
    @Override
    public Payment create(org.json.JSONObject jsonObject) {
      return new Payment(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean ORDER_IS_REQUIRED = false;

    public static final boolean TENDER_IS_REQUIRED = false;

    public static final boolean AMOUNT_IS_REQUIRED = false;

    public static final boolean TIPAMOUNT_IS_REQUIRED = false;

    public static final boolean TAXAMOUNT_IS_REQUIRED = false;

    public static final boolean CASHTENDERED_IS_REQUIRED = false;

    public static final boolean EXTERNALPAYMENTID_IS_REQUIRED = false;
    public static final long EXTERNALPAYMENTID_MAX_LEN = 32;

    public static final boolean EMPLOYEE_IS_REQUIRED = false;

    public static final boolean CREATEDTIME_IS_REQUIRED = false;

    public static final boolean CLIENTCREATEDTIME_IS_REQUIRED = false;

    public static final boolean OFFLINE_IS_REQUIRED = false;

    public static final boolean RESULT_IS_REQUIRED = false;

    public static final boolean CARDTRANSACTION_IS_REQUIRED = false;

    public static final boolean TAXRATES_IS_REQUIRED = false;

    public static final boolean REFUNDS_IS_REQUIRED = false;

    public static final boolean NOTE_IS_REQUIRED = false;
    public static final long NOTE_MAX_LEN = 255;

    public static final boolean LINEITEMPAYMENTS_IS_REQUIRED = false;

  }

}
