/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2013 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.printer;

@SuppressWarnings("all")
public final class Printer implements android.os.Parcelable, com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {


  private enum CacheKey {
    id {
      @Override
      public Object extractValue(Printer instance) {
        return instance.extractId();
      }
    },
    mac {
      @Override
      public Object extractValue(Printer instance) {
        return instance.extractMac();
      }
    },
    model {
      @Override
      public Object extractValue(Printer instance) {
        return instance.extractModel();
      }
    },
    name {
      @Override
      public Object extractValue(Printer instance) {
        return instance.extractName();
      }
    },
    ipAddress {
      @Override
      public Object extractValue(Printer instance) {
        return instance.extractIpAddress();
      }
    },
    type {
      @Override
      public Object extractValue(Printer instance) {
        return instance.extractType();
      }
    },
    ;

    public abstract Object extractValue(Printer instance);
  }

  private String jsonString = null;
  private org.json.JSONObject jsonObject = null;
  private android.os.Bundle bundle = null;
  private android.os.Bundle changeLog = null;
  private Object[] cache = null;
  private byte[] cacheState = null;

  private static final byte STATE_NOT_CACHED = 0;
  private static final byte STATE_CACHED_NO_VALUE = 1;
  private static final byte STATE_CACHED_VALUE = 2;

  /**
   * Constructs a new empty instance.
   */
  public Printer() { }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Printer(String json) {
    this.jsonString = json;
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Printer(org.json.JSONObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Printer(Printer src) {
    if (src.jsonString != null) {
      this.jsonString = src.jsonString;
    } else {
      this.jsonObject = com.clover.sdk.v3.JsonHelper.deepCopy(src.getJSONObject());
    }
  }

  private <T> T cacheGet(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return (T) cache[index];
  }

  private boolean cacheValueIsNotNull(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cache[index] != null;
  }

  private boolean cacheHasKey(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    return cacheState[index] == STATE_CACHED_VALUE;
  }

  private void cacheRemoveValue(CacheKey key) {
    int index = key.ordinal();
    populateCache(index);
    cache[index] = null;
    cacheState[index] = STATE_CACHED_NO_VALUE;
  }

  private void cacheMarkDirty(CacheKey key) {
    if (cache != null) {
      int index = key.ordinal();
      cache[index] = null;
      cacheState[index] = STATE_NOT_CACHED;
    }
  }

  private void populateCache(int index) {
    if (cache == null) {
      int size = CacheKey.values().length;
      cache = new Object[size];
      cacheState = new byte[size];
    }

    if (cacheState[index] == STATE_NOT_CACHED) {
      CacheKey key = CacheKey.values()[index];

      if (getJSONObject().has(key.name())) {
        cache[index] = key.extractValue(this);
        cacheState[index] = STATE_CACHED_VALUE;
      } else {
        cacheState[index] = STATE_CACHED_NO_VALUE;
      }
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    try {
      if (jsonObject == null) {
        if (jsonString != null) {
          jsonObject = new org.json.JSONObject(jsonString);
          jsonString = null; // null this so it will be recreated if jsonObject is modified
        } else {
          jsonObject = new org.json.JSONObject();
        }
      }
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }
    return jsonObject;
  }


  @Override
  public void validate() {
    java.lang.String id = getId();
    if (id != null && id.length() > 13) throw new IllegalArgumentException("Maximum string length exceeded for 'id'");

    java.lang.String mac = getMac();
    if (mac != null && mac.length() > 30) throw new IllegalArgumentException("Maximum string length exceeded for 'mac'");

    java.lang.String model = getModel();
    if (model != null && model.length() > 20) throw new IllegalArgumentException("Maximum string length exceeded for 'model'");

    java.lang.String name = getName();
    if (name != null && name.length() > 30) throw new IllegalArgumentException("Maximum string length exceeded for 'name'");

    java.lang.String ipAddress = getIpAddress();
    if (ipAddress != null && ipAddress.length() > 15) throw new IllegalArgumentException("Maximum string length exceeded for 'ipAddress'");
  }


  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return cacheGet(CacheKey.id);
  }

  private java.lang.String extractId() {
    return getJSONObject().isNull("id") ? null :
      getJSONObject().optString("id");
  }

  /**
   * MAC address of a network printer
   */
  public java.lang.String getMac() {
    return cacheGet(CacheKey.mac);
  }

  private java.lang.String extractMac() {
    return getJSONObject().isNull("mac") ? null :
      getJSONObject().optString("mac");
  }

  /**
   */
  public java.lang.String getModel() {
    return cacheGet(CacheKey.model);
  }

  private java.lang.String extractModel() {
    return getJSONObject().isNull("model") ? null :
      getJSONObject().optString("model");
  }

  /**
   */
  public java.lang.String getName() {
    return cacheGet(CacheKey.name);
  }

  private java.lang.String extractName() {
    return getJSONObject().isNull("name") ? null :
      getJSONObject().optString("name");
  }

  /**
   * IP address of a network printer
   */
  public java.lang.String getIpAddress() {
    return cacheGet(CacheKey.ipAddress);
  }

  private java.lang.String extractIpAddress() {
    return getJSONObject().isNull("ipAddress") ? null :
      getJSONObject().optString("ipAddress");
  }

  /**
   * NETWORK is a printer that's directly connected to the network.  MY_LOCAL represents the printer that's connected to the device that's making the request.
   */
  public com.clover.sdk.v3.printer.PrinterType getType() {
    return cacheGet(CacheKey.type);
  }

  private com.clover.sdk.v3.printer.PrinterType extractType() {
    if (!getJSONObject().isNull("type")) {
      try {
        return com.clover.sdk.v3.printer.PrinterType.valueOf(getJSONObject().optString("type"));
      } catch(Exception e) {
        e.printStackTrace();
      }
    }

    return null;
  }


  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'mac' field is set and is not null */
  public boolean isNotNullMac() {
    return cacheValueIsNotNull(CacheKey.mac);
  }

  /** Checks whether the 'model' field is set and is not null */
  public boolean isNotNullModel() {
    return cacheValueIsNotNull(CacheKey.model);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'ipAddress' field is set and is not null */
  public boolean isNotNullIpAddress() {
    return cacheValueIsNotNull(CacheKey.ipAddress);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return cacheValueIsNotNull(CacheKey.type);
  }


  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'mac' field has been set, however the value could be null */
  public boolean hasMac() {
    return cacheHasKey(CacheKey.mac);
  }

  /** Checks whether the 'model' field has been set, however the value could be null */
  public boolean hasModel() {
    return cacheHasKey(CacheKey.model);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'ipAddress' field has been set, however the value could be null */
  public boolean hasIpAddress() {
    return cacheHasKey(CacheKey.ipAddress);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return cacheHasKey(CacheKey.type);
  }


  /**
   * Sets the field 'id'.
   */
  public Printer setId(java.lang.String id) {
    logChange("id");

    try {
      getJSONObject().put("id", id == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(id));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.id);
    return this;
  }

  /**
   * Sets the field 'mac'.
   */
  public Printer setMac(java.lang.String mac) {
    logChange("mac");

    try {
      getJSONObject().put("mac", mac == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(mac));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.mac);
    return this;
  }

  /**
   * Sets the field 'model'.
   */
  public Printer setModel(java.lang.String model) {
    logChange("model");

    try {
      getJSONObject().put("model", model == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(model));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.model);
    return this;
  }

  /**
   * Sets the field 'name'.
   */
  public Printer setName(java.lang.String name) {
    logChange("name");

    try {
      getJSONObject().put("name", name == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(name));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.name);
    return this;
  }

  /**
   * Sets the field 'ipAddress'.
   */
  public Printer setIpAddress(java.lang.String ipAddress) {
    logChange("ipAddress");

    try {
      getJSONObject().put("ipAddress", ipAddress == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(ipAddress));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.ipAddress);
    return this;
  }

  /**
   * Sets the field 'type'.
   */
  public Printer setType(com.clover.sdk.v3.printer.PrinterType type) {
    logChange("type");

    try {
      getJSONObject().put("type", type == null ? org.json.JSONObject.NULL : com.clover.sdk.v3.JsonHelper.toJSON(type));
    } catch (org.json.JSONException e) {
      throw new java.lang.IllegalArgumentException(e);
    }

    cacheMarkDirty(CacheKey.type);
    return this;
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    unlogChange("id");
    getJSONObject().remove("id");
    cacheRemoveValue(CacheKey.id);
  }

  /** Clears the 'mac' field, the 'has' method for this field will now return false */
  public void clearMac() {
    unlogChange("mac");
    getJSONObject().remove("mac");
    cacheRemoveValue(CacheKey.mac);
  }

  /** Clears the 'model' field, the 'has' method for this field will now return false */
  public void clearModel() {
    unlogChange("model");
    getJSONObject().remove("model");
    cacheRemoveValue(CacheKey.model);
  }

  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    unlogChange("name");
    getJSONObject().remove("name");
    cacheRemoveValue(CacheKey.name);
  }

  /** Clears the 'ipAddress' field, the 'has' method for this field will now return false */
  public void clearIpAddress() {
    unlogChange("ipAddress");
    getJSONObject().remove("ipAddress");
    cacheRemoveValue(CacheKey.ipAddress);
  }

  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    unlogChange("type");
    getJSONObject().remove("type");
    cacheRemoveValue(CacheKey.type);
  }


  private void logChange(java.lang.String field) {
    if (changeLog == null) {
      changeLog = new android.os.Bundle();
    }
    changeLog.putString(field, null);
  }

  private void unlogChange(java.lang.String field) {
    if (changeLog != null) {
      changeLog.remove(field);
    }
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return changeLog != null;
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    changeLog = null;
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Printer copyChanges() {
    Printer copy = new Printer();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Printer src) {
    if (src.changeLog != null) {
      try {
        // Make a copy of the source so the destination fields are copies
        org.json.JSONObject srcObj = new Printer(src).getJSONObject();
        org.json.JSONObject dstObj = getJSONObject();
        for (java.lang.String field : src.changeLog.keySet()) {
          dstObj.put(field, srcObj.get(field));
          logChange(field);
        }
      } catch (org.json.JSONException e) {
        throw new java.lang.IllegalArgumentException(e);
      }
    }
  }


  /**
   * Gets a Bundle which can be used to get and set data attached to this instance. The attached Bundle will be
   * parcelled but not jsonified.
   */
  public android.os.Bundle getBundle() {
    if (bundle == null) {
      bundle = new android.os.Bundle();
    }
    return bundle;
  }

  @Override
  public String toString() {
    String json = jsonString != null ? jsonString : getJSONObject().toString();

    return "Printer{" +
        "json='" + json + "'" +
        ", bundle=" + bundle +
        ", changeLog=" + changeLog +
        '}';
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(android.os.Parcel dest, int flags) {
	  com.clover.sdk.v3.JsonParcelHelper.wrap(getJSONObject()).writeToParcel(dest, 0);
    dest.writeBundle(bundle);
    dest.writeBundle(changeLog);
  }

  public static final android.os.Parcelable.Creator<Printer> CREATOR = new android.os.Parcelable.Creator<Printer>() {
    @Override
    public Printer createFromParcel(android.os.Parcel in) {
      Printer instance = new Printer(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.bundle = in.readBundle();
      instance.changeLog = in.readBundle();
      return instance;
    }

    @Override
    public Printer[] newArray(int size) {
      return new Printer[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Printer> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Printer>() {
    @Override
    public Printer create(org.json.JSONObject jsonObject) {
      return new Printer(jsonObject);
    }
  };


  public interface Constraints {

    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;

    public static final boolean MAC_IS_REQUIRED = false;
    public static final long MAC_MAX_LEN = 30;

    public static final boolean MODEL_IS_REQUIRED = false;
    public static final long MODEL_MAX_LEN = 20;

    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 30;

    public static final boolean IPADDRESS_IS_REQUIRED = false;
    public static final long IPADDRESS_MAX_LEN = 15;

    public static final boolean TYPE_IS_REQUIRED = false;

  }

}
