package com.clover.sdk.cfp.connector.session;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */


/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPropertyName propertyName}</li>
 * <li>{@link #getPropertyValue propertyValue}</li>
 * <li>{@link #getPropertyAction propertyAction}</li>
 * <li>{@link #getInputOptions inputOptions}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CFPSessionProperty extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getPropertyName() {
    return genClient.cacheGet(CacheKey.propertyName);
  }

  public java.lang.String getPropertyValue() {
    return genClient.cacheGet(CacheKey.propertyValue);
  }

  public CFPSessionPropertyAction getPropertyAction() {
    return genClient.cacheGet(CacheKey.propertyAction);
  }

  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    propertyName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    propertyValue
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    propertyAction
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(CFPSessionPropertyAction.class))
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<CFPSessionProperty> genClient;

  /**
   * Constructs a new empty instance.
   */
  public CFPSessionProperty() {
    genClient = new GenericClient<CFPSessionProperty>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected CFPSessionProperty(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CFPSessionProperty(String json) throws IllegalArgumentException {
    this();
    try {
      genClient.setJsonObject(new org.json.JSONObject(json));
    } catch (org.json.JSONException e) {
      throw new IllegalArgumentException("invalid json", e);
    }
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CFPSessionProperty(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CFPSessionProperty(CFPSessionProperty src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'propertyName' field is set and is not null */
  public boolean isNotNullPropertyName() {
    return genClient.cacheValueIsNotNull(CacheKey.propertyName);
  }

  /** Checks whether the 'propertyValue' field is set and is not null */
  public boolean isNotNullPropertyValue() {
    return genClient.cacheValueIsNotNull(CacheKey.propertyValue);
  }

  /** Checks whether the 'propertyAction' field is set and is not null */
  public boolean isNotNullPropertyAction() {
    return genClient.cacheValueIsNotNull(CacheKey.propertyAction);
  }


  /** Checks whether the 'propertyName' field has been set, however the value could be null */
  public boolean hasPropertyName() {
    return genClient.cacheHasKey(CacheKey.propertyName);
  }

  /** Checks whether the 'propertyValue' field has been set, however the value could be null */
  public boolean hasPropertyValue() {
    return genClient.cacheHasKey(CacheKey.propertyValue);
  }

  /** Checks whether the 'propertyAction' field has been set, however the value could be null */
  public boolean hasPropertyAction() {
    return genClient.cacheHasKey(CacheKey.propertyAction);
  }

  /**
   * Sets the field 'propertyName'.
   */
  public CFPSessionProperty setPropertyName(java.lang.String propertyName) {
    return genClient.setOther(propertyName, CacheKey.propertyName);
  }

  /**
   * Sets the field 'propertyValue'.
   */
  public CFPSessionProperty setPropertyValue(java.lang.String propertyValue) {
    return genClient.setOther(propertyValue, CacheKey.propertyValue);
  }

  /**
   * Sets the field 'propertyAction'.
   */
  public CFPSessionProperty setPropertyAction(CFPSessionPropertyAction propertyAction) {
    return genClient.setOther(propertyAction, CacheKey.propertyAction);
  }

  /** Clears the 'propertyName' field, the 'has' method for this field will now return false */
  public void clearPropertyName() {
    genClient.clear(CacheKey.propertyName);
  }
  /** Clears the 'propertyValue' field, the 'has' method for this field will now return false */
  public void clearPropertyValue() {
    genClient.clear(CacheKey.propertyValue);
  }
  /** Clears the 'propertyAction' field, the 'has' method for this field will now return false */
  public void clearPropertyAction() {
    genClient.clear(CacheKey.propertyAction);
  }

  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CFPSessionProperty copyChanges() {
    CFPSessionProperty copy = new CFPSessionProperty();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CFPSessionProperty src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CFPSessionProperty(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CFPSessionProperty> CREATOR = new android.os.Parcelable.Creator<CFPSessionProperty>() {
    @Override
    public CFPSessionProperty createFromParcel(android.os.Parcel in) {
      CFPSessionProperty instance = new CFPSessionProperty(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CFPSessionProperty[] newArray(int size) {
      return new CFPSessionProperty[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CFPSessionProperty> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CFPSessionProperty>() {
    @Override
    public CFPSessionProperty create(org.json.JSONObject jsonObject) {
      return new CFPSessionProperty(jsonObject);
    }
  };

  public interface Constraints {

    public static final boolean PROPERTYNAME_IS_REQUIRED = false;
    public static final boolean PROPERTYVALUE_IS_REQUIRED = false;
    public static final boolean PROPERTYACTION_IS_REQUIRED = false;
  }

}
