/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Aggregate Ratings & Reviews information about a developer app. Clients can get the average rating of an app by dividing the total number of stars an app has received by the total number of times it has been reviewed.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getReviewCount reviewCount}</li>
 * <li>{@link #getTotalStars totalStars}</li>
 * <li>{@link #getWeightedRating weightedRating}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AggregateRating extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Total number of reviews that merchants have written about this app
   */
  public java.lang.Long getReviewCount() {
    return genClient.cacheGet(CacheKey.reviewCount);
  }

  /**
   * Sum of the number of stars this app has received for all of its reviews
   */
  public java.lang.Long getTotalStars() {
    return genClient.cacheGet(CacheKey.totalStars);
  }

  /**
   * Weighted Rating for this App
   */
  public java.lang.Double getWeightedRating() {
    return genClient.cacheGet(CacheKey.weightedRating);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    reviewCount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    totalStars
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    weightedRating
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Double.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AggregateRating> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AggregateRating() {
    genClient = new GenericClient<AggregateRating>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AggregateRating(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AggregateRating(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AggregateRating(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AggregateRating(AggregateRating src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'reviewCount' field is set and is not null */
  public boolean isNotNullReviewCount() {
    return genClient.cacheValueIsNotNull(CacheKey.reviewCount);
  }

  /** Checks whether the 'totalStars' field is set and is not null */
  public boolean isNotNullTotalStars() {
    return genClient.cacheValueIsNotNull(CacheKey.totalStars);
  }

  /** Checks whether the 'weightedRating' field is set and is not null */
  public boolean isNotNullWeightedRating() {
    return genClient.cacheValueIsNotNull(CacheKey.weightedRating);
  }



  /** Checks whether the 'reviewCount' field has been set, however the value could be null */
  public boolean hasReviewCount() {
    return genClient.cacheHasKey(CacheKey.reviewCount);
  }

  /** Checks whether the 'totalStars' field has been set, however the value could be null */
  public boolean hasTotalStars() {
    return genClient.cacheHasKey(CacheKey.totalStars);
  }

  /** Checks whether the 'weightedRating' field has been set, however the value could be null */
  public boolean hasWeightedRating() {
    return genClient.cacheHasKey(CacheKey.weightedRating);
  }


  /**
   * Sets the field 'reviewCount'.
   */
  public AggregateRating setReviewCount(java.lang.Long reviewCount) {
    return genClient.setOther(reviewCount, CacheKey.reviewCount);
  }

  /**
   * Sets the field 'totalStars'.
   */
  public AggregateRating setTotalStars(java.lang.Long totalStars) {
    return genClient.setOther(totalStars, CacheKey.totalStars);
  }

  /**
   * Sets the field 'weightedRating'.
   */
  public AggregateRating setWeightedRating(java.lang.Double weightedRating) {
    return genClient.setOther(weightedRating, CacheKey.weightedRating);
  }


  /** Clears the 'reviewCount' field, the 'has' method for this field will now return false */
  public void clearReviewCount() {
    genClient.clear(CacheKey.reviewCount);
  }
  /** Clears the 'totalStars' field, the 'has' method for this field will now return false */
  public void clearTotalStars() {
    genClient.clear(CacheKey.totalStars);
  }
  /** Clears the 'weightedRating' field, the 'has' method for this field will now return false */
  public void clearWeightedRating() {
    genClient.clear(CacheKey.weightedRating);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AggregateRating copyChanges() {
    AggregateRating copy = new AggregateRating();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AggregateRating src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AggregateRating(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AggregateRating> CREATOR = new android.os.Parcelable.Creator<AggregateRating>() {
    @Override
    public AggregateRating createFromParcel(android.os.Parcel in) {
      AggregateRating instance = new AggregateRating(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AggregateRating[] newArray(int size) {
      return new AggregateRating[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AggregateRating> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AggregateRating>() {
    public Class<AggregateRating> getCreatedClass() {
      return AggregateRating.class;
    }

    @Override
    public AggregateRating create(org.json.JSONObject jsonObject) {
      return new AggregateRating(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean REVIEWCOUNT_IS_REQUIRED = false;
    public static final boolean TOTALSTARS_IS_REQUIRED = false;
    public static final boolean WEIGHTEDRATING_IS_REQUIRED = false;
  }

}
