/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getPublished published}</li>
 * <li>{@link #getDeveloper developer}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getTagline tagline}</li>
 * <li>{@link #getBenefits benefits}</li>
 * <li>{@link #getVideoUrl videoUrl}</li>
 * <li>{@link #getActivationUrl activationUrl}</li>
 * <li>{@link #getSiteUrl siteUrl}</li>
 * <li>{@link #getDefaultResponseType defaultResponseType}</li>
 * <li>{@link #getAppDomain appDomain}</li>
 * <li>{@link #getAndroidVersion androidVersion}</li>
 * <li>{@link #getPackageName packageName}</li>
 * <li>{@link #getApproved approved}</li>
 * <li>{@link #getSystemApp systemApp}</li>
 * <li>{@link #getHidden hidden}</li>
 * <li>{@link #getDistribution distribution}</li>
 * <li>{@link #getFilenameIcon filenameIcon}</li>
 * <li>{@link #getFilenameIconSmall filenameIconSmall}</li>
 * <li>{@link #getFilenameIconLarge filenameIconLarge}</li>
 * <li>{@link #getFilenameCover filenameCover}</li>
 * <li>{@link #getFilenameBanner filenameBanner}</li>
 * <li>{@link #getInstallCount installCount}</li>
 * <li>{@link #getSortOrder sortOrder}</li>
 * <li>{@link #getPermissionMerchantRead permissionMerchantRead}</li>
 * <li>{@link #getPermissionMerchantWrite permissionMerchantWrite}</li>
 * <li>{@link #getPermissionCustomersRead permissionCustomersRead}</li>
 * <li>{@link #getPermissionCustomersWrite permissionCustomersWrite}</li>
 * <li>{@link #getPermissionInventoryRead permissionInventoryRead}</li>
 * <li>{@link #getPermissionInventoryWrite permissionInventoryWrite}</li>
 * <li>{@link #getPermissionOrdersRead permissionOrdersRead}</li>
 * <li>{@link #getPermissionOrdersWrite permissionOrdersWrite}</li>
 * <li>{@link #getPermissionPaymentsRead permissionPaymentsRead}</li>
 * <li>{@link #getPermissionPaymentsWrite permissionPaymentsWrite}</li>
 * <li>{@link #getPermissionEmployeesRead permissionEmployeesRead}</li>
 * <li>{@link #getPermissionEmployeesWrite permissionEmployeesWrite}</li>
 * <li>{@link #getPermissionProcessCards permissionProcessCards}</li>
 * <li>{@link #getPermissionMidRead permissionMidRead}</li>
 * <li>{@link #getPermissionCustomersAddressRead permissionCustomersAddressRead}</li>
 * <li>{@link #getPermissionCustomersAddressWrite permissionCustomersAddressWrite}</li>
 * <li>{@link #getPermissionCustomersBirthdateRead permissionCustomersBirthdateRead}</li>
 * <li>{@link #getPermissionCustomersBirthdateWrite permissionCustomersBirthdateWrite}</li>
 * <li>{@link #getPermissionCustomersBusinessnameRead permissionCustomersBusinessnameRead}</li>
 * <li>{@link #getPermissionCustomersBusinessnameWrite permissionCustomersBusinessnameWrite}</li>
 * <li>{@link #getPermissionCustomersCardRead permissionCustomersCardRead}</li>
 * <li>{@link #getPermissionCustomersCardWrite permissionCustomersCardWrite}</li>
 * <li>{@link #getPermissionCustomersEmailRead permissionCustomersEmailRead}</li>
 * <li>{@link #getPermissionCustomersEmailWrite permissionCustomersEmailWrite}</li>
 * <li>{@link #getPermissionCustomersNoteRead permissionCustomersNoteRead}</li>
 * <li>{@link #getPermissionCustomersNoteWrite permissionCustomersNoteWrite}</li>
 * <li>{@link #getPermissionCustomersPhoneRead permissionCustomersPhoneRead}</li>
 * <li>{@link #getPermissionCustomersPhoneWrite permissionCustomersPhoneWrite}</li>
 * <li>{@link #getPermissionCustomersMarketingRead permissionCustomersMarketingRead}</li>
 * <li>{@link #getPermissionCustomersMarketingWrite permissionCustomersMarketingWrite}</li>
 * <li>{@link #getPrivacyPolicy privacyPolicy}</li>
 * <li>{@link #getEula eula}</li>
 * <li>{@link #getSupportPhone supportPhone}</li>
 * <li>{@link #getSupportPhoneHours supportPhoneHours}</li>
 * <li>{@link #getSupportEmail supportEmail}</li>
 * <li>{@link #getSupportUrl supportUrl}</li>
 * <li>{@link #getProductType productType}</li>
 * <li>{@link #getApprovalStatus approvalStatus}</li>
 * <li>{@link #getAndroidPermissions androidPermissions}</li>
 * <li>{@link #getScreenshots screenshots}</li>
 * <li>{@link #getAvailableSubscriptions availableSubscriptions}</li>
 * <li>{@link #getSubscriptions subscriptions}</li>
 * <li>{@link #getRevisions revisions}</li>
 * <li>{@link #getAvailableMetereds availableMetereds}</li>
 * <li>{@link #getMetereds metereds}</li>
 * <li>{@link #getUsbDevices usbDevices}</li>
 * <li>{@link #getIsMerchantInTrial isMerchantInTrial}</li>
 * <li>{@link #getCurrentSubscription currentSubscription}</li>
 * <li>{@link #getWebhook webhook}</li>
 * <li>{@link #getAndroidVersions androidVersions}</li>
 * <li>{@link #getInstalled installed}</li>
 * <li>{@link #getInstalledTime installedTime}</li>
 * <li>{@link #getPaidAppHasTrial paidAppHasTrial}</li>
 * <li>{@link #getApprovalStatusModifiedTime approvalStatusModifiedTime}</li>
 * <li>{@link #getSmartReceiptText smartReceiptText}</li>
 * <li>{@link #getSmartReceiptUrl smartReceiptUrl}</li>
 * <li>{@link #getBillingStartTime billingStartTime}</li>
 * <li>{@link #getBillingInfo billingInfo}</li>
 * <li>{@link #getAppSecret appSecret}</li>
 * <li>{@link #getBusinessTypes businessTypes}</li>
 * <li>{@link #getDeviceTypes deviceTypes}</li>
 * <li>{@link #getModules modules}</li>
 * <li>{@link #getTaxClassificationCode taxClassificationCode}</li>
 * <li>{@link #getApplicationId applicationId}</li>
 * <li>{@link #getNonCloverBilling nonCloverBilling}</li>
 * <li>{@link #getEquipmentCode equipmentCode}</li>
 * <li>{@link #getEquipmentName equipmentName}</li>
 * <li>{@link #getFirstPublishedTime firstPublishedTime}</li>
 * <li>{@link #getFirstApprovalTime firstApprovalTime}</li>
 * <li>{@link #getFirstSubmittedTime firstSubmittedTime}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getAppBundle appBundle}</li>
 * <li>{@link #getEditorPick editorPick}</li>
 * <li>{@link #getPopularity popularity}</li>
 * <li>{@link #getAllowUninstall allowUninstall}</li>
 * <li>{@link #getCharge charge}</li>
 * <li>{@link #getLinkLabel linkLabel}</li>
 * <li>{@link #getCategories categories}</li>
 * <li>{@link #getPartnerId partnerId}</li>
 * <li>{@link #getLocales locales}</li>
 * <li>{@link #getRejectionReason rejectionReason}</li>
 * <li>{@link #getAggregateRating aggregateRating}</li>
 * <li>{@link #getTrialDays trialDays}</li>
 * <li>{@link #getTrialDaysLeft trialDaysLeft}</li>
 * <li>{@link #getIsHipaaCompliant isHipaaCompliant}</li>
 * <li>{@link #getMerchantsPlanIdsExclusion merchantsPlanIdsExclusion}</li>
 * <li>{@link #getResellersUuidsExclusion resellersUuidsExclusion}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class App extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the app
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.Boolean getPublished() {
    return genClient.cacheGet(CacheKey.published);
  }

  public com.clover.sdk.v3.developer.Developer getDeveloper() {
    return genClient.cacheGet(CacheKey.developer);
  }

  /**
   * DEPRECATED: merchant information should not be accessed through this object
   */
  @Deprecated
  public com.clover.sdk.v3.merchant.Merchant getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * App Description
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  /**
   * Short tagline for the app
   */
  public java.lang.String getTagline() {
    return genClient.cacheGet(CacheKey.tagline);
  }

  /**
   * Brief description about benefits of app
   */
  public java.util.List<java.lang.String> getBenefits() {
    return genClient.cacheGet(CacheKey.benefits);
  }

  /**
   * URL for embedded video
   */
  public java.lang.String getVideoUrl() {
    return genClient.cacheGet(CacheKey.videoUrl);
  }

  /**
   * Activation url for redirecting users after app installation.
   */
  public java.lang.String getActivationUrl() {
    return genClient.cacheGet(CacheKey.activationUrl);
  }

  /**
   * Site url for oauth redirect and web app launch from appmarket.
   */
  public java.lang.String getSiteUrl() {
    return genClient.cacheGet(CacheKey.siteUrl);
  }

  /**
   * Default oauth response type.
   */
  public com.clover.sdk.v3.apps.OAuthResponseType getDefaultResponseType() {
    return genClient.cacheGet(CacheKey.defaultResponseType);
  }

  public java.lang.String getAppDomain() {
    return genClient.cacheGet(CacheKey.appDomain);
  }

  public com.clover.sdk.v3.apps.AndroidVersion getAndroidVersion() {
    return genClient.cacheGet(CacheKey.androidVersion);
  }

  public java.lang.String getPackageName() {
    return genClient.cacheGet(CacheKey.packageName);
  }

  public java.lang.Boolean getApproved() {
    return genClient.cacheGet(CacheKey.approved);
  }

  public java.lang.Boolean getSystemApp() {
    return genClient.cacheGet(CacheKey.systemApp);
  }

  public java.lang.Boolean getHidden() {
    return genClient.cacheGet(CacheKey.hidden);
  }

  public com.clover.sdk.v3.apps.Distribution getDistribution() {
    return genClient.cacheGet(CacheKey.distribution);
  }

  public java.lang.String getFilenameIcon() {
    return genClient.cacheGet(CacheKey.filenameIcon);
  }

  /**
   * URL to the icon of the app. Generated from filenameIcon.
   */
  public java.lang.String getFilenameIconSmall() {
    return genClient.cacheGet(CacheKey.filenameIconSmall);
  }

  /**
   * URL to the icon of the app. Generated from filenameIcon.
   */
  public java.lang.String getFilenameIconLarge() {
    return genClient.cacheGet(CacheKey.filenameIconLarge);
  }

  /**
   * URL to the cover images of the app. To be displayed on app market details page.
   */
  public java.lang.String getFilenameCover() {
    return genClient.cacheGet(CacheKey.filenameCover);
  }

  /**
   * URL to the hero images of the app. To be displayed on app market home page.
   */
  public java.lang.String getFilenameBanner() {
    return genClient.cacheGet(CacheKey.filenameBanner);
  }

  public java.lang.Long getInstallCount() {
    return genClient.cacheGet(CacheKey.installCount);
  }

  public java.lang.Long getSortOrder() {
    return genClient.cacheGet(CacheKey.sortOrder);
  }

  public java.lang.Boolean getPermissionMerchantRead() {
    return genClient.cacheGet(CacheKey.permissionMerchantRead);
  }

  public java.lang.Boolean getPermissionMerchantWrite() {
    return genClient.cacheGet(CacheKey.permissionMerchantWrite);
  }

  public java.lang.Boolean getPermissionCustomersRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersRead);
  }

  public java.lang.Boolean getPermissionCustomersWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersWrite);
  }

  public java.lang.Boolean getPermissionInventoryRead() {
    return genClient.cacheGet(CacheKey.permissionInventoryRead);
  }

  public java.lang.Boolean getPermissionInventoryWrite() {
    return genClient.cacheGet(CacheKey.permissionInventoryWrite);
  }

  public java.lang.Boolean getPermissionOrdersRead() {
    return genClient.cacheGet(CacheKey.permissionOrdersRead);
  }

  public java.lang.Boolean getPermissionOrdersWrite() {
    return genClient.cacheGet(CacheKey.permissionOrdersWrite);
  }

  public java.lang.Boolean getPermissionPaymentsRead() {
    return genClient.cacheGet(CacheKey.permissionPaymentsRead);
  }

  public java.lang.Boolean getPermissionPaymentsWrite() {
    return genClient.cacheGet(CacheKey.permissionPaymentsWrite);
  }

  public java.lang.Boolean getPermissionEmployeesRead() {
    return genClient.cacheGet(CacheKey.permissionEmployeesRead);
  }

  public java.lang.Boolean getPermissionEmployeesWrite() {
    return genClient.cacheGet(CacheKey.permissionEmployeesWrite);
  }

  public java.lang.Boolean getPermissionProcessCards() {
    return genClient.cacheGet(CacheKey.permissionProcessCards);
  }

  public java.lang.Boolean getPermissionMidRead() {
    return genClient.cacheGet(CacheKey.permissionMidRead);
  }

  public java.lang.Boolean getPermissionCustomersAddressRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersAddressRead);
  }

  public java.lang.Boolean getPermissionCustomersAddressWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersAddressWrite);
  }

  public java.lang.Boolean getPermissionCustomersBirthdateRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersBirthdateRead);
  }

  public java.lang.Boolean getPermissionCustomersBirthdateWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersBirthdateWrite);
  }

  public java.lang.Boolean getPermissionCustomersBusinessnameRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersBusinessnameRead);
  }

  public java.lang.Boolean getPermissionCustomersBusinessnameWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersBusinessnameWrite);
  }

  public java.lang.Boolean getPermissionCustomersCardRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersCardRead);
  }

  public java.lang.Boolean getPermissionCustomersCardWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersCardWrite);
  }

  public java.lang.Boolean getPermissionCustomersEmailRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersEmailRead);
  }

  public java.lang.Boolean getPermissionCustomersEmailWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersEmailWrite);
  }

  public java.lang.Boolean getPermissionCustomersNoteRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersNoteRead);
  }

  public java.lang.Boolean getPermissionCustomersNoteWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersNoteWrite);
  }

  public java.lang.Boolean getPermissionCustomersPhoneRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersPhoneRead);
  }

  public java.lang.Boolean getPermissionCustomersPhoneWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersPhoneWrite);
  }

  public java.lang.Boolean getPermissionCustomersMarketingRead() {
    return genClient.cacheGet(CacheKey.permissionCustomersMarketingRead);
  }

  public java.lang.Boolean getPermissionCustomersMarketingWrite() {
    return genClient.cacheGet(CacheKey.permissionCustomersMarketingWrite);
  }

  public java.lang.String getPrivacyPolicy() {
    return genClient.cacheGet(CacheKey.privacyPolicy);
  }

  public java.lang.String getEula() {
    return genClient.cacheGet(CacheKey.eula);
  }

  public java.lang.String getSupportPhone() {
    return genClient.cacheGet(CacheKey.supportPhone);
  }

  public java.lang.String getSupportPhoneHours() {
    return genClient.cacheGet(CacheKey.supportPhoneHours);
  }

  public java.lang.String getSupportEmail() {
    return genClient.cacheGet(CacheKey.supportEmail);
  }

  public java.lang.String getSupportUrl() {
    return genClient.cacheGet(CacheKey.supportUrl);
  }

  public com.clover.sdk.v3.apps.ProductType getProductType() {
    return genClient.cacheGet(CacheKey.productType);
  }

  public com.clover.sdk.v3.base.ApprovalStatus getApprovalStatus() {
    return genClient.cacheGet(CacheKey.approvalStatus);
  }

  /**
   * The app's android permissions
   */
  public java.util.List<com.clover.sdk.v3.apps.AndroidPermission> getAndroidPermissions() {
    return genClient.cacheGet(CacheKey.androidPermissions);
  }

  /**
   * The app's screenshots
   */
  public java.util.List<com.clover.sdk.v3.apps.Screenshot> getScreenshots() {
    return genClient.cacheGet(CacheKey.screenshots);
  }

  /**
   * Available subscription options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppSubscription> getAvailableSubscriptions() {
    return genClient.cacheGet(CacheKey.availableSubscriptions);
  }

  /**
   * Subscription options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppSubscription> getSubscriptions() {
    return genClient.cacheGet(CacheKey.subscriptions);
  }

  /**
   * Revisions for this app
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getRevisions() {
    return genClient.cacheGet(CacheKey.revisions);
  }

  /**
   * Available metered options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppMetered> getAvailableMetereds() {
    return genClient.cacheGet(CacheKey.availableMetereds);
  }

  /**
   * Metered options for this app
   */
  public java.util.List<com.clover.sdk.v3.apps.AppMetered> getMetereds() {
    return genClient.cacheGet(CacheKey.metereds);
  }

  /**
   * USB devices with which this app will communicate
   */
  public java.util.List<com.clover.sdk.v3.apps.AppUsbDevice> getUsbDevices() {
    return genClient.cacheGet(CacheKey.usbDevices);
  }

  /**
   * DEPRECATED: This is now derived directly from billingStartTime (if future -> in trial; if past -> not in trial).  So it is now unnecessary.  Please update client code to not use it.
   */
  @Deprecated
  public java.lang.Boolean getIsMerchantInTrial() {
    return genClient.cacheGet(CacheKey.isMerchantInTrial);
  }

  /**
   * The merchant's current subscription for this app
   */
  public com.clover.sdk.v3.apps.AppSubscription getCurrentSubscription() {
    return genClient.cacheGet(CacheKey.currentSubscription);
  }

  /**
   * The app's web hook
   */
  public com.clover.sdk.v3.apps.WebHook getWebhook() {
    return genClient.cacheGet(CacheKey.webhook);
  }

  /**
   * The app's uploaded apks
   */
  public java.util.List<com.clover.sdk.v3.apps.AndroidVersion> getAndroidVersions() {
    return genClient.cacheGet(CacheKey.androidVersions);
  }

  /**
   *  Whether the app is installed 
   */
  public java.lang.Boolean getInstalled() {
    return genClient.cacheGet(CacheKey.installed);
  }

  /**
   * If the merchant has the app installed, this is the timestamp of when they installed the app.
   */
  public java.lang.Long getInstalledTime() {
    return genClient.cacheGet(CacheKey.installedTime);
  }

  /**
   * If the app is a paid app, this tells whether it currently offers a 30 day free trial or not.  Developer can toggle at will.
   */
  public java.lang.Boolean getPaidAppHasTrial() {
    return genClient.cacheGet(CacheKey.paidAppHasTrial);
  }

  /**
   * Records the time that the approval status last changed
   */
  public java.lang.Long getApprovalStatusModifiedTime() {
    return genClient.cacheGet(CacheKey.approvalStatusModifiedTime);
  }

  /**
   * Text will print on printed receipts for this app
   */
  public java.lang.String getSmartReceiptText() {
    return genClient.cacheGet(CacheKey.smartReceiptText);
  }

  /**
   * URL we will expose on printed and web receipts for this app
   */
  public java.lang.String getSmartReceiptUrl() {
    return genClient.cacheGet(CacheKey.smartReceiptUrl);
  }

  /**
   * If the merchant has the app installed, this is the timestamp of when they start/started paying.  If the merchant doesn't have the app installed, this is the timestamp of when they would start paying.  In UTC.  Applies to paid apps only.
   */
  public java.lang.Long getBillingStartTime() {
    return genClient.cacheGet(CacheKey.billingStartTime);
  }

  /**
   * Billing information for the app for the merchant in context
   */
  public com.clover.sdk.v3.apps.AppBillingInfo getBillingInfo() {
    return genClient.cacheGet(CacheKey.billingInfo);
  }

  /**
   * App's client secret for use with oauth
   */
  public java.lang.String getAppSecret() {
    return genClient.cacheGet(CacheKey.appSecret);
  }

  /**
   * App's associated business types
   */
  public java.util.List<com.clover.sdk.v3.apps.BusinessType> getBusinessTypes() {
    return genClient.cacheGet(CacheKey.businessTypes);
  }

  /**
   * App's supported device types
   */
  public java.util.List<com.clover.sdk.v3.apps.DeviceType> getDeviceTypes() {
    return genClient.cacheGet(CacheKey.deviceTypes);
  }

  public java.util.List<com.clover.sdk.v3.merchant.Module> getModules() {
    return genClient.cacheGet(CacheKey.modules);
  }

  public java.lang.String getTaxClassificationCode() {
    return genClient.cacheGet(CacheKey.taxClassificationCode);
  }

  /**
   * When set, this provides a friendly id that can be used to link an external application to this app.
   */
  public java.lang.String getApplicationId() {
    return genClient.cacheGet(CacheKey.applicationId);
  }

  /**
   * True if the app developer handles the billing for this app.
   */
  public java.lang.Boolean getNonCloverBilling() {
    return genClient.cacheGet(CacheKey.nonCloverBilling);
  }

  /**
   * Used to associate this developer/app combination with a specific equipment code in First Data back office systems
   */
  public java.lang.String getEquipmentCode() {
    return genClient.cacheGet(CacheKey.equipmentCode);
  }

  /**
   * Used to associate this developer/app combination with a specific equipment code in First Data back office systems
   */
  public java.lang.String getEquipmentName() {
    return genClient.cacheGet(CacheKey.equipmentName);
  }

  /**
   * Timestamp of first time this app transitions to approvalStatus PUBLISHED
   */
  public java.lang.Long getFirstPublishedTime() {
    return genClient.cacheGet(CacheKey.firstPublishedTime);
  }

  /**
   * Timestamp of first time this app transitions to approvalStatus APPROVED
   */
  public java.lang.Long getFirstApprovalTime() {
    return genClient.cacheGet(CacheKey.firstApprovalTime);
  }

  /**
   * Timestamp of first time this app transitions to approvalStatus PENDING
   */
  public java.lang.Long getFirstSubmittedTime() {
    return genClient.cacheGet(CacheKey.firstSubmittedTime);
  }

  /**
   * Timestamp of first time this app was created
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Points to a bundle of apps that should be installed/uninstalled when user installs/uninstalls this app.
   */
  public com.clover.sdk.v3.base.Reference getAppBundle() {
    return genClient.cacheGet(CacheKey.appBundle);
  }

  /**
   * True if the App has been tagged as an editor's pick.
   */
  public java.lang.Boolean getEditorPick() {
    return genClient.cacheGet(CacheKey.editorPick);
  }

  /**
   * Number of installs by billable production merchants once this app is published.
   */
  public java.lang.Long getPopularity() {
    return genClient.cacheGet(CacheKey.popularity);
  }

  /**
   * Only applies to default apps of plan, if true allow merchant to uninstall app.
   */
  public java.lang.Boolean getAllowUninstall() {
    return genClient.cacheGet(CacheKey.allowUninstall);
  }

  /**
   * Only applies to default apps of plan, if true then charge for app.
   */
  public java.lang.Boolean getCharge() {
    return genClient.cacheGet(CacheKey.charge);
  }

  /**
   * Link label to rebrand and promote apps
   */
  public java.lang.String getLinkLabel() {
    return genClient.cacheGet(CacheKey.linkLabel);
  }

  /**
   * List of app categories applicable to this app.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getCategories() {
    return genClient.cacheGet(CacheKey.categories);
  }

  /**
   * Used to identify a semi-int developer app.
   */
  public java.lang.String getPartnerId() {
    return genClient.cacheGet(CacheKey.partnerId);
  }

  /**
   * List of locale specific app resources.
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getLocales() {
    return genClient.cacheGet(CacheKey.locales);
  }

  /**
   * Rejection reason by the dev rel team while rejecting an app
   */
  public java.lang.String getRejectionReason() {
    return genClient.cacheGet(CacheKey.rejectionReason);
  }

  /**
   * Aggregate ratings & reviews data for this app.
   */
  public com.clover.sdk.v3.apps.AggregateRating getAggregateRating() {
    return genClient.cacheGet(CacheKey.aggregateRating);
  }

  /**
   * Returns the trial period in days for this app.
   */
  public java.lang.Integer getTrialDays() {
    return genClient.cacheGet(CacheKey.trialDays);
  }

  /**
   * Returns the trial period left in days for this app.
   */
  public java.lang.Integer getTrialDaysLeft() {
    return genClient.cacheGet(CacheKey.trialDaysLeft);
  }

  /**
   * This attribute shows if app is restricted due to compliance.
   */
  public java.lang.Boolean getIsHipaaCompliant() {
    return genClient.cacheGet(CacheKey.isHipaaCompliant);
  }

  /**
   * List of excluded merchant plan ids for given app
   */
  public java.util.List<java.lang.Long> getMerchantsPlanIdsExclusion() {
    return genClient.cacheGet(CacheKey.merchantsPlanIdsExclusion);
  }

  /**
   * List of excluded resellers uuids for given app
   */
  public java.util.List<java.lang.String> getResellersUuidsExclusion() {
    return genClient.cacheGet(CacheKey.resellersUuidsExclusion);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    published
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    developer
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.developer.Developer.JSON_CREATOR)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.merchant.Merchant.JSON_CREATOR)),
    description
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    tagline
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    benefits
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
    videoUrl
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    activationUrl
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    siteUrl
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    defaultResponseType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.OAuthResponseType.class)),
    appDomain
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    androidVersion
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AndroidVersion.JSON_CREATOR)),
    packageName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    approved
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    systemApp
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    hidden
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    distribution
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.Distribution.class)),
    filenameIcon
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    filenameIconSmall
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    filenameIconLarge
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    filenameCover
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    filenameBanner
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    installCount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    sortOrder
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    permissionMerchantRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionMerchantWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionInventoryRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionInventoryWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionOrdersRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionOrdersWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionPaymentsRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionPaymentsWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionEmployeesRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionEmployeesWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionProcessCards
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionMidRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersAddressRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersAddressWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersBirthdateRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersBirthdateWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersBusinessnameRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersBusinessnameWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersCardRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersCardWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersEmailRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersEmailWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersNoteRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersNoteWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersPhoneRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersPhoneWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersMarketingRead
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    permissionCustomersMarketingWrite
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    privacyPolicy
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    eula
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    supportPhone
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    supportPhoneHours
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    supportEmail
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    supportUrl
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    productType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.ProductType.class)),
    approvalStatus
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.base.ApprovalStatus.class)),
    androidPermissions
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AndroidPermission.JSON_CREATOR)),
    screenshots
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.Screenshot.JSON_CREATOR)),
    availableSubscriptions
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AppSubscription.JSON_CREATOR)),
    subscriptions
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AppSubscription.JSON_CREATOR)),
    revisions
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    availableMetereds
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AppMetered.JSON_CREATOR)),
    metereds
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AppMetered.JSON_CREATOR)),
    usbDevices
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AppUsbDevice.JSON_CREATOR)),
    isMerchantInTrial
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    currentSubscription
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AppSubscription.JSON_CREATOR)),
    webhook
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.WebHook.JSON_CREATOR)),
    androidVersions
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.AndroidVersion.JSON_CREATOR)),
    installed
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    installedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    paidAppHasTrial
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    approvalStatusModifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    smartReceiptText
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    smartReceiptUrl
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billingStartTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    billingInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AppBillingInfo.JSON_CREATOR)),
    appSecret
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessTypes
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.BusinessType.JSON_CREATOR)),
    deviceTypes
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.apps.DeviceType.JSON_CREATOR)),
    modules
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.merchant.Module.JSON_CREATOR)),
    taxClassificationCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    applicationId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    nonCloverBilling
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    equipmentCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    equipmentName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    firstPublishedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    firstApprovalTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    firstSubmittedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    appBundle
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    editorPick
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    popularity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    allowUninstall
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    charge
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    linkLabel
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    categories
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    partnerId
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    locales
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    rejectionReason
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    aggregateRating
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.AggregateRating.JSON_CREATOR)),
    trialDays
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    trialDaysLeft
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    isHipaaCompliant
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    merchantsPlanIdsExclusion
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.Long.class)),
    resellersUuidsExclusion
        (com.clover.sdk.extractors.BasicListExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<App> genClient;

  /**
   * Constructs a new empty instance.
   */
  public App() {
    genClient = new GenericClient<App>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected App(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public App(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public App(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public App(App src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.description, getDescription(), 2000);

    genClient.validateLength(CacheKey.tagline, getTagline(), 255);

    genClient.validateLength(CacheKey.videoUrl, getVideoUrl(), 255);

    genClient.validateLength(CacheKey.activationUrl, getActivationUrl(), 255);

    genClient.validateLength(CacheKey.siteUrl, getSiteUrl(), 255);

    genClient.validateLength(CacheKey.appDomain, getAppDomain(), 255);

    genClient.validateLength(CacheKey.packageName, getPackageName(), 255);

    genClient.validateLength(CacheKey.filenameIcon, getFilenameIcon(), 255);

    genClient.validateLength(CacheKey.filenameIconSmall, getFilenameIconSmall(), 255);

    genClient.validateLength(CacheKey.filenameIconLarge, getFilenameIconLarge(), 255);

    genClient.validateLength(CacheKey.filenameCover, getFilenameCover(), 255);

    genClient.validateLength(CacheKey.filenameBanner, getFilenameBanner(), 255);

    genClient.validateLength(CacheKey.privacyPolicy, getPrivacyPolicy(), 255);

    genClient.validateLength(CacheKey.eula, getEula(), 255);

    genClient.validateLength(CacheKey.supportPhone, getSupportPhone(), 25);

    genClient.validateLength(CacheKey.supportPhoneHours, getSupportPhoneHours(), 127);

    genClient.validateLength(CacheKey.supportEmail, getSupportEmail(), 127);

    genClient.validateLength(CacheKey.supportUrl, getSupportUrl(), 255);

    genClient.validateLength(CacheKey.smartReceiptText, getSmartReceiptText(), 100);

    genClient.validateLength(CacheKey.smartReceiptUrl, getSmartReceiptUrl(), 255);

    genClient.validateLength(CacheKey.appSecret, getAppSecret(), 255);

    genClient.validateLength(CacheKey.rejectionReason, getRejectionReason(), 2000);
    genClient.validateReferences(CacheKey.revisions);
    genClient.validateReferences(CacheKey.appBundle);
    genClient.validateReferences(CacheKey.categories);
    genClient.validateReferences(CacheKey.locales);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'published' field is set and is not null */
  public boolean isNotNullPublished() {
    return genClient.cacheValueIsNotNull(CacheKey.published);
  }

  /** Checks whether the 'developer' field is set and is not null */
  public boolean isNotNullDeveloper() {
    return genClient.cacheValueIsNotNull(CacheKey.developer);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'tagline' field is set and is not null */
  public boolean isNotNullTagline() {
    return genClient.cacheValueIsNotNull(CacheKey.tagline);
  }

  /** Checks whether the 'benefits' field is set and is not null */
  public boolean isNotNullBenefits() {
    return genClient.cacheValueIsNotNull(CacheKey.benefits);
  }

  /** Checks whether the 'benefits' field is set and is not null and is not empty */
  public boolean isNotEmptyBenefits() { return isNotNullBenefits() && !getBenefits().isEmpty(); }

  /** Checks whether the 'videoUrl' field is set and is not null */
  public boolean isNotNullVideoUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.videoUrl);
  }

  /** Checks whether the 'activationUrl' field is set and is not null */
  public boolean isNotNullActivationUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.activationUrl);
  }

  /** Checks whether the 'siteUrl' field is set and is not null */
  public boolean isNotNullSiteUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.siteUrl);
  }

  /** Checks whether the 'defaultResponseType' field is set and is not null */
  public boolean isNotNullDefaultResponseType() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultResponseType);
  }

  /** Checks whether the 'appDomain' field is set and is not null */
  public boolean isNotNullAppDomain() {
    return genClient.cacheValueIsNotNull(CacheKey.appDomain);
  }

  /** Checks whether the 'androidVersion' field is set and is not null */
  public boolean isNotNullAndroidVersion() {
    return genClient.cacheValueIsNotNull(CacheKey.androidVersion);
  }

  /** Checks whether the 'packageName' field is set and is not null */
  public boolean isNotNullPackageName() {
    return genClient.cacheValueIsNotNull(CacheKey.packageName);
  }

  /** Checks whether the 'approved' field is set and is not null */
  public boolean isNotNullApproved() {
    return genClient.cacheValueIsNotNull(CacheKey.approved);
  }

  /** Checks whether the 'systemApp' field is set and is not null */
  public boolean isNotNullSystemApp() {
    return genClient.cacheValueIsNotNull(CacheKey.systemApp);
  }

  /** Checks whether the 'hidden' field is set and is not null */
  public boolean isNotNullHidden() {
    return genClient.cacheValueIsNotNull(CacheKey.hidden);
  }

  /** Checks whether the 'distribution' field is set and is not null */
  public boolean isNotNullDistribution() {
    return genClient.cacheValueIsNotNull(CacheKey.distribution);
  }

  /** Checks whether the 'filenameIcon' field is set and is not null */
  public boolean isNotNullFilenameIcon() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameIcon);
  }

  /** Checks whether the 'filenameIconSmall' field is set and is not null */
  public boolean isNotNullFilenameIconSmall() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameIconSmall);
  }

  /** Checks whether the 'filenameIconLarge' field is set and is not null */
  public boolean isNotNullFilenameIconLarge() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameIconLarge);
  }

  /** Checks whether the 'filenameCover' field is set and is not null */
  public boolean isNotNullFilenameCover() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameCover);
  }

  /** Checks whether the 'filenameBanner' field is set and is not null */
  public boolean isNotNullFilenameBanner() {
    return genClient.cacheValueIsNotNull(CacheKey.filenameBanner);
  }

  /** Checks whether the 'installCount' field is set and is not null */
  public boolean isNotNullInstallCount() {
    return genClient.cacheValueIsNotNull(CacheKey.installCount);
  }

  /** Checks whether the 'sortOrder' field is set and is not null */
  public boolean isNotNullSortOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.sortOrder);
  }

  /** Checks whether the 'permissionMerchantRead' field is set and is not null */
  public boolean isNotNullPermissionMerchantRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionMerchantRead);
  }

  /** Checks whether the 'permissionMerchantWrite' field is set and is not null */
  public boolean isNotNullPermissionMerchantWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionMerchantWrite);
  }

  /** Checks whether the 'permissionCustomersRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersRead);
  }

  /** Checks whether the 'permissionCustomersWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersWrite);
  }

  /** Checks whether the 'permissionInventoryRead' field is set and is not null */
  public boolean isNotNullPermissionInventoryRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionInventoryRead);
  }

  /** Checks whether the 'permissionInventoryWrite' field is set and is not null */
  public boolean isNotNullPermissionInventoryWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionInventoryWrite);
  }

  /** Checks whether the 'permissionOrdersRead' field is set and is not null */
  public boolean isNotNullPermissionOrdersRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionOrdersRead);
  }

  /** Checks whether the 'permissionOrdersWrite' field is set and is not null */
  public boolean isNotNullPermissionOrdersWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionOrdersWrite);
  }

  /** Checks whether the 'permissionPaymentsRead' field is set and is not null */
  public boolean isNotNullPermissionPaymentsRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionPaymentsRead);
  }

  /** Checks whether the 'permissionPaymentsWrite' field is set and is not null */
  public boolean isNotNullPermissionPaymentsWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionPaymentsWrite);
  }

  /** Checks whether the 'permissionEmployeesRead' field is set and is not null */
  public boolean isNotNullPermissionEmployeesRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionEmployeesRead);
  }

  /** Checks whether the 'permissionEmployeesWrite' field is set and is not null */
  public boolean isNotNullPermissionEmployeesWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionEmployeesWrite);
  }

  /** Checks whether the 'permissionProcessCards' field is set and is not null */
  public boolean isNotNullPermissionProcessCards() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionProcessCards);
  }

  /** Checks whether the 'permissionMidRead' field is set and is not null */
  public boolean isNotNullPermissionMidRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionMidRead);
  }

  /** Checks whether the 'permissionCustomersAddressRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersAddressRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersAddressRead);
  }

  /** Checks whether the 'permissionCustomersAddressWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersAddressWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersAddressWrite);
  }

  /** Checks whether the 'permissionCustomersBirthdateRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersBirthdateRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersBirthdateRead);
  }

  /** Checks whether the 'permissionCustomersBirthdateWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersBirthdateWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersBirthdateWrite);
  }

  /** Checks whether the 'permissionCustomersBusinessnameRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersBusinessnameRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersBusinessnameRead);
  }

  /** Checks whether the 'permissionCustomersBusinessnameWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersBusinessnameWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersBusinessnameWrite);
  }

  /** Checks whether the 'permissionCustomersCardRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersCardRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersCardRead);
  }

  /** Checks whether the 'permissionCustomersCardWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersCardWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersCardWrite);
  }

  /** Checks whether the 'permissionCustomersEmailRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersEmailRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersEmailRead);
  }

  /** Checks whether the 'permissionCustomersEmailWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersEmailWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersEmailWrite);
  }

  /** Checks whether the 'permissionCustomersNoteRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersNoteRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersNoteRead);
  }

  /** Checks whether the 'permissionCustomersNoteWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersNoteWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersNoteWrite);
  }

  /** Checks whether the 'permissionCustomersPhoneRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersPhoneRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersPhoneRead);
  }

  /** Checks whether the 'permissionCustomersPhoneWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersPhoneWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersPhoneWrite);
  }

  /** Checks whether the 'permissionCustomersMarketingRead' field is set and is not null */
  public boolean isNotNullPermissionCustomersMarketingRead() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersMarketingRead);
  }

  /** Checks whether the 'permissionCustomersMarketingWrite' field is set and is not null */
  public boolean isNotNullPermissionCustomersMarketingWrite() {
    return genClient.cacheValueIsNotNull(CacheKey.permissionCustomersMarketingWrite);
  }

  /** Checks whether the 'privacyPolicy' field is set and is not null */
  public boolean isNotNullPrivacyPolicy() {
    return genClient.cacheValueIsNotNull(CacheKey.privacyPolicy);
  }

  /** Checks whether the 'eula' field is set and is not null */
  public boolean isNotNullEula() {
    return genClient.cacheValueIsNotNull(CacheKey.eula);
  }

  /** Checks whether the 'supportPhone' field is set and is not null */
  public boolean isNotNullSupportPhone() {
    return genClient.cacheValueIsNotNull(CacheKey.supportPhone);
  }

  /** Checks whether the 'supportPhoneHours' field is set and is not null */
  public boolean isNotNullSupportPhoneHours() {
    return genClient.cacheValueIsNotNull(CacheKey.supportPhoneHours);
  }

  /** Checks whether the 'supportEmail' field is set and is not null */
  public boolean isNotNullSupportEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.supportEmail);
  }

  /** Checks whether the 'supportUrl' field is set and is not null */
  public boolean isNotNullSupportUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.supportUrl);
  }

  /** Checks whether the 'productType' field is set and is not null */
  public boolean isNotNullProductType() {
    return genClient.cacheValueIsNotNull(CacheKey.productType);
  }

  /** Checks whether the 'approvalStatus' field is set and is not null */
  public boolean isNotNullApprovalStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.approvalStatus);
  }

  /** Checks whether the 'androidPermissions' field is set and is not null */
  public boolean isNotNullAndroidPermissions() {
    return genClient.cacheValueIsNotNull(CacheKey.androidPermissions);
  }

  /** Checks whether the 'androidPermissions' field is set and is not null and is not empty */
  public boolean isNotEmptyAndroidPermissions() { return isNotNullAndroidPermissions() && !getAndroidPermissions().isEmpty(); }

  /** Checks whether the 'screenshots' field is set and is not null */
  public boolean isNotNullScreenshots() {
    return genClient.cacheValueIsNotNull(CacheKey.screenshots);
  }

  /** Checks whether the 'screenshots' field is set and is not null and is not empty */
  public boolean isNotEmptyScreenshots() { return isNotNullScreenshots() && !getScreenshots().isEmpty(); }

  /** Checks whether the 'availableSubscriptions' field is set and is not null */
  public boolean isNotNullAvailableSubscriptions() {
    return genClient.cacheValueIsNotNull(CacheKey.availableSubscriptions);
  }

  /** Checks whether the 'availableSubscriptions' field is set and is not null and is not empty */
  public boolean isNotEmptyAvailableSubscriptions() { return isNotNullAvailableSubscriptions() && !getAvailableSubscriptions().isEmpty(); }

  /** Checks whether the 'subscriptions' field is set and is not null */
  public boolean isNotNullSubscriptions() {
    return genClient.cacheValueIsNotNull(CacheKey.subscriptions);
  }

  /** Checks whether the 'subscriptions' field is set and is not null and is not empty */
  public boolean isNotEmptySubscriptions() { return isNotNullSubscriptions() && !getSubscriptions().isEmpty(); }

  /** Checks whether the 'revisions' field is set and is not null */
  public boolean isNotNullRevisions() {
    return genClient.cacheValueIsNotNull(CacheKey.revisions);
  }

  /** Checks whether the 'revisions' field is set and is not null and is not empty */
  public boolean isNotEmptyRevisions() { return isNotNullRevisions() && !getRevisions().isEmpty(); }

  /** Checks whether the 'availableMetereds' field is set and is not null */
  public boolean isNotNullAvailableMetereds() {
    return genClient.cacheValueIsNotNull(CacheKey.availableMetereds);
  }

  /** Checks whether the 'availableMetereds' field is set and is not null and is not empty */
  public boolean isNotEmptyAvailableMetereds() { return isNotNullAvailableMetereds() && !getAvailableMetereds().isEmpty(); }

  /** Checks whether the 'metereds' field is set and is not null */
  public boolean isNotNullMetereds() {
    return genClient.cacheValueIsNotNull(CacheKey.metereds);
  }

  /** Checks whether the 'metereds' field is set and is not null and is not empty */
  public boolean isNotEmptyMetereds() { return isNotNullMetereds() && !getMetereds().isEmpty(); }

  /** Checks whether the 'usbDevices' field is set and is not null */
  public boolean isNotNullUsbDevices() {
    return genClient.cacheValueIsNotNull(CacheKey.usbDevices);
  }

  /** Checks whether the 'usbDevices' field is set and is not null and is not empty */
  public boolean isNotEmptyUsbDevices() { return isNotNullUsbDevices() && !getUsbDevices().isEmpty(); }

  /** Checks whether the 'isMerchantInTrial' field is set and is not null */
  public boolean isNotNullIsMerchantInTrial() {
    return genClient.cacheValueIsNotNull(CacheKey.isMerchantInTrial);
  }

  /** Checks whether the 'currentSubscription' field is set and is not null */
  public boolean isNotNullCurrentSubscription() {
    return genClient.cacheValueIsNotNull(CacheKey.currentSubscription);
  }

  /** Checks whether the 'webhook' field is set and is not null */
  public boolean isNotNullWebhook() {
    return genClient.cacheValueIsNotNull(CacheKey.webhook);
  }

  /** Checks whether the 'androidVersions' field is set and is not null */
  public boolean isNotNullAndroidVersions() {
    return genClient.cacheValueIsNotNull(CacheKey.androidVersions);
  }

  /** Checks whether the 'androidVersions' field is set and is not null and is not empty */
  public boolean isNotEmptyAndroidVersions() { return isNotNullAndroidVersions() && !getAndroidVersions().isEmpty(); }

  /** Checks whether the 'installed' field is set and is not null */
  public boolean isNotNullInstalled() {
    return genClient.cacheValueIsNotNull(CacheKey.installed);
  }

  /** Checks whether the 'installedTime' field is set and is not null */
  public boolean isNotNullInstalledTime() {
    return genClient.cacheValueIsNotNull(CacheKey.installedTime);
  }

  /** Checks whether the 'paidAppHasTrial' field is set and is not null */
  public boolean isNotNullPaidAppHasTrial() {
    return genClient.cacheValueIsNotNull(CacheKey.paidAppHasTrial);
  }

  /** Checks whether the 'approvalStatusModifiedTime' field is set and is not null */
  public boolean isNotNullApprovalStatusModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.approvalStatusModifiedTime);
  }

  /** Checks whether the 'smartReceiptText' field is set and is not null */
  public boolean isNotNullSmartReceiptText() {
    return genClient.cacheValueIsNotNull(CacheKey.smartReceiptText);
  }

  /** Checks whether the 'smartReceiptUrl' field is set and is not null */
  public boolean isNotNullSmartReceiptUrl() {
    return genClient.cacheValueIsNotNull(CacheKey.smartReceiptUrl);
  }

  /** Checks whether the 'billingStartTime' field is set and is not null */
  public boolean isNotNullBillingStartTime() {
    return genClient.cacheValueIsNotNull(CacheKey.billingStartTime);
  }

  /** Checks whether the 'billingInfo' field is set and is not null */
  public boolean isNotNullBillingInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.billingInfo);
  }

  /** Checks whether the 'appSecret' field is set and is not null */
  public boolean isNotNullAppSecret() {
    return genClient.cacheValueIsNotNull(CacheKey.appSecret);
  }

  /** Checks whether the 'businessTypes' field is set and is not null */
  public boolean isNotNullBusinessTypes() {
    return genClient.cacheValueIsNotNull(CacheKey.businessTypes);
  }

  /** Checks whether the 'businessTypes' field is set and is not null and is not empty */
  public boolean isNotEmptyBusinessTypes() { return isNotNullBusinessTypes() && !getBusinessTypes().isEmpty(); }

  /** Checks whether the 'deviceTypes' field is set and is not null */
  public boolean isNotNullDeviceTypes() {
    return genClient.cacheValueIsNotNull(CacheKey.deviceTypes);
  }

  /** Checks whether the 'deviceTypes' field is set and is not null and is not empty */
  public boolean isNotEmptyDeviceTypes() { return isNotNullDeviceTypes() && !getDeviceTypes().isEmpty(); }

  /** Checks whether the 'modules' field is set and is not null */
  public boolean isNotNullModules() {
    return genClient.cacheValueIsNotNull(CacheKey.modules);
  }

  /** Checks whether the 'modules' field is set and is not null and is not empty */
  public boolean isNotEmptyModules() { return isNotNullModules() && !getModules().isEmpty(); }

  /** Checks whether the 'taxClassificationCode' field is set and is not null */
  public boolean isNotNullTaxClassificationCode() {
    return genClient.cacheValueIsNotNull(CacheKey.taxClassificationCode);
  }

  /** Checks whether the 'applicationId' field is set and is not null */
  public boolean isNotNullApplicationId() {
    return genClient.cacheValueIsNotNull(CacheKey.applicationId);
  }

  /** Checks whether the 'nonCloverBilling' field is set and is not null */
  public boolean isNotNullNonCloverBilling() {
    return genClient.cacheValueIsNotNull(CacheKey.nonCloverBilling);
  }

  /** Checks whether the 'equipmentCode' field is set and is not null */
  public boolean isNotNullEquipmentCode() {
    return genClient.cacheValueIsNotNull(CacheKey.equipmentCode);
  }

  /** Checks whether the 'equipmentName' field is set and is not null */
  public boolean isNotNullEquipmentName() {
    return genClient.cacheValueIsNotNull(CacheKey.equipmentName);
  }

  /** Checks whether the 'firstPublishedTime' field is set and is not null */
  public boolean isNotNullFirstPublishedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstPublishedTime);
  }

  /** Checks whether the 'firstApprovalTime' field is set and is not null */
  public boolean isNotNullFirstApprovalTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstApprovalTime);
  }

  /** Checks whether the 'firstSubmittedTime' field is set and is not null */
  public boolean isNotNullFirstSubmittedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstSubmittedTime);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'appBundle' field is set and is not null */
  public boolean isNotNullAppBundle() {
    return genClient.cacheValueIsNotNull(CacheKey.appBundle);
  }

  /** Checks whether the 'editorPick' field is set and is not null */
  public boolean isNotNullEditorPick() {
    return genClient.cacheValueIsNotNull(CacheKey.editorPick);
  }

  /** Checks whether the 'popularity' field is set and is not null */
  public boolean isNotNullPopularity() {
    return genClient.cacheValueIsNotNull(CacheKey.popularity);
  }

  /** Checks whether the 'allowUninstall' field is set and is not null */
  public boolean isNotNullAllowUninstall() {
    return genClient.cacheValueIsNotNull(CacheKey.allowUninstall);
  }

  /** Checks whether the 'charge' field is set and is not null */
  public boolean isNotNullCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.charge);
  }

  /** Checks whether the 'linkLabel' field is set and is not null */
  public boolean isNotNullLinkLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.linkLabel);
  }

  /** Checks whether the 'categories' field is set and is not null */
  public boolean isNotNullCategories() {
    return genClient.cacheValueIsNotNull(CacheKey.categories);
  }

  /** Checks whether the 'categories' field is set and is not null and is not empty */
  public boolean isNotEmptyCategories() { return isNotNullCategories() && !getCategories().isEmpty(); }

  /** Checks whether the 'partnerId' field is set and is not null */
  public boolean isNotNullPartnerId() {
    return genClient.cacheValueIsNotNull(CacheKey.partnerId);
  }

  /** Checks whether the 'locales' field is set and is not null */
  public boolean isNotNullLocales() {
    return genClient.cacheValueIsNotNull(CacheKey.locales);
  }

  /** Checks whether the 'locales' field is set and is not null and is not empty */
  public boolean isNotEmptyLocales() { return isNotNullLocales() && !getLocales().isEmpty(); }

  /** Checks whether the 'rejectionReason' field is set and is not null */
  public boolean isNotNullRejectionReason() {
    return genClient.cacheValueIsNotNull(CacheKey.rejectionReason);
  }

  /** Checks whether the 'aggregateRating' field is set and is not null */
  public boolean isNotNullAggregateRating() {
    return genClient.cacheValueIsNotNull(CacheKey.aggregateRating);
  }

  /** Checks whether the 'trialDays' field is set and is not null */
  public boolean isNotNullTrialDays() {
    return genClient.cacheValueIsNotNull(CacheKey.trialDays);
  }

  /** Checks whether the 'trialDaysLeft' field is set and is not null */
  public boolean isNotNullTrialDaysLeft() {
    return genClient.cacheValueIsNotNull(CacheKey.trialDaysLeft);
  }

  /** Checks whether the 'isHipaaCompliant' field is set and is not null */
  public boolean isNotNullIsHipaaCompliant() {
    return genClient.cacheValueIsNotNull(CacheKey.isHipaaCompliant);
  }

  /** Checks whether the 'merchantsPlanIdsExclusion' field is set and is not null */
  public boolean isNotNullMerchantsPlanIdsExclusion() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantsPlanIdsExclusion);
  }

  /** Checks whether the 'merchantsPlanIdsExclusion' field is set and is not null and is not empty */
  public boolean isNotEmptyMerchantsPlanIdsExclusion() { return isNotNullMerchantsPlanIdsExclusion() && !getMerchantsPlanIdsExclusion().isEmpty(); }

  /** Checks whether the 'resellersUuidsExclusion' field is set and is not null */
  public boolean isNotNullResellersUuidsExclusion() {
    return genClient.cacheValueIsNotNull(CacheKey.resellersUuidsExclusion);
  }

  /** Checks whether the 'resellersUuidsExclusion' field is set and is not null and is not empty */
  public boolean isNotEmptyResellersUuidsExclusion() { return isNotNullResellersUuidsExclusion() && !getResellersUuidsExclusion().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'published' field has been set, however the value could be null */
  public boolean hasPublished() {
    return genClient.cacheHasKey(CacheKey.published);
  }

  /** Checks whether the 'developer' field has been set, however the value could be null */
  public boolean hasDeveloper() {
    return genClient.cacheHasKey(CacheKey.developer);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'tagline' field has been set, however the value could be null */
  public boolean hasTagline() {
    return genClient.cacheHasKey(CacheKey.tagline);
  }

  /** Checks whether the 'benefits' field has been set, however the value could be null */
  public boolean hasBenefits() {
    return genClient.cacheHasKey(CacheKey.benefits);
  }

  /** Checks whether the 'videoUrl' field has been set, however the value could be null */
  public boolean hasVideoUrl() {
    return genClient.cacheHasKey(CacheKey.videoUrl);
  }

  /** Checks whether the 'activationUrl' field has been set, however the value could be null */
  public boolean hasActivationUrl() {
    return genClient.cacheHasKey(CacheKey.activationUrl);
  }

  /** Checks whether the 'siteUrl' field has been set, however the value could be null */
  public boolean hasSiteUrl() {
    return genClient.cacheHasKey(CacheKey.siteUrl);
  }

  /** Checks whether the 'defaultResponseType' field has been set, however the value could be null */
  public boolean hasDefaultResponseType() {
    return genClient.cacheHasKey(CacheKey.defaultResponseType);
  }

  /** Checks whether the 'appDomain' field has been set, however the value could be null */
  public boolean hasAppDomain() {
    return genClient.cacheHasKey(CacheKey.appDomain);
  }

  /** Checks whether the 'androidVersion' field has been set, however the value could be null */
  public boolean hasAndroidVersion() {
    return genClient.cacheHasKey(CacheKey.androidVersion);
  }

  /** Checks whether the 'packageName' field has been set, however the value could be null */
  public boolean hasPackageName() {
    return genClient.cacheHasKey(CacheKey.packageName);
  }

  /** Checks whether the 'approved' field has been set, however the value could be null */
  public boolean hasApproved() {
    return genClient.cacheHasKey(CacheKey.approved);
  }

  /** Checks whether the 'systemApp' field has been set, however the value could be null */
  public boolean hasSystemApp() {
    return genClient.cacheHasKey(CacheKey.systemApp);
  }

  /** Checks whether the 'hidden' field has been set, however the value could be null */
  public boolean hasHidden() {
    return genClient.cacheHasKey(CacheKey.hidden);
  }

  /** Checks whether the 'distribution' field has been set, however the value could be null */
  public boolean hasDistribution() {
    return genClient.cacheHasKey(CacheKey.distribution);
  }

  /** Checks whether the 'filenameIcon' field has been set, however the value could be null */
  public boolean hasFilenameIcon() {
    return genClient.cacheHasKey(CacheKey.filenameIcon);
  }

  /** Checks whether the 'filenameIconSmall' field has been set, however the value could be null */
  public boolean hasFilenameIconSmall() {
    return genClient.cacheHasKey(CacheKey.filenameIconSmall);
  }

  /** Checks whether the 'filenameIconLarge' field has been set, however the value could be null */
  public boolean hasFilenameIconLarge() {
    return genClient.cacheHasKey(CacheKey.filenameIconLarge);
  }

  /** Checks whether the 'filenameCover' field has been set, however the value could be null */
  public boolean hasFilenameCover() {
    return genClient.cacheHasKey(CacheKey.filenameCover);
  }

  /** Checks whether the 'filenameBanner' field has been set, however the value could be null */
  public boolean hasFilenameBanner() {
    return genClient.cacheHasKey(CacheKey.filenameBanner);
  }

  /** Checks whether the 'installCount' field has been set, however the value could be null */
  public boolean hasInstallCount() {
    return genClient.cacheHasKey(CacheKey.installCount);
  }

  /** Checks whether the 'sortOrder' field has been set, however the value could be null */
  public boolean hasSortOrder() {
    return genClient.cacheHasKey(CacheKey.sortOrder);
  }

  /** Checks whether the 'permissionMerchantRead' field has been set, however the value could be null */
  public boolean hasPermissionMerchantRead() {
    return genClient.cacheHasKey(CacheKey.permissionMerchantRead);
  }

  /** Checks whether the 'permissionMerchantWrite' field has been set, however the value could be null */
  public boolean hasPermissionMerchantWrite() {
    return genClient.cacheHasKey(CacheKey.permissionMerchantWrite);
  }

  /** Checks whether the 'permissionCustomersRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersRead);
  }

  /** Checks whether the 'permissionCustomersWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersWrite);
  }

  /** Checks whether the 'permissionInventoryRead' field has been set, however the value could be null */
  public boolean hasPermissionInventoryRead() {
    return genClient.cacheHasKey(CacheKey.permissionInventoryRead);
  }

  /** Checks whether the 'permissionInventoryWrite' field has been set, however the value could be null */
  public boolean hasPermissionInventoryWrite() {
    return genClient.cacheHasKey(CacheKey.permissionInventoryWrite);
  }

  /** Checks whether the 'permissionOrdersRead' field has been set, however the value could be null */
  public boolean hasPermissionOrdersRead() {
    return genClient.cacheHasKey(CacheKey.permissionOrdersRead);
  }

  /** Checks whether the 'permissionOrdersWrite' field has been set, however the value could be null */
  public boolean hasPermissionOrdersWrite() {
    return genClient.cacheHasKey(CacheKey.permissionOrdersWrite);
  }

  /** Checks whether the 'permissionPaymentsRead' field has been set, however the value could be null */
  public boolean hasPermissionPaymentsRead() {
    return genClient.cacheHasKey(CacheKey.permissionPaymentsRead);
  }

  /** Checks whether the 'permissionPaymentsWrite' field has been set, however the value could be null */
  public boolean hasPermissionPaymentsWrite() {
    return genClient.cacheHasKey(CacheKey.permissionPaymentsWrite);
  }

  /** Checks whether the 'permissionEmployeesRead' field has been set, however the value could be null */
  public boolean hasPermissionEmployeesRead() {
    return genClient.cacheHasKey(CacheKey.permissionEmployeesRead);
  }

  /** Checks whether the 'permissionEmployeesWrite' field has been set, however the value could be null */
  public boolean hasPermissionEmployeesWrite() {
    return genClient.cacheHasKey(CacheKey.permissionEmployeesWrite);
  }

  /** Checks whether the 'permissionProcessCards' field has been set, however the value could be null */
  public boolean hasPermissionProcessCards() {
    return genClient.cacheHasKey(CacheKey.permissionProcessCards);
  }

  /** Checks whether the 'permissionMidRead' field has been set, however the value could be null */
  public boolean hasPermissionMidRead() {
    return genClient.cacheHasKey(CacheKey.permissionMidRead);
  }

  /** Checks whether the 'permissionCustomersAddressRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersAddressRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersAddressRead);
  }

  /** Checks whether the 'permissionCustomersAddressWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersAddressWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersAddressWrite);
  }

  /** Checks whether the 'permissionCustomersBirthdateRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersBirthdateRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersBirthdateRead);
  }

  /** Checks whether the 'permissionCustomersBirthdateWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersBirthdateWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersBirthdateWrite);
  }

  /** Checks whether the 'permissionCustomersBusinessnameRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersBusinessnameRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersBusinessnameRead);
  }

  /** Checks whether the 'permissionCustomersBusinessnameWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersBusinessnameWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersBusinessnameWrite);
  }

  /** Checks whether the 'permissionCustomersCardRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersCardRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersCardRead);
  }

  /** Checks whether the 'permissionCustomersCardWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersCardWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersCardWrite);
  }

  /** Checks whether the 'permissionCustomersEmailRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersEmailRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersEmailRead);
  }

  /** Checks whether the 'permissionCustomersEmailWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersEmailWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersEmailWrite);
  }

  /** Checks whether the 'permissionCustomersNoteRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersNoteRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersNoteRead);
  }

  /** Checks whether the 'permissionCustomersNoteWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersNoteWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersNoteWrite);
  }

  /** Checks whether the 'permissionCustomersPhoneRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersPhoneRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersPhoneRead);
  }

  /** Checks whether the 'permissionCustomersPhoneWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersPhoneWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersPhoneWrite);
  }

  /** Checks whether the 'permissionCustomersMarketingRead' field has been set, however the value could be null */
  public boolean hasPermissionCustomersMarketingRead() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersMarketingRead);
  }

  /** Checks whether the 'permissionCustomersMarketingWrite' field has been set, however the value could be null */
  public boolean hasPermissionCustomersMarketingWrite() {
    return genClient.cacheHasKey(CacheKey.permissionCustomersMarketingWrite);
  }

  /** Checks whether the 'privacyPolicy' field has been set, however the value could be null */
  public boolean hasPrivacyPolicy() {
    return genClient.cacheHasKey(CacheKey.privacyPolicy);
  }

  /** Checks whether the 'eula' field has been set, however the value could be null */
  public boolean hasEula() {
    return genClient.cacheHasKey(CacheKey.eula);
  }

  /** Checks whether the 'supportPhone' field has been set, however the value could be null */
  public boolean hasSupportPhone() {
    return genClient.cacheHasKey(CacheKey.supportPhone);
  }

  /** Checks whether the 'supportPhoneHours' field has been set, however the value could be null */
  public boolean hasSupportPhoneHours() {
    return genClient.cacheHasKey(CacheKey.supportPhoneHours);
  }

  /** Checks whether the 'supportEmail' field has been set, however the value could be null */
  public boolean hasSupportEmail() {
    return genClient.cacheHasKey(CacheKey.supportEmail);
  }

  /** Checks whether the 'supportUrl' field has been set, however the value could be null */
  public boolean hasSupportUrl() {
    return genClient.cacheHasKey(CacheKey.supportUrl);
  }

  /** Checks whether the 'productType' field has been set, however the value could be null */
  public boolean hasProductType() {
    return genClient.cacheHasKey(CacheKey.productType);
  }

  /** Checks whether the 'approvalStatus' field has been set, however the value could be null */
  public boolean hasApprovalStatus() {
    return genClient.cacheHasKey(CacheKey.approvalStatus);
  }

  /** Checks whether the 'androidPermissions' field has been set, however the value could be null */
  public boolean hasAndroidPermissions() {
    return genClient.cacheHasKey(CacheKey.androidPermissions);
  }

  /** Checks whether the 'screenshots' field has been set, however the value could be null */
  public boolean hasScreenshots() {
    return genClient.cacheHasKey(CacheKey.screenshots);
  }

  /** Checks whether the 'availableSubscriptions' field has been set, however the value could be null */
  public boolean hasAvailableSubscriptions() {
    return genClient.cacheHasKey(CacheKey.availableSubscriptions);
  }

  /** Checks whether the 'subscriptions' field has been set, however the value could be null */
  public boolean hasSubscriptions() {
    return genClient.cacheHasKey(CacheKey.subscriptions);
  }

  /** Checks whether the 'revisions' field has been set, however the value could be null */
  public boolean hasRevisions() {
    return genClient.cacheHasKey(CacheKey.revisions);
  }

  /** Checks whether the 'availableMetereds' field has been set, however the value could be null */
  public boolean hasAvailableMetereds() {
    return genClient.cacheHasKey(CacheKey.availableMetereds);
  }

  /** Checks whether the 'metereds' field has been set, however the value could be null */
  public boolean hasMetereds() {
    return genClient.cacheHasKey(CacheKey.metereds);
  }

  /** Checks whether the 'usbDevices' field has been set, however the value could be null */
  public boolean hasUsbDevices() {
    return genClient.cacheHasKey(CacheKey.usbDevices);
  }

  /** Checks whether the 'isMerchantInTrial' field has been set, however the value could be null */
  public boolean hasIsMerchantInTrial() {
    return genClient.cacheHasKey(CacheKey.isMerchantInTrial);
  }

  /** Checks whether the 'currentSubscription' field has been set, however the value could be null */
  public boolean hasCurrentSubscription() {
    return genClient.cacheHasKey(CacheKey.currentSubscription);
  }

  /** Checks whether the 'webhook' field has been set, however the value could be null */
  public boolean hasWebhook() {
    return genClient.cacheHasKey(CacheKey.webhook);
  }

  /** Checks whether the 'androidVersions' field has been set, however the value could be null */
  public boolean hasAndroidVersions() {
    return genClient.cacheHasKey(CacheKey.androidVersions);
  }

  /** Checks whether the 'installed' field has been set, however the value could be null */
  public boolean hasInstalled() {
    return genClient.cacheHasKey(CacheKey.installed);
  }

  /** Checks whether the 'installedTime' field has been set, however the value could be null */
  public boolean hasInstalledTime() {
    return genClient.cacheHasKey(CacheKey.installedTime);
  }

  /** Checks whether the 'paidAppHasTrial' field has been set, however the value could be null */
  public boolean hasPaidAppHasTrial() {
    return genClient.cacheHasKey(CacheKey.paidAppHasTrial);
  }

  /** Checks whether the 'approvalStatusModifiedTime' field has been set, however the value could be null */
  public boolean hasApprovalStatusModifiedTime() {
    return genClient.cacheHasKey(CacheKey.approvalStatusModifiedTime);
  }

  /** Checks whether the 'smartReceiptText' field has been set, however the value could be null */
  public boolean hasSmartReceiptText() {
    return genClient.cacheHasKey(CacheKey.smartReceiptText);
  }

  /** Checks whether the 'smartReceiptUrl' field has been set, however the value could be null */
  public boolean hasSmartReceiptUrl() {
    return genClient.cacheHasKey(CacheKey.smartReceiptUrl);
  }

  /** Checks whether the 'billingStartTime' field has been set, however the value could be null */
  public boolean hasBillingStartTime() {
    return genClient.cacheHasKey(CacheKey.billingStartTime);
  }

  /** Checks whether the 'billingInfo' field has been set, however the value could be null */
  public boolean hasBillingInfo() {
    return genClient.cacheHasKey(CacheKey.billingInfo);
  }

  /** Checks whether the 'appSecret' field has been set, however the value could be null */
  public boolean hasAppSecret() {
    return genClient.cacheHasKey(CacheKey.appSecret);
  }

  /** Checks whether the 'businessTypes' field has been set, however the value could be null */
  public boolean hasBusinessTypes() {
    return genClient.cacheHasKey(CacheKey.businessTypes);
  }

  /** Checks whether the 'deviceTypes' field has been set, however the value could be null */
  public boolean hasDeviceTypes() {
    return genClient.cacheHasKey(CacheKey.deviceTypes);
  }

  /** Checks whether the 'modules' field has been set, however the value could be null */
  public boolean hasModules() {
    return genClient.cacheHasKey(CacheKey.modules);
  }

  /** Checks whether the 'taxClassificationCode' field has been set, however the value could be null */
  public boolean hasTaxClassificationCode() {
    return genClient.cacheHasKey(CacheKey.taxClassificationCode);
  }

  /** Checks whether the 'applicationId' field has been set, however the value could be null */
  public boolean hasApplicationId() {
    return genClient.cacheHasKey(CacheKey.applicationId);
  }

  /** Checks whether the 'nonCloverBilling' field has been set, however the value could be null */
  public boolean hasNonCloverBilling() {
    return genClient.cacheHasKey(CacheKey.nonCloverBilling);
  }

  /** Checks whether the 'equipmentCode' field has been set, however the value could be null */
  public boolean hasEquipmentCode() {
    return genClient.cacheHasKey(CacheKey.equipmentCode);
  }

  /** Checks whether the 'equipmentName' field has been set, however the value could be null */
  public boolean hasEquipmentName() {
    return genClient.cacheHasKey(CacheKey.equipmentName);
  }

  /** Checks whether the 'firstPublishedTime' field has been set, however the value could be null */
  public boolean hasFirstPublishedTime() {
    return genClient.cacheHasKey(CacheKey.firstPublishedTime);
  }

  /** Checks whether the 'firstApprovalTime' field has been set, however the value could be null */
  public boolean hasFirstApprovalTime() {
    return genClient.cacheHasKey(CacheKey.firstApprovalTime);
  }

  /** Checks whether the 'firstSubmittedTime' field has been set, however the value could be null */
  public boolean hasFirstSubmittedTime() {
    return genClient.cacheHasKey(CacheKey.firstSubmittedTime);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'appBundle' field has been set, however the value could be null */
  public boolean hasAppBundle() {
    return genClient.cacheHasKey(CacheKey.appBundle);
  }

  /** Checks whether the 'editorPick' field has been set, however the value could be null */
  public boolean hasEditorPick() {
    return genClient.cacheHasKey(CacheKey.editorPick);
  }

  /** Checks whether the 'popularity' field has been set, however the value could be null */
  public boolean hasPopularity() {
    return genClient.cacheHasKey(CacheKey.popularity);
  }

  /** Checks whether the 'allowUninstall' field has been set, however the value could be null */
  public boolean hasAllowUninstall() {
    return genClient.cacheHasKey(CacheKey.allowUninstall);
  }

  /** Checks whether the 'charge' field has been set, however the value could be null */
  public boolean hasCharge() {
    return genClient.cacheHasKey(CacheKey.charge);
  }

  /** Checks whether the 'linkLabel' field has been set, however the value could be null */
  public boolean hasLinkLabel() {
    return genClient.cacheHasKey(CacheKey.linkLabel);
  }

  /** Checks whether the 'categories' field has been set, however the value could be null */
  public boolean hasCategories() {
    return genClient.cacheHasKey(CacheKey.categories);
  }

  /** Checks whether the 'partnerId' field has been set, however the value could be null */
  public boolean hasPartnerId() {
    return genClient.cacheHasKey(CacheKey.partnerId);
  }

  /** Checks whether the 'locales' field has been set, however the value could be null */
  public boolean hasLocales() {
    return genClient.cacheHasKey(CacheKey.locales);
  }

  /** Checks whether the 'rejectionReason' field has been set, however the value could be null */
  public boolean hasRejectionReason() {
    return genClient.cacheHasKey(CacheKey.rejectionReason);
  }

  /** Checks whether the 'aggregateRating' field has been set, however the value could be null */
  public boolean hasAggregateRating() {
    return genClient.cacheHasKey(CacheKey.aggregateRating);
  }

  /** Checks whether the 'trialDays' field has been set, however the value could be null */
  public boolean hasTrialDays() {
    return genClient.cacheHasKey(CacheKey.trialDays);
  }

  /** Checks whether the 'trialDaysLeft' field has been set, however the value could be null */
  public boolean hasTrialDaysLeft() {
    return genClient.cacheHasKey(CacheKey.trialDaysLeft);
  }

  /** Checks whether the 'isHipaaCompliant' field has been set, however the value could be null */
  public boolean hasIsHipaaCompliant() {
    return genClient.cacheHasKey(CacheKey.isHipaaCompliant);
  }

  /** Checks whether the 'merchantsPlanIdsExclusion' field has been set, however the value could be null */
  public boolean hasMerchantsPlanIdsExclusion() {
    return genClient.cacheHasKey(CacheKey.merchantsPlanIdsExclusion);
  }

  /** Checks whether the 'resellersUuidsExclusion' field has been set, however the value could be null */
  public boolean hasResellersUuidsExclusion() {
    return genClient.cacheHasKey(CacheKey.resellersUuidsExclusion);
  }


  /**
   * Sets the field 'id'.
   */
  public App setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public App setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'published'.
   */
  public App setPublished(java.lang.Boolean published) {
    return genClient.setOther(published, CacheKey.published);
  }

  /**
   * Sets the field 'developer'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setDeveloper(com.clover.sdk.v3.developer.Developer developer) {
    return genClient.setRecord(developer, CacheKey.developer);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setMerchant(com.clover.sdk.v3.merchant.Merchant merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'description'.
   */
  public App setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'tagline'.
   */
  public App setTagline(java.lang.String tagline) {
    return genClient.setOther(tagline, CacheKey.tagline);
  }

  /**
   * Sets the field 'benefits'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setBenefits(java.util.List<java.lang.String> benefits) {
    return genClient.setArrayOther(benefits, CacheKey.benefits);
  }

  /**
   * Sets the field 'videoUrl'.
   */
  public App setVideoUrl(java.lang.String videoUrl) {
    return genClient.setOther(videoUrl, CacheKey.videoUrl);
  }

  /**
   * Sets the field 'activationUrl'.
   */
  public App setActivationUrl(java.lang.String activationUrl) {
    return genClient.setOther(activationUrl, CacheKey.activationUrl);
  }

  /**
   * Sets the field 'siteUrl'.
   */
  public App setSiteUrl(java.lang.String siteUrl) {
    return genClient.setOther(siteUrl, CacheKey.siteUrl);
  }

  /**
   * Sets the field 'defaultResponseType'.
   */
  public App setDefaultResponseType(com.clover.sdk.v3.apps.OAuthResponseType defaultResponseType) {
    return genClient.setOther(defaultResponseType, CacheKey.defaultResponseType);
  }

  /**
   * Sets the field 'appDomain'.
   */
  public App setAppDomain(java.lang.String appDomain) {
    return genClient.setOther(appDomain, CacheKey.appDomain);
  }

  /**
   * Sets the field 'androidVersion'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setAndroidVersion(com.clover.sdk.v3.apps.AndroidVersion androidVersion) {
    return genClient.setRecord(androidVersion, CacheKey.androidVersion);
  }

  /**
   * Sets the field 'packageName'.
   */
  public App setPackageName(java.lang.String packageName) {
    return genClient.setOther(packageName, CacheKey.packageName);
  }

  /**
   * Sets the field 'approved'.
   */
  public App setApproved(java.lang.Boolean approved) {
    return genClient.setOther(approved, CacheKey.approved);
  }

  /**
   * Sets the field 'systemApp'.
   */
  public App setSystemApp(java.lang.Boolean systemApp) {
    return genClient.setOther(systemApp, CacheKey.systemApp);
  }

  /**
   * Sets the field 'hidden'.
   */
  public App setHidden(java.lang.Boolean hidden) {
    return genClient.setOther(hidden, CacheKey.hidden);
  }

  /**
   * Sets the field 'distribution'.
   */
  public App setDistribution(com.clover.sdk.v3.apps.Distribution distribution) {
    return genClient.setOther(distribution, CacheKey.distribution);
  }

  /**
   * Sets the field 'filenameIcon'.
   */
  public App setFilenameIcon(java.lang.String filenameIcon) {
    return genClient.setOther(filenameIcon, CacheKey.filenameIcon);
  }

  /**
   * Sets the field 'filenameIconSmall'.
   */
  public App setFilenameIconSmall(java.lang.String filenameIconSmall) {
    return genClient.setOther(filenameIconSmall, CacheKey.filenameIconSmall);
  }

  /**
   * Sets the field 'filenameIconLarge'.
   */
  public App setFilenameIconLarge(java.lang.String filenameIconLarge) {
    return genClient.setOther(filenameIconLarge, CacheKey.filenameIconLarge);
  }

  /**
   * Sets the field 'filenameCover'.
   */
  public App setFilenameCover(java.lang.String filenameCover) {
    return genClient.setOther(filenameCover, CacheKey.filenameCover);
  }

  /**
   * Sets the field 'filenameBanner'.
   */
  public App setFilenameBanner(java.lang.String filenameBanner) {
    return genClient.setOther(filenameBanner, CacheKey.filenameBanner);
  }

  /**
   * Sets the field 'installCount'.
   */
  public App setInstallCount(java.lang.Long installCount) {
    return genClient.setOther(installCount, CacheKey.installCount);
  }

  /**
   * Sets the field 'sortOrder'.
   */
  public App setSortOrder(java.lang.Long sortOrder) {
    return genClient.setOther(sortOrder, CacheKey.sortOrder);
  }

  /**
   * Sets the field 'permissionMerchantRead'.
   */
  public App setPermissionMerchantRead(java.lang.Boolean permissionMerchantRead) {
    return genClient.setOther(permissionMerchantRead, CacheKey.permissionMerchantRead);
  }

  /**
   * Sets the field 'permissionMerchantWrite'.
   */
  public App setPermissionMerchantWrite(java.lang.Boolean permissionMerchantWrite) {
    return genClient.setOther(permissionMerchantWrite, CacheKey.permissionMerchantWrite);
  }

  /**
   * Sets the field 'permissionCustomersRead'.
   */
  public App setPermissionCustomersRead(java.lang.Boolean permissionCustomersRead) {
    return genClient.setOther(permissionCustomersRead, CacheKey.permissionCustomersRead);
  }

  /**
   * Sets the field 'permissionCustomersWrite'.
   */
  public App setPermissionCustomersWrite(java.lang.Boolean permissionCustomersWrite) {
    return genClient.setOther(permissionCustomersWrite, CacheKey.permissionCustomersWrite);
  }

  /**
   * Sets the field 'permissionInventoryRead'.
   */
  public App setPermissionInventoryRead(java.lang.Boolean permissionInventoryRead) {
    return genClient.setOther(permissionInventoryRead, CacheKey.permissionInventoryRead);
  }

  /**
   * Sets the field 'permissionInventoryWrite'.
   */
  public App setPermissionInventoryWrite(java.lang.Boolean permissionInventoryWrite) {
    return genClient.setOther(permissionInventoryWrite, CacheKey.permissionInventoryWrite);
  }

  /**
   * Sets the field 'permissionOrdersRead'.
   */
  public App setPermissionOrdersRead(java.lang.Boolean permissionOrdersRead) {
    return genClient.setOther(permissionOrdersRead, CacheKey.permissionOrdersRead);
  }

  /**
   * Sets the field 'permissionOrdersWrite'.
   */
  public App setPermissionOrdersWrite(java.lang.Boolean permissionOrdersWrite) {
    return genClient.setOther(permissionOrdersWrite, CacheKey.permissionOrdersWrite);
  }

  /**
   * Sets the field 'permissionPaymentsRead'.
   */
  public App setPermissionPaymentsRead(java.lang.Boolean permissionPaymentsRead) {
    return genClient.setOther(permissionPaymentsRead, CacheKey.permissionPaymentsRead);
  }

  /**
   * Sets the field 'permissionPaymentsWrite'.
   */
  public App setPermissionPaymentsWrite(java.lang.Boolean permissionPaymentsWrite) {
    return genClient.setOther(permissionPaymentsWrite, CacheKey.permissionPaymentsWrite);
  }

  /**
   * Sets the field 'permissionEmployeesRead'.
   */
  public App setPermissionEmployeesRead(java.lang.Boolean permissionEmployeesRead) {
    return genClient.setOther(permissionEmployeesRead, CacheKey.permissionEmployeesRead);
  }

  /**
   * Sets the field 'permissionEmployeesWrite'.
   */
  public App setPermissionEmployeesWrite(java.lang.Boolean permissionEmployeesWrite) {
    return genClient.setOther(permissionEmployeesWrite, CacheKey.permissionEmployeesWrite);
  }

  /**
   * Sets the field 'permissionProcessCards'.
   */
  public App setPermissionProcessCards(java.lang.Boolean permissionProcessCards) {
    return genClient.setOther(permissionProcessCards, CacheKey.permissionProcessCards);
  }

  /**
   * Sets the field 'permissionMidRead'.
   */
  public App setPermissionMidRead(java.lang.Boolean permissionMidRead) {
    return genClient.setOther(permissionMidRead, CacheKey.permissionMidRead);
  }

  /**
   * Sets the field 'permissionCustomersAddressRead'.
   */
  public App setPermissionCustomersAddressRead(java.lang.Boolean permissionCustomersAddressRead) {
    return genClient.setOther(permissionCustomersAddressRead, CacheKey.permissionCustomersAddressRead);
  }

  /**
   * Sets the field 'permissionCustomersAddressWrite'.
   */
  public App setPermissionCustomersAddressWrite(java.lang.Boolean permissionCustomersAddressWrite) {
    return genClient.setOther(permissionCustomersAddressWrite, CacheKey.permissionCustomersAddressWrite);
  }

  /**
   * Sets the field 'permissionCustomersBirthdateRead'.
   */
  public App setPermissionCustomersBirthdateRead(java.lang.Boolean permissionCustomersBirthdateRead) {
    return genClient.setOther(permissionCustomersBirthdateRead, CacheKey.permissionCustomersBirthdateRead);
  }

  /**
   * Sets the field 'permissionCustomersBirthdateWrite'.
   */
  public App setPermissionCustomersBirthdateWrite(java.lang.Boolean permissionCustomersBirthdateWrite) {
    return genClient.setOther(permissionCustomersBirthdateWrite, CacheKey.permissionCustomersBirthdateWrite);
  }

  /**
   * Sets the field 'permissionCustomersBusinessnameRead'.
   */
  public App setPermissionCustomersBusinessnameRead(java.lang.Boolean permissionCustomersBusinessnameRead) {
    return genClient.setOther(permissionCustomersBusinessnameRead, CacheKey.permissionCustomersBusinessnameRead);
  }

  /**
   * Sets the field 'permissionCustomersBusinessnameWrite'.
   */
  public App setPermissionCustomersBusinessnameWrite(java.lang.Boolean permissionCustomersBusinessnameWrite) {
    return genClient.setOther(permissionCustomersBusinessnameWrite, CacheKey.permissionCustomersBusinessnameWrite);
  }

  /**
   * Sets the field 'permissionCustomersCardRead'.
   */
  public App setPermissionCustomersCardRead(java.lang.Boolean permissionCustomersCardRead) {
    return genClient.setOther(permissionCustomersCardRead, CacheKey.permissionCustomersCardRead);
  }

  /**
   * Sets the field 'permissionCustomersCardWrite'.
   */
  public App setPermissionCustomersCardWrite(java.lang.Boolean permissionCustomersCardWrite) {
    return genClient.setOther(permissionCustomersCardWrite, CacheKey.permissionCustomersCardWrite);
  }

  /**
   * Sets the field 'permissionCustomersEmailRead'.
   */
  public App setPermissionCustomersEmailRead(java.lang.Boolean permissionCustomersEmailRead) {
    return genClient.setOther(permissionCustomersEmailRead, CacheKey.permissionCustomersEmailRead);
  }

  /**
   * Sets the field 'permissionCustomersEmailWrite'.
   */
  public App setPermissionCustomersEmailWrite(java.lang.Boolean permissionCustomersEmailWrite) {
    return genClient.setOther(permissionCustomersEmailWrite, CacheKey.permissionCustomersEmailWrite);
  }

  /**
   * Sets the field 'permissionCustomersNoteRead'.
   */
  public App setPermissionCustomersNoteRead(java.lang.Boolean permissionCustomersNoteRead) {
    return genClient.setOther(permissionCustomersNoteRead, CacheKey.permissionCustomersNoteRead);
  }

  /**
   * Sets the field 'permissionCustomersNoteWrite'.
   */
  public App setPermissionCustomersNoteWrite(java.lang.Boolean permissionCustomersNoteWrite) {
    return genClient.setOther(permissionCustomersNoteWrite, CacheKey.permissionCustomersNoteWrite);
  }

  /**
   * Sets the field 'permissionCustomersPhoneRead'.
   */
  public App setPermissionCustomersPhoneRead(java.lang.Boolean permissionCustomersPhoneRead) {
    return genClient.setOther(permissionCustomersPhoneRead, CacheKey.permissionCustomersPhoneRead);
  }

  /**
   * Sets the field 'permissionCustomersPhoneWrite'.
   */
  public App setPermissionCustomersPhoneWrite(java.lang.Boolean permissionCustomersPhoneWrite) {
    return genClient.setOther(permissionCustomersPhoneWrite, CacheKey.permissionCustomersPhoneWrite);
  }

  /**
   * Sets the field 'permissionCustomersMarketingRead'.
   */
  public App setPermissionCustomersMarketingRead(java.lang.Boolean permissionCustomersMarketingRead) {
    return genClient.setOther(permissionCustomersMarketingRead, CacheKey.permissionCustomersMarketingRead);
  }

  /**
   * Sets the field 'permissionCustomersMarketingWrite'.
   */
  public App setPermissionCustomersMarketingWrite(java.lang.Boolean permissionCustomersMarketingWrite) {
    return genClient.setOther(permissionCustomersMarketingWrite, CacheKey.permissionCustomersMarketingWrite);
  }

  /**
   * Sets the field 'privacyPolicy'.
   */
  public App setPrivacyPolicy(java.lang.String privacyPolicy) {
    return genClient.setOther(privacyPolicy, CacheKey.privacyPolicy);
  }

  /**
   * Sets the field 'eula'.
   */
  public App setEula(java.lang.String eula) {
    return genClient.setOther(eula, CacheKey.eula);
  }

  /**
   * Sets the field 'supportPhone'.
   */
  public App setSupportPhone(java.lang.String supportPhone) {
    return genClient.setOther(supportPhone, CacheKey.supportPhone);
  }

  /**
   * Sets the field 'supportPhoneHours'.
   */
  public App setSupportPhoneHours(java.lang.String supportPhoneHours) {
    return genClient.setOther(supportPhoneHours, CacheKey.supportPhoneHours);
  }

  /**
   * Sets the field 'supportEmail'.
   */
  public App setSupportEmail(java.lang.String supportEmail) {
    return genClient.setOther(supportEmail, CacheKey.supportEmail);
  }

  /**
   * Sets the field 'supportUrl'.
   */
  public App setSupportUrl(java.lang.String supportUrl) {
    return genClient.setOther(supportUrl, CacheKey.supportUrl);
  }

  /**
   * Sets the field 'productType'.
   */
  public App setProductType(com.clover.sdk.v3.apps.ProductType productType) {
    return genClient.setOther(productType, CacheKey.productType);
  }

  /**
   * Sets the field 'approvalStatus'.
   */
  public App setApprovalStatus(com.clover.sdk.v3.base.ApprovalStatus approvalStatus) {
    return genClient.setOther(approvalStatus, CacheKey.approvalStatus);
  }

  /**
   * Sets the field 'androidPermissions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAndroidPermissions(java.util.List<com.clover.sdk.v3.apps.AndroidPermission> androidPermissions) {
    return genClient.setArrayRecord(androidPermissions, CacheKey.androidPermissions);
  }

  /**
   * Sets the field 'screenshots'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setScreenshots(java.util.List<com.clover.sdk.v3.apps.Screenshot> screenshots) {
    return genClient.setArrayRecord(screenshots, CacheKey.screenshots);
  }

  /**
   * Sets the field 'availableSubscriptions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAvailableSubscriptions(java.util.List<com.clover.sdk.v3.apps.AppSubscription> availableSubscriptions) {
    return genClient.setArrayRecord(availableSubscriptions, CacheKey.availableSubscriptions);
  }

  /**
   * Sets the field 'subscriptions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setSubscriptions(java.util.List<com.clover.sdk.v3.apps.AppSubscription> subscriptions) {
    return genClient.setArrayRecord(subscriptions, CacheKey.subscriptions);
  }

  /**
   * Sets the field 'revisions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setRevisions(java.util.List<com.clover.sdk.v3.base.Reference> revisions) {
    return genClient.setArrayRecord(revisions, CacheKey.revisions);
  }

  /**
   * Sets the field 'availableMetereds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAvailableMetereds(java.util.List<com.clover.sdk.v3.apps.AppMetered> availableMetereds) {
    return genClient.setArrayRecord(availableMetereds, CacheKey.availableMetereds);
  }

  /**
   * Sets the field 'metereds'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setMetereds(java.util.List<com.clover.sdk.v3.apps.AppMetered> metereds) {
    return genClient.setArrayRecord(metereds, CacheKey.metereds);
  }

  /**
   * Sets the field 'usbDevices'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setUsbDevices(java.util.List<com.clover.sdk.v3.apps.AppUsbDevice> usbDevices) {
    return genClient.setArrayRecord(usbDevices, CacheKey.usbDevices);
  }

  /**
   * Sets the field 'isMerchantInTrial'.
   */
  public App setIsMerchantInTrial(java.lang.Boolean isMerchantInTrial) {
    return genClient.setOther(isMerchantInTrial, CacheKey.isMerchantInTrial);
  }

  /**
   * Sets the field 'currentSubscription'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setCurrentSubscription(com.clover.sdk.v3.apps.AppSubscription currentSubscription) {
    return genClient.setRecord(currentSubscription, CacheKey.currentSubscription);
  }

  /**
   * Sets the field 'webhook'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setWebhook(com.clover.sdk.v3.apps.WebHook webhook) {
    return genClient.setRecord(webhook, CacheKey.webhook);
  }

  /**
   * Sets the field 'androidVersions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setAndroidVersions(java.util.List<com.clover.sdk.v3.apps.AndroidVersion> androidVersions) {
    return genClient.setArrayRecord(androidVersions, CacheKey.androidVersions);
  }

  /**
   * Sets the field 'installed'.
   */
  public App setInstalled(java.lang.Boolean installed) {
    return genClient.setOther(installed, CacheKey.installed);
  }

  /**
   * Sets the field 'installedTime'.
   */
  public App setInstalledTime(java.lang.Long installedTime) {
    return genClient.setOther(installedTime, CacheKey.installedTime);
  }

  /**
   * Sets the field 'paidAppHasTrial'.
   */
  public App setPaidAppHasTrial(java.lang.Boolean paidAppHasTrial) {
    return genClient.setOther(paidAppHasTrial, CacheKey.paidAppHasTrial);
  }

  /**
   * Sets the field 'approvalStatusModifiedTime'.
   */
  public App setApprovalStatusModifiedTime(java.lang.Long approvalStatusModifiedTime) {
    return genClient.setOther(approvalStatusModifiedTime, CacheKey.approvalStatusModifiedTime);
  }

  /**
   * Sets the field 'smartReceiptText'.
   */
  public App setSmartReceiptText(java.lang.String smartReceiptText) {
    return genClient.setOther(smartReceiptText, CacheKey.smartReceiptText);
  }

  /**
   * Sets the field 'smartReceiptUrl'.
   */
  public App setSmartReceiptUrl(java.lang.String smartReceiptUrl) {
    return genClient.setOther(smartReceiptUrl, CacheKey.smartReceiptUrl);
  }

  /**
   * Sets the field 'billingStartTime'.
   */
  public App setBillingStartTime(java.lang.Long billingStartTime) {
    return genClient.setOther(billingStartTime, CacheKey.billingStartTime);
  }

  /**
   * Sets the field 'billingInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setBillingInfo(com.clover.sdk.v3.apps.AppBillingInfo billingInfo) {
    return genClient.setRecord(billingInfo, CacheKey.billingInfo);
  }

  /**
   * Sets the field 'appSecret'.
   */
  public App setAppSecret(java.lang.String appSecret) {
    return genClient.setOther(appSecret, CacheKey.appSecret);
  }

  /**
   * Sets the field 'businessTypes'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setBusinessTypes(java.util.List<com.clover.sdk.v3.apps.BusinessType> businessTypes) {
    return genClient.setArrayRecord(businessTypes, CacheKey.businessTypes);
  }

  /**
   * Sets the field 'deviceTypes'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setDeviceTypes(java.util.List<com.clover.sdk.v3.apps.DeviceType> deviceTypes) {
    return genClient.setArrayRecord(deviceTypes, CacheKey.deviceTypes);
  }

  /**
   * Sets the field 'modules'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setModules(java.util.List<com.clover.sdk.v3.merchant.Module> modules) {
    return genClient.setArrayRecord(modules, CacheKey.modules);
  }

  /**
   * Sets the field 'taxClassificationCode'.
   */
  public App setTaxClassificationCode(java.lang.String taxClassificationCode) {
    return genClient.setOther(taxClassificationCode, CacheKey.taxClassificationCode);
  }

  /**
   * Sets the field 'applicationId'.
   */
  public App setApplicationId(java.lang.String applicationId) {
    return genClient.setOther(applicationId, CacheKey.applicationId);
  }

  /**
   * Sets the field 'nonCloverBilling'.
   */
  public App setNonCloverBilling(java.lang.Boolean nonCloverBilling) {
    return genClient.setOther(nonCloverBilling, CacheKey.nonCloverBilling);
  }

  /**
   * Sets the field 'equipmentCode'.
   */
  public App setEquipmentCode(java.lang.String equipmentCode) {
    return genClient.setOther(equipmentCode, CacheKey.equipmentCode);
  }

  /**
   * Sets the field 'equipmentName'.
   */
  public App setEquipmentName(java.lang.String equipmentName) {
    return genClient.setOther(equipmentName, CacheKey.equipmentName);
  }

  /**
   * Sets the field 'firstPublishedTime'.
   */
  public App setFirstPublishedTime(java.lang.Long firstPublishedTime) {
    return genClient.setOther(firstPublishedTime, CacheKey.firstPublishedTime);
  }

  /**
   * Sets the field 'firstApprovalTime'.
   */
  public App setFirstApprovalTime(java.lang.Long firstApprovalTime) {
    return genClient.setOther(firstApprovalTime, CacheKey.firstApprovalTime);
  }

  /**
   * Sets the field 'firstSubmittedTime'.
   */
  public App setFirstSubmittedTime(java.lang.Long firstSubmittedTime) {
    return genClient.setOther(firstSubmittedTime, CacheKey.firstSubmittedTime);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public App setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'appBundle'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setAppBundle(com.clover.sdk.v3.base.Reference appBundle) {
    return genClient.setRecord(appBundle, CacheKey.appBundle);
  }

  /**
   * Sets the field 'editorPick'.
   */
  public App setEditorPick(java.lang.Boolean editorPick) {
    return genClient.setOther(editorPick, CacheKey.editorPick);
  }

  /**
   * Sets the field 'popularity'.
   */
  public App setPopularity(java.lang.Long popularity) {
    return genClient.setOther(popularity, CacheKey.popularity);
  }

  /**
   * Sets the field 'allowUninstall'.
   */
  public App setAllowUninstall(java.lang.Boolean allowUninstall) {
    return genClient.setOther(allowUninstall, CacheKey.allowUninstall);
  }

  /**
   * Sets the field 'charge'.
   */
  public App setCharge(java.lang.Boolean charge) {
    return genClient.setOther(charge, CacheKey.charge);
  }

  /**
   * Sets the field 'linkLabel'.
   */
  public App setLinkLabel(java.lang.String linkLabel) {
    return genClient.setOther(linkLabel, CacheKey.linkLabel);
  }

  /**
   * Sets the field 'categories'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setCategories(java.util.List<com.clover.sdk.v3.base.Reference> categories) {
    return genClient.setArrayRecord(categories, CacheKey.categories);
  }

  /**
   * Sets the field 'partnerId'.
   */
  public App setPartnerId(java.lang.String partnerId) {
    return genClient.setOther(partnerId, CacheKey.partnerId);
  }

  /**
   * Sets the field 'locales'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setLocales(java.util.List<com.clover.sdk.v3.base.Reference> locales) {
    return genClient.setArrayRecord(locales, CacheKey.locales);
  }

  /**
   * Sets the field 'rejectionReason'.
   */
  public App setRejectionReason(java.lang.String rejectionReason) {
    return genClient.setOther(rejectionReason, CacheKey.rejectionReason);
  }

  /**
   * Sets the field 'aggregateRating'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public App setAggregateRating(com.clover.sdk.v3.apps.AggregateRating aggregateRating) {
    return genClient.setRecord(aggregateRating, CacheKey.aggregateRating);
  }

  /**
   * Sets the field 'trialDays'.
   */
  public App setTrialDays(java.lang.Integer trialDays) {
    return genClient.setOther(trialDays, CacheKey.trialDays);
  }

  /**
   * Sets the field 'trialDaysLeft'.
   */
  public App setTrialDaysLeft(java.lang.Integer trialDaysLeft) {
    return genClient.setOther(trialDaysLeft, CacheKey.trialDaysLeft);
  }

  /**
   * Sets the field 'isHipaaCompliant'.
   */
  public App setIsHipaaCompliant(java.lang.Boolean isHipaaCompliant) {
    return genClient.setOther(isHipaaCompliant, CacheKey.isHipaaCompliant);
  }

  /**
   * Sets the field 'merchantsPlanIdsExclusion'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setMerchantsPlanIdsExclusion(java.util.List<java.lang.Long> merchantsPlanIdsExclusion) {
    return genClient.setArrayOther(merchantsPlanIdsExclusion, CacheKey.merchantsPlanIdsExclusion);
  }

  /**
   * Sets the field 'resellersUuidsExclusion'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public App setResellersUuidsExclusion(java.util.List<java.lang.String> resellersUuidsExclusion) {
    return genClient.setArrayOther(resellersUuidsExclusion, CacheKey.resellersUuidsExclusion);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'published' field, the 'has' method for this field will now return false */
  public void clearPublished() {
    genClient.clear(CacheKey.published);
  }
  /** Clears the 'developer' field, the 'has' method for this field will now return false */
  public void clearDeveloper() {
    genClient.clear(CacheKey.developer);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'tagline' field, the 'has' method for this field will now return false */
  public void clearTagline() {
    genClient.clear(CacheKey.tagline);
  }
  /** Clears the 'benefits' field, the 'has' method for this field will now return false */
  public void clearBenefits() {
    genClient.clear(CacheKey.benefits);
  }
  /** Clears the 'videoUrl' field, the 'has' method for this field will now return false */
  public void clearVideoUrl() {
    genClient.clear(CacheKey.videoUrl);
  }
  /** Clears the 'activationUrl' field, the 'has' method for this field will now return false */
  public void clearActivationUrl() {
    genClient.clear(CacheKey.activationUrl);
  }
  /** Clears the 'siteUrl' field, the 'has' method for this field will now return false */
  public void clearSiteUrl() {
    genClient.clear(CacheKey.siteUrl);
  }
  /** Clears the 'defaultResponseType' field, the 'has' method for this field will now return false */
  public void clearDefaultResponseType() {
    genClient.clear(CacheKey.defaultResponseType);
  }
  /** Clears the 'appDomain' field, the 'has' method for this field will now return false */
  public void clearAppDomain() {
    genClient.clear(CacheKey.appDomain);
  }
  /** Clears the 'androidVersion' field, the 'has' method for this field will now return false */
  public void clearAndroidVersion() {
    genClient.clear(CacheKey.androidVersion);
  }
  /** Clears the 'packageName' field, the 'has' method for this field will now return false */
  public void clearPackageName() {
    genClient.clear(CacheKey.packageName);
  }
  /** Clears the 'approved' field, the 'has' method for this field will now return false */
  public void clearApproved() {
    genClient.clear(CacheKey.approved);
  }
  /** Clears the 'systemApp' field, the 'has' method for this field will now return false */
  public void clearSystemApp() {
    genClient.clear(CacheKey.systemApp);
  }
  /** Clears the 'hidden' field, the 'has' method for this field will now return false */
  public void clearHidden() {
    genClient.clear(CacheKey.hidden);
  }
  /** Clears the 'distribution' field, the 'has' method for this field will now return false */
  public void clearDistribution() {
    genClient.clear(CacheKey.distribution);
  }
  /** Clears the 'filenameIcon' field, the 'has' method for this field will now return false */
  public void clearFilenameIcon() {
    genClient.clear(CacheKey.filenameIcon);
  }
  /** Clears the 'filenameIconSmall' field, the 'has' method for this field will now return false */
  public void clearFilenameIconSmall() {
    genClient.clear(CacheKey.filenameIconSmall);
  }
  /** Clears the 'filenameIconLarge' field, the 'has' method for this field will now return false */
  public void clearFilenameIconLarge() {
    genClient.clear(CacheKey.filenameIconLarge);
  }
  /** Clears the 'filenameCover' field, the 'has' method for this field will now return false */
  public void clearFilenameCover() {
    genClient.clear(CacheKey.filenameCover);
  }
  /** Clears the 'filenameBanner' field, the 'has' method for this field will now return false */
  public void clearFilenameBanner() {
    genClient.clear(CacheKey.filenameBanner);
  }
  /** Clears the 'installCount' field, the 'has' method for this field will now return false */
  public void clearInstallCount() {
    genClient.clear(CacheKey.installCount);
  }
  /** Clears the 'sortOrder' field, the 'has' method for this field will now return false */
  public void clearSortOrder() {
    genClient.clear(CacheKey.sortOrder);
  }
  /** Clears the 'permissionMerchantRead' field, the 'has' method for this field will now return false */
  public void clearPermissionMerchantRead() {
    genClient.clear(CacheKey.permissionMerchantRead);
  }
  /** Clears the 'permissionMerchantWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionMerchantWrite() {
    genClient.clear(CacheKey.permissionMerchantWrite);
  }
  /** Clears the 'permissionCustomersRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersRead() {
    genClient.clear(CacheKey.permissionCustomersRead);
  }
  /** Clears the 'permissionCustomersWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersWrite() {
    genClient.clear(CacheKey.permissionCustomersWrite);
  }
  /** Clears the 'permissionInventoryRead' field, the 'has' method for this field will now return false */
  public void clearPermissionInventoryRead() {
    genClient.clear(CacheKey.permissionInventoryRead);
  }
  /** Clears the 'permissionInventoryWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionInventoryWrite() {
    genClient.clear(CacheKey.permissionInventoryWrite);
  }
  /** Clears the 'permissionOrdersRead' field, the 'has' method for this field will now return false */
  public void clearPermissionOrdersRead() {
    genClient.clear(CacheKey.permissionOrdersRead);
  }
  /** Clears the 'permissionOrdersWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionOrdersWrite() {
    genClient.clear(CacheKey.permissionOrdersWrite);
  }
  /** Clears the 'permissionPaymentsRead' field, the 'has' method for this field will now return false */
  public void clearPermissionPaymentsRead() {
    genClient.clear(CacheKey.permissionPaymentsRead);
  }
  /** Clears the 'permissionPaymentsWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionPaymentsWrite() {
    genClient.clear(CacheKey.permissionPaymentsWrite);
  }
  /** Clears the 'permissionEmployeesRead' field, the 'has' method for this field will now return false */
  public void clearPermissionEmployeesRead() {
    genClient.clear(CacheKey.permissionEmployeesRead);
  }
  /** Clears the 'permissionEmployeesWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionEmployeesWrite() {
    genClient.clear(CacheKey.permissionEmployeesWrite);
  }
  /** Clears the 'permissionProcessCards' field, the 'has' method for this field will now return false */
  public void clearPermissionProcessCards() {
    genClient.clear(CacheKey.permissionProcessCards);
  }
  /** Clears the 'permissionMidRead' field, the 'has' method for this field will now return false */
  public void clearPermissionMidRead() {
    genClient.clear(CacheKey.permissionMidRead);
  }
  /** Clears the 'permissionCustomersAddressRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersAddressRead() {
    genClient.clear(CacheKey.permissionCustomersAddressRead);
  }
  /** Clears the 'permissionCustomersAddressWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersAddressWrite() {
    genClient.clear(CacheKey.permissionCustomersAddressWrite);
  }
  /** Clears the 'permissionCustomersBirthdateRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersBirthdateRead() {
    genClient.clear(CacheKey.permissionCustomersBirthdateRead);
  }
  /** Clears the 'permissionCustomersBirthdateWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersBirthdateWrite() {
    genClient.clear(CacheKey.permissionCustomersBirthdateWrite);
  }
  /** Clears the 'permissionCustomersBusinessnameRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersBusinessnameRead() {
    genClient.clear(CacheKey.permissionCustomersBusinessnameRead);
  }
  /** Clears the 'permissionCustomersBusinessnameWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersBusinessnameWrite() {
    genClient.clear(CacheKey.permissionCustomersBusinessnameWrite);
  }
  /** Clears the 'permissionCustomersCardRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersCardRead() {
    genClient.clear(CacheKey.permissionCustomersCardRead);
  }
  /** Clears the 'permissionCustomersCardWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersCardWrite() {
    genClient.clear(CacheKey.permissionCustomersCardWrite);
  }
  /** Clears the 'permissionCustomersEmailRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersEmailRead() {
    genClient.clear(CacheKey.permissionCustomersEmailRead);
  }
  /** Clears the 'permissionCustomersEmailWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersEmailWrite() {
    genClient.clear(CacheKey.permissionCustomersEmailWrite);
  }
  /** Clears the 'permissionCustomersNoteRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersNoteRead() {
    genClient.clear(CacheKey.permissionCustomersNoteRead);
  }
  /** Clears the 'permissionCustomersNoteWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersNoteWrite() {
    genClient.clear(CacheKey.permissionCustomersNoteWrite);
  }
  /** Clears the 'permissionCustomersPhoneRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersPhoneRead() {
    genClient.clear(CacheKey.permissionCustomersPhoneRead);
  }
  /** Clears the 'permissionCustomersPhoneWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersPhoneWrite() {
    genClient.clear(CacheKey.permissionCustomersPhoneWrite);
  }
  /** Clears the 'permissionCustomersMarketingRead' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersMarketingRead() {
    genClient.clear(CacheKey.permissionCustomersMarketingRead);
  }
  /** Clears the 'permissionCustomersMarketingWrite' field, the 'has' method for this field will now return false */
  public void clearPermissionCustomersMarketingWrite() {
    genClient.clear(CacheKey.permissionCustomersMarketingWrite);
  }
  /** Clears the 'privacyPolicy' field, the 'has' method for this field will now return false */
  public void clearPrivacyPolicy() {
    genClient.clear(CacheKey.privacyPolicy);
  }
  /** Clears the 'eula' field, the 'has' method for this field will now return false */
  public void clearEula() {
    genClient.clear(CacheKey.eula);
  }
  /** Clears the 'supportPhone' field, the 'has' method for this field will now return false */
  public void clearSupportPhone() {
    genClient.clear(CacheKey.supportPhone);
  }
  /** Clears the 'supportPhoneHours' field, the 'has' method for this field will now return false */
  public void clearSupportPhoneHours() {
    genClient.clear(CacheKey.supportPhoneHours);
  }
  /** Clears the 'supportEmail' field, the 'has' method for this field will now return false */
  public void clearSupportEmail() {
    genClient.clear(CacheKey.supportEmail);
  }
  /** Clears the 'supportUrl' field, the 'has' method for this field will now return false */
  public void clearSupportUrl() {
    genClient.clear(CacheKey.supportUrl);
  }
  /** Clears the 'productType' field, the 'has' method for this field will now return false */
  public void clearProductType() {
    genClient.clear(CacheKey.productType);
  }
  /** Clears the 'approvalStatus' field, the 'has' method for this field will now return false */
  public void clearApprovalStatus() {
    genClient.clear(CacheKey.approvalStatus);
  }
  /** Clears the 'androidPermissions' field, the 'has' method for this field will now return false */
  public void clearAndroidPermissions() {
    genClient.clear(CacheKey.androidPermissions);
  }
  /** Clears the 'screenshots' field, the 'has' method for this field will now return false */
  public void clearScreenshots() {
    genClient.clear(CacheKey.screenshots);
  }
  /** Clears the 'availableSubscriptions' field, the 'has' method for this field will now return false */
  public void clearAvailableSubscriptions() {
    genClient.clear(CacheKey.availableSubscriptions);
  }
  /** Clears the 'subscriptions' field, the 'has' method for this field will now return false */
  public void clearSubscriptions() {
    genClient.clear(CacheKey.subscriptions);
  }
  /** Clears the 'revisions' field, the 'has' method for this field will now return false */
  public void clearRevisions() {
    genClient.clear(CacheKey.revisions);
  }
  /** Clears the 'availableMetereds' field, the 'has' method for this field will now return false */
  public void clearAvailableMetereds() {
    genClient.clear(CacheKey.availableMetereds);
  }
  /** Clears the 'metereds' field, the 'has' method for this field will now return false */
  public void clearMetereds() {
    genClient.clear(CacheKey.metereds);
  }
  /** Clears the 'usbDevices' field, the 'has' method for this field will now return false */
  public void clearUsbDevices() {
    genClient.clear(CacheKey.usbDevices);
  }
  /** Clears the 'isMerchantInTrial' field, the 'has' method for this field will now return false */
  public void clearIsMerchantInTrial() {
    genClient.clear(CacheKey.isMerchantInTrial);
  }
  /** Clears the 'currentSubscription' field, the 'has' method for this field will now return false */
  public void clearCurrentSubscription() {
    genClient.clear(CacheKey.currentSubscription);
  }
  /** Clears the 'webhook' field, the 'has' method for this field will now return false */
  public void clearWebhook() {
    genClient.clear(CacheKey.webhook);
  }
  /** Clears the 'androidVersions' field, the 'has' method for this field will now return false */
  public void clearAndroidVersions() {
    genClient.clear(CacheKey.androidVersions);
  }
  /** Clears the 'installed' field, the 'has' method for this field will now return false */
  public void clearInstalled() {
    genClient.clear(CacheKey.installed);
  }
  /** Clears the 'installedTime' field, the 'has' method for this field will now return false */
  public void clearInstalledTime() {
    genClient.clear(CacheKey.installedTime);
  }
  /** Clears the 'paidAppHasTrial' field, the 'has' method for this field will now return false */
  public void clearPaidAppHasTrial() {
    genClient.clear(CacheKey.paidAppHasTrial);
  }
  /** Clears the 'approvalStatusModifiedTime' field, the 'has' method for this field will now return false */
  public void clearApprovalStatusModifiedTime() {
    genClient.clear(CacheKey.approvalStatusModifiedTime);
  }
  /** Clears the 'smartReceiptText' field, the 'has' method for this field will now return false */
  public void clearSmartReceiptText() {
    genClient.clear(CacheKey.smartReceiptText);
  }
  /** Clears the 'smartReceiptUrl' field, the 'has' method for this field will now return false */
  public void clearSmartReceiptUrl() {
    genClient.clear(CacheKey.smartReceiptUrl);
  }
  /** Clears the 'billingStartTime' field, the 'has' method for this field will now return false */
  public void clearBillingStartTime() {
    genClient.clear(CacheKey.billingStartTime);
  }
  /** Clears the 'billingInfo' field, the 'has' method for this field will now return false */
  public void clearBillingInfo() {
    genClient.clear(CacheKey.billingInfo);
  }
  /** Clears the 'appSecret' field, the 'has' method for this field will now return false */
  public void clearAppSecret() {
    genClient.clear(CacheKey.appSecret);
  }
  /** Clears the 'businessTypes' field, the 'has' method for this field will now return false */
  public void clearBusinessTypes() {
    genClient.clear(CacheKey.businessTypes);
  }
  /** Clears the 'deviceTypes' field, the 'has' method for this field will now return false */
  public void clearDeviceTypes() {
    genClient.clear(CacheKey.deviceTypes);
  }
  /** Clears the 'modules' field, the 'has' method for this field will now return false */
  public void clearModules() {
    genClient.clear(CacheKey.modules);
  }
  /** Clears the 'taxClassificationCode' field, the 'has' method for this field will now return false */
  public void clearTaxClassificationCode() {
    genClient.clear(CacheKey.taxClassificationCode);
  }
  /** Clears the 'applicationId' field, the 'has' method for this field will now return false */
  public void clearApplicationId() {
    genClient.clear(CacheKey.applicationId);
  }
  /** Clears the 'nonCloverBilling' field, the 'has' method for this field will now return false */
  public void clearNonCloverBilling() {
    genClient.clear(CacheKey.nonCloverBilling);
  }
  /** Clears the 'equipmentCode' field, the 'has' method for this field will now return false */
  public void clearEquipmentCode() {
    genClient.clear(CacheKey.equipmentCode);
  }
  /** Clears the 'equipmentName' field, the 'has' method for this field will now return false */
  public void clearEquipmentName() {
    genClient.clear(CacheKey.equipmentName);
  }
  /** Clears the 'firstPublishedTime' field, the 'has' method for this field will now return false */
  public void clearFirstPublishedTime() {
    genClient.clear(CacheKey.firstPublishedTime);
  }
  /** Clears the 'firstApprovalTime' field, the 'has' method for this field will now return false */
  public void clearFirstApprovalTime() {
    genClient.clear(CacheKey.firstApprovalTime);
  }
  /** Clears the 'firstSubmittedTime' field, the 'has' method for this field will now return false */
  public void clearFirstSubmittedTime() {
    genClient.clear(CacheKey.firstSubmittedTime);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'appBundle' field, the 'has' method for this field will now return false */
  public void clearAppBundle() {
    genClient.clear(CacheKey.appBundle);
  }
  /** Clears the 'editorPick' field, the 'has' method for this field will now return false */
  public void clearEditorPick() {
    genClient.clear(CacheKey.editorPick);
  }
  /** Clears the 'popularity' field, the 'has' method for this field will now return false */
  public void clearPopularity() {
    genClient.clear(CacheKey.popularity);
  }
  /** Clears the 'allowUninstall' field, the 'has' method for this field will now return false */
  public void clearAllowUninstall() {
    genClient.clear(CacheKey.allowUninstall);
  }
  /** Clears the 'charge' field, the 'has' method for this field will now return false */
  public void clearCharge() {
    genClient.clear(CacheKey.charge);
  }
  /** Clears the 'linkLabel' field, the 'has' method for this field will now return false */
  public void clearLinkLabel() {
    genClient.clear(CacheKey.linkLabel);
  }
  /** Clears the 'categories' field, the 'has' method for this field will now return false */
  public void clearCategories() {
    genClient.clear(CacheKey.categories);
  }
  /** Clears the 'partnerId' field, the 'has' method for this field will now return false */
  public void clearPartnerId() {
    genClient.clear(CacheKey.partnerId);
  }
  /** Clears the 'locales' field, the 'has' method for this field will now return false */
  public void clearLocales() {
    genClient.clear(CacheKey.locales);
  }
  /** Clears the 'rejectionReason' field, the 'has' method for this field will now return false */
  public void clearRejectionReason() {
    genClient.clear(CacheKey.rejectionReason);
  }
  /** Clears the 'aggregateRating' field, the 'has' method for this field will now return false */
  public void clearAggregateRating() {
    genClient.clear(CacheKey.aggregateRating);
  }
  /** Clears the 'trialDays' field, the 'has' method for this field will now return false */
  public void clearTrialDays() {
    genClient.clear(CacheKey.trialDays);
  }
  /** Clears the 'trialDaysLeft' field, the 'has' method for this field will now return false */
  public void clearTrialDaysLeft() {
    genClient.clear(CacheKey.trialDaysLeft);
  }
  /** Clears the 'isHipaaCompliant' field, the 'has' method for this field will now return false */
  public void clearIsHipaaCompliant() {
    genClient.clear(CacheKey.isHipaaCompliant);
  }
  /** Clears the 'merchantsPlanIdsExclusion' field, the 'has' method for this field will now return false */
  public void clearMerchantsPlanIdsExclusion() {
    genClient.clear(CacheKey.merchantsPlanIdsExclusion);
  }
  /** Clears the 'resellersUuidsExclusion' field, the 'has' method for this field will now return false */
  public void clearResellersUuidsExclusion() {
    genClient.clear(CacheKey.resellersUuidsExclusion);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public App copyChanges() {
    App copy = new App();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(App src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new App(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<App> CREATOR = new android.os.Parcelable.Creator<App>() {
    @Override
    public App createFromParcel(android.os.Parcel in) {
      App instance = new App(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public App[] newArray(int size) {
      return new App[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<App> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<App>() {
    public Class<App> getCreatedClass() {
      return App.class;
    }

    @Override
    public App create(org.json.JSONObject jsonObject) {
      return new App(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean PUBLISHED_IS_REQUIRED = false;
    public static final boolean DEVELOPER_IS_REQUIRED = false;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final long DESCRIPTION_MAX_LEN = 2000;
    public static final boolean TAGLINE_IS_REQUIRED = false;
    public static final long TAGLINE_MAX_LEN = 255;
    public static final boolean BENEFITS_IS_REQUIRED = false;
    public static final boolean VIDEOURL_IS_REQUIRED = false;
    public static final long VIDEOURL_MAX_LEN = 255;
    public static final boolean ACTIVATIONURL_IS_REQUIRED = false;
    public static final long ACTIVATIONURL_MAX_LEN = 255;
    public static final boolean SITEURL_IS_REQUIRED = false;
    public static final long SITEURL_MAX_LEN = 255;
    public static final boolean DEFAULTRESPONSETYPE_IS_REQUIRED = false;
    public static final boolean APPDOMAIN_IS_REQUIRED = false;
    public static final long APPDOMAIN_MAX_LEN = 255;
    public static final boolean ANDROIDVERSION_IS_REQUIRED = false;
    public static final boolean PACKAGENAME_IS_REQUIRED = false;
    public static final long PACKAGENAME_MAX_LEN = 255;
    public static final boolean APPROVED_IS_REQUIRED = false;
    public static final boolean SYSTEMAPP_IS_REQUIRED = false;
    public static final boolean HIDDEN_IS_REQUIRED = false;
    public static final boolean DISTRIBUTION_IS_REQUIRED = false;
    public static final boolean FILENAMEICON_IS_REQUIRED = false;
    public static final long FILENAMEICON_MAX_LEN = 255;
    public static final boolean FILENAMEICONSMALL_IS_REQUIRED = false;
    public static final long FILENAMEICONSMALL_MAX_LEN = 255;
    public static final boolean FILENAMEICONLARGE_IS_REQUIRED = false;
    public static final long FILENAMEICONLARGE_MAX_LEN = 255;
    public static final boolean FILENAMECOVER_IS_REQUIRED = false;
    public static final long FILENAMECOVER_MAX_LEN = 255;
    public static final boolean FILENAMEBANNER_IS_REQUIRED = false;
    public static final long FILENAMEBANNER_MAX_LEN = 255;
    public static final boolean INSTALLCOUNT_IS_REQUIRED = false;
    public static final boolean SORTORDER_IS_REQUIRED = false;
    public static final boolean PERMISSIONMERCHANTREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONMERCHANTWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONINVENTORYREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONINVENTORYWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONORDERSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONORDERSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONPAYMENTSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONPAYMENTSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONEMPLOYEESREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONEMPLOYEESWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONPROCESSCARDS_IS_REQUIRED = false;
    public static final boolean PERMISSIONMIDREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSADDRESSREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSADDRESSWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSBIRTHDATEREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSBIRTHDATEWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSBUSINESSNAMEREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSBUSINESSNAMEWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSCARDREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSCARDWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSEMAILREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSEMAILWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSNOTEREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSNOTEWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSPHONEREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSPHONEWRITE_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSMARKETINGREAD_IS_REQUIRED = false;
    public static final boolean PERMISSIONCUSTOMERSMARKETINGWRITE_IS_REQUIRED = false;
    public static final boolean PRIVACYPOLICY_IS_REQUIRED = false;
    public static final long PRIVACYPOLICY_MAX_LEN = 255;
    public static final boolean EULA_IS_REQUIRED = false;
    public static final long EULA_MAX_LEN = 255;
    public static final boolean SUPPORTPHONE_IS_REQUIRED = false;
    public static final long SUPPORTPHONE_MAX_LEN = 25;
    public static final boolean SUPPORTPHONEHOURS_IS_REQUIRED = false;
    public static final long SUPPORTPHONEHOURS_MAX_LEN = 127;
    public static final boolean SUPPORTEMAIL_IS_REQUIRED = false;
    public static final long SUPPORTEMAIL_MAX_LEN = 127;
    public static final boolean SUPPORTURL_IS_REQUIRED = false;
    public static final long SUPPORTURL_MAX_LEN = 255;
    public static final boolean PRODUCTTYPE_IS_REQUIRED = false;
    public static final boolean APPROVALSTATUS_IS_REQUIRED = false;
    public static final boolean ANDROIDPERMISSIONS_IS_REQUIRED = false;
    public static final boolean SCREENSHOTS_IS_REQUIRED = false;
    public static final boolean AVAILABLESUBSCRIPTIONS_IS_REQUIRED = false;
    public static final boolean SUBSCRIPTIONS_IS_REQUIRED = false;
    public static final boolean REVISIONS_IS_REQUIRED = false;
    public static final boolean AVAILABLEMETEREDS_IS_REQUIRED = false;
    public static final boolean METEREDS_IS_REQUIRED = false;
    public static final boolean USBDEVICES_IS_REQUIRED = false;
    public static final boolean ISMERCHANTINTRIAL_IS_REQUIRED = false;
    public static final boolean CURRENTSUBSCRIPTION_IS_REQUIRED = false;
    public static final boolean WEBHOOK_IS_REQUIRED = false;
    public static final boolean ANDROIDVERSIONS_IS_REQUIRED = false;
    public static final boolean INSTALLED_IS_REQUIRED = false;
    public static final boolean INSTALLEDTIME_IS_REQUIRED = false;
    public static final boolean PAIDAPPHASTRIAL_IS_REQUIRED = false;
    public static final boolean APPROVALSTATUSMODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean SMARTRECEIPTTEXT_IS_REQUIRED = false;
    public static final long SMARTRECEIPTTEXT_MAX_LEN = 100;
    public static final boolean SMARTRECEIPTURL_IS_REQUIRED = false;
    public static final long SMARTRECEIPTURL_MAX_LEN = 255;
    public static final boolean BILLINGSTARTTIME_IS_REQUIRED = false;
    public static final boolean BILLINGINFO_IS_REQUIRED = false;
    public static final boolean APPSECRET_IS_REQUIRED = false;
    public static final long APPSECRET_MAX_LEN = 255;
    public static final boolean BUSINESSTYPES_IS_REQUIRED = false;
    public static final boolean DEVICETYPES_IS_REQUIRED = false;
    public static final boolean MODULES_IS_REQUIRED = false;
    public static final boolean TAXCLASSIFICATIONCODE_IS_REQUIRED = false;
    public static final boolean APPLICATIONID_IS_REQUIRED = false;
    public static final boolean NONCLOVERBILLING_IS_REQUIRED = false;
    public static final boolean EQUIPMENTCODE_IS_REQUIRED = false;
    public static final boolean EQUIPMENTNAME_IS_REQUIRED = false;
    public static final boolean FIRSTPUBLISHEDTIME_IS_REQUIRED = false;
    public static final boolean FIRSTAPPROVALTIME_IS_REQUIRED = false;
    public static final boolean FIRSTSUBMITTEDTIME_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean APPBUNDLE_IS_REQUIRED = false;
    public static final boolean EDITORPICK_IS_REQUIRED = false;
    public static final boolean POPULARITY_IS_REQUIRED = false;
    public static final boolean ALLOWUNINSTALL_IS_REQUIRED = false;
    public static final boolean CHARGE_IS_REQUIRED = false;
    public static final boolean LINKLABEL_IS_REQUIRED = false;
    public static final boolean CATEGORIES_IS_REQUIRED = false;
    public static final boolean PARTNERID_IS_REQUIRED = false;
    public static final boolean LOCALES_IS_REQUIRED = false;
    public static final boolean REJECTIONREASON_IS_REQUIRED = false;
    public static final long REJECTIONREASON_MAX_LEN = 2000;
    public static final boolean AGGREGATERATING_IS_REQUIRED = false;
    public static final boolean TRIALDAYS_IS_REQUIRED = false;
    public static final boolean TRIALDAYSLEFT_IS_REQUIRED = false;
    public static final boolean ISHIPAACOMPLIANT_IS_REQUIRED = false;
    public static final boolean MERCHANTSPLANIDSEXCLUSION_IS_REQUIRED = false;
    public static final boolean RESELLERSUUIDSEXCLUSION_IS_REQUIRED = false;
  }

}
