/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getDisplayName displayName}</li>
 * <li>{@link #getDescription description}</li>
 * <li>{@link #getCountryCode countryCode}</li>
 * <li>{@link #getReseller reseller}</li>
 * <li>{@link #getMerchantGroup merchantGroup}</li>
 * <li>{@link #getMaxSize maxSize}</li>
 * <li>{@link #getSortOrder sortOrder}</li>
 * <li>{@link #getViewAllButton viewAllButton}</li>
 * <li>{@link #getResultLabel resultLabel}</li>
 * <li>{@link #getAutoInstall autoInstall}</li>
 * <li>{@link #getCarouselApps carouselApps}</li>
 * <li>{@link #getSortBy sortBy}</li>
 * <li>{@link #getAppPopulatedBy appPopulatedBy}</li>
 * <li>{@link #getCollectionGroup collectionGroup}</li>
 * <li>{@link #getCollectionStyle collectionStyle}</li>
 * <li>{@link #getShowInAppMarket showInAppMarket}</li>
 * <li>{@link #getShowInAppDetail showInAppDetail}</li>
 * <li>{@link #getShowInDashboard showInDashboard}</li>
 * <li>{@link #getShowInFinance showInFinance}</li>
 * <li>{@link #getCategories categories}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AppCarousel extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Name of the collection
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Display name of the collection
   */
  public java.lang.String getDisplayName() {
    return genClient.cacheGet(CacheKey.displayName);
  }

  /**
   * Description about the collection
   */
  public java.lang.String getDescription() {
    return genClient.cacheGet(CacheKey.description);
  }

  public java.lang.String getCountryCode() {
    return genClient.cacheGet(CacheKey.countryCode);
  }

  public com.clover.sdk.v3.base.Reference getReseller() {
    return genClient.cacheGet(CacheKey.reseller);
  }

  public com.clover.sdk.v3.base.Reference getMerchantGroup() {
    return genClient.cacheGet(CacheKey.merchantGroup);
  }

  /**
   * Maximum number of apps in a collection
   */
  public java.lang.Integer getMaxSize() {
    return genClient.cacheGet(CacheKey.maxSize);
  }

  public java.lang.Long getSortOrder() {
    return genClient.cacheGet(CacheKey.sortOrder);
  }

  public java.lang.String getViewAllButton() {
    return genClient.cacheGet(CacheKey.viewAllButton);
  }

  public java.lang.String getResultLabel() {
    return genClient.cacheGet(CacheKey.resultLabel);
  }

  /**
   * When true, apps in this carousel will be installed to merchants in the associated merchant group.
   */
  public java.lang.Boolean getAutoInstall() {
    return genClient.cacheGet(CacheKey.autoInstall);
  }

  /**
   * List of apps to be in a collection
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getCarouselApps() {
    return genClient.cacheGet(CacheKey.carouselApps);
  }

  /**
   * Sort strategy to order apps in a collection
   */
  public com.clover.sdk.v3.apps.CarouselSortBy getSortBy() {
    return genClient.cacheGet(CacheKey.sortBy);
  }

  /**
   * Population strategy to populated apps in a collection
   */
  public com.clover.sdk.v3.apps.AppCollectionPopulation getAppPopulatedBy() {
    return genClient.cacheGet(CacheKey.appPopulatedBy);
  }

  /**
   * Group a collection belong to. Used to display collection in a group. More info: https://confluence.dev.clover.com/display/AM/Functional+Spec+-+Phase+1+-+App+Market+Collection+-+Server#FunctionalSpec-Phase1-AppMarketCollection-Server-CollectionGroup
   */
  public com.clover.sdk.v3.apps.AppCollectionGroup getCollectionGroup() {
    return genClient.cacheGet(CacheKey.collectionGroup);
  }

  /**
   * Style to be used for consistent display across clients. More info: https://confluence.dev.clover.com/display/AM/Functional+Spec+-+Phase+1+-+App+Market+Collection+%28Personalization%29+-+Server
   */
  public com.clover.sdk.v3.apps.AppCollectionStyle getCollectionStyle() {
    return genClient.cacheGet(CacheKey.collectionStyle);
  }

  /**
   * Boolean to decide whether collection needs to be shown in app market page
   */
  public java.lang.Boolean getShowInAppMarket() {
    return genClient.cacheGet(CacheKey.showInAppMarket);
  }

  /**
   * Boolean to decide whether collection needs to be shown in app detail page
   */
  public java.lang.Boolean getShowInAppDetail() {
    return genClient.cacheGet(CacheKey.showInAppDetail);
  }

  /**
   * Boolean to decide whether collection needs to be shown in merchant dashboard
   */
  public java.lang.Boolean getShowInDashboard() {
    return genClient.cacheGet(CacheKey.showInDashboard);
  }

  /**
   * Boolean to decide whether collection needs to be shown in finance page
   */
  public java.lang.Boolean getShowInFinance() {
    return genClient.cacheGet(CacheKey.showInFinance);
  }

  /**
   * App functional or domain categories
   */
  public java.util.List<com.clover.sdk.v3.base.Reference> getCategories() {
    return genClient.cacheGet(CacheKey.categories);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    displayName
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    description
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    countryCode
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    reseller
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    merchantGroup
            (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    maxSize
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    sortOrder
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    viewAllButton
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    resultLabel
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    autoInstall
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    carouselApps
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    sortBy
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.CarouselSortBy.class)),
    appPopulatedBy
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.AppCollectionPopulation.class)),
    collectionGroup
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.AppCollectionGroup.class)),
    collectionStyle
            (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.apps.AppCollectionStyle.class)),
    showInAppMarket
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    showInAppDetail
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    showInDashboard
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    showInFinance
            (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    categories
            (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AppCarousel> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AppCarousel() {
    genClient = new GenericClient<AppCarousel>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AppCarousel(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AppCarousel(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AppCarousel(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AppCarousel(AppCarousel src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.name, getName());
    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateNotNull(CacheKey.displayName, getDisplayName());
    genClient.validateLength(CacheKey.displayName, getDisplayName(), 127);

    genClient.validateNotNull(CacheKey.countryCode, getCountryCode());
    genClient.validateLength(CacheKey.countryCode, getCountryCode(), 2);

    genClient.validateNotNull(CacheKey.maxSize, getMaxSize());

    genClient.validateLength(CacheKey.viewAllButton, getViewAllButton(), 127);

    genClient.validateLength(CacheKey.resultLabel, getResultLabel(), 127);

    genClient.validateNotNull(CacheKey.appPopulatedBy, getAppPopulatedBy());

    genClient.validateNotNull(CacheKey.collectionStyle, getCollectionStyle());
    genClient.validateReferences(CacheKey.reseller);
    genClient.validateReferences(CacheKey.merchantGroup);
    genClient.validateReferences(CacheKey.carouselApps);
    genClient.validateReferences(CacheKey.categories);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'displayName' field is set and is not null */
  public boolean isNotNullDisplayName() {
    return genClient.cacheValueIsNotNull(CacheKey.displayName);
  }

  /** Checks whether the 'description' field is set and is not null */
  public boolean isNotNullDescription() {
    return genClient.cacheValueIsNotNull(CacheKey.description);
  }

  /** Checks whether the 'countryCode' field is set and is not null */
  public boolean isNotNullCountryCode() {
    return genClient.cacheValueIsNotNull(CacheKey.countryCode);
  }

  /** Checks whether the 'reseller' field is set and is not null */
  public boolean isNotNullReseller() {
    return genClient.cacheValueIsNotNull(CacheKey.reseller);
  }

  /** Checks whether the 'merchantGroup' field is set and is not null */
  public boolean isNotNullMerchantGroup() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantGroup);
  }

  /** Checks whether the 'maxSize' field is set and is not null */
  public boolean isNotNullMaxSize() {
    return genClient.cacheValueIsNotNull(CacheKey.maxSize);
  }

  /** Checks whether the 'sortOrder' field is set and is not null */
  public boolean isNotNullSortOrder() {
    return genClient.cacheValueIsNotNull(CacheKey.sortOrder);
  }

  /** Checks whether the 'viewAllButton' field is set and is not null */
  public boolean isNotNullViewAllButton() {
    return genClient.cacheValueIsNotNull(CacheKey.viewAllButton);
  }

  /** Checks whether the 'resultLabel' field is set and is not null */
  public boolean isNotNullResultLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.resultLabel);
  }

  /** Checks whether the 'autoInstall' field is set and is not null */
  public boolean isNotNullAutoInstall() {
    return genClient.cacheValueIsNotNull(CacheKey.autoInstall);
  }

  /** Checks whether the 'carouselApps' field is set and is not null */
  public boolean isNotNullCarouselApps() {
    return genClient.cacheValueIsNotNull(CacheKey.carouselApps);
  }

  /** Checks whether the 'carouselApps' field is set and is not null and is not empty */
  public boolean isNotEmptyCarouselApps() { return isNotNullCarouselApps() && !getCarouselApps().isEmpty(); }

  /** Checks whether the 'sortBy' field is set and is not null */
  public boolean isNotNullSortBy() {
    return genClient.cacheValueIsNotNull(CacheKey.sortBy);
  }

  /** Checks whether the 'appPopulatedBy' field is set and is not null */
  public boolean isNotNullAppPopulatedBy() {
    return genClient.cacheValueIsNotNull(CacheKey.appPopulatedBy);
  }

  /** Checks whether the 'collectionGroup' field is set and is not null */
  public boolean isNotNullCollectionGroup() {
    return genClient.cacheValueIsNotNull(CacheKey.collectionGroup);
  }

  /** Checks whether the 'collectionStyle' field is set and is not null */
  public boolean isNotNullCollectionStyle() {
    return genClient.cacheValueIsNotNull(CacheKey.collectionStyle);
  }

  /** Checks whether the 'showInAppMarket' field is set and is not null */
  public boolean isNotNullShowInAppMarket() {
    return genClient.cacheValueIsNotNull(CacheKey.showInAppMarket);
  }

  /** Checks whether the 'showInAppDetail' field is set and is not null */
  public boolean isNotNullShowInAppDetail() {
    return genClient.cacheValueIsNotNull(CacheKey.showInAppDetail);
  }

  /** Checks whether the 'showInDashboard' field is set and is not null */
  public boolean isNotNullShowInDashboard() {
    return genClient.cacheValueIsNotNull(CacheKey.showInDashboard);
  }

  /** Checks whether the 'showInFinance' field is set and is not null */
  public boolean isNotNullShowInFinance() {
    return genClient.cacheValueIsNotNull(CacheKey.showInFinance);
  }

  /** Checks whether the 'categories' field is set and is not null */
  public boolean isNotNullCategories() {
    return genClient.cacheValueIsNotNull(CacheKey.categories);
  }

  /** Checks whether the 'categories' field is set and is not null and is not empty */
  public boolean isNotEmptyCategories() { return isNotNullCategories() && !getCategories().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'displayName' field has been set, however the value could be null */
  public boolean hasDisplayName() {
    return genClient.cacheHasKey(CacheKey.displayName);
  }

  /** Checks whether the 'description' field has been set, however the value could be null */
  public boolean hasDescription() {
    return genClient.cacheHasKey(CacheKey.description);
  }

  /** Checks whether the 'countryCode' field has been set, however the value could be null */
  public boolean hasCountryCode() {
    return genClient.cacheHasKey(CacheKey.countryCode);
  }

  /** Checks whether the 'reseller' field has been set, however the value could be null */
  public boolean hasReseller() {
    return genClient.cacheHasKey(CacheKey.reseller);
  }

  /** Checks whether the 'merchantGroup' field has been set, however the value could be null */
  public boolean hasMerchantGroup() {
    return genClient.cacheHasKey(CacheKey.merchantGroup);
  }

  /** Checks whether the 'maxSize' field has been set, however the value could be null */
  public boolean hasMaxSize() {
    return genClient.cacheHasKey(CacheKey.maxSize);
  }

  /** Checks whether the 'sortOrder' field has been set, however the value could be null */
  public boolean hasSortOrder() {
    return genClient.cacheHasKey(CacheKey.sortOrder);
  }

  /** Checks whether the 'viewAllButton' field has been set, however the value could be null */
  public boolean hasViewAllButton() {
    return genClient.cacheHasKey(CacheKey.viewAllButton);
  }

  /** Checks whether the 'resultLabel' field has been set, however the value could be null */
  public boolean hasResultLabel() {
    return genClient.cacheHasKey(CacheKey.resultLabel);
  }

  /** Checks whether the 'autoInstall' field has been set, however the value could be null */
  public boolean hasAutoInstall() {
    return genClient.cacheHasKey(CacheKey.autoInstall);
  }

  /** Checks whether the 'carouselApps' field has been set, however the value could be null */
  public boolean hasCarouselApps() {
    return genClient.cacheHasKey(CacheKey.carouselApps);
  }

  /** Checks whether the 'sortBy' field has been set, however the value could be null */
  public boolean hasSortBy() {
    return genClient.cacheHasKey(CacheKey.sortBy);
  }

  /** Checks whether the 'appPopulatedBy' field has been set, however the value could be null */
  public boolean hasAppPopulatedBy() {
    return genClient.cacheHasKey(CacheKey.appPopulatedBy);
  }

  /** Checks whether the 'collectionGroup' field has been set, however the value could be null */
  public boolean hasCollectionGroup() {
    return genClient.cacheHasKey(CacheKey.collectionGroup);
  }

  /** Checks whether the 'collectionStyle' field has been set, however the value could be null */
  public boolean hasCollectionStyle() {
    return genClient.cacheHasKey(CacheKey.collectionStyle);
  }

  /** Checks whether the 'showInAppMarket' field has been set, however the value could be null */
  public boolean hasShowInAppMarket() {
    return genClient.cacheHasKey(CacheKey.showInAppMarket);
  }

  /** Checks whether the 'showInAppDetail' field has been set, however the value could be null */
  public boolean hasShowInAppDetail() {
    return genClient.cacheHasKey(CacheKey.showInAppDetail);
  }

  /** Checks whether the 'showInDashboard' field has been set, however the value could be null */
  public boolean hasShowInDashboard() {
    return genClient.cacheHasKey(CacheKey.showInDashboard);
  }

  /** Checks whether the 'showInFinance' field has been set, however the value could be null */
  public boolean hasShowInFinance() {
    return genClient.cacheHasKey(CacheKey.showInFinance);
  }

  /** Checks whether the 'categories' field has been set, however the value could be null */
  public boolean hasCategories() {
    return genClient.cacheHasKey(CacheKey.categories);
  }


  /**
   * Sets the field 'id'.
   */
  public AppCarousel setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public AppCarousel setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'displayName'.
   */
  public AppCarousel setDisplayName(java.lang.String displayName) {
    return genClient.setOther(displayName, CacheKey.displayName);
  }

  /**
   * Sets the field 'description'.
   */
  public AppCarousel setDescription(java.lang.String description) {
    return genClient.setOther(description, CacheKey.description);
  }

  /**
   * Sets the field 'countryCode'.
   */
  public AppCarousel setCountryCode(java.lang.String countryCode) {
    return genClient.setOther(countryCode, CacheKey.countryCode);
  }

  /**
   * Sets the field 'reseller'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppCarousel setReseller(com.clover.sdk.v3.base.Reference reseller) {
    return genClient.setRecord(reseller, CacheKey.reseller);
  }

  /**
   * Sets the field 'merchantGroup'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppCarousel setMerchantGroup(com.clover.sdk.v3.base.Reference merchantGroup) {
    return genClient.setRecord(merchantGroup, CacheKey.merchantGroup);
  }

  /**
   * Sets the field 'maxSize'.
   */
  public AppCarousel setMaxSize(java.lang.Integer maxSize) {
    return genClient.setOther(maxSize, CacheKey.maxSize);
  }

  /**
   * Sets the field 'sortOrder'.
   */
  public AppCarousel setSortOrder(java.lang.Long sortOrder) {
    return genClient.setOther(sortOrder, CacheKey.sortOrder);
  }

  /**
   * Sets the field 'viewAllButton'.
   */
  public AppCarousel setViewAllButton(java.lang.String viewAllButton) {
    return genClient.setOther(viewAllButton, CacheKey.viewAllButton);
  }

  /**
   * Sets the field 'resultLabel'.
   */
  public AppCarousel setResultLabel(java.lang.String resultLabel) {
    return genClient.setOther(resultLabel, CacheKey.resultLabel);
  }

  /**
   * Sets the field 'autoInstall'.
   */
  public AppCarousel setAutoInstall(java.lang.Boolean autoInstall) {
    return genClient.setOther(autoInstall, CacheKey.autoInstall);
  }

  /**
   * Sets the field 'carouselApps'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public AppCarousel setCarouselApps(java.util.List<com.clover.sdk.v3.base.Reference> carouselApps) {
    return genClient.setArrayRecord(carouselApps, CacheKey.carouselApps);
  }

  /**
   * Sets the field 'sortBy'.
   */
  public AppCarousel setSortBy(com.clover.sdk.v3.apps.CarouselSortBy sortBy) {
    return genClient.setOther(sortBy, CacheKey.sortBy);
  }

  /**
   * Sets the field 'appPopulatedBy'.
   */
  public AppCarousel setAppPopulatedBy(com.clover.sdk.v3.apps.AppCollectionPopulation appPopulatedBy) {
    return genClient.setOther(appPopulatedBy, CacheKey.appPopulatedBy);
  }

  /**
   * Sets the field 'collectionGroup'.
   */
  public AppCarousel setCollectionGroup(com.clover.sdk.v3.apps.AppCollectionGroup collectionGroup) {
    return genClient.setOther(collectionGroup, CacheKey.collectionGroup);
  }

  /**
   * Sets the field 'collectionStyle'.
   */
  public AppCarousel setCollectionStyle(com.clover.sdk.v3.apps.AppCollectionStyle collectionStyle) {
    return genClient.setOther(collectionStyle, CacheKey.collectionStyle);
  }

  /**
   * Sets the field 'showInAppMarket'.
   */
  public AppCarousel setShowInAppMarket(java.lang.Boolean showInAppMarket) {
    return genClient.setOther(showInAppMarket, CacheKey.showInAppMarket);
  }

  /**
   * Sets the field 'showInAppDetail'.
   */
  public AppCarousel setShowInAppDetail(java.lang.Boolean showInAppDetail) {
    return genClient.setOther(showInAppDetail, CacheKey.showInAppDetail);
  }

  /**
   * Sets the field 'showInDashboard'.
   */
  public AppCarousel setShowInDashboard(java.lang.Boolean showInDashboard) {
    return genClient.setOther(showInDashboard, CacheKey.showInDashboard);
  }

  /**
   * Sets the field 'showInFinance'.
   */
  public AppCarousel setShowInFinance(java.lang.Boolean showInFinance) {
    return genClient.setOther(showInFinance, CacheKey.showInFinance);
  }

  /**
   * Sets the field 'categories'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public AppCarousel setCategories(java.util.List<com.clover.sdk.v3.base.Reference> categories) {
    return genClient.setArrayRecord(categories, CacheKey.categories);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'displayName' field, the 'has' method for this field will now return false */
  public void clearDisplayName() {
    genClient.clear(CacheKey.displayName);
  }
  /** Clears the 'description' field, the 'has' method for this field will now return false */
  public void clearDescription() {
    genClient.clear(CacheKey.description);
  }
  /** Clears the 'countryCode' field, the 'has' method for this field will now return false */
  public void clearCountryCode() {
    genClient.clear(CacheKey.countryCode);
  }
  /** Clears the 'reseller' field, the 'has' method for this field will now return false */
  public void clearReseller() {
    genClient.clear(CacheKey.reseller);
  }
  /** Clears the 'merchantGroup' field, the 'has' method for this field will now return false */
  public void clearMerchantGroup() {
    genClient.clear(CacheKey.merchantGroup);
  }
  /** Clears the 'maxSize' field, the 'has' method for this field will now return false */
  public void clearMaxSize() {
    genClient.clear(CacheKey.maxSize);
  }
  /** Clears the 'sortOrder' field, the 'has' method for this field will now return false */
  public void clearSortOrder() {
    genClient.clear(CacheKey.sortOrder);
  }
  /** Clears the 'viewAllButton' field, the 'has' method for this field will now return false */
  public void clearViewAllButton() {
    genClient.clear(CacheKey.viewAllButton);
  }
  /** Clears the 'resultLabel' field, the 'has' method for this field will now return false */
  public void clearResultLabel() {
    genClient.clear(CacheKey.resultLabel);
  }
  /** Clears the 'autoInstall' field, the 'has' method for this field will now return false */
  public void clearAutoInstall() {
    genClient.clear(CacheKey.autoInstall);
  }
  /** Clears the 'carouselApps' field, the 'has' method for this field will now return false */
  public void clearCarouselApps() {
    genClient.clear(CacheKey.carouselApps);
  }
  /** Clears the 'sortBy' field, the 'has' method for this field will now return false */
  public void clearSortBy() {
    genClient.clear(CacheKey.sortBy);
  }
  /** Clears the 'appPopulatedBy' field, the 'has' method for this field will now return false */
  public void clearAppPopulatedBy() {
    genClient.clear(CacheKey.appPopulatedBy);
  }
  /** Clears the 'collectionGroup' field, the 'has' method for this field will now return false */
  public void clearCollectionGroup() {
    genClient.clear(CacheKey.collectionGroup);
  }
  /** Clears the 'collectionStyle' field, the 'has' method for this field will now return false */
  public void clearCollectionStyle() {
    genClient.clear(CacheKey.collectionStyle);
  }
  /** Clears the 'showInAppMarket' field, the 'has' method for this field will now return false */
  public void clearShowInAppMarket() {
    genClient.clear(CacheKey.showInAppMarket);
  }
  /** Clears the 'showInAppDetail' field, the 'has' method for this field will now return false */
  public void clearShowInAppDetail() {
    genClient.clear(CacheKey.showInAppDetail);
  }
  /** Clears the 'showInDashboard' field, the 'has' method for this field will now return false */
  public void clearShowInDashboard() {
    genClient.clear(CacheKey.showInDashboard);
  }
  /** Clears the 'showInFinance' field, the 'has' method for this field will now return false */
  public void clearShowInFinance() {
    genClient.clear(CacheKey.showInFinance);
  }
  /** Clears the 'categories' field, the 'has' method for this field will now return false */
  public void clearCategories() {
    genClient.clear(CacheKey.categories);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AppCarousel copyChanges() {
    AppCarousel copy = new AppCarousel();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AppCarousel src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AppCarousel(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AppCarousel> CREATOR = new android.os.Parcelable.Creator<AppCarousel>() {
    @Override
    public AppCarousel createFromParcel(android.os.Parcel in) {
      AppCarousel instance = new AppCarousel(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AppCarousel[] newArray(int size) {
      return new AppCarousel[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AppCarousel> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AppCarousel>() {
    public Class<AppCarousel> getCreatedClass() {
      return AppCarousel.class;
    }

    @Override
    public AppCarousel create(org.json.JSONObject jsonObject) {
      return new AppCarousel(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = true;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean DISPLAYNAME_IS_REQUIRED = true;
    public static final long DISPLAYNAME_MAX_LEN = 127;
    public static final boolean DESCRIPTION_IS_REQUIRED = false;
    public static final boolean COUNTRYCODE_IS_REQUIRED = true;
    public static final long COUNTRYCODE_MAX_LEN = 2;
    public static final boolean RESELLER_IS_REQUIRED = false;
    public static final boolean MERCHANTGROUP_IS_REQUIRED = false;
    public static final boolean MAXSIZE_IS_REQUIRED = true;
    public static final boolean SORTORDER_IS_REQUIRED = false;
    public static final boolean VIEWALLBUTTON_IS_REQUIRED = false;
    public static final long VIEWALLBUTTON_MAX_LEN = 127;
    public static final boolean RESULTLABEL_IS_REQUIRED = false;
    public static final long RESULTLABEL_MAX_LEN = 127;
    public static final boolean AUTOINSTALL_IS_REQUIRED = false;
    public static final boolean CAROUSELAPPS_IS_REQUIRED = false;
    public static final boolean SORTBY_IS_REQUIRED = false;
    public static final boolean APPPOPULATEDBY_IS_REQUIRED = true;
    public static final boolean COLLECTIONGROUP_IS_REQUIRED = false;
    public static final boolean COLLECTIONSTYLE_IS_REQUIRED = true;
    public static final boolean SHOWINAPPMARKET_IS_REQUIRED = false;
    public static final boolean SHOWINAPPDETAIL_IS_REQUIRED = false;
    public static final boolean SHOWINDASHBOARD_IS_REQUIRED = false;
    public static final boolean SHOWINFINANCE_IS_REQUIRED = false;
    public static final boolean CATEGORIES_IS_REQUIRED = false;
  }

}
