/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getAction action}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getCountry country}</li>
 * <li>{@link #getActive active}</li>
 * <li>{@link #getAppMetered appMetered}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AppMeteredCountry extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * App metered action
   */
  public java.lang.String getAction() {
    return genClient.cacheGet(CacheKey.action);
  }

  /**
   * The cost of the metered country
   */
  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * The country of the metered country
   */
  public java.lang.String getCountry() {
    return genClient.cacheGet(CacheKey.country);
  }

  /**
   * App metered country active status
   */
  public java.lang.Boolean getActive() {
    return genClient.cacheGet(CacheKey.active);
  }

  /**
   * Reference to metered this metered country belongs to
   */
  public com.clover.sdk.v3.base.Reference getAppMetered() {
    return genClient.cacheGet(CacheKey.appMetered);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    action
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    country
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    active
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    appMetered
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AppMeteredCountry> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AppMeteredCountry() {
    genClient = new GenericClient<AppMeteredCountry>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AppMeteredCountry(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AppMeteredCountry(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AppMeteredCountry(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AppMeteredCountry(AppMeteredCountry src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.action, getAction());
    genClient.validateLength(CacheKey.action, getAction(), 40);

    genClient.validateNotNull(CacheKey.amount, getAmount());
    genClient.validateMin(CacheKey.amount, getAmount(), 0L);

    genClient.validateNotNull(CacheKey.country, getCountry());
    genClient.validateLength(CacheKey.country, getCountry(), 2);
    genClient.validateReferences(CacheKey.appMetered);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'action' field is set and is not null */
  public boolean isNotNullAction() {
    return genClient.cacheValueIsNotNull(CacheKey.action);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'country' field is set and is not null */
  public boolean isNotNullCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.country);
  }

  /** Checks whether the 'active' field is set and is not null */
  public boolean isNotNullActive() {
    return genClient.cacheValueIsNotNull(CacheKey.active);
  }

  /** Checks whether the 'appMetered' field is set and is not null */
  public boolean isNotNullAppMetered() {
    return genClient.cacheValueIsNotNull(CacheKey.appMetered);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'action' field has been set, however the value could be null */
  public boolean hasAction() {
    return genClient.cacheHasKey(CacheKey.action);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'country' field has been set, however the value could be null */
  public boolean hasCountry() {
    return genClient.cacheHasKey(CacheKey.country);
  }

  /** Checks whether the 'active' field has been set, however the value could be null */
  public boolean hasActive() {
    return genClient.cacheHasKey(CacheKey.active);
  }

  /** Checks whether the 'appMetered' field has been set, however the value could be null */
  public boolean hasAppMetered() {
    return genClient.cacheHasKey(CacheKey.appMetered);
  }


  /**
   * Sets the field 'id'.
   */
  public AppMeteredCountry setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'action'.
   */
  public AppMeteredCountry setAction(java.lang.String action) {
    return genClient.setOther(action, CacheKey.action);
  }

  /**
   * Sets the field 'amount'.
   */
  public AppMeteredCountry setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'country'.
   */
  public AppMeteredCountry setCountry(java.lang.String country) {
    return genClient.setOther(country, CacheKey.country);
  }

  /**
   * Sets the field 'active'.
   */
  public AppMeteredCountry setActive(java.lang.Boolean active) {
    return genClient.setOther(active, CacheKey.active);
  }

  /**
   * Sets the field 'appMetered'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppMeteredCountry setAppMetered(com.clover.sdk.v3.base.Reference appMetered) {
    return genClient.setRecord(appMetered, CacheKey.appMetered);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'action' field, the 'has' method for this field will now return false */
  public void clearAction() {
    genClient.clear(CacheKey.action);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'country' field, the 'has' method for this field will now return false */
  public void clearCountry() {
    genClient.clear(CacheKey.country);
  }
  /** Clears the 'active' field, the 'has' method for this field will now return false */
  public void clearActive() {
    genClient.clear(CacheKey.active);
  }
  /** Clears the 'appMetered' field, the 'has' method for this field will now return false */
  public void clearAppMetered() {
    genClient.clear(CacheKey.appMetered);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AppMeteredCountry copyChanges() {
    AppMeteredCountry copy = new AppMeteredCountry();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AppMeteredCountry src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AppMeteredCountry(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AppMeteredCountry> CREATOR = new android.os.Parcelable.Creator<AppMeteredCountry>() {
    @Override
    public AppMeteredCountry createFromParcel(android.os.Parcel in) {
      AppMeteredCountry instance = new AppMeteredCountry(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AppMeteredCountry[] newArray(int size) {
      return new AppMeteredCountry[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AppMeteredCountry> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AppMeteredCountry>() {
    public Class<AppMeteredCountry> getCreatedClass() {
      return AppMeteredCountry.class;
    }

    @Override
    public AppMeteredCountry create(org.json.JSONObject jsonObject) {
      return new AppMeteredCountry(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean ACTION_IS_REQUIRED = true;
    public static final long ACTION_MAX_LEN = 40;
    public static final boolean AMOUNT_IS_REQUIRED = true;
    public static final long AMOUNT_MIN = 0;
    public static final boolean COUNTRY_IS_REQUIRED = true;
    public static final long COUNTRY_MAX_LEN = 2;
    public static final boolean ACTIVE_IS_REQUIRED = false;
    public static final boolean APPMETERED_IS_REQUIRED = false;
  }

}
