/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getApp app}</li>
 * <li>{@link #getEvent event}</li>
 * <li>{@link #getTimeToLive timeToLive}</li>
 * <li>{@link #getData data}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class AppNotification extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * The app the notification will be sent to. This will be autopopulated by the server.
   */
  public com.clover.sdk.v3.base.Reference getApp() {
    return genClient.cacheGet(CacheKey.app);
  }

  /**
   * 
   */
  public java.lang.String getEvent() {
    return genClient.cacheGet(CacheKey.event);
  }

  /**
   * The time to live of the notification in seconds. By default this is 5 days.
   */
  public java.lang.Long getTimeToLive() {
    return genClient.cacheGet(CacheKey.timeToLive);
  }

  /**
   * Payload of the notification. This is at most 4000 characters.
   */
  public java.lang.String getData() {
    return genClient.cacheGet(CacheKey.data);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    app
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    event
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    timeToLive
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    data
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<AppNotification> genClient;

  /**
   * Constructs a new empty instance.
   */
  public AppNotification() {
    genClient = new GenericClient<AppNotification>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected AppNotification(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public AppNotification(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public AppNotification(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public AppNotification(AppNotification src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {

    genClient.validateLength(CacheKey.event, getEvent(), 255);

    genClient.validateLength(CacheKey.data, getData(), 4000);
    genClient.validateReferences(CacheKey.app);
  }

  /** Checks whether the 'app' field is set and is not null */
  public boolean isNotNullApp() {
    return genClient.cacheValueIsNotNull(CacheKey.app);
  }

  /** Checks whether the 'event' field is set and is not null */
  public boolean isNotNullEvent() {
    return genClient.cacheValueIsNotNull(CacheKey.event);
  }

  /** Checks whether the 'timeToLive' field is set and is not null */
  public boolean isNotNullTimeToLive() {
    return genClient.cacheValueIsNotNull(CacheKey.timeToLive);
  }

  /** Checks whether the 'data' field is set and is not null */
  public boolean isNotNullData() {
    return genClient.cacheValueIsNotNull(CacheKey.data);
  }



  /** Checks whether the 'app' field has been set, however the value could be null */
  public boolean hasApp() {
    return genClient.cacheHasKey(CacheKey.app);
  }

  /** Checks whether the 'event' field has been set, however the value could be null */
  public boolean hasEvent() {
    return genClient.cacheHasKey(CacheKey.event);
  }

  /** Checks whether the 'timeToLive' field has been set, however the value could be null */
  public boolean hasTimeToLive() {
    return genClient.cacheHasKey(CacheKey.timeToLive);
  }

  /** Checks whether the 'data' field has been set, however the value could be null */
  public boolean hasData() {
    return genClient.cacheHasKey(CacheKey.data);
  }


  /**
   * Sets the field 'app'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public AppNotification setApp(com.clover.sdk.v3.base.Reference app) {
    return genClient.setRecord(app, CacheKey.app);
  }

  /**
   * Sets the field 'event'.
   */
  public AppNotification setEvent(java.lang.String event) {
    return genClient.setOther(event, CacheKey.event);
  }

  /**
   * Sets the field 'timeToLive'.
   */
  public AppNotification setTimeToLive(java.lang.Long timeToLive) {
    return genClient.setOther(timeToLive, CacheKey.timeToLive);
  }

  /**
   * Sets the field 'data'.
   */
  public AppNotification setData(java.lang.String data) {
    return genClient.setOther(data, CacheKey.data);
  }


  /** Clears the 'app' field, the 'has' method for this field will now return false */
  public void clearApp() {
    genClient.clear(CacheKey.app);
  }
  /** Clears the 'event' field, the 'has' method for this field will now return false */
  public void clearEvent() {
    genClient.clear(CacheKey.event);
  }
  /** Clears the 'timeToLive' field, the 'has' method for this field will now return false */
  public void clearTimeToLive() {
    genClient.clear(CacheKey.timeToLive);
  }
  /** Clears the 'data' field, the 'has' method for this field will now return false */
  public void clearData() {
    genClient.clear(CacheKey.data);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public AppNotification copyChanges() {
    AppNotification copy = new AppNotification();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(AppNotification src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new AppNotification(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<AppNotification> CREATOR = new android.os.Parcelable.Creator<AppNotification>() {
    @Override
    public AppNotification createFromParcel(android.os.Parcel in) {
      AppNotification instance = new AppNotification(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public AppNotification[] newArray(int size) {
      return new AppNotification[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<AppNotification> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<AppNotification>() {
    public Class<AppNotification> getCreatedClass() {
      return AppNotification.class;
    }

    @Override
    public AppNotification create(org.json.JSONObject jsonObject) {
      return new AppNotification(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean APP_IS_REQUIRED = false;
    public static final boolean EVENT_IS_REQUIRED = false;
    public static final long EVENT_MAX_LEN = 255;
    public static final boolean TIMETOLIVE_IS_REQUIRED = false;
    public static final boolean DATA_IS_REQUIRED = false;
    public static final long DATA_MAX_LEN = 4000;
  }

}
