/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.apps;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * Mapping between MCC to AppCarousel. Schema should never be exposed to endpoints. Instead use AppCarousel schema to expose the association.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getMccCode mccCode}</li>
 * <li>{@link #getAppCarousel appCarousel}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MccAppCarousel extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.Integer getMccCode() {
    return genClient.cacheGet(CacheKey.mccCode);
  }

  /**
   * The AppCarousel of interest.
   */
  public com.clover.sdk.v3.base.Reference getAppCarousel() {
    return genClient.cacheGet(CacheKey.appCarousel);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    mccCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    appCarousel
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MccAppCarousel> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MccAppCarousel() {
    genClient = new GenericClient<MccAppCarousel>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MccAppCarousel(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MccAppCarousel(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MccAppCarousel(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MccAppCarousel(MccAppCarousel src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateNotNull(CacheKey.mccCode, getMccCode());

    genClient.validateNotNull(CacheKey.appCarousel, getAppCarousel());
    genClient.validateReferences(CacheKey.appCarousel);
  }

  /** Checks whether the 'mccCode' field is set and is not null */
  public boolean isNotNullMccCode() {
    return genClient.cacheValueIsNotNull(CacheKey.mccCode);
  }

  /** Checks whether the 'appCarousel' field is set and is not null */
  public boolean isNotNullAppCarousel() {
    return genClient.cacheValueIsNotNull(CacheKey.appCarousel);
  }



  /** Checks whether the 'mccCode' field has been set, however the value could be null */
  public boolean hasMccCode() {
    return genClient.cacheHasKey(CacheKey.mccCode);
  }

  /** Checks whether the 'appCarousel' field has been set, however the value could be null */
  public boolean hasAppCarousel() {
    return genClient.cacheHasKey(CacheKey.appCarousel);
  }


  /**
   * Sets the field 'mccCode'.
   */
  public MccAppCarousel setMccCode(java.lang.Integer mccCode) {
    return genClient.setOther(mccCode, CacheKey.mccCode);
  }

  /**
   * Sets the field 'appCarousel'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MccAppCarousel setAppCarousel(com.clover.sdk.v3.base.Reference appCarousel) {
    return genClient.setRecord(appCarousel, CacheKey.appCarousel);
  }


  /** Clears the 'mccCode' field, the 'has' method for this field will now return false */
  public void clearMccCode() {
    genClient.clear(CacheKey.mccCode);
  }
  /** Clears the 'appCarousel' field, the 'has' method for this field will now return false */
  public void clearAppCarousel() {
    genClient.clear(CacheKey.appCarousel);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MccAppCarousel copyChanges() {
    MccAppCarousel copy = new MccAppCarousel();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MccAppCarousel src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MccAppCarousel(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MccAppCarousel> CREATOR = new android.os.Parcelable.Creator<MccAppCarousel>() {
    @Override
    public MccAppCarousel createFromParcel(android.os.Parcel in) {
      MccAppCarousel instance = new MccAppCarousel(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MccAppCarousel[] newArray(int size) {
      return new MccAppCarousel[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MccAppCarousel> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MccAppCarousel>() {
    public Class<MccAppCarousel> getCreatedClass() {
      return MccAppCarousel.class;
    }

    @Override
    public MccAppCarousel create(org.json.JSONObject jsonObject) {
      return new MccAppCarousel(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean MCCCODE_IS_REQUIRED = true;
    public static final boolean APPCAROUSEL_IS_REQUIRED = true;
  }

}
