/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.base;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getCountryCode countryCode}</li>
 * <li>{@link #getDisplayName displayName}</li>
 * <li>{@link #getLocalDisplayName localDisplayName}</li>
 * <li>{@link #getDefaultCurrency defaultCurrency}</li>
 * <li>{@link #getDefaultTimezone defaultTimezone}</li>
 * <li>{@link #getStateProvinceRequired stateProvinceRequired}</li>
 * <li>{@link #getZipPostalRequired zipPostalRequired}</li>
 * <li>{@link #getCountyRequired countyRequired}</li>
 * <li>{@link #getDefaultLocale defaultLocale}</li>
 * <li>{@link #getAppMarketBillingEnabled appMarketBillingEnabled}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CountryInfo extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * ISO 3166-1-alpha-2 code
   */
  public java.lang.String getCountryCode() {
    return genClient.cacheGet(CacheKey.countryCode);
  }

  public java.lang.String getDisplayName() {
    return genClient.cacheGet(CacheKey.displayName);
  }

  public java.lang.String getLocalDisplayName() {
    return genClient.cacheGet(CacheKey.localDisplayName);
  }

  public java.lang.String getDefaultCurrency() {
    return genClient.cacheGet(CacheKey.defaultCurrency);
  }

  public java.lang.String getDefaultTimezone() {
    return genClient.cacheGet(CacheKey.defaultTimezone);
  }

  /**
   * Indicates whether the state/province field is required when creating the address
   */
  public java.lang.Boolean getStateProvinceRequired() {
    return genClient.cacheGet(CacheKey.stateProvinceRequired);
  }

  /**
   * Indicates whether the ZIP/Postal code field is required when creating the address
   */
  public java.lang.Boolean getZipPostalRequired() {
    return genClient.cacheGet(CacheKey.zipPostalRequired);
  }

  /**
   * Indicates whether the county field is required when creating the address
   */
  public java.lang.Boolean getCountyRequired() {
    return genClient.cacheGet(CacheKey.countyRequired);
  }

  public java.lang.String getDefaultLocale() {
    return genClient.cacheGet(CacheKey.defaultLocale);
  }

  /**
   * Indicates whether the country is enabled for app market billing
   */
  public java.lang.Boolean getAppMarketBillingEnabled() {
    return genClient.cacheGet(CacheKey.appMarketBillingEnabled);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    countryCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    displayName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    localDisplayName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    defaultCurrency
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    defaultTimezone
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    stateProvinceRequired
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    zipPostalRequired
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    countyRequired
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    defaultLocale
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    appMarketBillingEnabled
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<CountryInfo> genClient;

  /**
   * Constructs a new empty instance.
   */
  public CountryInfo() {
    genClient = new GenericClient<CountryInfo>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected CountryInfo(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CountryInfo(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CountryInfo(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CountryInfo(CountryInfo src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateLength(CacheKey.countryCode, getCountryCode(), 2);

    genClient.validateLength(CacheKey.defaultCurrency, getDefaultCurrency(), 3);

    genClient.validateLength(CacheKey.defaultTimezone, getDefaultTimezone(), 255);

    genClient.validateLength(CacheKey.defaultLocale, getDefaultLocale(), 5);
  }

  /** Checks whether the 'countryCode' field is set and is not null */
  public boolean isNotNullCountryCode() {
    return genClient.cacheValueIsNotNull(CacheKey.countryCode);
  }

  /** Checks whether the 'displayName' field is set and is not null */
  public boolean isNotNullDisplayName() {
    return genClient.cacheValueIsNotNull(CacheKey.displayName);
  }

  /** Checks whether the 'localDisplayName' field is set and is not null */
  public boolean isNotNullLocalDisplayName() {
    return genClient.cacheValueIsNotNull(CacheKey.localDisplayName);
  }

  /** Checks whether the 'defaultCurrency' field is set and is not null */
  public boolean isNotNullDefaultCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'defaultTimezone' field is set and is not null */
  public boolean isNotNullDefaultTimezone() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultTimezone);
  }

  /** Checks whether the 'stateProvinceRequired' field is set and is not null */
  public boolean isNotNullStateProvinceRequired() {
    return genClient.cacheValueIsNotNull(CacheKey.stateProvinceRequired);
  }

  /** Checks whether the 'zipPostalRequired' field is set and is not null */
  public boolean isNotNullZipPostalRequired() {
    return genClient.cacheValueIsNotNull(CacheKey.zipPostalRequired);
  }

  /** Checks whether the 'countyRequired' field is set and is not null */
  public boolean isNotNullCountyRequired() {
    return genClient.cacheValueIsNotNull(CacheKey.countyRequired);
  }

  /** Checks whether the 'defaultLocale' field is set and is not null */
  public boolean isNotNullDefaultLocale() {
    return genClient.cacheValueIsNotNull(CacheKey.defaultLocale);
  }

  /** Checks whether the 'appMarketBillingEnabled' field is set and is not null */
  public boolean isNotNullAppMarketBillingEnabled() {
    return genClient.cacheValueIsNotNull(CacheKey.appMarketBillingEnabled);
  }



  /** Checks whether the 'countryCode' field has been set, however the value could be null */
  public boolean hasCountryCode() {
    return genClient.cacheHasKey(CacheKey.countryCode);
  }

  /** Checks whether the 'displayName' field has been set, however the value could be null */
  public boolean hasDisplayName() {
    return genClient.cacheHasKey(CacheKey.displayName);
  }

  /** Checks whether the 'localDisplayName' field has been set, however the value could be null */
  public boolean hasLocalDisplayName() {
    return genClient.cacheHasKey(CacheKey.localDisplayName);
  }

  /** Checks whether the 'defaultCurrency' field has been set, however the value could be null */
  public boolean hasDefaultCurrency() {
    return genClient.cacheHasKey(CacheKey.defaultCurrency);
  }

  /** Checks whether the 'defaultTimezone' field has been set, however the value could be null */
  public boolean hasDefaultTimezone() {
    return genClient.cacheHasKey(CacheKey.defaultTimezone);
  }

  /** Checks whether the 'stateProvinceRequired' field has been set, however the value could be null */
  public boolean hasStateProvinceRequired() {
    return genClient.cacheHasKey(CacheKey.stateProvinceRequired);
  }

  /** Checks whether the 'zipPostalRequired' field has been set, however the value could be null */
  public boolean hasZipPostalRequired() {
    return genClient.cacheHasKey(CacheKey.zipPostalRequired);
  }

  /** Checks whether the 'countyRequired' field has been set, however the value could be null */
  public boolean hasCountyRequired() {
    return genClient.cacheHasKey(CacheKey.countyRequired);
  }

  /** Checks whether the 'defaultLocale' field has been set, however the value could be null */
  public boolean hasDefaultLocale() {
    return genClient.cacheHasKey(CacheKey.defaultLocale);
  }

  /** Checks whether the 'appMarketBillingEnabled' field has been set, however the value could be null */
  public boolean hasAppMarketBillingEnabled() {
    return genClient.cacheHasKey(CacheKey.appMarketBillingEnabled);
  }


  /**
   * Sets the field 'countryCode'.
   */
  public CountryInfo setCountryCode(java.lang.String countryCode) {
    return genClient.setOther(countryCode, CacheKey.countryCode);
  }

  /**
   * Sets the field 'displayName'.
   */
  public CountryInfo setDisplayName(java.lang.String displayName) {
    return genClient.setOther(displayName, CacheKey.displayName);
  }

  /**
   * Sets the field 'localDisplayName'.
   */
  public CountryInfo setLocalDisplayName(java.lang.String localDisplayName) {
    return genClient.setOther(localDisplayName, CacheKey.localDisplayName);
  }

  /**
   * Sets the field 'defaultCurrency'.
   */
  public CountryInfo setDefaultCurrency(java.lang.String defaultCurrency) {
    return genClient.setOther(defaultCurrency, CacheKey.defaultCurrency);
  }

  /**
   * Sets the field 'defaultTimezone'.
   */
  public CountryInfo setDefaultTimezone(java.lang.String defaultTimezone) {
    return genClient.setOther(defaultTimezone, CacheKey.defaultTimezone);
  }

  /**
   * Sets the field 'stateProvinceRequired'.
   */
  public CountryInfo setStateProvinceRequired(java.lang.Boolean stateProvinceRequired) {
    return genClient.setOther(stateProvinceRequired, CacheKey.stateProvinceRequired);
  }

  /**
   * Sets the field 'zipPostalRequired'.
   */
  public CountryInfo setZipPostalRequired(java.lang.Boolean zipPostalRequired) {
    return genClient.setOther(zipPostalRequired, CacheKey.zipPostalRequired);
  }

  /**
   * Sets the field 'countyRequired'.
   */
  public CountryInfo setCountyRequired(java.lang.Boolean countyRequired) {
    return genClient.setOther(countyRequired, CacheKey.countyRequired);
  }

  /**
   * Sets the field 'defaultLocale'.
   */
  public CountryInfo setDefaultLocale(java.lang.String defaultLocale) {
    return genClient.setOther(defaultLocale, CacheKey.defaultLocale);
  }

  /**
   * Sets the field 'appMarketBillingEnabled'.
   */
  public CountryInfo setAppMarketBillingEnabled(java.lang.Boolean appMarketBillingEnabled) {
    return genClient.setOther(appMarketBillingEnabled, CacheKey.appMarketBillingEnabled);
  }


  /** Clears the 'countryCode' field, the 'has' method for this field will now return false */
  public void clearCountryCode() {
    genClient.clear(CacheKey.countryCode);
  }
  /** Clears the 'displayName' field, the 'has' method for this field will now return false */
  public void clearDisplayName() {
    genClient.clear(CacheKey.displayName);
  }
  /** Clears the 'localDisplayName' field, the 'has' method for this field will now return false */
  public void clearLocalDisplayName() {
    genClient.clear(CacheKey.localDisplayName);
  }
  /** Clears the 'defaultCurrency' field, the 'has' method for this field will now return false */
  public void clearDefaultCurrency() {
    genClient.clear(CacheKey.defaultCurrency);
  }
  /** Clears the 'defaultTimezone' field, the 'has' method for this field will now return false */
  public void clearDefaultTimezone() {
    genClient.clear(CacheKey.defaultTimezone);
  }
  /** Clears the 'stateProvinceRequired' field, the 'has' method for this field will now return false */
  public void clearStateProvinceRequired() {
    genClient.clear(CacheKey.stateProvinceRequired);
  }
  /** Clears the 'zipPostalRequired' field, the 'has' method for this field will now return false */
  public void clearZipPostalRequired() {
    genClient.clear(CacheKey.zipPostalRequired);
  }
  /** Clears the 'countyRequired' field, the 'has' method for this field will now return false */
  public void clearCountyRequired() {
    genClient.clear(CacheKey.countyRequired);
  }
  /** Clears the 'defaultLocale' field, the 'has' method for this field will now return false */
  public void clearDefaultLocale() {
    genClient.clear(CacheKey.defaultLocale);
  }
  /** Clears the 'appMarketBillingEnabled' field, the 'has' method for this field will now return false */
  public void clearAppMarketBillingEnabled() {
    genClient.clear(CacheKey.appMarketBillingEnabled);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CountryInfo copyChanges() {
    CountryInfo copy = new CountryInfo();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CountryInfo src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CountryInfo(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CountryInfo> CREATOR = new android.os.Parcelable.Creator<CountryInfo>() {
    @Override
    public CountryInfo createFromParcel(android.os.Parcel in) {
      CountryInfo instance = new CountryInfo(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CountryInfo[] newArray(int size) {
      return new CountryInfo[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CountryInfo> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CountryInfo>() {
    public Class<CountryInfo> getCreatedClass() {
      return CountryInfo.class;
    }

    @Override
    public CountryInfo create(org.json.JSONObject jsonObject) {
      return new CountryInfo(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean COUNTRYCODE_IS_REQUIRED = false;
    public static final long COUNTRYCODE_MAX_LEN = 2;
    public static final boolean DISPLAYNAME_IS_REQUIRED = false;
    public static final boolean LOCALDISPLAYNAME_IS_REQUIRED = false;
    public static final boolean DEFAULTCURRENCY_IS_REQUIRED = false;
    public static final long DEFAULTCURRENCY_MAX_LEN = 3;
    public static final boolean DEFAULTTIMEZONE_IS_REQUIRED = false;
    public static final long DEFAULTTIMEZONE_MAX_LEN = 255;
    public static final boolean STATEPROVINCEREQUIRED_IS_REQUIRED = false;
    public static final boolean ZIPPOSTALREQUIRED_IS_REQUIRED = false;
    public static final boolean COUNTYREQUIRED_IS_REQUIRED = false;
    public static final boolean DEFAULTLOCALE_IS_REQUIRED = false;
    public static final long DEFAULTLOCALE_MAX_LEN = 5;
    public static final boolean APPMARKETBILLINGENABLED_IS_REQUIRED = false;
  }

}
