/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.billing;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getCurrency currency}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getTax tax}</li>
 * <li>{@link #getDeveloperPortion developerPortion}</li>
 * <li>{@link #getStatus status}</li>
 * <li>{@link #getType type}</li>
 * <li>{@link #getTaxClassificationCode taxClassificationCode}</li>
 * <li>{@link #getStartDate startDate}</li>
 * <li>{@link #getEndDate endDate}</li>
 * <li>{@link #getExportMonth exportMonth}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getMerchantAppCharge merchantAppCharge}</li>
 * <li>{@link #getMerchantPlanCharge merchantPlanCharge}</li>
 * <li>{@link #getInfoleaseChargeAttempts infoleaseChargeAttempts}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Charge extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.String getCurrency() {
    return genClient.cacheGet(CacheKey.currency);
  }

  public java.lang.Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  public java.lang.Long getTax() {
    return genClient.cacheGet(CacheKey.tax);
  }

  public java.lang.Long getDeveloperPortion() {
    return genClient.cacheGet(CacheKey.developerPortion);
  }

  public com.clover.sdk.v3.billing.ChargeStatus getStatus() {
    return genClient.cacheGet(CacheKey.status);
  }

  public com.clover.sdk.v3.billing.ChargeType getType() {
    return genClient.cacheGet(CacheKey.type);
  }

  public java.lang.String getTaxClassificationCode() {
    return genClient.cacheGet(CacheKey.taxClassificationCode);
  }

  public java.lang.Long getStartDate() {
    return genClient.cacheGet(CacheKey.startDate);
  }

  public java.lang.Long getEndDate() {
    return genClient.cacheGet(CacheKey.endDate);
  }

  public java.lang.Long getExportMonth() {
    return genClient.cacheGet(CacheKey.exportMonth);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * Object which includes the charge object and some details regarding the app charge
   */
  public com.clover.sdk.v3.base.Reference getMerchantAppCharge() {
    return genClient.cacheGet(CacheKey.merchantAppCharge);
  }

  /**
   * Object which includes the charge object and some details regarding the plan charge
   */
  public com.clover.sdk.v3.base.Reference getMerchantPlanCharge() {
    return genClient.cacheGet(CacheKey.merchantPlanCharge);
  }

  /**
   * Infolease charge attempts
   */
  public java.util.List<com.clover.sdk.v3.billing.InfoleaseChargeAttempt> getInfoleaseChargeAttempts() {
    return genClient.cacheGet(CacheKey.infoleaseChargeAttempts);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    currency
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    tax
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    developerPortion
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    status
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.billing.ChargeStatus.class)),
    type
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.billing.ChargeType.class)),
    taxClassificationCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    startDate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    endDate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    exportMonth
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    merchantAppCharge
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    merchantPlanCharge
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    infoleaseChargeAttempts
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.billing.InfoleaseChargeAttempt.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Charge> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Charge() {
    genClient = new GenericClient<Charge>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Charge(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Charge(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Charge(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Charge(Charge src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.currency, getCurrency(), 3);

    genClient.validateNotNull(CacheKey.amount, getAmount());

    genClient.validateNotNull(CacheKey.status, getStatus());

    genClient.validateNotNull(CacheKey.type, getType());
    genClient.validateReferences(CacheKey.merchantAppCharge);
    genClient.validateReferences(CacheKey.merchantPlanCharge);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'currency' field is set and is not null */
  public boolean isNotNullCurrency() {
    return genClient.cacheValueIsNotNull(CacheKey.currency);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'tax' field is set and is not null */
  public boolean isNotNullTax() {
    return genClient.cacheValueIsNotNull(CacheKey.tax);
  }

  /** Checks whether the 'developerPortion' field is set and is not null */
  public boolean isNotNullDeveloperPortion() {
    return genClient.cacheValueIsNotNull(CacheKey.developerPortion);
  }

  /** Checks whether the 'status' field is set and is not null */
  public boolean isNotNullStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.status);
  }

  /** Checks whether the 'type' field is set and is not null */
  public boolean isNotNullType() {
    return genClient.cacheValueIsNotNull(CacheKey.type);
  }

  /** Checks whether the 'taxClassificationCode' field is set and is not null */
  public boolean isNotNullTaxClassificationCode() {
    return genClient.cacheValueIsNotNull(CacheKey.taxClassificationCode);
  }

  /** Checks whether the 'startDate' field is set and is not null */
  public boolean isNotNullStartDate() {
    return genClient.cacheValueIsNotNull(CacheKey.startDate);
  }

  /** Checks whether the 'endDate' field is set and is not null */
  public boolean isNotNullEndDate() {
    return genClient.cacheValueIsNotNull(CacheKey.endDate);
  }

  /** Checks whether the 'exportMonth' field is set and is not null */
  public boolean isNotNullExportMonth() {
    return genClient.cacheValueIsNotNull(CacheKey.exportMonth);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'merchantAppCharge' field is set and is not null */
  public boolean isNotNullMerchantAppCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantAppCharge);
  }

  /** Checks whether the 'merchantPlanCharge' field is set and is not null */
  public boolean isNotNullMerchantPlanCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantPlanCharge);
  }

  /** Checks whether the 'infoleaseChargeAttempts' field is set and is not null */
  public boolean isNotNullInfoleaseChargeAttempts() {
    return genClient.cacheValueIsNotNull(CacheKey.infoleaseChargeAttempts);
  }

  /** Checks whether the 'infoleaseChargeAttempts' field is set and is not null and is not empty */
  public boolean isNotEmptyInfoleaseChargeAttempts() { return isNotNullInfoleaseChargeAttempts() && !getInfoleaseChargeAttempts().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'currency' field has been set, however the value could be null */
  public boolean hasCurrency() {
    return genClient.cacheHasKey(CacheKey.currency);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'tax' field has been set, however the value could be null */
  public boolean hasTax() {
    return genClient.cacheHasKey(CacheKey.tax);
  }

  /** Checks whether the 'developerPortion' field has been set, however the value could be null */
  public boolean hasDeveloperPortion() {
    return genClient.cacheHasKey(CacheKey.developerPortion);
  }

  /** Checks whether the 'status' field has been set, however the value could be null */
  public boolean hasStatus() {
    return genClient.cacheHasKey(CacheKey.status);
  }

  /** Checks whether the 'type' field has been set, however the value could be null */
  public boolean hasType() {
    return genClient.cacheHasKey(CacheKey.type);
  }

  /** Checks whether the 'taxClassificationCode' field has been set, however the value could be null */
  public boolean hasTaxClassificationCode() {
    return genClient.cacheHasKey(CacheKey.taxClassificationCode);
  }

  /** Checks whether the 'startDate' field has been set, however the value could be null */
  public boolean hasStartDate() {
    return genClient.cacheHasKey(CacheKey.startDate);
  }

  /** Checks whether the 'endDate' field has been set, however the value could be null */
  public boolean hasEndDate() {
    return genClient.cacheHasKey(CacheKey.endDate);
  }

  /** Checks whether the 'exportMonth' field has been set, however the value could be null */
  public boolean hasExportMonth() {
    return genClient.cacheHasKey(CacheKey.exportMonth);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'merchantAppCharge' field has been set, however the value could be null */
  public boolean hasMerchantAppCharge() {
    return genClient.cacheHasKey(CacheKey.merchantAppCharge);
  }

  /** Checks whether the 'merchantPlanCharge' field has been set, however the value could be null */
  public boolean hasMerchantPlanCharge() {
    return genClient.cacheHasKey(CacheKey.merchantPlanCharge);
  }

  /** Checks whether the 'infoleaseChargeAttempts' field has been set, however the value could be null */
  public boolean hasInfoleaseChargeAttempts() {
    return genClient.cacheHasKey(CacheKey.infoleaseChargeAttempts);
  }


  /**
   * Sets the field 'id'.
   */
  public Charge setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'currency'.
   */
  public Charge setCurrency(java.lang.String currency) {
    return genClient.setOther(currency, CacheKey.currency);
  }

  /**
   * Sets the field 'amount'.
   */
  public Charge setAmount(java.lang.Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'tax'.
   */
  public Charge setTax(java.lang.Long tax) {
    return genClient.setOther(tax, CacheKey.tax);
  }

  /**
   * Sets the field 'developerPortion'.
   */
  public Charge setDeveloperPortion(java.lang.Long developerPortion) {
    return genClient.setOther(developerPortion, CacheKey.developerPortion);
  }

  /**
   * Sets the field 'status'.
   */
  public Charge setStatus(com.clover.sdk.v3.billing.ChargeStatus status) {
    return genClient.setOther(status, CacheKey.status);
  }

  /**
   * Sets the field 'type'.
   */
  public Charge setType(com.clover.sdk.v3.billing.ChargeType type) {
    return genClient.setOther(type, CacheKey.type);
  }

  /**
   * Sets the field 'taxClassificationCode'.
   */
  public Charge setTaxClassificationCode(java.lang.String taxClassificationCode) {
    return genClient.setOther(taxClassificationCode, CacheKey.taxClassificationCode);
  }

  /**
   * Sets the field 'startDate'.
   */
  public Charge setStartDate(java.lang.Long startDate) {
    return genClient.setOther(startDate, CacheKey.startDate);
  }

  /**
   * Sets the field 'endDate'.
   */
  public Charge setEndDate(java.lang.Long endDate) {
    return genClient.setOther(endDate, CacheKey.endDate);
  }

  /**
   * Sets the field 'exportMonth'.
   */
  public Charge setExportMonth(java.lang.Long exportMonth) {
    return genClient.setOther(exportMonth, CacheKey.exportMonth);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Charge setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Charge setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'merchantAppCharge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Charge setMerchantAppCharge(com.clover.sdk.v3.base.Reference merchantAppCharge) {
    return genClient.setRecord(merchantAppCharge, CacheKey.merchantAppCharge);
  }

  /**
   * Sets the field 'merchantPlanCharge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Charge setMerchantPlanCharge(com.clover.sdk.v3.base.Reference merchantPlanCharge) {
    return genClient.setRecord(merchantPlanCharge, CacheKey.merchantPlanCharge);
  }

  /**
   * Sets the field 'infoleaseChargeAttempts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Charge setInfoleaseChargeAttempts(java.util.List<com.clover.sdk.v3.billing.InfoleaseChargeAttempt> infoleaseChargeAttempts) {
    return genClient.setArrayRecord(infoleaseChargeAttempts, CacheKey.infoleaseChargeAttempts);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'currency' field, the 'has' method for this field will now return false */
  public void clearCurrency() {
    genClient.clear(CacheKey.currency);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'tax' field, the 'has' method for this field will now return false */
  public void clearTax() {
    genClient.clear(CacheKey.tax);
  }
  /** Clears the 'developerPortion' field, the 'has' method for this field will now return false */
  public void clearDeveloperPortion() {
    genClient.clear(CacheKey.developerPortion);
  }
  /** Clears the 'status' field, the 'has' method for this field will now return false */
  public void clearStatus() {
    genClient.clear(CacheKey.status);
  }
  /** Clears the 'type' field, the 'has' method for this field will now return false */
  public void clearType() {
    genClient.clear(CacheKey.type);
  }
  /** Clears the 'taxClassificationCode' field, the 'has' method for this field will now return false */
  public void clearTaxClassificationCode() {
    genClient.clear(CacheKey.taxClassificationCode);
  }
  /** Clears the 'startDate' field, the 'has' method for this field will now return false */
  public void clearStartDate() {
    genClient.clear(CacheKey.startDate);
  }
  /** Clears the 'endDate' field, the 'has' method for this field will now return false */
  public void clearEndDate() {
    genClient.clear(CacheKey.endDate);
  }
  /** Clears the 'exportMonth' field, the 'has' method for this field will now return false */
  public void clearExportMonth() {
    genClient.clear(CacheKey.exportMonth);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'merchantAppCharge' field, the 'has' method for this field will now return false */
  public void clearMerchantAppCharge() {
    genClient.clear(CacheKey.merchantAppCharge);
  }
  /** Clears the 'merchantPlanCharge' field, the 'has' method for this field will now return false */
  public void clearMerchantPlanCharge() {
    genClient.clear(CacheKey.merchantPlanCharge);
  }
  /** Clears the 'infoleaseChargeAttempts' field, the 'has' method for this field will now return false */
  public void clearInfoleaseChargeAttempts() {
    genClient.clear(CacheKey.infoleaseChargeAttempts);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Charge copyChanges() {
    Charge copy = new Charge();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Charge src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Charge(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Charge> CREATOR = new android.os.Parcelable.Creator<Charge>() {
    @Override
    public Charge createFromParcel(android.os.Parcel in) {
      Charge instance = new Charge(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Charge[] newArray(int size) {
      return new Charge[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Charge> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Charge>() {
    public Class<Charge> getCreatedClass() {
      return Charge.class;
    }

    @Override
    public Charge create(org.json.JSONObject jsonObject) {
      return new Charge(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean CURRENCY_IS_REQUIRED = false;
    public static final long CURRENCY_MAX_LEN = 3;
    public static final boolean AMOUNT_IS_REQUIRED = true;
    public static final boolean TAX_IS_REQUIRED = false;
    public static final boolean DEVELOPERPORTION_IS_REQUIRED = false;
    public static final boolean STATUS_IS_REQUIRED = true;
    public static final boolean TYPE_IS_REQUIRED = true;
    public static final boolean TAXCLASSIFICATIONCODE_IS_REQUIRED = false;
    public static final boolean STARTDATE_IS_REQUIRED = false;
    public static final boolean ENDDATE_IS_REQUIRED = false;
    public static final boolean EXPORTMONTH_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean MERCHANTAPPCHARGE_IS_REQUIRED = false;
    public static final boolean MERCHANTPLANCHARGE_IS_REQUIRED = false;
    public static final boolean INFOLEASECHARGEATTEMPTS_IS_REQUIRED = false;
  }

}
