/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.billing;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getCharge charge}</li>
 * <li>{@link #getApp app}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getAppSubscription appSubscription}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getAppInstallTime appInstallTime}</li>
 * <li>{@link #getAppUninstallTime appUninstallTime}</li>
 * <li>{@link #getAppMeteredEvents appMeteredEvents}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantAppCharge extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public com.clover.sdk.v3.billing.Charge getCharge() {
    return genClient.cacheGet(CacheKey.charge);
  }

  /**
   * The app that this line item belongs to.
   */
  public com.clover.sdk.v3.apps.App getApp() {
    return genClient.cacheGet(CacheKey.app);
  }

  /**
   * The merchant that belongs to this line item.
   */
  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  public com.clover.sdk.v3.base.Reference getAppSubscription() {
    return genClient.cacheGet(CacheKey.appSubscription);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * A timestamp indicating when the app was installed by the merchant
   */
  public java.lang.Long getAppInstallTime() {
    return genClient.cacheGet(CacheKey.appInstallTime);
  }

  /**
   * This is only filled in if the install that caused this app line item has been uninstalled
   */
  public java.lang.Long getAppUninstallTime() {
    return genClient.cacheGet(CacheKey.appUninstallTime);
  }

  public java.util.List<com.clover.sdk.v3.billing.AppMeteredEvent> getAppMeteredEvents() {
    return genClient.cacheGet(CacheKey.appMeteredEvents);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    charge
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.billing.Charge.JSON_CREATOR)),
    app
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.apps.App.JSON_CREATOR)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    appSubscription
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    appInstallTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    appUninstallTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    appMeteredEvents
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.billing.AppMeteredEvent.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantAppCharge> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantAppCharge() {
    genClient = new GenericClient<MerchantAppCharge>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantAppCharge(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantAppCharge(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantAppCharge(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantAppCharge(MerchantAppCharge src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateNotNull(CacheKey.app, getApp());

    genClient.validateNotNull(CacheKey.merchant, getMerchant());
    genClient.validateReferences(CacheKey.merchant);
    genClient.validateReferences(CacheKey.appSubscription);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'charge' field is set and is not null */
  public boolean isNotNullCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.charge);
  }

  /** Checks whether the 'app' field is set and is not null */
  public boolean isNotNullApp() {
    return genClient.cacheValueIsNotNull(CacheKey.app);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'appSubscription' field is set and is not null */
  public boolean isNotNullAppSubscription() {
    return genClient.cacheValueIsNotNull(CacheKey.appSubscription);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'appInstallTime' field is set and is not null */
  public boolean isNotNullAppInstallTime() {
    return genClient.cacheValueIsNotNull(CacheKey.appInstallTime);
  }

  /** Checks whether the 'appUninstallTime' field is set and is not null */
  public boolean isNotNullAppUninstallTime() {
    return genClient.cacheValueIsNotNull(CacheKey.appUninstallTime);
  }

  /** Checks whether the 'appMeteredEvents' field is set and is not null */
  public boolean isNotNullAppMeteredEvents() {
    return genClient.cacheValueIsNotNull(CacheKey.appMeteredEvents);
  }

  /** Checks whether the 'appMeteredEvents' field is set and is not null and is not empty */
  public boolean isNotEmptyAppMeteredEvents() { return isNotNullAppMeteredEvents() && !getAppMeteredEvents().isEmpty(); }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'charge' field has been set, however the value could be null */
  public boolean hasCharge() {
    return genClient.cacheHasKey(CacheKey.charge);
  }

  /** Checks whether the 'app' field has been set, however the value could be null */
  public boolean hasApp() {
    return genClient.cacheHasKey(CacheKey.app);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'appSubscription' field has been set, however the value could be null */
  public boolean hasAppSubscription() {
    return genClient.cacheHasKey(CacheKey.appSubscription);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'appInstallTime' field has been set, however the value could be null */
  public boolean hasAppInstallTime() {
    return genClient.cacheHasKey(CacheKey.appInstallTime);
  }

  /** Checks whether the 'appUninstallTime' field has been set, however the value could be null */
  public boolean hasAppUninstallTime() {
    return genClient.cacheHasKey(CacheKey.appUninstallTime);
  }

  /** Checks whether the 'appMeteredEvents' field has been set, however the value could be null */
  public boolean hasAppMeteredEvents() {
    return genClient.cacheHasKey(CacheKey.appMeteredEvents);
  }


  /**
   * Sets the field 'id'.
   */
  public MerchantAppCharge setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'charge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantAppCharge setCharge(com.clover.sdk.v3.billing.Charge charge) {
    return genClient.setRecord(charge, CacheKey.charge);
  }

  /**
   * Sets the field 'app'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantAppCharge setApp(com.clover.sdk.v3.apps.App app) {
    return genClient.setRecord(app, CacheKey.app);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantAppCharge setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'appSubscription'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantAppCharge setAppSubscription(com.clover.sdk.v3.base.Reference appSubscription) {
    return genClient.setRecord(appSubscription, CacheKey.appSubscription);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MerchantAppCharge setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MerchantAppCharge setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'appInstallTime'.
   */
  public MerchantAppCharge setAppInstallTime(java.lang.Long appInstallTime) {
    return genClient.setOther(appInstallTime, CacheKey.appInstallTime);
  }

  /**
   * Sets the field 'appUninstallTime'.
   */
  public MerchantAppCharge setAppUninstallTime(java.lang.Long appUninstallTime) {
    return genClient.setOther(appUninstallTime, CacheKey.appUninstallTime);
  }

  /**
   * Sets the field 'appMeteredEvents'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public MerchantAppCharge setAppMeteredEvents(java.util.List<com.clover.sdk.v3.billing.AppMeteredEvent> appMeteredEvents) {
    return genClient.setArrayRecord(appMeteredEvents, CacheKey.appMeteredEvents);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'charge' field, the 'has' method for this field will now return false */
  public void clearCharge() {
    genClient.clear(CacheKey.charge);
  }
  /** Clears the 'app' field, the 'has' method for this field will now return false */
  public void clearApp() {
    genClient.clear(CacheKey.app);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'appSubscription' field, the 'has' method for this field will now return false */
  public void clearAppSubscription() {
    genClient.clear(CacheKey.appSubscription);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'appInstallTime' field, the 'has' method for this field will now return false */
  public void clearAppInstallTime() {
    genClient.clear(CacheKey.appInstallTime);
  }
  /** Clears the 'appUninstallTime' field, the 'has' method for this field will now return false */
  public void clearAppUninstallTime() {
    genClient.clear(CacheKey.appUninstallTime);
  }
  /** Clears the 'appMeteredEvents' field, the 'has' method for this field will now return false */
  public void clearAppMeteredEvents() {
    genClient.clear(CacheKey.appMeteredEvents);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantAppCharge copyChanges() {
    MerchantAppCharge copy = new MerchantAppCharge();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantAppCharge src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantAppCharge(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantAppCharge> CREATOR = new android.os.Parcelable.Creator<MerchantAppCharge>() {
    @Override
    public MerchantAppCharge createFromParcel(android.os.Parcel in) {
      MerchantAppCharge instance = new MerchantAppCharge(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantAppCharge[] newArray(int size) {
      return new MerchantAppCharge[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantAppCharge> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantAppCharge>() {
    public Class<MerchantAppCharge> getCreatedClass() {
      return MerchantAppCharge.class;
    }

    @Override
    public MerchantAppCharge create(org.json.JSONObject jsonObject) {
      return new MerchantAppCharge(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean CHARGE_IS_REQUIRED = false;
    public static final boolean APP_IS_REQUIRED = true;
    public static final boolean MERCHANT_IS_REQUIRED = true;
    public static final boolean APPSUBSCRIPTION_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean APPINSTALLTIME_IS_REQUIRED = false;
    public static final boolean APPUNINSTALLTIME_IS_REQUIRED = false;
    public static final boolean APPMETEREDEVENTS_IS_REQUIRED = false;
  }

}
