/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.billing;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getCharge charge}</li>
 * <li>{@link #getPlanChargeType planChargeType}</li>
 * <li>{@link #getNumOfDevices numOfDevices}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getMerchantPlan merchantPlan}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class MerchantPlanCharge extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public com.clover.sdk.v3.billing.Charge getCharge() {
    return genClient.cacheGet(CacheKey.charge);
  }

  public com.clover.sdk.v3.billing.PlanChargeType getPlanChargeType() {
    return genClient.cacheGet(CacheKey.planChargeType);
  }

  public java.lang.Long getNumOfDevices() {
    return genClient.cacheGet(CacheKey.numOfDevices);
  }

  /**
   * The merchant that this merchant plan charge belongs to.
   */
  public com.clover.sdk.v3.merchant.Merchant getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * The merchant plan that this merchant plan charge was created for.
   */
  public com.clover.sdk.v3.merchant.MerchantPlan getMerchantPlan() {
    return genClient.cacheGet(CacheKey.merchantPlan);
  }

  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    charge
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.billing.Charge.JSON_CREATOR)),
    planChargeType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.billing.PlanChargeType.class)),
    numOfDevices
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.merchant.Merchant.JSON_CREATOR)),
    merchantPlan
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.merchant.MerchantPlan.JSON_CREATOR)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<MerchantPlanCharge> genClient;

  /**
   * Constructs a new empty instance.
   */
  public MerchantPlanCharge() {
    genClient = new GenericClient<MerchantPlanCharge>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected MerchantPlanCharge(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public MerchantPlanCharge(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public MerchantPlanCharge(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public MerchantPlanCharge(MerchantPlanCharge src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'charge' field is set and is not null */
  public boolean isNotNullCharge() {
    return genClient.cacheValueIsNotNull(CacheKey.charge);
  }

  /** Checks whether the 'planChargeType' field is set and is not null */
  public boolean isNotNullPlanChargeType() {
    return genClient.cacheValueIsNotNull(CacheKey.planChargeType);
  }

  /** Checks whether the 'numOfDevices' field is set and is not null */
  public boolean isNotNullNumOfDevices() {
    return genClient.cacheValueIsNotNull(CacheKey.numOfDevices);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'merchantPlan' field is set and is not null */
  public boolean isNotNullMerchantPlan() {
    return genClient.cacheValueIsNotNull(CacheKey.merchantPlan);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'charge' field has been set, however the value could be null */
  public boolean hasCharge() {
    return genClient.cacheHasKey(CacheKey.charge);
  }

  /** Checks whether the 'planChargeType' field has been set, however the value could be null */
  public boolean hasPlanChargeType() {
    return genClient.cacheHasKey(CacheKey.planChargeType);
  }

  /** Checks whether the 'numOfDevices' field has been set, however the value could be null */
  public boolean hasNumOfDevices() {
    return genClient.cacheHasKey(CacheKey.numOfDevices);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'merchantPlan' field has been set, however the value could be null */
  public boolean hasMerchantPlan() {
    return genClient.cacheHasKey(CacheKey.merchantPlan);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }


  /**
   * Sets the field 'id'.
   */
  public MerchantPlanCharge setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'charge'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlanCharge setCharge(com.clover.sdk.v3.billing.Charge charge) {
    return genClient.setRecord(charge, CacheKey.charge);
  }

  /**
   * Sets the field 'planChargeType'.
   */
  public MerchantPlanCharge setPlanChargeType(com.clover.sdk.v3.billing.PlanChargeType planChargeType) {
    return genClient.setOther(planChargeType, CacheKey.planChargeType);
  }

  /**
   * Sets the field 'numOfDevices'.
   */
  public MerchantPlanCharge setNumOfDevices(java.lang.Long numOfDevices) {
    return genClient.setOther(numOfDevices, CacheKey.numOfDevices);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlanCharge setMerchant(com.clover.sdk.v3.merchant.Merchant merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'merchantPlan'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public MerchantPlanCharge setMerchantPlan(com.clover.sdk.v3.merchant.MerchantPlan merchantPlan) {
    return genClient.setRecord(merchantPlan, CacheKey.merchantPlan);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public MerchantPlanCharge setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public MerchantPlanCharge setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'charge' field, the 'has' method for this field will now return false */
  public void clearCharge() {
    genClient.clear(CacheKey.charge);
  }
  /** Clears the 'planChargeType' field, the 'has' method for this field will now return false */
  public void clearPlanChargeType() {
    genClient.clear(CacheKey.planChargeType);
  }
  /** Clears the 'numOfDevices' field, the 'has' method for this field will now return false */
  public void clearNumOfDevices() {
    genClient.clear(CacheKey.numOfDevices);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'merchantPlan' field, the 'has' method for this field will now return false */
  public void clearMerchantPlan() {
    genClient.clear(CacheKey.merchantPlan);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public MerchantPlanCharge copyChanges() {
    MerchantPlanCharge copy = new MerchantPlanCharge();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(MerchantPlanCharge src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new MerchantPlanCharge(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<MerchantPlanCharge> CREATOR = new android.os.Parcelable.Creator<MerchantPlanCharge>() {
    @Override
    public MerchantPlanCharge createFromParcel(android.os.Parcel in) {
      MerchantPlanCharge instance = new MerchantPlanCharge(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public MerchantPlanCharge[] newArray(int size) {
      return new MerchantPlanCharge[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<MerchantPlanCharge> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<MerchantPlanCharge>() {
    public Class<MerchantPlanCharge> getCreatedClass() {
      return MerchantPlanCharge.class;
    }

    @Override
    public MerchantPlanCharge create(org.json.JSONObject jsonObject) {
      return new MerchantPlanCharge(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean CHARGE_IS_REQUIRED = false;
    public static final boolean PLANCHARGETYPE_IS_REQUIRED = false;
    public static final boolean NUMOFDEVICES_IS_REQUIRED = false;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean MERCHANTPLAN_IS_REQUIRED = false;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
  }

}
