/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.binhandler;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getPaymentPlatformType paymentPlatformType}</li>
 * <li>{@link #getFirst6 first6}</li>
 * <li>{@link #getLast4 last4}</li>
 * <li>{@link #getCardType cardType}</li>
 * <li>{@link #getAmount amount}</li>
 * <li>{@link #getEntryType entryType}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DynamicBinHandlerRequest extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public PaymentPlatformType getPaymentPlatformType() {
    return genClient.cacheGet(CacheKey.paymentPlatformType);
  }

  /**
   * first6 of number
   */
  public String getFirst6() {
    return genClient.cacheGet(CacheKey.first6);
  }

  /**
   * last4 of number
   */
  public String getLast4() {
    return genClient.cacheGet(CacheKey.last4);
  }

  /**
   * determined card type based on AID/GBF/etc
   */
  public com.clover.sdk.v3.payments.CardType getCardType() {
    return genClient.cacheGet(CacheKey.cardType);
  }

  /**
   * tx amount
   */
  public Long getAmount() {
    return genClient.cacheGet(CacheKey.amount);
  }

  /**
   * enum indicating if this is MSR, CONTACT, NFC, KEYED
   */
  public com.clover.sdk.v3.payments.CardEntryType getEntryType() {
    return genClient.cacheGet(CacheKey.entryType);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    paymentPlatformType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(PaymentPlatformType.class)),
    first6
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    last4
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
    cardType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.CardType.class)),
    amount
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(Long.class)),
    entryType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.payments.CardEntryType.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DynamicBinHandlerRequest> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DynamicBinHandlerRequest() {
    genClient = new GenericClient<DynamicBinHandlerRequest>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DynamicBinHandlerRequest(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DynamicBinHandlerRequest(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DynamicBinHandlerRequest(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DynamicBinHandlerRequest(DynamicBinHandlerRequest src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'paymentPlatformType' field is set and is not null */
  public boolean isNotNullPaymentPlatformType() {
    return genClient.cacheValueIsNotNull(CacheKey.paymentPlatformType);
  }

  /** Checks whether the 'first6' field is set and is not null */
  public boolean isNotNullFirst6() {
    return genClient.cacheValueIsNotNull(CacheKey.first6);
  }

  /** Checks whether the 'last4' field is set and is not null */
  public boolean isNotNullLast4() {
    return genClient.cacheValueIsNotNull(CacheKey.last4);
  }

  /** Checks whether the 'cardType' field is set and is not null */
  public boolean isNotNullCardType() {
    return genClient.cacheValueIsNotNull(CacheKey.cardType);
  }

  /** Checks whether the 'amount' field is set and is not null */
  public boolean isNotNullAmount() {
    return genClient.cacheValueIsNotNull(CacheKey.amount);
  }

  /** Checks whether the 'entryType' field is set and is not null */
  public boolean isNotNullEntryType() {
    return genClient.cacheValueIsNotNull(CacheKey.entryType);
  }



  /** Checks whether the 'paymentPlatformType' field has been set, however the value could be null */
  public boolean hasPaymentPlatformType() {
    return genClient.cacheHasKey(CacheKey.paymentPlatformType);
  }

  /** Checks whether the 'first6' field has been set, however the value could be null */
  public boolean hasFirst6() {
    return genClient.cacheHasKey(CacheKey.first6);
  }

  /** Checks whether the 'last4' field has been set, however the value could be null */
  public boolean hasLast4() {
    return genClient.cacheHasKey(CacheKey.last4);
  }

  /** Checks whether the 'cardType' field has been set, however the value could be null */
  public boolean hasCardType() {
    return genClient.cacheHasKey(CacheKey.cardType);
  }

  /** Checks whether the 'amount' field has been set, however the value could be null */
  public boolean hasAmount() {
    return genClient.cacheHasKey(CacheKey.amount);
  }

  /** Checks whether the 'entryType' field has been set, however the value could be null */
  public boolean hasEntryType() {
    return genClient.cacheHasKey(CacheKey.entryType);
  }


  /**
   * Sets the field 'paymentPlatformType'.
   */
  public DynamicBinHandlerRequest setPaymentPlatformType(PaymentPlatformType paymentPlatformType) {
    return genClient.setOther(paymentPlatformType, CacheKey.paymentPlatformType);
  }

  /**
   * Sets the field 'first6'.
   */
  public DynamicBinHandlerRequest setFirst6(String first6) {
    return genClient.setOther(first6, CacheKey.first6);
  }

  /**
   * Sets the field 'last4'.
   */
  public DynamicBinHandlerRequest setLast4(String last4) {
    return genClient.setOther(last4, CacheKey.last4);
  }

  /**
   * Sets the field 'cardType'.
   */
  public DynamicBinHandlerRequest setCardType(com.clover.sdk.v3.payments.CardType cardType) {
    return genClient.setOther(cardType, CacheKey.cardType);
  }

  /**
   * Sets the field 'amount'.
   */
  public DynamicBinHandlerRequest setAmount(Long amount) {
    return genClient.setOther(amount, CacheKey.amount);
  }

  /**
   * Sets the field 'entryType'.
   */
  public DynamicBinHandlerRequest setEntryType(com.clover.sdk.v3.payments.CardEntryType entryType) {
    return genClient.setOther(entryType, CacheKey.entryType);
  }


  /** Clears the 'paymentPlatformType' field, the 'has' method for this field will now return false */
  public void clearPaymentPlatformType() {
    genClient.clear(CacheKey.paymentPlatformType);
  }
  /** Clears the 'first6' field, the 'has' method for this field will now return false */
  public void clearFirst6() {
    genClient.clear(CacheKey.first6);
  }
  /** Clears the 'last4' field, the 'has' method for this field will now return false */
  public void clearLast4() {
    genClient.clear(CacheKey.last4);
  }
  /** Clears the 'cardType' field, the 'has' method for this field will now return false */
  public void clearCardType() {
    genClient.clear(CacheKey.cardType);
  }
  /** Clears the 'amount' field, the 'has' method for this field will now return false */
  public void clearAmount() {
    genClient.clear(CacheKey.amount);
  }
  /** Clears the 'entryType' field, the 'has' method for this field will now return false */
  public void clearEntryType() {
    genClient.clear(CacheKey.entryType);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DynamicBinHandlerRequest copyChanges() {
    DynamicBinHandlerRequest copy = new DynamicBinHandlerRequest();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DynamicBinHandlerRequest src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DynamicBinHandlerRequest(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DynamicBinHandlerRequest> CREATOR = new android.os.Parcelable.Creator<DynamicBinHandlerRequest>() {
    @Override
    public DynamicBinHandlerRequest createFromParcel(android.os.Parcel in) {
      DynamicBinHandlerRequest instance = new DynamicBinHandlerRequest(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DynamicBinHandlerRequest[] newArray(int size) {
      return new DynamicBinHandlerRequest[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DynamicBinHandlerRequest> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DynamicBinHandlerRequest>() {
    public Class<DynamicBinHandlerRequest> getCreatedClass() {
      return DynamicBinHandlerRequest.class;
    }

    @Override
    public DynamicBinHandlerRequest create(org.json.JSONObject jsonObject) {
      return new DynamicBinHandlerRequest(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean PAYMENTPLATFORMTYPE_IS_REQUIRED = false;
    public static final boolean FIRST6_IS_REQUIRED = false;
    public static final boolean LAST4_IS_REQUIRED = false;
    public static final boolean CARDTYPE_IS_REQUIRED = false;
    public static final boolean AMOUNT_IS_REQUIRED = false;
    public static final boolean ENTRYTYPE_IS_REQUIRED = false;
  }

}
