/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.binhandler;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getResponseType responseType}</li>
 * <li>{@link #getAction action}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DynamicBinResponse extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * ACCEPTED : returned by the implementor if they either don't care about the bin, or if they are using it for a purpose that doesn't require the payment flow be changed, ACTIVITY_LAUNCH:returned by the implementor if they want CPA to start an activity for result, passing the dynamic bin handler request (again)
   */
  public ResponseType getResponseType() {
    return genClient.cacheGet(CacheKey.responseType);
  }

  /**
   * activity action to invoke, only populated for ResponseType ACTIVITY_LAUNCH
   */
  public String getAction() {
    return genClient.cacheGet(CacheKey.action);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    responseType
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(ResponseType.class)),
    action
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(String.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DynamicBinResponse> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DynamicBinResponse() {
    genClient = new GenericClient<DynamicBinResponse>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DynamicBinResponse(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DynamicBinResponse(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DynamicBinResponse(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DynamicBinResponse(DynamicBinResponse src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'responseType' field is set and is not null */
  public boolean isNotNullResponseType() {
    return genClient.cacheValueIsNotNull(CacheKey.responseType);
  }

  /** Checks whether the 'action' field is set and is not null */
  public boolean isNotNullAction() {
    return genClient.cacheValueIsNotNull(CacheKey.action);
  }



  /** Checks whether the 'responseType' field has been set, however the value could be null */
  public boolean hasResponseType() {
    return genClient.cacheHasKey(CacheKey.responseType);
  }

  /** Checks whether the 'action' field has been set, however the value could be null */
  public boolean hasAction() {
    return genClient.cacheHasKey(CacheKey.action);
  }


  /**
   * Sets the field 'responseType'.
   */
  public DynamicBinResponse setResponseType(ResponseType responseType) {
    return genClient.setOther(responseType, CacheKey.responseType);
  }

  /**
   * Sets the field 'action'.
   */
  public DynamicBinResponse setAction(String action) {
    return genClient.setOther(action, CacheKey.action);
  }


  /** Clears the 'responseType' field, the 'has' method for this field will now return false */
  public void clearResponseType() {
    genClient.clear(CacheKey.responseType);
  }
  /** Clears the 'action' field, the 'has' method for this field will now return false */
  public void clearAction() {
    genClient.clear(CacheKey.action);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DynamicBinResponse copyChanges() {
    DynamicBinResponse copy = new DynamicBinResponse();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DynamicBinResponse src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DynamicBinResponse(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DynamicBinResponse> CREATOR = new android.os.Parcelable.Creator<DynamicBinResponse>() {
    @Override
    public DynamicBinResponse createFromParcel(android.os.Parcel in) {
      DynamicBinResponse instance = new DynamicBinResponse(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DynamicBinResponse[] newArray(int size) {
      return new DynamicBinResponse[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DynamicBinResponse> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DynamicBinResponse>() {
    public Class<DynamicBinResponse> getCreatedClass() {
      return DynamicBinResponse.class;
    }

    @Override
    public DynamicBinResponse create(org.json.JSONObject jsonObject) {
      return new DynamicBinResponse(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean RESPONSETYPE_IS_REQUIRED = false;
    public static final boolean ACTION_IS_REQUIRED = false;
  }

}
