/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.cacheindex;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getCacheName cache_name}</li>
 * <li>{@link #getIndex index}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class CacheIndex extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Name of a Memcached cache.
   */
  public java.lang.String getCacheName() {
    return genClient.cacheGet(CacheKey.cache_name);
  }

  /**
   * Index that is incremented when a cache is invalidated and forms part of the key used for entries stored in the cache.
   */
  public java.lang.Integer getIndex() {
    return genClient.cacheGet(CacheKey.index);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    cache_name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    index
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<CacheIndex> genClient;

  /**
   * Constructs a new empty instance.
   */
  public CacheIndex() {
    genClient = new GenericClient<CacheIndex>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected CacheIndex(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public CacheIndex(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public CacheIndex(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public CacheIndex(CacheIndex src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
  }

  /** Checks whether the 'cache_name' field is set and is not null */
  public boolean isNotNullCacheName() {
    return genClient.cacheValueIsNotNull(CacheKey.cache_name);
  }

  /** Checks whether the 'index' field is set and is not null */
  public boolean isNotNullIndex() {
    return genClient.cacheValueIsNotNull(CacheKey.index);
  }



  /** Checks whether the 'cache_name' field has been set, however the value could be null */
  public boolean hasCacheName() {
    return genClient.cacheHasKey(CacheKey.cache_name);
  }

  /** Checks whether the 'index' field has been set, however the value could be null */
  public boolean hasIndex() {
    return genClient.cacheHasKey(CacheKey.index);
  }


  /**
   * Sets the field 'cache_name'.
   */
  public CacheIndex setCacheName(java.lang.String cache_name) {
    return genClient.setOther(cache_name, CacheKey.cache_name);
  }

  /**
   * Sets the field 'index'.
   */
  public CacheIndex setIndex(java.lang.Integer index) {
    return genClient.setOther(index, CacheKey.index);
  }


  /** Clears the 'cache_name' field, the 'has' method for this field will now return false */
  public void clearCacheName() {
    genClient.clear(CacheKey.cache_name);
  }
  /** Clears the 'index' field, the 'has' method for this field will now return false */
  public void clearIndex() {
    genClient.clear(CacheKey.index);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public CacheIndex copyChanges() {
    CacheIndex copy = new CacheIndex();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(CacheIndex src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new CacheIndex(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<CacheIndex> CREATOR = new android.os.Parcelable.Creator<CacheIndex>() {
    @Override
    public CacheIndex createFromParcel(android.os.Parcel in) {
      CacheIndex instance = new CacheIndex(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public CacheIndex[] newArray(int size) {
      return new CacheIndex[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<CacheIndex> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<CacheIndex>() {
    public Class<CacheIndex> getCreatedClass() {
      return CacheIndex.class;
    }

    @Override
    public CacheIndex create(org.json.JSONObject jsonObject) {
      return new CacheIndex(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean CACHE_NAME_IS_REQUIRED = false;
    public static final boolean INDEX_IS_REQUIRED = false;
  }

}
