/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.customers;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getMerchant merchant}</li>
 * <li>{@link #getFirstName firstName}</li>
 * <li>{@link #getLastName lastName}</li>
 * <li>{@link #getMarketingAllowed marketingAllowed}</li>
 * <li>{@link #getCustomerSince customerSince}</li>
 * <li>{@link #getOrders orders}</li>
 * <li>{@link #getAddresses addresses}</li>
 * <li>{@link #getEmailAddresses emailAddresses}</li>
 * <li>{@link #getPhoneNumbers phoneNumbers}</li>
 * <li>{@link #getCards cards}</li>
 * <li>{@link #getMetadata metadata}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Customer extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * The merchant that is associated with this customer
   */
  public com.clover.sdk.v3.base.Reference getMerchant() {
    return genClient.cacheGet(CacheKey.merchant);
  }

  /**
   * First/given name of the customer
   */
  public java.lang.String getFirstName() {
    return genClient.cacheGet(CacheKey.firstName);
  }

  /**
   * Last name/surname of the customer
   */
  public java.lang.String getLastName() {
    return genClient.cacheGet(CacheKey.lastName);
  }

  public java.lang.Boolean getMarketingAllowed() {
    return genClient.cacheGet(CacheKey.marketingAllowed);
  }

  public java.lang.Long getCustomerSince() {
    return genClient.cacheGet(CacheKey.customerSince);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getOrders() {
    return genClient.cacheGet(CacheKey.orders);
  }

  public java.util.List<com.clover.sdk.v3.customers.Address> getAddresses() {
    return genClient.cacheGet(CacheKey.addresses);
  }

  public java.util.List<com.clover.sdk.v3.customers.EmailAddress> getEmailAddresses() {
    return genClient.cacheGet(CacheKey.emailAddresses);
  }

  public java.util.List<com.clover.sdk.v3.customers.PhoneNumber> getPhoneNumbers() {
    return genClient.cacheGet(CacheKey.phoneNumbers);
  }

  public java.util.List<com.clover.sdk.v3.customers.Card> getCards() {
    return genClient.cacheGet(CacheKey.cards);
  }

  /**
   * Additional information about the customer.
   */
  public com.clover.sdk.v3.customers.CustomerMetadata getMetadata() {
    return genClient.cacheGet(CacheKey.metadata);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    merchant
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    firstName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    lastName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    marketingAllowed
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    customerSince
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    orders
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    addresses
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.customers.Address.JSON_CREATOR)),
    emailAddresses
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.customers.EmailAddress.JSON_CREATOR)),
    phoneNumbers
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.customers.PhoneNumber.JSON_CREATOR)),
    cards
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.customers.Card.JSON_CREATOR)),
    metadata
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.customers.CustomerMetadata.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Customer> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Customer() {
    genClient = new GenericClient<Customer>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Customer(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Customer(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Customer(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Customer(Customer src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.firstName, getFirstName(), 64);

    genClient.validateLength(CacheKey.lastName, getLastName(), 64);
    genClient.validateReferences(CacheKey.merchant);
    genClient.validateReferences(CacheKey.orders);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'merchant' field is set and is not null */
  public boolean isNotNullMerchant() {
    return genClient.cacheValueIsNotNull(CacheKey.merchant);
  }

  /** Checks whether the 'firstName' field is set and is not null */
  public boolean isNotNullFirstName() {
    return genClient.cacheValueIsNotNull(CacheKey.firstName);
  }

  /** Checks whether the 'lastName' field is set and is not null */
  public boolean isNotNullLastName() {
    return genClient.cacheValueIsNotNull(CacheKey.lastName);
  }

  /** Checks whether the 'marketingAllowed' field is set and is not null */
  public boolean isNotNullMarketingAllowed() {
    return genClient.cacheValueIsNotNull(CacheKey.marketingAllowed);
  }

  /** Checks whether the 'customerSince' field is set and is not null */
  public boolean isNotNullCustomerSince() {
    return genClient.cacheValueIsNotNull(CacheKey.customerSince);
  }

  /** Checks whether the 'orders' field is set and is not null */
  public boolean isNotNullOrders() {
    return genClient.cacheValueIsNotNull(CacheKey.orders);
  }

  /** Checks whether the 'orders' field is set and is not null and is not empty */
  public boolean isNotEmptyOrders() { return isNotNullOrders() && !getOrders().isEmpty(); }

  /** Checks whether the 'addresses' field is set and is not null */
  public boolean isNotNullAddresses() {
    return genClient.cacheValueIsNotNull(CacheKey.addresses);
  }

  /** Checks whether the 'addresses' field is set and is not null and is not empty */
  public boolean isNotEmptyAddresses() { return isNotNullAddresses() && !getAddresses().isEmpty(); }

  /** Checks whether the 'emailAddresses' field is set and is not null */
  public boolean isNotNullEmailAddresses() {
    return genClient.cacheValueIsNotNull(CacheKey.emailAddresses);
  }

  /** Checks whether the 'emailAddresses' field is set and is not null and is not empty */
  public boolean isNotEmptyEmailAddresses() { return isNotNullEmailAddresses() && !getEmailAddresses().isEmpty(); }

  /** Checks whether the 'phoneNumbers' field is set and is not null */
  public boolean isNotNullPhoneNumbers() {
    return genClient.cacheValueIsNotNull(CacheKey.phoneNumbers);
  }

  /** Checks whether the 'phoneNumbers' field is set and is not null and is not empty */
  public boolean isNotEmptyPhoneNumbers() { return isNotNullPhoneNumbers() && !getPhoneNumbers().isEmpty(); }

  /** Checks whether the 'cards' field is set and is not null */
  public boolean isNotNullCards() {
    return genClient.cacheValueIsNotNull(CacheKey.cards);
  }

  /** Checks whether the 'cards' field is set and is not null and is not empty */
  public boolean isNotEmptyCards() { return isNotNullCards() && !getCards().isEmpty(); }

  /** Checks whether the 'metadata' field is set and is not null */
  public boolean isNotNullMetadata() {
    return genClient.cacheValueIsNotNull(CacheKey.metadata);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'merchant' field has been set, however the value could be null */
  public boolean hasMerchant() {
    return genClient.cacheHasKey(CacheKey.merchant);
  }

  /** Checks whether the 'firstName' field has been set, however the value could be null */
  public boolean hasFirstName() {
    return genClient.cacheHasKey(CacheKey.firstName);
  }

  /** Checks whether the 'lastName' field has been set, however the value could be null */
  public boolean hasLastName() {
    return genClient.cacheHasKey(CacheKey.lastName);
  }

  /** Checks whether the 'marketingAllowed' field has been set, however the value could be null */
  public boolean hasMarketingAllowed() {
    return genClient.cacheHasKey(CacheKey.marketingAllowed);
  }

  /** Checks whether the 'customerSince' field has been set, however the value could be null */
  public boolean hasCustomerSince() {
    return genClient.cacheHasKey(CacheKey.customerSince);
  }

  /** Checks whether the 'orders' field has been set, however the value could be null */
  public boolean hasOrders() {
    return genClient.cacheHasKey(CacheKey.orders);
  }

  /** Checks whether the 'addresses' field has been set, however the value could be null */
  public boolean hasAddresses() {
    return genClient.cacheHasKey(CacheKey.addresses);
  }

  /** Checks whether the 'emailAddresses' field has been set, however the value could be null */
  public boolean hasEmailAddresses() {
    return genClient.cacheHasKey(CacheKey.emailAddresses);
  }

  /** Checks whether the 'phoneNumbers' field has been set, however the value could be null */
  public boolean hasPhoneNumbers() {
    return genClient.cacheHasKey(CacheKey.phoneNumbers);
  }

  /** Checks whether the 'cards' field has been set, however the value could be null */
  public boolean hasCards() {
    return genClient.cacheHasKey(CacheKey.cards);
  }

  /** Checks whether the 'metadata' field has been set, however the value could be null */
  public boolean hasMetadata() {
    return genClient.cacheHasKey(CacheKey.metadata);
  }


  /**
   * Sets the field 'id'.
   */
  public Customer setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'merchant'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Customer setMerchant(com.clover.sdk.v3.base.Reference merchant) {
    return genClient.setRecord(merchant, CacheKey.merchant);
  }

  /**
   * Sets the field 'firstName'.
   */
  public Customer setFirstName(java.lang.String firstName) {
    return genClient.setOther(firstName, CacheKey.firstName);
  }

  /**
   * Sets the field 'lastName'.
   */
  public Customer setLastName(java.lang.String lastName) {
    return genClient.setOther(lastName, CacheKey.lastName);
  }

  /**
   * Sets the field 'marketingAllowed'.
   */
  public Customer setMarketingAllowed(java.lang.Boolean marketingAllowed) {
    return genClient.setOther(marketingAllowed, CacheKey.marketingAllowed);
  }

  /**
   * Sets the field 'customerSince'.
   */
  public Customer setCustomerSince(java.lang.Long customerSince) {
    return genClient.setOther(customerSince, CacheKey.customerSince);
  }

  /**
   * Sets the field 'orders'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setOrders(java.util.List<com.clover.sdk.v3.base.Reference> orders) {
    return genClient.setArrayRecord(orders, CacheKey.orders);
  }

  /**
   * Sets the field 'addresses'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setAddresses(java.util.List<com.clover.sdk.v3.customers.Address> addresses) {
    return genClient.setArrayRecord(addresses, CacheKey.addresses);
  }

  /**
   * Sets the field 'emailAddresses'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setEmailAddresses(java.util.List<com.clover.sdk.v3.customers.EmailAddress> emailAddresses) {
    return genClient.setArrayRecord(emailAddresses, CacheKey.emailAddresses);
  }

  /**
   * Sets the field 'phoneNumbers'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setPhoneNumbers(java.util.List<com.clover.sdk.v3.customers.PhoneNumber> phoneNumbers) {
    return genClient.setArrayRecord(phoneNumbers, CacheKey.phoneNumbers);
  }

  /**
   * Sets the field 'cards'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public Customer setCards(java.util.List<com.clover.sdk.v3.customers.Card> cards) {
    return genClient.setArrayRecord(cards, CacheKey.cards);
  }

  /**
   * Sets the field 'metadata'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Customer setMetadata(com.clover.sdk.v3.customers.CustomerMetadata metadata) {
    return genClient.setRecord(metadata, CacheKey.metadata);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'merchant' field, the 'has' method for this field will now return false */
  public void clearMerchant() {
    genClient.clear(CacheKey.merchant);
  }
  /** Clears the 'firstName' field, the 'has' method for this field will now return false */
  public void clearFirstName() {
    genClient.clear(CacheKey.firstName);
  }
  /** Clears the 'lastName' field, the 'has' method for this field will now return false */
  public void clearLastName() {
    genClient.clear(CacheKey.lastName);
  }
  /** Clears the 'marketingAllowed' field, the 'has' method for this field will now return false */
  public void clearMarketingAllowed() {
    genClient.clear(CacheKey.marketingAllowed);
  }
  /** Clears the 'customerSince' field, the 'has' method for this field will now return false */
  public void clearCustomerSince() {
    genClient.clear(CacheKey.customerSince);
  }
  /** Clears the 'orders' field, the 'has' method for this field will now return false */
  public void clearOrders() {
    genClient.clear(CacheKey.orders);
  }
  /** Clears the 'addresses' field, the 'has' method for this field will now return false */
  public void clearAddresses() {
    genClient.clear(CacheKey.addresses);
  }
  /** Clears the 'emailAddresses' field, the 'has' method for this field will now return false */
  public void clearEmailAddresses() {
    genClient.clear(CacheKey.emailAddresses);
  }
  /** Clears the 'phoneNumbers' field, the 'has' method for this field will now return false */
  public void clearPhoneNumbers() {
    genClient.clear(CacheKey.phoneNumbers);
  }
  /** Clears the 'cards' field, the 'has' method for this field will now return false */
  public void clearCards() {
    genClient.clear(CacheKey.cards);
  }
  /** Clears the 'metadata' field, the 'has' method for this field will now return false */
  public void clearMetadata() {
    genClient.clear(CacheKey.metadata);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Customer copyChanges() {
    Customer copy = new Customer();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Customer src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Customer(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Customer> CREATOR = new android.os.Parcelable.Creator<Customer>() {
    @Override
    public Customer createFromParcel(android.os.Parcel in) {
      Customer instance = new Customer(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Customer[] newArray(int size) {
      return new Customer[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Customer> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Customer>() {
    public Class<Customer> getCreatedClass() {
      return Customer.class;
    }

    @Override
    public Customer create(org.json.JSONObject jsonObject) {
      return new Customer(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean MERCHANT_IS_REQUIRED = false;
    public static final boolean FIRSTNAME_IS_REQUIRED = false;
    public static final long FIRSTNAME_MAX_LEN = 64;
    public static final boolean LASTNAME_IS_REQUIRED = false;
    public static final long LASTNAME_MAX_LEN = 64;
    public static final boolean MARKETINGALLOWED_IS_REQUIRED = false;
    public static final boolean CUSTOMERSINCE_IS_REQUIRED = false;
    public static final boolean ORDERS_IS_REQUIRED = false;
    public static final boolean ADDRESSES_IS_REQUIRED = false;
    public static final boolean EMAILADDRESSES_IS_REQUIRED = false;
    public static final boolean PHONENUMBERS_IS_REQUIRED = false;
    public static final boolean CARDS_IS_REQUIRED = false;
    public static final boolean METADATA_IS_REQUIRED = false;
  }

}
