/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.developer;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getFirstName firstName}</li>
 * <li>{@link #getLastName lastName}</li>
 * <li>{@link #getEmail email}</li>
 * <li>{@link #getPhone phone}</li>
 * <li>{@link #getDob dob}</li>
 * <li>{@link #getSsn ssn}</li>
 * <li>{@link #getAddress address}</li>
 * <li>{@link #getCity city}</li>
 * <li>{@link #getCounty county}</li>
 * <li>{@link #getState state}</li>
 * <li>{@link #getCountry country}</li>
 * <li>{@link #getPostalCode postalCode}</li>
 * <li>{@link #getBankAccountNumber bankAccountNumber}</li>
 * <li>{@link #getBankInfo bankInfo}</li>
 * <li>{@link #getBankRoutingNumber bankRoutingNumber}</li>
 * <li>{@link #getBusinessLegalName businessLegalName}</li>
 * <li>{@link #getVatRegisterNumber vatRegisterNumber}</li>
 * <li>{@link #getBusinessAddress businessAddress}</li>
 * <li>{@link #getBusinessCity businessCity}</li>
 * <li>{@link #getBusinessState businessState}</li>
 * <li>{@link #getBusinessCountry businessCountry}</li>
 * <li>{@link #getBusinessPostalCode businessPostalCode}</li>
 * <li>{@link #getBillingStatus billingStatus}</li>
 * <li>{@link #getBillingStatusMessage billingStatusMessage}</li>
 * <li>{@link #getApprovalStatus approvalStatus}</li>
 * <li>{@link #getAcceptedAgreement acceptedAgreement}</li>
 * <li>{@link #getPrName prName}</li>
 * <li>{@link #getPrEmail prEmail}</li>
 * <li>{@link #getPrPhone prPhone}</li>
 * <li>{@link #getWebsite website}</li>
 * <li>{@link #getCreatedTime createdTime}</li>
 * <li>{@link #getFirstSubmittedTime firstSubmittedTime}</li>
 * <li>{@link #getFirstApprovalTime firstApprovalTime}</li>
 * <li>{@link #getModifiedTime modifiedTime}</li>
 * <li>{@link #getOwner owner}</li>
 * <li>{@link #getAppBillingSystem appBillingSystem}</li>
 * <li>{@link #getInfoleaseVendorCode infoleaseVendorCode}</li>
 * <li>{@link #getInfoleaseGlCode infoleaseGlCode}</li>
 * <li>{@link #getRevShare revShare}</li>
 * <li>{@link #getIsRevShareFlatRate isRevShareFlatRate}</li>
 * <li>{@link #getRevShareEffectiveTime revShareEffectiveTime}</li>
 * <li>{@link #getSignorName signorName}</li>
 * <li>{@link #getSignorTitle signorTitle}</li>
 * <li>{@link #getReferralSubmissionTime referralSubmissionTime}</li>
 * <li>{@link #getEmergencyEmail emergencyEmail}</li>
 * <li>{@link #getCollectionApprovalStatus collectionApprovalStatus}</li>
 * <li>{@link #getIsIsv isIsv}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class Developer extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  /**
   * Unique identifier
   */
  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  /**
   * Developer's name.  Could be a company name.  Whatever is to be shown as who made the app in App Marketplace, e.g. NoshList, Pioneer Works Inc., Seven Spaces, etc.  Also used as (optional) Business DBA (Doing Business Name) name when sending to Braintree for app billing background check.
   */
  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  /**
   * Developer's individual first name.
   */
  public java.lang.String getFirstName() {
    return genClient.cacheGet(CacheKey.firstName);
  }

  /**
   * Developer's individual last name.
   */
  public java.lang.String getLastName() {
    return genClient.cacheGet(CacheKey.lastName);
  }

  /**
   * Developer's email.
   */
  public java.lang.String getEmail() {
    return genClient.cacheGet(CacheKey.email);
  }

  /**
   * Developer's phone.
   */
  public java.lang.String getPhone() {
    return genClient.cacheGet(CacheKey.phone);
  }

  /**
   * Developer's date of birth.
   */
  public java.lang.String getDob() {
    return genClient.cacheGet(CacheKey.dob);
  }

  /**
   * Developer's SSN; won't be stored in the clear in the DB; will be stored encrypted in sensitiveInfo.
   */
  public java.lang.String getSsn() {
    return genClient.cacheGet(CacheKey.ssn);
  }

  /**
   * Developer's address.
   */
  public java.lang.String getAddress() {
    return genClient.cacheGet(CacheKey.address);
  }

  /**
   * Developer's city.
   */
  public java.lang.String getCity() {
    return genClient.cacheGet(CacheKey.city);
  }

  /**
   * Developer's county.
   */
  public java.lang.String getCounty() {
    return genClient.cacheGet(CacheKey.county);
  }

  /**
   * Developer's state.
   */
  public java.lang.String getState() {
    return genClient.cacheGet(CacheKey.state);
  }

  /**
   * Developer's country.
   */
  public java.lang.String getCountry() {
    return genClient.cacheGet(CacheKey.country);
  }

  /**
   * Developer's postal code.
   */
  public java.lang.String getPostalCode() {
    return genClient.cacheGet(CacheKey.postalCode);
  }

  /**
   * Developer's bank account number; won't be stored in the clear in the DB; will be stored encrypted in sensitiveInfo.
   */
  public java.lang.String getBankAccountNumber() {
    return genClient.cacheGet(CacheKey.bankAccountNumber);
  }

  /**
   * Developer's bank info that allows persisting last four and billing modified times.
   */
  public com.clover.sdk.v3.base.Reference getBankInfo() {
    return genClient.cacheGet(CacheKey.bankInfo);
  }

  /**
   * Developer's bank routing number.
   */
  public java.lang.String getBankRoutingNumber() {
    return genClient.cacheGet(CacheKey.bankRoutingNumber);
  }

  /**
   * Developer's business legal name.
   */
  public java.lang.String getBusinessLegalName() {
    return genClient.cacheGet(CacheKey.businessLegalName);
  }

  /**
   * Developer's VAT Register Number.
   */
  public java.lang.String getVatRegisterNumber() {
    return genClient.cacheGet(CacheKey.vatRegisterNumber);
  }

  /**
   * Developer's business address.
   */
  public java.lang.String getBusinessAddress() {
    return genClient.cacheGet(CacheKey.businessAddress);
  }

  /**
   * Developer's business city.
   */
  public java.lang.String getBusinessCity() {
    return genClient.cacheGet(CacheKey.businessCity);
  }

  /**
   * Developer's business state.
   */
  public java.lang.String getBusinessState() {
    return genClient.cacheGet(CacheKey.businessState);
  }

  /**
   * Developer's business country.
   */
  public java.lang.String getBusinessCountry() {
    return genClient.cacheGet(CacheKey.businessCountry);
  }

  /**
   * Developer's business postal code.
   */
  public java.lang.String getBusinessPostalCode() {
    return genClient.cacheGet(CacheKey.businessPostalCode);
  }

  /**
   * Developer's billing status.
   */
  public com.clover.sdk.v3.developer.DeveloperBillingStatus getBillingStatus() {
    return genClient.cacheGet(CacheKey.billingStatus);
  }

  /**
   * Developer's billing status message.
   */
  public java.lang.String getBillingStatusMessage() {
    return genClient.cacheGet(CacheKey.billingStatusMessage);
  }

  public com.clover.sdk.v3.base.ApprovalStatus getApprovalStatus() {
    return genClient.cacheGet(CacheKey.approvalStatus);
  }

  /**
   * If the user has accepted the developer agreement.
   */
  public java.lang.Boolean getAcceptedAgreement() {
    return genClient.cacheGet(CacheKey.acceptedAgreement);
  }

  /**
   * Name of public relations contact.
   */
  public java.lang.String getPrName() {
    return genClient.cacheGet(CacheKey.prName);
  }

  /**
   * Email of public relations contact.
   */
  public java.lang.String getPrEmail() {
    return genClient.cacheGet(CacheKey.prEmail);
  }

  /**
   * Phone of public relations contact.
   */
  public java.lang.String getPrPhone() {
    return genClient.cacheGet(CacheKey.prPhone);
  }

  /**
   * Developer's business website.
   */
  public java.lang.String getWebsite() {
    return genClient.cacheGet(CacheKey.website);
  }

  /**
   * Timestamp indicating the time the developer was created.
   */
  public java.lang.Long getCreatedTime() {
    return genClient.cacheGet(CacheKey.createdTime);
  }

  /**
   * Timestamp indicating the time the developer information was first submitted.
   */
  public java.lang.Long getFirstSubmittedTime() {
    return genClient.cacheGet(CacheKey.firstSubmittedTime);
  }

  /**
   * Timestamp indicating the time the developer was first approved.
   */
  public java.lang.Long getFirstApprovalTime() {
    return genClient.cacheGet(CacheKey.firstApprovalTime);
  }

  /**
   * Timestamp indicating the last time the developer was modified.
   */
  public java.lang.Long getModifiedTime() {
    return genClient.cacheGet(CacheKey.modifiedTime);
  }

  /**
   * The user account that owns this developer account.
   */
  public com.clover.sdk.v3.base.Reference getOwner() {
    return genClient.cacheGet(CacheKey.owner);
  }

  /**
   * Temporary while we are switching US billing systems.
   */
  public java.lang.String getAppBillingSystem() {
    return genClient.cacheGet(CacheKey.appBillingSystem);
  }

  /**
   * The Infolease vendor code.  This is generated when the developer is on-boarded in the Infolease system.
   */
  public java.lang.String getInfoleaseVendorCode() {
    return genClient.cacheGet(CacheKey.infoleaseVendorCode);
  }

  /**
   * The Infolease GL (General Ledger) code.  Only for specific apps.  Will usually be null.
   */
  public java.lang.String getInfoleaseGlCode() {
    return genClient.cacheGet(CacheKey.infoleaseGlCode);
  }

  /**
   * Revenue share due the developer.
   */
  public java.lang.Integer getRevShare() {
    return genClient.cacheGet(CacheKey.revShare);
  }

  /**
   * Revenue share is a flat rate / amount not percentage.
   */
  public java.lang.Boolean getIsRevShareFlatRate() {
    return genClient.cacheGet(CacheKey.isRevShareFlatRate);
  }

  /**
   * Timestamp indicating when the revenue share is effective.
   */
  public java.lang.Long getRevShareEffectiveTime() {
    return genClient.cacheGet(CacheKey.revShareEffectiveTime);
  }

  /**
   * Signor name for developer referral program.
   */
  public java.lang.String getSignorName() {
    return genClient.cacheGet(CacheKey.signorName);
  }

  /**
   * Signor title for developer referral program.
   */
  public java.lang.String getSignorTitle() {
    return genClient.cacheGet(CacheKey.signorTitle);
  }

  /**
   * Timestamp indicating when the developer referral form was submitted.
   */
  public java.lang.Long getReferralSubmissionTime() {
    return genClient.cacheGet(CacheKey.referralSubmissionTime);
  }

  /**
   * Optional email field used by Clover support for high priority communications.
   */
  public java.lang.String getEmergencyEmail() {
    return genClient.cacheGet(CacheKey.emergencyEmail);
  }

  /**
   * Developer's status concerning the ability to create private app collections.
   */
  public com.clover.sdk.v3.developer.CollectionApprovalStatus getCollectionApprovalStatus() {
    return genClient.cacheGet(CacheKey.collectionApprovalStatus);
  }

  /**
   * This is true if the developer has a partner app.
   */
  public java.lang.Boolean getIsIsv() {
    return genClient.cacheGet(CacheKey.isIsv);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    firstName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    lastName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    email
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    phone
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    dob
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    ssn
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    address
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    city
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    county
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    state
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    country
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    postalCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    bankAccountNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    bankInfo
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    bankRoutingNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessLegalName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    vatRegisterNumber
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessAddress
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessCity
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessState
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessCountry
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    businessPostalCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    billingStatus
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.developer.DeveloperBillingStatus.class)),
    billingStatusMessage
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    approvalStatus
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.base.ApprovalStatus.class)),
    acceptedAgreement
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    prName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    prEmail
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    prPhone
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    website
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    createdTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    firstSubmittedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    firstApprovalTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    modifiedTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    owner
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    appBillingSystem
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    infoleaseVendorCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    infoleaseGlCode
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    revShare
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Integer.class)),
    isRevShareFlatRate
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    revShareEffectiveTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    signorName
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    signorTitle
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    referralSubmissionTime
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Long.class)),
    emergencyEmail
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    collectionApprovalStatus
        (com.clover.sdk.extractors.EnumExtractionStrategy.instance(com.clover.sdk.v3.developer.CollectionApprovalStatus.class)),
    isIsv
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<Developer> genClient;

  /**
   * Constructs a new empty instance.
   */
  public Developer() {
    genClient = new GenericClient<Developer>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected Developer(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public Developer(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public Developer(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public Developer(Developer src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.name, getName(), 127);

    genClient.validateLength(CacheKey.firstName, getFirstName(), 127);

    genClient.validateLength(CacheKey.lastName, getLastName(), 127);

    genClient.validateLength(CacheKey.email, getEmail(), 127);

    genClient.validateLength(CacheKey.phone, getPhone(), 25);

    genClient.validateLength(CacheKey.dob, getDob(), 10);

    genClient.validateLength(CacheKey.ssn, getSsn(), 9);

    genClient.validateLength(CacheKey.address, getAddress(), 255);

    genClient.validateLength(CacheKey.city, getCity(), 127);

    genClient.validateLength(CacheKey.county, getCounty(), 127);

    genClient.validateLength(CacheKey.state, getState(), 127);

    genClient.validateLength(CacheKey.country, getCountry(), 2);

    genClient.validateLength(CacheKey.postalCode, getPostalCode(), 20);

    genClient.validateLength(CacheKey.bankAccountNumber, getBankAccountNumber(), 34);

    genClient.validateLength(CacheKey.bankRoutingNumber, getBankRoutingNumber(), 40);

    genClient.validateLength(CacheKey.businessLegalName, getBusinessLegalName(), 255);

    genClient.validateLength(CacheKey.vatRegisterNumber, getVatRegisterNumber(), 127);

    genClient.validateLength(CacheKey.businessAddress, getBusinessAddress(), 255);

    genClient.validateLength(CacheKey.businessCity, getBusinessCity(), 127);

    genClient.validateLength(CacheKey.businessState, getBusinessState(), 127);

    genClient.validateLength(CacheKey.businessCountry, getBusinessCountry(), 2);

    genClient.validateLength(CacheKey.businessPostalCode, getBusinessPostalCode(), 20);

    genClient.validateLength(CacheKey.billingStatusMessage, getBillingStatusMessage(), 127);

    genClient.validateLength(CacheKey.prName, getPrName(), 255);

    genClient.validateLength(CacheKey.prEmail, getPrEmail(), 127);

    genClient.validateLength(CacheKey.prPhone, getPrPhone(), 25);

    genClient.validateLength(CacheKey.website, getWebsite(), 255);

    genClient.validateLength(CacheKey.appBillingSystem, getAppBillingSystem(), 10);

    genClient.validateLength(CacheKey.infoleaseVendorCode, getInfoleaseVendorCode(), 30);

    genClient.validateLength(CacheKey.infoleaseGlCode, getInfoleaseGlCode(), 10);

    genClient.validateLength(CacheKey.signorName, getSignorName(), 127);

    genClient.validateLength(CacheKey.signorTitle, getSignorTitle(), 127);

    genClient.validateLength(CacheKey.emergencyEmail, getEmergencyEmail(), 127);
    genClient.validateReferences(CacheKey.bankInfo);
    genClient.validateReferences(CacheKey.owner);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'firstName' field is set and is not null */
  public boolean isNotNullFirstName() {
    return genClient.cacheValueIsNotNull(CacheKey.firstName);
  }

  /** Checks whether the 'lastName' field is set and is not null */
  public boolean isNotNullLastName() {
    return genClient.cacheValueIsNotNull(CacheKey.lastName);
  }

  /** Checks whether the 'email' field is set and is not null */
  public boolean isNotNullEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.email);
  }

  /** Checks whether the 'phone' field is set and is not null */
  public boolean isNotNullPhone() {
    return genClient.cacheValueIsNotNull(CacheKey.phone);
  }

  /** Checks whether the 'dob' field is set and is not null */
  public boolean isNotNullDob() {
    return genClient.cacheValueIsNotNull(CacheKey.dob);
  }

  /** Checks whether the 'ssn' field is set and is not null */
  public boolean isNotNullSsn() {
    return genClient.cacheValueIsNotNull(CacheKey.ssn);
  }

  /** Checks whether the 'address' field is set and is not null */
  public boolean isNotNullAddress() {
    return genClient.cacheValueIsNotNull(CacheKey.address);
  }

  /** Checks whether the 'city' field is set and is not null */
  public boolean isNotNullCity() {
    return genClient.cacheValueIsNotNull(CacheKey.city);
  }

  /** Checks whether the 'county' field is set and is not null */
  public boolean isNotNullCounty() {
    return genClient.cacheValueIsNotNull(CacheKey.county);
  }

  /** Checks whether the 'state' field is set and is not null */
  public boolean isNotNullState() {
    return genClient.cacheValueIsNotNull(CacheKey.state);
  }

  /** Checks whether the 'country' field is set and is not null */
  public boolean isNotNullCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.country);
  }

  /** Checks whether the 'postalCode' field is set and is not null */
  public boolean isNotNullPostalCode() {
    return genClient.cacheValueIsNotNull(CacheKey.postalCode);
  }

  /** Checks whether the 'bankAccountNumber' field is set and is not null */
  public boolean isNotNullBankAccountNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.bankAccountNumber);
  }

  /** Checks whether the 'bankInfo' field is set and is not null */
  public boolean isNotNullBankInfo() {
    return genClient.cacheValueIsNotNull(CacheKey.bankInfo);
  }

  /** Checks whether the 'bankRoutingNumber' field is set and is not null */
  public boolean isNotNullBankRoutingNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.bankRoutingNumber);
  }

  /** Checks whether the 'businessLegalName' field is set and is not null */
  public boolean isNotNullBusinessLegalName() {
    return genClient.cacheValueIsNotNull(CacheKey.businessLegalName);
  }

  /** Checks whether the 'vatRegisterNumber' field is set and is not null */
  public boolean isNotNullVatRegisterNumber() {
    return genClient.cacheValueIsNotNull(CacheKey.vatRegisterNumber);
  }

  /** Checks whether the 'businessAddress' field is set and is not null */
  public boolean isNotNullBusinessAddress() {
    return genClient.cacheValueIsNotNull(CacheKey.businessAddress);
  }

  /** Checks whether the 'businessCity' field is set and is not null */
  public boolean isNotNullBusinessCity() {
    return genClient.cacheValueIsNotNull(CacheKey.businessCity);
  }

  /** Checks whether the 'businessState' field is set and is not null */
  public boolean isNotNullBusinessState() {
    return genClient.cacheValueIsNotNull(CacheKey.businessState);
  }

  /** Checks whether the 'businessCountry' field is set and is not null */
  public boolean isNotNullBusinessCountry() {
    return genClient.cacheValueIsNotNull(CacheKey.businessCountry);
  }

  /** Checks whether the 'businessPostalCode' field is set and is not null */
  public boolean isNotNullBusinessPostalCode() {
    return genClient.cacheValueIsNotNull(CacheKey.businessPostalCode);
  }

  /** Checks whether the 'billingStatus' field is set and is not null */
  public boolean isNotNullBillingStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.billingStatus);
  }

  /** Checks whether the 'billingStatusMessage' field is set and is not null */
  public boolean isNotNullBillingStatusMessage() {
    return genClient.cacheValueIsNotNull(CacheKey.billingStatusMessage);
  }

  /** Checks whether the 'approvalStatus' field is set and is not null */
  public boolean isNotNullApprovalStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.approvalStatus);
  }

  /** Checks whether the 'acceptedAgreement' field is set and is not null */
  public boolean isNotNullAcceptedAgreement() {
    return genClient.cacheValueIsNotNull(CacheKey.acceptedAgreement);
  }

  /** Checks whether the 'prName' field is set and is not null */
  public boolean isNotNullPrName() {
    return genClient.cacheValueIsNotNull(CacheKey.prName);
  }

  /** Checks whether the 'prEmail' field is set and is not null */
  public boolean isNotNullPrEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.prEmail);
  }

  /** Checks whether the 'prPhone' field is set and is not null */
  public boolean isNotNullPrPhone() {
    return genClient.cacheValueIsNotNull(CacheKey.prPhone);
  }

  /** Checks whether the 'website' field is set and is not null */
  public boolean isNotNullWebsite() {
    return genClient.cacheValueIsNotNull(CacheKey.website);
  }

  /** Checks whether the 'createdTime' field is set and is not null */
  public boolean isNotNullCreatedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.createdTime);
  }

  /** Checks whether the 'firstSubmittedTime' field is set and is not null */
  public boolean isNotNullFirstSubmittedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstSubmittedTime);
  }

  /** Checks whether the 'firstApprovalTime' field is set and is not null */
  public boolean isNotNullFirstApprovalTime() {
    return genClient.cacheValueIsNotNull(CacheKey.firstApprovalTime);
  }

  /** Checks whether the 'modifiedTime' field is set and is not null */
  public boolean isNotNullModifiedTime() {
    return genClient.cacheValueIsNotNull(CacheKey.modifiedTime);
  }

  /** Checks whether the 'owner' field is set and is not null */
  public boolean isNotNullOwner() {
    return genClient.cacheValueIsNotNull(CacheKey.owner);
  }

  /** Checks whether the 'appBillingSystem' field is set and is not null */
  public boolean isNotNullAppBillingSystem() {
    return genClient.cacheValueIsNotNull(CacheKey.appBillingSystem);
  }

  /** Checks whether the 'infoleaseVendorCode' field is set and is not null */
  public boolean isNotNullInfoleaseVendorCode() {
    return genClient.cacheValueIsNotNull(CacheKey.infoleaseVendorCode);
  }

  /** Checks whether the 'infoleaseGlCode' field is set and is not null */
  public boolean isNotNullInfoleaseGlCode() {
    return genClient.cacheValueIsNotNull(CacheKey.infoleaseGlCode);
  }

  /** Checks whether the 'revShare' field is set and is not null */
  public boolean isNotNullRevShare() {
    return genClient.cacheValueIsNotNull(CacheKey.revShare);
  }

  /** Checks whether the 'isRevShareFlatRate' field is set and is not null */
  public boolean isNotNullIsRevShareFlatRate() {
    return genClient.cacheValueIsNotNull(CacheKey.isRevShareFlatRate);
  }

  /** Checks whether the 'revShareEffectiveTime' field is set and is not null */
  public boolean isNotNullRevShareEffectiveTime() {
    return genClient.cacheValueIsNotNull(CacheKey.revShareEffectiveTime);
  }

  /** Checks whether the 'signorName' field is set and is not null */
  public boolean isNotNullSignorName() {
    return genClient.cacheValueIsNotNull(CacheKey.signorName);
  }

  /** Checks whether the 'signorTitle' field is set and is not null */
  public boolean isNotNullSignorTitle() {
    return genClient.cacheValueIsNotNull(CacheKey.signorTitle);
  }

  /** Checks whether the 'referralSubmissionTime' field is set and is not null */
  public boolean isNotNullReferralSubmissionTime() {
    return genClient.cacheValueIsNotNull(CacheKey.referralSubmissionTime);
  }

  /** Checks whether the 'emergencyEmail' field is set and is not null */
  public boolean isNotNullEmergencyEmail() {
    return genClient.cacheValueIsNotNull(CacheKey.emergencyEmail);
  }

  /** Checks whether the 'collectionApprovalStatus' field is set and is not null */
  public boolean isNotNullCollectionApprovalStatus() {
    return genClient.cacheValueIsNotNull(CacheKey.collectionApprovalStatus);
  }

  /** Checks whether the 'isIsv' field is set and is not null */
  public boolean isNotNullIsIsv() {
    return genClient.cacheValueIsNotNull(CacheKey.isIsv);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'firstName' field has been set, however the value could be null */
  public boolean hasFirstName() {
    return genClient.cacheHasKey(CacheKey.firstName);
  }

  /** Checks whether the 'lastName' field has been set, however the value could be null */
  public boolean hasLastName() {
    return genClient.cacheHasKey(CacheKey.lastName);
  }

  /** Checks whether the 'email' field has been set, however the value could be null */
  public boolean hasEmail() {
    return genClient.cacheHasKey(CacheKey.email);
  }

  /** Checks whether the 'phone' field has been set, however the value could be null */
  public boolean hasPhone() {
    return genClient.cacheHasKey(CacheKey.phone);
  }

  /** Checks whether the 'dob' field has been set, however the value could be null */
  public boolean hasDob() {
    return genClient.cacheHasKey(CacheKey.dob);
  }

  /** Checks whether the 'ssn' field has been set, however the value could be null */
  public boolean hasSsn() {
    return genClient.cacheHasKey(CacheKey.ssn);
  }

  /** Checks whether the 'address' field has been set, however the value could be null */
  public boolean hasAddress() {
    return genClient.cacheHasKey(CacheKey.address);
  }

  /** Checks whether the 'city' field has been set, however the value could be null */
  public boolean hasCity() {
    return genClient.cacheHasKey(CacheKey.city);
  }

  /** Checks whether the 'county' field has been set, however the value could be null */
  public boolean hasCounty() {
    return genClient.cacheHasKey(CacheKey.county);
  }

  /** Checks whether the 'state' field has been set, however the value could be null */
  public boolean hasState() {
    return genClient.cacheHasKey(CacheKey.state);
  }

  /** Checks whether the 'country' field has been set, however the value could be null */
  public boolean hasCountry() {
    return genClient.cacheHasKey(CacheKey.country);
  }

  /** Checks whether the 'postalCode' field has been set, however the value could be null */
  public boolean hasPostalCode() {
    return genClient.cacheHasKey(CacheKey.postalCode);
  }

  /** Checks whether the 'bankAccountNumber' field has been set, however the value could be null */
  public boolean hasBankAccountNumber() {
    return genClient.cacheHasKey(CacheKey.bankAccountNumber);
  }

  /** Checks whether the 'bankInfo' field has been set, however the value could be null */
  public boolean hasBankInfo() {
    return genClient.cacheHasKey(CacheKey.bankInfo);
  }

  /** Checks whether the 'bankRoutingNumber' field has been set, however the value could be null */
  public boolean hasBankRoutingNumber() {
    return genClient.cacheHasKey(CacheKey.bankRoutingNumber);
  }

  /** Checks whether the 'businessLegalName' field has been set, however the value could be null */
  public boolean hasBusinessLegalName() {
    return genClient.cacheHasKey(CacheKey.businessLegalName);
  }

  /** Checks whether the 'vatRegisterNumber' field has been set, however the value could be null */
  public boolean hasVatRegisterNumber() {
    return genClient.cacheHasKey(CacheKey.vatRegisterNumber);
  }

  /** Checks whether the 'businessAddress' field has been set, however the value could be null */
  public boolean hasBusinessAddress() {
    return genClient.cacheHasKey(CacheKey.businessAddress);
  }

  /** Checks whether the 'businessCity' field has been set, however the value could be null */
  public boolean hasBusinessCity() {
    return genClient.cacheHasKey(CacheKey.businessCity);
  }

  /** Checks whether the 'businessState' field has been set, however the value could be null */
  public boolean hasBusinessState() {
    return genClient.cacheHasKey(CacheKey.businessState);
  }

  /** Checks whether the 'businessCountry' field has been set, however the value could be null */
  public boolean hasBusinessCountry() {
    return genClient.cacheHasKey(CacheKey.businessCountry);
  }

  /** Checks whether the 'businessPostalCode' field has been set, however the value could be null */
  public boolean hasBusinessPostalCode() {
    return genClient.cacheHasKey(CacheKey.businessPostalCode);
  }

  /** Checks whether the 'billingStatus' field has been set, however the value could be null */
  public boolean hasBillingStatus() {
    return genClient.cacheHasKey(CacheKey.billingStatus);
  }

  /** Checks whether the 'billingStatusMessage' field has been set, however the value could be null */
  public boolean hasBillingStatusMessage() {
    return genClient.cacheHasKey(CacheKey.billingStatusMessage);
  }

  /** Checks whether the 'approvalStatus' field has been set, however the value could be null */
  public boolean hasApprovalStatus() {
    return genClient.cacheHasKey(CacheKey.approvalStatus);
  }

  /** Checks whether the 'acceptedAgreement' field has been set, however the value could be null */
  public boolean hasAcceptedAgreement() {
    return genClient.cacheHasKey(CacheKey.acceptedAgreement);
  }

  /** Checks whether the 'prName' field has been set, however the value could be null */
  public boolean hasPrName() {
    return genClient.cacheHasKey(CacheKey.prName);
  }

  /** Checks whether the 'prEmail' field has been set, however the value could be null */
  public boolean hasPrEmail() {
    return genClient.cacheHasKey(CacheKey.prEmail);
  }

  /** Checks whether the 'prPhone' field has been set, however the value could be null */
  public boolean hasPrPhone() {
    return genClient.cacheHasKey(CacheKey.prPhone);
  }

  /** Checks whether the 'website' field has been set, however the value could be null */
  public boolean hasWebsite() {
    return genClient.cacheHasKey(CacheKey.website);
  }

  /** Checks whether the 'createdTime' field has been set, however the value could be null */
  public boolean hasCreatedTime() {
    return genClient.cacheHasKey(CacheKey.createdTime);
  }

  /** Checks whether the 'firstSubmittedTime' field has been set, however the value could be null */
  public boolean hasFirstSubmittedTime() {
    return genClient.cacheHasKey(CacheKey.firstSubmittedTime);
  }

  /** Checks whether the 'firstApprovalTime' field has been set, however the value could be null */
  public boolean hasFirstApprovalTime() {
    return genClient.cacheHasKey(CacheKey.firstApprovalTime);
  }

  /** Checks whether the 'modifiedTime' field has been set, however the value could be null */
  public boolean hasModifiedTime() {
    return genClient.cacheHasKey(CacheKey.modifiedTime);
  }

  /** Checks whether the 'owner' field has been set, however the value could be null */
  public boolean hasOwner() {
    return genClient.cacheHasKey(CacheKey.owner);
  }

  /** Checks whether the 'appBillingSystem' field has been set, however the value could be null */
  public boolean hasAppBillingSystem() {
    return genClient.cacheHasKey(CacheKey.appBillingSystem);
  }

  /** Checks whether the 'infoleaseVendorCode' field has been set, however the value could be null */
  public boolean hasInfoleaseVendorCode() {
    return genClient.cacheHasKey(CacheKey.infoleaseVendorCode);
  }

  /** Checks whether the 'infoleaseGlCode' field has been set, however the value could be null */
  public boolean hasInfoleaseGlCode() {
    return genClient.cacheHasKey(CacheKey.infoleaseGlCode);
  }

  /** Checks whether the 'revShare' field has been set, however the value could be null */
  public boolean hasRevShare() {
    return genClient.cacheHasKey(CacheKey.revShare);
  }

  /** Checks whether the 'isRevShareFlatRate' field has been set, however the value could be null */
  public boolean hasIsRevShareFlatRate() {
    return genClient.cacheHasKey(CacheKey.isRevShareFlatRate);
  }

  /** Checks whether the 'revShareEffectiveTime' field has been set, however the value could be null */
  public boolean hasRevShareEffectiveTime() {
    return genClient.cacheHasKey(CacheKey.revShareEffectiveTime);
  }

  /** Checks whether the 'signorName' field has been set, however the value could be null */
  public boolean hasSignorName() {
    return genClient.cacheHasKey(CacheKey.signorName);
  }

  /** Checks whether the 'signorTitle' field has been set, however the value could be null */
  public boolean hasSignorTitle() {
    return genClient.cacheHasKey(CacheKey.signorTitle);
  }

  /** Checks whether the 'referralSubmissionTime' field has been set, however the value could be null */
  public boolean hasReferralSubmissionTime() {
    return genClient.cacheHasKey(CacheKey.referralSubmissionTime);
  }

  /** Checks whether the 'emergencyEmail' field has been set, however the value could be null */
  public boolean hasEmergencyEmail() {
    return genClient.cacheHasKey(CacheKey.emergencyEmail);
  }

  /** Checks whether the 'collectionApprovalStatus' field has been set, however the value could be null */
  public boolean hasCollectionApprovalStatus() {
    return genClient.cacheHasKey(CacheKey.collectionApprovalStatus);
  }

  /** Checks whether the 'isIsv' field has been set, however the value could be null */
  public boolean hasIsIsv() {
    return genClient.cacheHasKey(CacheKey.isIsv);
  }


  /**
   * Sets the field 'id'.
   */
  public Developer setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public Developer setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'firstName'.
   */
  public Developer setFirstName(java.lang.String firstName) {
    return genClient.setOther(firstName, CacheKey.firstName);
  }

  /**
   * Sets the field 'lastName'.
   */
  public Developer setLastName(java.lang.String lastName) {
    return genClient.setOther(lastName, CacheKey.lastName);
  }

  /**
   * Sets the field 'email'.
   */
  public Developer setEmail(java.lang.String email) {
    return genClient.setOther(email, CacheKey.email);
  }

  /**
   * Sets the field 'phone'.
   */
  public Developer setPhone(java.lang.String phone) {
    return genClient.setOther(phone, CacheKey.phone);
  }

  /**
   * Sets the field 'dob'.
   */
  public Developer setDob(java.lang.String dob) {
    return genClient.setOther(dob, CacheKey.dob);
  }

  /**
   * Sets the field 'ssn'.
   */
  public Developer setSsn(java.lang.String ssn) {
    return genClient.setOther(ssn, CacheKey.ssn);
  }

  /**
   * Sets the field 'address'.
   */
  public Developer setAddress(java.lang.String address) {
    return genClient.setOther(address, CacheKey.address);
  }

  /**
   * Sets the field 'city'.
   */
  public Developer setCity(java.lang.String city) {
    return genClient.setOther(city, CacheKey.city);
  }

  /**
   * Sets the field 'county'.
   */
  public Developer setCounty(java.lang.String county) {
    return genClient.setOther(county, CacheKey.county);
  }

  /**
   * Sets the field 'state'.
   */
  public Developer setState(java.lang.String state) {
    return genClient.setOther(state, CacheKey.state);
  }

  /**
   * Sets the field 'country'.
   */
  public Developer setCountry(java.lang.String country) {
    return genClient.setOther(country, CacheKey.country);
  }

  /**
   * Sets the field 'postalCode'.
   */
  public Developer setPostalCode(java.lang.String postalCode) {
    return genClient.setOther(postalCode, CacheKey.postalCode);
  }

  /**
   * Sets the field 'bankAccountNumber'.
   */
  public Developer setBankAccountNumber(java.lang.String bankAccountNumber) {
    return genClient.setOther(bankAccountNumber, CacheKey.bankAccountNumber);
  }

  /**
   * Sets the field 'bankInfo'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Developer setBankInfo(com.clover.sdk.v3.base.Reference bankInfo) {
    return genClient.setRecord(bankInfo, CacheKey.bankInfo);
  }

  /**
   * Sets the field 'bankRoutingNumber'.
   */
  public Developer setBankRoutingNumber(java.lang.String bankRoutingNumber) {
    return genClient.setOther(bankRoutingNumber, CacheKey.bankRoutingNumber);
  }

  /**
   * Sets the field 'businessLegalName'.
   */
  public Developer setBusinessLegalName(java.lang.String businessLegalName) {
    return genClient.setOther(businessLegalName, CacheKey.businessLegalName);
  }

  /**
   * Sets the field 'vatRegisterNumber'.
   */
  public Developer setVatRegisterNumber(java.lang.String vatRegisterNumber) {
    return genClient.setOther(vatRegisterNumber, CacheKey.vatRegisterNumber);
  }

  /**
   * Sets the field 'businessAddress'.
   */
  public Developer setBusinessAddress(java.lang.String businessAddress) {
    return genClient.setOther(businessAddress, CacheKey.businessAddress);
  }

  /**
   * Sets the field 'businessCity'.
   */
  public Developer setBusinessCity(java.lang.String businessCity) {
    return genClient.setOther(businessCity, CacheKey.businessCity);
  }

  /**
   * Sets the field 'businessState'.
   */
  public Developer setBusinessState(java.lang.String businessState) {
    return genClient.setOther(businessState, CacheKey.businessState);
  }

  /**
   * Sets the field 'businessCountry'.
   */
  public Developer setBusinessCountry(java.lang.String businessCountry) {
    return genClient.setOther(businessCountry, CacheKey.businessCountry);
  }

  /**
   * Sets the field 'businessPostalCode'.
   */
  public Developer setBusinessPostalCode(java.lang.String businessPostalCode) {
    return genClient.setOther(businessPostalCode, CacheKey.businessPostalCode);
  }

  /**
   * Sets the field 'billingStatus'.
   */
  public Developer setBillingStatus(com.clover.sdk.v3.developer.DeveloperBillingStatus billingStatus) {
    return genClient.setOther(billingStatus, CacheKey.billingStatus);
  }

  /**
   * Sets the field 'billingStatusMessage'.
   */
  public Developer setBillingStatusMessage(java.lang.String billingStatusMessage) {
    return genClient.setOther(billingStatusMessage, CacheKey.billingStatusMessage);
  }

  /**
   * Sets the field 'approvalStatus'.
   */
  public Developer setApprovalStatus(com.clover.sdk.v3.base.ApprovalStatus approvalStatus) {
    return genClient.setOther(approvalStatus, CacheKey.approvalStatus);
  }

  /**
   * Sets the field 'acceptedAgreement'.
   */
  public Developer setAcceptedAgreement(java.lang.Boolean acceptedAgreement) {
    return genClient.setOther(acceptedAgreement, CacheKey.acceptedAgreement);
  }

  /**
   * Sets the field 'prName'.
   */
  public Developer setPrName(java.lang.String prName) {
    return genClient.setOther(prName, CacheKey.prName);
  }

  /**
   * Sets the field 'prEmail'.
   */
  public Developer setPrEmail(java.lang.String prEmail) {
    return genClient.setOther(prEmail, CacheKey.prEmail);
  }

  /**
   * Sets the field 'prPhone'.
   */
  public Developer setPrPhone(java.lang.String prPhone) {
    return genClient.setOther(prPhone, CacheKey.prPhone);
  }

  /**
   * Sets the field 'website'.
   */
  public Developer setWebsite(java.lang.String website) {
    return genClient.setOther(website, CacheKey.website);
  }

  /**
   * Sets the field 'createdTime'.
   */
  public Developer setCreatedTime(java.lang.Long createdTime) {
    return genClient.setOther(createdTime, CacheKey.createdTime);
  }

  /**
   * Sets the field 'firstSubmittedTime'.
   */
  public Developer setFirstSubmittedTime(java.lang.Long firstSubmittedTime) {
    return genClient.setOther(firstSubmittedTime, CacheKey.firstSubmittedTime);
  }

  /**
   * Sets the field 'firstApprovalTime'.
   */
  public Developer setFirstApprovalTime(java.lang.Long firstApprovalTime) {
    return genClient.setOther(firstApprovalTime, CacheKey.firstApprovalTime);
  }

  /**
   * Sets the field 'modifiedTime'.
   */
  public Developer setModifiedTime(java.lang.Long modifiedTime) {
    return genClient.setOther(modifiedTime, CacheKey.modifiedTime);
  }

  /**
   * Sets the field 'owner'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public Developer setOwner(com.clover.sdk.v3.base.Reference owner) {
    return genClient.setRecord(owner, CacheKey.owner);
  }

  /**
   * Sets the field 'appBillingSystem'.
   */
  public Developer setAppBillingSystem(java.lang.String appBillingSystem) {
    return genClient.setOther(appBillingSystem, CacheKey.appBillingSystem);
  }

  /**
   * Sets the field 'infoleaseVendorCode'.
   */
  public Developer setInfoleaseVendorCode(java.lang.String infoleaseVendorCode) {
    return genClient.setOther(infoleaseVendorCode, CacheKey.infoleaseVendorCode);
  }

  /**
   * Sets the field 'infoleaseGlCode'.
   */
  public Developer setInfoleaseGlCode(java.lang.String infoleaseGlCode) {
    return genClient.setOther(infoleaseGlCode, CacheKey.infoleaseGlCode);
  }

  /**
   * Sets the field 'revShare'.
   */
  public Developer setRevShare(java.lang.Integer revShare) {
    return genClient.setOther(revShare, CacheKey.revShare);
  }

  /**
   * Sets the field 'isRevShareFlatRate'.
   */
  public Developer setIsRevShareFlatRate(java.lang.Boolean isRevShareFlatRate) {
    return genClient.setOther(isRevShareFlatRate, CacheKey.isRevShareFlatRate);
  }

  /**
   * Sets the field 'revShareEffectiveTime'.
   */
  public Developer setRevShareEffectiveTime(java.lang.Long revShareEffectiveTime) {
    return genClient.setOther(revShareEffectiveTime, CacheKey.revShareEffectiveTime);
  }

  /**
   * Sets the field 'signorName'.
   */
  public Developer setSignorName(java.lang.String signorName) {
    return genClient.setOther(signorName, CacheKey.signorName);
  }

  /**
   * Sets the field 'signorTitle'.
   */
  public Developer setSignorTitle(java.lang.String signorTitle) {
    return genClient.setOther(signorTitle, CacheKey.signorTitle);
  }

  /**
   * Sets the field 'referralSubmissionTime'.
   */
  public Developer setReferralSubmissionTime(java.lang.Long referralSubmissionTime) {
    return genClient.setOther(referralSubmissionTime, CacheKey.referralSubmissionTime);
  }

  /**
   * Sets the field 'emergencyEmail'.
   */
  public Developer setEmergencyEmail(java.lang.String emergencyEmail) {
    return genClient.setOther(emergencyEmail, CacheKey.emergencyEmail);
  }

  /**
   * Sets the field 'collectionApprovalStatus'.
   */
  public Developer setCollectionApprovalStatus(com.clover.sdk.v3.developer.CollectionApprovalStatus collectionApprovalStatus) {
    return genClient.setOther(collectionApprovalStatus, CacheKey.collectionApprovalStatus);
  }

  /**
   * Sets the field 'isIsv'.
   */
  public Developer setIsIsv(java.lang.Boolean isIsv) {
    return genClient.setOther(isIsv, CacheKey.isIsv);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'firstName' field, the 'has' method for this field will now return false */
  public void clearFirstName() {
    genClient.clear(CacheKey.firstName);
  }
  /** Clears the 'lastName' field, the 'has' method for this field will now return false */
  public void clearLastName() {
    genClient.clear(CacheKey.lastName);
  }
  /** Clears the 'email' field, the 'has' method for this field will now return false */
  public void clearEmail() {
    genClient.clear(CacheKey.email);
  }
  /** Clears the 'phone' field, the 'has' method for this field will now return false */
  public void clearPhone() {
    genClient.clear(CacheKey.phone);
  }
  /** Clears the 'dob' field, the 'has' method for this field will now return false */
  public void clearDob() {
    genClient.clear(CacheKey.dob);
  }
  /** Clears the 'ssn' field, the 'has' method for this field will now return false */
  public void clearSsn() {
    genClient.clear(CacheKey.ssn);
  }
  /** Clears the 'address' field, the 'has' method for this field will now return false */
  public void clearAddress() {
    genClient.clear(CacheKey.address);
  }
  /** Clears the 'city' field, the 'has' method for this field will now return false */
  public void clearCity() {
    genClient.clear(CacheKey.city);
  }
  /** Clears the 'county' field, the 'has' method for this field will now return false */
  public void clearCounty() {
    genClient.clear(CacheKey.county);
  }
  /** Clears the 'state' field, the 'has' method for this field will now return false */
  public void clearState() {
    genClient.clear(CacheKey.state);
  }
  /** Clears the 'country' field, the 'has' method for this field will now return false */
  public void clearCountry() {
    genClient.clear(CacheKey.country);
  }
  /** Clears the 'postalCode' field, the 'has' method for this field will now return false */
  public void clearPostalCode() {
    genClient.clear(CacheKey.postalCode);
  }
  /** Clears the 'bankAccountNumber' field, the 'has' method for this field will now return false */
  public void clearBankAccountNumber() {
    genClient.clear(CacheKey.bankAccountNumber);
  }
  /** Clears the 'bankInfo' field, the 'has' method for this field will now return false */
  public void clearBankInfo() {
    genClient.clear(CacheKey.bankInfo);
  }
  /** Clears the 'bankRoutingNumber' field, the 'has' method for this field will now return false */
  public void clearBankRoutingNumber() {
    genClient.clear(CacheKey.bankRoutingNumber);
  }
  /** Clears the 'businessLegalName' field, the 'has' method for this field will now return false */
  public void clearBusinessLegalName() {
    genClient.clear(CacheKey.businessLegalName);
  }
  /** Clears the 'vatRegisterNumber' field, the 'has' method for this field will now return false */
  public void clearVatRegisterNumber() {
    genClient.clear(CacheKey.vatRegisterNumber);
  }
  /** Clears the 'businessAddress' field, the 'has' method for this field will now return false */
  public void clearBusinessAddress() {
    genClient.clear(CacheKey.businessAddress);
  }
  /** Clears the 'businessCity' field, the 'has' method for this field will now return false */
  public void clearBusinessCity() {
    genClient.clear(CacheKey.businessCity);
  }
  /** Clears the 'businessState' field, the 'has' method for this field will now return false */
  public void clearBusinessState() {
    genClient.clear(CacheKey.businessState);
  }
  /** Clears the 'businessCountry' field, the 'has' method for this field will now return false */
  public void clearBusinessCountry() {
    genClient.clear(CacheKey.businessCountry);
  }
  /** Clears the 'businessPostalCode' field, the 'has' method for this field will now return false */
  public void clearBusinessPostalCode() {
    genClient.clear(CacheKey.businessPostalCode);
  }
  /** Clears the 'billingStatus' field, the 'has' method for this field will now return false */
  public void clearBillingStatus() {
    genClient.clear(CacheKey.billingStatus);
  }
  /** Clears the 'billingStatusMessage' field, the 'has' method for this field will now return false */
  public void clearBillingStatusMessage() {
    genClient.clear(CacheKey.billingStatusMessage);
  }
  /** Clears the 'approvalStatus' field, the 'has' method for this field will now return false */
  public void clearApprovalStatus() {
    genClient.clear(CacheKey.approvalStatus);
  }
  /** Clears the 'acceptedAgreement' field, the 'has' method for this field will now return false */
  public void clearAcceptedAgreement() {
    genClient.clear(CacheKey.acceptedAgreement);
  }
  /** Clears the 'prName' field, the 'has' method for this field will now return false */
  public void clearPrName() {
    genClient.clear(CacheKey.prName);
  }
  /** Clears the 'prEmail' field, the 'has' method for this field will now return false */
  public void clearPrEmail() {
    genClient.clear(CacheKey.prEmail);
  }
  /** Clears the 'prPhone' field, the 'has' method for this field will now return false */
  public void clearPrPhone() {
    genClient.clear(CacheKey.prPhone);
  }
  /** Clears the 'website' field, the 'has' method for this field will now return false */
  public void clearWebsite() {
    genClient.clear(CacheKey.website);
  }
  /** Clears the 'createdTime' field, the 'has' method for this field will now return false */
  public void clearCreatedTime() {
    genClient.clear(CacheKey.createdTime);
  }
  /** Clears the 'firstSubmittedTime' field, the 'has' method for this field will now return false */
  public void clearFirstSubmittedTime() {
    genClient.clear(CacheKey.firstSubmittedTime);
  }
  /** Clears the 'firstApprovalTime' field, the 'has' method for this field will now return false */
  public void clearFirstApprovalTime() {
    genClient.clear(CacheKey.firstApprovalTime);
  }
  /** Clears the 'modifiedTime' field, the 'has' method for this field will now return false */
  public void clearModifiedTime() {
    genClient.clear(CacheKey.modifiedTime);
  }
  /** Clears the 'owner' field, the 'has' method for this field will now return false */
  public void clearOwner() {
    genClient.clear(CacheKey.owner);
  }
  /** Clears the 'appBillingSystem' field, the 'has' method for this field will now return false */
  public void clearAppBillingSystem() {
    genClient.clear(CacheKey.appBillingSystem);
  }
  /** Clears the 'infoleaseVendorCode' field, the 'has' method for this field will now return false */
  public void clearInfoleaseVendorCode() {
    genClient.clear(CacheKey.infoleaseVendorCode);
  }
  /** Clears the 'infoleaseGlCode' field, the 'has' method for this field will now return false */
  public void clearInfoleaseGlCode() {
    genClient.clear(CacheKey.infoleaseGlCode);
  }
  /** Clears the 'revShare' field, the 'has' method for this field will now return false */
  public void clearRevShare() {
    genClient.clear(CacheKey.revShare);
  }
  /** Clears the 'isRevShareFlatRate' field, the 'has' method for this field will now return false */
  public void clearIsRevShareFlatRate() {
    genClient.clear(CacheKey.isRevShareFlatRate);
  }
  /** Clears the 'revShareEffectiveTime' field, the 'has' method for this field will now return false */
  public void clearRevShareEffectiveTime() {
    genClient.clear(CacheKey.revShareEffectiveTime);
  }
  /** Clears the 'signorName' field, the 'has' method for this field will now return false */
  public void clearSignorName() {
    genClient.clear(CacheKey.signorName);
  }
  /** Clears the 'signorTitle' field, the 'has' method for this field will now return false */
  public void clearSignorTitle() {
    genClient.clear(CacheKey.signorTitle);
  }
  /** Clears the 'referralSubmissionTime' field, the 'has' method for this field will now return false */
  public void clearReferralSubmissionTime() {
    genClient.clear(CacheKey.referralSubmissionTime);
  }
  /** Clears the 'emergencyEmail' field, the 'has' method for this field will now return false */
  public void clearEmergencyEmail() {
    genClient.clear(CacheKey.emergencyEmail);
  }
  /** Clears the 'collectionApprovalStatus' field, the 'has' method for this field will now return false */
  public void clearCollectionApprovalStatus() {
    genClient.clear(CacheKey.collectionApprovalStatus);
  }
  /** Clears the 'isIsv' field, the 'has' method for this field will now return false */
  public void clearIsIsv() {
    genClient.clear(CacheKey.isIsv);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public Developer copyChanges() {
    Developer copy = new Developer();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(Developer src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new Developer(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<Developer> CREATOR = new android.os.Parcelable.Creator<Developer>() {
    @Override
    public Developer createFromParcel(android.os.Parcel in) {
      Developer instance = new Developer(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public Developer[] newArray(int size) {
      return new Developer[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<Developer> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<Developer>() {
    public Class<Developer> getCreatedClass() {
      return Developer.class;
    }

    @Override
    public Developer create(org.json.JSONObject jsonObject) {
      return new Developer(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final long NAME_MAX_LEN = 127;
    public static final boolean FIRSTNAME_IS_REQUIRED = false;
    public static final long FIRSTNAME_MAX_LEN = 127;
    public static final boolean LASTNAME_IS_REQUIRED = false;
    public static final long LASTNAME_MAX_LEN = 127;
    public static final boolean EMAIL_IS_REQUIRED = false;
    public static final long EMAIL_MAX_LEN = 127;
    public static final boolean PHONE_IS_REQUIRED = false;
    public static final long PHONE_MAX_LEN = 25;
    public static final boolean DOB_IS_REQUIRED = false;
    public static final long DOB_MAX_LEN = 10;
    public static final boolean SSN_IS_REQUIRED = false;
    public static final long SSN_MAX_LEN = 9;
    public static final boolean ADDRESS_IS_REQUIRED = false;
    public static final long ADDRESS_MAX_LEN = 255;
    public static final boolean CITY_IS_REQUIRED = false;
    public static final long CITY_MAX_LEN = 127;
    public static final boolean COUNTY_IS_REQUIRED = false;
    public static final long COUNTY_MAX_LEN = 127;
    public static final boolean STATE_IS_REQUIRED = false;
    public static final long STATE_MAX_LEN = 127;
    public static final boolean COUNTRY_IS_REQUIRED = false;
    public static final long COUNTRY_MAX_LEN = 2;
    public static final boolean POSTALCODE_IS_REQUIRED = false;
    public static final long POSTALCODE_MAX_LEN = 20;
    public static final boolean BANKACCOUNTNUMBER_IS_REQUIRED = false;
    public static final long BANKACCOUNTNUMBER_MAX_LEN = 34;
    public static final boolean BANKINFO_IS_REQUIRED = false;
    public static final boolean BANKROUTINGNUMBER_IS_REQUIRED = false;
    public static final long BANKROUTINGNUMBER_MAX_LEN = 40;
    public static final boolean BUSINESSLEGALNAME_IS_REQUIRED = false;
    public static final long BUSINESSLEGALNAME_MAX_LEN = 255;
    public static final boolean VATREGISTERNUMBER_IS_REQUIRED = false;
    public static final long VATREGISTERNUMBER_MAX_LEN = 127;
    public static final boolean BUSINESSADDRESS_IS_REQUIRED = false;
    public static final long BUSINESSADDRESS_MAX_LEN = 255;
    public static final boolean BUSINESSCITY_IS_REQUIRED = false;
    public static final long BUSINESSCITY_MAX_LEN = 127;
    public static final boolean BUSINESSSTATE_IS_REQUIRED = false;
    public static final long BUSINESSSTATE_MAX_LEN = 127;
    public static final boolean BUSINESSCOUNTRY_IS_REQUIRED = false;
    public static final long BUSINESSCOUNTRY_MAX_LEN = 2;
    public static final boolean BUSINESSPOSTALCODE_IS_REQUIRED = false;
    public static final long BUSINESSPOSTALCODE_MAX_LEN = 20;
    public static final boolean BILLINGSTATUS_IS_REQUIRED = false;
    public static final boolean BILLINGSTATUSMESSAGE_IS_REQUIRED = false;
    public static final long BILLINGSTATUSMESSAGE_MAX_LEN = 127;
    public static final boolean APPROVALSTATUS_IS_REQUIRED = false;
    public static final boolean ACCEPTEDAGREEMENT_IS_REQUIRED = false;
    public static final boolean PRNAME_IS_REQUIRED = false;
    public static final long PRNAME_MAX_LEN = 255;
    public static final boolean PREMAIL_IS_REQUIRED = false;
    public static final long PREMAIL_MAX_LEN = 127;
    public static final boolean PRPHONE_IS_REQUIRED = false;
    public static final long PRPHONE_MAX_LEN = 25;
    public static final boolean WEBSITE_IS_REQUIRED = false;
    public static final long WEBSITE_MAX_LEN = 255;
    public static final boolean CREATEDTIME_IS_REQUIRED = false;
    public static final boolean FIRSTSUBMITTEDTIME_IS_REQUIRED = false;
    public static final boolean FIRSTAPPROVALTIME_IS_REQUIRED = false;
    public static final boolean MODIFIEDTIME_IS_REQUIRED = false;
    public static final boolean OWNER_IS_REQUIRED = false;
    public static final boolean APPBILLINGSYSTEM_IS_REQUIRED = false;
    public static final long APPBILLINGSYSTEM_MAX_LEN = 10;
    public static final boolean INFOLEASEVENDORCODE_IS_REQUIRED = false;
    public static final long INFOLEASEVENDORCODE_MAX_LEN = 30;
    public static final boolean INFOLEASEGLCODE_IS_REQUIRED = false;
    public static final long INFOLEASEGLCODE_MAX_LEN = 10;
    public static final boolean REVSHARE_IS_REQUIRED = false;
    public static final boolean ISREVSHAREFLATRATE_IS_REQUIRED = false;
    public static final boolean REVSHAREEFFECTIVETIME_IS_REQUIRED = false;
    public static final boolean SIGNORNAME_IS_REQUIRED = false;
    public static final long SIGNORNAME_MAX_LEN = 127;
    public static final boolean SIGNORTITLE_IS_REQUIRED = false;
    public static final long SIGNORTITLE_MAX_LEN = 127;
    public static final boolean REFERRALSUBMISSIONTIME_IS_REQUIRED = false;
    public static final boolean EMERGENCYEMAIL_IS_REQUIRED = false;
    public static final long EMERGENCYEMAIL_MAX_LEN = 127;
    public static final boolean COLLECTIONAPPROVALSTATUS_IS_REQUIRED = false;
    public static final boolean ISISV_IS_REQUIRED = false;
  }

}
