/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */

/*
 * Copyright (C) 2019 Clover Network, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clover.sdk.v3.developer;

import com.clover.sdk.GenericClient;
import com.clover.sdk.GenericParcelable;

/**
 * This is an auto-generated Clover data object.
 * <p>
 * <h3>Fields</h3>
 * <ul>
 * <li>{@link #getId id}</li>
 * <li>{@link #getName name}</li>
 * <li>{@link #getLabel label}</li>
 * <li>{@link #getSystem system}</li>
 * <li>{@link #getTemplateRole templateRole}</li>
 * <li>{@link #getAccounts accounts}</li>
 * <li>{@link #getPermissions permissions}</li>
 * <li>{@link #getDeveloperRef developerRef}</li>
 * </ul>
 */
@SuppressWarnings("all")
public class DeveloperRole extends GenericParcelable implements com.clover.sdk.v3.Validator, com.clover.sdk.JSONifiable {

  public java.lang.String getId() {
    return genClient.cacheGet(CacheKey.id);
  }

  public java.lang.String getName() {
    return genClient.cacheGet(CacheKey.name);
  }

  public java.lang.String getLabel() {
    return genClient.cacheGet(CacheKey.label);
  }

  public java.lang.Boolean getSystem() {
    return genClient.cacheGet(CacheKey.system);
  }

  public com.clover.sdk.v3.base.Reference getTemplateRole() {
    return genClient.cacheGet(CacheKey.templateRole);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getAccounts() {
    return genClient.cacheGet(CacheKey.accounts);
  }

  public java.util.List<com.clover.sdk.v3.base.Reference> getPermissions() {
    return genClient.cacheGet(CacheKey.permissions);
  }

  public com.clover.sdk.v3.base.Reference getDeveloperRef() {
    return genClient.cacheGet(CacheKey.developerRef);
  }




  private enum CacheKey implements com.clover.sdk.ExtractionStrategyEnum {
    id
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    name
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    label
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.String.class)),
    system
        (com.clover.sdk.extractors.BasicExtractionStrategy.instance(java.lang.Boolean.class)),
    templateRole
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    accounts
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    permissions
        (com.clover.sdk.extractors.RecordListExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
    developerRef
        (com.clover.sdk.extractors.RecordExtractionStrategy.instance(com.clover.sdk.v3.base.Reference.JSON_CREATOR)),
      ;

    private final com.clover.sdk.extractors.ExtractionStrategy extractionStrategy;

    private CacheKey(com.clover.sdk.extractors.ExtractionStrategy s) {
      extractionStrategy = s;
    }

    @Override
    public com.clover.sdk.extractors.ExtractionStrategy getExtractionStrategy() {
      return extractionStrategy;
    }
  }

  private final GenericClient<DeveloperRole> genClient;

  /**
   * Constructs a new empty instance.
   */
  public DeveloperRole() {
    genClient = new GenericClient<DeveloperRole>(this);
  }

  @Override
  protected GenericClient getGenericClient() {
    return genClient;
  }

  /**
   * Constructs a new empty instance.
   */
  protected DeveloperRole(boolean noInit) {
    genClient = null;
  }

  /**
   * Constructs a new instance from the given JSON String.
   */
  public DeveloperRole(String json) throws IllegalArgumentException {
    this();
    genClient.initJsonObject(json);
  }

  /**
   * Construct a new instance backed by the given JSONObject, the parameter is not copied so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public DeveloperRole(org.json.JSONObject jsonObject) {
    this();
    genClient.setJsonObject(jsonObject);
  }

  /**
   * Constructs a new instance that is a deep copy of the source instance. It does not copy the bundle or changelog.
   */
  public DeveloperRole(DeveloperRole src) {
    this();
    if (src.genClient.getJsonObject() != null) {
      genClient.setJsonObject(com.clover.sdk.v3.JsonHelper.deepCopy(src.genClient.getJSONObject()));
    }
  }

  /**
   * Returns the internal JSONObject backing this instance, the return value is not a copy so changes to it will be
   * reflected in this instance and vice-versa.
   */
  public org.json.JSONObject getJSONObject() {
    return genClient.getJSONObject();
  }

  @Override
  public void validate() {
    genClient.validateCloverId(CacheKey.id, getId());

    genClient.validateLength(CacheKey.label, getLabel(), 127);
    genClient.validateReferences(CacheKey.templateRole);
    genClient.validateReferences(CacheKey.accounts);
    genClient.validateReferences(CacheKey.permissions);
    genClient.validateReferences(CacheKey.developerRef);
  }

  /** Checks whether the 'id' field is set and is not null */
  public boolean isNotNullId() {
    return genClient.cacheValueIsNotNull(CacheKey.id);
  }

  /** Checks whether the 'name' field is set and is not null */
  public boolean isNotNullName() {
    return genClient.cacheValueIsNotNull(CacheKey.name);
  }

  /** Checks whether the 'label' field is set and is not null */
  public boolean isNotNullLabel() {
    return genClient.cacheValueIsNotNull(CacheKey.label);
  }

  /** Checks whether the 'system' field is set and is not null */
  public boolean isNotNullSystem() {
    return genClient.cacheValueIsNotNull(CacheKey.system);
  }

  /** Checks whether the 'templateRole' field is set and is not null */
  public boolean isNotNullTemplateRole() {
    return genClient.cacheValueIsNotNull(CacheKey.templateRole);
  }

  /** Checks whether the 'accounts' field is set and is not null */
  public boolean isNotNullAccounts() {
    return genClient.cacheValueIsNotNull(CacheKey.accounts);
  }

  /** Checks whether the 'accounts' field is set and is not null and is not empty */
  public boolean isNotEmptyAccounts() { return isNotNullAccounts() && !getAccounts().isEmpty(); }

  /** Checks whether the 'permissions' field is set and is not null */
  public boolean isNotNullPermissions() {
    return genClient.cacheValueIsNotNull(CacheKey.permissions);
  }

  /** Checks whether the 'permissions' field is set and is not null and is not empty */
  public boolean isNotEmptyPermissions() { return isNotNullPermissions() && !getPermissions().isEmpty(); }

  /** Checks whether the 'developerRef' field is set and is not null */
  public boolean isNotNullDeveloperRef() {
    return genClient.cacheValueIsNotNull(CacheKey.developerRef);
  }



  /** Checks whether the 'id' field has been set, however the value could be null */
  public boolean hasId() {
    return genClient.cacheHasKey(CacheKey.id);
  }

  /** Checks whether the 'name' field has been set, however the value could be null */
  public boolean hasName() {
    return genClient.cacheHasKey(CacheKey.name);
  }

  /** Checks whether the 'label' field has been set, however the value could be null */
  public boolean hasLabel() {
    return genClient.cacheHasKey(CacheKey.label);
  }

  /** Checks whether the 'system' field has been set, however the value could be null */
  public boolean hasSystem() {
    return genClient.cacheHasKey(CacheKey.system);
  }

  /** Checks whether the 'templateRole' field has been set, however the value could be null */
  public boolean hasTemplateRole() {
    return genClient.cacheHasKey(CacheKey.templateRole);
  }

  /** Checks whether the 'accounts' field has been set, however the value could be null */
  public boolean hasAccounts() {
    return genClient.cacheHasKey(CacheKey.accounts);
  }

  /** Checks whether the 'permissions' field has been set, however the value could be null */
  public boolean hasPermissions() {
    return genClient.cacheHasKey(CacheKey.permissions);
  }

  /** Checks whether the 'developerRef' field has been set, however the value could be null */
  public boolean hasDeveloperRef() {
    return genClient.cacheHasKey(CacheKey.developerRef);
  }


  /**
   * Sets the field 'id'.
   */
  public DeveloperRole setId(java.lang.String id) {
    return genClient.setOther(id, CacheKey.id);
  }

  /**
   * Sets the field 'name'.
   */
  public DeveloperRole setName(java.lang.String name) {
    return genClient.setOther(name, CacheKey.name);
  }

  /**
   * Sets the field 'label'.
   */
  public DeveloperRole setLabel(java.lang.String label) {
    return genClient.setOther(label, CacheKey.label);
  }

  /**
   * Sets the field 'system'.
   */
  public DeveloperRole setSystem(java.lang.Boolean system) {
    return genClient.setOther(system, CacheKey.system);
  }

  /**
   * Sets the field 'templateRole'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeveloperRole setTemplateRole(com.clover.sdk.v3.base.Reference templateRole) {
    return genClient.setRecord(templateRole, CacheKey.templateRole);
  }

  /**
   * Sets the field 'accounts'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public DeveloperRole setAccounts(java.util.List<com.clover.sdk.v3.base.Reference> accounts) {
    return genClient.setArrayRecord(accounts, CacheKey.accounts);
  }

  /**
   * Sets the field 'permissions'.
   *
   * Nulls in the given List are skipped. List parameter is copied, so it will not reflect any changes, but objects inside it will.
   */
  public DeveloperRole setPermissions(java.util.List<com.clover.sdk.v3.base.Reference> permissions) {
    return genClient.setArrayRecord(permissions, CacheKey.permissions);
  }

  /**
   * Sets the field 'developerRef'.
   *
   * The parameter is not copied so changes to it will be reflected in this instance and vice-versa.
   */
  public DeveloperRole setDeveloperRef(com.clover.sdk.v3.base.Reference developerRef) {
    return genClient.setRecord(developerRef, CacheKey.developerRef);
  }


  /** Clears the 'id' field, the 'has' method for this field will now return false */
  public void clearId() {
    genClient.clear(CacheKey.id);
  }
  /** Clears the 'name' field, the 'has' method for this field will now return false */
  public void clearName() {
    genClient.clear(CacheKey.name);
  }
  /** Clears the 'label' field, the 'has' method for this field will now return false */
  public void clearLabel() {
    genClient.clear(CacheKey.label);
  }
  /** Clears the 'system' field, the 'has' method for this field will now return false */
  public void clearSystem() {
    genClient.clear(CacheKey.system);
  }
  /** Clears the 'templateRole' field, the 'has' method for this field will now return false */
  public void clearTemplateRole() {
    genClient.clear(CacheKey.templateRole);
  }
  /** Clears the 'accounts' field, the 'has' method for this field will now return false */
  public void clearAccounts() {
    genClient.clear(CacheKey.accounts);
  }
  /** Clears the 'permissions' field, the 'has' method for this field will now return false */
  public void clearPermissions() {
    genClient.clear(CacheKey.permissions);
  }
  /** Clears the 'developerRef' field, the 'has' method for this field will now return false */
  public void clearDeveloperRef() {
    genClient.clear(CacheKey.developerRef);
  }


  /**
   * Returns true if this instance has any changes.
   */
  public boolean containsChanges() {
    return genClient.containsChanges();
  }

  /**
   * Reset the log of changes made to this instance, calling copyChanges() after this would return an empty instance.
   */
  public void resetChangeLog() {
    genClient.resetChangeLog();
  }

  /**
   * Create a copy of this instance that contains only fields that were set after the constructor was called.
   */
  public DeveloperRole copyChanges() {
    DeveloperRole copy = new DeveloperRole();
    copy.mergeChanges(this);
    copy.resetChangeLog();
    return copy;
  }

  /**
   * Copy all the changed fields from the given source to this instance.
   */
  public void mergeChanges(DeveloperRole src) {
    if (src.genClient.getChangeLog() != null) {
      genClient.mergeChanges(new DeveloperRole(src).getJSONObject(), src.genClient);
    }
  }

  public static final android.os.Parcelable.Creator<DeveloperRole> CREATOR = new android.os.Parcelable.Creator<DeveloperRole>() {
    @Override
    public DeveloperRole createFromParcel(android.os.Parcel in) {
      DeveloperRole instance = new DeveloperRole(com.clover.sdk.v3.JsonParcelHelper.ObjectWrapper.CREATOR.createFromParcel(in).unwrap());
      instance.genClient.setBundle(in.readBundle(getClass().getClassLoader()));
      instance.genClient.setChangeLog(in.readBundle());
      return instance;
    }

    @Override
    public DeveloperRole[] newArray(int size) {
      return new DeveloperRole[size];
    }
  };

  public static final com.clover.sdk.JSONifiable.Creator<DeveloperRole> JSON_CREATOR = new com.clover.sdk.JSONifiable.Creator<DeveloperRole>() {
    public Class<DeveloperRole> getCreatedClass() {
      return DeveloperRole.class;
    }

    @Override
    public DeveloperRole create(org.json.JSONObject jsonObject) {
      return new DeveloperRole(jsonObject);
    }
  };

  public interface Constraints {
    public static final boolean ID_IS_REQUIRED = false;
    public static final long ID_MAX_LEN = 13;
    public static final boolean NAME_IS_REQUIRED = false;
    public static final boolean LABEL_IS_REQUIRED = false;
    public static final long LABEL_MAX_LEN = 127;
    public static final boolean SYSTEM_IS_REQUIRED = false;
    public static final boolean TEMPLATEROLE_IS_REQUIRED = false;
    public static final boolean ACCOUNTS_IS_REQUIRED = false;
    public static final boolean PERMISSIONS_IS_REQUIRED = false;
    public static final boolean DEVELOPERREF_IS_REQUIRED = false;
  }

}
